/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose&#64;example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya&#64;example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose&#64;example.com from DATA_READ logging, and aliya&#64;example.com from DATA_WRITE logging.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AuditConfig}
 */
public final class AuditConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AuditConfig)
    AuditConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuditConfig.newBuilder() to construct.
  private AuditConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuditConfig() {
    auditLogConfigs_ = java.util.Collections.emptyList();
    exemptedMembers_ = com.google.protobuf.LazyStringArrayList.emptyList();
    service_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuditConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AuditConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AuditConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AuditConfig.class,
            com.google.cloud.compute.v1.AuditConfig.Builder.class);
  }

  private int bitField0_;
  public static final int AUDIT_LOG_CONFIGS_FIELD_NUMBER = 488420626;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AuditLogConfig> auditLogConfigs_;
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AuditLogConfig> getAuditLogConfigsList() {
    return auditLogConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AuditLogConfigOrBuilder>
      getAuditLogConfigsOrBuilderList() {
    return auditLogConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
   */
  @java.lang.Override
  public int getAuditLogConfigsCount() {
    return auditLogConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AuditLogConfig getAuditLogConfigs(int index) {
    return auditLogConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AuditLogConfigOrBuilder getAuditLogConfigsOrBuilder(
      int index) {
    return auditLogConfigs_.get(index);
  }

  public static final int EXEMPTED_MEMBERS_FIELD_NUMBER = 232615576;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList exemptedMembers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated string exempted_members = 232615576;</code>
   *
   * @return A list containing the exemptedMembers.
   */
  public com.google.protobuf.ProtocolStringList getExemptedMembersList() {
    return exemptedMembers_;
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated string exempted_members = 232615576;</code>
   *
   * @return The count of exemptedMembers.
   */
  public int getExemptedMembersCount() {
    return exemptedMembers_.size();
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated string exempted_members = 232615576;</code>
   *
   * @param index The index of the element to return.
   * @return The exemptedMembers at the given index.
   */
  public java.lang.String getExemptedMembers(int index) {
    return exemptedMembers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated string exempted_members = 232615576;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the exemptedMembers at the given index.
   */
  public com.google.protobuf.ByteString getExemptedMembersBytes(int index) {
    return exemptedMembers_.getByteString(index);
  }

  public static final int SERVICE_FIELD_NUMBER = 373540533;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return Whether the service field is set.
   */
  @java.lang.Override
  public boolean hasService() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < exemptedMembers_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 232615576, exemptedMembers_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 373540533, service_);
    }
    for (int i = 0; i < auditLogConfigs_.size(); i++) {
      output.writeMessage(488420626, auditLogConfigs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < exemptedMembers_.size(); i++) {
        dataSize += computeStringSizeNoTag(exemptedMembers_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getExemptedMembersList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(373540533, service_);
    }
    for (int i = 0; i < auditLogConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              488420626, auditLogConfigs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AuditConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AuditConfig other = (com.google.cloud.compute.v1.AuditConfig) obj;

    if (!getAuditLogConfigsList().equals(other.getAuditLogConfigsList())) return false;
    if (!getExemptedMembersList().equals(other.getExemptedMembersList())) return false;
    if (hasService() != other.hasService()) return false;
    if (hasService()) {
      if (!getService().equals(other.getService())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAuditLogConfigsCount() > 0) {
      hash = (37 * hash) + AUDIT_LOG_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAuditLogConfigsList().hashCode();
    }
    if (getExemptedMembersCount() > 0) {
      hash = (37 * hash) + EXEMPTED_MEMBERS_FIELD_NUMBER;
      hash = (53 * hash) + getExemptedMembersList().hashCode();
    }
    if (hasService()) {
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AuditConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.AuditConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose&#64;example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya&#64;example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose&#64;example.com from DATA_READ logging, and aliya&#64;example.com from DATA_WRITE logging.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AuditConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AuditConfig)
      com.google.cloud.compute.v1.AuditConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AuditConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AuditConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AuditConfig.class,
              com.google.cloud.compute.v1.AuditConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AuditConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (auditLogConfigsBuilder_ == null) {
        auditLogConfigs_ = java.util.Collections.emptyList();
      } else {
        auditLogConfigs_ = null;
        auditLogConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      exemptedMembers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      service_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AuditConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AuditConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AuditConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AuditConfig build() {
      com.google.cloud.compute.v1.AuditConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AuditConfig buildPartial() {
      com.google.cloud.compute.v1.AuditConfig result =
          new com.google.cloud.compute.v1.AuditConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.AuditConfig result) {
      if (auditLogConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          auditLogConfigs_ = java.util.Collections.unmodifiableList(auditLogConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.auditLogConfigs_ = auditLogConfigs_;
      } else {
        result.auditLogConfigs_ = auditLogConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.AuditConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        exemptedMembers_.makeImmutable();
        result.exemptedMembers_ = exemptedMembers_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.service_ = service_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AuditConfig) {
        return mergeFrom((com.google.cloud.compute.v1.AuditConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AuditConfig other) {
      if (other == com.google.cloud.compute.v1.AuditConfig.getDefaultInstance()) return this;
      if (auditLogConfigsBuilder_ == null) {
        if (!other.auditLogConfigs_.isEmpty()) {
          if (auditLogConfigs_.isEmpty()) {
            auditLogConfigs_ = other.auditLogConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAuditLogConfigsIsMutable();
            auditLogConfigs_.addAll(other.auditLogConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.auditLogConfigs_.isEmpty()) {
          if (auditLogConfigsBuilder_.isEmpty()) {
            auditLogConfigsBuilder_.dispose();
            auditLogConfigsBuilder_ = null;
            auditLogConfigs_ = other.auditLogConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            auditLogConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAuditLogConfigsFieldBuilder()
                    : null;
          } else {
            auditLogConfigsBuilder_.addAllMessages(other.auditLogConfigs_);
          }
        }
      }
      if (!other.exemptedMembers_.isEmpty()) {
        if (exemptedMembers_.isEmpty()) {
          exemptedMembers_ = other.exemptedMembers_;
          bitField0_ |= 0x00000002;
        } else {
          ensureExemptedMembersIsMutable();
          exemptedMembers_.addAll(other.exemptedMembers_);
        }
        onChanged();
      }
      if (other.hasService()) {
        service_ = other.service_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1860924610:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExemptedMembersIsMutable();
                exemptedMembers_.add(s);
                break;
              } // case 1860924610
            case -1306643030:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -1306643030
            case -387602286:
              {
                com.google.cloud.compute.v1.AuditLogConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AuditLogConfig.parser(), extensionRegistry);
                if (auditLogConfigsBuilder_ == null) {
                  ensureAuditLogConfigsIsMutable();
                  auditLogConfigs_.add(m);
                } else {
                  auditLogConfigsBuilder_.addMessage(m);
                }
                break;
              } // case -387602286
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.AuditLogConfig> auditLogConfigs_ =
        java.util.Collections.emptyList();

    private void ensureAuditLogConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        auditLogConfigs_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AuditLogConfig>(auditLogConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AuditLogConfig,
            com.google.cloud.compute.v1.AuditLogConfig.Builder,
            com.google.cloud.compute.v1.AuditLogConfigOrBuilder>
        auditLogConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AuditLogConfig> getAuditLogConfigsList() {
      if (auditLogConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(auditLogConfigs_);
      } else {
        return auditLogConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public int getAuditLogConfigsCount() {
      if (auditLogConfigsBuilder_ == null) {
        return auditLogConfigs_.size();
      } else {
        return auditLogConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public com.google.cloud.compute.v1.AuditLogConfig getAuditLogConfigs(int index) {
      if (auditLogConfigsBuilder_ == null) {
        return auditLogConfigs_.get(index);
      } else {
        return auditLogConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder setAuditLogConfigs(int index, com.google.cloud.compute.v1.AuditLogConfig value) {
      if (auditLogConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.set(index, value);
        onChanged();
      } else {
        auditLogConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder setAuditLogConfigs(
        int index, com.google.cloud.compute.v1.AuditLogConfig.Builder builderForValue) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        auditLogConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder addAuditLogConfigs(com.google.cloud.compute.v1.AuditLogConfig value) {
      if (auditLogConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(value);
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder addAuditLogConfigs(int index, com.google.cloud.compute.v1.AuditLogConfig value) {
      if (auditLogConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(index, value);
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder addAuditLogConfigs(
        com.google.cloud.compute.v1.AuditLogConfig.Builder builderForValue) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder addAuditLogConfigs(
        int index, com.google.cloud.compute.v1.AuditLogConfig.Builder builderForValue) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder addAllAuditLogConfigs(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AuditLogConfig> values) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, auditLogConfigs_);
        onChanged();
      } else {
        auditLogConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder clearAuditLogConfigs() {
      if (auditLogConfigsBuilder_ == null) {
        auditLogConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        auditLogConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public Builder removeAuditLogConfigs(int index) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.remove(index);
        onChanged();
      } else {
        auditLogConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public com.google.cloud.compute.v1.AuditLogConfig.Builder getAuditLogConfigsBuilder(int index) {
      return getAuditLogConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public com.google.cloud.compute.v1.AuditLogConfigOrBuilder getAuditLogConfigsOrBuilder(
        int index) {
      if (auditLogConfigsBuilder_ == null) {
        return auditLogConfigs_.get(index);
      } else {
        return auditLogConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AuditLogConfigOrBuilder>
        getAuditLogConfigsOrBuilderList() {
      if (auditLogConfigsBuilder_ != null) {
        return auditLogConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(auditLogConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public com.google.cloud.compute.v1.AuditLogConfig.Builder addAuditLogConfigsBuilder() {
      return getAuditLogConfigsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AuditLogConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public com.google.cloud.compute.v1.AuditLogConfig.Builder addAuditLogConfigsBuilder(int index) {
      return getAuditLogConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AuditLogConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditLogConfig audit_log_configs = 488420626;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AuditLogConfig.Builder>
        getAuditLogConfigsBuilderList() {
      return getAuditLogConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AuditLogConfig,
            com.google.cloud.compute.v1.AuditLogConfig.Builder,
            com.google.cloud.compute.v1.AuditLogConfigOrBuilder>
        getAuditLogConfigsFieldBuilder() {
      if (auditLogConfigsBuilder_ == null) {
        auditLogConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AuditLogConfig,
                com.google.cloud.compute.v1.AuditLogConfig.Builder,
                com.google.cloud.compute.v1.AuditLogConfigOrBuilder>(
                auditLogConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        auditLogConfigs_ = null;
      }
      return auditLogConfigsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList exemptedMembers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExemptedMembersIsMutable() {
      if (!exemptedMembers_.isModifiable()) {
        exemptedMembers_ = new com.google.protobuf.LazyStringArrayList(exemptedMembers_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @return A list containing the exemptedMembers.
     */
    public com.google.protobuf.ProtocolStringList getExemptedMembersList() {
      exemptedMembers_.makeImmutable();
      return exemptedMembers_;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @return The count of exemptedMembers.
     */
    public int getExemptedMembersCount() {
      return exemptedMembers_.size();
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @param index The index of the element to return.
     * @return The exemptedMembers at the given index.
     */
    public java.lang.String getExemptedMembers(int index) {
      return exemptedMembers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exemptedMembers at the given index.
     */
    public com.google.protobuf.ByteString getExemptedMembersBytes(int index) {
      return exemptedMembers_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @param index The index to set the value at.
     * @param value The exemptedMembers to set.
     * @return This builder for chaining.
     */
    public Builder setExemptedMembers(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExemptedMembersIsMutable();
      exemptedMembers_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @param value The exemptedMembers to add.
     * @return This builder for chaining.
     */
    public Builder addExemptedMembers(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExemptedMembersIsMutable();
      exemptedMembers_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @param values The exemptedMembers to add.
     * @return This builder for chaining.
     */
    public Builder addAllExemptedMembers(java.lang.Iterable<java.lang.String> values) {
      ensureExemptedMembersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exemptedMembers_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExemptedMembers() {
      exemptedMembers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated string exempted_members = 232615576;</code>
     *
     * @param value The bytes of the exemptedMembers to add.
     * @return This builder for chaining.
     */
    public Builder addExemptedMembersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExemptedMembersIsMutable();
      exemptedMembers_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return Whether the service field is set.
     */
    public boolean hasService() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AuditConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AuditConfig)
  private static final com.google.cloud.compute.v1.AuditConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AuditConfig();
  }

  public static com.google.cloud.compute.v1.AuditConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuditConfig> PARSER =
      new com.google.protobuf.AbstractParser<AuditConfig>() {
        @java.lang.Override
        public AuditConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuditConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuditConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AuditConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
