/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Next free: 15
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BfdStatus}
 */
public final class BfdStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BfdStatus)
    BfdStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BfdStatus.newBuilder() to construct.
  private BfdStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BfdStatus() {
    bfdSessionInitializationMode_ = "";
    controlPacketIntervals_ = java.util.Collections.emptyList();
    localDiagnostic_ = "";
    localState_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BfdStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BfdStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BfdStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BfdStatus.class,
            com.google.cloud.compute.v1.BfdStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BfdStatus.BfdSessionInitializationMode}
   */
  public enum BfdSessionInitializationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BFD_SESSION_INITIALIZATION_MODE = 0;</code>
     */
    UNDEFINED_BFD_SESSION_INITIALIZATION_MODE(0),
    /** <code>ACTIVE = 314733318;</code> */
    ACTIVE(314733318),
    /** <code>DISABLED = 516696700;</code> */
    DISABLED(516696700),
    /** <code>PASSIVE = 462813959;</code> */
    PASSIVE(462813959),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BFD_SESSION_INITIALIZATION_MODE = 0;</code>
     */
    public static final int UNDEFINED_BFD_SESSION_INITIALIZATION_MODE_VALUE = 0;
    /** <code>ACTIVE = 314733318;</code> */
    public static final int ACTIVE_VALUE = 314733318;
    /** <code>DISABLED = 516696700;</code> */
    public static final int DISABLED_VALUE = 516696700;
    /** <code>PASSIVE = 462813959;</code> */
    public static final int PASSIVE_VALUE = 462813959;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BfdSessionInitializationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BfdSessionInitializationMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BFD_SESSION_INITIALIZATION_MODE;
        case 314733318:
          return ACTIVE;
        case 516696700:
          return DISABLED;
        case 462813959:
          return PASSIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BfdSessionInitializationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BfdSessionInitializationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<BfdSessionInitializationMode>() {
              public BfdSessionInitializationMode findValueByNumber(int number) {
                return BfdSessionInitializationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BfdStatus.getDescriptor().getEnumTypes().get(0);
    }

    private static final BfdSessionInitializationMode[] VALUES = values();

    public static BfdSessionInitializationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BfdSessionInitializationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BfdStatus.BfdSessionInitializationMode)
  }

  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BfdStatus.LocalDiagnostic}
   */
  public enum LocalDiagnostic implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOCAL_DIAGNOSTIC = 0;</code>
     */
    UNDEFINED_LOCAL_DIAGNOSTIC(0),
    /** <code>ADMINISTRATIVELY_DOWN = 121685798;</code> */
    ADMINISTRATIVELY_DOWN(121685798),
    /** <code>CONCATENATED_PATH_DOWN = 26186892;</code> */
    CONCATENATED_PATH_DOWN(26186892),
    /** <code>CONTROL_DETECTION_TIME_EXPIRED = 135478383;</code> */
    CONTROL_DETECTION_TIME_EXPIRED(135478383),
    /** <code>DIAGNOSTIC_UNSPECIFIED = 58720895;</code> */
    DIAGNOSTIC_UNSPECIFIED(58720895),
    /** <code>ECHO_FUNCTION_FAILED = 220687466;</code> */
    ECHO_FUNCTION_FAILED(220687466),
    /** <code>FORWARDING_PLANE_RESET = 19715882;</code> */
    FORWARDING_PLANE_RESET(19715882),
    /** <code>NEIGHBOR_SIGNALED_SESSION_DOWN = 374226742;</code> */
    NEIGHBOR_SIGNALED_SESSION_DOWN(374226742),
    /** <code>NO_DIAGNOSTIC = 222503141;</code> */
    NO_DIAGNOSTIC(222503141),
    /** <code>PATH_DOWN = 290605180;</code> */
    PATH_DOWN(290605180),
    /** <code>REVERSE_CONCATENATED_PATH_DOWN = 479337129;</code> */
    REVERSE_CONCATENATED_PATH_DOWN(479337129),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOCAL_DIAGNOSTIC = 0;</code>
     */
    public static final int UNDEFINED_LOCAL_DIAGNOSTIC_VALUE = 0;
    /** <code>ADMINISTRATIVELY_DOWN = 121685798;</code> */
    public static final int ADMINISTRATIVELY_DOWN_VALUE = 121685798;
    /** <code>CONCATENATED_PATH_DOWN = 26186892;</code> */
    public static final int CONCATENATED_PATH_DOWN_VALUE = 26186892;
    /** <code>CONTROL_DETECTION_TIME_EXPIRED = 135478383;</code> */
    public static final int CONTROL_DETECTION_TIME_EXPIRED_VALUE = 135478383;
    /** <code>DIAGNOSTIC_UNSPECIFIED = 58720895;</code> */
    public static final int DIAGNOSTIC_UNSPECIFIED_VALUE = 58720895;
    /** <code>ECHO_FUNCTION_FAILED = 220687466;</code> */
    public static final int ECHO_FUNCTION_FAILED_VALUE = 220687466;
    /** <code>FORWARDING_PLANE_RESET = 19715882;</code> */
    public static final int FORWARDING_PLANE_RESET_VALUE = 19715882;
    /** <code>NEIGHBOR_SIGNALED_SESSION_DOWN = 374226742;</code> */
    public static final int NEIGHBOR_SIGNALED_SESSION_DOWN_VALUE = 374226742;
    /** <code>NO_DIAGNOSTIC = 222503141;</code> */
    public static final int NO_DIAGNOSTIC_VALUE = 222503141;
    /** <code>PATH_DOWN = 290605180;</code> */
    public static final int PATH_DOWN_VALUE = 290605180;
    /** <code>REVERSE_CONCATENATED_PATH_DOWN = 479337129;</code> */
    public static final int REVERSE_CONCATENATED_PATH_DOWN_VALUE = 479337129;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LocalDiagnostic valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LocalDiagnostic forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LOCAL_DIAGNOSTIC;
        case 121685798:
          return ADMINISTRATIVELY_DOWN;
        case 26186892:
          return CONCATENATED_PATH_DOWN;
        case 135478383:
          return CONTROL_DETECTION_TIME_EXPIRED;
        case 58720895:
          return DIAGNOSTIC_UNSPECIFIED;
        case 220687466:
          return ECHO_FUNCTION_FAILED;
        case 19715882:
          return FORWARDING_PLANE_RESET;
        case 374226742:
          return NEIGHBOR_SIGNALED_SESSION_DOWN;
        case 222503141:
          return NO_DIAGNOSTIC;
        case 290605180:
          return PATH_DOWN;
        case 479337129:
          return REVERSE_CONCATENATED_PATH_DOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LocalDiagnostic> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LocalDiagnostic>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LocalDiagnostic>() {
              public LocalDiagnostic findValueByNumber(int number) {
                return LocalDiagnostic.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BfdStatus.getDescriptor().getEnumTypes().get(1);
    }

    private static final LocalDiagnostic[] VALUES = values();

    public static LocalDiagnostic valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LocalDiagnostic(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BfdStatus.LocalDiagnostic)
  }

  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BfdStatus.LocalState}
   */
  public enum LocalState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOCAL_STATE = 0;</code>
     */
    UNDEFINED_LOCAL_STATE(0),
    /** <code>ADMIN_DOWN = 128544690;</code> */
    ADMIN_DOWN(128544690),
    /** <code>DOWN = 2104482;</code> */
    DOWN(2104482),
    /** <code>INIT = 2252048;</code> */
    INIT(2252048),
    /** <code>STATE_UNSPECIFIED = 470755401;</code> */
    STATE_UNSPECIFIED(470755401),
    /** <code>UP = 2715;</code> */
    UP(2715),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOCAL_STATE = 0;</code>
     */
    public static final int UNDEFINED_LOCAL_STATE_VALUE = 0;
    /** <code>ADMIN_DOWN = 128544690;</code> */
    public static final int ADMIN_DOWN_VALUE = 128544690;
    /** <code>DOWN = 2104482;</code> */
    public static final int DOWN_VALUE = 2104482;
    /** <code>INIT = 2252048;</code> */
    public static final int INIT_VALUE = 2252048;
    /** <code>STATE_UNSPECIFIED = 470755401;</code> */
    public static final int STATE_UNSPECIFIED_VALUE = 470755401;
    /** <code>UP = 2715;</code> */
    public static final int UP_VALUE = 2715;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LocalState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LocalState forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LOCAL_STATE;
        case 128544690:
          return ADMIN_DOWN;
        case 2104482:
          return DOWN;
        case 2252048:
          return INIT;
        case 470755401:
          return STATE_UNSPECIFIED;
        case 2715:
          return UP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LocalState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LocalState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LocalState>() {
          public LocalState findValueByNumber(int number) {
            return LocalState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BfdStatus.getDescriptor().getEnumTypes().get(2);
    }

    private static final LocalState[] VALUES = values();

    public static LocalState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LocalState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BfdStatus.LocalState)
  }

  private int bitField0_;
  public static final int BFD_SESSION_INITIALIZATION_MODE_FIELD_NUMBER = 218156954;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bfdSessionInitializationMode_ = "";
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * Check the BfdSessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bfd_session_initialization_mode = 218156954;</code>
   *
   * @return Whether the bfdSessionInitializationMode field is set.
   */
  @java.lang.Override
  public boolean hasBfdSessionInitializationMode() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * Check the BfdSessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bfd_session_initialization_mode = 218156954;</code>
   *
   * @return The bfdSessionInitializationMode.
   */
  @java.lang.Override
  public java.lang.String getBfdSessionInitializationMode() {
    java.lang.Object ref = bfdSessionInitializationMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bfdSessionInitializationMode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * Check the BfdSessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bfd_session_initialization_mode = 218156954;</code>
   *
   * @return The bytes for bfdSessionInitializationMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBfdSessionInitializationModeBytes() {
    java.lang.Object ref = bfdSessionInitializationMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bfdSessionInitializationMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_UPDATE_TIMESTAMP_MICROS_FIELD_NUMBER = 457195569;
  private long configUpdateTimestampMicros_ = 0L;
  /**
   *
   *
   * <pre>
   * Unix timestamp of the most recent config update.
   * </pre>
   *
   * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
   *
   * @return Whether the configUpdateTimestampMicros field is set.
   */
  @java.lang.Override
  public boolean hasConfigUpdateTimestampMicros() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Unix timestamp of the most recent config update.
   * </pre>
   *
   * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
   *
   * @return The configUpdateTimestampMicros.
   */
  @java.lang.Override
  public long getConfigUpdateTimestampMicros() {
    return configUpdateTimestampMicros_;
  }

  public static final int CONTROL_PACKET_COUNTS_FIELD_NUMBER = 132573561;
  private com.google.cloud.compute.v1.BfdStatusPacketCounts controlPacketCounts_;
  /**
   *
   *
   * <pre>
   * Control packet counts for the current BFD session.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
   * </code>
   *
   * @return Whether the controlPacketCounts field is set.
   */
  @java.lang.Override
  public boolean hasControlPacketCounts() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Control packet counts for the current BFD session.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
   * </code>
   *
   * @return The controlPacketCounts.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdStatusPacketCounts getControlPacketCounts() {
    return controlPacketCounts_ == null
        ? com.google.cloud.compute.v1.BfdStatusPacketCounts.getDefaultInstance()
        : controlPacketCounts_;
  }
  /**
   *
   *
   * <pre>
   * Control packet counts for the current BFD session.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdStatusPacketCountsOrBuilder
      getControlPacketCountsOrBuilder() {
    return controlPacketCounts_ == null
        ? com.google.cloud.compute.v1.BfdStatusPacketCounts.getDefaultInstance()
        : controlPacketCounts_;
  }

  public static final int CONTROL_PACKET_INTERVALS_FIELD_NUMBER = 500806649;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.PacketIntervals> controlPacketIntervals_;
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PacketIntervals>
      getControlPacketIntervalsList() {
    return controlPacketIntervals_;
  }
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.PacketIntervalsOrBuilder>
      getControlPacketIntervalsOrBuilderList() {
    return controlPacketIntervals_;
  }
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  @java.lang.Override
  public int getControlPacketIntervalsCount() {
    return controlPacketIntervals_.size();
  }
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PacketIntervals getControlPacketIntervals(int index) {
    return controlPacketIntervals_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PacketIntervalsOrBuilder getControlPacketIntervalsOrBuilder(
      int index) {
    return controlPacketIntervals_.get(index);
  }

  public static final int LOCAL_DIAGNOSTIC_FIELD_NUMBER = 463737083;

  @SuppressWarnings("serial")
  private volatile java.lang.Object localDiagnostic_ = "";
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the LocalDiagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_diagnostic = 463737083;</code>
   *
   * @return Whether the localDiagnostic field is set.
   */
  @java.lang.Override
  public boolean hasLocalDiagnostic() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the LocalDiagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_diagnostic = 463737083;</code>
   *
   * @return The localDiagnostic.
   */
  @java.lang.Override
  public java.lang.String getLocalDiagnostic() {
    java.lang.Object ref = localDiagnostic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      localDiagnostic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the LocalDiagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_diagnostic = 463737083;</code>
   *
   * @return The bytes for localDiagnostic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocalDiagnosticBytes() {
    java.lang.Object ref = localDiagnostic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      localDiagnostic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_STATE_FIELD_NUMBER = 149195453;

  @SuppressWarnings("serial")
  private volatile java.lang.Object localState_ = "";
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the LocalState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_state = 149195453;</code>
   *
   * @return Whether the localState field is set.
   */
  @java.lang.Override
  public boolean hasLocalState() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the LocalState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_state = 149195453;</code>
   *
   * @return The localState.
   */
  @java.lang.Override
  public java.lang.String getLocalState() {
    java.lang.Object ref = localState_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      localState_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the LocalState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_state = 149195453;</code>
   *
   * @return The bytes for localState.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocalStateBytes() {
    java.lang.Object ref = localState_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      localState_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEGOTIATED_LOCAL_CONTROL_TX_INTERVAL_MS_FIELD_NUMBER = 21768340;
  private int negotiatedLocalControlTxIntervalMs_ = 0;
  /**
   *
   *
   * <pre>
   * Negotiated transmit interval for control packets.
   * </pre>
   *
   * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
   *
   * @return Whether the negotiatedLocalControlTxIntervalMs field is set.
   */
  @java.lang.Override
  public boolean hasNegotiatedLocalControlTxIntervalMs() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Negotiated transmit interval for control packets.
   * </pre>
   *
   * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
   *
   * @return The negotiatedLocalControlTxIntervalMs.
   */
  @java.lang.Override
  public int getNegotiatedLocalControlTxIntervalMs() {
    return negotiatedLocalControlTxIntervalMs_;
  }

  public static final int RX_PACKET_FIELD_NUMBER = 505069729;
  private com.google.cloud.compute.v1.BfdPacket rxPacket_;
  /**
   *
   *
   * <pre>
   * The most recent Rx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
   *
   * @return Whether the rxPacket field is set.
   */
  @java.lang.Override
  public boolean hasRxPacket() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The most recent Rx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
   *
   * @return The rxPacket.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdPacket getRxPacket() {
    return rxPacket_ == null
        ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
        : rxPacket_;
  }
  /**
   *
   *
   * <pre>
   * The most recent Rx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdPacketOrBuilder getRxPacketOrBuilder() {
    return rxPacket_ == null
        ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
        : rxPacket_;
  }

  public static final int TX_PACKET_FIELD_NUMBER = 111386275;
  private com.google.cloud.compute.v1.BfdPacket txPacket_;
  /**
   *
   *
   * <pre>
   * The most recent Tx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
   *
   * @return Whether the txPacket field is set.
   */
  @java.lang.Override
  public boolean hasTxPacket() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The most recent Tx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
   *
   * @return The txPacket.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdPacket getTxPacket() {
    return txPacket_ == null
        ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
        : txPacket_;
  }
  /**
   *
   *
   * <pre>
   * The most recent Tx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BfdPacketOrBuilder getTxPacketOrBuilder() {
    return txPacket_ == null
        ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
        : txPacket_;
  }

  public static final int UPTIME_MS_FIELD_NUMBER = 125398365;
  private long uptimeMs_ = 0L;
  /**
   *
   *
   * <pre>
   * Session uptime in milliseconds. Value will be 0 if session is not up.
   * </pre>
   *
   * <code>optional int64 uptime_ms = 125398365;</code>
   *
   * @return Whether the uptimeMs field is set.
   */
  @java.lang.Override
  public boolean hasUptimeMs() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Session uptime in milliseconds. Value will be 0 if session is not up.
   * </pre>
   *
   * <code>optional int64 uptime_ms = 125398365;</code>
   *
   * @return The uptimeMs.
   */
  @java.lang.Override
  public long getUptimeMs() {
    return uptimeMs_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt32(21768340, negotiatedLocalControlTxIntervalMs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(111386275, getTxPacket());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt64(125398365, uptimeMs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(132573561, getControlPacketCounts());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 149195453, localState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 218156954, bfdSessionInitializationMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(457195569, configUpdateTimestampMicros_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 463737083, localDiagnostic_);
    }
    for (int i = 0; i < controlPacketIntervals_.size(); i++) {
      output.writeMessage(500806649, controlPacketIntervals_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(505069729, getRxPacket());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(
              21768340, negotiatedLocalControlTxIntervalMs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(111386275, getTxPacket());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(125398365, uptimeMs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              132573561, getControlPacketCounts());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(149195453, localState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              218156954, bfdSessionInitializationMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              457195569, configUpdateTimestampMicros_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(463737083, localDiagnostic_);
    }
    for (int i = 0; i < controlPacketIntervals_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              500806649, controlPacketIntervals_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(505069729, getRxPacket());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BfdStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BfdStatus other = (com.google.cloud.compute.v1.BfdStatus) obj;

    if (hasBfdSessionInitializationMode() != other.hasBfdSessionInitializationMode()) return false;
    if (hasBfdSessionInitializationMode()) {
      if (!getBfdSessionInitializationMode().equals(other.getBfdSessionInitializationMode()))
        return false;
    }
    if (hasConfigUpdateTimestampMicros() != other.hasConfigUpdateTimestampMicros()) return false;
    if (hasConfigUpdateTimestampMicros()) {
      if (getConfigUpdateTimestampMicros() != other.getConfigUpdateTimestampMicros()) return false;
    }
    if (hasControlPacketCounts() != other.hasControlPacketCounts()) return false;
    if (hasControlPacketCounts()) {
      if (!getControlPacketCounts().equals(other.getControlPacketCounts())) return false;
    }
    if (!getControlPacketIntervalsList().equals(other.getControlPacketIntervalsList()))
      return false;
    if (hasLocalDiagnostic() != other.hasLocalDiagnostic()) return false;
    if (hasLocalDiagnostic()) {
      if (!getLocalDiagnostic().equals(other.getLocalDiagnostic())) return false;
    }
    if (hasLocalState() != other.hasLocalState()) return false;
    if (hasLocalState()) {
      if (!getLocalState().equals(other.getLocalState())) return false;
    }
    if (hasNegotiatedLocalControlTxIntervalMs() != other.hasNegotiatedLocalControlTxIntervalMs())
      return false;
    if (hasNegotiatedLocalControlTxIntervalMs()) {
      if (getNegotiatedLocalControlTxIntervalMs() != other.getNegotiatedLocalControlTxIntervalMs())
        return false;
    }
    if (hasRxPacket() != other.hasRxPacket()) return false;
    if (hasRxPacket()) {
      if (!getRxPacket().equals(other.getRxPacket())) return false;
    }
    if (hasTxPacket() != other.hasTxPacket()) return false;
    if (hasTxPacket()) {
      if (!getTxPacket().equals(other.getTxPacket())) return false;
    }
    if (hasUptimeMs() != other.hasUptimeMs()) return false;
    if (hasUptimeMs()) {
      if (getUptimeMs() != other.getUptimeMs()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBfdSessionInitializationMode()) {
      hash = (37 * hash) + BFD_SESSION_INITIALIZATION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getBfdSessionInitializationMode().hashCode();
    }
    if (hasConfigUpdateTimestampMicros()) {
      hash = (37 * hash) + CONFIG_UPDATE_TIMESTAMP_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getConfigUpdateTimestampMicros());
    }
    if (hasControlPacketCounts()) {
      hash = (37 * hash) + CONTROL_PACKET_COUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getControlPacketCounts().hashCode();
    }
    if (getControlPacketIntervalsCount() > 0) {
      hash = (37 * hash) + CONTROL_PACKET_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + getControlPacketIntervalsList().hashCode();
    }
    if (hasLocalDiagnostic()) {
      hash = (37 * hash) + LOCAL_DIAGNOSTIC_FIELD_NUMBER;
      hash = (53 * hash) + getLocalDiagnostic().hashCode();
    }
    if (hasLocalState()) {
      hash = (37 * hash) + LOCAL_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getLocalState().hashCode();
    }
    if (hasNegotiatedLocalControlTxIntervalMs()) {
      hash = (37 * hash) + NEGOTIATED_LOCAL_CONTROL_TX_INTERVAL_MS_FIELD_NUMBER;
      hash = (53 * hash) + getNegotiatedLocalControlTxIntervalMs();
    }
    if (hasRxPacket()) {
      hash = (37 * hash) + RX_PACKET_FIELD_NUMBER;
      hash = (53 * hash) + getRxPacket().hashCode();
    }
    if (hasTxPacket()) {
      hash = (37 * hash) + TX_PACKET_FIELD_NUMBER;
      hash = (53 * hash) + getTxPacket().hashCode();
    }
    if (hasUptimeMs()) {
      hash = (37 * hash) + UPTIME_MS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUptimeMs());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BfdStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.BfdStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Next free: 15
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BfdStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BfdStatus)
      com.google.cloud.compute.v1.BfdStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BfdStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BfdStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BfdStatus.class,
              com.google.cloud.compute.v1.BfdStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BfdStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getControlPacketCountsFieldBuilder();
        getControlPacketIntervalsFieldBuilder();
        getRxPacketFieldBuilder();
        getTxPacketFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bfdSessionInitializationMode_ = "";
      configUpdateTimestampMicros_ = 0L;
      controlPacketCounts_ = null;
      if (controlPacketCountsBuilder_ != null) {
        controlPacketCountsBuilder_.dispose();
        controlPacketCountsBuilder_ = null;
      }
      if (controlPacketIntervalsBuilder_ == null) {
        controlPacketIntervals_ = java.util.Collections.emptyList();
      } else {
        controlPacketIntervals_ = null;
        controlPacketIntervalsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      localDiagnostic_ = "";
      localState_ = "";
      negotiatedLocalControlTxIntervalMs_ = 0;
      rxPacket_ = null;
      if (rxPacketBuilder_ != null) {
        rxPacketBuilder_.dispose();
        rxPacketBuilder_ = null;
      }
      txPacket_ = null;
      if (txPacketBuilder_ != null) {
        txPacketBuilder_.dispose();
        txPacketBuilder_ = null;
      }
      uptimeMs_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BfdStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BfdStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BfdStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BfdStatus build() {
      com.google.cloud.compute.v1.BfdStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BfdStatus buildPartial() {
      com.google.cloud.compute.v1.BfdStatus result =
          new com.google.cloud.compute.v1.BfdStatus(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.BfdStatus result) {
      if (controlPacketIntervalsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          controlPacketIntervals_ = java.util.Collections.unmodifiableList(controlPacketIntervals_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.controlPacketIntervals_ = controlPacketIntervals_;
      } else {
        result.controlPacketIntervals_ = controlPacketIntervalsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.BfdStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bfdSessionInitializationMode_ = bfdSessionInitializationMode_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.configUpdateTimestampMicros_ = configUpdateTimestampMicros_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.controlPacketCounts_ =
            controlPacketCountsBuilder_ == null
                ? controlPacketCounts_
                : controlPacketCountsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.localDiagnostic_ = localDiagnostic_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.localState_ = localState_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.negotiatedLocalControlTxIntervalMs_ = negotiatedLocalControlTxIntervalMs_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.rxPacket_ = rxPacketBuilder_ == null ? rxPacket_ : rxPacketBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.txPacket_ = txPacketBuilder_ == null ? txPacket_ : txPacketBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.uptimeMs_ = uptimeMs_;
        to_bitField0_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BfdStatus) {
        return mergeFrom((com.google.cloud.compute.v1.BfdStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BfdStatus other) {
      if (other == com.google.cloud.compute.v1.BfdStatus.getDefaultInstance()) return this;
      if (other.hasBfdSessionInitializationMode()) {
        bfdSessionInitializationMode_ = other.bfdSessionInitializationMode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasConfigUpdateTimestampMicros()) {
        setConfigUpdateTimestampMicros(other.getConfigUpdateTimestampMicros());
      }
      if (other.hasControlPacketCounts()) {
        mergeControlPacketCounts(other.getControlPacketCounts());
      }
      if (controlPacketIntervalsBuilder_ == null) {
        if (!other.controlPacketIntervals_.isEmpty()) {
          if (controlPacketIntervals_.isEmpty()) {
            controlPacketIntervals_ = other.controlPacketIntervals_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureControlPacketIntervalsIsMutable();
            controlPacketIntervals_.addAll(other.controlPacketIntervals_);
          }
          onChanged();
        }
      } else {
        if (!other.controlPacketIntervals_.isEmpty()) {
          if (controlPacketIntervalsBuilder_.isEmpty()) {
            controlPacketIntervalsBuilder_.dispose();
            controlPacketIntervalsBuilder_ = null;
            controlPacketIntervals_ = other.controlPacketIntervals_;
            bitField0_ = (bitField0_ & ~0x00000008);
            controlPacketIntervalsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getControlPacketIntervalsFieldBuilder()
                    : null;
          } else {
            controlPacketIntervalsBuilder_.addAllMessages(other.controlPacketIntervals_);
          }
        }
      }
      if (other.hasLocalDiagnostic()) {
        localDiagnostic_ = other.localDiagnostic_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasLocalState()) {
        localState_ = other.localState_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasNegotiatedLocalControlTxIntervalMs()) {
        setNegotiatedLocalControlTxIntervalMs(other.getNegotiatedLocalControlTxIntervalMs());
      }
      if (other.hasRxPacket()) {
        mergeRxPacket(other.getRxPacket());
      }
      if (other.hasTxPacket()) {
        mergeTxPacket(other.getTxPacket());
      }
      if (other.hasUptimeMs()) {
        setUptimeMs(other.getUptimeMs());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 174146720:
              {
                negotiatedLocalControlTxIntervalMs_ = input.readUInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 174146720
            case 891090202:
              {
                input.readMessage(getTxPacketFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 891090202
            case 1003186920:
              {
                uptimeMs_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 1003186920
            case 1060588490:
              {
                input.readMessage(
                    getControlPacketCountsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 1060588490
            case 1193563626:
              {
                localState_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1193563626
            case 1745255634:
              {
                bfdSessionInitializationMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1745255634
            case -637402744:
              {
                configUpdateTimestampMicros_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case -637402744
            case -585070630:
              {
                localDiagnostic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -585070630
            case -288514102:
              {
                com.google.cloud.compute.v1.PacketIntervals m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PacketIntervals.parser(), extensionRegistry);
                if (controlPacketIntervalsBuilder_ == null) {
                  ensureControlPacketIntervalsIsMutable();
                  controlPacketIntervals_.add(m);
                } else {
                  controlPacketIntervalsBuilder_.addMessage(m);
                }
                break;
              } // case -288514102
            case -254409462:
              {
                input.readMessage(getRxPacketFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -254409462
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bfdSessionInitializationMode_ = "";
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
     * Check the BfdSessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bfd_session_initialization_mode = 218156954;</code>
     *
     * @return Whether the bfdSessionInitializationMode field is set.
     */
    public boolean hasBfdSessionInitializationMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
     * Check the BfdSessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bfd_session_initialization_mode = 218156954;</code>
     *
     * @return The bfdSessionInitializationMode.
     */
    public java.lang.String getBfdSessionInitializationMode() {
      java.lang.Object ref = bfdSessionInitializationMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bfdSessionInitializationMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
     * Check the BfdSessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bfd_session_initialization_mode = 218156954;</code>
     *
     * @return The bytes for bfdSessionInitializationMode.
     */
    public com.google.protobuf.ByteString getBfdSessionInitializationModeBytes() {
      java.lang.Object ref = bfdSessionInitializationMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bfdSessionInitializationMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
     * Check the BfdSessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bfd_session_initialization_mode = 218156954;</code>
     *
     * @param value The bfdSessionInitializationMode to set.
     * @return This builder for chaining.
     */
    public Builder setBfdSessionInitializationMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bfdSessionInitializationMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
     * Check the BfdSessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bfd_session_initialization_mode = 218156954;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBfdSessionInitializationMode() {
      bfdSessionInitializationMode_ = getDefaultInstance().getBfdSessionInitializationMode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
     * Check the BfdSessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bfd_session_initialization_mode = 218156954;</code>
     *
     * @param value The bytes for bfdSessionInitializationMode to set.
     * @return This builder for chaining.
     */
    public Builder setBfdSessionInitializationModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bfdSessionInitializationMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long configUpdateTimestampMicros_;
    /**
     *
     *
     * <pre>
     * Unix timestamp of the most recent config update.
     * </pre>
     *
     * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
     *
     * @return Whether the configUpdateTimestampMicros field is set.
     */
    @java.lang.Override
    public boolean hasConfigUpdateTimestampMicros() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Unix timestamp of the most recent config update.
     * </pre>
     *
     * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
     *
     * @return The configUpdateTimestampMicros.
     */
    @java.lang.Override
    public long getConfigUpdateTimestampMicros() {
      return configUpdateTimestampMicros_;
    }
    /**
     *
     *
     * <pre>
     * Unix timestamp of the most recent config update.
     * </pre>
     *
     * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
     *
     * @param value The configUpdateTimestampMicros to set.
     * @return This builder for chaining.
     */
    public Builder setConfigUpdateTimestampMicros(long value) {

      configUpdateTimestampMicros_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unix timestamp of the most recent config update.
     * </pre>
     *
     * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfigUpdateTimestampMicros() {
      bitField0_ = (bitField0_ & ~0x00000002);
      configUpdateTimestampMicros_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BfdStatusPacketCounts controlPacketCounts_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdStatusPacketCounts,
            com.google.cloud.compute.v1.BfdStatusPacketCounts.Builder,
            com.google.cloud.compute.v1.BfdStatusPacketCountsOrBuilder>
        controlPacketCountsBuilder_;
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     *
     * @return Whether the controlPacketCounts field is set.
     */
    public boolean hasControlPacketCounts() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     *
     * @return The controlPacketCounts.
     */
    public com.google.cloud.compute.v1.BfdStatusPacketCounts getControlPacketCounts() {
      if (controlPacketCountsBuilder_ == null) {
        return controlPacketCounts_ == null
            ? com.google.cloud.compute.v1.BfdStatusPacketCounts.getDefaultInstance()
            : controlPacketCounts_;
      } else {
        return controlPacketCountsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    public Builder setControlPacketCounts(com.google.cloud.compute.v1.BfdStatusPacketCounts value) {
      if (controlPacketCountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        controlPacketCounts_ = value;
      } else {
        controlPacketCountsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    public Builder setControlPacketCounts(
        com.google.cloud.compute.v1.BfdStatusPacketCounts.Builder builderForValue) {
      if (controlPacketCountsBuilder_ == null) {
        controlPacketCounts_ = builderForValue.build();
      } else {
        controlPacketCountsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    public Builder mergeControlPacketCounts(
        com.google.cloud.compute.v1.BfdStatusPacketCounts value) {
      if (controlPacketCountsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && controlPacketCounts_ != null
            && controlPacketCounts_
                != com.google.cloud.compute.v1.BfdStatusPacketCounts.getDefaultInstance()) {
          getControlPacketCountsBuilder().mergeFrom(value);
        } else {
          controlPacketCounts_ = value;
        }
      } else {
        controlPacketCountsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    public Builder clearControlPacketCounts() {
      bitField0_ = (bitField0_ & ~0x00000004);
      controlPacketCounts_ = null;
      if (controlPacketCountsBuilder_ != null) {
        controlPacketCountsBuilder_.dispose();
        controlPacketCountsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    public com.google.cloud.compute.v1.BfdStatusPacketCounts.Builder
        getControlPacketCountsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getControlPacketCountsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    public com.google.cloud.compute.v1.BfdStatusPacketCountsOrBuilder
        getControlPacketCountsOrBuilder() {
      if (controlPacketCountsBuilder_ != null) {
        return controlPacketCountsBuilder_.getMessageOrBuilder();
      } else {
        return controlPacketCounts_ == null
            ? com.google.cloud.compute.v1.BfdStatusPacketCounts.getDefaultInstance()
            : controlPacketCounts_;
      }
    }
    /**
     *
     *
     * <pre>
     * Control packet counts for the current BFD session.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdStatusPacketCounts,
            com.google.cloud.compute.v1.BfdStatusPacketCounts.Builder,
            com.google.cloud.compute.v1.BfdStatusPacketCountsOrBuilder>
        getControlPacketCountsFieldBuilder() {
      if (controlPacketCountsBuilder_ == null) {
        controlPacketCountsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BfdStatusPacketCounts,
                com.google.cloud.compute.v1.BfdStatusPacketCounts.Builder,
                com.google.cloud.compute.v1.BfdStatusPacketCountsOrBuilder>(
                getControlPacketCounts(), getParentForChildren(), isClean());
        controlPacketCounts_ = null;
      }
      return controlPacketCountsBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.PacketIntervals> controlPacketIntervals_ =
        java.util.Collections.emptyList();

    private void ensureControlPacketIntervalsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        controlPacketIntervals_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.PacketIntervals>(
                controlPacketIntervals_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PacketIntervals,
            com.google.cloud.compute.v1.PacketIntervals.Builder,
            com.google.cloud.compute.v1.PacketIntervalsOrBuilder>
        controlPacketIntervalsBuilder_;

    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.PacketIntervals>
        getControlPacketIntervalsList() {
      if (controlPacketIntervalsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(controlPacketIntervals_);
      } else {
        return controlPacketIntervalsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public int getControlPacketIntervalsCount() {
      if (controlPacketIntervalsBuilder_ == null) {
        return controlPacketIntervals_.size();
      } else {
        return controlPacketIntervalsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketIntervals getControlPacketIntervals(int index) {
      if (controlPacketIntervalsBuilder_ == null) {
        return controlPacketIntervals_.get(index);
      } else {
        return controlPacketIntervalsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder setControlPacketIntervals(
        int index, com.google.cloud.compute.v1.PacketIntervals value) {
      if (controlPacketIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.set(index, value);
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder setControlPacketIntervals(
        int index, com.google.cloud.compute.v1.PacketIntervals.Builder builderForValue) {
      if (controlPacketIntervalsBuilder_ == null) {
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.set(index, builderForValue.build());
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder addControlPacketIntervals(com.google.cloud.compute.v1.PacketIntervals value) {
      if (controlPacketIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.add(value);
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder addControlPacketIntervals(
        int index, com.google.cloud.compute.v1.PacketIntervals value) {
      if (controlPacketIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.add(index, value);
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder addControlPacketIntervals(
        com.google.cloud.compute.v1.PacketIntervals.Builder builderForValue) {
      if (controlPacketIntervalsBuilder_ == null) {
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.add(builderForValue.build());
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder addControlPacketIntervals(
        int index, com.google.cloud.compute.v1.PacketIntervals.Builder builderForValue) {
      if (controlPacketIntervalsBuilder_ == null) {
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.add(index, builderForValue.build());
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder addAllControlPacketIntervals(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.PacketIntervals> values) {
      if (controlPacketIntervalsBuilder_ == null) {
        ensureControlPacketIntervalsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, controlPacketIntervals_);
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder clearControlPacketIntervals() {
      if (controlPacketIntervalsBuilder_ == null) {
        controlPacketIntervals_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public Builder removeControlPacketIntervals(int index) {
      if (controlPacketIntervalsBuilder_ == null) {
        ensureControlPacketIntervalsIsMutable();
        controlPacketIntervals_.remove(index);
        onChanged();
      } else {
        controlPacketIntervalsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketIntervals.Builder getControlPacketIntervalsBuilder(
        int index) {
      return getControlPacketIntervalsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketIntervalsOrBuilder getControlPacketIntervalsOrBuilder(
        int index) {
      if (controlPacketIntervalsBuilder_ == null) {
        return controlPacketIntervals_.get(index);
      } else {
        return controlPacketIntervalsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.PacketIntervalsOrBuilder>
        getControlPacketIntervalsOrBuilderList() {
      if (controlPacketIntervalsBuilder_ != null) {
        return controlPacketIntervalsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(controlPacketIntervals_);
      }
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketIntervals.Builder addControlPacketIntervalsBuilder() {
      return getControlPacketIntervalsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.PacketIntervals.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketIntervals.Builder addControlPacketIntervalsBuilder(
        int index) {
      return getControlPacketIntervalsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.PacketIntervals.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Inter-packet time interval statistics for control packets.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.PacketIntervals.Builder>
        getControlPacketIntervalsBuilderList() {
      return getControlPacketIntervalsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PacketIntervals,
            com.google.cloud.compute.v1.PacketIntervals.Builder,
            com.google.cloud.compute.v1.PacketIntervalsOrBuilder>
        getControlPacketIntervalsFieldBuilder() {
      if (controlPacketIntervalsBuilder_ == null) {
        controlPacketIntervalsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PacketIntervals,
                com.google.cloud.compute.v1.PacketIntervals.Builder,
                com.google.cloud.compute.v1.PacketIntervalsOrBuilder>(
                controlPacketIntervals_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        controlPacketIntervals_ = null;
      }
      return controlPacketIntervalsBuilder_;
    }

    private java.lang.Object localDiagnostic_ = "";
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the LocalDiagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_diagnostic = 463737083;</code>
     *
     * @return Whether the localDiagnostic field is set.
     */
    public boolean hasLocalDiagnostic() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the LocalDiagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_diagnostic = 463737083;</code>
     *
     * @return The localDiagnostic.
     */
    public java.lang.String getLocalDiagnostic() {
      java.lang.Object ref = localDiagnostic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        localDiagnostic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the LocalDiagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_diagnostic = 463737083;</code>
     *
     * @return The bytes for localDiagnostic.
     */
    public com.google.protobuf.ByteString getLocalDiagnosticBytes() {
      java.lang.Object ref = localDiagnostic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        localDiagnostic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the LocalDiagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_diagnostic = 463737083;</code>
     *
     * @param value The localDiagnostic to set.
     * @return This builder for chaining.
     */
    public Builder setLocalDiagnostic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      localDiagnostic_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the LocalDiagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_diagnostic = 463737083;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalDiagnostic() {
      localDiagnostic_ = getDefaultInstance().getLocalDiagnostic();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the LocalDiagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_diagnostic = 463737083;</code>
     *
     * @param value The bytes for localDiagnostic to set.
     * @return This builder for chaining.
     */
    public Builder setLocalDiagnosticBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      localDiagnostic_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object localState_ = "";
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the LocalState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_state = 149195453;</code>
     *
     * @return Whether the localState field is set.
     */
    public boolean hasLocalState() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the LocalState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_state = 149195453;</code>
     *
     * @return The localState.
     */
    public java.lang.String getLocalState() {
      java.lang.Object ref = localState_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        localState_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the LocalState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_state = 149195453;</code>
     *
     * @return The bytes for localState.
     */
    public com.google.protobuf.ByteString getLocalStateBytes() {
      java.lang.Object ref = localState_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        localState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the LocalState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_state = 149195453;</code>
     *
     * @param value The localState to set.
     * @return This builder for chaining.
     */
    public Builder setLocalState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      localState_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the LocalState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_state = 149195453;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalState() {
      localState_ = getDefaultInstance().getLocalState();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the LocalState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string local_state = 149195453;</code>
     *
     * @param value The bytes for localState to set.
     * @return This builder for chaining.
     */
    public Builder setLocalStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      localState_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int negotiatedLocalControlTxIntervalMs_;
    /**
     *
     *
     * <pre>
     * Negotiated transmit interval for control packets.
     * </pre>
     *
     * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
     *
     * @return Whether the negotiatedLocalControlTxIntervalMs field is set.
     */
    @java.lang.Override
    public boolean hasNegotiatedLocalControlTxIntervalMs() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Negotiated transmit interval for control packets.
     * </pre>
     *
     * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
     *
     * @return The negotiatedLocalControlTxIntervalMs.
     */
    @java.lang.Override
    public int getNegotiatedLocalControlTxIntervalMs() {
      return negotiatedLocalControlTxIntervalMs_;
    }
    /**
     *
     *
     * <pre>
     * Negotiated transmit interval for control packets.
     * </pre>
     *
     * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
     *
     * @param value The negotiatedLocalControlTxIntervalMs to set.
     * @return This builder for chaining.
     */
    public Builder setNegotiatedLocalControlTxIntervalMs(int value) {

      negotiatedLocalControlTxIntervalMs_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Negotiated transmit interval for control packets.
     * </pre>
     *
     * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNegotiatedLocalControlTxIntervalMs() {
      bitField0_ = (bitField0_ & ~0x00000040);
      negotiatedLocalControlTxIntervalMs_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BfdPacket rxPacket_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdPacket,
            com.google.cloud.compute.v1.BfdPacket.Builder,
            com.google.cloud.compute.v1.BfdPacketOrBuilder>
        rxPacketBuilder_;
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     *
     * @return Whether the rxPacket field is set.
     */
    public boolean hasRxPacket() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     *
     * @return The rxPacket.
     */
    public com.google.cloud.compute.v1.BfdPacket getRxPacket() {
      if (rxPacketBuilder_ == null) {
        return rxPacket_ == null
            ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
            : rxPacket_;
      } else {
        return rxPacketBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    public Builder setRxPacket(com.google.cloud.compute.v1.BfdPacket value) {
      if (rxPacketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rxPacket_ = value;
      } else {
        rxPacketBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    public Builder setRxPacket(com.google.cloud.compute.v1.BfdPacket.Builder builderForValue) {
      if (rxPacketBuilder_ == null) {
        rxPacket_ = builderForValue.build();
      } else {
        rxPacketBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    public Builder mergeRxPacket(com.google.cloud.compute.v1.BfdPacket value) {
      if (rxPacketBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && rxPacket_ != null
            && rxPacket_ != com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()) {
          getRxPacketBuilder().mergeFrom(value);
        } else {
          rxPacket_ = value;
        }
      } else {
        rxPacketBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    public Builder clearRxPacket() {
      bitField0_ = (bitField0_ & ~0x00000080);
      rxPacket_ = null;
      if (rxPacketBuilder_ != null) {
        rxPacketBuilder_.dispose();
        rxPacketBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    public com.google.cloud.compute.v1.BfdPacket.Builder getRxPacketBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRxPacketFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    public com.google.cloud.compute.v1.BfdPacketOrBuilder getRxPacketOrBuilder() {
      if (rxPacketBuilder_ != null) {
        return rxPacketBuilder_.getMessageOrBuilder();
      } else {
        return rxPacket_ == null
            ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
            : rxPacket_;
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent Rx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdPacket,
            com.google.cloud.compute.v1.BfdPacket.Builder,
            com.google.cloud.compute.v1.BfdPacketOrBuilder>
        getRxPacketFieldBuilder() {
      if (rxPacketBuilder_ == null) {
        rxPacketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BfdPacket,
                com.google.cloud.compute.v1.BfdPacket.Builder,
                com.google.cloud.compute.v1.BfdPacketOrBuilder>(
                getRxPacket(), getParentForChildren(), isClean());
        rxPacket_ = null;
      }
      return rxPacketBuilder_;
    }

    private com.google.cloud.compute.v1.BfdPacket txPacket_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdPacket,
            com.google.cloud.compute.v1.BfdPacket.Builder,
            com.google.cloud.compute.v1.BfdPacketOrBuilder>
        txPacketBuilder_;
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     *
     * @return Whether the txPacket field is set.
     */
    public boolean hasTxPacket() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     *
     * @return The txPacket.
     */
    public com.google.cloud.compute.v1.BfdPacket getTxPacket() {
      if (txPacketBuilder_ == null) {
        return txPacket_ == null
            ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
            : txPacket_;
      } else {
        return txPacketBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    public Builder setTxPacket(com.google.cloud.compute.v1.BfdPacket value) {
      if (txPacketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        txPacket_ = value;
      } else {
        txPacketBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    public Builder setTxPacket(com.google.cloud.compute.v1.BfdPacket.Builder builderForValue) {
      if (txPacketBuilder_ == null) {
        txPacket_ = builderForValue.build();
      } else {
        txPacketBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    public Builder mergeTxPacket(com.google.cloud.compute.v1.BfdPacket value) {
      if (txPacketBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && txPacket_ != null
            && txPacket_ != com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()) {
          getTxPacketBuilder().mergeFrom(value);
        } else {
          txPacket_ = value;
        }
      } else {
        txPacketBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    public Builder clearTxPacket() {
      bitField0_ = (bitField0_ & ~0x00000100);
      txPacket_ = null;
      if (txPacketBuilder_ != null) {
        txPacketBuilder_.dispose();
        txPacketBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    public com.google.cloud.compute.v1.BfdPacket.Builder getTxPacketBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getTxPacketFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    public com.google.cloud.compute.v1.BfdPacketOrBuilder getTxPacketOrBuilder() {
      if (txPacketBuilder_ != null) {
        return txPacketBuilder_.getMessageOrBuilder();
      } else {
        return txPacket_ == null
            ? com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()
            : txPacket_;
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent Tx control packet for this BFD session.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BfdPacket,
            com.google.cloud.compute.v1.BfdPacket.Builder,
            com.google.cloud.compute.v1.BfdPacketOrBuilder>
        getTxPacketFieldBuilder() {
      if (txPacketBuilder_ == null) {
        txPacketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BfdPacket,
                com.google.cloud.compute.v1.BfdPacket.Builder,
                com.google.cloud.compute.v1.BfdPacketOrBuilder>(
                getTxPacket(), getParentForChildren(), isClean());
        txPacket_ = null;
      }
      return txPacketBuilder_;
    }

    private long uptimeMs_;
    /**
     *
     *
     * <pre>
     * Session uptime in milliseconds. Value will be 0 if session is not up.
     * </pre>
     *
     * <code>optional int64 uptime_ms = 125398365;</code>
     *
     * @return Whether the uptimeMs field is set.
     */
    @java.lang.Override
    public boolean hasUptimeMs() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Session uptime in milliseconds. Value will be 0 if session is not up.
     * </pre>
     *
     * <code>optional int64 uptime_ms = 125398365;</code>
     *
     * @return The uptimeMs.
     */
    @java.lang.Override
    public long getUptimeMs() {
      return uptimeMs_;
    }
    /**
     *
     *
     * <pre>
     * Session uptime in milliseconds. Value will be 0 if session is not up.
     * </pre>
     *
     * <code>optional int64 uptime_ms = 125398365;</code>
     *
     * @param value The uptimeMs to set.
     * @return This builder for chaining.
     */
    public Builder setUptimeMs(long value) {

      uptimeMs_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session uptime in milliseconds. Value will be 0 if session is not up.
     * </pre>
     *
     * <code>optional int64 uptime_ms = 125398365;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUptimeMs() {
      bitField0_ = (bitField0_ & ~0x00000200);
      uptimeMs_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BfdStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BfdStatus)
  private static final com.google.cloud.compute.v1.BfdStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BfdStatus();
  }

  public static com.google.cloud.compute.v1.BfdStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BfdStatus> PARSER =
      new com.google.protobuf.AbstractParser<BfdStatus>() {
        @java.lang.Override
        public BfdStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BfdStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BfdStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BfdStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
