/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Message containing what to include in the cache key for a request for Cloud CDN.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.CacheKeyPolicy}
 */
public final class CacheKeyPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.CacheKeyPolicy)
    CacheKeyPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CacheKeyPolicy.newBuilder() to construct.
  private CacheKeyPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CacheKeyPolicy() {
    includeHttpHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
    includeNamedCookies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    queryStringBlacklist_ = com.google.protobuf.LazyStringArrayList.emptyList();
    queryStringWhitelist_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CacheKeyPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CacheKeyPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CacheKeyPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.CacheKeyPolicy.class,
            com.google.cloud.compute.v1.CacheKeyPolicy.Builder.class);
  }

  private int bitField0_;
  public static final int INCLUDE_HOST_FIELD_NUMBER = 486867679;
  private boolean includeHost_ = false;
  /**
   *
   *
   * <pre>
   * If true, requests to different hosts will be cached separately.
   * </pre>
   *
   * <code>optional bool include_host = 486867679;</code>
   *
   * @return Whether the includeHost field is set.
   */
  @java.lang.Override
  public boolean hasIncludeHost() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, requests to different hosts will be cached separately.
   * </pre>
   *
   * <code>optional bool include_host = 486867679;</code>
   *
   * @return The includeHost.
   */
  @java.lang.Override
  public boolean getIncludeHost() {
    return includeHost_;
  }

  public static final int INCLUDE_HTTP_HEADERS_FIELD_NUMBER = 2489606;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList includeHttpHeaders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @return A list containing the includeHttpHeaders.
   */
  public com.google.protobuf.ProtocolStringList getIncludeHttpHeadersList() {
    return includeHttpHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @return The count of includeHttpHeaders.
   */
  public int getIncludeHttpHeadersCount() {
    return includeHttpHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @param index The index of the element to return.
   * @return The includeHttpHeaders at the given index.
   */
  public java.lang.String getIncludeHttpHeaders(int index) {
    return includeHttpHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includeHttpHeaders at the given index.
   */
  public com.google.protobuf.ByteString getIncludeHttpHeadersBytes(int index) {
    return includeHttpHeaders_.getByteString(index);
  }

  public static final int INCLUDE_NAMED_COOKIES_FIELD_NUMBER = 87316530;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList includeNamedCookies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
   * </pre>
   *
   * <code>repeated string include_named_cookies = 87316530;</code>
   *
   * @return A list containing the includeNamedCookies.
   */
  public com.google.protobuf.ProtocolStringList getIncludeNamedCookiesList() {
    return includeNamedCookies_;
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
   * </pre>
   *
   * <code>repeated string include_named_cookies = 87316530;</code>
   *
   * @return The count of includeNamedCookies.
   */
  public int getIncludeNamedCookiesCount() {
    return includeNamedCookies_.size();
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
   * </pre>
   *
   * <code>repeated string include_named_cookies = 87316530;</code>
   *
   * @param index The index of the element to return.
   * @return The includeNamedCookies at the given index.
   */
  public java.lang.String getIncludeNamedCookies(int index) {
    return includeNamedCookies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
   * </pre>
   *
   * <code>repeated string include_named_cookies = 87316530;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includeNamedCookies at the given index.
   */
  public com.google.protobuf.ByteString getIncludeNamedCookiesBytes(int index) {
    return includeNamedCookies_.getByteString(index);
  }

  public static final int INCLUDE_PROTOCOL_FIELD_NUMBER = 303507535;
  private boolean includeProtocol_ = false;
  /**
   *
   *
   * <pre>
   * If true, http and https requests will be cached separately.
   * </pre>
   *
   * <code>optional bool include_protocol = 303507535;</code>
   *
   * @return Whether the includeProtocol field is set.
   */
  @java.lang.Override
  public boolean hasIncludeProtocol() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, http and https requests will be cached separately.
   * </pre>
   *
   * <code>optional bool include_protocol = 303507535;</code>
   *
   * @return The includeProtocol.
   */
  @java.lang.Override
  public boolean getIncludeProtocol() {
    return includeProtocol_;
  }

  public static final int INCLUDE_QUERY_STRING_FIELD_NUMBER = 474036639;
  private boolean includeQueryString_ = false;
  /**
   *
   *
   * <pre>
   * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
   * </pre>
   *
   * <code>optional bool include_query_string = 474036639;</code>
   *
   * @return Whether the includeQueryString field is set.
   */
  @java.lang.Override
  public boolean hasIncludeQueryString() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
   * </pre>
   *
   * <code>optional bool include_query_string = 474036639;</code>
   *
   * @return The includeQueryString.
   */
  @java.lang.Override
  public boolean getIncludeQueryString() {
    return includeQueryString_;
  }

  public static final int QUERY_STRING_BLACKLIST_FIELD_NUMBER = 354964742;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList queryStringBlacklist_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_blacklist = 354964742;</code>
   *
   * @return A list containing the queryStringBlacklist.
   */
  public com.google.protobuf.ProtocolStringList getQueryStringBlacklistList() {
    return queryStringBlacklist_;
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_blacklist = 354964742;</code>
   *
   * @return The count of queryStringBlacklist.
   */
  public int getQueryStringBlacklistCount() {
    return queryStringBlacklist_.size();
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_blacklist = 354964742;</code>
   *
   * @param index The index of the element to return.
   * @return The queryStringBlacklist at the given index.
   */
  public java.lang.String getQueryStringBlacklist(int index) {
    return queryStringBlacklist_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_blacklist = 354964742;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the queryStringBlacklist at the given index.
   */
  public com.google.protobuf.ByteString getQueryStringBlacklistBytes(int index) {
    return queryStringBlacklist_.getByteString(index);
  }

  public static final int QUERY_STRING_WHITELIST_FIELD_NUMBER = 52456496;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList queryStringWhitelist_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @return A list containing the queryStringWhitelist.
   */
  public com.google.protobuf.ProtocolStringList getQueryStringWhitelistList() {
    return queryStringWhitelist_;
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @return The count of queryStringWhitelist.
   */
  public int getQueryStringWhitelistCount() {
    return queryStringWhitelist_.size();
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @param index The index of the element to return.
   * @return The queryStringWhitelist at the given index.
   */
  public java.lang.String getQueryStringWhitelist(int index) {
    return queryStringWhitelist_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the queryStringWhitelist at the given index.
   */
  public com.google.protobuf.ByteString getQueryStringWhitelistBytes(int index) {
    return queryStringWhitelist_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < includeHttpHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2489606, includeHttpHeaders_.getRaw(i));
    }
    for (int i = 0; i < queryStringWhitelist_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 52456496, queryStringWhitelist_.getRaw(i));
    }
    for (int i = 0; i < includeNamedCookies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 87316530, includeNamedCookies_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(303507535, includeProtocol_);
    }
    for (int i = 0; i < queryStringBlacklist_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 354964742, queryStringBlacklist_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(474036639, includeQueryString_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(486867679, includeHost_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < includeHttpHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(includeHttpHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getIncludeHttpHeadersList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < queryStringWhitelist_.size(); i++) {
        dataSize += computeStringSizeNoTag(queryStringWhitelist_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getQueryStringWhitelistList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < includeNamedCookies_.size(); i++) {
        dataSize += computeStringSizeNoTag(includeNamedCookies_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getIncludeNamedCookiesList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(303507535, includeProtocol_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < queryStringBlacklist_.size(); i++) {
        dataSize += computeStringSizeNoTag(queryStringBlacklist_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getQueryStringBlacklistList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(474036639, includeQueryString_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(486867679, includeHost_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.CacheKeyPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.CacheKeyPolicy other =
        (com.google.cloud.compute.v1.CacheKeyPolicy) obj;

    if (hasIncludeHost() != other.hasIncludeHost()) return false;
    if (hasIncludeHost()) {
      if (getIncludeHost() != other.getIncludeHost()) return false;
    }
    if (!getIncludeHttpHeadersList().equals(other.getIncludeHttpHeadersList())) return false;
    if (!getIncludeNamedCookiesList().equals(other.getIncludeNamedCookiesList())) return false;
    if (hasIncludeProtocol() != other.hasIncludeProtocol()) return false;
    if (hasIncludeProtocol()) {
      if (getIncludeProtocol() != other.getIncludeProtocol()) return false;
    }
    if (hasIncludeQueryString() != other.hasIncludeQueryString()) return false;
    if (hasIncludeQueryString()) {
      if (getIncludeQueryString() != other.getIncludeQueryString()) return false;
    }
    if (!getQueryStringBlacklistList().equals(other.getQueryStringBlacklistList())) return false;
    if (!getQueryStringWhitelistList().equals(other.getQueryStringWhitelistList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIncludeHost()) {
      hash = (37 * hash) + INCLUDE_HOST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeHost());
    }
    if (getIncludeHttpHeadersCount() > 0) {
      hash = (37 * hash) + INCLUDE_HTTP_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeHttpHeadersList().hashCode();
    }
    if (getIncludeNamedCookiesCount() > 0) {
      hash = (37 * hash) + INCLUDE_NAMED_COOKIES_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeNamedCookiesList().hashCode();
    }
    if (hasIncludeProtocol()) {
      hash = (37 * hash) + INCLUDE_PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeProtocol());
    }
    if (hasIncludeQueryString()) {
      hash = (37 * hash) + INCLUDE_QUERY_STRING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeQueryString());
    }
    if (getQueryStringBlacklistCount() > 0) {
      hash = (37 * hash) + QUERY_STRING_BLACKLIST_FIELD_NUMBER;
      hash = (53 * hash) + getQueryStringBlacklistList().hashCode();
    }
    if (getQueryStringWhitelistCount() > 0) {
      hash = (37 * hash) + QUERY_STRING_WHITELIST_FIELD_NUMBER;
      hash = (53 * hash) + getQueryStringWhitelistList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.CacheKeyPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message containing what to include in the cache key for a request for Cloud CDN.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.CacheKeyPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.CacheKeyPolicy)
      com.google.cloud.compute.v1.CacheKeyPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CacheKeyPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CacheKeyPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.CacheKeyPolicy.class,
              com.google.cloud.compute.v1.CacheKeyPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.CacheKeyPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      includeHost_ = false;
      includeHttpHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      includeNamedCookies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      includeProtocol_ = false;
      includeQueryString_ = false;
      queryStringBlacklist_ = com.google.protobuf.LazyStringArrayList.emptyList();
      queryStringWhitelist_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CacheKeyPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CacheKeyPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.CacheKeyPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CacheKeyPolicy build() {
      com.google.cloud.compute.v1.CacheKeyPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CacheKeyPolicy buildPartial() {
      com.google.cloud.compute.v1.CacheKeyPolicy result =
          new com.google.cloud.compute.v1.CacheKeyPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.CacheKeyPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.includeHost_ = includeHost_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        includeHttpHeaders_.makeImmutable();
        result.includeHttpHeaders_ = includeHttpHeaders_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        includeNamedCookies_.makeImmutable();
        result.includeNamedCookies_ = includeNamedCookies_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.includeProtocol_ = includeProtocol_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.includeQueryString_ = includeQueryString_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        queryStringBlacklist_.makeImmutable();
        result.queryStringBlacklist_ = queryStringBlacklist_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        queryStringWhitelist_.makeImmutable();
        result.queryStringWhitelist_ = queryStringWhitelist_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.CacheKeyPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.CacheKeyPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.CacheKeyPolicy other) {
      if (other == com.google.cloud.compute.v1.CacheKeyPolicy.getDefaultInstance()) return this;
      if (other.hasIncludeHost()) {
        setIncludeHost(other.getIncludeHost());
      }
      if (!other.includeHttpHeaders_.isEmpty()) {
        if (includeHttpHeaders_.isEmpty()) {
          includeHttpHeaders_ = other.includeHttpHeaders_;
          bitField0_ |= 0x00000002;
        } else {
          ensureIncludeHttpHeadersIsMutable();
          includeHttpHeaders_.addAll(other.includeHttpHeaders_);
        }
        onChanged();
      }
      if (!other.includeNamedCookies_.isEmpty()) {
        if (includeNamedCookies_.isEmpty()) {
          includeNamedCookies_ = other.includeNamedCookies_;
          bitField0_ |= 0x00000004;
        } else {
          ensureIncludeNamedCookiesIsMutable();
          includeNamedCookies_.addAll(other.includeNamedCookies_);
        }
        onChanged();
      }
      if (other.hasIncludeProtocol()) {
        setIncludeProtocol(other.getIncludeProtocol());
      }
      if (other.hasIncludeQueryString()) {
        setIncludeQueryString(other.getIncludeQueryString());
      }
      if (!other.queryStringBlacklist_.isEmpty()) {
        if (queryStringBlacklist_.isEmpty()) {
          queryStringBlacklist_ = other.queryStringBlacklist_;
          bitField0_ |= 0x00000020;
        } else {
          ensureQueryStringBlacklistIsMutable();
          queryStringBlacklist_.addAll(other.queryStringBlacklist_);
        }
        onChanged();
      }
      if (!other.queryStringWhitelist_.isEmpty()) {
        if (queryStringWhitelist_.isEmpty()) {
          queryStringWhitelist_ = other.queryStringWhitelist_;
          bitField0_ |= 0x00000040;
        } else {
          ensureQueryStringWhitelistIsMutable();
          queryStringWhitelist_.addAll(other.queryStringWhitelist_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 19916850:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludeHttpHeadersIsMutable();
                includeHttpHeaders_.add(s);
                break;
              } // case 19916850
            case 419651970:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureQueryStringWhitelistIsMutable();
                queryStringWhitelist_.add(s);
                break;
              } // case 419651970
            case 698532242:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludeNamedCookiesIsMutable();
                includeNamedCookies_.add(s);
                break;
              } // case 698532242
            case -1866907016:
              {
                includeProtocol_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case -1866907016
            case -1455249358:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureQueryStringBlacklistIsMutable();
                queryStringBlacklist_.add(s);
                break;
              } // case -1455249358
            case -502674184:
              {
                includeQueryString_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case -502674184
            case -400025864:
              {
                includeHost_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -400025864
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean includeHost_;
    /**
     *
     *
     * <pre>
     * If true, requests to different hosts will be cached separately.
     * </pre>
     *
     * <code>optional bool include_host = 486867679;</code>
     *
     * @return Whether the includeHost field is set.
     */
    @java.lang.Override
    public boolean hasIncludeHost() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, requests to different hosts will be cached separately.
     * </pre>
     *
     * <code>optional bool include_host = 486867679;</code>
     *
     * @return The includeHost.
     */
    @java.lang.Override
    public boolean getIncludeHost() {
      return includeHost_;
    }
    /**
     *
     *
     * <pre>
     * If true, requests to different hosts will be cached separately.
     * </pre>
     *
     * <code>optional bool include_host = 486867679;</code>
     *
     * @param value The includeHost to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeHost(boolean value) {

      includeHost_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, requests to different hosts will be cached separately.
     * </pre>
     *
     * <code>optional bool include_host = 486867679;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeHost() {
      bitField0_ = (bitField0_ & ~0x00000001);
      includeHost_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList includeHttpHeaders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncludeHttpHeadersIsMutable() {
      if (!includeHttpHeaders_.isModifiable()) {
        includeHttpHeaders_ = new com.google.protobuf.LazyStringArrayList(includeHttpHeaders_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @return A list containing the includeHttpHeaders.
     */
    public com.google.protobuf.ProtocolStringList getIncludeHttpHeadersList() {
      includeHttpHeaders_.makeImmutable();
      return includeHttpHeaders_;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @return The count of includeHttpHeaders.
     */
    public int getIncludeHttpHeadersCount() {
      return includeHttpHeaders_.size();
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param index The index of the element to return.
     * @return The includeHttpHeaders at the given index.
     */
    public java.lang.String getIncludeHttpHeaders(int index) {
      return includeHttpHeaders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeHttpHeaders at the given index.
     */
    public com.google.protobuf.ByteString getIncludeHttpHeadersBytes(int index) {
      return includeHttpHeaders_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param index The index to set the value at.
     * @param value The includeHttpHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeHttpHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeHttpHeadersIsMutable();
      includeHttpHeaders_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param value The includeHttpHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeHttpHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeHttpHeadersIsMutable();
      includeHttpHeaders_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param values The includeHttpHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludeHttpHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureIncludeHttpHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeHttpHeaders_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeHttpHeaders() {
      includeHttpHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param value The bytes of the includeHttpHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeHttpHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludeHttpHeadersIsMutable();
      includeHttpHeaders_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList includeNamedCookies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncludeNamedCookiesIsMutable() {
      if (!includeNamedCookies_.isModifiable()) {
        includeNamedCookies_ = new com.google.protobuf.LazyStringArrayList(includeNamedCookies_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @return A list containing the includeNamedCookies.
     */
    public com.google.protobuf.ProtocolStringList getIncludeNamedCookiesList() {
      includeNamedCookies_.makeImmutable();
      return includeNamedCookies_;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @return The count of includeNamedCookies.
     */
    public int getIncludeNamedCookiesCount() {
      return includeNamedCookies_.size();
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @param index The index of the element to return.
     * @return The includeNamedCookies at the given index.
     */
    public java.lang.String getIncludeNamedCookies(int index) {
      return includeNamedCookies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeNamedCookies at the given index.
     */
    public com.google.protobuf.ByteString getIncludeNamedCookiesBytes(int index) {
      return includeNamedCookies_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @param index The index to set the value at.
     * @param value The includeNamedCookies to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeNamedCookies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeNamedCookiesIsMutable();
      includeNamedCookies_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @param value The includeNamedCookies to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeNamedCookies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeNamedCookiesIsMutable();
      includeNamedCookies_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @param values The includeNamedCookies to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludeNamedCookies(java.lang.Iterable<java.lang.String> values) {
      ensureIncludeNamedCookiesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeNamedCookies_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeNamedCookies() {
      includeNamedCookies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
     * </pre>
     *
     * <code>repeated string include_named_cookies = 87316530;</code>
     *
     * @param value The bytes of the includeNamedCookies to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeNamedCookiesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludeNamedCookiesIsMutable();
      includeNamedCookies_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean includeProtocol_;
    /**
     *
     *
     * <pre>
     * If true, http and https requests will be cached separately.
     * </pre>
     *
     * <code>optional bool include_protocol = 303507535;</code>
     *
     * @return Whether the includeProtocol field is set.
     */
    @java.lang.Override
    public boolean hasIncludeProtocol() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, http and https requests will be cached separately.
     * </pre>
     *
     * <code>optional bool include_protocol = 303507535;</code>
     *
     * @return The includeProtocol.
     */
    @java.lang.Override
    public boolean getIncludeProtocol() {
      return includeProtocol_;
    }
    /**
     *
     *
     * <pre>
     * If true, http and https requests will be cached separately.
     * </pre>
     *
     * <code>optional bool include_protocol = 303507535;</code>
     *
     * @param value The includeProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeProtocol(boolean value) {

      includeProtocol_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, http and https requests will be cached separately.
     * </pre>
     *
     * <code>optional bool include_protocol = 303507535;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeProtocol() {
      bitField0_ = (bitField0_ & ~0x00000008);
      includeProtocol_ = false;
      onChanged();
      return this;
    }

    private boolean includeQueryString_;
    /**
     *
     *
     * <pre>
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
     * </pre>
     *
     * <code>optional bool include_query_string = 474036639;</code>
     *
     * @return Whether the includeQueryString field is set.
     */
    @java.lang.Override
    public boolean hasIncludeQueryString() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
     * </pre>
     *
     * <code>optional bool include_query_string = 474036639;</code>
     *
     * @return The includeQueryString.
     */
    @java.lang.Override
    public boolean getIncludeQueryString() {
      return includeQueryString_;
    }
    /**
     *
     *
     * <pre>
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
     * </pre>
     *
     * <code>optional bool include_query_string = 474036639;</code>
     *
     * @param value The includeQueryString to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeQueryString(boolean value) {

      includeQueryString_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
     * </pre>
     *
     * <code>optional bool include_query_string = 474036639;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeQueryString() {
      bitField0_ = (bitField0_ & ~0x00000010);
      includeQueryString_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList queryStringBlacklist_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureQueryStringBlacklistIsMutable() {
      if (!queryStringBlacklist_.isModifiable()) {
        queryStringBlacklist_ = new com.google.protobuf.LazyStringArrayList(queryStringBlacklist_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @return A list containing the queryStringBlacklist.
     */
    public com.google.protobuf.ProtocolStringList getQueryStringBlacklistList() {
      queryStringBlacklist_.makeImmutable();
      return queryStringBlacklist_;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @return The count of queryStringBlacklist.
     */
    public int getQueryStringBlacklistCount() {
      return queryStringBlacklist_.size();
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @param index The index of the element to return.
     * @return The queryStringBlacklist at the given index.
     */
    public java.lang.String getQueryStringBlacklist(int index) {
      return queryStringBlacklist_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the queryStringBlacklist at the given index.
     */
    public com.google.protobuf.ByteString getQueryStringBlacklistBytes(int index) {
      return queryStringBlacklist_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @param index The index to set the value at.
     * @param value The queryStringBlacklist to set.
     * @return This builder for chaining.
     */
    public Builder setQueryStringBlacklist(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureQueryStringBlacklistIsMutable();
      queryStringBlacklist_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @param value The queryStringBlacklist to add.
     * @return This builder for chaining.
     */
    public Builder addQueryStringBlacklist(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureQueryStringBlacklistIsMutable();
      queryStringBlacklist_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @param values The queryStringBlacklist to add.
     * @return This builder for chaining.
     */
    public Builder addAllQueryStringBlacklist(java.lang.Iterable<java.lang.String> values) {
      ensureQueryStringBlacklistIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queryStringBlacklist_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryStringBlacklist() {
      queryStringBlacklist_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_blacklist = 354964742;</code>
     *
     * @param value The bytes of the queryStringBlacklist to add.
     * @return This builder for chaining.
     */
    public Builder addQueryStringBlacklistBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureQueryStringBlacklistIsMutable();
      queryStringBlacklist_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList queryStringWhitelist_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureQueryStringWhitelistIsMutable() {
      if (!queryStringWhitelist_.isModifiable()) {
        queryStringWhitelist_ = new com.google.protobuf.LazyStringArrayList(queryStringWhitelist_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @return A list containing the queryStringWhitelist.
     */
    public com.google.protobuf.ProtocolStringList getQueryStringWhitelistList() {
      queryStringWhitelist_.makeImmutable();
      return queryStringWhitelist_;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @return The count of queryStringWhitelist.
     */
    public int getQueryStringWhitelistCount() {
      return queryStringWhitelist_.size();
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param index The index of the element to return.
     * @return The queryStringWhitelist at the given index.
     */
    public java.lang.String getQueryStringWhitelist(int index) {
      return queryStringWhitelist_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the queryStringWhitelist at the given index.
     */
    public com.google.protobuf.ByteString getQueryStringWhitelistBytes(int index) {
      return queryStringWhitelist_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param index The index to set the value at.
     * @param value The queryStringWhitelist to set.
     * @return This builder for chaining.
     */
    public Builder setQueryStringWhitelist(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureQueryStringWhitelistIsMutable();
      queryStringWhitelist_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param value The queryStringWhitelist to add.
     * @return This builder for chaining.
     */
    public Builder addQueryStringWhitelist(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureQueryStringWhitelistIsMutable();
      queryStringWhitelist_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param values The queryStringWhitelist to add.
     * @return This builder for chaining.
     */
    public Builder addAllQueryStringWhitelist(java.lang.Iterable<java.lang.String> values) {
      ensureQueryStringWhitelistIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queryStringWhitelist_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryStringWhitelist() {
      queryStringWhitelist_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param value The bytes of the queryStringWhitelist to add.
     * @return This builder for chaining.
     */
    public Builder addQueryStringWhitelistBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureQueryStringWhitelistIsMutable();
      queryStringWhitelist_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.CacheKeyPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.CacheKeyPolicy)
  private static final com.google.cloud.compute.v1.CacheKeyPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.CacheKeyPolicy();
  }

  public static com.google.cloud.compute.v1.CacheKeyPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CacheKeyPolicy> PARSER =
      new com.google.protobuf.AbstractParser<CacheKeyPolicy>() {
        @java.lang.Override
        public CacheKeyPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CacheKeyPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CacheKeyPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.CacheKeyPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
