/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A request message for RegionInstanceGroupManagers.CreateInstances. See the method description for details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest}
 */
public final class CreateInstancesRegionInstanceGroupManagerRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest)
    CreateInstancesRegionInstanceGroupManagerRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateInstancesRegionInstanceGroupManagerRequest.newBuilder() to construct.
  private CreateInstancesRegionInstanceGroupManagerRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateInstancesRegionInstanceGroupManagerRequest() {
    instanceGroupManager_ = "";
    project_ = "";
    region_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateInstancesRegionInstanceGroupManagerRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CreateInstancesRegionInstanceGroupManagerRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CreateInstancesRegionInstanceGroupManagerRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest.class,
            com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest.Builder
                .class);
  }

  private int bitField0_;
  public static final int INSTANCE_GROUP_MANAGER_FIELD_NUMBER = 249363395;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceGroupManager_ = "";
  /**
   *
   *
   * <pre>
   * The name of the managed instance group. It should conform to RFC1035.
   * </pre>
   *
   * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instanceGroupManager.
   */
  @java.lang.Override
  public java.lang.String getInstanceGroupManager() {
    java.lang.Object ref = instanceGroupManager_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceGroupManager_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the managed instance group. It should conform to RFC1035.
   * </pre>
   *
   * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for instanceGroupManager.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceGroupManagerBytes() {
    java.lang.Object ref = instanceGroupManager_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceGroupManager_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 227560217;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * The name of the region where the managed instance group is located. It should conform to RFC1035.
   * </pre>
   *
   * <code>
   * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
   * </code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the region where the managed instance group is located. It should conform to RFC1035.
   * </pre>
   *
   * <code>
   * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
   * </code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int
      REGION_INSTANCE_GROUP_MANAGERS_CREATE_INSTANCES_REQUEST_RESOURCE_FIELD_NUMBER = 359014280;
  private com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
      regionInstanceGroupManagersCreateInstancesRequestResource_;
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the regionInstanceGroupManagersCreateInstancesRequestResource field is set.
   */
  @java.lang.Override
  public boolean hasRegionInstanceGroupManagersCreateInstancesRequestResource() {
    return regionInstanceGroupManagersCreateInstancesRequestResource_ != null;
  }
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The regionInstanceGroupManagersCreateInstancesRequestResource.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
      getRegionInstanceGroupManagersCreateInstancesRequestResource() {
    return regionInstanceGroupManagersCreateInstancesRequestResource_ == null
        ? com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
            .getDefaultInstance()
        : regionInstanceGroupManagersCreateInstancesRequestResource_;
  }
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequestOrBuilder
      getRegionInstanceGroupManagersCreateInstancesRequestResourceOrBuilder() {
    return regionInstanceGroupManagersCreateInstancesRequestResource_ == null
        ? com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
            .getDefaultInstance()
        : regionInstanceGroupManagersCreateInstancesRequestResource_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 37109963;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return Whether the requestId field is set.
   */
  @java.lang.Override
  public boolean hasRequestId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37109963, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceGroupManager_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 249363395, instanceGroupManager_);
    }
    if (regionInstanceGroupManagersCreateInstancesRequestResource_ != null) {
      output.writeMessage(
          359014280, getRegionInstanceGroupManagersCreateInstancesRequestResource());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37109963, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceGroupManager_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              249363395, instanceGroupManager_);
    }
    if (regionInstanceGroupManagersCreateInstancesRequestResource_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              359014280, getRegionInstanceGroupManagersCreateInstancesRequestResource());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest other =
        (com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest) obj;

    if (!getInstanceGroupManager().equals(other.getInstanceGroupManager())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (!getRegion().equals(other.getRegion())) return false;
    if (hasRegionInstanceGroupManagersCreateInstancesRequestResource()
        != other.hasRegionInstanceGroupManagersCreateInstancesRequestResource()) return false;
    if (hasRegionInstanceGroupManagersCreateInstancesRequestResource()) {
      if (!getRegionInstanceGroupManagersCreateInstancesRequestResource()
          .equals(other.getRegionInstanceGroupManagersCreateInstancesRequestResource()))
        return false;
    }
    if (hasRequestId() != other.hasRequestId()) return false;
    if (hasRequestId()) {
      if (!getRequestId().equals(other.getRequestId())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_GROUP_MANAGER_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceGroupManager().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + REGION_FIELD_NUMBER;
    hash = (53 * hash) + getRegion().hashCode();
    if (hasRegionInstanceGroupManagersCreateInstancesRequestResource()) {
      hash =
          (37 * hash)
              + REGION_INSTANCE_GROUP_MANAGERS_CREATE_INSTANCES_REQUEST_RESOURCE_FIELD_NUMBER;
      hash =
          (53 * hash) + getRegionInstanceGroupManagersCreateInstancesRequestResource().hashCode();
    }
    if (hasRequestId()) {
      hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
      hash = (53 * hash) + getRequestId().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request message for RegionInstanceGroupManagers.CreateInstances. See the method description for details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest)
      com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CreateInstancesRegionInstanceGroupManagerRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CreateInstancesRegionInstanceGroupManagerRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest.class,
              com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceGroupManager_ = "";
      project_ = "";
      region_ = "";
      regionInstanceGroupManagersCreateInstancesRequestResource_ = null;
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ != null) {
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.dispose();
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CreateInstancesRegionInstanceGroupManagerRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest build() {
      com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
        buildPartial() {
      com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest result =
          new com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceGroupManager_ = instanceGroupManager_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.region_ = region_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.regionInstanceGroupManagersCreateInstancesRequestResource_ =
            regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ == null
                ? regionInstanceGroupManagersCreateInstancesRequestResource_
                : regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.build();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.requestId_ = requestId_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest) {
        return mergeFrom(
            (com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest other) {
      if (other
          == com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
              .getDefaultInstance()) return this;
      if (!other.getInstanceGroupManager().isEmpty()) {
        instanceGroupManager_ = other.instanceGroupManager_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRegion().isEmpty()) {
        region_ = other.region_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRegionInstanceGroupManagersCreateInstancesRequestResource()) {
        mergeRegionInstanceGroupManagersCreateInstancesRequestResource(
            other.getRegionInstanceGroupManagersCreateInstancesRequestResource());
      }
      if (other.hasRequestId()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 296879706:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 296879706
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1111570338
            case 1820481738:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1820481738
            case 1994907162:
              {
                instanceGroupManager_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1994907162
            case -1422853054:
              {
                input.readMessage(
                    getRegionInstanceGroupManagersCreateInstancesRequestResourceFieldBuilder()
                        .getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -1422853054
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceGroupManager_ = "";
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. It should conform to RFC1035.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceGroupManager.
     */
    public java.lang.String getInstanceGroupManager() {
      java.lang.Object ref = instanceGroupManager_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceGroupManager_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. It should conform to RFC1035.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for instanceGroupManager.
     */
    public com.google.protobuf.ByteString getInstanceGroupManagerBytes() {
      java.lang.Object ref = instanceGroupManager_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceGroupManager_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. It should conform to RFC1035.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The instanceGroupManager to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupManager(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceGroupManager_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. It should conform to RFC1035.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceGroupManager() {
      instanceGroupManager_ = getDefaultInstance().getInstanceGroupManager();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. It should conform to RFC1035.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for instanceGroupManager to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupManagerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceGroupManager_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * The name of the region where the managed instance group is located. It should conform to RFC1035.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the region where the managed instance group is located. It should conform to RFC1035.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the region where the managed instance group is located. It should conform to RFC1035.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the region where the managed instance group is located. It should conform to RFC1035.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the region where the managed instance group is located. It should conform to RFC1035.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
        regionInstanceGroupManagersCreateInstancesRequestResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest,
            com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest.Builder,
            com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequestOrBuilder>
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_;
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the regionInstanceGroupManagersCreateInstancesRequestResource field is set.
     */
    public boolean hasRegionInstanceGroupManagersCreateInstancesRequestResource() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The regionInstanceGroupManagersCreateInstancesRequestResource.
     */
    public com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
        getRegionInstanceGroupManagersCreateInstancesRequestResource() {
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ == null) {
        return regionInstanceGroupManagersCreateInstancesRequestResource_ == null
            ? com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
                .getDefaultInstance()
            : regionInstanceGroupManagersCreateInstancesRequestResource_;
      } else {
        return regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegionInstanceGroupManagersCreateInstancesRequestResource(
        com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest value) {
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        regionInstanceGroupManagersCreateInstancesRequestResource_ = value;
      } else {
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegionInstanceGroupManagersCreateInstancesRequestResource(
        com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest.Builder
            builderForValue) {
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ == null) {
        regionInstanceGroupManagersCreateInstancesRequestResource_ = builderForValue.build();
      } else {
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.setMessage(
            builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRegionInstanceGroupManagersCreateInstancesRequestResource(
        com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest value) {
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && regionInstanceGroupManagersCreateInstancesRequestResource_ != null
            && regionInstanceGroupManagersCreateInstancesRequestResource_
                != com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
                    .getDefaultInstance()) {
          getRegionInstanceGroupManagersCreateInstancesRequestResourceBuilder().mergeFrom(value);
        } else {
          regionInstanceGroupManagersCreateInstancesRequestResource_ = value;
        }
      } else {
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRegionInstanceGroupManagersCreateInstancesRequestResource() {
      bitField0_ = (bitField0_ & ~0x00000008);
      regionInstanceGroupManagersCreateInstancesRequestResource_ = null;
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ != null) {
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_.dispose();
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest.Builder
        getRegionInstanceGroupManagersCreateInstancesRequestResourceBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRegionInstanceGroupManagersCreateInstancesRequestResourceFieldBuilder()
          .getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequestOrBuilder
        getRegionInstanceGroupManagersCreateInstancesRequestResourceOrBuilder() {
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ != null) {
        return regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_
            .getMessageOrBuilder();
      } else {
        return regionInstanceGroupManagersCreateInstancesRequestResource_ == null
            ? com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
                .getDefaultInstance()
            : regionInstanceGroupManagersCreateInstancesRequestResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest region_instance_group_managers_create_instances_request_resource = 359014280 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest,
            com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest.Builder,
            com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequestOrBuilder>
        getRegionInstanceGroupManagersCreateInstancesRequestResourceFieldBuilder() {
      if (regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ == null) {
        regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest,
                com.google.cloud.compute.v1.RegionInstanceGroupManagersCreateInstancesRequest
                    .Builder,
                com.google.cloud.compute.v1
                    .RegionInstanceGroupManagersCreateInstancesRequestOrBuilder>(
                getRegionInstanceGroupManagersCreateInstancesRequestResource(),
                getParentForChildren(),
                isClean());
        regionInstanceGroupManagersCreateInstancesRequestResource_ = null;
      }
      return regionInstanceGroupManagersCreateInstancesRequestResourceBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return Whether the requestId field is set.
     */
    public boolean hasRequestId() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest)
  private static final com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest();
  }

  public static com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateInstancesRegionInstanceGroupManagerRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<
              CreateInstancesRegionInstanceGroupManagerRequest>() {
            @java.lang.Override
            public CreateInstancesRegionInstanceGroupManagerRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<CreateInstancesRegionInstanceGroupManagerRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateInstancesRegionInstanceGroupManagerRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
