/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HealthStatusForNetworkEndpoint}
 */
public final class HealthStatusForNetworkEndpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HealthStatusForNetworkEndpoint)
    HealthStatusForNetworkEndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HealthStatusForNetworkEndpoint.newBuilder() to construct.
  private HealthStatusForNetworkEndpoint(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HealthStatusForNetworkEndpoint() {
    healthState_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HealthStatusForNetworkEndpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HealthStatusForNetworkEndpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HealthStatusForNetworkEndpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.class,
            com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Health state of the network endpoint determined based on the health checks configured.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.HealthStatusForNetworkEndpoint.HealthState}
   */
  public enum HealthState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_HEALTH_STATE = 0;</code>
     */
    UNDEFINED_HEALTH_STATE(0),
    /**
     *
     *
     * <pre>
     * Endpoint is being drained.
     * </pre>
     *
     * <code>DRAINING = 480455402;</code>
     */
    DRAINING(480455402),
    /**
     *
     *
     * <pre>
     * Endpoint is healthy.
     * </pre>
     *
     * <code>HEALTHY = 439801213;</code>
     */
    HEALTHY(439801213),
    /**
     *
     *
     * <pre>
     * Endpoint is unhealthy.
     * </pre>
     *
     * <code>UNHEALTHY = 462118084;</code>
     */
    UNHEALTHY(462118084),
    /**
     *
     *
     * <pre>
     * Health status of the endpoint is unknown.
     * </pre>
     *
     * <code>UNKNOWN = 433141802;</code>
     */
    UNKNOWN(433141802),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_HEALTH_STATE = 0;</code>
     */
    public static final int UNDEFINED_HEALTH_STATE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Endpoint is being drained.
     * </pre>
     *
     * <code>DRAINING = 480455402;</code>
     */
    public static final int DRAINING_VALUE = 480455402;
    /**
     *
     *
     * <pre>
     * Endpoint is healthy.
     * </pre>
     *
     * <code>HEALTHY = 439801213;</code>
     */
    public static final int HEALTHY_VALUE = 439801213;
    /**
     *
     *
     * <pre>
     * Endpoint is unhealthy.
     * </pre>
     *
     * <code>UNHEALTHY = 462118084;</code>
     */
    public static final int UNHEALTHY_VALUE = 462118084;
    /**
     *
     *
     * <pre>
     * Health status of the endpoint is unknown.
     * </pre>
     *
     * <code>UNKNOWN = 433141802;</code>
     */
    public static final int UNKNOWN_VALUE = 433141802;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HealthState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HealthState forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_HEALTH_STATE;
        case 480455402:
          return DRAINING;
        case 439801213:
          return HEALTHY;
        case 462118084:
          return UNHEALTHY;
        case 433141802:
          return UNKNOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HealthState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HealthState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<HealthState>() {
          public HealthState findValueByNumber(int number) {
            return HealthState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final HealthState[] VALUES = values();

    public static HealthState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HealthState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.HealthStatusForNetworkEndpoint.HealthState)
  }

  private int bitField0_;
  public static final int BACKEND_SERVICE_FIELD_NUMBER = 306946058;
  private com.google.cloud.compute.v1.BackendServiceReference backendService_;
  /**
   *
   *
   * <pre>
   * URL of the backend service associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
   * </code>
   *
   * @return Whether the backendService field is set.
   */
  @java.lang.Override
  public boolean hasBackendService() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the backend service associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
   * </code>
   *
   * @return The backendService.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceReference getBackendService() {
    return backendService_ == null
        ? com.google.cloud.compute.v1.BackendServiceReference.getDefaultInstance()
        : backendService_;
  }
  /**
   *
   *
   * <pre>
   * URL of the backend service associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceReferenceOrBuilder getBackendServiceOrBuilder() {
    return backendService_ == null
        ? com.google.cloud.compute.v1.BackendServiceReference.getDefaultInstance()
        : backendService_;
  }

  public static final int FORWARDING_RULE_FIELD_NUMBER = 269964030;
  private com.google.cloud.compute.v1.ForwardingRuleReference forwardingRule_;
  /**
   *
   *
   * <pre>
   * URL of the forwarding rule associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
   * </code>
   *
   * @return Whether the forwardingRule field is set.
   */
  @java.lang.Override
  public boolean hasForwardingRule() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the forwarding rule associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
   * </code>
   *
   * @return The forwardingRule.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ForwardingRuleReference getForwardingRule() {
    return forwardingRule_ == null
        ? com.google.cloud.compute.v1.ForwardingRuleReference.getDefaultInstance()
        : forwardingRule_;
  }
  /**
   *
   *
   * <pre>
   * URL of the forwarding rule associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ForwardingRuleReferenceOrBuilder getForwardingRuleOrBuilder() {
    return forwardingRule_ == null
        ? com.google.cloud.compute.v1.ForwardingRuleReference.getDefaultInstance()
        : forwardingRule_;
  }

  public static final int HEALTH_CHECK_FIELD_NUMBER = 308876645;
  private com.google.cloud.compute.v1.HealthCheckReference healthCheck_;
  /**
   *
   *
   * <pre>
   * URL of the health check associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
   *
   * @return Whether the healthCheck field is set.
   */
  @java.lang.Override
  public boolean hasHealthCheck() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the health check associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
   *
   * @return The healthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheckReference getHealthCheck() {
    return healthCheck_ == null
        ? com.google.cloud.compute.v1.HealthCheckReference.getDefaultInstance()
        : healthCheck_;
  }
  /**
   *
   *
   * <pre>
   * URL of the health check associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheckReferenceOrBuilder getHealthCheckOrBuilder() {
    return healthCheck_ == null
        ? com.google.cloud.compute.v1.HealthCheckReference.getDefaultInstance()
        : healthCheck_;
  }

  public static final int HEALTH_CHECK_SERVICE_FIELD_NUMBER = 408374747;
  private com.google.cloud.compute.v1.HealthCheckServiceReference healthCheckService_;
  /**
   *
   *
   * <pre>
   * URL of the health check service associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
   * </code>
   *
   * @return Whether the healthCheckService field is set.
   */
  @java.lang.Override
  public boolean hasHealthCheckService() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the health check service associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
   * </code>
   *
   * @return The healthCheckService.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheckServiceReference getHealthCheckService() {
    return healthCheckService_ == null
        ? com.google.cloud.compute.v1.HealthCheckServiceReference.getDefaultInstance()
        : healthCheckService_;
  }
  /**
   *
   *
   * <pre>
   * URL of the health check service associated with the health state of the network endpoint.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheckServiceReferenceOrBuilder
      getHealthCheckServiceOrBuilder() {
    return healthCheckService_ == null
        ? com.google.cloud.compute.v1.HealthCheckServiceReference.getDefaultInstance()
        : healthCheckService_;
  }

  public static final int HEALTH_STATE_FIELD_NUMBER = 324007150;

  @SuppressWarnings("serial")
  private volatile java.lang.Object healthState_ = "";
  /**
   *
   *
   * <pre>
   * Health state of the network endpoint determined based on the health checks configured.
   * Check the HealthState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_state = 324007150;</code>
   *
   * @return Whether the healthState field is set.
   */
  @java.lang.Override
  public boolean hasHealthState() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Health state of the network endpoint determined based on the health checks configured.
   * Check the HealthState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_state = 324007150;</code>
   *
   * @return The healthState.
   */
  @java.lang.Override
  public java.lang.String getHealthState() {
    java.lang.Object ref = healthState_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthState_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Health state of the network endpoint determined based on the health checks configured.
   * Check the HealthState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_state = 324007150;</code>
   *
   * @return The bytes for healthState.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthStateBytes() {
    java.lang.Object ref = healthState_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthState_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(269964030, getForwardingRule());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(306946058, getBackendService());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(308876645, getHealthCheck());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 324007150, healthState_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(408374747, getHealthCheckService());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(269964030, getForwardingRule());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(306946058, getBackendService());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(308876645, getHealthCheck());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(324007150, healthState_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              408374747, getHealthCheckService());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint other =
        (com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint) obj;

    if (hasBackendService() != other.hasBackendService()) return false;
    if (hasBackendService()) {
      if (!getBackendService().equals(other.getBackendService())) return false;
    }
    if (hasForwardingRule() != other.hasForwardingRule()) return false;
    if (hasForwardingRule()) {
      if (!getForwardingRule().equals(other.getForwardingRule())) return false;
    }
    if (hasHealthCheck() != other.hasHealthCheck()) return false;
    if (hasHealthCheck()) {
      if (!getHealthCheck().equals(other.getHealthCheck())) return false;
    }
    if (hasHealthCheckService() != other.hasHealthCheckService()) return false;
    if (hasHealthCheckService()) {
      if (!getHealthCheckService().equals(other.getHealthCheckService())) return false;
    }
    if (hasHealthState() != other.hasHealthState()) return false;
    if (hasHealthState()) {
      if (!getHealthState().equals(other.getHealthState())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBackendService()) {
      hash = (37 * hash) + BACKEND_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getBackendService().hashCode();
    }
    if (hasForwardingRule()) {
      hash = (37 * hash) + FORWARDING_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getForwardingRule().hashCode();
    }
    if (hasHealthCheck()) {
      hash = (37 * hash) + HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getHealthCheck().hashCode();
    }
    if (hasHealthCheckService()) {
      hash = (37 * hash) + HEALTH_CHECK_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getHealthCheckService().hashCode();
    }
    if (hasHealthState()) {
      hash = (37 * hash) + HEALTH_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getHealthState().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HealthStatusForNetworkEndpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HealthStatusForNetworkEndpoint)
      com.google.cloud.compute.v1.HealthStatusForNetworkEndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthStatusForNetworkEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthStatusForNetworkEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.class,
              com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBackendServiceFieldBuilder();
        getForwardingRuleFieldBuilder();
        getHealthCheckFieldBuilder();
        getHealthCheckServiceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      backendService_ = null;
      if (backendServiceBuilder_ != null) {
        backendServiceBuilder_.dispose();
        backendServiceBuilder_ = null;
      }
      forwardingRule_ = null;
      if (forwardingRuleBuilder_ != null) {
        forwardingRuleBuilder_.dispose();
        forwardingRuleBuilder_ = null;
      }
      healthCheck_ = null;
      if (healthCheckBuilder_ != null) {
        healthCheckBuilder_.dispose();
        healthCheckBuilder_ = null;
      }
      healthCheckService_ = null;
      if (healthCheckServiceBuilder_ != null) {
        healthCheckServiceBuilder_.dispose();
        healthCheckServiceBuilder_ = null;
      }
      healthState_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthStatusForNetworkEndpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint build() {
      com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint buildPartial() {
      com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint result =
          new com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.backendService_ =
            backendServiceBuilder_ == null ? backendService_ : backendServiceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.forwardingRule_ =
            forwardingRuleBuilder_ == null ? forwardingRule_ : forwardingRuleBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.healthCheck_ =
            healthCheckBuilder_ == null ? healthCheck_ : healthCheckBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.healthCheckService_ =
            healthCheckServiceBuilder_ == null
                ? healthCheckService_
                : healthCheckServiceBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.healthState_ = healthState_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint) {
        return mergeFrom((com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint other) {
      if (other == com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint.getDefaultInstance())
        return this;
      if (other.hasBackendService()) {
        mergeBackendService(other.getBackendService());
      }
      if (other.hasForwardingRule()) {
        mergeForwardingRule(other.getForwardingRule());
      }
      if (other.hasHealthCheck()) {
        mergeHealthCheck(other.getHealthCheck());
      }
      if (other.hasHealthCheckService()) {
        mergeHealthCheckService(other.getHealthCheckService());
      }
      if (other.hasHealthState()) {
        healthState_ = other.healthState_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case -2135255054:
              {
                input.readMessage(getForwardingRuleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -2135255054
            case -1839398830:
              {
                input.readMessage(getBackendServiceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1839398830
            case -1823954134:
              {
                input.readMessage(getHealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1823954134
            case -1702910094:
              {
                healthState_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1702910094
            case -1027969318:
              {
                input.readMessage(
                    getHealthCheckServiceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -1027969318
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.BackendServiceReference backendService_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceReference,
            com.google.cloud.compute.v1.BackendServiceReference.Builder,
            com.google.cloud.compute.v1.BackendServiceReferenceOrBuilder>
        backendServiceBuilder_;
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     *
     * @return Whether the backendService field is set.
     */
    public boolean hasBackendService() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     *
     * @return The backendService.
     */
    public com.google.cloud.compute.v1.BackendServiceReference getBackendService() {
      if (backendServiceBuilder_ == null) {
        return backendService_ == null
            ? com.google.cloud.compute.v1.BackendServiceReference.getDefaultInstance()
            : backendService_;
      } else {
        return backendServiceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    public Builder setBackendService(com.google.cloud.compute.v1.BackendServiceReference value) {
      if (backendServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backendService_ = value;
      } else {
        backendServiceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    public Builder setBackendService(
        com.google.cloud.compute.v1.BackendServiceReference.Builder builderForValue) {
      if (backendServiceBuilder_ == null) {
        backendService_ = builderForValue.build();
      } else {
        backendServiceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    public Builder mergeBackendService(com.google.cloud.compute.v1.BackendServiceReference value) {
      if (backendServiceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && backendService_ != null
            && backendService_
                != com.google.cloud.compute.v1.BackendServiceReference.getDefaultInstance()) {
          getBackendServiceBuilder().mergeFrom(value);
        } else {
          backendService_ = value;
        }
      } else {
        backendServiceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    public Builder clearBackendService() {
      bitField0_ = (bitField0_ & ~0x00000001);
      backendService_ = null;
      if (backendServiceBuilder_ != null) {
        backendServiceBuilder_.dispose();
        backendServiceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceReference.Builder getBackendServiceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBackendServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceReferenceOrBuilder
        getBackendServiceOrBuilder() {
      if (backendServiceBuilder_ != null) {
        return backendServiceBuilder_.getMessageOrBuilder();
      } else {
        return backendService_ == null
            ? com.google.cloud.compute.v1.BackendServiceReference.getDefaultInstance()
            : backendService_;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the backend service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceReference backend_service = 306946058;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceReference,
            com.google.cloud.compute.v1.BackendServiceReference.Builder,
            com.google.cloud.compute.v1.BackendServiceReferenceOrBuilder>
        getBackendServiceFieldBuilder() {
      if (backendServiceBuilder_ == null) {
        backendServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceReference,
                com.google.cloud.compute.v1.BackendServiceReference.Builder,
                com.google.cloud.compute.v1.BackendServiceReferenceOrBuilder>(
                getBackendService(), getParentForChildren(), isClean());
        backendService_ = null;
      }
      return backendServiceBuilder_;
    }

    private com.google.cloud.compute.v1.ForwardingRuleReference forwardingRule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ForwardingRuleReference,
            com.google.cloud.compute.v1.ForwardingRuleReference.Builder,
            com.google.cloud.compute.v1.ForwardingRuleReferenceOrBuilder>
        forwardingRuleBuilder_;
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     *
     * @return Whether the forwardingRule field is set.
     */
    public boolean hasForwardingRule() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     *
     * @return The forwardingRule.
     */
    public com.google.cloud.compute.v1.ForwardingRuleReference getForwardingRule() {
      if (forwardingRuleBuilder_ == null) {
        return forwardingRule_ == null
            ? com.google.cloud.compute.v1.ForwardingRuleReference.getDefaultInstance()
            : forwardingRule_;
      } else {
        return forwardingRuleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    public Builder setForwardingRule(com.google.cloud.compute.v1.ForwardingRuleReference value) {
      if (forwardingRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        forwardingRule_ = value;
      } else {
        forwardingRuleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    public Builder setForwardingRule(
        com.google.cloud.compute.v1.ForwardingRuleReference.Builder builderForValue) {
      if (forwardingRuleBuilder_ == null) {
        forwardingRule_ = builderForValue.build();
      } else {
        forwardingRuleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    public Builder mergeForwardingRule(com.google.cloud.compute.v1.ForwardingRuleReference value) {
      if (forwardingRuleBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && forwardingRule_ != null
            && forwardingRule_
                != com.google.cloud.compute.v1.ForwardingRuleReference.getDefaultInstance()) {
          getForwardingRuleBuilder().mergeFrom(value);
        } else {
          forwardingRule_ = value;
        }
      } else {
        forwardingRuleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    public Builder clearForwardingRule() {
      bitField0_ = (bitField0_ & ~0x00000002);
      forwardingRule_ = null;
      if (forwardingRuleBuilder_ != null) {
        forwardingRuleBuilder_.dispose();
        forwardingRuleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleReference.Builder getForwardingRuleBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getForwardingRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleReferenceOrBuilder
        getForwardingRuleOrBuilder() {
      if (forwardingRuleBuilder_ != null) {
        return forwardingRuleBuilder_.getMessageOrBuilder();
      } else {
        return forwardingRule_ == null
            ? com.google.cloud.compute.v1.ForwardingRuleReference.getDefaultInstance()
            : forwardingRule_;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ForwardingRuleReference forwarding_rule = 269964030;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ForwardingRuleReference,
            com.google.cloud.compute.v1.ForwardingRuleReference.Builder,
            com.google.cloud.compute.v1.ForwardingRuleReferenceOrBuilder>
        getForwardingRuleFieldBuilder() {
      if (forwardingRuleBuilder_ == null) {
        forwardingRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ForwardingRuleReference,
                com.google.cloud.compute.v1.ForwardingRuleReference.Builder,
                com.google.cloud.compute.v1.ForwardingRuleReferenceOrBuilder>(
                getForwardingRule(), getParentForChildren(), isClean());
        forwardingRule_ = null;
      }
      return forwardingRuleBuilder_;
    }

    private com.google.cloud.compute.v1.HealthCheckReference healthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HealthCheckReference,
            com.google.cloud.compute.v1.HealthCheckReference.Builder,
            com.google.cloud.compute.v1.HealthCheckReferenceOrBuilder>
        healthCheckBuilder_;
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     *
     * @return Whether the healthCheck field is set.
     */
    public boolean hasHealthCheck() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     *
     * @return The healthCheck.
     */
    public com.google.cloud.compute.v1.HealthCheckReference getHealthCheck() {
      if (healthCheckBuilder_ == null) {
        return healthCheck_ == null
            ? com.google.cloud.compute.v1.HealthCheckReference.getDefaultInstance()
            : healthCheck_;
      } else {
        return healthCheckBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    public Builder setHealthCheck(com.google.cloud.compute.v1.HealthCheckReference value) {
      if (healthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        healthCheck_ = value;
      } else {
        healthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    public Builder setHealthCheck(
        com.google.cloud.compute.v1.HealthCheckReference.Builder builderForValue) {
      if (healthCheckBuilder_ == null) {
        healthCheck_ = builderForValue.build();
      } else {
        healthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    public Builder mergeHealthCheck(com.google.cloud.compute.v1.HealthCheckReference value) {
      if (healthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && healthCheck_ != null
            && healthCheck_
                != com.google.cloud.compute.v1.HealthCheckReference.getDefaultInstance()) {
          getHealthCheckBuilder().mergeFrom(value);
        } else {
          healthCheck_ = value;
        }
      } else {
        healthCheckBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    public Builder clearHealthCheck() {
      bitField0_ = (bitField0_ & ~0x00000004);
      healthCheck_ = null;
      if (healthCheckBuilder_ != null) {
        healthCheckBuilder_.dispose();
        healthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    public com.google.cloud.compute.v1.HealthCheckReference.Builder getHealthCheckBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getHealthCheckFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    public com.google.cloud.compute.v1.HealthCheckReferenceOrBuilder getHealthCheckOrBuilder() {
      if (healthCheckBuilder_ != null) {
        return healthCheckBuilder_.getMessageOrBuilder();
      } else {
        return healthCheck_ == null
            ? com.google.cloud.compute.v1.HealthCheckReference.getDefaultInstance()
            : healthCheck_;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the health check associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckReference health_check = 308876645;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HealthCheckReference,
            com.google.cloud.compute.v1.HealthCheckReference.Builder,
            com.google.cloud.compute.v1.HealthCheckReferenceOrBuilder>
        getHealthCheckFieldBuilder() {
      if (healthCheckBuilder_ == null) {
        healthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HealthCheckReference,
                com.google.cloud.compute.v1.HealthCheckReference.Builder,
                com.google.cloud.compute.v1.HealthCheckReferenceOrBuilder>(
                getHealthCheck(), getParentForChildren(), isClean());
        healthCheck_ = null;
      }
      return healthCheckBuilder_;
    }

    private com.google.cloud.compute.v1.HealthCheckServiceReference healthCheckService_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HealthCheckServiceReference,
            com.google.cloud.compute.v1.HealthCheckServiceReference.Builder,
            com.google.cloud.compute.v1.HealthCheckServiceReferenceOrBuilder>
        healthCheckServiceBuilder_;
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     *
     * @return Whether the healthCheckService field is set.
     */
    public boolean hasHealthCheckService() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     *
     * @return The healthCheckService.
     */
    public com.google.cloud.compute.v1.HealthCheckServiceReference getHealthCheckService() {
      if (healthCheckServiceBuilder_ == null) {
        return healthCheckService_ == null
            ? com.google.cloud.compute.v1.HealthCheckServiceReference.getDefaultInstance()
            : healthCheckService_;
      } else {
        return healthCheckServiceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    public Builder setHealthCheckService(
        com.google.cloud.compute.v1.HealthCheckServiceReference value) {
      if (healthCheckServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        healthCheckService_ = value;
      } else {
        healthCheckServiceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    public Builder setHealthCheckService(
        com.google.cloud.compute.v1.HealthCheckServiceReference.Builder builderForValue) {
      if (healthCheckServiceBuilder_ == null) {
        healthCheckService_ = builderForValue.build();
      } else {
        healthCheckServiceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    public Builder mergeHealthCheckService(
        com.google.cloud.compute.v1.HealthCheckServiceReference value) {
      if (healthCheckServiceBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && healthCheckService_ != null
            && healthCheckService_
                != com.google.cloud.compute.v1.HealthCheckServiceReference.getDefaultInstance()) {
          getHealthCheckServiceBuilder().mergeFrom(value);
        } else {
          healthCheckService_ = value;
        }
      } else {
        healthCheckServiceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    public Builder clearHealthCheckService() {
      bitField0_ = (bitField0_ & ~0x00000008);
      healthCheckService_ = null;
      if (healthCheckServiceBuilder_ != null) {
        healthCheckServiceBuilder_.dispose();
        healthCheckServiceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    public com.google.cloud.compute.v1.HealthCheckServiceReference.Builder
        getHealthCheckServiceBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getHealthCheckServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    public com.google.cloud.compute.v1.HealthCheckServiceReferenceOrBuilder
        getHealthCheckServiceOrBuilder() {
      if (healthCheckServiceBuilder_ != null) {
        return healthCheckServiceBuilder_.getMessageOrBuilder();
      } else {
        return healthCheckService_ == null
            ? com.google.cloud.compute.v1.HealthCheckServiceReference.getDefaultInstance()
            : healthCheckService_;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the health check service associated with the health state of the network endpoint.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HealthCheckServiceReference health_check_service = 408374747;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HealthCheckServiceReference,
            com.google.cloud.compute.v1.HealthCheckServiceReference.Builder,
            com.google.cloud.compute.v1.HealthCheckServiceReferenceOrBuilder>
        getHealthCheckServiceFieldBuilder() {
      if (healthCheckServiceBuilder_ == null) {
        healthCheckServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HealthCheckServiceReference,
                com.google.cloud.compute.v1.HealthCheckServiceReference.Builder,
                com.google.cloud.compute.v1.HealthCheckServiceReferenceOrBuilder>(
                getHealthCheckService(), getParentForChildren(), isClean());
        healthCheckService_ = null;
      }
      return healthCheckServiceBuilder_;
    }

    private java.lang.Object healthState_ = "";
    /**
     *
     *
     * <pre>
     * Health state of the network endpoint determined based on the health checks configured.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return Whether the healthState field is set.
     */
    public boolean hasHealthState() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Health state of the network endpoint determined based on the health checks configured.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return The healthState.
     */
    public java.lang.String getHealthState() {
      java.lang.Object ref = healthState_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthState_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Health state of the network endpoint determined based on the health checks configured.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return The bytes for healthState.
     */
    public com.google.protobuf.ByteString getHealthStateBytes() {
      java.lang.Object ref = healthState_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Health state of the network endpoint determined based on the health checks configured.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @param value The healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      healthState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Health state of the network endpoint determined based on the health checks configured.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthState() {
      healthState_ = getDefaultInstance().getHealthState();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Health state of the network endpoint determined based on the health checks configured.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @param value The bytes for healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      healthState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HealthStatusForNetworkEndpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HealthStatusForNetworkEndpoint)
  private static final com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint();
  }

  public static com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HealthStatusForNetworkEndpoint> PARSER =
      new com.google.protobuf.AbstractParser<HealthStatusForNetworkEndpoint>() {
        @java.lang.Override
        public HealthStatusForNetworkEndpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HealthStatusForNetworkEndpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HealthStatusForNetworkEndpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
