/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

public interface InstanceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.Instance)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   *
   * @return Whether the advancedMachineFeatures field is set.
   */
  boolean hasAdvancedMachineFeatures();
  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   *
   * @return The advancedMachineFeatures.
   */
  com.google.cloud.compute.v1.AdvancedMachineFeatures getAdvancedMachineFeatures();
  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   */
  com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder
      getAdvancedMachineFeaturesOrBuilder();

  /**
   *
   *
   * <pre>
   * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return Whether the canIpForward field is set.
   */
  boolean hasCanIpForward();
  /**
   *
   *
   * <pre>
   * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return The canIpForward.
   */
  boolean getCanIpForward();

  /**
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   *
   * @return Whether the confidentialInstanceConfig field is set.
   */
  boolean hasConfidentialInstanceConfig();
  /**
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   *
   * @return The confidentialInstanceConfig.
   */
  com.google.cloud.compute.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig();
  /**
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   */
  com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder
      getConfidentialInstanceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] The CPU platform used by this instance.
   * </pre>
   *
   * <code>optional string cpu_platform = 410285354;</code>
   *
   * @return Whether the cpuPlatform field is set.
   */
  boolean hasCpuPlatform();
  /**
   *
   *
   * <pre>
   * [Output Only] The CPU platform used by this instance.
   * </pre>
   *
   * <code>optional string cpu_platform = 410285354;</code>
   *
   * @return The cpuPlatform.
   */
  java.lang.String getCpuPlatform();
  /**
   *
   *
   * <pre>
   * [Output Only] The CPU platform used by this instance.
   * </pre>
   *
   * <code>optional string cpu_platform = 410285354;</code>
   *
   * @return The bytes for cpuPlatform.
   */
  com.google.protobuf.ByteString getCpuPlatformBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * Whether the resource should be protected against deletion.
   * </pre>
   *
   * <code>optional bool deletion_protection = 458014698;</code>
   *
   * @return Whether the deletionProtection field is set.
   */
  boolean hasDeletionProtection();
  /**
   *
   *
   * <pre>
   * Whether the resource should be protected against deletion.
   * </pre>
   *
   * <code>optional bool deletion_protection = 458014698;</code>
   *
   * @return The deletionProtection.
   */
  boolean getDeletionProtection();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  java.util.List<com.google.cloud.compute.v1.AttachedDisk> getDisksList();
  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  com.google.cloud.compute.v1.AttachedDisk getDisks(int index);
  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  int getDisksCount();
  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.AttachedDiskOrBuilder>
      getDisksOrBuilderList();
  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  com.google.cloud.compute.v1.AttachedDiskOrBuilder getDisksOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Enables display device for the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
   *
   * @return Whether the displayDevice field is set.
   */
  boolean hasDisplayDevice();
  /**
   *
   *
   * <pre>
   * Enables display device for the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
   *
   * @return The displayDevice.
   */
  com.google.cloud.compute.v1.DisplayDevice getDisplayDevice();
  /**
   *
   *
   * <pre>
   * Enables display device for the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
   */
  com.google.cloud.compute.v1.DisplayDeviceOrBuilder getDisplayDeviceOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  boolean hasFingerprint();
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  java.lang.String getFingerprint();
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  com.google.protobuf.ByteString getFingerprintBytes();

  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getGuestAcceleratorsList();
  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index);
  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  int getGuestAcceleratorsCount();
  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
      getGuestAcceleratorsOrBuilderList();
  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
   * </pre>
   *
   * <code>optional string hostname = 237067315;</code>
   *
   * @return Whether the hostname field is set.
   */
  boolean hasHostname();
  /**
   *
   *
   * <pre>
   * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
   * </pre>
   *
   * <code>optional string hostname = 237067315;</code>
   *
   * @return The hostname.
   */
  java.lang.String getHostname();
  /**
   *
   *
   * <pre>
   * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
   * </pre>
   *
   * <code>optional string hostname = 237067315;</code>
   *
   * @return The bytes for hostname.
   */
  com.google.protobuf.ByteString getHostnameBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
   * </code>
   *
   * @return Whether the instanceEncryptionKey field is set.
   */
  boolean hasInstanceEncryptionKey();
  /**
   *
   *
   * <pre>
   * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
   * </code>
   *
   * @return The instanceEncryptionKey.
   */
  com.google.cloud.compute.v1.CustomerEncryptionKey getInstanceEncryptionKey();
  /**
   *
   *
   * <pre>
   * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
   * </code>
   */
  com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder getInstanceEncryptionKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return Whether the keyRevocationActionType field is set.
   */
  boolean hasKeyRevocationActionType();
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The keyRevocationActionType.
   */
  java.lang.String getKeyRevocationActionType();
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The bytes for keyRevocationActionType.
   */
  com.google.protobuf.ByteString getKeyRevocationActionTypeBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  boolean hasLabelFingerprint();
  /**
   *
   *
   * <pre>
   * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  java.lang.String getLabelFingerprint();
  /**
   *
   *
   * <pre>
   * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  com.google.protobuf.ByteString getLabelFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * [Output Only] Last start timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_start_timestamp = 443830736;</code>
   *
   * @return Whether the lastStartTimestamp field is set.
   */
  boolean hasLastStartTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Last start timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_start_timestamp = 443830736;</code>
   *
   * @return The lastStartTimestamp.
   */
  java.lang.String getLastStartTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Last start timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_start_timestamp = 443830736;</code>
   *
   * @return The bytes for lastStartTimestamp.
   */
  com.google.protobuf.ByteString getLastStartTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Last stop timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_stop_timestamp = 412823010;</code>
   *
   * @return Whether the lastStopTimestamp field is set.
   */
  boolean hasLastStopTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Last stop timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_stop_timestamp = 412823010;</code>
   *
   * @return The lastStopTimestamp.
   */
  java.lang.String getLastStopTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Last stop timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_stop_timestamp = 412823010;</code>
   *
   * @return The bytes for lastStopTimestamp.
   */
  com.google.protobuf.ByteString getLastStopTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Last suspended timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_suspended_timestamp = 356275337;</code>
   *
   * @return Whether the lastSuspendedTimestamp field is set.
   */
  boolean hasLastSuspendedTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Last suspended timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_suspended_timestamp = 356275337;</code>
   *
   * @return The lastSuspendedTimestamp.
   */
  java.lang.String getLastSuspendedTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Last suspended timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_suspended_timestamp = 356275337;</code>
   *
   * @return The bytes for lastSuspendedTimestamp.
   */
  com.google.protobuf.ByteString getLastSuspendedTimestampBytes();

  /**
   *
   *
   * <pre>
   * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return Whether the machineType field is set.
   */
  boolean hasMachineType();
  /**
   *
   *
   * <pre>
   * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The machineType.
   */
  java.lang.String getMachineType();
  /**
   *
   *
   * <pre>
   * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The bytes for machineType.
   */
  com.google.protobuf.ByteString getMachineTypeBytes();

  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return Whether the metadata field is set.
   */
  boolean hasMetadata();
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return The metadata.
   */
  com.google.cloud.compute.v1.Metadata getMetadata();
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   */
  com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return Whether the minCpuPlatform field is set.
   */
  boolean hasMinCpuPlatform();
  /**
   *
   *
   * <pre>
   * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The minCpuPlatform.
   */
  java.lang.String getMinCpuPlatform();
  /**
   *
   *
   * <pre>
   * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  com.google.protobuf.ByteString getMinCpuPlatformBytes();

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList();
  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index);
  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  int getNetworkInterfacesCount();
  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
      getNetworkInterfacesOrBuilderList();
  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(int index);

  /**
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   *
   * @return Whether the networkPerformanceConfig field is set.
   */
  boolean hasNetworkPerformanceConfig();
  /**
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   *
   * @return The networkPerformanceConfig.
   */
  com.google.cloud.compute.v1.NetworkPerformanceConfig getNetworkPerformanceConfig();
  /**
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   */
  com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder
      getNetworkPerformanceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
   *
   * @return Whether the params field is set.
   */
  boolean hasParams();
  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
   *
   * @return The params.
   */
  com.google.cloud.compute.v1.InstanceParams getParams();
  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
   */
  com.google.cloud.compute.v1.InstanceParamsOrBuilder getParamsOrBuilder();

  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return Whether the privateIpv6GoogleAccess field is set.
   */
  boolean hasPrivateIpv6GoogleAccess();
  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The privateIpv6GoogleAccess.
   */
  java.lang.String getPrivateIpv6GoogleAccess();
  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The bytes for privateIpv6GoogleAccess.
   */
  com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes();

  /**
   *
   *
   * <pre>
   * Specifies the reservations that this instance can consume from.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   *
   * @return Whether the reservationAffinity field is set.
   */
  boolean hasReservationAffinity();
  /**
   *
   *
   * <pre>
   * Specifies the reservations that this instance can consume from.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   *
   * @return The reservationAffinity.
   */
  com.google.cloud.compute.v1.ReservationAffinity getReservationAffinity();
  /**
   *
   *
   * <pre>
   * Specifies the reservations that this instance can consume from.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   */
  com.google.cloud.compute.v1.ReservationAffinityOrBuilder getReservationAffinityOrBuilder();

  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return A list containing the resourcePolicies.
   */
  java.util.List<java.lang.String> getResourcePoliciesList();
  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return The count of resourcePolicies.
   */
  int getResourcePoliciesCount();
  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the element to return.
   * @return The resourcePolicies at the given index.
   */
  java.lang.String getResourcePolicies(int index);
  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourcePolicies at the given index.
   */
  com.google.protobuf.ByteString getResourcePoliciesBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
   *
   * @return Whether the resourceStatus field is set.
   */
  boolean hasResourceStatus();
  /**
   *
   *
   * <pre>
   * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
   *
   * @return The resourceStatus.
   */
  com.google.cloud.compute.v1.ResourceStatus getResourceStatus();
  /**
   *
   *
   * <pre>
   * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
   */
  com.google.cloud.compute.v1.ResourceStatusOrBuilder getResourceStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  boolean hasSatisfiesPzs();
  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * Sets the scheduling options for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return Whether the scheduling field is set.
   */
  boolean hasScheduling();
  /**
   *
   *
   * <pre>
   * Sets the scheduling options for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return The scheduling.
   */
  com.google.cloud.compute.v1.Scheduling getScheduling();
  /**
   *
   *
   * <pre>
   * Sets the scheduling options for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   */
  com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList();
  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index);
  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  int getServiceAccountsCount();
  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
      getServiceAccountsOrBuilderList();
  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(int index);

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  boolean hasShieldedInstanceConfig();
  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   *
   * @return The shieldedInstanceConfig.
   */
  com.google.cloud.compute.v1.ShieldedInstanceConfig getShieldedInstanceConfig();
  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   */
  com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder getShieldedInstanceConfigOrBuilder();

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
   * </code>
   *
   * @return Whether the shieldedInstanceIntegrityPolicy field is set.
   */
  boolean hasShieldedInstanceIntegrityPolicy();
  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
   * </code>
   *
   * @return The shieldedInstanceIntegrityPolicy.
   */
  com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy getShieldedInstanceIntegrityPolicy();
  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
   * </code>
   */
  com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicyOrBuilder
      getShieldedInstanceIntegrityPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Source machine image
   * </pre>
   *
   * <code>optional string source_machine_image = 21769791;</code>
   *
   * @return Whether the sourceMachineImage field is set.
   */
  boolean hasSourceMachineImage();
  /**
   *
   *
   * <pre>
   * Source machine image
   * </pre>
   *
   * <code>optional string source_machine_image = 21769791;</code>
   *
   * @return The sourceMachineImage.
   */
  java.lang.String getSourceMachineImage();
  /**
   *
   *
   * <pre>
   * Source machine image
   * </pre>
   *
   * <code>optional string source_machine_image = 21769791;</code>
   *
   * @return The bytes for sourceMachineImage.
   */
  com.google.protobuf.ByteString getSourceMachineImageBytes();

  /**
   *
   *
   * <pre>
   * Source machine image encryption key when creating an instance from a machine image.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
   * </code>
   *
   * @return Whether the sourceMachineImageEncryptionKey field is set.
   */
  boolean hasSourceMachineImageEncryptionKey();
  /**
   *
   *
   * <pre>
   * Source machine image encryption key when creating an instance from a machine image.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
   * </code>
   *
   * @return The sourceMachineImageEncryptionKey.
   */
  com.google.cloud.compute.v1.CustomerEncryptionKey getSourceMachineImageEncryptionKey();
  /**
   *
   *
   * <pre>
   * Source machine image encryption key when creating an instance from a machine image.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
   * </code>
   */
  com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceMachineImageEncryptionKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
   * </pre>
   *
   * <code>optional bool start_restricted = 123693144;</code>
   *
   * @return Whether the startRestricted field is set.
   */
  boolean hasStartRestricted();
  /**
   *
   *
   * <pre>
   * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
   * </pre>
   *
   * <code>optional bool start_restricted = 123693144;</code>
   *
   * @return The startRestricted.
   */
  boolean getStartRestricted();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  java.lang.String getStatus();
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  com.google.protobuf.ByteString getStatusBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  boolean hasStatusMessage();
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  java.lang.String getStatusMessage();
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  com.google.protobuf.ByteString getStatusMessageBytes();

  /**
   *
   *
   * <pre>
   * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return Whether the tags field is set.
   */
  boolean hasTags();
  /**
   *
   *
   * <pre>
   * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return The tags.
   */
  com.google.cloud.compute.v1.Tags getTags();
  /**
   *
   *
   * <pre>
   * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   */
  com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  boolean hasZone();
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  java.lang.String getZone();
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  com.google.protobuf.ByteString getZoneBytes();
}
