/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an Interconnect Attachment (VLAN) resource. You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read Creating VLAN Attachments.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectAttachment}
 */
public final class InterconnectAttachment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectAttachment)
    InterconnectAttachmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InterconnectAttachment.newBuilder() to construct.
  private InterconnectAttachment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectAttachment() {
    bandwidth_ = "";
    candidateIpv6Subnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
    candidateSubnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
    cloudRouterIpAddress_ = "";
    cloudRouterIpv6Address_ = "";
    cloudRouterIpv6InterfaceId_ = "";
    creationTimestamp_ = "";
    customerRouterIpAddress_ = "";
    customerRouterIpv6Address_ = "";
    customerRouterIpv6InterfaceId_ = "";
    description_ = "";
    edgeAvailabilityDomain_ = "";
    encryption_ = "";
    googleReferenceId_ = "";
    interconnect_ = "";
    ipsecInternalAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    kind_ = "";
    labelFingerprint_ = "";
    name_ = "";
    operationalStatus_ = "";
    pairingKey_ = "";
    region_ = "";
    remoteService_ = "";
    router_ = "";
    selfLink_ = "";
    stackType_ = "";
    state_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectAttachment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachment_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectAttachment.class,
            com.google.cloud.compute.v1.InterconnectAttachment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.Bandwidth}
   */
  public enum Bandwidth implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BANDWIDTH = 0;</code>
     */
    UNDEFINED_BANDWIDTH(0),
    /**
     *
     *
     * <pre>
     * 100 Mbit/s
     * </pre>
     *
     * <code>BPS_100M = 49547958;</code>
     */
    BPS_100M(49547958),
    /**
     *
     *
     * <pre>
     * 10 Gbit/s
     * </pre>
     *
     * <code>BPS_10G = 278693006;</code>
     */
    BPS_10G(278693006),
    /**
     *
     *
     * <pre>
     * 1 Gbit/s
     * </pre>
     *
     * <code>BPS_1G = 355358448;</code>
     */
    BPS_1G(355358448),
    /**
     *
     *
     * <pre>
     * 200 Mbit/s
     * </pre>
     *
     * <code>BPS_200M = 49577749;</code>
     */
    BPS_200M(49577749),
    /**
     *
     *
     * <pre>
     * 20 Gbit/s
     * </pre>
     *
     * <code>BPS_20G = 278693967;</code>
     */
    BPS_20G(278693967),
    /**
     *
     *
     * <pre>
     * 2 Gbit/s
     * </pre>
     *
     * <code>BPS_2G = 355358479;</code>
     */
    BPS_2G(355358479),
    /**
     *
     *
     * <pre>
     * 300 Mbit/s
     * </pre>
     *
     * <code>BPS_300M = 49607540;</code>
     */
    BPS_300M(49607540),
    /**
     *
     *
     * <pre>
     * 400 Mbit/s
     * </pre>
     *
     * <code>BPS_400M = 49637331;</code>
     */
    BPS_400M(49637331),
    /**
     *
     *
     * <pre>
     * 500 Mbit/s
     * </pre>
     *
     * <code>BPS_500M = 49667122;</code>
     */
    BPS_500M(49667122),
    /**
     *
     *
     * <pre>
     * 50 Gbit/s
     * </pre>
     *
     * <code>BPS_50G = 278696850;</code>
     */
    BPS_50G(278696850),
    /**
     *
     *
     * <pre>
     * 50 Mbit/s
     * </pre>
     *
     * <code>BPS_50M = 278696856;</code>
     */
    BPS_50M(278696856),
    /**
     *
     *
     * <pre>
     * 5 Gbit/s
     * </pre>
     *
     * <code>BPS_5G = 355358572;</code>
     */
    BPS_5G(355358572),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BANDWIDTH = 0;</code>
     */
    public static final int UNDEFINED_BANDWIDTH_VALUE = 0;
    /**
     *
     *
     * <pre>
     * 100 Mbit/s
     * </pre>
     *
     * <code>BPS_100M = 49547958;</code>
     */
    public static final int BPS_100M_VALUE = 49547958;
    /**
     *
     *
     * <pre>
     * 10 Gbit/s
     * </pre>
     *
     * <code>BPS_10G = 278693006;</code>
     */
    public static final int BPS_10G_VALUE = 278693006;
    /**
     *
     *
     * <pre>
     * 1 Gbit/s
     * </pre>
     *
     * <code>BPS_1G = 355358448;</code>
     */
    public static final int BPS_1G_VALUE = 355358448;
    /**
     *
     *
     * <pre>
     * 200 Mbit/s
     * </pre>
     *
     * <code>BPS_200M = 49577749;</code>
     */
    public static final int BPS_200M_VALUE = 49577749;
    /**
     *
     *
     * <pre>
     * 20 Gbit/s
     * </pre>
     *
     * <code>BPS_20G = 278693967;</code>
     */
    public static final int BPS_20G_VALUE = 278693967;
    /**
     *
     *
     * <pre>
     * 2 Gbit/s
     * </pre>
     *
     * <code>BPS_2G = 355358479;</code>
     */
    public static final int BPS_2G_VALUE = 355358479;
    /**
     *
     *
     * <pre>
     * 300 Mbit/s
     * </pre>
     *
     * <code>BPS_300M = 49607540;</code>
     */
    public static final int BPS_300M_VALUE = 49607540;
    /**
     *
     *
     * <pre>
     * 400 Mbit/s
     * </pre>
     *
     * <code>BPS_400M = 49637331;</code>
     */
    public static final int BPS_400M_VALUE = 49637331;
    /**
     *
     *
     * <pre>
     * 500 Mbit/s
     * </pre>
     *
     * <code>BPS_500M = 49667122;</code>
     */
    public static final int BPS_500M_VALUE = 49667122;
    /**
     *
     *
     * <pre>
     * 50 Gbit/s
     * </pre>
     *
     * <code>BPS_50G = 278696850;</code>
     */
    public static final int BPS_50G_VALUE = 278696850;
    /**
     *
     *
     * <pre>
     * 50 Mbit/s
     * </pre>
     *
     * <code>BPS_50M = 278696856;</code>
     */
    public static final int BPS_50M_VALUE = 278696856;
    /**
     *
     *
     * <pre>
     * 5 Gbit/s
     * </pre>
     *
     * <code>BPS_5G = 355358572;</code>
     */
    public static final int BPS_5G_VALUE = 355358572;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Bandwidth valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Bandwidth forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BANDWIDTH;
        case 49547958:
          return BPS_100M;
        case 278693006:
          return BPS_10G;
        case 355358448:
          return BPS_1G;
        case 49577749:
          return BPS_200M;
        case 278693967:
          return BPS_20G;
        case 355358479:
          return BPS_2G;
        case 49607540:
          return BPS_300M;
        case 49637331:
          return BPS_400M;
        case 49667122:
          return BPS_500M;
        case 278696850:
          return BPS_50G;
        case 278696856:
          return BPS_50M;
        case 355358572:
          return BPS_5G;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Bandwidth> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Bandwidth> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Bandwidth>() {
          public Bandwidth findValueByNumber(int number) {
            return Bandwidth.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Bandwidth[] VALUES = values();

    public static Bandwidth valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Bandwidth(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.Bandwidth)
  }

  /**
   *
   *
   * <pre>
   * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.EdgeAvailabilityDomain}
   */
  public enum EdgeAvailabilityDomain implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_EDGE_AVAILABILITY_DOMAIN = 0;</code>
     */
    UNDEFINED_EDGE_AVAILABILITY_DOMAIN(0),
    /** <code>AVAILABILITY_DOMAIN_1 = 349552090;</code> */
    AVAILABILITY_DOMAIN_1(349552090),
    /** <code>AVAILABILITY_DOMAIN_2 = 349552091;</code> */
    AVAILABILITY_DOMAIN_2(349552091),
    /** <code>AVAILABILITY_DOMAIN_ANY = 375256373;</code> */
    AVAILABILITY_DOMAIN_ANY(375256373),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_EDGE_AVAILABILITY_DOMAIN = 0;</code>
     */
    public static final int UNDEFINED_EDGE_AVAILABILITY_DOMAIN_VALUE = 0;
    /** <code>AVAILABILITY_DOMAIN_1 = 349552090;</code> */
    public static final int AVAILABILITY_DOMAIN_1_VALUE = 349552090;
    /** <code>AVAILABILITY_DOMAIN_2 = 349552091;</code> */
    public static final int AVAILABILITY_DOMAIN_2_VALUE = 349552091;
    /** <code>AVAILABILITY_DOMAIN_ANY = 375256373;</code> */
    public static final int AVAILABILITY_DOMAIN_ANY_VALUE = 375256373;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EdgeAvailabilityDomain valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EdgeAvailabilityDomain forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_EDGE_AVAILABILITY_DOMAIN;
        case 349552090:
          return AVAILABILITY_DOMAIN_1;
        case 349552091:
          return AVAILABILITY_DOMAIN_2;
        case 375256373:
          return AVAILABILITY_DOMAIN_ANY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EdgeAvailabilityDomain>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EdgeAvailabilityDomain>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EdgeAvailabilityDomain>() {
              public EdgeAvailabilityDomain findValueByNumber(int number) {
                return EdgeAvailabilityDomain.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final EdgeAvailabilityDomain[] VALUES = values();

    public static EdgeAvailabilityDomain valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EdgeAvailabilityDomain(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.EdgeAvailabilityDomain)
  }

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.Encryption}
   */
  public enum Encryption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENCRYPTION = 0;</code>
     */
    UNDEFINED_ENCRYPTION(0),
    /**
     *
     *
     * <pre>
     * The interconnect attachment will carry only encrypted traffic that is encrypted by an IPsec device such as HA VPN gateway; VMs cannot directly send traffic to or receive traffic from such an interconnect attachment. To use HA VPN over Cloud Interconnect, the interconnect attachment must be created with this option.
     * </pre>
     *
     * <code>IPSEC = 69882282;</code>
     */
    IPSEC(69882282),
    /**
     *
     *
     * <pre>
     * This is the default value, which means the Interconnect Attachment will carry unencrypted traffic. VMs will be able to send traffic to or receive traffic from such interconnect attachment.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENCRYPTION = 0;</code>
     */
    public static final int UNDEFINED_ENCRYPTION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The interconnect attachment will carry only encrypted traffic that is encrypted by an IPsec device such as HA VPN gateway; VMs cannot directly send traffic to or receive traffic from such an interconnect attachment. To use HA VPN over Cloud Interconnect, the interconnect attachment must be created with this option.
     * </pre>
     *
     * <code>IPSEC = 69882282;</code>
     */
    public static final int IPSEC_VALUE = 69882282;
    /**
     *
     *
     * <pre>
     * This is the default value, which means the Interconnect Attachment will carry unencrypted traffic. VMs will be able to send traffic to or receive traffic from such interconnect attachment.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Encryption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Encryption forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ENCRYPTION;
        case 69882282:
          return IPSEC;
        case 2402104:
          return NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Encryption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Encryption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Encryption>() {
          public Encryption findValueByNumber(int number) {
            return Encryption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final Encryption[] VALUES = values();

    public static Encryption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Encryption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.Encryption)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.OperationalStatus}
   */
  public enum OperationalStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_OPERATIONAL_STATUS = 0;</code>
     */
    UNDEFINED_OPERATIONAL_STATUS(0),
    /**
     *
     *
     * <pre>
     * Indicates that attachment has been turned up and is ready to use.
     * </pre>
     *
     * <code>OS_ACTIVE = 55721409;</code>
     */
    OS_ACTIVE(55721409),
    /**
     *
     *
     * <pre>
     * Indicates that attachment is not ready to use yet, because turnup is not complete.
     * </pre>
     *
     * <code>OS_UNPROVISIONED = 239771840;</code>
     */
    OS_UNPROVISIONED(239771840),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_OPERATIONAL_STATUS = 0;</code>
     */
    public static final int UNDEFINED_OPERATIONAL_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that attachment has been turned up and is ready to use.
     * </pre>
     *
     * <code>OS_ACTIVE = 55721409;</code>
     */
    public static final int OS_ACTIVE_VALUE = 55721409;
    /**
     *
     *
     * <pre>
     * Indicates that attachment is not ready to use yet, because turnup is not complete.
     * </pre>
     *
     * <code>OS_UNPROVISIONED = 239771840;</code>
     */
    public static final int OS_UNPROVISIONED_VALUE = 239771840;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationalStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OperationalStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_OPERATIONAL_STATUS;
        case 55721409:
          return OS_ACTIVE;
        case 239771840:
          return OS_UNPROVISIONED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>() {
              public OperationalStatus findValueByNumber(int number) {
                return OperationalStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(3);
    }

    private static final OperationalStatus[] VALUES = values();

    public static OperationalStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OperationalStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.OperationalStatus)
  }

  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.StackType}
   */
  public enum StackType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STACK_TYPE = 0;</code>
     */
    UNDEFINED_STACK_TYPE(0),
    /**
     *
     *
     * <pre>
     * The interconnect attachment can have both IPv4 and IPv6 addresses.
     * </pre>
     *
     * <code>IPV4_IPV6 = 22197249;</code>
     */
    IPV4_IPV6(22197249),
    /**
     *
     *
     * <pre>
     * The interconnect attachment will only be assigned IPv4 addresses.
     * </pre>
     *
     * <code>IPV4_ONLY = 22373798;</code>
     */
    IPV4_ONLY(22373798),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STACK_TYPE = 0;</code>
     */
    public static final int UNDEFINED_STACK_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The interconnect attachment can have both IPv4 and IPv6 addresses.
     * </pre>
     *
     * <code>IPV4_IPV6 = 22197249;</code>
     */
    public static final int IPV4_IPV6_VALUE = 22197249;
    /**
     *
     *
     * <pre>
     * The interconnect attachment will only be assigned IPv4 addresses.
     * </pre>
     *
     * <code>IPV4_ONLY = 22373798;</code>
     */
    public static final int IPV4_ONLY_VALUE = 22373798;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StackType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StackType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STACK_TYPE;
        case 22197249:
          return IPV4_IPV6;
        case 22373798:
          return IPV4_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StackType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StackType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<StackType>() {
          public StackType findValueByNumber(int number) {
            return StackType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(4);
    }

    private static final StackType[] VALUES = values();

    public static StackType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StackType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.StackType)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    UNDEFINED_STATE(0),
    /**
     *
     *
     * <pre>
     * Indicates that attachment has been turned up and is ready to use.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /**
     *
     *
     * <pre>
     * The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was wiped out, or because the other side of a Partner attachment was deleted.
     * </pre>
     *
     * <code>DEFUNCT = 115891759;</code>
     */
    DEFUNCT(115891759),
    /**
     *
     *
     * <pre>
     * A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
     * </pre>
     *
     * <code>PARTNER_REQUEST_RECEIVED = 513587304;</code>
     */
    PARTNER_REQUEST_RECEIVED(513587304),
    /**
     *
     *
     * <pre>
     * PARTNER or PARTNER_PROVIDER attachment that is waiting for the customer to activate.
     * </pre>
     *
     * <code>PENDING_CUSTOMER = 167494054;</code>
     */
    PENDING_CUSTOMER(167494054),
    /**
     *
     *
     * <pre>
     * A newly created PARTNER attachment that has not yet been configured on the Partner side.
     * </pre>
     *
     * <code>PENDING_PARTNER = 387890656;</code>
     */
    PENDING_PARTNER(387890656),
    /** <code>STATE_UNSPECIFIED = 470755401;</code> */
    STATE_UNSPECIFIED(470755401),
    /**
     *
     *
     * <pre>
     * Indicates that attachment is not ready to use yet, because turnup is not complete.
     * </pre>
     *
     * <code>UNPROVISIONED = 517333979;</code>
     */
    UNPROVISIONED(517333979),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    public static final int UNDEFINED_STATE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that attachment has been turned up and is ready to use.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;
    /**
     *
     *
     * <pre>
     * The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was wiped out, or because the other side of a Partner attachment was deleted.
     * </pre>
     *
     * <code>DEFUNCT = 115891759;</code>
     */
    public static final int DEFUNCT_VALUE = 115891759;
    /**
     *
     *
     * <pre>
     * A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
     * </pre>
     *
     * <code>PARTNER_REQUEST_RECEIVED = 513587304;</code>
     */
    public static final int PARTNER_REQUEST_RECEIVED_VALUE = 513587304;
    /**
     *
     *
     * <pre>
     * PARTNER or PARTNER_PROVIDER attachment that is waiting for the customer to activate.
     * </pre>
     *
     * <code>PENDING_CUSTOMER = 167494054;</code>
     */
    public static final int PENDING_CUSTOMER_VALUE = 167494054;
    /**
     *
     *
     * <pre>
     * A newly created PARTNER attachment that has not yet been configured on the Partner side.
     * </pre>
     *
     * <code>PENDING_PARTNER = 387890656;</code>
     */
    public static final int PENDING_PARTNER_VALUE = 387890656;
    /** <code>STATE_UNSPECIFIED = 470755401;</code> */
    public static final int STATE_UNSPECIFIED_VALUE = 470755401;
    /**
     *
     *
     * <pre>
     * Indicates that attachment is not ready to use yet, because turnup is not complete.
     * </pre>
     *
     * <code>UNPROVISIONED = 517333979;</code>
     */
    public static final int UNPROVISIONED_VALUE = 517333979;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATE;
        case 314733318:
          return ACTIVE;
        case 115891759:
          return DEFUNCT;
        case 513587304:
          return PARTNER_REQUEST_RECEIVED;
        case 167494054:
          return PENDING_CUSTOMER;
        case 387890656:
          return PENDING_PARTNER;
        case 470755401:
          return STATE_UNSPECIFIED;
        case 517333979:
          return UNPROVISIONED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(5);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.State)
  }

  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectAttachment.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * Attachment to a dedicated interconnect.
     * </pre>
     *
     * <code>DEDICATED = 258411983;</code>
     */
    DEDICATED(258411983),
    /**
     *
     *
     * <pre>
     * Attachment to a partner interconnect, created by the customer.
     * </pre>
     *
     * <code>PARTNER = 461924520;</code>
     */
    PARTNER(461924520),
    /**
     *
     *
     * <pre>
     * Attachment to a partner interconnect, created by the partner.
     * </pre>
     *
     * <code>PARTNER_PROVIDER = 483261352;</code>
     */
    PARTNER_PROVIDER(483261352),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Attachment to a dedicated interconnect.
     * </pre>
     *
     * <code>DEDICATED = 258411983;</code>
     */
    public static final int DEDICATED_VALUE = 258411983;
    /**
     *
     *
     * <pre>
     * Attachment to a partner interconnect, created by the customer.
     * </pre>
     *
     * <code>PARTNER = 461924520;</code>
     */
    public static final int PARTNER_VALUE = 461924520;
    /**
     *
     *
     * <pre>
     * Attachment to a partner interconnect, created by the partner.
     * </pre>
     *
     * <code>PARTNER_PROVIDER = 483261352;</code>
     */
    public static final int PARTNER_PROVIDER_VALUE = 483261352;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 258411983:
          return DEDICATED;
        case 461924520:
          return PARTNER;
        case 483261352:
          return PARTNER_PROVIDER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDescriptor()
          .getEnumTypes()
          .get(6);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachment.Type)
  }

  private int bitField0_;
  private int bitField1_;
  public static final int ADMIN_ENABLED_FIELD_NUMBER = 445675089;
  private boolean adminEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  @java.lang.Override
  public boolean hasAdminEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  @java.lang.Override
  public boolean getAdminEnabled() {
    return adminEnabled_;
  }

  public static final int BANDWIDTH_FIELD_NUMBER = 181715121;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bandwidth_ = "";
  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
   * Check the Bandwidth enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bandwidth = 181715121;</code>
   *
   * @return Whether the bandwidth field is set.
   */
  @java.lang.Override
  public boolean hasBandwidth() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
   * Check the Bandwidth enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bandwidth = 181715121;</code>
   *
   * @return The bandwidth.
   */
  @java.lang.Override
  public java.lang.String getBandwidth() {
    java.lang.Object ref = bandwidth_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bandwidth_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
   * Check the Bandwidth enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bandwidth = 181715121;</code>
   *
   * @return The bytes for bandwidth.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBandwidthBytes() {
    java.lang.Object ref = bandwidth_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bandwidth_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CANDIDATE_IPV6_SUBNETS_FIELD_NUMBER = 70682522;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList candidateIpv6Subnets_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @return A list containing the candidateIpv6Subnets.
   */
  public com.google.protobuf.ProtocolStringList getCandidateIpv6SubnetsList() {
    return candidateIpv6Subnets_;
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @return The count of candidateIpv6Subnets.
   */
  public int getCandidateIpv6SubnetsCount() {
    return candidateIpv6Subnets_.size();
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @param index The index of the element to return.
   * @return The candidateIpv6Subnets at the given index.
   */
  public java.lang.String getCandidateIpv6Subnets(int index) {
    return candidateIpv6Subnets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the candidateIpv6Subnets at the given index.
   */
  public com.google.protobuf.ByteString getCandidateIpv6SubnetsBytes(int index) {
    return candidateIpv6Subnets_.getByteString(index);
  }

  public static final int CANDIDATE_SUBNETS_FIELD_NUMBER = 237842938;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList candidateSubnets_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @return A list containing the candidateSubnets.
   */
  public com.google.protobuf.ProtocolStringList getCandidateSubnetsList() {
    return candidateSubnets_;
  }
  /**
   *
   *
   * <pre>
   * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @return The count of candidateSubnets.
   */
  public int getCandidateSubnetsCount() {
    return candidateSubnets_.size();
  }
  /**
   *
   *
   * <pre>
   * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @param index The index of the element to return.
   * @return The candidateSubnets at the given index.
   */
  public java.lang.String getCandidateSubnets(int index) {
    return candidateSubnets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the candidateSubnets at the given index.
   */
  public com.google.protobuf.ByteString getCandidateSubnetsBytes(int index) {
    return candidateSubnets_.getByteString(index);
  }

  public static final int CLOUD_ROUTER_IP_ADDRESS_FIELD_NUMBER = 287392776;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudRouterIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ip_address = 287392776;</code>
   *
   * @return Whether the cloudRouterIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasCloudRouterIpAddress() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ip_address = 287392776;</code>
   *
   * @return The cloudRouterIpAddress.
   */
  @java.lang.Override
  public java.lang.String getCloudRouterIpAddress() {
    java.lang.Object ref = cloudRouterIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudRouterIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ip_address = 287392776;</code>
   *
   * @return The bytes for cloudRouterIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudRouterIpAddressBytes() {
    java.lang.Object ref = cloudRouterIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudRouterIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_ROUTER_IPV6_ADDRESS_FIELD_NUMBER = 451922376;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudRouterIpv6Address_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_address = 451922376;</code>
   *
   * @return Whether the cloudRouterIpv6Address field is set.
   */
  @java.lang.Override
  public boolean hasCloudRouterIpv6Address() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_address = 451922376;</code>
   *
   * @return The cloudRouterIpv6Address.
   */
  @java.lang.Override
  public java.lang.String getCloudRouterIpv6Address() {
    java.lang.Object ref = cloudRouterIpv6Address_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudRouterIpv6Address_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_address = 451922376;</code>
   *
   * @return The bytes for cloudRouterIpv6Address.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudRouterIpv6AddressBytes() {
    java.lang.Object ref = cloudRouterIpv6Address_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudRouterIpv6Address_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_ROUTER_IPV6_INTERFACE_ID_FIELD_NUMBER = 521282701;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudRouterIpv6InterfaceId_ = "";
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
   *
   * @return Whether the cloudRouterIpv6InterfaceId field is set.
   */
  @java.lang.Override
  public boolean hasCloudRouterIpv6InterfaceId() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
   *
   * @return The cloudRouterIpv6InterfaceId.
   */
  @java.lang.Override
  public java.lang.String getCloudRouterIpv6InterfaceId() {
    java.lang.Object ref = cloudRouterIpv6InterfaceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudRouterIpv6InterfaceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
   *
   * @return The bytes for cloudRouterIpv6InterfaceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudRouterIpv6InterfaceIdBytes() {
    java.lang.Object ref = cloudRouterIpv6InterfaceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudRouterIpv6InterfaceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIGURATION_CONSTRAINTS_FIELD_NUMBER = 179681389;
  private com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      configurationConstraints_;
  /**
   *
   *
   * <pre>
   * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
   * </code>
   *
   * @return Whether the configurationConstraints field is set.
   */
  @java.lang.Override
  public boolean hasConfigurationConstraints() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
   * </code>
   *
   * @return The configurationConstraints.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      getConfigurationConstraints() {
    return configurationConstraints_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
            .getDefaultInstance()
        : configurationConstraints_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder
      getConfigurationConstraintsOrBuilder() {
    return configurationConstraints_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
            .getDefaultInstance()
        : configurationConstraints_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_ROUTER_IP_ADDRESS_FIELD_NUMBER = 332475761;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customerRouterIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ip_address = 332475761;</code>
   *
   * @return Whether the customerRouterIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasCustomerRouterIpAddress() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ip_address = 332475761;</code>
   *
   * @return The customerRouterIpAddress.
   */
  @java.lang.Override
  public java.lang.String getCustomerRouterIpAddress() {
    java.lang.Object ref = customerRouterIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customerRouterIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ip_address = 332475761;</code>
   *
   * @return The bytes for customerRouterIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerRouterIpAddressBytes() {
    java.lang.Object ref = customerRouterIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customerRouterIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_ROUTER_IPV6_ADDRESS_FIELD_NUMBER = 290127089;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customerRouterIpv6Address_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_address = 290127089;</code>
   *
   * @return Whether the customerRouterIpv6Address field is set.
   */
  @java.lang.Override
  public boolean hasCustomerRouterIpv6Address() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_address = 290127089;</code>
   *
   * @return The customerRouterIpv6Address.
   */
  @java.lang.Override
  public java.lang.String getCustomerRouterIpv6Address() {
    java.lang.Object ref = customerRouterIpv6Address_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customerRouterIpv6Address_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_address = 290127089;</code>
   *
   * @return The bytes for customerRouterIpv6Address.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerRouterIpv6AddressBytes() {
    java.lang.Object ref = customerRouterIpv6Address_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customerRouterIpv6Address_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_ROUTER_IPV6_INTERFACE_ID_FIELD_NUMBER = 380994308;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customerRouterIpv6InterfaceId_ = "";
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
   *
   * @return Whether the customerRouterIpv6InterfaceId field is set.
   */
  @java.lang.Override
  public boolean hasCustomerRouterIpv6InterfaceId() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
   *
   * @return The customerRouterIpv6InterfaceId.
   */
  @java.lang.Override
  public java.lang.String getCustomerRouterIpv6InterfaceId() {
    java.lang.Object ref = customerRouterIpv6InterfaceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customerRouterIpv6InterfaceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
   *
   * @return The bytes for customerRouterIpv6InterfaceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerRouterIpv6InterfaceIdBytes() {
    java.lang.Object ref = customerRouterIpv6InterfaceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customerRouterIpv6InterfaceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATAPLANE_VERSION_FIELD_NUMBER = 34920075;
  private int dataplaneVersion_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
   * </pre>
   *
   * <code>optional int32 dataplane_version = 34920075;</code>
   *
   * @return Whether the dataplaneVersion field is set.
   */
  @java.lang.Override
  public boolean hasDataplaneVersion() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
   * </pre>
   *
   * <code>optional int32 dataplane_version = 34920075;</code>
   *
   * @return The dataplaneVersion.
   */
  @java.lang.Override
  public int getDataplaneVersion() {
    return dataplaneVersion_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EDGE_AVAILABILITY_DOMAIN_FIELD_NUMBER = 71289510;

  @SuppressWarnings("serial")
  private volatile java.lang.Object edgeAvailabilityDomain_ = "";
  /**
   *
   *
   * <pre>
   * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * Check the EdgeAvailabilityDomain enum for the list of possible values.
   * </pre>
   *
   * <code>optional string edge_availability_domain = 71289510;</code>
   *
   * @return Whether the edgeAvailabilityDomain field is set.
   */
  @java.lang.Override
  public boolean hasEdgeAvailabilityDomain() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * Check the EdgeAvailabilityDomain enum for the list of possible values.
   * </pre>
   *
   * <code>optional string edge_availability_domain = 71289510;</code>
   *
   * @return The edgeAvailabilityDomain.
   */
  @java.lang.Override
  public java.lang.String getEdgeAvailabilityDomain() {
    java.lang.Object ref = edgeAvailabilityDomain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      edgeAvailabilityDomain_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * Check the EdgeAvailabilityDomain enum for the list of possible values.
   * </pre>
   *
   * <code>optional string edge_availability_domain = 71289510;</code>
   *
   * @return The bytes for edgeAvailabilityDomain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEdgeAvailabilityDomainBytes() {
    java.lang.Object ref = edgeAvailabilityDomain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      edgeAvailabilityDomain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTION_FIELD_NUMBER = 97980291;

  @SuppressWarnings("serial")
  private volatile java.lang.Object encryption_ = "";
  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * Check the Encryption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string encryption = 97980291;</code>
   *
   * @return Whether the encryption field is set.
   */
  @java.lang.Override
  public boolean hasEncryption() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * Check the Encryption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string encryption = 97980291;</code>
   *
   * @return The encryption.
   */
  @java.lang.Override
  public java.lang.String getEncryption() {
    java.lang.Object ref = encryption_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      encryption_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * Check the Encryption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string encryption = 97980291;</code>
   *
   * @return The bytes for encryption.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEncryptionBytes() {
    java.lang.Object ref = encryption_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      encryption_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOOGLE_REFERENCE_ID_FIELD_NUMBER = 534944469;

  @SuppressWarnings("serial")
  private volatile java.lang.Object googleReferenceId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return Whether the googleReferenceId field is set.
   */
  @java.lang.Override
  public boolean hasGoogleReferenceId() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return The googleReferenceId.
   */
  @java.lang.Override
  public java.lang.String getGoogleReferenceId() {
    java.lang.Object ref = googleReferenceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      googleReferenceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return The bytes for googleReferenceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGoogleReferenceIdBytes() {
    java.lang.Object ref = googleReferenceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      googleReferenceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTERCONNECT_FIELD_NUMBER = 224601230;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interconnect_ = "";
  /**
   *
   *
   * <pre>
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return Whether the interconnect field is set.
   */
  @java.lang.Override
  public boolean hasInterconnect() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return The interconnect.
   */
  @java.lang.Override
  public java.lang.String getInterconnect() {
    java.lang.Object ref = interconnect_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interconnect_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return The bytes for interconnect.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterconnectBytes() {
    java.lang.Object ref = interconnect_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interconnect_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPSEC_INTERNAL_ADDRESSES_FIELD_NUMBER = 407648565;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ipsecInternalAddresses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @return A list containing the ipsecInternalAddresses.
   */
  public com.google.protobuf.ProtocolStringList getIpsecInternalAddressesList() {
    return ipsecInternalAddresses_;
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @return The count of ipsecInternalAddresses.
   */
  public int getIpsecInternalAddressesCount() {
    return ipsecInternalAddresses_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @param index The index of the element to return.
   * @return The ipsecInternalAddresses at the given index.
   */
  public java.lang.String getIpsecInternalAddresses(int index) {
    return ipsecInternalAddresses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ipsecInternalAddresses at the given index.
   */
  public com.google.protobuf.ByteString getIpsecInternalAddressesBytes(int index) {
    return ipsecInternalAddresses_.getByteString(index);
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_InterconnectAttachment_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MTU_FIELD_NUMBER = 108462;
  private int mtu_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
   * </pre>
   *
   * <code>optional int32 mtu = 108462;</code>
   *
   * @return Whether the mtu field is set.
   */
  @java.lang.Override
  public boolean hasMtu() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
   * </pre>
   *
   * <code>optional int32 mtu = 108462;</code>
   *
   * @return The mtu.
   */
  @java.lang.Override
  public int getMtu() {
    return mtu_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATIONAL_STATUS_FIELD_NUMBER = 201070847;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationalStatus_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return Whether the operationalStatus field is set.
   */
  @java.lang.Override
  public boolean hasOperationalStatus() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The operationalStatus.
   */
  @java.lang.Override
  public java.lang.String getOperationalStatus() {
    java.lang.Object ref = operationalStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationalStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The bytes for operationalStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationalStatusBytes() {
    java.lang.Object ref = operationalStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationalStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAIRING_KEY_FIELD_NUMBER = 439695464;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pairingKey_ = "";
  /**
   *
   *
   * <pre>
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
   * </pre>
   *
   * <code>optional string pairing_key = 439695464;</code>
   *
   * @return Whether the pairingKey field is set.
   */
  @java.lang.Override
  public boolean hasPairingKey() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
   * </pre>
   *
   * <code>optional string pairing_key = 439695464;</code>
   *
   * @return The pairingKey.
   */
  @java.lang.Override
  public java.lang.String getPairingKey() {
    java.lang.Object ref = pairingKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pairingKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
   * </pre>
   *
   * <code>optional string pairing_key = 439695464;</code>
   *
   * @return The bytes for pairingKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPairingKeyBytes() {
    java.lang.Object ref = pairingKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pairingKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTNER_ASN_FIELD_NUMBER = 438166149;
  private long partnerAsn_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>optional int64 partner_asn = 438166149;</code>
   *
   * @return Whether the partnerAsn field is set.
   */
  @java.lang.Override
  public boolean hasPartnerAsn() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>optional int64 partner_asn = 438166149;</code>
   *
   * @return The partnerAsn.
   */
  @java.lang.Override
  public long getPartnerAsn() {
    return partnerAsn_;
  }

  public static final int PARTNER_METADATA_FIELD_NUMBER = 65908934;
  private com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partnerMetadata_;
  /**
   *
   *
   * <pre>
   * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
   * </code>
   *
   * @return Whether the partnerMetadata field is set.
   */
  @java.lang.Override
  public boolean hasPartnerMetadata() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
   * </code>
   *
   * @return The partnerMetadata.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata getPartnerMetadata() {
    return partnerMetadata_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.getDefaultInstance()
        : partnerMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadataOrBuilder
      getPartnerMetadataOrBuilder() {
    return partnerMetadata_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.getDefaultInstance()
        : partnerMetadata_;
  }

  public static final int PRIVATE_INTERCONNECT_INFO_FIELD_NUMBER = 237270531;
  private com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo privateInterconnectInfo_;
  /**
   *
   *
   * <pre>
   * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
   * </code>
   *
   * @return Whether the privateInterconnectInfo field is set.
   */
  @java.lang.Override
  public boolean hasPrivateInterconnectInfo() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
   * </code>
   *
   * @return The privateInterconnectInfo.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo
      getPrivateInterconnectInfo() {
    return privateInterconnectInfo_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.getDefaultInstance()
        : privateInterconnectInfo_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfoOrBuilder
      getPrivateInterconnectInfoOrBuilder() {
    return privateInterconnectInfo_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.getDefaultInstance()
        : privateInterconnectInfo_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_SERVICE_FIELD_NUMBER = 391954364;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteService_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return Whether the remoteService field is set.
   */
  @java.lang.Override
  public boolean hasRemoteService() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return The remoteService.
   */
  @java.lang.Override
  public java.lang.String getRemoteService() {
    java.lang.Object ref = remoteService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return The bytes for remoteService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRemoteServiceBytes() {
    java.lang.Object ref = remoteService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTER_FIELD_NUMBER = 148608841;

  @SuppressWarnings("serial")
  private volatile java.lang.Object router_ = "";
  /**
   *
   *
   * <pre>
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return Whether the router field is set.
   */
  @java.lang.Override
  public boolean hasRouter() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return The router.
   */
  @java.lang.Override
  public java.lang.String getRouter() {
    java.lang.Object ref = router_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      router_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return The bytes for router.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouterBytes() {
    java.lang.Object ref = router_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      router_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 480964267;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STACK_TYPE_FIELD_NUMBER = 425908881;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stackType_ = "";
  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return Whether the stackType field is set.
   */
  @java.lang.Override
  public boolean hasStackType() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The stackType.
   */
  @java.lang.Override
  public java.lang.String getStackType() {
    java.lang.Object ref = stackType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stackType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The bytes for stackType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStackTypeBytes() {
    java.lang.Object ref = stackType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stackType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNET_LENGTH_FIELD_NUMBER = 279831048;
  private int subnetLength_ = 0;
  /**
   *
   *
   * <pre>
   * Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
   * </pre>
   *
   * <code>optional int32 subnet_length = 279831048;</code>
   *
   * @return Whether the subnetLength field is set.
   */
  @java.lang.Override
  public boolean hasSubnetLength() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
   * </pre>
   *
   * <code>optional int32 subnet_length = 279831048;</code>
   *
   * @return The subnetLength.
   */
  @java.lang.Override
  public int getSubnetLength() {
    return subnetLength_;
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField1_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VLAN_TAG8021Q_FIELD_NUMBER = 119927836;
  private int vlanTag8021Q_ = 0;
  /**
   *
   *
   * <pre>
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
   * </pre>
   *
   * <code>optional int32 vlan_tag8021q = 119927836;</code>
   *
   * @return Whether the vlanTag8021q field is set.
   */
  @java.lang.Override
  public boolean hasVlanTag8021Q() {
    return ((bitField1_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
   * </pre>
   *
   * <code>optional int32 vlan_tag8021q = 119927836;</code>
   *
   * @return The vlanTag8021q.
   */
  @java.lang.Override
  public int getVlanTag8021Q() {
    return vlanTag8021Q_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeInt32(108462, mtu_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt32(34920075, dataplaneVersion_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeMessage(65908934, getPartnerMetadata());
    }
    for (int i = 0; i < candidateIpv6Subnets_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 70682522, candidateIpv6Subnets_.getRaw(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 71289510, edgeAvailabilityDomain_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 97980291, encryption_);
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeInt32(119927836, vlanTag8021Q_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 148608841, router_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(179681389, getConfigurationConstraints());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181715121, bandwidth_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 201070847, operationalStatus_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 224601230, interconnect_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeMessage(237270531, getPrivateInterconnectInfo());
    }
    for (int i = 0; i < candidateSubnets_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 237842938, candidateSubnets_.getRaw(i));
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeInt32(279831048, subnetLength_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 287392776, cloudRouterIpAddress_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 290127089, customerRouterIpv6Address_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 332475761, customerRouterIpAddress_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 380994308, customerRouterIpv6InterfaceId_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 391954364, remoteService_);
    }
    for (int i = 0; i < ipsecInternalAddresses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 407648565, ipsecInternalAddresses_.getRaw(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 425908881, stackType_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeInt64(438166149, partnerAsn_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 439695464, pairingKey_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(445675089, adminEnabled_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 451922376, cloudRouterIpv6Address_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      output.writeBool(480964267, satisfiesPzs_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 521282701, cloudRouterIpv6InterfaceId_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 534944469, googleReferenceId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(108462, mtu_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(34920075, dataplaneVersion_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(65908934, getPartnerMetadata());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < candidateIpv6Subnets_.size(); i++) {
        dataSize += computeStringSizeNoTag(candidateIpv6Subnets_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getCandidateIpv6SubnetsList().size();
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              71289510, edgeAvailabilityDomain_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(97980291, encryption_);
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(119927836, vlanTag8021Q_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(148608841, router_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              179681389, getConfigurationConstraints());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181715121, bandwidth_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(201070847, operationalStatus_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(224601230, interconnect_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              237270531, getPrivateInterconnectInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < candidateSubnets_.size(); i++) {
        dataSize += computeStringSizeNoTag(candidateSubnets_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getCandidateSubnetsList().size();
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(279831048, subnetLength_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              287392776, cloudRouterIpAddress_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              290127089, customerRouterIpv6Address_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              332475761, customerRouterIpAddress_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              380994308, customerRouterIpv6InterfaceId_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(391954364, remoteService_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ipsecInternalAddresses_.size(); i++) {
        dataSize += computeStringSizeNoTag(ipsecInternalAddresses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getIpsecInternalAddressesList().size();
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(425908881, stackType_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(438166149, partnerAsn_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(439695464, pairingKey_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(445675089, adminEnabled_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              451922376, cloudRouterIpv6Address_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964267, satisfiesPzs_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              521282701, cloudRouterIpv6InterfaceId_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(534944469, googleReferenceId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectAttachment)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectAttachment other =
        (com.google.cloud.compute.v1.InterconnectAttachment) obj;

    if (hasAdminEnabled() != other.hasAdminEnabled()) return false;
    if (hasAdminEnabled()) {
      if (getAdminEnabled() != other.getAdminEnabled()) return false;
    }
    if (hasBandwidth() != other.hasBandwidth()) return false;
    if (hasBandwidth()) {
      if (!getBandwidth().equals(other.getBandwidth())) return false;
    }
    if (!getCandidateIpv6SubnetsList().equals(other.getCandidateIpv6SubnetsList())) return false;
    if (!getCandidateSubnetsList().equals(other.getCandidateSubnetsList())) return false;
    if (hasCloudRouterIpAddress() != other.hasCloudRouterIpAddress()) return false;
    if (hasCloudRouterIpAddress()) {
      if (!getCloudRouterIpAddress().equals(other.getCloudRouterIpAddress())) return false;
    }
    if (hasCloudRouterIpv6Address() != other.hasCloudRouterIpv6Address()) return false;
    if (hasCloudRouterIpv6Address()) {
      if (!getCloudRouterIpv6Address().equals(other.getCloudRouterIpv6Address())) return false;
    }
    if (hasCloudRouterIpv6InterfaceId() != other.hasCloudRouterIpv6InterfaceId()) return false;
    if (hasCloudRouterIpv6InterfaceId()) {
      if (!getCloudRouterIpv6InterfaceId().equals(other.getCloudRouterIpv6InterfaceId()))
        return false;
    }
    if (hasConfigurationConstraints() != other.hasConfigurationConstraints()) return false;
    if (hasConfigurationConstraints()) {
      if (!getConfigurationConstraints().equals(other.getConfigurationConstraints())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasCustomerRouterIpAddress() != other.hasCustomerRouterIpAddress()) return false;
    if (hasCustomerRouterIpAddress()) {
      if (!getCustomerRouterIpAddress().equals(other.getCustomerRouterIpAddress())) return false;
    }
    if (hasCustomerRouterIpv6Address() != other.hasCustomerRouterIpv6Address()) return false;
    if (hasCustomerRouterIpv6Address()) {
      if (!getCustomerRouterIpv6Address().equals(other.getCustomerRouterIpv6Address()))
        return false;
    }
    if (hasCustomerRouterIpv6InterfaceId() != other.hasCustomerRouterIpv6InterfaceId())
      return false;
    if (hasCustomerRouterIpv6InterfaceId()) {
      if (!getCustomerRouterIpv6InterfaceId().equals(other.getCustomerRouterIpv6InterfaceId()))
        return false;
    }
    if (hasDataplaneVersion() != other.hasDataplaneVersion()) return false;
    if (hasDataplaneVersion()) {
      if (getDataplaneVersion() != other.getDataplaneVersion()) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEdgeAvailabilityDomain() != other.hasEdgeAvailabilityDomain()) return false;
    if (hasEdgeAvailabilityDomain()) {
      if (!getEdgeAvailabilityDomain().equals(other.getEdgeAvailabilityDomain())) return false;
    }
    if (hasEncryption() != other.hasEncryption()) return false;
    if (hasEncryption()) {
      if (!getEncryption().equals(other.getEncryption())) return false;
    }
    if (hasGoogleReferenceId() != other.hasGoogleReferenceId()) return false;
    if (hasGoogleReferenceId()) {
      if (!getGoogleReferenceId().equals(other.getGoogleReferenceId())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInterconnect() != other.hasInterconnect()) return false;
    if (hasInterconnect()) {
      if (!getInterconnect().equals(other.getInterconnect())) return false;
    }
    if (!getIpsecInternalAddressesList().equals(other.getIpsecInternalAddressesList()))
      return false;
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasMtu() != other.hasMtu()) return false;
    if (hasMtu()) {
      if (getMtu() != other.getMtu()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasOperationalStatus() != other.hasOperationalStatus()) return false;
    if (hasOperationalStatus()) {
      if (!getOperationalStatus().equals(other.getOperationalStatus())) return false;
    }
    if (hasPairingKey() != other.hasPairingKey()) return false;
    if (hasPairingKey()) {
      if (!getPairingKey().equals(other.getPairingKey())) return false;
    }
    if (hasPartnerAsn() != other.hasPartnerAsn()) return false;
    if (hasPartnerAsn()) {
      if (getPartnerAsn() != other.getPartnerAsn()) return false;
    }
    if (hasPartnerMetadata() != other.hasPartnerMetadata()) return false;
    if (hasPartnerMetadata()) {
      if (!getPartnerMetadata().equals(other.getPartnerMetadata())) return false;
    }
    if (hasPrivateInterconnectInfo() != other.hasPrivateInterconnectInfo()) return false;
    if (hasPrivateInterconnectInfo()) {
      if (!getPrivateInterconnectInfo().equals(other.getPrivateInterconnectInfo())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasRemoteService() != other.hasRemoteService()) return false;
    if (hasRemoteService()) {
      if (!getRemoteService().equals(other.getRemoteService())) return false;
    }
    if (hasRouter() != other.hasRouter()) return false;
    if (hasRouter()) {
      if (!getRouter().equals(other.getRouter())) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStackType() != other.hasStackType()) return false;
    if (hasStackType()) {
      if (!getStackType().equals(other.getStackType())) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (hasSubnetLength() != other.hasSubnetLength()) return false;
    if (hasSubnetLength()) {
      if (getSubnetLength() != other.getSubnetLength()) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (hasVlanTag8021Q() != other.hasVlanTag8021Q()) return false;
    if (hasVlanTag8021Q()) {
      if (getVlanTag8021Q() != other.getVlanTag8021Q()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdminEnabled()) {
      hash = (37 * hash) + ADMIN_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminEnabled());
    }
    if (hasBandwidth()) {
      hash = (37 * hash) + BANDWIDTH_FIELD_NUMBER;
      hash = (53 * hash) + getBandwidth().hashCode();
    }
    if (getCandidateIpv6SubnetsCount() > 0) {
      hash = (37 * hash) + CANDIDATE_IPV6_SUBNETS_FIELD_NUMBER;
      hash = (53 * hash) + getCandidateIpv6SubnetsList().hashCode();
    }
    if (getCandidateSubnetsCount() > 0) {
      hash = (37 * hash) + CANDIDATE_SUBNETS_FIELD_NUMBER;
      hash = (53 * hash) + getCandidateSubnetsList().hashCode();
    }
    if (hasCloudRouterIpAddress()) {
      hash = (37 * hash) + CLOUD_ROUTER_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getCloudRouterIpAddress().hashCode();
    }
    if (hasCloudRouterIpv6Address()) {
      hash = (37 * hash) + CLOUD_ROUTER_IPV6_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getCloudRouterIpv6Address().hashCode();
    }
    if (hasCloudRouterIpv6InterfaceId()) {
      hash = (37 * hash) + CLOUD_ROUTER_IPV6_INTERFACE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCloudRouterIpv6InterfaceId().hashCode();
    }
    if (hasConfigurationConstraints()) {
      hash = (37 * hash) + CONFIGURATION_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConfigurationConstraints().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasCustomerRouterIpAddress()) {
      hash = (37 * hash) + CUSTOMER_ROUTER_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerRouterIpAddress().hashCode();
    }
    if (hasCustomerRouterIpv6Address()) {
      hash = (37 * hash) + CUSTOMER_ROUTER_IPV6_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerRouterIpv6Address().hashCode();
    }
    if (hasCustomerRouterIpv6InterfaceId()) {
      hash = (37 * hash) + CUSTOMER_ROUTER_IPV6_INTERFACE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerRouterIpv6InterfaceId().hashCode();
    }
    if (hasDataplaneVersion()) {
      hash = (37 * hash) + DATAPLANE_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getDataplaneVersion();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEdgeAvailabilityDomain()) {
      hash = (37 * hash) + EDGE_AVAILABILITY_DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + getEdgeAvailabilityDomain().hashCode();
    }
    if (hasEncryption()) {
      hash = (37 * hash) + ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getEncryption().hashCode();
    }
    if (hasGoogleReferenceId()) {
      hash = (37 * hash) + GOOGLE_REFERENCE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleReferenceId().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInterconnect()) {
      hash = (37 * hash) + INTERCONNECT_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnect().hashCode();
    }
    if (getIpsecInternalAddressesCount() > 0) {
      hash = (37 * hash) + IPSEC_INTERNAL_ADDRESSES_FIELD_NUMBER;
      hash = (53 * hash) + getIpsecInternalAddressesList().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasMtu()) {
      hash = (37 * hash) + MTU_FIELD_NUMBER;
      hash = (53 * hash) + getMtu();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasOperationalStatus()) {
      hash = (37 * hash) + OPERATIONAL_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getOperationalStatus().hashCode();
    }
    if (hasPairingKey()) {
      hash = (37 * hash) + PAIRING_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPairingKey().hashCode();
    }
    if (hasPartnerAsn()) {
      hash = (37 * hash) + PARTNER_ASN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPartnerAsn());
    }
    if (hasPartnerMetadata()) {
      hash = (37 * hash) + PARTNER_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getPartnerMetadata().hashCode();
    }
    if (hasPrivateInterconnectInfo()) {
      hash = (37 * hash) + PRIVATE_INTERCONNECT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateInterconnectInfo().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasRemoteService()) {
      hash = (37 * hash) + REMOTE_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getRemoteService().hashCode();
    }
    if (hasRouter()) {
      hash = (37 * hash) + ROUTER_FIELD_NUMBER;
      hash = (53 * hash) + getRouter().hashCode();
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStackType()) {
      hash = (37 * hash) + STACK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getStackType().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    if (hasSubnetLength()) {
      hash = (37 * hash) + SUBNET_LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetLength();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    if (hasVlanTag8021Q()) {
      hash = (37 * hash) + VLAN_TAG8021Q_FIELD_NUMBER;
      hash = (53 * hash) + getVlanTag8021Q();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InterconnectAttachment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an Interconnect Attachment (VLAN) resource. You can use Interconnect attachments (VLANS) to connect your Virtual Private Cloud networks to your on-premises networks through an Interconnect. For more information, read Creating VLAN Attachments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectAttachment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectAttachment)
      com.google.cloud.compute.v1.InterconnectAttachmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachment_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectAttachment.class,
              com.google.cloud.compute.v1.InterconnectAttachment.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectAttachment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigurationConstraintsFieldBuilder();
        getPartnerMetadataFieldBuilder();
        getPrivateInterconnectInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      adminEnabled_ = false;
      bandwidth_ = "";
      candidateIpv6Subnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      candidateSubnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      cloudRouterIpAddress_ = "";
      cloudRouterIpv6Address_ = "";
      cloudRouterIpv6InterfaceId_ = "";
      configurationConstraints_ = null;
      if (configurationConstraintsBuilder_ != null) {
        configurationConstraintsBuilder_.dispose();
        configurationConstraintsBuilder_ = null;
      }
      creationTimestamp_ = "";
      customerRouterIpAddress_ = "";
      customerRouterIpv6Address_ = "";
      customerRouterIpv6InterfaceId_ = "";
      dataplaneVersion_ = 0;
      description_ = "";
      edgeAvailabilityDomain_ = "";
      encryption_ = "";
      googleReferenceId_ = "";
      id_ = 0L;
      interconnect_ = "";
      ipsecInternalAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      mtu_ = 0;
      name_ = "";
      operationalStatus_ = "";
      pairingKey_ = "";
      partnerAsn_ = 0L;
      partnerMetadata_ = null;
      if (partnerMetadataBuilder_ != null) {
        partnerMetadataBuilder_.dispose();
        partnerMetadataBuilder_ = null;
      }
      privateInterconnectInfo_ = null;
      if (privateInterconnectInfoBuilder_ != null) {
        privateInterconnectInfoBuilder_.dispose();
        privateInterconnectInfoBuilder_ = null;
      }
      region_ = "";
      remoteService_ = "";
      router_ = "";
      satisfiesPzs_ = false;
      selfLink_ = "";
      stackType_ = "";
      state_ = "";
      subnetLength_ = 0;
      type_ = "";
      vlanTag8021Q_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachment getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectAttachment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachment build() {
      com.google.cloud.compute.v1.InterconnectAttachment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachment buildPartial() {
      com.google.cloud.compute.v1.InterconnectAttachment result =
          new com.google.cloud.compute.v1.InterconnectAttachment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectAttachment result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adminEnabled_ = adminEnabled_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bandwidth_ = bandwidth_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        candidateIpv6Subnets_.makeImmutable();
        result.candidateIpv6Subnets_ = candidateIpv6Subnets_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        candidateSubnets_.makeImmutable();
        result.candidateSubnets_ = candidateSubnets_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.cloudRouterIpAddress_ = cloudRouterIpAddress_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cloudRouterIpv6Address_ = cloudRouterIpv6Address_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cloudRouterIpv6InterfaceId_ = cloudRouterIpv6InterfaceId_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.configurationConstraints_ =
            configurationConstraintsBuilder_ == null
                ? configurationConstraints_
                : configurationConstraintsBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.customerRouterIpAddress_ = customerRouterIpAddress_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.customerRouterIpv6Address_ = customerRouterIpv6Address_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.customerRouterIpv6InterfaceId_ = customerRouterIpv6InterfaceId_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.dataplaneVersion_ = dataplaneVersion_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.edgeAvailabilityDomain_ = edgeAvailabilityDomain_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.encryption_ = encryption_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.googleReferenceId_ = googleReferenceId_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.interconnect_ = interconnect_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        ipsecInternalAddresses_.makeImmutable();
        result.ipsecInternalAddresses_ = ipsecInternalAddresses_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.mtu_ = mtu_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.operationalStatus_ = operationalStatus_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.pairingKey_ = pairingKey_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.partnerAsn_ = partnerAsn_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.partnerMetadata_ =
            partnerMetadataBuilder_ == null ? partnerMetadata_ : partnerMetadataBuilder_.build();
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.privateInterconnectInfo_ =
            privateInterconnectInfoBuilder_ == null
                ? privateInterconnectInfo_
                : privateInterconnectInfoBuilder_.build();
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.remoteService_ = remoteService_;
        to_bitField0_ |= 0x08000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.compute.v1.InterconnectAttachment result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.router_ = router_;
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x40000000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.stackType_ = stackType_;
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.state_ = state_;
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.subnetLength_ = subnetLength_;
        to_bitField1_ |= 0x00000002;
      }
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.type_ = type_;
        to_bitField1_ |= 0x00000004;
      }
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.vlanTag8021Q_ = vlanTag8021Q_;
        to_bitField1_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectAttachment) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectAttachment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectAttachment other) {
      if (other == com.google.cloud.compute.v1.InterconnectAttachment.getDefaultInstance())
        return this;
      if (other.hasAdminEnabled()) {
        setAdminEnabled(other.getAdminEnabled());
      }
      if (other.hasBandwidth()) {
        bandwidth_ = other.bandwidth_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.candidateIpv6Subnets_.isEmpty()) {
        if (candidateIpv6Subnets_.isEmpty()) {
          candidateIpv6Subnets_ = other.candidateIpv6Subnets_;
          bitField0_ |= 0x00000004;
        } else {
          ensureCandidateIpv6SubnetsIsMutable();
          candidateIpv6Subnets_.addAll(other.candidateIpv6Subnets_);
        }
        onChanged();
      }
      if (!other.candidateSubnets_.isEmpty()) {
        if (candidateSubnets_.isEmpty()) {
          candidateSubnets_ = other.candidateSubnets_;
          bitField0_ |= 0x00000008;
        } else {
          ensureCandidateSubnetsIsMutable();
          candidateSubnets_.addAll(other.candidateSubnets_);
        }
        onChanged();
      }
      if (other.hasCloudRouterIpAddress()) {
        cloudRouterIpAddress_ = other.cloudRouterIpAddress_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCloudRouterIpv6Address()) {
        cloudRouterIpv6Address_ = other.cloudRouterIpv6Address_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCloudRouterIpv6InterfaceId()) {
        cloudRouterIpv6InterfaceId_ = other.cloudRouterIpv6InterfaceId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasConfigurationConstraints()) {
        mergeConfigurationConstraints(other.getConfigurationConstraints());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasCustomerRouterIpAddress()) {
        customerRouterIpAddress_ = other.customerRouterIpAddress_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasCustomerRouterIpv6Address()) {
        customerRouterIpv6Address_ = other.customerRouterIpv6Address_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasCustomerRouterIpv6InterfaceId()) {
        customerRouterIpv6InterfaceId_ = other.customerRouterIpv6InterfaceId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasDataplaneVersion()) {
        setDataplaneVersion(other.getDataplaneVersion());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasEdgeAvailabilityDomain()) {
        edgeAvailabilityDomain_ = other.edgeAvailabilityDomain_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasEncryption()) {
        encryption_ = other.encryption_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasGoogleReferenceId()) {
        googleReferenceId_ = other.googleReferenceId_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInterconnect()) {
        interconnect_ = other.interconnect_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (!other.ipsecInternalAddresses_.isEmpty()) {
        if (ipsecInternalAddresses_.isEmpty()) {
          ipsecInternalAddresses_ = other.ipsecInternalAddresses_;
          bitField0_ |= 0x00080000;
        } else {
          ensureIpsecInternalAddressesIsMutable();
          ipsecInternalAddresses_.addAll(other.ipsecInternalAddresses_);
        }
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00400000;
      if (other.hasMtu()) {
        setMtu(other.getMtu());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.hasOperationalStatus()) {
        operationalStatus_ = other.operationalStatus_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (other.hasPairingKey()) {
        pairingKey_ = other.pairingKey_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.hasPartnerAsn()) {
        setPartnerAsn(other.getPartnerAsn());
      }
      if (other.hasPartnerMetadata()) {
        mergePartnerMetadata(other.getPartnerMetadata());
      }
      if (other.hasPrivateInterconnectInfo()) {
        mergePrivateInterconnectInfo(other.getPrivateInterconnectInfo());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (other.hasRemoteService()) {
        remoteService_ = other.remoteService_;
        bitField0_ |= 0x80000000;
        onChanged();
      }
      if (other.hasRouter()) {
        router_ = other.router_;
        bitField1_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField1_ |= 0x00000004;
        onChanged();
      }
      if (other.hasStackType()) {
        stackType_ = other.stackType_;
        bitField1_ |= 0x00000008;
        onChanged();
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField1_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSubnetLength()) {
        setSubnetLength(other.getSubnetLength());
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField1_ |= 0x00000040;
        onChanged();
      }
      if (other.hasVlanTag8021Q()) {
        setVlanTag8021Q(other.getVlanTag8021Q());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00020000;
                break;
              } // case 26840
            case 867696:
              {
                mtu_ = input.readInt32();
                bitField0_ |= 0x00800000;
                break;
              } // case 867696
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 26989658
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000040;
                break;
              } // case 28604882
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 244202930
            case 279360600:
              {
                dataplaneVersion_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case 279360600
            case 527271474:
              {
                input.readMessage(getPartnerMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 527271474
            case 565460178:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCandidateIpv6SubnetsIsMutable();
                candidateIpv6Subnets_.add(s);
                break;
              } // case 565460178
            case 570316082:
              {
                edgeAvailabilityDomain_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 570316082
            case 783842330:
              {
                encryption_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 783842330
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000010;
                break;
              } // case 878060682
            case 959422688:
              {
                vlanTag8021Q_ = input.readInt32();
                bitField1_ |= 0x00000080;
                break;
              } // case 959422688
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 1111570338
            case 1188870730:
              {
                router_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000001;
                break;
              } // case 1188870730
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 1424998602
            case 1437451114:
              {
                input.readMessage(
                    getConfigurationConstraintsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 1437451114
            case 1453720970:
              {
                bandwidth_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1453720970
            case 1608566778:
              {
                operationalStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 1608566778
            case 1796809842:
              {
                interconnect_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 1796809842
            case 1898164250:
              {
                input.readMessage(
                    getPrivateInterconnectInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 1898164250
            case 1902743506:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCandidateSubnetsIsMutable();
                candidateSubnets_.add(s);
                break;
              } // case 1902743506
            case -2056318912:
              {
                subnetLength_ = input.readInt32();
                bitField1_ |= 0x00000020;
                break;
              } // case -2056318912
            case -1995825086:
              {
                cloudRouterIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1995825086
            case -1973950582:
              {
                customerRouterIpv6Address_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -1973950582
            case -1635161206:
              {
                customerRouterIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -1635161206
            case -1247012830:
              {
                customerRouterIpv6InterfaceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -1247012830
            case -1159332382:
              {
                remoteService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x80000000;
                break;
              } // case -1159332382
            case -1033778774:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIpsecInternalAddressesIsMutable();
                ipsecInternalAddresses_.add(s);
                break;
              } // case -1033778774
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -911466526
            case -887696246:
              {
                stackType_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000008;
                break;
              } // case -887696246
            case -789638104:
              {
                partnerAsn_ = input.readInt64();
                bitField0_ |= 0x08000000;
                break;
              } // case -789638104
            case -777403582:
              {
                pairingKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case -777403582
            case -729566584:
              {
                adminEnabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -729566584
            case -679588286:
              {
                cloudRouterIpv6Address_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -679588286
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000004;
                break;
              } // case -645248918
            case -447253160:
              {
                satisfiesPzs_ = input.readBool();
                bitField1_ |= 0x00000002;
                break;
              } // case -447253160
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00400000;
                break;
              } // case -293404678
            case -124705686:
              {
                cloudRouterIpv6InterfaceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -124705686
            case -15411542:
              {
                googleReferenceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case -15411542
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private boolean adminEnabled_;
    /**
     *
     *
     * <pre>
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return Whether the adminEnabled field is set.
     */
    @java.lang.Override
    public boolean hasAdminEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return The adminEnabled.
     */
    @java.lang.Override
    public boolean getAdminEnabled() {
      return adminEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @param value The adminEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminEnabled(boolean value) {

      adminEnabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adminEnabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object bandwidth_ = "";
    /**
     *
     *
     * <pre>
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bandwidth = 181715121;</code>
     *
     * @return Whether the bandwidth field is set.
     */
    public boolean hasBandwidth() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bandwidth = 181715121;</code>
     *
     * @return The bandwidth.
     */
    public java.lang.String getBandwidth() {
      java.lang.Object ref = bandwidth_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bandwidth_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bandwidth = 181715121;</code>
     *
     * @return The bytes for bandwidth.
     */
    public com.google.protobuf.ByteString getBandwidthBytes() {
      java.lang.Object ref = bandwidth_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bandwidth_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bandwidth = 181715121;</code>
     *
     * @param value The bandwidth to set.
     * @return This builder for chaining.
     */
    public Builder setBandwidth(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bandwidth_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bandwidth = 181715121;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBandwidth() {
      bandwidth_ = getDefaultInstance().getBandwidth();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bandwidth = 181715121;</code>
     *
     * @param value The bytes for bandwidth to set.
     * @return This builder for chaining.
     */
    public Builder setBandwidthBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bandwidth_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList candidateIpv6Subnets_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCandidateIpv6SubnetsIsMutable() {
      if (!candidateIpv6Subnets_.isModifiable()) {
        candidateIpv6Subnets_ = new com.google.protobuf.LazyStringArrayList(candidateIpv6Subnets_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @return A list containing the candidateIpv6Subnets.
     */
    public com.google.protobuf.ProtocolStringList getCandidateIpv6SubnetsList() {
      candidateIpv6Subnets_.makeImmutable();
      return candidateIpv6Subnets_;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @return The count of candidateIpv6Subnets.
     */
    public int getCandidateIpv6SubnetsCount() {
      return candidateIpv6Subnets_.size();
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @param index The index of the element to return.
     * @return The candidateIpv6Subnets at the given index.
     */
    public java.lang.String getCandidateIpv6Subnets(int index) {
      return candidateIpv6Subnets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the candidateIpv6Subnets at the given index.
     */
    public com.google.protobuf.ByteString getCandidateIpv6SubnetsBytes(int index) {
      return candidateIpv6Subnets_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @param index The index to set the value at.
     * @param value The candidateIpv6Subnets to set.
     * @return This builder for chaining.
     */
    public Builder setCandidateIpv6Subnets(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCandidateIpv6SubnetsIsMutable();
      candidateIpv6Subnets_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @param value The candidateIpv6Subnets to add.
     * @return This builder for chaining.
     */
    public Builder addCandidateIpv6Subnets(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCandidateIpv6SubnetsIsMutable();
      candidateIpv6Subnets_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @param values The candidateIpv6Subnets to add.
     * @return This builder for chaining.
     */
    public Builder addAllCandidateIpv6Subnets(java.lang.Iterable<java.lang.String> values) {
      ensureCandidateIpv6SubnetsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidateIpv6Subnets_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCandidateIpv6Subnets() {
      candidateIpv6Subnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     *
     * @param value The bytes of the candidateIpv6Subnets to add.
     * @return This builder for chaining.
     */
    public Builder addCandidateIpv6SubnetsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCandidateIpv6SubnetsIsMutable();
      candidateIpv6Subnets_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList candidateSubnets_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCandidateSubnetsIsMutable() {
      if (!candidateSubnets_.isModifiable()) {
        candidateSubnets_ = new com.google.protobuf.LazyStringArrayList(candidateSubnets_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @return A list containing the candidateSubnets.
     */
    public com.google.protobuf.ProtocolStringList getCandidateSubnetsList() {
      candidateSubnets_.makeImmutable();
      return candidateSubnets_;
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @return The count of candidateSubnets.
     */
    public int getCandidateSubnetsCount() {
      return candidateSubnets_.size();
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @param index The index of the element to return.
     * @return The candidateSubnets at the given index.
     */
    public java.lang.String getCandidateSubnets(int index) {
      return candidateSubnets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the candidateSubnets at the given index.
     */
    public com.google.protobuf.ByteString getCandidateSubnetsBytes(int index) {
      return candidateSubnets_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @param index The index to set the value at.
     * @param value The candidateSubnets to set.
     * @return This builder for chaining.
     */
    public Builder setCandidateSubnets(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCandidateSubnetsIsMutable();
      candidateSubnets_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @param value The candidateSubnets to add.
     * @return This builder for chaining.
     */
    public Builder addCandidateSubnets(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCandidateSubnetsIsMutable();
      candidateSubnets_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @param values The candidateSubnets to add.
     * @return This builder for chaining.
     */
    public Builder addAllCandidateSubnets(java.lang.Iterable<java.lang.String> values) {
      ensureCandidateSubnetsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidateSubnets_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCandidateSubnets() {
      candidateSubnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
     * </pre>
     *
     * <code>repeated string candidate_subnets = 237842938;</code>
     *
     * @param value The bytes of the candidateSubnets to add.
     * @return This builder for chaining.
     */
    public Builder addCandidateSubnetsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCandidateSubnetsIsMutable();
      candidateSubnets_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object cloudRouterIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ip_address = 287392776;</code>
     *
     * @return Whether the cloudRouterIpAddress field is set.
     */
    public boolean hasCloudRouterIpAddress() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ip_address = 287392776;</code>
     *
     * @return The cloudRouterIpAddress.
     */
    public java.lang.String getCloudRouterIpAddress() {
      java.lang.Object ref = cloudRouterIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudRouterIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ip_address = 287392776;</code>
     *
     * @return The bytes for cloudRouterIpAddress.
     */
    public com.google.protobuf.ByteString getCloudRouterIpAddressBytes() {
      java.lang.Object ref = cloudRouterIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudRouterIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ip_address = 287392776;</code>
     *
     * @param value The cloudRouterIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setCloudRouterIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudRouterIpAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ip_address = 287392776;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudRouterIpAddress() {
      cloudRouterIpAddress_ = getDefaultInstance().getCloudRouterIpAddress();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ip_address = 287392776;</code>
     *
     * @param value The bytes for cloudRouterIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setCloudRouterIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudRouterIpAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object cloudRouterIpv6Address_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_address = 451922376;</code>
     *
     * @return Whether the cloudRouterIpv6Address field is set.
     */
    public boolean hasCloudRouterIpv6Address() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_address = 451922376;</code>
     *
     * @return The cloudRouterIpv6Address.
     */
    public java.lang.String getCloudRouterIpv6Address() {
      java.lang.Object ref = cloudRouterIpv6Address_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudRouterIpv6Address_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_address = 451922376;</code>
     *
     * @return The bytes for cloudRouterIpv6Address.
     */
    public com.google.protobuf.ByteString getCloudRouterIpv6AddressBytes() {
      java.lang.Object ref = cloudRouterIpv6Address_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudRouterIpv6Address_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_address = 451922376;</code>
     *
     * @param value The cloudRouterIpv6Address to set.
     * @return This builder for chaining.
     */
    public Builder setCloudRouterIpv6Address(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudRouterIpv6Address_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_address = 451922376;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudRouterIpv6Address() {
      cloudRouterIpv6Address_ = getDefaultInstance().getCloudRouterIpv6Address();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_address = 451922376;</code>
     *
     * @param value The bytes for cloudRouterIpv6Address to set.
     * @return This builder for chaining.
     */
    public Builder setCloudRouterIpv6AddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudRouterIpv6Address_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object cloudRouterIpv6InterfaceId_ = "";
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     *
     * @return Whether the cloudRouterIpv6InterfaceId field is set.
     */
    public boolean hasCloudRouterIpv6InterfaceId() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     *
     * @return The cloudRouterIpv6InterfaceId.
     */
    public java.lang.String getCloudRouterIpv6InterfaceId() {
      java.lang.Object ref = cloudRouterIpv6InterfaceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudRouterIpv6InterfaceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     *
     * @return The bytes for cloudRouterIpv6InterfaceId.
     */
    public com.google.protobuf.ByteString getCloudRouterIpv6InterfaceIdBytes() {
      java.lang.Object ref = cloudRouterIpv6InterfaceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudRouterIpv6InterfaceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     *
     * @param value The cloudRouterIpv6InterfaceId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudRouterIpv6InterfaceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudRouterIpv6InterfaceId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudRouterIpv6InterfaceId() {
      cloudRouterIpv6InterfaceId_ = getDefaultInstance().getCloudRouterIpv6InterfaceId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     *
     * @param value The bytes for cloudRouterIpv6InterfaceId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudRouterIpv6InterfaceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudRouterIpv6InterfaceId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
        configurationConstraints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder>
        configurationConstraintsBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     *
     * @return Whether the configurationConstraints field is set.
     */
    public boolean hasConfigurationConstraints() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     *
     * @return The configurationConstraints.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
        getConfigurationConstraints() {
      if (configurationConstraintsBuilder_ == null) {
        return configurationConstraints_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
                .getDefaultInstance()
            : configurationConstraints_;
      } else {
        return configurationConstraintsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    public Builder setConfigurationConstraints(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints value) {
      if (configurationConstraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configurationConstraints_ = value;
      } else {
        configurationConstraintsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    public Builder setConfigurationConstraints(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder
            builderForValue) {
      if (configurationConstraintsBuilder_ == null) {
        configurationConstraints_ = builderForValue.build();
      } else {
        configurationConstraintsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    public Builder mergeConfigurationConstraints(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints value) {
      if (configurationConstraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && configurationConstraints_ != null
            && configurationConstraints_
                != com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
                    .getDefaultInstance()) {
          getConfigurationConstraintsBuilder().mergeFrom(value);
        } else {
          configurationConstraints_ = value;
        }
      } else {
        configurationConstraintsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    public Builder clearConfigurationConstraints() {
      bitField0_ = (bitField0_ & ~0x00000080);
      configurationConstraints_ = null;
      if (configurationConstraintsBuilder_ != null) {
        configurationConstraintsBuilder_.dispose();
        configurationConstraintsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder
        getConfigurationConstraintsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getConfigurationConstraintsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder
        getConfigurationConstraintsOrBuilder() {
      if (configurationConstraintsBuilder_ != null) {
        return configurationConstraintsBuilder_.getMessageOrBuilder();
      } else {
        return configurationConstraints_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
                .getDefaultInstance()
            : configurationConstraints_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder>
        getConfigurationConstraintsFieldBuilder() {
      if (configurationConstraintsBuilder_ == null) {
        configurationConstraintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints,
                com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder,
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsOrBuilder>(
                getConfigurationConstraints(), getParentForChildren(), isClean());
        configurationConstraints_ = null;
      }
      return configurationConstraintsBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object customerRouterIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ip_address = 332475761;</code>
     *
     * @return Whether the customerRouterIpAddress field is set.
     */
    public boolean hasCustomerRouterIpAddress() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ip_address = 332475761;</code>
     *
     * @return The customerRouterIpAddress.
     */
    public java.lang.String getCustomerRouterIpAddress() {
      java.lang.Object ref = customerRouterIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customerRouterIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ip_address = 332475761;</code>
     *
     * @return The bytes for customerRouterIpAddress.
     */
    public com.google.protobuf.ByteString getCustomerRouterIpAddressBytes() {
      java.lang.Object ref = customerRouterIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customerRouterIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ip_address = 332475761;</code>
     *
     * @param value The customerRouterIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerRouterIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerRouterIpAddress_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ip_address = 332475761;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerRouterIpAddress() {
      customerRouterIpAddress_ = getDefaultInstance().getCustomerRouterIpAddress();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ip_address = 332475761;</code>
     *
     * @param value The bytes for customerRouterIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerRouterIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerRouterIpAddress_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object customerRouterIpv6Address_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_address = 290127089;</code>
     *
     * @return Whether the customerRouterIpv6Address field is set.
     */
    public boolean hasCustomerRouterIpv6Address() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_address = 290127089;</code>
     *
     * @return The customerRouterIpv6Address.
     */
    public java.lang.String getCustomerRouterIpv6Address() {
      java.lang.Object ref = customerRouterIpv6Address_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customerRouterIpv6Address_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_address = 290127089;</code>
     *
     * @return The bytes for customerRouterIpv6Address.
     */
    public com.google.protobuf.ByteString getCustomerRouterIpv6AddressBytes() {
      java.lang.Object ref = customerRouterIpv6Address_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customerRouterIpv6Address_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_address = 290127089;</code>
     *
     * @param value The customerRouterIpv6Address to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerRouterIpv6Address(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerRouterIpv6Address_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_address = 290127089;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerRouterIpv6Address() {
      customerRouterIpv6Address_ = getDefaultInstance().getCustomerRouterIpv6Address();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_address = 290127089;</code>
     *
     * @param value The bytes for customerRouterIpv6Address to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerRouterIpv6AddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerRouterIpv6Address_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object customerRouterIpv6InterfaceId_ = "";
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     *
     * @return Whether the customerRouterIpv6InterfaceId field is set.
     */
    public boolean hasCustomerRouterIpv6InterfaceId() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     *
     * @return The customerRouterIpv6InterfaceId.
     */
    public java.lang.String getCustomerRouterIpv6InterfaceId() {
      java.lang.Object ref = customerRouterIpv6InterfaceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customerRouterIpv6InterfaceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     *
     * @return The bytes for customerRouterIpv6InterfaceId.
     */
    public com.google.protobuf.ByteString getCustomerRouterIpv6InterfaceIdBytes() {
      java.lang.Object ref = customerRouterIpv6InterfaceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customerRouterIpv6InterfaceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     *
     * @param value The customerRouterIpv6InterfaceId to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerRouterIpv6InterfaceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerRouterIpv6InterfaceId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerRouterIpv6InterfaceId() {
      customerRouterIpv6InterfaceId_ = getDefaultInstance().getCustomerRouterIpv6InterfaceId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not available.
     * </pre>
     *
     * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     *
     * @param value The bytes for customerRouterIpv6InterfaceId to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerRouterIpv6InterfaceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerRouterIpv6InterfaceId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int dataplaneVersion_;
    /**
     *
     *
     * <pre>
     * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
     * </pre>
     *
     * <code>optional int32 dataplane_version = 34920075;</code>
     *
     * @return Whether the dataplaneVersion field is set.
     */
    @java.lang.Override
    public boolean hasDataplaneVersion() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
     * </pre>
     *
     * <code>optional int32 dataplane_version = 34920075;</code>
     *
     * @return The dataplaneVersion.
     */
    @java.lang.Override
    public int getDataplaneVersion() {
      return dataplaneVersion_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
     * </pre>
     *
     * <code>optional int32 dataplane_version = 34920075;</code>
     *
     * @param value The dataplaneVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDataplaneVersion(int value) {

      dataplaneVersion_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
     * </pre>
     *
     * <code>optional int32 dataplane_version = 34920075;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataplaneVersion() {
      bitField0_ = (bitField0_ & ~0x00001000);
      dataplaneVersion_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object edgeAvailabilityDomain_ = "";
    /**
     *
     *
     * <pre>
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     * </pre>
     *
     * <code>optional string edge_availability_domain = 71289510;</code>
     *
     * @return Whether the edgeAvailabilityDomain field is set.
     */
    public boolean hasEdgeAvailabilityDomain() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     * </pre>
     *
     * <code>optional string edge_availability_domain = 71289510;</code>
     *
     * @return The edgeAvailabilityDomain.
     */
    public java.lang.String getEdgeAvailabilityDomain() {
      java.lang.Object ref = edgeAvailabilityDomain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        edgeAvailabilityDomain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     * </pre>
     *
     * <code>optional string edge_availability_domain = 71289510;</code>
     *
     * @return The bytes for edgeAvailabilityDomain.
     */
    public com.google.protobuf.ByteString getEdgeAvailabilityDomainBytes() {
      java.lang.Object ref = edgeAvailabilityDomain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        edgeAvailabilityDomain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     * </pre>
     *
     * <code>optional string edge_availability_domain = 71289510;</code>
     *
     * @param value The edgeAvailabilityDomain to set.
     * @return This builder for chaining.
     */
    public Builder setEdgeAvailabilityDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      edgeAvailabilityDomain_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     * </pre>
     *
     * <code>optional string edge_availability_domain = 71289510;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEdgeAvailabilityDomain() {
      edgeAvailabilityDomain_ = getDefaultInstance().getEdgeAvailabilityDomain();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     * </pre>
     *
     * <code>optional string edge_availability_domain = 71289510;</code>
     *
     * @param value The bytes for edgeAvailabilityDomain to set.
     * @return This builder for chaining.
     */
    public Builder setEdgeAvailabilityDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      edgeAvailabilityDomain_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object encryption_ = "";
    /**
     *
     *
     * <pre>
     * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
     * Check the Encryption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string encryption = 97980291;</code>
     *
     * @return Whether the encryption field is set.
     */
    public boolean hasEncryption() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
     * Check the Encryption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string encryption = 97980291;</code>
     *
     * @return The encryption.
     */
    public java.lang.String getEncryption() {
      java.lang.Object ref = encryption_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        encryption_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
     * Check the Encryption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string encryption = 97980291;</code>
     *
     * @return The bytes for encryption.
     */
    public com.google.protobuf.ByteString getEncryptionBytes() {
      java.lang.Object ref = encryption_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        encryption_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
     * Check the Encryption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string encryption = 97980291;</code>
     *
     * @param value The encryption to set.
     * @return This builder for chaining.
     */
    public Builder setEncryption(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      encryption_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
     * Check the Encryption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string encryption = 97980291;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryption() {
      encryption_ = getDefaultInstance().getEncryption();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
     * Check the Encryption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string encryption = 97980291;</code>
     *
     * @param value The bytes for encryption to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      encryption_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object googleReferenceId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return Whether the googleReferenceId field is set.
     */
    public boolean hasGoogleReferenceId() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return The googleReferenceId.
     */
    public java.lang.String getGoogleReferenceId() {
      java.lang.Object ref = googleReferenceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        googleReferenceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return The bytes for googleReferenceId.
     */
    public com.google.protobuf.ByteString getGoogleReferenceIdBytes() {
      java.lang.Object ref = googleReferenceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        googleReferenceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @param value The googleReferenceId to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleReferenceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      googleReferenceId_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleReferenceId() {
      googleReferenceId_ = getDefaultInstance().getGoogleReferenceId();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @param value The bytes for googleReferenceId to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleReferenceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      googleReferenceId_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00020000);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object interconnect_ = "";
    /**
     *
     *
     * <pre>
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return Whether the interconnect field is set.
     */
    public boolean hasInterconnect() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return The interconnect.
     */
    public java.lang.String getInterconnect() {
      java.lang.Object ref = interconnect_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interconnect_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return The bytes for interconnect.
     */
    public com.google.protobuf.ByteString getInterconnectBytes() {
      java.lang.Object ref = interconnect_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interconnect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @param value The interconnect to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnect(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interconnect_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnect() {
      interconnect_ = getDefaultInstance().getInterconnect();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @param value The bytes for interconnect to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interconnect_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ipsecInternalAddresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIpsecInternalAddressesIsMutable() {
      if (!ipsecInternalAddresses_.isModifiable()) {
        ipsecInternalAddresses_ =
            new com.google.protobuf.LazyStringArrayList(ipsecInternalAddresses_);
      }
      bitField0_ |= 0x00080000;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @return A list containing the ipsecInternalAddresses.
     */
    public com.google.protobuf.ProtocolStringList getIpsecInternalAddressesList() {
      ipsecInternalAddresses_.makeImmutable();
      return ipsecInternalAddresses_;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @return The count of ipsecInternalAddresses.
     */
    public int getIpsecInternalAddressesCount() {
      return ipsecInternalAddresses_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @param index The index of the element to return.
     * @return The ipsecInternalAddresses at the given index.
     */
    public java.lang.String getIpsecInternalAddresses(int index) {
      return ipsecInternalAddresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipsecInternalAddresses at the given index.
     */
    public com.google.protobuf.ByteString getIpsecInternalAddressesBytes(int index) {
      return ipsecInternalAddresses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @param index The index to set the value at.
     * @param value The ipsecInternalAddresses to set.
     * @return This builder for chaining.
     */
    public Builder setIpsecInternalAddresses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpsecInternalAddressesIsMutable();
      ipsecInternalAddresses_.set(index, value);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @param value The ipsecInternalAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addIpsecInternalAddresses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpsecInternalAddressesIsMutable();
      ipsecInternalAddresses_.add(value);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @param values The ipsecInternalAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addAllIpsecInternalAddresses(java.lang.Iterable<java.lang.String> values) {
      ensureIpsecInternalAddressesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipsecInternalAddresses_);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpsecInternalAddresses() {
      ipsecInternalAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00080000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
     * </pre>
     *
     * <code>repeated string ipsec_internal_addresses = 407648565;</code>
     *
     * @param value The bytes of the ipsecInternalAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addIpsecInternalAddressesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIpsecInternalAddressesIsMutable();
      ipsecInternalAddresses_.add(value);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00400000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00400000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00400000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00400000;
      return this;
    }

    private int mtu_;
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @return Whether the mtu field is set.
     */
    @java.lang.Override
    public boolean hasMtu() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @return The mtu.
     */
    @java.lang.Override
    public int getMtu() {
      return mtu_;
    }
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @param value The mtu to set.
     * @return This builder for chaining.
     */
    public Builder setMtu(int value) {

      mtu_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMtu() {
      bitField0_ = (bitField0_ & ~0x00800000);
      mtu_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private java.lang.Object operationalStatus_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return Whether the operationalStatus field is set.
     */
    public boolean hasOperationalStatus() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return The operationalStatus.
     */
    public java.lang.String getOperationalStatus() {
      java.lang.Object ref = operationalStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationalStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return The bytes for operationalStatus.
     */
    public com.google.protobuf.ByteString getOperationalStatusBytes() {
      java.lang.Object ref = operationalStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationalStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @param value The operationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setOperationalStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationalStatus_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationalStatus() {
      operationalStatus_ = getDefaultInstance().getOperationalStatus();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @param value The bytes for operationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setOperationalStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationalStatus_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.lang.Object pairingKey_ = "";
    /**
     *
     *
     * <pre>
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     * </pre>
     *
     * <code>optional string pairing_key = 439695464;</code>
     *
     * @return Whether the pairingKey field is set.
     */
    public boolean hasPairingKey() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     * </pre>
     *
     * <code>optional string pairing_key = 439695464;</code>
     *
     * @return The pairingKey.
     */
    public java.lang.String getPairingKey() {
      java.lang.Object ref = pairingKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pairingKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     * </pre>
     *
     * <code>optional string pairing_key = 439695464;</code>
     *
     * @return The bytes for pairingKey.
     */
    public com.google.protobuf.ByteString getPairingKeyBytes() {
      java.lang.Object ref = pairingKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pairingKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     * </pre>
     *
     * <code>optional string pairing_key = 439695464;</code>
     *
     * @param value The pairingKey to set.
     * @return This builder for chaining.
     */
    public Builder setPairingKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pairingKey_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     * </pre>
     *
     * <code>optional string pairing_key = 439695464;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPairingKey() {
      pairingKey_ = getDefaultInstance().getPairingKey();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
     * </pre>
     *
     * <code>optional string pairing_key = 439695464;</code>
     *
     * @param value The bytes for pairingKey to set.
     * @return This builder for chaining.
     */
    public Builder setPairingKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pairingKey_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private long partnerAsn_;
    /**
     *
     *
     * <pre>
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>optional int64 partner_asn = 438166149;</code>
     *
     * @return Whether the partnerAsn field is set.
     */
    @java.lang.Override
    public boolean hasPartnerAsn() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>optional int64 partner_asn = 438166149;</code>
     *
     * @return The partnerAsn.
     */
    @java.lang.Override
    public long getPartnerAsn() {
      return partnerAsn_;
    }
    /**
     *
     *
     * <pre>
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>optional int64 partner_asn = 438166149;</code>
     *
     * @param value The partnerAsn to set.
     * @return This builder for chaining.
     */
    public Builder setPartnerAsn(long value) {

      partnerAsn_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>optional int64 partner_asn = 438166149;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartnerAsn() {
      bitField0_ = (bitField0_ & ~0x08000000);
      partnerAsn_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partnerMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata,
            com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadataOrBuilder>
        partnerMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     *
     * @return Whether the partnerMetadata field is set.
     */
    public boolean hasPartnerMetadata() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     *
     * @return The partnerMetadata.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata getPartnerMetadata() {
      if (partnerMetadataBuilder_ == null) {
        return partnerMetadata_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.getDefaultInstance()
            : partnerMetadata_;
      } else {
        return partnerMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    public Builder setPartnerMetadata(
        com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata value) {
      if (partnerMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partnerMetadata_ = value;
      } else {
        partnerMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    public Builder setPartnerMetadata(
        com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.Builder builderForValue) {
      if (partnerMetadataBuilder_ == null) {
        partnerMetadata_ = builderForValue.build();
      } else {
        partnerMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    public Builder mergePartnerMetadata(
        com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata value) {
      if (partnerMetadataBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && partnerMetadata_ != null
            && partnerMetadata_
                != com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata
                    .getDefaultInstance()) {
          getPartnerMetadataBuilder().mergeFrom(value);
        } else {
          partnerMetadata_ = value;
        }
      } else {
        partnerMetadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    public Builder clearPartnerMetadata() {
      bitField0_ = (bitField0_ & ~0x10000000);
      partnerMetadata_ = null;
      if (partnerMetadataBuilder_ != null) {
        partnerMetadataBuilder_.dispose();
        partnerMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.Builder
        getPartnerMetadataBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getPartnerMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadataOrBuilder
        getPartnerMetadataOrBuilder() {
      if (partnerMetadataBuilder_ != null) {
        return partnerMetadataBuilder_.getMessageOrBuilder();
      } else {
        return partnerMetadata_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.getDefaultInstance()
            : partnerMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata,
            com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadataOrBuilder>
        getPartnerMetadataFieldBuilder() {
      if (partnerMetadataBuilder_ == null) {
        partnerMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata,
                com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata.Builder,
                com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadataOrBuilder>(
                getPartnerMetadata(), getParentForChildren(), isClean());
        partnerMetadata_ = null;
      }
      return partnerMetadataBuilder_;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo privateInterconnectInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo,
            com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfoOrBuilder>
        privateInterconnectInfoBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     *
     * @return Whether the privateInterconnectInfo field is set.
     */
    public boolean hasPrivateInterconnectInfo() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     *
     * @return The privateInterconnectInfo.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo
        getPrivateInterconnectInfo() {
      if (privateInterconnectInfoBuilder_ == null) {
        return privateInterconnectInfo_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.getDefaultInstance()
            : privateInterconnectInfo_;
      } else {
        return privateInterconnectInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    public Builder setPrivateInterconnectInfo(
        com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo value) {
      if (privateInterconnectInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateInterconnectInfo_ = value;
      } else {
        privateInterconnectInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    public Builder setPrivateInterconnectInfo(
        com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.Builder builderForValue) {
      if (privateInterconnectInfoBuilder_ == null) {
        privateInterconnectInfo_ = builderForValue.build();
      } else {
        privateInterconnectInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    public Builder mergePrivateInterconnectInfo(
        com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo value) {
      if (privateInterconnectInfoBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && privateInterconnectInfo_ != null
            && privateInterconnectInfo_
                != com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo
                    .getDefaultInstance()) {
          getPrivateInterconnectInfoBuilder().mergeFrom(value);
        } else {
          privateInterconnectInfo_ = value;
        }
      } else {
        privateInterconnectInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    public Builder clearPrivateInterconnectInfo() {
      bitField0_ = (bitField0_ & ~0x20000000);
      privateInterconnectInfo_ = null;
      if (privateInterconnectInfoBuilder_ != null) {
        privateInterconnectInfoBuilder_.dispose();
        privateInterconnectInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.Builder
        getPrivateInterconnectInfoBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getPrivateInterconnectInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfoOrBuilder
        getPrivateInterconnectInfoOrBuilder() {
      if (privateInterconnectInfoBuilder_ != null) {
        return privateInterconnectInfoBuilder_.getMessageOrBuilder();
      } else {
        return privateInterconnectInfo_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.getDefaultInstance()
            : privateInterconnectInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo,
            com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfoOrBuilder>
        getPrivateInterconnectInfoFieldBuilder() {
      if (privateInterconnectInfoBuilder_ == null) {
        privateInterconnectInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo,
                com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo.Builder,
                com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfoOrBuilder>(
                getPrivateInterconnectInfo(), getParentForChildren(), isClean());
        privateInterconnectInfo_ = null;
      }
      return privateInterconnectInfoBuilder_;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private java.lang.Object remoteService_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return Whether the remoteService field is set.
     */
    public boolean hasRemoteService() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return The remoteService.
     */
    public java.lang.String getRemoteService() {
      java.lang.Object ref = remoteService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return The bytes for remoteService.
     */
    public com.google.protobuf.ByteString getRemoteServiceBytes() {
      java.lang.Object ref = remoteService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @param value The remoteService to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteService_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteService() {
      remoteService_ = getDefaultInstance().getRemoteService();
      bitField0_ = (bitField0_ & ~0x80000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @param value The bytes for remoteService to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteService_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    private java.lang.Object router_ = "";
    /**
     *
     *
     * <pre>
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return Whether the router field is set.
     */
    public boolean hasRouter() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return The router.
     */
    public java.lang.String getRouter() {
      java.lang.Object ref = router_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        router_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return The bytes for router.
     */
    public com.google.protobuf.ByteString getRouterBytes() {
      java.lang.Object ref = router_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        router_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @param value The router to set.
     * @return This builder for chaining.
     */
    public Builder setRouter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      router_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouter() {
      router_ = getDefaultInstance().getRouter();
      bitField1_ = (bitField1_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @param value The bytes for router to set.
     * @return This builder for chaining.
     */
    public Builder setRouterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      router_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField1_ = (bitField1_ & ~0x00000002);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField1_ = (bitField1_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object stackType_ = "";
    /**
     *
     *
     * <pre>
     * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return Whether the stackType field is set.
     */
    public boolean hasStackType() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return The stackType.
     */
    public java.lang.String getStackType() {
      java.lang.Object ref = stackType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stackType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return The bytes for stackType.
     */
    public com.google.protobuf.ByteString getStackTypeBytes() {
      java.lang.Object ref = stackType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stackType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @param value The stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stackType_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStackType() {
      stackType_ = getDefaultInstance().getStackType();
      bitField1_ = (bitField1_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @param value The bytes for stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stackType_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField1_ = (bitField1_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int subnetLength_;
    /**
     *
     *
     * <pre>
     * Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
     * </pre>
     *
     * <code>optional int32 subnet_length = 279831048;</code>
     *
     * @return Whether the subnetLength field is set.
     */
    @java.lang.Override
    public boolean hasSubnetLength() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
     * </pre>
     *
     * <code>optional int32 subnet_length = 279831048;</code>
     *
     * @return The subnetLength.
     */
    @java.lang.Override
    public int getSubnetLength() {
      return subnetLength_;
    }
    /**
     *
     *
     * <pre>
     * Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
     * </pre>
     *
     * <code>optional int32 subnet_length = 279831048;</code>
     *
     * @param value The subnetLength to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetLength(int value) {

      subnetLength_ = value;
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
     * </pre>
     *
     * <code>optional int32 subnet_length = 279831048;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetLength() {
      bitField1_ = (bitField1_ & ~0x00000020);
      subnetLength_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField1_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField1_ = (bitField1_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int vlanTag8021Q_;
    /**
     *
     *
     * <pre>
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
     * </pre>
     *
     * <code>optional int32 vlan_tag8021q = 119927836;</code>
     *
     * @return Whether the vlanTag8021q field is set.
     */
    @java.lang.Override
    public boolean hasVlanTag8021Q() {
      return ((bitField1_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
     * </pre>
     *
     * <code>optional int32 vlan_tag8021q = 119927836;</code>
     *
     * @return The vlanTag8021q.
     */
    @java.lang.Override
    public int getVlanTag8021Q() {
      return vlanTag8021Q_;
    }
    /**
     *
     *
     * <pre>
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
     * </pre>
     *
     * <code>optional int32 vlan_tag8021q = 119927836;</code>
     *
     * @param value The vlanTag8021q to set.
     * @return This builder for chaining.
     */
    public Builder setVlanTag8021Q(int value) {

      vlanTag8021Q_ = value;
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
     * </pre>
     *
     * <code>optional int32 vlan_tag8021q = 119927836;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVlanTag8021Q() {
      bitField1_ = (bitField1_ & ~0x00000080);
      vlanTag8021Q_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectAttachment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectAttachment)
  private static final com.google.cloud.compute.v1.InterconnectAttachment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectAttachment();
  }

  public static com.google.cloud.compute.v1.InterconnectAttachment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectAttachment> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectAttachment>() {
        @java.lang.Override
        public InterconnectAttachment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectAttachment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectAttachment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
