/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints}
 */
public final class InterconnectAttachmentConfigurationConstraints
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints)
    InterconnectAttachmentConfigurationConstraintsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InterconnectAttachmentConfigurationConstraints.newBuilder() to construct.
  private InterconnectAttachmentConfigurationConstraints(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectAttachmentConfigurationConstraints() {
    bgpMd5_ = "";
    bgpPeerAsnRanges_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectAttachmentConfigurationConstraints();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentConfigurationConstraints_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentConfigurationConstraints_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.class,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.BgpMd5}
   */
  public enum BgpMd5 implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BGP_MD5 = 0;</code>
     */
    UNDEFINED_BGP_MD5(0),
    /**
     *
     *
     * <pre>
     * MD5_OPTIONAL: BGP MD5 authentication is supported and can optionally be configured.
     * </pre>
     *
     * <code>MD5_OPTIONAL = 532156673;</code>
     */
    MD5_OPTIONAL(532156673),
    /**
     *
     *
     * <pre>
     * MD5_REQUIRED: BGP MD5 authentication must be configured.
     * </pre>
     *
     * <code>MD5_REQUIRED = 218034496;</code>
     */
    MD5_REQUIRED(218034496),
    /**
     *
     *
     * <pre>
     * MD5_UNSUPPORTED: BGP MD5 authentication must not be configured
     * </pre>
     *
     * <code>MD5_UNSUPPORTED = 86962388;</code>
     */
    MD5_UNSUPPORTED(86962388),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BGP_MD5 = 0;</code>
     */
    public static final int UNDEFINED_BGP_MD5_VALUE = 0;
    /**
     *
     *
     * <pre>
     * MD5_OPTIONAL: BGP MD5 authentication is supported and can optionally be configured.
     * </pre>
     *
     * <code>MD5_OPTIONAL = 532156673;</code>
     */
    public static final int MD5_OPTIONAL_VALUE = 532156673;
    /**
     *
     *
     * <pre>
     * MD5_REQUIRED: BGP MD5 authentication must be configured.
     * </pre>
     *
     * <code>MD5_REQUIRED = 218034496;</code>
     */
    public static final int MD5_REQUIRED_VALUE = 218034496;
    /**
     *
     *
     * <pre>
     * MD5_UNSUPPORTED: BGP MD5 authentication must not be configured
     * </pre>
     *
     * <code>MD5_UNSUPPORTED = 86962388;</code>
     */
    public static final int MD5_UNSUPPORTED_VALUE = 86962388;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BgpMd5 valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BgpMd5 forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BGP_MD5;
        case 532156673:
          return MD5_OPTIONAL;
        case 218034496:
          return MD5_REQUIRED;
        case 86962388:
          return MD5_UNSUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BgpMd5> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BgpMd5> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BgpMd5>() {
          public BgpMd5 findValueByNumber(int number) {
            return BgpMd5.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final BgpMd5[] VALUES = values();

    public static BgpMd5 valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BgpMd5(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.BgpMd5)
  }

  private int bitField0_;
  public static final int BGP_MD5_FIELD_NUMBER = 373093386;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bgpMd5_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
   * Check the BgpMd5 enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_md5 = 373093386;</code>
   *
   * @return Whether the bgpMd5 field is set.
   */
  @java.lang.Override
  public boolean hasBgpMd5() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
   * Check the BgpMd5 enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_md5 = 373093386;</code>
   *
   * @return The bgpMd5.
   */
  @java.lang.Override
  public java.lang.String getBgpMd5() {
    java.lang.Object ref = bgpMd5_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bgpMd5_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
   * Check the BgpMd5 enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bgp_md5 = 373093386;</code>
   *
   * @return The bytes for bgpMd5.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBgpMd5Bytes() {
    java.lang.Object ref = bgpMd5_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bgpMd5_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BGP_PEER_ASN_RANGES_FIELD_NUMBER = 475946370;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
      bgpPeerAsnRanges_;
  /**
   *
   *
   * <pre>
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
      getBgpPeerAsnRangesList() {
    return bgpPeerAsnRanges_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder>
      getBgpPeerAsnRangesOrBuilderList() {
    return bgpPeerAsnRanges_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
   * </code>
   */
  @java.lang.Override
  public int getBgpPeerAsnRangesCount() {
    return bgpPeerAsnRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
      getBgpPeerAsnRanges(int index) {
    return bgpPeerAsnRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder
      getBgpPeerAsnRangesOrBuilder(int index) {
    return bgpPeerAsnRanges_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 373093386, bgpMd5_);
    }
    for (int i = 0; i < bgpPeerAsnRanges_.size(); i++) {
      output.writeMessage(475946370, bgpPeerAsnRanges_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(373093386, bgpMd5_);
    }
    for (int i = 0; i < bgpPeerAsnRanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              475946370, bgpPeerAsnRanges_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints other =
        (com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints) obj;

    if (hasBgpMd5() != other.hasBgpMd5()) return false;
    if (hasBgpMd5()) {
      if (!getBgpMd5().equals(other.getBgpMd5())) return false;
    }
    if (!getBgpPeerAsnRangesList().equals(other.getBgpPeerAsnRangesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBgpMd5()) {
      hash = (37 * hash) + BGP_MD5_FIELD_NUMBER;
      hash = (53 * hash) + getBgpMd5().hashCode();
    }
    if (getBgpPeerAsnRangesCount() > 0) {
      hash = (37 * hash) + BGP_PEER_ASN_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getBgpPeerAsnRangesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints)
      com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentConfigurationConstraints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentConfigurationConstraints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.class,
              com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bgpMd5_ = "";
      if (bgpPeerAsnRangesBuilder_ == null) {
        bgpPeerAsnRanges_ = java.util.Collections.emptyList();
      } else {
        bgpPeerAsnRanges_ = null;
        bgpPeerAsnRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentConfigurationConstraints_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints build() {
      com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
        buildPartial() {
      com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints result =
          new com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints result) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          bgpPeerAsnRanges_ = java.util.Collections.unmodifiableList(bgpPeerAsnRanges_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.bgpPeerAsnRanges_ = bgpPeerAsnRanges_;
      } else {
        result.bgpPeerAsnRanges_ = bgpPeerAsnRangesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bgpMd5_ = bgpMd5_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints) {
        return mergeFrom(
            (com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
              .getDefaultInstance()) return this;
      if (other.hasBgpMd5()) {
        bgpMd5_ = other.bgpMd5_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (bgpPeerAsnRangesBuilder_ == null) {
        if (!other.bgpPeerAsnRanges_.isEmpty()) {
          if (bgpPeerAsnRanges_.isEmpty()) {
            bgpPeerAsnRanges_ = other.bgpPeerAsnRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBgpPeerAsnRangesIsMutable();
            bgpPeerAsnRanges_.addAll(other.bgpPeerAsnRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.bgpPeerAsnRanges_.isEmpty()) {
          if (bgpPeerAsnRangesBuilder_.isEmpty()) {
            bgpPeerAsnRangesBuilder_.dispose();
            bgpPeerAsnRangesBuilder_ = null;
            bgpPeerAsnRanges_ = other.bgpPeerAsnRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
            bgpPeerAsnRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBgpPeerAsnRangesFieldBuilder()
                    : null;
          } else {
            bgpPeerAsnRangesBuilder_.addAllMessages(other.bgpPeerAsnRanges_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case -1310220206:
              {
                bgpMd5_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1310220206
            case -487396334:
              {
                com.google.cloud.compute.v1
                        .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                    m =
                        input.readMessage(
                            com.google.cloud.compute.v1
                                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                                .parser(),
                            extensionRegistry);
                if (bgpPeerAsnRangesBuilder_ == null) {
                  ensureBgpPeerAsnRangesIsMutable();
                  bgpPeerAsnRanges_.add(m);
                } else {
                  bgpPeerAsnRangesBuilder_.addMessage(m);
                }
                break;
              } // case -487396334
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bgpMd5_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
     * Check the BgpMd5 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_md5 = 373093386;</code>
     *
     * @return Whether the bgpMd5 field is set.
     */
    public boolean hasBgpMd5() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
     * Check the BgpMd5 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_md5 = 373093386;</code>
     *
     * @return The bgpMd5.
     */
    public java.lang.String getBgpMd5() {
      java.lang.Object ref = bgpMd5_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bgpMd5_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
     * Check the BgpMd5 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_md5 = 373093386;</code>
     *
     * @return The bytes for bgpMd5.
     */
    public com.google.protobuf.ByteString getBgpMd5Bytes() {
      java.lang.Object ref = bgpMd5_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bgpMd5_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
     * Check the BgpMd5 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_md5 = 373093386;</code>
     *
     * @param value The bgpMd5 to set.
     * @return This builder for chaining.
     */
    public Builder setBgpMd5(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bgpMd5_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
     * Check the BgpMd5 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_md5 = 373093386;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBgpMd5() {
      bgpMd5_ = getDefaultInstance().getBgpMd5();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
     * Check the BgpMd5 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bgp_md5 = 373093386;</code>
     *
     * @param value The bytes for bgpMd5 to set.
     * @return This builder for chaining.
     */
    public Builder setBgpMd5Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bgpMd5_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
        bgpPeerAsnRanges_ = java.util.Collections.emptyList();

    private void ensureBgpPeerAsnRangesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        bgpPeerAsnRanges_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>(
                bgpPeerAsnRanges_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange,
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange.Builder,
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder>
        bgpPeerAsnRangesBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
        getBgpPeerAsnRangesList() {
      if (bgpPeerAsnRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bgpPeerAsnRanges_);
      } else {
        return bgpPeerAsnRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public int getBgpPeerAsnRangesCount() {
      if (bgpPeerAsnRangesBuilder_ == null) {
        return bgpPeerAsnRanges_.size();
      } else {
        return bgpPeerAsnRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
        getBgpPeerAsnRanges(int index) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        return bgpPeerAsnRanges_.get(index);
      } else {
        return bgpPeerAsnRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder setBgpPeerAsnRanges(
        int index,
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
            value) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.set(index, value);
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder setBgpPeerAsnRanges(
        int index,
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                .Builder
            builderForValue) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder addBgpPeerAsnRanges(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
            value) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.add(value);
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder addBgpPeerAsnRanges(
        int index,
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
            value) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.add(index, value);
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder addBgpPeerAsnRanges(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                .Builder
            builderForValue) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.add(builderForValue.build());
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder addBgpPeerAsnRanges(
        int index,
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                .Builder
            builderForValue) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder addAllBgpPeerAsnRanges(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
            values) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        ensureBgpPeerAsnRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bgpPeerAsnRanges_);
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder clearBgpPeerAsnRanges() {
      if (bgpPeerAsnRangesBuilder_ == null) {
        bgpPeerAsnRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public Builder removeBgpPeerAsnRanges(int index) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        ensureBgpPeerAsnRangesIsMutable();
        bgpPeerAsnRanges_.remove(index);
        onChanged();
      } else {
        bgpPeerAsnRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
            .Builder
        getBgpPeerAsnRangesBuilder(int index) {
      return getBgpPeerAsnRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public com.google.cloud.compute.v1
            .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder
        getBgpPeerAsnRangesOrBuilder(int index) {
      if (bgpPeerAsnRangesBuilder_ == null) {
        return bgpPeerAsnRanges_.get(index);
      } else {
        return bgpPeerAsnRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder>
        getBgpPeerAsnRangesOrBuilderList() {
      if (bgpPeerAsnRangesBuilder_ != null) {
        return bgpPeerAsnRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bgpPeerAsnRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
            .Builder
        addBgpPeerAsnRangesBuilder() {
      return getBgpPeerAsnRangesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1
                  .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
            .Builder
        addBgpPeerAsnRangesBuilder(int index) {
      return getBgpPeerAsnRangesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1
                  .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] List of ASN ranges that the remote location is known to support. Formatted as an array of inclusive ranges {min: min-value, max: max-value}. For example, [{min: 123, max: 123}, {min: 64512, max: 65534}] allows the peer ASN to be 123 or anything in the range 64512-65534. This field is only advisory. Although the API accepts other ranges, these are the ranges that we recommend.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange bgp_peer_asn_ranges = 475946370;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange.Builder>
        getBgpPeerAsnRangesBuilderList() {
      return getBgpPeerAsnRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange,
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange.Builder,
            com.google.cloud.compute.v1
                .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder>
        getBgpPeerAsnRangesFieldBuilder() {
      if (bgpPeerAsnRangesBuilder_ == null) {
        bgpPeerAsnRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange,
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange.Builder,
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsBgpPeerASNRangeOrBuilder>(
                bgpPeerAsnRanges_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        bgpPeerAsnRanges_ = null;
      }
      return bgpPeerAsnRangesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints)
  private static final com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints();
  }

  public static com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectAttachmentConfigurationConstraints>
      PARSER =
          new com.google.protobuf.AbstractParser<InterconnectAttachmentConfigurationConstraints>() {
            @java.lang.Override
            public InterconnectAttachmentConfigurationConstraints parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<InterconnectAttachmentConfigurationConstraints>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectAttachmentConfigurationConstraints>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
