/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectRemoteLocationConstraints}
 */
public final class InterconnectRemoteLocationConstraints
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectRemoteLocationConstraints)
    InterconnectRemoteLocationConstraintsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InterconnectRemoteLocationConstraints.newBuilder() to construct.
  private InterconnectRemoteLocationConstraints(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectRemoteLocationConstraints() {
    portPairRemoteLocation_ = "";
    portPairVlan_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectRemoteLocationConstraints();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectRemoteLocationConstraints_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectRemoteLocationConstraints_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.class,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectRemoteLocationConstraints.PortPairRemoteLocation}
   */
  public enum PortPairRemoteLocation implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PORT_PAIR_REMOTE_LOCATION = 0;</code>
     */
    UNDEFINED_PORT_PAIR_REMOTE_LOCATION(0),
    /**
     *
     *
     * <pre>
     * If PORT_PAIR_MATCHING_REMOTE_LOCATION, the remote cloud provider allocates ports in pairs, and the user should choose the same remote location for both ports.
     * </pre>
     *
     * <code>PORT_PAIR_MATCHING_REMOTE_LOCATION = 207291859;</code>
     */
    PORT_PAIR_MATCHING_REMOTE_LOCATION(207291859),
    /**
     *
     *
     * <pre>
     * If PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, a user may opt to provision a redundant pair of Cross-Cloud Interconnects using two different remote locations in the same city.
     * </pre>
     *
     * <code>PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION = 60609829;</code>
     */
    PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION(60609829),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PORT_PAIR_REMOTE_LOCATION = 0;</code>
     */
    public static final int UNDEFINED_PORT_PAIR_REMOTE_LOCATION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If PORT_PAIR_MATCHING_REMOTE_LOCATION, the remote cloud provider allocates ports in pairs, and the user should choose the same remote location for both ports.
     * </pre>
     *
     * <code>PORT_PAIR_MATCHING_REMOTE_LOCATION = 207291859;</code>
     */
    public static final int PORT_PAIR_MATCHING_REMOTE_LOCATION_VALUE = 207291859;
    /**
     *
     *
     * <pre>
     * If PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, a user may opt to provision a redundant pair of Cross-Cloud Interconnects using two different remote locations in the same city.
     * </pre>
     *
     * <code>PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION = 60609829;</code>
     */
    public static final int PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION_VALUE = 60609829;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PortPairRemoteLocation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PortPairRemoteLocation forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PORT_PAIR_REMOTE_LOCATION;
        case 207291859:
          return PORT_PAIR_MATCHING_REMOTE_LOCATION;
        case 60609829:
          return PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PortPairRemoteLocation>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PortPairRemoteLocation>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PortPairRemoteLocation>() {
              public PortPairRemoteLocation findValueByNumber(int number) {
                return PortPairRemoteLocation.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PortPairRemoteLocation[] VALUES = values();

    public static PortPairRemoteLocation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PortPairRemoteLocation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectRemoteLocationConstraints.PortPairRemoteLocation)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectRemoteLocationConstraints.PortPairVlan}
   */
  public enum PortPairVlan implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PORT_PAIR_VLAN = 0;</code>
     */
    UNDEFINED_PORT_PAIR_VLAN(0),
    /**
     *
     *
     * <pre>
     * If PORT_PAIR_MATCHING_VLAN, the Interconnect for this attachment is part of a pair of ports that should have matching VLAN allocations. This occurs with Cross-Cloud Interconnect to Azure remote locations. While GCP's API does not explicitly group pairs of ports, the UI uses this field to ensure matching VLAN ids when configuring a redundant VLAN pair.
     * </pre>
     *
     * <code>PORT_PAIR_MATCHING_VLAN = 250295358;</code>
     */
    PORT_PAIR_MATCHING_VLAN(250295358),
    /**
     *
     *
     * <pre>
     * PORT_PAIR_UNCONSTRAINED_VLAN means there is no constraint.
     * </pre>
     *
     * <code>PORT_PAIR_UNCONSTRAINED_VLAN = 175227948;</code>
     */
    PORT_PAIR_UNCONSTRAINED_VLAN(175227948),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PORT_PAIR_VLAN = 0;</code>
     */
    public static final int UNDEFINED_PORT_PAIR_VLAN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If PORT_PAIR_MATCHING_VLAN, the Interconnect for this attachment is part of a pair of ports that should have matching VLAN allocations. This occurs with Cross-Cloud Interconnect to Azure remote locations. While GCP's API does not explicitly group pairs of ports, the UI uses this field to ensure matching VLAN ids when configuring a redundant VLAN pair.
     * </pre>
     *
     * <code>PORT_PAIR_MATCHING_VLAN = 250295358;</code>
     */
    public static final int PORT_PAIR_MATCHING_VLAN_VALUE = 250295358;
    /**
     *
     *
     * <pre>
     * PORT_PAIR_UNCONSTRAINED_VLAN means there is no constraint.
     * </pre>
     *
     * <code>PORT_PAIR_UNCONSTRAINED_VLAN = 175227948;</code>
     */
    public static final int PORT_PAIR_UNCONSTRAINED_VLAN_VALUE = 175227948;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PortPairVlan valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PortPairVlan forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PORT_PAIR_VLAN;
        case 250295358:
          return PORT_PAIR_MATCHING_VLAN;
        case 175227948:
          return PORT_PAIR_UNCONSTRAINED_VLAN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PortPairVlan> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PortPairVlan> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PortPairVlan>() {
          public PortPairVlan findValueByNumber(int number) {
            return PortPairVlan.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final PortPairVlan[] VALUES = values();

    public static PortPairVlan valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PortPairVlan(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectRemoteLocationConstraints.PortPairVlan)
  }

  private int bitField0_;
  public static final int PORT_PAIR_REMOTE_LOCATION_FIELD_NUMBER = 495917351;

  @SuppressWarnings("serial")
  private volatile java.lang.Object portPairRemoteLocation_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
   * Check the PortPairRemoteLocation enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_pair_remote_location = 495917351;</code>
   *
   * @return Whether the portPairRemoteLocation field is set.
   */
  @java.lang.Override
  public boolean hasPortPairRemoteLocation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
   * Check the PortPairRemoteLocation enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_pair_remote_location = 495917351;</code>
   *
   * @return The portPairRemoteLocation.
   */
  @java.lang.Override
  public java.lang.String getPortPairRemoteLocation() {
    java.lang.Object ref = portPairRemoteLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      portPairRemoteLocation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
   * Check the PortPairRemoteLocation enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_pair_remote_location = 495917351;</code>
   *
   * @return The bytes for portPairRemoteLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPortPairRemoteLocationBytes() {
    java.lang.Object ref = portPairRemoteLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      portPairRemoteLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_PAIR_VLAN_FIELD_NUMBER = 478214506;

  @SuppressWarnings("serial")
  private volatile java.lang.Object portPairVlan_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
   * Check the PortPairVlan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_pair_vlan = 478214506;</code>
   *
   * @return Whether the portPairVlan field is set.
   */
  @java.lang.Override
  public boolean hasPortPairVlan() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
   * Check the PortPairVlan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_pair_vlan = 478214506;</code>
   *
   * @return The portPairVlan.
   */
  @java.lang.Override
  public java.lang.String getPortPairVlan() {
    java.lang.Object ref = portPairVlan_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      portPairVlan_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
   * Check the PortPairVlan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_pair_vlan = 478214506;</code>
   *
   * @return The bytes for portPairVlan.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPortPairVlanBytes() {
    java.lang.Object ref = portPairVlan_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      portPairVlan_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNET_LENGTH_RANGE_FIELD_NUMBER = 184473670;
  private com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
      subnetLengthRange_;
  /**
   *
   *
   * <pre>
   * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
   * </code>
   *
   * @return Whether the subnetLengthRange field is set.
   */
  @java.lang.Override
  public boolean hasSubnetLengthRange() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
   * </code>
   *
   * @return The subnetLengthRange.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
      getSubnetLengthRange() {
    return subnetLengthRange_ == null
        ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
            .getDefaultInstance()
        : subnetLengthRange_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRangeOrBuilder
      getSubnetLengthRangeOrBuilder() {
    return subnetLengthRange_ == null
        ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
            .getDefaultInstance()
        : subnetLengthRange_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(184473670, getSubnetLengthRange());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 478214506, portPairVlan_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 495917351, portPairRemoteLocation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              184473670, getSubnetLengthRange());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(478214506, portPairVlan_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              495917351, portPairRemoteLocation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints other =
        (com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints) obj;

    if (hasPortPairRemoteLocation() != other.hasPortPairRemoteLocation()) return false;
    if (hasPortPairRemoteLocation()) {
      if (!getPortPairRemoteLocation().equals(other.getPortPairRemoteLocation())) return false;
    }
    if (hasPortPairVlan() != other.hasPortPairVlan()) return false;
    if (hasPortPairVlan()) {
      if (!getPortPairVlan().equals(other.getPortPairVlan())) return false;
    }
    if (hasSubnetLengthRange() != other.hasSubnetLengthRange()) return false;
    if (hasSubnetLengthRange()) {
      if (!getSubnetLengthRange().equals(other.getSubnetLengthRange())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPortPairRemoteLocation()) {
      hash = (37 * hash) + PORT_PAIR_REMOTE_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getPortPairRemoteLocation().hashCode();
    }
    if (hasPortPairVlan()) {
      hash = (37 * hash) + PORT_PAIR_VLAN_FIELD_NUMBER;
      hash = (53 * hash) + getPortPairVlan().hashCode();
    }
    if (hasSubnetLengthRange()) {
      hash = (37 * hash) + SUBNET_LENGTH_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetLengthRange().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectRemoteLocationConstraints}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectRemoteLocationConstraints)
      com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectRemoteLocationConstraints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectRemoteLocationConstraints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.class,
              com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSubnetLengthRangeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      portPairRemoteLocation_ = "";
      portPairVlan_ = "";
      subnetLengthRange_ = null;
      if (subnetLengthRangeBuilder_ != null) {
        subnetLengthRangeBuilder_.dispose();
        subnetLengthRangeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectRemoteLocationConstraints_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints build() {
      com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints buildPartial() {
      com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints result =
          new com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.portPairRemoteLocation_ = portPairRemoteLocation_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.portPairVlan_ = portPairVlan_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.subnetLengthRange_ =
            subnetLengthRangeBuilder_ == null
                ? subnetLengthRange_
                : subnetLengthRangeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDefaultInstance())
        return this;
      if (other.hasPortPairRemoteLocation()) {
        portPairRemoteLocation_ = other.portPairRemoteLocation_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPortPairVlan()) {
        portPairVlan_ = other.portPairVlan_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasSubnetLengthRange()) {
        mergeSubnetLengthRange(other.getSubnetLengthRange());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1475789362:
              {
                input.readMessage(
                    getSubnetLengthRangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 1475789362
            case -469251246:
              {
                portPairVlan_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -469251246
            case -327628486:
              {
                portPairRemoteLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -327628486
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object portPairRemoteLocation_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
     * Check the PortPairRemoteLocation enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_remote_location = 495917351;</code>
     *
     * @return Whether the portPairRemoteLocation field is set.
     */
    public boolean hasPortPairRemoteLocation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
     * Check the PortPairRemoteLocation enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_remote_location = 495917351;</code>
     *
     * @return The portPairRemoteLocation.
     */
    public java.lang.String getPortPairRemoteLocation() {
      java.lang.Object ref = portPairRemoteLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        portPairRemoteLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
     * Check the PortPairRemoteLocation enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_remote_location = 495917351;</code>
     *
     * @return The bytes for portPairRemoteLocation.
     */
    public com.google.protobuf.ByteString getPortPairRemoteLocationBytes() {
      java.lang.Object ref = portPairRemoteLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        portPairRemoteLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
     * Check the PortPairRemoteLocation enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_remote_location = 495917351;</code>
     *
     * @param value The portPairRemoteLocation to set.
     * @return This builder for chaining.
     */
    public Builder setPortPairRemoteLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      portPairRemoteLocation_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
     * Check the PortPairRemoteLocation enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_remote_location = 495917351;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPortPairRemoteLocation() {
      portPairRemoteLocation_ = getDefaultInstance().getPortPairRemoteLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. GCP's API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
     * Check the PortPairRemoteLocation enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_remote_location = 495917351;</code>
     *
     * @param value The bytes for portPairRemoteLocation to set.
     * @return This builder for chaining.
     */
    public Builder setPortPairRemoteLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      portPairRemoteLocation_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object portPairVlan_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
     * Check the PortPairVlan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_vlan = 478214506;</code>
     *
     * @return Whether the portPairVlan field is set.
     */
    public boolean hasPortPairVlan() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
     * Check the PortPairVlan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_vlan = 478214506;</code>
     *
     * @return The portPairVlan.
     */
    public java.lang.String getPortPairVlan() {
      java.lang.Object ref = portPairVlan_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        portPairVlan_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
     * Check the PortPairVlan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_vlan = 478214506;</code>
     *
     * @return The bytes for portPairVlan.
     */
    public com.google.protobuf.ByteString getPortPairVlanBytes() {
      java.lang.Object ref = portPairVlan_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        portPairVlan_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
     * Check the PortPairVlan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_vlan = 478214506;</code>
     *
     * @param value The portPairVlan to set.
     * @return This builder for chaining.
     */
    public Builder setPortPairVlan(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      portPairVlan_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
     * Check the PortPairVlan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_vlan = 478214506;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPortPairVlan() {
      portPairVlan_ = getDefaultInstance().getPortPairVlan();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
     * Check the PortPairVlan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_pair_vlan = 478214506;</code>
     *
     * @param value The bytes for portPairVlan to set.
     * @return This builder for chaining.
     */
    public Builder setPortPairVlanBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      portPairVlan_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
        subnetLengthRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
                .Builder,
            com.google.cloud.compute.v1
                .InterconnectRemoteLocationConstraintsSubnetLengthRangeOrBuilder>
        subnetLengthRangeBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     *
     * @return Whether the subnetLengthRange field is set.
     */
    public boolean hasSubnetLengthRange() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     *
     * @return The subnetLengthRange.
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
        getSubnetLengthRange() {
      if (subnetLengthRangeBuilder_ == null) {
        return subnetLengthRange_ == null
            ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
                .getDefaultInstance()
            : subnetLengthRange_;
      } else {
        return subnetLengthRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    public Builder setSubnetLengthRange(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange value) {
      if (subnetLengthRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subnetLengthRange_ = value;
      } else {
        subnetLengthRangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    public Builder setSubnetLengthRange(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange.Builder
            builderForValue) {
      if (subnetLengthRangeBuilder_ == null) {
        subnetLengthRange_ = builderForValue.build();
      } else {
        subnetLengthRangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    public Builder mergeSubnetLengthRange(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange value) {
      if (subnetLengthRangeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && subnetLengthRange_ != null
            && subnetLengthRange_
                != com.google.cloud.compute.v1
                    .InterconnectRemoteLocationConstraintsSubnetLengthRange.getDefaultInstance()) {
          getSubnetLengthRangeBuilder().mergeFrom(value);
        } else {
          subnetLengthRange_ = value;
        }
      } else {
        subnetLengthRangeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    public Builder clearSubnetLengthRange() {
      bitField0_ = (bitField0_ & ~0x00000004);
      subnetLengthRange_ = null;
      if (subnetLengthRangeBuilder_ != null) {
        subnetLengthRangeBuilder_.dispose();
        subnetLengthRangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
            .Builder
        getSubnetLengthRangeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSubnetLengthRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    public com.google.cloud.compute.v1
            .InterconnectRemoteLocationConstraintsSubnetLengthRangeOrBuilder
        getSubnetLengthRangeOrBuilder() {
      if (subnetLengthRangeBuilder_ != null) {
        return subnetLengthRangeBuilder_.getMessageOrBuilder();
      } else {
        return subnetLengthRange_ == null
            ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
                .getDefaultInstance()
            : subnetLengthRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] [min-length, max-length] The minimum and maximum value (inclusive) for the IPv4 subnet length. For example, an interconnectRemoteLocation for Azure has {min: 30, max: 30} because Azure requires /30 subnets. This range specifies the values supported by both cloud providers. Interconnect currently supports /29 and /30 IPv4 subnet lengths. If a remote cloud has no constraint on IPv4 subnet length, the range would thus be {min: 29, max: 30}.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange subnet_length_range = 184473670;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
                .Builder,
            com.google.cloud.compute.v1
                .InterconnectRemoteLocationConstraintsSubnetLengthRangeOrBuilder>
        getSubnetLengthRangeFieldBuilder() {
      if (subnetLengthRangeBuilder_ == null) {
        subnetLengthRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange,
                com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsSubnetLengthRange
                    .Builder,
                com.google.cloud.compute.v1
                    .InterconnectRemoteLocationConstraintsSubnetLengthRangeOrBuilder>(
                getSubnetLengthRange(), getParentForChildren(), isClean());
        subnetLengthRange_ = null;
      }
      return subnetLengthRangeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectRemoteLocationConstraints)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectRemoteLocationConstraints)
  private static final com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints();
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectRemoteLocationConstraints> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectRemoteLocationConstraints>() {
        @java.lang.Override
        public InterconnectRemoteLocationConstraints parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectRemoteLocationConstraints> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectRemoteLocationConstraints> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
