/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Output Only] A connection connected to this network attachment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint}
 */
public final class NetworkAttachmentConnectedEndpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint)
    NetworkAttachmentConnectedEndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkAttachmentConnectedEndpoint.newBuilder() to construct.
  private NetworkAttachmentConnectedEndpoint(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkAttachmentConnectedEndpoint() {
    ipAddress_ = "";
    projectIdOrNum_ = "";
    secondaryIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    status_ = "";
    subnetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkAttachmentConnectedEndpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkAttachmentConnectedEndpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkAttachmentConnectedEndpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.class,
            com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The status of a connected endpoint to this network attachment.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The consumer allows traffic from the producer to reach its VPC.
     * </pre>
     *
     * <code>ACCEPTED = 246714279;</code>
     */
    ACCEPTED(246714279),
    /**
     *
     *
     * <pre>
     * The consumer network attachment no longer exists.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    CLOSED(380163436),
    /**
     *
     *
     * <pre>
     * The consumer needs to take further action before traffic can be served.
     * </pre>
     *
     * <code>NEEDS_ATTENTION = 344491452;</code>
     */
    NEEDS_ATTENTION(344491452),
    /**
     *
     *
     * <pre>
     * The consumer neither allows nor prohibits traffic from the producer to reach its VPC.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    PENDING(35394935),
    /**
     *
     *
     * <pre>
     * The consumer prohibits traffic from the producer to reach its VPC.
     * </pre>
     *
     * <code>REJECTED = 174130302;</code>
     */
    REJECTED(174130302),
    /** <code>STATUS_UNSPECIFIED = 42133066;</code> */
    STATUS_UNSPECIFIED(42133066),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The consumer allows traffic from the producer to reach its VPC.
     * </pre>
     *
     * <code>ACCEPTED = 246714279;</code>
     */
    public static final int ACCEPTED_VALUE = 246714279;
    /**
     *
     *
     * <pre>
     * The consumer network attachment no longer exists.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    public static final int CLOSED_VALUE = 380163436;
    /**
     *
     *
     * <pre>
     * The consumer needs to take further action before traffic can be served.
     * </pre>
     *
     * <code>NEEDS_ATTENTION = 344491452;</code>
     */
    public static final int NEEDS_ATTENTION_VALUE = 344491452;
    /**
     *
     *
     * <pre>
     * The consumer neither allows nor prohibits traffic from the producer to reach its VPC.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    public static final int PENDING_VALUE = 35394935;
    /**
     *
     *
     * <pre>
     * The consumer prohibits traffic from the producer to reach its VPC.
     * </pre>
     *
     * <code>REJECTED = 174130302;</code>
     */
    public static final int REJECTED_VALUE = 174130302;
    /** <code>STATUS_UNSPECIFIED = 42133066;</code> */
    public static final int STATUS_UNSPECIFIED_VALUE = 42133066;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 246714279:
          return ACCEPTED;
        case 380163436:
          return CLOSED;
        case 344491452:
          return NEEDS_ATTENTION;
        case 35394935:
          return PENDING;
        case 174130302:
          return REJECTED;
        case 42133066:
          return STATUS_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.Status)
  }

  private int bitField0_;
  public static final int IP_ADDRESS_FIELD_NUMBER = 406272220;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipAddress_ = "";
  /**
   *
   *
   * <pre>
   * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return Whether the ipAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpAddress() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_OR_NUM_FIELD_NUMBER = 349783336;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectIdOrNum_ = "";
  /**
   *
   *
   * <pre>
   * The project id or number of the interface to which the IP was assigned.
   * </pre>
   *
   * <code>optional string project_id_or_num = 349783336;</code>
   *
   * @return Whether the projectIdOrNum field is set.
   */
  @java.lang.Override
  public boolean hasProjectIdOrNum() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The project id or number of the interface to which the IP was assigned.
   * </pre>
   *
   * <code>optional string project_id_or_num = 349783336;</code>
   *
   * @return The projectIdOrNum.
   */
  @java.lang.Override
  public java.lang.String getProjectIdOrNum() {
    java.lang.Object ref = projectIdOrNum_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectIdOrNum_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project id or number of the interface to which the IP was assigned.
   * </pre>
   *
   * <code>optional string project_id_or_num = 349783336;</code>
   *
   * @return The bytes for projectIdOrNum.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdOrNumBytes() {
    java.lang.Object ref = projectIdOrNum_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectIdOrNum_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECONDARY_IP_CIDR_RANGES_FIELD_NUMBER = 117184788;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList secondaryIpCidrRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Alias IP ranges from the same subnetwork.
   * </pre>
   *
   * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
   *
   * @return A list containing the secondaryIpCidrRanges.
   */
  public com.google.protobuf.ProtocolStringList getSecondaryIpCidrRangesList() {
    return secondaryIpCidrRanges_;
  }
  /**
   *
   *
   * <pre>
   * Alias IP ranges from the same subnetwork.
   * </pre>
   *
   * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
   *
   * @return The count of secondaryIpCidrRanges.
   */
  public int getSecondaryIpCidrRangesCount() {
    return secondaryIpCidrRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Alias IP ranges from the same subnetwork.
   * </pre>
   *
   * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
   *
   * @param index The index of the element to return.
   * @return The secondaryIpCidrRanges at the given index.
   */
  public java.lang.String getSecondaryIpCidrRanges(int index) {
    return secondaryIpCidrRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Alias IP ranges from the same subnetwork.
   * </pre>
   *
   * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the secondaryIpCidrRanges at the given index.
   */
  public com.google.protobuf.ByteString getSecondaryIpCidrRangesBytes(int index) {
    return secondaryIpCidrRanges_.getByteString(index);
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * The status of a connected endpoint to this network attachment.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The status of a connected endpoint to this network attachment.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The status of a connected endpoint to this network attachment.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 307827694;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * The subnetwork used to assign the IP to the producer instance network interface.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return Whether the subnetwork field is set.
   */
  @java.lang.Override
  public boolean hasSubnetwork() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The subnetwork used to assign the IP to the producer instance network interface.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The subnetwork used to assign the IP to the producer instance network interface.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < secondaryIpCidrRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 117184788, secondaryIpCidrRanges_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 307827694, subnetwork_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 349783336, projectIdOrNum_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 406272220, ipAddress_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < secondaryIpCidrRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(secondaryIpCidrRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSecondaryIpCidrRangesList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(307827694, subnetwork_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(349783336, projectIdOrNum_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(406272220, ipAddress_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint other =
        (com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint) obj;

    if (hasIpAddress() != other.hasIpAddress()) return false;
    if (hasIpAddress()) {
      if (!getIpAddress().equals(other.getIpAddress())) return false;
    }
    if (hasProjectIdOrNum() != other.hasProjectIdOrNum()) return false;
    if (hasProjectIdOrNum()) {
      if (!getProjectIdOrNum().equals(other.getProjectIdOrNum())) return false;
    }
    if (!getSecondaryIpCidrRangesList().equals(other.getSecondaryIpCidrRangesList())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasSubnetwork() != other.hasSubnetwork()) return false;
    if (hasSubnetwork()) {
      if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIpAddress()) {
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
    }
    if (hasProjectIdOrNum()) {
      hash = (37 * hash) + PROJECT_ID_OR_NUM_FIELD_NUMBER;
      hash = (53 * hash) + getProjectIdOrNum().hashCode();
    }
    if (getSecondaryIpCidrRangesCount() > 0) {
      hash = (37 * hash) + SECONDARY_IP_CIDR_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryIpCidrRangesList().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasSubnetwork()) {
      hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetwork().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A connection connected to this network attachment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint)
      com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkAttachmentConnectedEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkAttachmentConnectedEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.class,
              com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ipAddress_ = "";
      projectIdOrNum_ = "";
      secondaryIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      status_ = "";
      subnetwork_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkAttachmentConnectedEndpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint build() {
      com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint buildPartial() {
      com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint result =
          new com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ipAddress_ = ipAddress_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectIdOrNum_ = projectIdOrNum_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        secondaryIpCidrRanges_.makeImmutable();
        result.secondaryIpCidrRanges_ = secondaryIpCidrRanges_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.subnetwork_ = subnetwork_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint) {
        return mergeFrom((com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint other) {
      if (other
          == com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint.getDefaultInstance())
        return this;
      if (other.hasIpAddress()) {
        ipAddress_ = other.ipAddress_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasProjectIdOrNum()) {
        projectIdOrNum_ = other.projectIdOrNum_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.secondaryIpCidrRanges_.isEmpty()) {
        if (secondaryIpCidrRanges_.isEmpty()) {
          secondaryIpCidrRanges_ = other.secondaryIpCidrRanges_;
          bitField0_ |= 0x00000004;
        } else {
          ensureSecondaryIpCidrRangesIsMutable();
          secondaryIpCidrRanges_.addAll(other.secondaryIpCidrRanges_);
        }
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasSubnetwork()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 937478306:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSecondaryIpCidrRangesIsMutable();
                secondaryIpCidrRanges_.add(s);
                break;
              } // case 937478306
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1450082194
            case -1832345742:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1832345742
            case -1496700606:
              {
                projectIdOrNum_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1496700606
            case -1044789534:
              {
                ipAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1044789534
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object ipAddress_ = "";
    /**
     *
     *
     * <pre>
     * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return Whether the ipAddress field is set.
     */
    public boolean hasIpAddress() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {
      ipAddress_ = getDefaultInstance().getIpAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IPv4 address assigned to the producer instance network interface. This value will be a range in case of Serverless.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectIdOrNum_ = "";
    /**
     *
     *
     * <pre>
     * The project id or number of the interface to which the IP was assigned.
     * </pre>
     *
     * <code>optional string project_id_or_num = 349783336;</code>
     *
     * @return Whether the projectIdOrNum field is set.
     */
    public boolean hasProjectIdOrNum() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The project id or number of the interface to which the IP was assigned.
     * </pre>
     *
     * <code>optional string project_id_or_num = 349783336;</code>
     *
     * @return The projectIdOrNum.
     */
    public java.lang.String getProjectIdOrNum() {
      java.lang.Object ref = projectIdOrNum_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectIdOrNum_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project id or number of the interface to which the IP was assigned.
     * </pre>
     *
     * <code>optional string project_id_or_num = 349783336;</code>
     *
     * @return The bytes for projectIdOrNum.
     */
    public com.google.protobuf.ByteString getProjectIdOrNumBytes() {
      java.lang.Object ref = projectIdOrNum_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectIdOrNum_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project id or number of the interface to which the IP was assigned.
     * </pre>
     *
     * <code>optional string project_id_or_num = 349783336;</code>
     *
     * @param value The projectIdOrNum to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdOrNum(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectIdOrNum_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project id or number of the interface to which the IP was assigned.
     * </pre>
     *
     * <code>optional string project_id_or_num = 349783336;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectIdOrNum() {
      projectIdOrNum_ = getDefaultInstance().getProjectIdOrNum();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project id or number of the interface to which the IP was assigned.
     * </pre>
     *
     * <code>optional string project_id_or_num = 349783336;</code>
     *
     * @param value The bytes for projectIdOrNum to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdOrNumBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectIdOrNum_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList secondaryIpCidrRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSecondaryIpCidrRangesIsMutable() {
      if (!secondaryIpCidrRanges_.isModifiable()) {
        secondaryIpCidrRanges_ =
            new com.google.protobuf.LazyStringArrayList(secondaryIpCidrRanges_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @return A list containing the secondaryIpCidrRanges.
     */
    public com.google.protobuf.ProtocolStringList getSecondaryIpCidrRangesList() {
      secondaryIpCidrRanges_.makeImmutable();
      return secondaryIpCidrRanges_;
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @return The count of secondaryIpCidrRanges.
     */
    public int getSecondaryIpCidrRangesCount() {
      return secondaryIpCidrRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @param index The index of the element to return.
     * @return The secondaryIpCidrRanges at the given index.
     */
    public java.lang.String getSecondaryIpCidrRanges(int index) {
      return secondaryIpCidrRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the secondaryIpCidrRanges at the given index.
     */
    public com.google.protobuf.ByteString getSecondaryIpCidrRangesBytes(int index) {
      return secondaryIpCidrRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @param index The index to set the value at.
     * @param value The secondaryIpCidrRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSecondaryIpCidrRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecondaryIpCidrRangesIsMutable();
      secondaryIpCidrRanges_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @param value The secondaryIpCidrRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSecondaryIpCidrRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecondaryIpCidrRangesIsMutable();
      secondaryIpCidrRanges_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @param values The secondaryIpCidrRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSecondaryIpCidrRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSecondaryIpCidrRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secondaryIpCidrRanges_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecondaryIpCidrRanges() {
      secondaryIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alias IP ranges from the same subnetwork.
     * </pre>
     *
     * <code>repeated string secondary_ip_cidr_ranges = 117184788;</code>
     *
     * @param value The bytes of the secondaryIpCidrRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSecondaryIpCidrRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSecondaryIpCidrRangesIsMutable();
      secondaryIpCidrRanges_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * The status of a connected endpoint to this network attachment.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status of a connected endpoint to this network attachment.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of a connected endpoint to this network attachment.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of a connected endpoint to this network attachment.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of a connected endpoint to this network attachment.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of a connected endpoint to this network attachment.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * The subnetwork used to assign the IP to the producer instance network interface.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return Whether the subnetwork field is set.
     */
    public boolean hasSubnetwork() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The subnetwork used to assign the IP to the producer instance network interface.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The subnetwork used to assign the IP to the producer instance network interface.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The subnetwork used to assign the IP to the producer instance network interface.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The subnetwork used to assign the IP to the producer instance network interface.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The subnetwork used to assign the IP to the producer instance network interface.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint)
  private static final com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint();
  }

  public static com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkAttachmentConnectedEndpoint> PARSER =
      new com.google.protobuf.AbstractParser<NetworkAttachmentConnectedEndpoint>() {
        @java.lang.Override
        public NetworkAttachmentConnectedEndpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkAttachmentConnectedEndpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkAttachmentConnectedEndpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkAttachmentConnectedEndpoint
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
