/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represent a sole-tenant Node Template resource. You can use a template to define properties for nodes in a node group. For more information, read Creating node groups and instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NodeTemplate}
 */
public final class NodeTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NodeTemplate)
    NodeTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeTemplate.newBuilder() to construct.
  private NodeTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeTemplate() {
    accelerators_ = java.util.Collections.emptyList();
    cpuOvercommitType_ = "";
    creationTimestamp_ = "";
    description_ = "";
    disks_ = java.util.Collections.emptyList();
    kind_ = "";
    name_ = "";
    nodeType_ = "";
    region_ = "";
    selfLink_ = "";
    status_ = "";
    statusMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NodeTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 339007161:
        return internalGetNodeAffinityLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NodeTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NodeTemplate.class,
            com.google.cloud.compute.v1.NodeTemplate.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * CPU overcommit.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NodeTemplate.CpuOvercommitType}
   */
  public enum CpuOvercommitType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CPU_OVERCOMMIT_TYPE = 0;</code>
     */
    UNDEFINED_CPU_OVERCOMMIT_TYPE(0),
    /** <code>CPU_OVERCOMMIT_TYPE_UNSPECIFIED = 520665615;</code> */
    CPU_OVERCOMMIT_TYPE_UNSPECIFIED(520665615),
    /** <code>ENABLED = 182130465;</code> */
    ENABLED(182130465),
    /** <code>NONE = 2402104;</code> */
    NONE(2402104),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CPU_OVERCOMMIT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_CPU_OVERCOMMIT_TYPE_VALUE = 0;
    /** <code>CPU_OVERCOMMIT_TYPE_UNSPECIFIED = 520665615;</code> */
    public static final int CPU_OVERCOMMIT_TYPE_UNSPECIFIED_VALUE = 520665615;
    /** <code>ENABLED = 182130465;</code> */
    public static final int ENABLED_VALUE = 182130465;
    /** <code>NONE = 2402104;</code> */
    public static final int NONE_VALUE = 2402104;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CpuOvercommitType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CpuOvercommitType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CPU_OVERCOMMIT_TYPE;
        case 520665615:
          return CPU_OVERCOMMIT_TYPE_UNSPECIFIED;
        case 182130465:
          return ENABLED;
        case 2402104:
          return NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CpuOvercommitType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CpuOvercommitType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CpuOvercommitType>() {
              public CpuOvercommitType findValueByNumber(int number) {
                return CpuOvercommitType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NodeTemplate.getDescriptor().getEnumTypes().get(0);
    }

    private static final CpuOvercommitType[] VALUES = values();

    public static CpuOvercommitType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CpuOvercommitType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NodeTemplate.CpuOvercommitType)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NodeTemplate.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Resources are being allocated.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * The node template is currently being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * Invalid status.
     * </pre>
     *
     * <code>INVALID = 530283991;</code>
     */
    INVALID(530283991),
    /**
     *
     *
     * <pre>
     * The node template is ready.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    READY(77848963),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Resources are being allocated.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;
    /**
     *
     *
     * <pre>
     * The node template is currently being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;
    /**
     *
     *
     * <pre>
     * Invalid status.
     * </pre>
     *
     * <code>INVALID = 530283991;</code>
     */
    public static final int INVALID_VALUE = 530283991;
    /**
     *
     *
     * <pre>
     * The node template is ready.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    public static final int READY_VALUE = 77848963;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 530283991:
          return INVALID;
        case 77848963:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NodeTemplate.getDescriptor().getEnumTypes().get(1);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NodeTemplate.Status)
  }

  private int bitField0_;
  public static final int ACCELERATORS_FIELD_NUMBER = 269577064;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> accelerators_;
  /** <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getAcceleratorsList() {
    return accelerators_;
  }
  /** <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code> */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }
  /** <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code> */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }
  /** <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfig getAccelerators(int index) {
    return accelerators_.get(index);
  }
  /** <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(
      int index) {
    return accelerators_.get(index);
  }

  public static final int CPU_OVERCOMMIT_TYPE_FIELD_NUMBER = 247727959;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cpuOvercommitType_ = "";
  /**
   *
   *
   * <pre>
   * CPU overcommit.
   * Check the CpuOvercommitType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string cpu_overcommit_type = 247727959;</code>
   *
   * @return Whether the cpuOvercommitType field is set.
   */
  @java.lang.Override
  public boolean hasCpuOvercommitType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * CPU overcommit.
   * Check the CpuOvercommitType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string cpu_overcommit_type = 247727959;</code>
   *
   * @return The cpuOvercommitType.
   */
  @java.lang.Override
  public java.lang.String getCpuOvercommitType() {
    java.lang.Object ref = cpuOvercommitType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuOvercommitType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * CPU overcommit.
   * Check the CpuOvercommitType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string cpu_overcommit_type = 247727959;</code>
   *
   * @return The bytes for cpuOvercommitType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuOvercommitTypeBytes() {
    java.lang.Object ref = cpuOvercommitType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuOvercommitType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISKS_FIELD_NUMBER = 95594102;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.LocalDisk> disks_;
  /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.LocalDisk> getDisksList() {
    return disks_;
  }
  /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.LocalDiskOrBuilder>
      getDisksOrBuilderList() {
    return disks_;
  }
  /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
  @java.lang.Override
  public int getDisksCount() {
    return disks_.size();
  }
  /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.LocalDisk getDisks(int index) {
    return disks_.get(index);
  }
  /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.LocalDiskOrBuilder getDisksOrBuilder(int index) {
    return disks_.get(index);
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_AFFINITY_LABELS_FIELD_NUMBER = 339007161;

  private static final class NodeAffinityLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_NodeTemplate_NodeAffinityLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> nodeAffinityLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetNodeAffinityLabels() {
    if (nodeAffinityLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          NodeAffinityLabelsDefaultEntryHolder.defaultEntry);
    }
    return nodeAffinityLabels_;
  }

  public int getNodeAffinityLabelsCount() {
    return internalGetNodeAffinityLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to use for node affinity, which will be used in instance scheduling.
   * </pre>
   *
   * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
   */
  @java.lang.Override
  public boolean containsNodeAffinityLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetNodeAffinityLabels().getMap().containsKey(key);
  }
  /** Use {@link #getNodeAffinityLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getNodeAffinityLabels() {
    return getNodeAffinityLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to use for node affinity, which will be used in instance scheduling.
   * </pre>
   *
   * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getNodeAffinityLabelsMap() {
    return internalGetNodeAffinityLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to use for node affinity, which will be used in instance scheduling.
   * </pre>
   *
   * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getNodeAffinityLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetNodeAffinityLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to use for node affinity, which will be used in instance scheduling.
   * </pre>
   *
   * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
   */
  @java.lang.Override
  public java.lang.String getNodeAffinityLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetNodeAffinityLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NODE_TYPE_FIELD_NUMBER = 465832791;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeType_ = "";
  /**
   *
   *
   * <pre>
   * The node type to use for nodes group that are created from this template.
   * </pre>
   *
   * <code>optional string node_type = 465832791;</code>
   *
   * @return Whether the nodeType field is set.
   */
  @java.lang.Override
  public boolean hasNodeType() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The node type to use for nodes group that are created from this template.
   * </pre>
   *
   * <code>optional string node_type = 465832791;</code>
   *
   * @return The nodeType.
   */
  @java.lang.Override
  public java.lang.String getNodeType() {
    java.lang.Object ref = nodeType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The node type to use for nodes group that are created from this template.
   * </pre>
   *
   * <code>optional string node_type = 465832791;</code>
   *
   * @return The bytes for nodeType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeTypeBytes() {
    java.lang.Object ref = nodeType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_TYPE_FLEXIBILITY_FIELD_NUMBER = 315257905;
  private com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility nodeTypeFlexibility_;
  /**
   *
   *
   * <pre>
   * Do not use. Instead, use the node_type property.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
   * </code>
   *
   * @return Whether the nodeTypeFlexibility field is set.
   */
  @java.lang.Override
  public boolean hasNodeTypeFlexibility() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Do not use. Instead, use the node_type property.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
   * </code>
   *
   * @return The nodeTypeFlexibility.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility getNodeTypeFlexibility() {
    return nodeTypeFlexibility_ == null
        ? com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.getDefaultInstance()
        : nodeTypeFlexibility_;
  }
  /**
   *
   *
   * <pre>
   * Do not use. Instead, use the node_type property.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibilityOrBuilder
      getNodeTypeFlexibilityOrBuilder() {
    return nodeTypeFlexibility_ == null
        ? com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.getDefaultInstance()
        : nodeTypeFlexibility_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the region where the node template resides, such as us-central1.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the region where the node template resides, such as us-central1.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the region where the node template resides, such as us-central1.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVER_BINDING_FIELD_NUMBER = 208179593;
  private com.google.cloud.compute.v1.ServerBinding serverBinding_;
  /**
   *
   *
   * <pre>
   * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
   *
   * @return Whether the serverBinding field is set.
   */
  @java.lang.Override
  public boolean hasServerBinding() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
   *
   * @return The serverBinding.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServerBinding getServerBinding() {
    return serverBinding_ == null
        ? com.google.cloud.compute.v1.ServerBinding.getDefaultInstance()
        : serverBinding_;
  }
  /**
   *
   *
   * <pre>
   * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServerBindingOrBuilder getServerBindingOrBuilder() {
    return serverBinding_ == null
        ? com.google.cloud.compute.v1.ServerBinding.getDefaultInstance()
        : serverBinding_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 297428154;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  @java.lang.Override
  public boolean hasStatusMessage() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    for (int i = 0; i < disks_.size(); i++) {
      output.writeMessage(95594102, disks_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(208179593, getServerBinding());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 247727959, cpuOvercommitType_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(269577064, accelerators_.get(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 297428154, statusMessage_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(315257905, getNodeTypeFlexibility());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetNodeAffinityLabels(),
        NodeAffinityLabelsDefaultEntryHolder.defaultEntry,
        339007161);
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 465832791, nodeType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    for (int i = 0; i < disks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(95594102, disks_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(208179593, getServerBinding());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(247727959, cpuOvercommitType_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(269577064, accelerators_.get(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(297428154, statusMessage_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              315257905, getNodeTypeFlexibility());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetNodeAffinityLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> nodeAffinityLabels__ =
          NodeAffinityLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(339007161, nodeAffinityLabels__);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(465832791, nodeType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NodeTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NodeTemplate other = (com.google.cloud.compute.v1.NodeTemplate) obj;

    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (hasCpuOvercommitType() != other.hasCpuOvercommitType()) return false;
    if (hasCpuOvercommitType()) {
      if (!getCpuOvercommitType().equals(other.getCpuOvercommitType())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getDisksList().equals(other.getDisksList())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!internalGetNodeAffinityLabels().equals(other.internalGetNodeAffinityLabels()))
      return false;
    if (hasNodeType() != other.hasNodeType()) return false;
    if (hasNodeType()) {
      if (!getNodeType().equals(other.getNodeType())) return false;
    }
    if (hasNodeTypeFlexibility() != other.hasNodeTypeFlexibility()) return false;
    if (hasNodeTypeFlexibility()) {
      if (!getNodeTypeFlexibility().equals(other.getNodeTypeFlexibility())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasServerBinding() != other.hasServerBinding()) return false;
    if (hasServerBinding()) {
      if (!getServerBinding().equals(other.getServerBinding())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasStatusMessage() != other.hasStatusMessage()) return false;
    if (hasStatusMessage()) {
      if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    if (hasCpuOvercommitType()) {
      hash = (37 * hash) + CPU_OVERCOMMIT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getCpuOvercommitType().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getDisksCount() > 0) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDisksList().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (!internalGetNodeAffinityLabels().getMap().isEmpty()) {
      hash = (37 * hash) + NODE_AFFINITY_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetNodeAffinityLabels().hashCode();
    }
    if (hasNodeType()) {
      hash = (37 * hash) + NODE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getNodeType().hashCode();
    }
    if (hasNodeTypeFlexibility()) {
      hash = (37 * hash) + NODE_TYPE_FLEXIBILITY_FIELD_NUMBER;
      hash = (53 * hash) + getNodeTypeFlexibility().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasServerBinding()) {
      hash = (37 * hash) + SERVER_BINDING_FIELD_NUMBER;
      hash = (53 * hash) + getServerBinding().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasStatusMessage()) {
      hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStatusMessage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NodeTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.NodeTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represent a sole-tenant Node Template resource. You can use a template to define properties for nodes in a node group. For more information, read Creating node groups and instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NodeTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NodeTemplate)
      com.google.cloud.compute.v1.NodeTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NodeTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 339007161:
          return internalGetNodeAffinityLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 339007161:
          return internalGetMutableNodeAffinityLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NodeTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NodeTemplate.class,
              com.google.cloud.compute.v1.NodeTemplate.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NodeTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAcceleratorsFieldBuilder();
        getDisksFieldBuilder();
        getNodeTypeFlexibilityFieldBuilder();
        getServerBindingFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      cpuOvercommitType_ = "";
      creationTimestamp_ = "";
      description_ = "";
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
      } else {
        disks_ = null;
        disksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      kind_ = "";
      name_ = "";
      internalGetMutableNodeAffinityLabels().clear();
      nodeType_ = "";
      nodeTypeFlexibility_ = null;
      if (nodeTypeFlexibilityBuilder_ != null) {
        nodeTypeFlexibilityBuilder_.dispose();
        nodeTypeFlexibilityBuilder_ = null;
      }
      region_ = "";
      selfLink_ = "";
      serverBinding_ = null;
      if (serverBindingBuilder_ != null) {
        serverBindingBuilder_.dispose();
        serverBindingBuilder_ = null;
      }
      status_ = "";
      statusMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NodeTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NodeTemplate getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NodeTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NodeTemplate build() {
      com.google.cloud.compute.v1.NodeTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NodeTemplate buildPartial() {
      com.google.cloud.compute.v1.NodeTemplate result =
          new com.google.cloud.compute.v1.NodeTemplate(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.NodeTemplate result) {
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
      if (disksBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          disks_ = java.util.Collections.unmodifiableList(disks_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.disks_ = disks_;
      } else {
        result.disks_ = disksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.NodeTemplate result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cpuOvercommitType_ = cpuOvercommitType_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.nodeAffinityLabels_ = internalGetNodeAffinityLabels();
        result.nodeAffinityLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.nodeType_ = nodeType_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.nodeTypeFlexibility_ =
            nodeTypeFlexibilityBuilder_ == null
                ? nodeTypeFlexibility_
                : nodeTypeFlexibilityBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.serverBinding_ =
            serverBindingBuilder_ == null ? serverBinding_ : serverBindingBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.statusMessage_ = statusMessage_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NodeTemplate) {
        return mergeFrom((com.google.cloud.compute.v1.NodeTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NodeTemplate other) {
      if (other == com.google.cloud.compute.v1.NodeTemplate.getDefaultInstance()) return this;
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000001);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (other.hasCpuOvercommitType()) {
        cpuOvercommitType_ = other.cpuOvercommitType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (disksBuilder_ == null) {
        if (!other.disks_.isEmpty()) {
          if (disks_.isEmpty()) {
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDisksIsMutable();
            disks_.addAll(other.disks_);
          }
          onChanged();
        }
      } else {
        if (!other.disks_.isEmpty()) {
          if (disksBuilder_.isEmpty()) {
            disksBuilder_.dispose();
            disksBuilder_ = null;
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000010);
            disksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDisksFieldBuilder()
                    : null;
          } else {
            disksBuilder_.addAllMessages(other.disks_);
          }
        }
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      internalGetMutableNodeAffinityLabels().mergeFrom(other.internalGetNodeAffinityLabels());
      bitField0_ |= 0x00000100;
      if (other.hasNodeType()) {
        nodeType_ = other.nodeType_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasNodeTypeFlexibility()) {
        mergeNodeTypeFlexibility(other.getNodeTypeFlexibility());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasServerBinding()) {
        mergeServerBinding(other.getServerBinding());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasStatusMessage()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 764752818:
              {
                com.google.cloud.compute.v1.LocalDisk m =
                    input.readMessage(
                        com.google.cloud.compute.v1.LocalDisk.parser(), extensionRegistry);
                if (disksBuilder_ == null) {
                  ensureDisksIsMutable();
                  disks_.add(m);
                } else {
                  disksBuilder_.addMessage(m);
                }
                break;
              } // case 764752818
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1111570338
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1450082194
            case 1665436746:
              {
                input.readMessage(getServerBindingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 1665436746
            case 1981823674:
              {
                cpuOvercommitType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1981823674
            case -2138350782:
              {
                com.google.cloud.compute.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case -2138350782
            case -1915542062:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -1915542062
            case -1772904054:
              {
                input.readMessage(
                    getNodeTypeFlexibilityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case -1772904054
            case -1582910006:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    nodeAffinityLabels__ =
                        input.readMessage(
                            NodeAffinityLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableNodeAffinityLabels()
                    .getMutableMap()
                    .put(nodeAffinityLabels__.getKey(), nodeAffinityLabels__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case -1582910006
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case -645248918
            case -568304966:
              {
                nodeType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -568304966
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AcceleratorConfig>(accelerators_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        acceleratorsBuilder_;

    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder setAccelerators(int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder addAccelerators(com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder addAccelerators(int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder addAccelerators(
        com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AcceleratorConfig> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder getAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(
        int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig accelerators = 269577064;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AcceleratorConfig,
                com.google.cloud.compute.v1.AcceleratorConfig.Builder,
                com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>(
                accelerators_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private java.lang.Object cpuOvercommitType_ = "";
    /**
     *
     *
     * <pre>
     * CPU overcommit.
     * Check the CpuOvercommitType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cpu_overcommit_type = 247727959;</code>
     *
     * @return Whether the cpuOvercommitType field is set.
     */
    public boolean hasCpuOvercommitType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit.
     * Check the CpuOvercommitType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cpu_overcommit_type = 247727959;</code>
     *
     * @return The cpuOvercommitType.
     */
    public java.lang.String getCpuOvercommitType() {
      java.lang.Object ref = cpuOvercommitType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuOvercommitType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit.
     * Check the CpuOvercommitType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cpu_overcommit_type = 247727959;</code>
     *
     * @return The bytes for cpuOvercommitType.
     */
    public com.google.protobuf.ByteString getCpuOvercommitTypeBytes() {
      java.lang.Object ref = cpuOvercommitType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuOvercommitType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit.
     * Check the CpuOvercommitType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cpu_overcommit_type = 247727959;</code>
     *
     * @param value The cpuOvercommitType to set.
     * @return This builder for chaining.
     */
    public Builder setCpuOvercommitType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cpuOvercommitType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit.
     * Check the CpuOvercommitType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cpu_overcommit_type = 247727959;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuOvercommitType() {
      cpuOvercommitType_ = getDefaultInstance().getCpuOvercommitType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU overcommit.
     * Check the CpuOvercommitType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cpu_overcommit_type = 247727959;</code>
     *
     * @param value The bytes for cpuOvercommitType to set.
     * @return This builder for chaining.
     */
    public Builder setCpuOvercommitTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cpuOvercommitType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.LocalDisk> disks_ =
        java.util.Collections.emptyList();

    private void ensureDisksIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        disks_ = new java.util.ArrayList<com.google.cloud.compute.v1.LocalDisk>(disks_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.LocalDisk,
            com.google.cloud.compute.v1.LocalDisk.Builder,
            com.google.cloud.compute.v1.LocalDiskOrBuilder>
        disksBuilder_;

    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public java.util.List<com.google.cloud.compute.v1.LocalDisk> getDisksList() {
      if (disksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(disks_);
      } else {
        return disksBuilder_.getMessageList();
      }
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public int getDisksCount() {
      if (disksBuilder_ == null) {
        return disks_.size();
      } else {
        return disksBuilder_.getCount();
      }
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public com.google.cloud.compute.v1.LocalDisk getDisks(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessage(index);
      }
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder setDisks(int index, com.google.cloud.compute.v1.LocalDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.set(index, value);
        onChanged();
      } else {
        disksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder setDisks(
        int index, com.google.cloud.compute.v1.LocalDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.set(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder addDisks(com.google.cloud.compute.v1.LocalDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(value);
        onChanged();
      } else {
        disksBuilder_.addMessage(value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder addDisks(int index, com.google.cloud.compute.v1.LocalDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(index, value);
        onChanged();
      } else {
        disksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder addDisks(com.google.cloud.compute.v1.LocalDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder addDisks(
        int index, com.google.cloud.compute.v1.LocalDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder addAllDisks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.LocalDisk> values) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, disks_);
        onChanged();
      } else {
        disksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder clearDisks() {
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        disksBuilder_.clear();
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public Builder removeDisks(int index) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.remove(index);
        onChanged();
      } else {
        disksBuilder_.remove(index);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public com.google.cloud.compute.v1.LocalDisk.Builder getDisksBuilder(int index) {
      return getDisksFieldBuilder().getBuilder(index);
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public com.google.cloud.compute.v1.LocalDiskOrBuilder getDisksOrBuilder(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessageOrBuilder(index);
      }
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public java.util.List<? extends com.google.cloud.compute.v1.LocalDiskOrBuilder>
        getDisksOrBuilderList() {
      if (disksBuilder_ != null) {
        return disksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(disks_);
      }
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public com.google.cloud.compute.v1.LocalDisk.Builder addDisksBuilder() {
      return getDisksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.LocalDisk.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public com.google.cloud.compute.v1.LocalDisk.Builder addDisksBuilder(int index) {
      return getDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.LocalDisk.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.compute.v1.LocalDisk disks = 95594102;</code> */
    public java.util.List<com.google.cloud.compute.v1.LocalDisk.Builder> getDisksBuilderList() {
      return getDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.LocalDisk,
            com.google.cloud.compute.v1.LocalDisk.Builder,
            com.google.cloud.compute.v1.LocalDiskOrBuilder>
        getDisksFieldBuilder() {
      if (disksBuilder_ == null) {
        disksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.LocalDisk,
                com.google.cloud.compute.v1.LocalDisk.Builder,
                com.google.cloud.compute.v1.LocalDiskOrBuilder>(
                disks_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        disks_ = null;
      }
      return disksBuilder_;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeTemplate for node templates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> nodeAffinityLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetNodeAffinityLabels() {
      if (nodeAffinityLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            NodeAffinityLabelsDefaultEntryHolder.defaultEntry);
      }
      return nodeAffinityLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableNodeAffinityLabels() {
      if (nodeAffinityLabels_ == null) {
        nodeAffinityLabels_ =
            com.google.protobuf.MapField.newMapField(
                NodeAffinityLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!nodeAffinityLabels_.isMutable()) {
        nodeAffinityLabels_ = nodeAffinityLabels_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return nodeAffinityLabels_;
    }

    public int getNodeAffinityLabelsCount() {
      return internalGetNodeAffinityLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    @java.lang.Override
    public boolean containsNodeAffinityLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetNodeAffinityLabels().getMap().containsKey(key);
    }
    /** Use {@link #getNodeAffinityLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getNodeAffinityLabels() {
      return getNodeAffinityLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getNodeAffinityLabelsMap() {
      return internalGetNodeAffinityLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getNodeAffinityLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetNodeAffinityLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    @java.lang.Override
    public java.lang.String getNodeAffinityLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetNodeAffinityLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearNodeAffinityLabels() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableNodeAffinityLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    public Builder removeNodeAffinityLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableNodeAffinityLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableNodeAffinityLabels() {
      bitField0_ |= 0x00000100;
      return internalGetMutableNodeAffinityLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    public Builder putNodeAffinityLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableNodeAffinityLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to use for node affinity, which will be used in instance scheduling.
     * </pre>
     *
     * <code>map&lt;string, string&gt; node_affinity_labels = 339007161;</code>
     */
    public Builder putAllNodeAffinityLabels(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableNodeAffinityLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private java.lang.Object nodeType_ = "";
    /**
     *
     *
     * <pre>
     * The node type to use for nodes group that are created from this template.
     * </pre>
     *
     * <code>optional string node_type = 465832791;</code>
     *
     * @return Whether the nodeType field is set.
     */
    public boolean hasNodeType() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The node type to use for nodes group that are created from this template.
     * </pre>
     *
     * <code>optional string node_type = 465832791;</code>
     *
     * @return The nodeType.
     */
    public java.lang.String getNodeType() {
      java.lang.Object ref = nodeType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The node type to use for nodes group that are created from this template.
     * </pre>
     *
     * <code>optional string node_type = 465832791;</code>
     *
     * @return The bytes for nodeType.
     */
    public com.google.protobuf.ByteString getNodeTypeBytes() {
      java.lang.Object ref = nodeType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The node type to use for nodes group that are created from this template.
     * </pre>
     *
     * <code>optional string node_type = 465832791;</code>
     *
     * @param value The nodeType to set.
     * @return This builder for chaining.
     */
    public Builder setNodeType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node type to use for nodes group that are created from this template.
     * </pre>
     *
     * <code>optional string node_type = 465832791;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeType() {
      nodeType_ = getDefaultInstance().getNodeType();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node type to use for nodes group that are created from this template.
     * </pre>
     *
     * <code>optional string node_type = 465832791;</code>
     *
     * @param value The bytes for nodeType to set.
     * @return This builder for chaining.
     */
    public Builder setNodeTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility nodeTypeFlexibility_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility,
            com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.Builder,
            com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibilityOrBuilder>
        nodeTypeFlexibilityBuilder_;
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     *
     * @return Whether the nodeTypeFlexibility field is set.
     */
    public boolean hasNodeTypeFlexibility() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     *
     * @return The nodeTypeFlexibility.
     */
    public com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility getNodeTypeFlexibility() {
      if (nodeTypeFlexibilityBuilder_ == null) {
        return nodeTypeFlexibility_ == null
            ? com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.getDefaultInstance()
            : nodeTypeFlexibility_;
      } else {
        return nodeTypeFlexibilityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    public Builder setNodeTypeFlexibility(
        com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility value) {
      if (nodeTypeFlexibilityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeTypeFlexibility_ = value;
      } else {
        nodeTypeFlexibilityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    public Builder setNodeTypeFlexibility(
        com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.Builder builderForValue) {
      if (nodeTypeFlexibilityBuilder_ == null) {
        nodeTypeFlexibility_ = builderForValue.build();
      } else {
        nodeTypeFlexibilityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    public Builder mergeNodeTypeFlexibility(
        com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility value) {
      if (nodeTypeFlexibilityBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && nodeTypeFlexibility_ != null
            && nodeTypeFlexibility_
                != com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility
                    .getDefaultInstance()) {
          getNodeTypeFlexibilityBuilder().mergeFrom(value);
        } else {
          nodeTypeFlexibility_ = value;
        }
      } else {
        nodeTypeFlexibilityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    public Builder clearNodeTypeFlexibility() {
      bitField0_ = (bitField0_ & ~0x00000400);
      nodeTypeFlexibility_ = null;
      if (nodeTypeFlexibilityBuilder_ != null) {
        nodeTypeFlexibilityBuilder_.dispose();
        nodeTypeFlexibilityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    public com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.Builder
        getNodeTypeFlexibilityBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getNodeTypeFlexibilityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    public com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibilityOrBuilder
        getNodeTypeFlexibilityOrBuilder() {
      if (nodeTypeFlexibilityBuilder_ != null) {
        return nodeTypeFlexibilityBuilder_.getMessageOrBuilder();
      } else {
        return nodeTypeFlexibility_ == null
            ? com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.getDefaultInstance()
            : nodeTypeFlexibility_;
      }
    }
    /**
     *
     *
     * <pre>
     * Do not use. Instead, use the node_type property.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility node_type_flexibility = 315257905;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility,
            com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.Builder,
            com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibilityOrBuilder>
        getNodeTypeFlexibilityFieldBuilder() {
      if (nodeTypeFlexibilityBuilder_ == null) {
        nodeTypeFlexibilityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility,
                com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibility.Builder,
                com.google.cloud.compute.v1.NodeTemplateNodeTypeFlexibilityOrBuilder>(
                getNodeTypeFlexibility(), getParentForChildren(), isClean());
        nodeTypeFlexibility_ = null;
      }
      return nodeTypeFlexibilityBuilder_;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the region where the node template resides, such as us-central1.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the region where the node template resides, such as us-central1.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the region where the node template resides, such as us-central1.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the region where the node template resides, such as us-central1.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the region where the node template resides, such as us-central1.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the region where the node template resides, such as us-central1.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ServerBinding serverBinding_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ServerBinding,
            com.google.cloud.compute.v1.ServerBinding.Builder,
            com.google.cloud.compute.v1.ServerBindingOrBuilder>
        serverBindingBuilder_;
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     *
     * @return Whether the serverBinding field is set.
     */
    public boolean hasServerBinding() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     *
     * @return The serverBinding.
     */
    public com.google.cloud.compute.v1.ServerBinding getServerBinding() {
      if (serverBindingBuilder_ == null) {
        return serverBinding_ == null
            ? com.google.cloud.compute.v1.ServerBinding.getDefaultInstance()
            : serverBinding_;
      } else {
        return serverBindingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    public Builder setServerBinding(com.google.cloud.compute.v1.ServerBinding value) {
      if (serverBindingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serverBinding_ = value;
      } else {
        serverBindingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    public Builder setServerBinding(
        com.google.cloud.compute.v1.ServerBinding.Builder builderForValue) {
      if (serverBindingBuilder_ == null) {
        serverBinding_ = builderForValue.build();
      } else {
        serverBindingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    public Builder mergeServerBinding(com.google.cloud.compute.v1.ServerBinding value) {
      if (serverBindingBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && serverBinding_ != null
            && serverBinding_ != com.google.cloud.compute.v1.ServerBinding.getDefaultInstance()) {
          getServerBindingBuilder().mergeFrom(value);
        } else {
          serverBinding_ = value;
        }
      } else {
        serverBindingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    public Builder clearServerBinding() {
      bitField0_ = (bitField0_ & ~0x00002000);
      serverBinding_ = null;
      if (serverBindingBuilder_ != null) {
        serverBindingBuilder_.dispose();
        serverBindingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    public com.google.cloud.compute.v1.ServerBinding.Builder getServerBindingBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getServerBindingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    public com.google.cloud.compute.v1.ServerBindingOrBuilder getServerBindingOrBuilder() {
      if (serverBindingBuilder_ != null) {
        return serverBindingBuilder_.getMessageOrBuilder();
      } else {
        return serverBinding_ == null
            ? com.google.cloud.compute.v1.ServerBinding.getDefaultInstance()
            : serverBinding_;
      }
    }
    /**
     *
     *
     * <pre>
     * Sets the binding properties for the physical server. Valid values include: - *[Default]* RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical server - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server whenever possible See Sole-tenant node options for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ServerBinding server_binding = 208179593;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ServerBinding,
            com.google.cloud.compute.v1.ServerBinding.Builder,
            com.google.cloud.compute.v1.ServerBindingOrBuilder>
        getServerBindingFieldBuilder() {
      if (serverBindingBuilder_ == null) {
        serverBindingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ServerBinding,
                com.google.cloud.compute.v1.ServerBinding.Builder,
                com.google.cloud.compute.v1.ServerBindingOrBuilder>(
                getServerBinding(), getParentForChildren(), isClean());
        serverBinding_ = null;
      }
      return serverBindingBuilder_;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return Whether the statusMessage field is set.
     */
    public boolean hasStatusMessage() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NodeTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NodeTemplate)
  private static final com.google.cloud.compute.v1.NodeTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NodeTemplate();
  }

  public static com.google.cloud.compute.v1.NodeTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeTemplate> PARSER =
      new com.google.protobuf.AbstractParser<NodeTemplate>() {
        @java.lang.Override
        public NodeTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NodeTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
