/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NotificationEndpointGrpcSettings}
 */
public final class NotificationEndpointGrpcSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NotificationEndpointGrpcSettings)
    NotificationEndpointGrpcSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationEndpointGrpcSettings.newBuilder() to construct.
  private NotificationEndpointGrpcSettings(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationEndpointGrpcSettings() {
    authority_ = "";
    endpoint_ = "";
    payloadName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotificationEndpointGrpcSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NotificationEndpointGrpcSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NotificationEndpointGrpcSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.class,
            com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.Builder.class);
  }

  private int bitField0_;
  public static final int AUTHORITY_FIELD_NUMBER = 401868611;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authority_ = "";
  /**
   *
   *
   * <pre>
   * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
   * </pre>
   *
   * <code>optional string authority = 401868611;</code>
   *
   * @return Whether the authority field is set.
   */
  @java.lang.Override
  public boolean hasAuthority() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
   * </pre>
   *
   * <code>optional string authority = 401868611;</code>
   *
   * @return The authority.
   */
  @java.lang.Override
  public java.lang.String getAuthority() {
    java.lang.Object ref = authority_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authority_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
   * </pre>
   *
   * <code>optional string authority = 401868611;</code>
   *
   * @return The bytes for authority.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorityBytes() {
    java.lang.Object ref = authority_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authority_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENDPOINT_FIELD_NUMBER = 130489749;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpoint_ = "";
  /**
   *
   *
   * <pre>
   * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
   * </pre>
   *
   * <code>optional string endpoint = 130489749;</code>
   *
   * @return Whether the endpoint field is set.
   */
  @java.lang.Override
  public boolean hasEndpoint() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
   * </pre>
   *
   * <code>optional string endpoint = 130489749;</code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
   * </pre>
   *
   * <code>optional string endpoint = 130489749;</code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYLOAD_NAME_FIELD_NUMBER = 300358300;

  @SuppressWarnings("serial")
  private volatile java.lang.Object payloadName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
   * </pre>
   *
   * <code>optional string payload_name = 300358300;</code>
   *
   * @return Whether the payloadName field is set.
   */
  @java.lang.Override
  public boolean hasPayloadName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
   * </pre>
   *
   * <code>optional string payload_name = 300358300;</code>
   *
   * @return The payloadName.
   */
  @java.lang.Override
  public java.lang.String getPayloadName() {
    java.lang.Object ref = payloadName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      payloadName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
   * </pre>
   *
   * <code>optional string payload_name = 300358300;</code>
   *
   * @return The bytes for payloadName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPayloadNameBytes() {
    java.lang.Object ref = payloadName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      payloadName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESEND_INTERVAL_FIELD_NUMBER = 478288969;
  private com.google.cloud.compute.v1.Duration resendInterval_;
  /**
   *
   *
   * <pre>
   * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
   *
   * @return Whether the resendInterval field is set.
   */
  @java.lang.Override
  public boolean hasResendInterval() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
   *
   * @return The resendInterval.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getResendInterval() {
    return resendInterval_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : resendInterval_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getResendIntervalOrBuilder() {
    return resendInterval_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : resendInterval_;
  }

  public static final int RETRY_DURATION_SEC_FIELD_NUMBER = 115681117;
  private int retryDurationSec_ = 0;
  /**
   *
   *
   * <pre>
   * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
   * </pre>
   *
   * <code>optional uint32 retry_duration_sec = 115681117;</code>
   *
   * @return Whether the retryDurationSec field is set.
   */
  @java.lang.Override
  public boolean hasRetryDurationSec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
   * </pre>
   *
   * <code>optional uint32 retry_duration_sec = 115681117;</code>
   *
   * @return The retryDurationSec.
   */
  @java.lang.Override
  public int getRetryDurationSec() {
    return retryDurationSec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt32(115681117, retryDurationSec_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 130489749, endpoint_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 300358300, payloadName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 401868611, authority_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(478288969, getResendInterval());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(115681117, retryDurationSec_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(130489749, endpoint_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(300358300, payloadName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(401868611, authority_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(478288969, getResendInterval());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NotificationEndpointGrpcSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NotificationEndpointGrpcSettings other =
        (com.google.cloud.compute.v1.NotificationEndpointGrpcSettings) obj;

    if (hasAuthority() != other.hasAuthority()) return false;
    if (hasAuthority()) {
      if (!getAuthority().equals(other.getAuthority())) return false;
    }
    if (hasEndpoint() != other.hasEndpoint()) return false;
    if (hasEndpoint()) {
      if (!getEndpoint().equals(other.getEndpoint())) return false;
    }
    if (hasPayloadName() != other.hasPayloadName()) return false;
    if (hasPayloadName()) {
      if (!getPayloadName().equals(other.getPayloadName())) return false;
    }
    if (hasResendInterval() != other.hasResendInterval()) return false;
    if (hasResendInterval()) {
      if (!getResendInterval().equals(other.getResendInterval())) return false;
    }
    if (hasRetryDurationSec() != other.hasRetryDurationSec()) return false;
    if (hasRetryDurationSec()) {
      if (getRetryDurationSec() != other.getRetryDurationSec()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAuthority()) {
      hash = (37 * hash) + AUTHORITY_FIELD_NUMBER;
      hash = (53 * hash) + getAuthority().hashCode();
    }
    if (hasEndpoint()) {
      hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpoint().hashCode();
    }
    if (hasPayloadName()) {
      hash = (37 * hash) + PAYLOAD_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPayloadName().hashCode();
    }
    if (hasResendInterval()) {
      hash = (37 * hash) + RESEND_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getResendInterval().hashCode();
    }
    if (hasRetryDurationSec()) {
      hash = (37 * hash) + RETRY_DURATION_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getRetryDurationSec();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.NotificationEndpointGrpcSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NotificationEndpointGrpcSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NotificationEndpointGrpcSettings)
      com.google.cloud.compute.v1.NotificationEndpointGrpcSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NotificationEndpointGrpcSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NotificationEndpointGrpcSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.class,
              com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResendIntervalFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      authority_ = "";
      endpoint_ = "";
      payloadName_ = "";
      resendInterval_ = null;
      if (resendIntervalBuilder_ != null) {
        resendIntervalBuilder_.dispose();
        resendIntervalBuilder_ = null;
      }
      retryDurationSec_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NotificationEndpointGrpcSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NotificationEndpointGrpcSettings
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NotificationEndpointGrpcSettings build() {
      com.google.cloud.compute.v1.NotificationEndpointGrpcSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NotificationEndpointGrpcSettings buildPartial() {
      com.google.cloud.compute.v1.NotificationEndpointGrpcSettings result =
          new com.google.cloud.compute.v1.NotificationEndpointGrpcSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.NotificationEndpointGrpcSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.authority_ = authority_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endpoint_ = endpoint_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.payloadName_ = payloadName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resendInterval_ =
            resendIntervalBuilder_ == null ? resendInterval_ : resendIntervalBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.retryDurationSec_ = retryDurationSec_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NotificationEndpointGrpcSettings) {
        return mergeFrom((com.google.cloud.compute.v1.NotificationEndpointGrpcSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NotificationEndpointGrpcSettings other) {
      if (other
          == com.google.cloud.compute.v1.NotificationEndpointGrpcSettings.getDefaultInstance())
        return this;
      if (other.hasAuthority()) {
        authority_ = other.authority_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEndpoint()) {
        endpoint_ = other.endpoint_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPayloadName()) {
        payloadName_ = other.payloadName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasResendInterval()) {
        mergeResendInterval(other.getResendInterval());
      }
      if (other.hasRetryDurationSec()) {
        setRetryDurationSec(other.getRetryDurationSec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 925448936:
              {
                retryDurationSec_ = input.readUInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 925448936
            case 1043917994:
              {
                endpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1043917994
            case -1892100894:
              {
                payloadName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -1892100894
            case -1080018406:
              {
                authority_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1080018406
            case -468655542:
              {
                input.readMessage(getResendIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -468655542
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object authority_ = "";
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
     * </pre>
     *
     * <code>optional string authority = 401868611;</code>
     *
     * @return Whether the authority field is set.
     */
    public boolean hasAuthority() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
     * </pre>
     *
     * <code>optional string authority = 401868611;</code>
     *
     * @return The authority.
     */
    public java.lang.String getAuthority() {
      java.lang.Object ref = authority_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authority_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
     * </pre>
     *
     * <code>optional string authority = 401868611;</code>
     *
     * @return The bytes for authority.
     */
    public com.google.protobuf.ByteString getAuthorityBytes() {
      java.lang.Object ref = authority_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authority_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
     * </pre>
     *
     * <code>optional string authority = 401868611;</code>
     *
     * @param value The authority to set.
     * @return This builder for chaining.
     */
    public Builder setAuthority(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authority_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
     * </pre>
     *
     * <code>optional string authority = 401868611;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthority() {
      authority_ = getDefaultInstance().getAuthority();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
     * </pre>
     *
     * <code>optional string authority = 401868611;</code>
     *
     * @param value The bytes for authority to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authority_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
     * </pre>
     *
     * <code>optional string endpoint = 130489749;</code>
     *
     * @return Whether the endpoint field is set.
     */
    public boolean hasEndpoint() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
     * </pre>
     *
     * <code>optional string endpoint = 130489749;</code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
     * </pre>
     *
     * <code>optional string endpoint = 130489749;</code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
     * </pre>
     *
     * <code>optional string endpoint = 130489749;</code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpoint_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
     * </pre>
     *
     * <code>optional string endpoint = 130489749;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {
      endpoint_ = getDefaultInstance().getEndpoint();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
     * </pre>
     *
     * <code>optional string endpoint = 130489749;</code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpoint_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object payloadName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
     * </pre>
     *
     * <code>optional string payload_name = 300358300;</code>
     *
     * @return Whether the payloadName field is set.
     */
    public boolean hasPayloadName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
     * </pre>
     *
     * <code>optional string payload_name = 300358300;</code>
     *
     * @return The payloadName.
     */
    public java.lang.String getPayloadName() {
      java.lang.Object ref = payloadName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payloadName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
     * </pre>
     *
     * <code>optional string payload_name = 300358300;</code>
     *
     * @return The bytes for payloadName.
     */
    public com.google.protobuf.ByteString getPayloadNameBytes() {
      java.lang.Object ref = payloadName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        payloadName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
     * </pre>
     *
     * <code>optional string payload_name = 300358300;</code>
     *
     * @param value The payloadName to set.
     * @return This builder for chaining.
     */
    public Builder setPayloadName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      payloadName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
     * </pre>
     *
     * <code>optional string payload_name = 300358300;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPayloadName() {
      payloadName_ = getDefaultInstance().getPayloadName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, this field is used to populate the "name" field in gRPC requests.
     * </pre>
     *
     * <code>optional string payload_name = 300358300;</code>
     *
     * @param value The bytes for payloadName to set.
     * @return This builder for chaining.
     */
    public Builder setPayloadNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      payloadName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Duration resendInterval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        resendIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     *
     * @return Whether the resendInterval field is set.
     */
    public boolean hasResendInterval() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     *
     * @return The resendInterval.
     */
    public com.google.cloud.compute.v1.Duration getResendInterval() {
      if (resendIntervalBuilder_ == null) {
        return resendInterval_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : resendInterval_;
      } else {
        return resendIntervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    public Builder setResendInterval(com.google.cloud.compute.v1.Duration value) {
      if (resendIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resendInterval_ = value;
      } else {
        resendIntervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    public Builder setResendInterval(com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (resendIntervalBuilder_ == null) {
        resendInterval_ = builderForValue.build();
      } else {
        resendIntervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    public Builder mergeResendInterval(com.google.cloud.compute.v1.Duration value) {
      if (resendIntervalBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && resendInterval_ != null
            && resendInterval_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getResendIntervalBuilder().mergeFrom(value);
        } else {
          resendInterval_ = value;
        }
      } else {
        resendIntervalBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    public Builder clearResendInterval() {
      bitField0_ = (bitField0_ & ~0x00000008);
      resendInterval_ = null;
      if (resendIntervalBuilder_ != null) {
        resendIntervalBuilder_.dispose();
        resendIntervalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getResendIntervalBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getResendIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getResendIntervalOrBuilder() {
      if (resendIntervalBuilder_ != null) {
        return resendIntervalBuilder_.getMessageOrBuilder();
      } else {
        return resendInterval_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : resendInterval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed. Can only be set for regional notification endpoints.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration resend_interval = 478288969;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getResendIntervalFieldBuilder() {
      if (resendIntervalBuilder_ == null) {
        resendIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getResendInterval(), getParentForChildren(), isClean());
        resendInterval_ = null;
      }
      return resendIntervalBuilder_;
    }

    private int retryDurationSec_;
    /**
     *
     *
     * <pre>
     * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
     * </pre>
     *
     * <code>optional uint32 retry_duration_sec = 115681117;</code>
     *
     * @return Whether the retryDurationSec field is set.
     */
    @java.lang.Override
    public boolean hasRetryDurationSec() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
     * </pre>
     *
     * <code>optional uint32 retry_duration_sec = 115681117;</code>
     *
     * @return The retryDurationSec.
     */
    @java.lang.Override
    public int getRetryDurationSec() {
      return retryDurationSec_;
    }
    /**
     *
     *
     * <pre>
     * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
     * </pre>
     *
     * <code>optional uint32 retry_duration_sec = 115681117;</code>
     *
     * @param value The retryDurationSec to set.
     * @return This builder for chaining.
     */
    public Builder setRetryDurationSec(int value) {

      retryDurationSec_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
     * </pre>
     *
     * <code>optional uint32 retry_duration_sec = 115681117;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetryDurationSec() {
      bitField0_ = (bitField0_ & ~0x00000010);
      retryDurationSec_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NotificationEndpointGrpcSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NotificationEndpointGrpcSettings)
  private static final com.google.cloud.compute.v1.NotificationEndpointGrpcSettings
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NotificationEndpointGrpcSettings();
  }

  public static com.google.cloud.compute.v1.NotificationEndpointGrpcSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationEndpointGrpcSettings> PARSER =
      new com.google.protobuf.AbstractParser<NotificationEndpointGrpcSettings>() {
        @java.lang.Override
        public NotificationEndpointGrpcSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotificationEndpointGrpcSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationEndpointGrpcSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NotificationEndpointGrpcSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
