/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Specified snapshot properties for scheduled snapshots created by this policy.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties}
 */
public final class ResourcePolicySnapshotSchedulePolicySnapshotProperties
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties)
    ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourcePolicySnapshotSchedulePolicySnapshotProperties.newBuilder() to construct.
  private ResourcePolicySnapshotSchedulePolicySnapshotProperties(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourcePolicySnapshotSchedulePolicySnapshotProperties() {
    chainName_ = "";
    storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourcePolicySnapshotSchedulePolicySnapshotProperties();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicySnapshotProperties_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicySnapshotProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                .class,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                .Builder.class);
  }

  private int bitField0_;
  public static final int CHAIN_NAME_FIELD_NUMBER = 68644169;

  @SuppressWarnings("serial")
  private volatile java.lang.Object chainName_ = "";
  /**
   *
   *
   * <pre>
   * Chain name that the snapshot is created in.
   * </pre>
   *
   * <code>optional string chain_name = 68644169;</code>
   *
   * @return Whether the chainName field is set.
   */
  @java.lang.Override
  public boolean hasChainName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Chain name that the snapshot is created in.
   * </pre>
   *
   * <code>optional string chain_name = 68644169;</code>
   *
   * @return The chainName.
   */
  @java.lang.Override
  public java.lang.String getChainName() {
    java.lang.Object ref = chainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      chainName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Chain name that the snapshot is created in.
   * </pre>
   *
   * <code>optional string chain_name = 68644169;</code>
   *
   * @return The bytes for chainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChainNameBytes() {
    java.lang.Object ref = chainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      chainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GUEST_FLUSH_FIELD_NUMBER = 385550813;
  private boolean guestFlush_ = false;
  /**
   *
   *
   * <pre>
   * Indication to perform a 'guest aware' snapshot.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return Whether the guestFlush field is set.
   */
  @java.lang.Override
  public boolean hasGuestFlush() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indication to perform a 'guest aware' snapshot.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return The guestFlush.
   */
  @java.lang.Override
  public boolean getGuestFlush() {
    return guestFlush_;
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicySnapshotProperties_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STORAGE_LOCATIONS_FIELD_NUMBER = 328005274;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList storageLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return A list containing the storageLocations.
   */
  public com.google.protobuf.ProtocolStringList getStorageLocationsList() {
    return storageLocations_;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return The count of storageLocations.
   */
  public int getStorageLocationsCount() {
    return storageLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the element to return.
   * @return The storageLocations at the given index.
   */
  public java.lang.String getStorageLocations(int index) {
    return storageLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the storageLocations at the given index.
   */
  public com.google.protobuf.ByteString getStorageLocationsBytes(int index) {
    return storageLocations_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 68644169, chainName_);
    }
    for (int i = 0; i < storageLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 328005274, storageLocations_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(385550813, guestFlush_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(68644169, chainName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < storageLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(storageLocations_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getStorageLocationsList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(385550813, guestFlush_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties other =
        (com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties) obj;

    if (hasChainName() != other.hasChainName()) return false;
    if (hasChainName()) {
      if (!getChainName().equals(other.getChainName())) return false;
    }
    if (hasGuestFlush() != other.hasGuestFlush()) return false;
    if (hasGuestFlush()) {
      if (getGuestFlush() != other.getGuestFlush()) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getStorageLocationsList().equals(other.getStorageLocationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasChainName()) {
      hash = (37 * hash) + CHAIN_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getChainName().hashCode();
    }
    if (hasGuestFlush()) {
      hash = (37 * hash) + GUEST_FLUSH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGuestFlush());
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getStorageLocationsCount() > 0) {
      hash = (37 * hash) + STORAGE_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getStorageLocationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specified snapshot properties for scheduled snapshots created by this policy.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties)
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicySnapshotProperties_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicySnapshotProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                  .class,
              com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      chainName_ = "";
      guestFlush_ = false;
      internalGetMutableLabels().clear();
      storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicySnapshotProperties_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
        build() {
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
        buildPartial() {
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties result =
          new com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties(
              this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.chainName_ = chainName_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.guestFlush_ = guestFlush_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        storageLocations_.makeImmutable();
        result.storageLocations_ = storageLocations_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties) {
        return mergeFrom(
            (com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties other) {
      if (other
          == com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
              .getDefaultInstance()) return this;
      if (other.hasChainName()) {
        chainName_ = other.chainName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasGuestFlush()) {
        setGuestFlush(other.getGuestFlush());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      if (!other.storageLocations_.isEmpty()) {
        if (storageLocations_.isEmpty()) {
          storageLocations_ = other.storageLocations_;
          bitField0_ |= 0x00000008;
        } else {
          ensureStorageLocationsIsMutable();
          storageLocations_.addAll(other.storageLocations_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 549153354:
              {
                chainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 549153354
            case -1670925102:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStorageLocationsIsMutable();
                storageLocations_.add(s);
                break;
              } // case -1670925102
            case -1210560792:
              {
                guestFlush_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -1210560792
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case -293404678
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object chainName_ = "";
    /**
     *
     *
     * <pre>
     * Chain name that the snapshot is created in.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return Whether the chainName field is set.
     */
    public boolean hasChainName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Chain name that the snapshot is created in.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return The chainName.
     */
    public java.lang.String getChainName() {
      java.lang.Object ref = chainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        chainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Chain name that the snapshot is created in.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return The bytes for chainName.
     */
    public com.google.protobuf.ByteString getChainNameBytes() {
      java.lang.Object ref = chainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        chainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Chain name that the snapshot is created in.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @param value The chainName to set.
     * @return This builder for chaining.
     */
    public Builder setChainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      chainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Chain name that the snapshot is created in.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChainName() {
      chainName_ = getDefaultInstance().getChainName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Chain name that the snapshot is created in.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @param value The bytes for chainName to set.
     * @return This builder for chaining.
     */
    public Builder setChainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      chainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean guestFlush_;
    /**
     *
     *
     * <pre>
     * Indication to perform a 'guest aware' snapshot.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return Whether the guestFlush field is set.
     */
    @java.lang.Override
    public boolean hasGuestFlush() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indication to perform a 'guest aware' snapshot.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return The guestFlush.
     */
    @java.lang.Override
    public boolean getGuestFlush() {
      return guestFlush_;
    }
    /**
     *
     *
     * <pre>
     * Indication to perform a 'guest aware' snapshot.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @param value The guestFlush to set.
     * @return This builder for chaining.
     */
    public Builder setGuestFlush(boolean value) {

      guestFlush_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indication to perform a 'guest aware' snapshot.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGuestFlush() {
      bitField0_ = (bitField0_ & ~0x00000002);
      guestFlush_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList storageLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStorageLocationsIsMutable() {
      if (!storageLocations_.isModifiable()) {
        storageLocations_ = new com.google.protobuf.LazyStringArrayList(storageLocations_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return A list containing the storageLocations.
     */
    public com.google.protobuf.ProtocolStringList getStorageLocationsList() {
      storageLocations_.makeImmutable();
      return storageLocations_;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return The count of storageLocations.
     */
    public int getStorageLocationsCount() {
      return storageLocations_.size();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index of the element to return.
     * @return The storageLocations at the given index.
     */
    public java.lang.String getStorageLocations(int index) {
      return storageLocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the storageLocations at the given index.
     */
    public com.google.protobuf.ByteString getStorageLocationsBytes(int index) {
      return storageLocations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index to set the value at.
     * @param value The storageLocations to set.
     * @return This builder for chaining.
     */
    public Builder setStorageLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStorageLocationsIsMutable();
      storageLocations_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param value The storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addStorageLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStorageLocationsIsMutable();
      storageLocations_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param values The storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllStorageLocations(java.lang.Iterable<java.lang.String> values) {
      ensureStorageLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, storageLocations_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageLocations() {
      storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param value The bytes of the storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addStorageLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStorageLocationsIsMutable();
      storageLocations_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties)
  private static final com.google.cloud.compute.v1
          .ResourcePolicySnapshotSchedulePolicySnapshotProperties
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties();
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          ResourcePolicySnapshotSchedulePolicySnapshotProperties>
      PARSER =
          new com.google.protobuf.AbstractParser<
              ResourcePolicySnapshotSchedulePolicySnapshotProperties>() {
            @java.lang.Override
            public ResourcePolicySnapshotSchedulePolicySnapshotProperties parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<ResourcePolicySnapshotSchedulePolicySnapshotProperties>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourcePolicySnapshotSchedulePolicySnapshotProperties>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
