/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterBgpPeerBfd}
 */
public final class RouterBgpPeerBfd extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterBgpPeerBfd)
    RouterBgpPeerBfdOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouterBgpPeerBfd.newBuilder() to construct.
  private RouterBgpPeerBfd(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterBgpPeerBfd() {
    sessionInitializationMode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterBgpPeerBfd();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterBgpPeerBfd_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterBgpPeerBfd_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterBgpPeerBfd.class,
            com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgpPeerBfd.SessionInitializationMode}
   */
  public enum SessionInitializationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SESSION_INITIALIZATION_MODE = 0;</code>
     */
    UNDEFINED_SESSION_INITIALIZATION_MODE(0),
    /** <code>ACTIVE = 314733318;</code> */
    ACTIVE(314733318),
    /** <code>DISABLED = 516696700;</code> */
    DISABLED(516696700),
    /** <code>PASSIVE = 462813959;</code> */
    PASSIVE(462813959),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SESSION_INITIALIZATION_MODE = 0;</code>
     */
    public static final int UNDEFINED_SESSION_INITIALIZATION_MODE_VALUE = 0;
    /** <code>ACTIVE = 314733318;</code> */
    public static final int ACTIVE_VALUE = 314733318;
    /** <code>DISABLED = 516696700;</code> */
    public static final int DISABLED_VALUE = 516696700;
    /** <code>PASSIVE = 462813959;</code> */
    public static final int PASSIVE_VALUE = 462813959;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SessionInitializationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SessionInitializationMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SESSION_INITIALIZATION_MODE;
        case 314733318:
          return ACTIVE;
        case 516696700:
          return DISABLED;
        case 462813959:
          return PASSIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SessionInitializationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SessionInitializationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SessionInitializationMode>() {
              public SessionInitializationMode findValueByNumber(int number) {
                return SessionInitializationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgpPeerBfd.getDescriptor().getEnumTypes().get(0);
    }

    private static final SessionInitializationMode[] VALUES = values();

    public static SessionInitializationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SessionInitializationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgpPeerBfd.SessionInitializationMode)
  }

  private int bitField0_;
  public static final int MIN_RECEIVE_INTERVAL_FIELD_NUMBER = 186981614;
  private int minReceiveInterval_ = 0;
  /**
   *
   *
   * <pre>
   * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
   * </pre>
   *
   * <code>optional uint32 min_receive_interval = 186981614;</code>
   *
   * @return Whether the minReceiveInterval field is set.
   */
  @java.lang.Override
  public boolean hasMinReceiveInterval() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
   * </pre>
   *
   * <code>optional uint32 min_receive_interval = 186981614;</code>
   *
   * @return The minReceiveInterval.
   */
  @java.lang.Override
  public int getMinReceiveInterval() {
    return minReceiveInterval_;
  }

  public static final int MIN_TRANSMIT_INTERVAL_FIELD_NUMBER = 523282631;
  private int minTransmitInterval_ = 0;
  /**
   *
   *
   * <pre>
   * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
   * </pre>
   *
   * <code>optional uint32 min_transmit_interval = 523282631;</code>
   *
   * @return Whether the minTransmitInterval field is set.
   */
  @java.lang.Override
  public boolean hasMinTransmitInterval() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
   * </pre>
   *
   * <code>optional uint32 min_transmit_interval = 523282631;</code>
   *
   * @return The minTransmitInterval.
   */
  @java.lang.Override
  public int getMinTransmitInterval() {
    return minTransmitInterval_;
  }

  public static final int MULTIPLIER_FIELD_NUMBER = 191331777;
  private int multiplier_ = 0;
  /**
   *
   *
   * <pre>
   * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
   * </pre>
   *
   * <code>optional uint32 multiplier = 191331777;</code>
   *
   * @return Whether the multiplier field is set.
   */
  @java.lang.Override
  public boolean hasMultiplier() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
   * </pre>
   *
   * <code>optional uint32 multiplier = 191331777;</code>
   *
   * @return The multiplier.
   */
  @java.lang.Override
  public int getMultiplier() {
    return multiplier_;
  }

  public static final int SESSION_INITIALIZATION_MODE_FIELD_NUMBER = 105957049;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sessionInitializationMode_ = "";
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
   * Check the SessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_initialization_mode = 105957049;</code>
   *
   * @return Whether the sessionInitializationMode field is set.
   */
  @java.lang.Override
  public boolean hasSessionInitializationMode() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
   * Check the SessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_initialization_mode = 105957049;</code>
   *
   * @return The sessionInitializationMode.
   */
  @java.lang.Override
  public java.lang.String getSessionInitializationMode() {
    java.lang.Object ref = sessionInitializationMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionInitializationMode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
   * Check the SessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_initialization_mode = 105957049;</code>
   *
   * @return The bytes for sessionInitializationMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionInitializationModeBytes() {
    java.lang.Object ref = sessionInitializationMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionInitializationMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 105957049, sessionInitializationMode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeUInt32(186981614, minReceiveInterval_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeUInt32(191331777, multiplier_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeUInt32(523282631, minTransmitInterval_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              105957049, sessionInitializationMode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(186981614, minReceiveInterval_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(191331777, multiplier_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(523282631, minTransmitInterval_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterBgpPeerBfd)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterBgpPeerBfd other =
        (com.google.cloud.compute.v1.RouterBgpPeerBfd) obj;

    if (hasMinReceiveInterval() != other.hasMinReceiveInterval()) return false;
    if (hasMinReceiveInterval()) {
      if (getMinReceiveInterval() != other.getMinReceiveInterval()) return false;
    }
    if (hasMinTransmitInterval() != other.hasMinTransmitInterval()) return false;
    if (hasMinTransmitInterval()) {
      if (getMinTransmitInterval() != other.getMinTransmitInterval()) return false;
    }
    if (hasMultiplier() != other.hasMultiplier()) return false;
    if (hasMultiplier()) {
      if (getMultiplier() != other.getMultiplier()) return false;
    }
    if (hasSessionInitializationMode() != other.hasSessionInitializationMode()) return false;
    if (hasSessionInitializationMode()) {
      if (!getSessionInitializationMode().equals(other.getSessionInitializationMode()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMinReceiveInterval()) {
      hash = (37 * hash) + MIN_RECEIVE_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getMinReceiveInterval();
    }
    if (hasMinTransmitInterval()) {
      hash = (37 * hash) + MIN_TRANSMIT_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getMinTransmitInterval();
    }
    if (hasMultiplier()) {
      hash = (37 * hash) + MULTIPLIER_FIELD_NUMBER;
      hash = (53 * hash) + getMultiplier();
    }
    if (hasSessionInitializationMode()) {
      hash = (37 * hash) + SESSION_INITIALIZATION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getSessionInitializationMode().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterBgpPeerBfd prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterBgpPeerBfd}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterBgpPeerBfd)
      com.google.cloud.compute.v1.RouterBgpPeerBfdOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgpPeerBfd_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgpPeerBfd_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterBgpPeerBfd.class,
              com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterBgpPeerBfd.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      minReceiveInterval_ = 0;
      minTransmitInterval_ = 0;
      multiplier_ = 0;
      sessionInitializationMode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgpPeerBfd_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgpPeerBfd getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgpPeerBfd build() {
      com.google.cloud.compute.v1.RouterBgpPeerBfd result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgpPeerBfd buildPartial() {
      com.google.cloud.compute.v1.RouterBgpPeerBfd result =
          new com.google.cloud.compute.v1.RouterBgpPeerBfd(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterBgpPeerBfd result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.minReceiveInterval_ = minReceiveInterval_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.minTransmitInterval_ = minTransmitInterval_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.multiplier_ = multiplier_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sessionInitializationMode_ = sessionInitializationMode_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterBgpPeerBfd) {
        return mergeFrom((com.google.cloud.compute.v1.RouterBgpPeerBfd) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterBgpPeerBfd other) {
      if (other == com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance()) return this;
      if (other.hasMinReceiveInterval()) {
        setMinReceiveInterval(other.getMinReceiveInterval());
      }
      if (other.hasMinTransmitInterval()) {
        setMinTransmitInterval(other.getMinTransmitInterval());
      }
      if (other.hasMultiplier()) {
        setMultiplier(other.getMultiplier());
      }
      if (other.hasSessionInitializationMode()) {
        sessionInitializationMode_ = other.sessionInitializationMode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 847656394:
              {
                sessionInitializationMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 847656394
            case 1495852912:
              {
                minReceiveInterval_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 1495852912
            case 1530654216:
              {
                multiplier_ = input.readUInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 1530654216
            case -108706248:
              {
                minTransmitInterval_ = input.readUInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case -108706248
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int minReceiveInterval_;
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_receive_interval = 186981614;</code>
     *
     * @return Whether the minReceiveInterval field is set.
     */
    @java.lang.Override
    public boolean hasMinReceiveInterval() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_receive_interval = 186981614;</code>
     *
     * @return The minReceiveInterval.
     */
    @java.lang.Override
    public int getMinReceiveInterval() {
      return minReceiveInterval_;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_receive_interval = 186981614;</code>
     *
     * @param value The minReceiveInterval to set.
     * @return This builder for chaining.
     */
    public Builder setMinReceiveInterval(int value) {

      minReceiveInterval_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_receive_interval = 186981614;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinReceiveInterval() {
      bitField0_ = (bitField0_ & ~0x00000001);
      minReceiveInterval_ = 0;
      onChanged();
      return this;
    }

    private int minTransmitInterval_;
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_transmit_interval = 523282631;</code>
     *
     * @return Whether the minTransmitInterval field is set.
     */
    @java.lang.Override
    public boolean hasMinTransmitInterval() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_transmit_interval = 523282631;</code>
     *
     * @return The minTransmitInterval.
     */
    @java.lang.Override
    public int getMinTransmitInterval() {
      return minTransmitInterval_;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_transmit_interval = 523282631;</code>
     *
     * @param value The minTransmitInterval to set.
     * @return This builder for chaining.
     */
    public Builder setMinTransmitInterval(int value) {

      minTransmitInterval_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
     * </pre>
     *
     * <code>optional uint32 min_transmit_interval = 523282631;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinTransmitInterval() {
      bitField0_ = (bitField0_ & ~0x00000002);
      minTransmitInterval_ = 0;
      onChanged();
      return this;
    }

    private int multiplier_;
    /**
     *
     *
     * <pre>
     * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @return Whether the multiplier field is set.
     */
    @java.lang.Override
    public boolean hasMultiplier() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @return The multiplier.
     */
    @java.lang.Override
    public int getMultiplier() {
      return multiplier_;
    }
    /**
     *
     *
     * <pre>
     * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @param value The multiplier to set.
     * @return This builder for chaining.
     */
    public Builder setMultiplier(int value) {

      multiplier_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiplier() {
      bitField0_ = (bitField0_ & ~0x00000004);
      multiplier_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object sessionInitializationMode_ = "";
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
     * Check the SessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_initialization_mode = 105957049;</code>
     *
     * @return Whether the sessionInitializationMode field is set.
     */
    public boolean hasSessionInitializationMode() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
     * Check the SessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_initialization_mode = 105957049;</code>
     *
     * @return The sessionInitializationMode.
     */
    public java.lang.String getSessionInitializationMode() {
      java.lang.Object ref = sessionInitializationMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionInitializationMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
     * Check the SessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_initialization_mode = 105957049;</code>
     *
     * @return The bytes for sessionInitializationMode.
     */
    public com.google.protobuf.ByteString getSessionInitializationModeBytes() {
      java.lang.Object ref = sessionInitializationMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionInitializationMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
     * Check the SessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_initialization_mode = 105957049;</code>
     *
     * @param value The sessionInitializationMode to set.
     * @return This builder for chaining.
     */
    public Builder setSessionInitializationMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sessionInitializationMode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
     * Check the SessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_initialization_mode = 105957049;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionInitializationMode() {
      sessionInitializationMode_ = getDefaultInstance().getSessionInitializationMode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
     * Check the SessionInitializationMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_initialization_mode = 105957049;</code>
     *
     * @param value The bytes for sessionInitializationMode to set.
     * @return This builder for chaining.
     */
    public Builder setSessionInitializationModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sessionInitializationMode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterBgpPeerBfd)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterBgpPeerBfd)
  private static final com.google.cloud.compute.v1.RouterBgpPeerBfd DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterBgpPeerBfd();
  }

  public static com.google.cloud.compute.v1.RouterBgpPeerBfd getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterBgpPeerBfd> PARSER =
      new com.google.protobuf.AbstractParser<RouterBgpPeerBfd>() {
        @java.lang.Override
        public RouterBgpPeerBfd parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterBgpPeerBfd> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterBgpPeerBfd> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeerBfd getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
