/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Status of a NAT contained in this router.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterStatusNatStatus}
 */
public final class RouterStatusNatStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterStatusNatStatus)
    RouterStatusNatStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouterStatusNatStatus.newBuilder() to construct.
  private RouterStatusNatStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterStatusNatStatus() {
    autoAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    drainAutoAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    drainUserAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    name_ = "";
    ruleStatus_ = java.util.Collections.emptyList();
    userAllocatedNatIpResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
    userAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterStatusNatStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatusNatStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatusNatStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterStatusNatStatus.class,
            com.google.cloud.compute.v1.RouterStatusNatStatus.Builder.class);
  }

  private int bitField0_;
  public static final int AUTO_ALLOCATED_NAT_IPS_FIELD_NUMBER = 510794246;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList autoAllocatedNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * </pre>
   *
   * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
   *
   * @return A list containing the autoAllocatedNatIps.
   */
  public com.google.protobuf.ProtocolStringList getAutoAllocatedNatIpsList() {
    return autoAllocatedNatIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * </pre>
   *
   * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
   *
   * @return The count of autoAllocatedNatIps.
   */
  public int getAutoAllocatedNatIpsCount() {
    return autoAllocatedNatIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * </pre>
   *
   * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
   *
   * @param index The index of the element to return.
   * @return The autoAllocatedNatIps at the given index.
   */
  public java.lang.String getAutoAllocatedNatIps(int index) {
    return autoAllocatedNatIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
   * </pre>
   *
   * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the autoAllocatedNatIps at the given index.
   */
  public com.google.protobuf.ByteString getAutoAllocatedNatIpsBytes(int index) {
    return autoAllocatedNatIps_.getByteString(index);
  }

  public static final int DRAIN_AUTO_ALLOCATED_NAT_IPS_FIELD_NUMBER = 309184557;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList drainAutoAllocatedNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
   *
   * @return A list containing the drainAutoAllocatedNatIps.
   */
  public com.google.protobuf.ProtocolStringList getDrainAutoAllocatedNatIpsList() {
    return drainAutoAllocatedNatIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
   *
   * @return The count of drainAutoAllocatedNatIps.
   */
  public int getDrainAutoAllocatedNatIpsCount() {
    return drainAutoAllocatedNatIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
   *
   * @param index The index of the element to return.
   * @return The drainAutoAllocatedNatIps at the given index.
   */
  public java.lang.String getDrainAutoAllocatedNatIps(int index) {
    return drainAutoAllocatedNatIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the drainAutoAllocatedNatIps at the given index.
   */
  public com.google.protobuf.ByteString getDrainAutoAllocatedNatIpsBytes(int index) {
    return drainAutoAllocatedNatIps_.getByteString(index);
  }

  public static final int DRAIN_USER_ALLOCATED_NAT_IPS_FIELD_NUMBER = 305268553;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList drainUserAllocatedNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
   *
   * @return A list containing the drainUserAllocatedNatIps.
   */
  public com.google.protobuf.ProtocolStringList getDrainUserAllocatedNatIpsList() {
    return drainUserAllocatedNatIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
   *
   * @return The count of drainUserAllocatedNatIps.
   */
  public int getDrainUserAllocatedNatIpsCount() {
    return drainUserAllocatedNatIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
   *
   * @param index The index of the element to return.
   * @return The drainUserAllocatedNatIps at the given index.
   */
  public java.lang.String getDrainUserAllocatedNatIps(int index) {
    return drainUserAllocatedNatIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the drainUserAllocatedNatIps at the given index.
   */
  public com.google.protobuf.ByteString getDrainUserAllocatedNatIpsBytes(int index) {
    return drainUserAllocatedNatIps_.getByteString(index);
  }

  public static final int MIN_EXTRA_NAT_IPS_NEEDED_FIELD_NUMBER = 365786338;
  private int minExtraNatIpsNeeded_ = 0;
  /**
   *
   *
   * <pre>
   * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
   * </pre>
   *
   * <code>optional int32 min_extra_nat_ips_needed = 365786338;</code>
   *
   * @return Whether the minExtraNatIpsNeeded field is set.
   */
  @java.lang.Override
  public boolean hasMinExtraNatIpsNeeded() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
   * </pre>
   *
   * <code>optional int32 min_extra_nat_ips_needed = 365786338;</code>
   *
   * @return The minExtraNatIpsNeeded.
   */
  @java.lang.Override
  public int getMinExtraNatIpsNeeded() {
    return minExtraNatIpsNeeded_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Unique name of this NAT.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Unique name of this NAT.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique name of this NAT.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NUM_VM_ENDPOINTS_WITH_NAT_MAPPINGS_FIELD_NUMBER = 512367468;
  private int numVmEndpointsWithNatMappings_ = 0;
  /**
   *
   *
   * <pre>
   * Number of VM endpoints (i.e., Nics) that can use NAT.
   * </pre>
   *
   * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
   *
   * @return Whether the numVmEndpointsWithNatMappings field is set.
   */
  @java.lang.Override
  public boolean hasNumVmEndpointsWithNatMappings() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Number of VM endpoints (i.e., Nics) that can use NAT.
   * </pre>
   *
   * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
   *
   * @return The numVmEndpointsWithNatMappings.
   */
  @java.lang.Override
  public int getNumVmEndpointsWithNatMappings() {
    return numVmEndpointsWithNatMappings_;
  }

  public static final int RULE_STATUS_FIELD_NUMBER = 140223125;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus>
      ruleStatus_;
  /**
   *
   *
   * <pre>
   * Status of rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus>
      getRuleStatusList() {
    return ruleStatus_;
  }
  /**
   *
   *
   * <pre>
   * Status of rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder>
      getRuleStatusOrBuilderList() {
    return ruleStatus_;
  }
  /**
   *
   *
   * <pre>
   * Status of rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
   * </code>
   */
  @java.lang.Override
  public int getRuleStatusCount() {
    return ruleStatus_.size();
  }
  /**
   *
   *
   * <pre>
   * Status of rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus getRuleStatus(int index) {
    return ruleStatus_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Status of rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder
      getRuleStatusOrBuilder(int index) {
    return ruleStatus_.get(index);
  }

  public static final int USER_ALLOCATED_NAT_IP_RESOURCES_FIELD_NUMBER = 212776151;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList userAllocatedNatIpResources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of fully qualified URLs of reserved IP address resources.
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
   *
   * @return A list containing the userAllocatedNatIpResources.
   */
  public com.google.protobuf.ProtocolStringList getUserAllocatedNatIpResourcesList() {
    return userAllocatedNatIpResources_;
  }
  /**
   *
   *
   * <pre>
   * A list of fully qualified URLs of reserved IP address resources.
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
   *
   * @return The count of userAllocatedNatIpResources.
   */
  public int getUserAllocatedNatIpResourcesCount() {
    return userAllocatedNatIpResources_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of fully qualified URLs of reserved IP address resources.
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
   *
   * @param index The index of the element to return.
   * @return The userAllocatedNatIpResources at the given index.
   */
  public java.lang.String getUserAllocatedNatIpResources(int index) {
    return userAllocatedNatIpResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of fully qualified URLs of reserved IP address resources.
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the userAllocatedNatIpResources at the given index.
   */
  public com.google.protobuf.ByteString getUserAllocatedNatIpResourcesBytes(int index) {
    return userAllocatedNatIpResources_.getByteString(index);
  }

  public static final int USER_ALLOCATED_NAT_IPS_FIELD_NUMBER = 506878242;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList userAllocatedNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ips = 506878242;</code>
   *
   * @return A list containing the userAllocatedNatIps.
   */
  public com.google.protobuf.ProtocolStringList getUserAllocatedNatIpsList() {
    return userAllocatedNatIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ips = 506878242;</code>
   *
   * @return The count of userAllocatedNatIps.
   */
  public int getUserAllocatedNatIpsCount() {
    return userAllocatedNatIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ips = 506878242;</code>
   *
   * @param index The index of the element to return.
   * @return The userAllocatedNatIps at the given index.
   */
  public java.lang.String getUserAllocatedNatIps(int index) {
    return userAllocatedNatIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
   * </pre>
   *
   * <code>repeated string user_allocated_nat_ips = 506878242;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the userAllocatedNatIps at the given index.
   */
  public com.google.protobuf.ByteString getUserAllocatedNatIpsBytes(int index) {
    return userAllocatedNatIps_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < ruleStatus_.size(); i++) {
      output.writeMessage(140223125, ruleStatus_.get(i));
    }
    for (int i = 0; i < userAllocatedNatIpResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 212776151, userAllocatedNatIpResources_.getRaw(i));
    }
    for (int i = 0; i < drainUserAllocatedNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 305268553, drainUserAllocatedNatIps_.getRaw(i));
    }
    for (int i = 0; i < drainAutoAllocatedNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 309184557, drainAutoAllocatedNatIps_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(365786338, minExtraNatIpsNeeded_);
    }
    for (int i = 0; i < userAllocatedNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 506878242, userAllocatedNatIps_.getRaw(i));
    }
    for (int i = 0; i < autoAllocatedNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 510794246, autoAllocatedNatIps_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(512367468, numVmEndpointsWithNatMappings_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    for (int i = 0; i < ruleStatus_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(140223125, ruleStatus_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < userAllocatedNatIpResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(userAllocatedNatIpResources_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getUserAllocatedNatIpResourcesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < drainUserAllocatedNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(drainUserAllocatedNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDrainUserAllocatedNatIpsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < drainAutoAllocatedNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(drainAutoAllocatedNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDrainAutoAllocatedNatIpsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(365786338, minExtraNatIpsNeeded_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < userAllocatedNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(userAllocatedNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getUserAllocatedNatIpsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < autoAllocatedNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(autoAllocatedNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAutoAllocatedNatIpsList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              512367468, numVmEndpointsWithNatMappings_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterStatusNatStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterStatusNatStatus other =
        (com.google.cloud.compute.v1.RouterStatusNatStatus) obj;

    if (!getAutoAllocatedNatIpsList().equals(other.getAutoAllocatedNatIpsList())) return false;
    if (!getDrainAutoAllocatedNatIpsList().equals(other.getDrainAutoAllocatedNatIpsList()))
      return false;
    if (!getDrainUserAllocatedNatIpsList().equals(other.getDrainUserAllocatedNatIpsList()))
      return false;
    if (hasMinExtraNatIpsNeeded() != other.hasMinExtraNatIpsNeeded()) return false;
    if (hasMinExtraNatIpsNeeded()) {
      if (getMinExtraNatIpsNeeded() != other.getMinExtraNatIpsNeeded()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNumVmEndpointsWithNatMappings() != other.hasNumVmEndpointsWithNatMappings())
      return false;
    if (hasNumVmEndpointsWithNatMappings()) {
      if (getNumVmEndpointsWithNatMappings() != other.getNumVmEndpointsWithNatMappings())
        return false;
    }
    if (!getRuleStatusList().equals(other.getRuleStatusList())) return false;
    if (!getUserAllocatedNatIpResourcesList().equals(other.getUserAllocatedNatIpResourcesList()))
      return false;
    if (!getUserAllocatedNatIpsList().equals(other.getUserAllocatedNatIpsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAutoAllocatedNatIpsCount() > 0) {
      hash = (37 * hash) + AUTO_ALLOCATED_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoAllocatedNatIpsList().hashCode();
    }
    if (getDrainAutoAllocatedNatIpsCount() > 0) {
      hash = (37 * hash) + DRAIN_AUTO_ALLOCATED_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getDrainAutoAllocatedNatIpsList().hashCode();
    }
    if (getDrainUserAllocatedNatIpsCount() > 0) {
      hash = (37 * hash) + DRAIN_USER_ALLOCATED_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getDrainUserAllocatedNatIpsList().hashCode();
    }
    if (hasMinExtraNatIpsNeeded()) {
      hash = (37 * hash) + MIN_EXTRA_NAT_IPS_NEEDED_FIELD_NUMBER;
      hash = (53 * hash) + getMinExtraNatIpsNeeded();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNumVmEndpointsWithNatMappings()) {
      hash = (37 * hash) + NUM_VM_ENDPOINTS_WITH_NAT_MAPPINGS_FIELD_NUMBER;
      hash = (53 * hash) + getNumVmEndpointsWithNatMappings();
    }
    if (getRuleStatusCount() > 0) {
      hash = (37 * hash) + RULE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getRuleStatusList().hashCode();
    }
    if (getUserAllocatedNatIpResourcesCount() > 0) {
      hash = (37 * hash) + USER_ALLOCATED_NAT_IP_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getUserAllocatedNatIpResourcesList().hashCode();
    }
    if (getUserAllocatedNatIpsCount() > 0) {
      hash = (37 * hash) + USER_ALLOCATED_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getUserAllocatedNatIpsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterStatusNatStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Status of a NAT contained in this router.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterStatusNatStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterStatusNatStatus)
      com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusNatStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusNatStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterStatusNatStatus.class,
              com.google.cloud.compute.v1.RouterStatusNatStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterStatusNatStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      drainAutoAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      drainUserAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      minExtraNatIpsNeeded_ = 0;
      name_ = "";
      numVmEndpointsWithNatMappings_ = 0;
      if (ruleStatusBuilder_ == null) {
        ruleStatus_ = java.util.Collections.emptyList();
      } else {
        ruleStatus_ = null;
        ruleStatusBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      userAllocatedNatIpResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      userAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusNatStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusNatStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterStatusNatStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusNatStatus build() {
      com.google.cloud.compute.v1.RouterStatusNatStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusNatStatus buildPartial() {
      com.google.cloud.compute.v1.RouterStatusNatStatus result =
          new com.google.cloud.compute.v1.RouterStatusNatStatus(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.RouterStatusNatStatus result) {
      if (ruleStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          ruleStatus_ = java.util.Collections.unmodifiableList(ruleStatus_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.ruleStatus_ = ruleStatus_;
      } else {
        result.ruleStatus_ = ruleStatusBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterStatusNatStatus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        autoAllocatedNatIps_.makeImmutable();
        result.autoAllocatedNatIps_ = autoAllocatedNatIps_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        drainAutoAllocatedNatIps_.makeImmutable();
        result.drainAutoAllocatedNatIps_ = drainAutoAllocatedNatIps_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        drainUserAllocatedNatIps_.makeImmutable();
        result.drainUserAllocatedNatIps_ = drainUserAllocatedNatIps_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minExtraNatIpsNeeded_ = minExtraNatIpsNeeded_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.numVmEndpointsWithNatMappings_ = numVmEndpointsWithNatMappings_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        userAllocatedNatIpResources_.makeImmutable();
        result.userAllocatedNatIpResources_ = userAllocatedNatIpResources_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        userAllocatedNatIps_.makeImmutable();
        result.userAllocatedNatIps_ = userAllocatedNatIps_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterStatusNatStatus) {
        return mergeFrom((com.google.cloud.compute.v1.RouterStatusNatStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterStatusNatStatus other) {
      if (other == com.google.cloud.compute.v1.RouterStatusNatStatus.getDefaultInstance())
        return this;
      if (!other.autoAllocatedNatIps_.isEmpty()) {
        if (autoAllocatedNatIps_.isEmpty()) {
          autoAllocatedNatIps_ = other.autoAllocatedNatIps_;
          bitField0_ |= 0x00000001;
        } else {
          ensureAutoAllocatedNatIpsIsMutable();
          autoAllocatedNatIps_.addAll(other.autoAllocatedNatIps_);
        }
        onChanged();
      }
      if (!other.drainAutoAllocatedNatIps_.isEmpty()) {
        if (drainAutoAllocatedNatIps_.isEmpty()) {
          drainAutoAllocatedNatIps_ = other.drainAutoAllocatedNatIps_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDrainAutoAllocatedNatIpsIsMutable();
          drainAutoAllocatedNatIps_.addAll(other.drainAutoAllocatedNatIps_);
        }
        onChanged();
      }
      if (!other.drainUserAllocatedNatIps_.isEmpty()) {
        if (drainUserAllocatedNatIps_.isEmpty()) {
          drainUserAllocatedNatIps_ = other.drainUserAllocatedNatIps_;
          bitField0_ |= 0x00000004;
        } else {
          ensureDrainUserAllocatedNatIpsIsMutable();
          drainUserAllocatedNatIps_.addAll(other.drainUserAllocatedNatIps_);
        }
        onChanged();
      }
      if (other.hasMinExtraNatIpsNeeded()) {
        setMinExtraNatIpsNeeded(other.getMinExtraNatIpsNeeded());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasNumVmEndpointsWithNatMappings()) {
        setNumVmEndpointsWithNatMappings(other.getNumVmEndpointsWithNatMappings());
      }
      if (ruleStatusBuilder_ == null) {
        if (!other.ruleStatus_.isEmpty()) {
          if (ruleStatus_.isEmpty()) {
            ruleStatus_ = other.ruleStatus_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureRuleStatusIsMutable();
            ruleStatus_.addAll(other.ruleStatus_);
          }
          onChanged();
        }
      } else {
        if (!other.ruleStatus_.isEmpty()) {
          if (ruleStatusBuilder_.isEmpty()) {
            ruleStatusBuilder_.dispose();
            ruleStatusBuilder_ = null;
            ruleStatus_ = other.ruleStatus_;
            bitField0_ = (bitField0_ & ~0x00000040);
            ruleStatusBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRuleStatusFieldBuilder()
                    : null;
          } else {
            ruleStatusBuilder_.addAllMessages(other.ruleStatus_);
          }
        }
      }
      if (!other.userAllocatedNatIpResources_.isEmpty()) {
        if (userAllocatedNatIpResources_.isEmpty()) {
          userAllocatedNatIpResources_ = other.userAllocatedNatIpResources_;
          bitField0_ |= 0x00000080;
        } else {
          ensureUserAllocatedNatIpResourcesIsMutable();
          userAllocatedNatIpResources_.addAll(other.userAllocatedNatIpResources_);
        }
        onChanged();
      }
      if (!other.userAllocatedNatIps_.isEmpty()) {
        if (userAllocatedNatIps_.isEmpty()) {
          userAllocatedNatIps_ = other.userAllocatedNatIps_;
          bitField0_ |= 0x00000100;
        } else {
          ensureUserAllocatedNatIpsIsMutable();
          userAllocatedNatIps_.addAll(other.userAllocatedNatIps_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26989658
            case 1121785002:
              {
                com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.parser(),
                        extensionRegistry);
                if (ruleStatusBuilder_ == null) {
                  ensureRuleStatusIsMutable();
                  ruleStatus_.add(m);
                } else {
                  ruleStatusBuilder_.addMessage(m);
                }
                break;
              } // case 1121785002
            case 1702209210:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUserAllocatedNatIpResourcesIsMutable();
                userAllocatedNatIpResources_.add(s);
                break;
              } // case 1702209210
            case -1852818870:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDrainUserAllocatedNatIpsIsMutable();
                drainUserAllocatedNatIps_.add(s);
                break;
              } // case -1852818870
            case -1821490838:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDrainAutoAllocatedNatIpsIsMutable();
                drainAutoAllocatedNatIps_.add(s);
                break;
              } // case -1821490838
            case -1368676592:
              {
                minExtraNatIpsNeeded_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case -1368676592
            case -239941358:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUserAllocatedNatIpsIsMutable();
                userAllocatedNatIps_.add(s);
                break;
              } // case -239941358
            case -208613326:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAutoAllocatedNatIpsIsMutable();
                autoAllocatedNatIps_.add(s);
                break;
              } // case -208613326
            case -196027552:
              {
                numVmEndpointsWithNatMappings_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case -196027552
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList autoAllocatedNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAutoAllocatedNatIpsIsMutable() {
      if (!autoAllocatedNatIps_.isModifiable()) {
        autoAllocatedNatIps_ = new com.google.protobuf.LazyStringArrayList(autoAllocatedNatIps_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @return A list containing the autoAllocatedNatIps.
     */
    public com.google.protobuf.ProtocolStringList getAutoAllocatedNatIpsList() {
      autoAllocatedNatIps_.makeImmutable();
      return autoAllocatedNatIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @return The count of autoAllocatedNatIps.
     */
    public int getAutoAllocatedNatIpsCount() {
      return autoAllocatedNatIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @param index The index of the element to return.
     * @return The autoAllocatedNatIps at the given index.
     */
    public java.lang.String getAutoAllocatedNatIps(int index) {
      return autoAllocatedNatIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the autoAllocatedNatIps at the given index.
     */
    public com.google.protobuf.ByteString getAutoAllocatedNatIpsBytes(int index) {
      return autoAllocatedNatIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @param index The index to set the value at.
     * @param value The autoAllocatedNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setAutoAllocatedNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAutoAllocatedNatIpsIsMutable();
      autoAllocatedNatIps_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @param value The autoAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAutoAllocatedNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAutoAllocatedNatIpsIsMutable();
      autoAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @param values The autoAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllAutoAllocatedNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureAutoAllocatedNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, autoAllocatedNatIps_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoAllocatedNatIps() {
      autoAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT. Example: ["1.1.1.1", "129.2.16.89"]
     * </pre>
     *
     * <code>repeated string auto_allocated_nat_ips = 510794246;</code>
     *
     * @param value The bytes of the autoAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAutoAllocatedNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAutoAllocatedNatIpsIsMutable();
      autoAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList drainAutoAllocatedNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDrainAutoAllocatedNatIpsIsMutable() {
      if (!drainAutoAllocatedNatIps_.isModifiable()) {
        drainAutoAllocatedNatIps_ =
            new com.google.protobuf.LazyStringArrayList(drainAutoAllocatedNatIps_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @return A list containing the drainAutoAllocatedNatIps.
     */
    public com.google.protobuf.ProtocolStringList getDrainAutoAllocatedNatIpsList() {
      drainAutoAllocatedNatIps_.makeImmutable();
      return drainAutoAllocatedNatIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @return The count of drainAutoAllocatedNatIps.
     */
    public int getDrainAutoAllocatedNatIpsCount() {
      return drainAutoAllocatedNatIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @param index The index of the element to return.
     * @return The drainAutoAllocatedNatIps at the given index.
     */
    public java.lang.String getDrainAutoAllocatedNatIps(int index) {
      return drainAutoAllocatedNatIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the drainAutoAllocatedNatIps at the given index.
     */
    public com.google.protobuf.ByteString getDrainAutoAllocatedNatIpsBytes(int index) {
      return drainAutoAllocatedNatIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @param index The index to set the value at.
     * @param value The drainAutoAllocatedNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setDrainAutoAllocatedNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainAutoAllocatedNatIpsIsMutable();
      drainAutoAllocatedNatIps_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @param value The drainAutoAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainAutoAllocatedNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainAutoAllocatedNatIpsIsMutable();
      drainAutoAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @param values The drainAutoAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllDrainAutoAllocatedNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureDrainAutoAllocatedNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, drainAutoAllocatedNatIps_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDrainAutoAllocatedNatIps() {
      drainAutoAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs auto-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_auto_allocated_nat_ips = 309184557;</code>
     *
     * @param value The bytes of the drainAutoAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainAutoAllocatedNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDrainAutoAllocatedNatIpsIsMutable();
      drainAutoAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList drainUserAllocatedNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDrainUserAllocatedNatIpsIsMutable() {
      if (!drainUserAllocatedNatIps_.isModifiable()) {
        drainUserAllocatedNatIps_ =
            new com.google.protobuf.LazyStringArrayList(drainUserAllocatedNatIps_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @return A list containing the drainUserAllocatedNatIps.
     */
    public com.google.protobuf.ProtocolStringList getDrainUserAllocatedNatIpsList() {
      drainUserAllocatedNatIps_.makeImmutable();
      return drainUserAllocatedNatIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @return The count of drainUserAllocatedNatIps.
     */
    public int getDrainUserAllocatedNatIpsCount() {
      return drainUserAllocatedNatIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @param index The index of the element to return.
     * @return The drainUserAllocatedNatIps at the given index.
     */
    public java.lang.String getDrainUserAllocatedNatIps(int index) {
      return drainUserAllocatedNatIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the drainUserAllocatedNatIps at the given index.
     */
    public com.google.protobuf.ByteString getDrainUserAllocatedNatIpsBytes(int index) {
      return drainUserAllocatedNatIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @param index The index to set the value at.
     * @param value The drainUserAllocatedNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setDrainUserAllocatedNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainUserAllocatedNatIpsIsMutable();
      drainUserAllocatedNatIps_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @param value The drainUserAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainUserAllocatedNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainUserAllocatedNatIpsIsMutable();
      drainUserAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @param values The drainUserAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllDrainUserAllocatedNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureDrainUserAllocatedNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, drainUserAllocatedNatIps_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDrainUserAllocatedNatIps() {
      drainUserAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_user_allocated_nat_ips = 305268553;</code>
     *
     * @param value The bytes of the drainUserAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainUserAllocatedNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDrainUserAllocatedNatIpsIsMutable();
      drainUserAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int minExtraNatIpsNeeded_;
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
     * </pre>
     *
     * <code>optional int32 min_extra_nat_ips_needed = 365786338;</code>
     *
     * @return Whether the minExtraNatIpsNeeded field is set.
     */
    @java.lang.Override
    public boolean hasMinExtraNatIpsNeeded() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
     * </pre>
     *
     * <code>optional int32 min_extra_nat_ips_needed = 365786338;</code>
     *
     * @return The minExtraNatIpsNeeded.
     */
    @java.lang.Override
    public int getMinExtraNatIpsNeeded() {
      return minExtraNatIpsNeeded_;
    }
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
     * </pre>
     *
     * <code>optional int32 min_extra_nat_ips_needed = 365786338;</code>
     *
     * @param value The minExtraNatIpsNeeded to set.
     * @return This builder for chaining.
     */
    public Builder setMinExtraNatIpsNeeded(int value) {

      minExtraNatIpsNeeded_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if user-specified IPs are NOT enough to allow all configured VMs to use NAT. This value is meaningful only when auto-allocation of NAT IPs is *not* used.
     * </pre>
     *
     * <code>optional int32 min_extra_nat_ips_needed = 365786338;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinExtraNatIpsNeeded() {
      bitField0_ = (bitField0_ & ~0x00000008);
      minExtraNatIpsNeeded_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Unique name of this NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Unique name of this NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique name of this NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique name of this NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique name of this NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique name of this NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int numVmEndpointsWithNatMappings_;
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., Nics) that can use NAT.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @return Whether the numVmEndpointsWithNatMappings field is set.
     */
    @java.lang.Override
    public boolean hasNumVmEndpointsWithNatMappings() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., Nics) that can use NAT.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @return The numVmEndpointsWithNatMappings.
     */
    @java.lang.Override
    public int getNumVmEndpointsWithNatMappings() {
      return numVmEndpointsWithNatMappings_;
    }
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., Nics) that can use NAT.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @param value The numVmEndpointsWithNatMappings to set.
     * @return This builder for chaining.
     */
    public Builder setNumVmEndpointsWithNatMappings(int value) {

      numVmEndpointsWithNatMappings_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., Nics) that can use NAT.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumVmEndpointsWithNatMappings() {
      bitField0_ = (bitField0_ & ~0x00000020);
      numVmEndpointsWithNatMappings_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus>
        ruleStatus_ = java.util.Collections.emptyList();

    private void ensureRuleStatusIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        ruleStatus_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus>(
                ruleStatus_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus,
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder,
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder>
        ruleStatusBuilder_;

    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus>
        getRuleStatusList() {
      if (ruleStatusBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ruleStatus_);
      } else {
        return ruleStatusBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public int getRuleStatusCount() {
      if (ruleStatusBuilder_ == null) {
        return ruleStatus_.size();
      } else {
        return ruleStatusBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus getRuleStatus(int index) {
      if (ruleStatusBuilder_ == null) {
        return ruleStatus_.get(index);
      } else {
        return ruleStatusBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder setRuleStatus(
        int index, com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus value) {
      if (ruleStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleStatusIsMutable();
        ruleStatus_.set(index, value);
        onChanged();
      } else {
        ruleStatusBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder setRuleStatus(
        int index,
        com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder builderForValue) {
      if (ruleStatusBuilder_ == null) {
        ensureRuleStatusIsMutable();
        ruleStatus_.set(index, builderForValue.build());
        onChanged();
      } else {
        ruleStatusBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder addRuleStatus(
        com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus value) {
      if (ruleStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleStatusIsMutable();
        ruleStatus_.add(value);
        onChanged();
      } else {
        ruleStatusBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder addRuleStatus(
        int index, com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus value) {
      if (ruleStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleStatusIsMutable();
        ruleStatus_.add(index, value);
        onChanged();
      } else {
        ruleStatusBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder addRuleStatus(
        com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder builderForValue) {
      if (ruleStatusBuilder_ == null) {
        ensureRuleStatusIsMutable();
        ruleStatus_.add(builderForValue.build());
        onChanged();
      } else {
        ruleStatusBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder addRuleStatus(
        int index,
        com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder builderForValue) {
      if (ruleStatusBuilder_ == null) {
        ensureRuleStatusIsMutable();
        ruleStatus_.add(index, builderForValue.build());
        onChanged();
      } else {
        ruleStatusBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder addAllRuleStatus(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus>
            values) {
      if (ruleStatusBuilder_ == null) {
        ensureRuleStatusIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ruleStatus_);
        onChanged();
      } else {
        ruleStatusBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder clearRuleStatus() {
      if (ruleStatusBuilder_ == null) {
        ruleStatus_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        ruleStatusBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public Builder removeRuleStatus(int index) {
      if (ruleStatusBuilder_ == null) {
        ensureRuleStatusIsMutable();
        ruleStatus_.remove(index);
        onChanged();
      } else {
        ruleStatusBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder
        getRuleStatusBuilder(int index) {
      return getRuleStatusFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder
        getRuleStatusOrBuilder(int index) {
      if (ruleStatusBuilder_ == null) {
        return ruleStatus_.get(index);
      } else {
        return ruleStatusBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder>
        getRuleStatusOrBuilderList() {
      if (ruleStatusBuilder_ != null) {
        return ruleStatusBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ruleStatus_);
      }
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder
        addRuleStatusBuilder() {
      return getRuleStatusFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder
        addRuleStatusBuilder(int index) {
      return getRuleStatusFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Status of rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus rule_status = 140223125;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder>
        getRuleStatusBuilderList() {
      return getRuleStatusFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus,
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder,
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder>
        getRuleStatusFieldBuilder() {
      if (ruleStatusBuilder_ == null) {
        ruleStatusBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus,
                com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder,
                com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder>(
                ruleStatus_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        ruleStatus_ = null;
      }
      return ruleStatusBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList userAllocatedNatIpResources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUserAllocatedNatIpResourcesIsMutable() {
      if (!userAllocatedNatIpResources_.isModifiable()) {
        userAllocatedNatIpResources_ =
            new com.google.protobuf.LazyStringArrayList(userAllocatedNatIpResources_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @return A list containing the userAllocatedNatIpResources.
     */
    public com.google.protobuf.ProtocolStringList getUserAllocatedNatIpResourcesList() {
      userAllocatedNatIpResources_.makeImmutable();
      return userAllocatedNatIpResources_;
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @return The count of userAllocatedNatIpResources.
     */
    public int getUserAllocatedNatIpResourcesCount() {
      return userAllocatedNatIpResources_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @param index The index of the element to return.
     * @return The userAllocatedNatIpResources at the given index.
     */
    public java.lang.String getUserAllocatedNatIpResources(int index) {
      return userAllocatedNatIpResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the userAllocatedNatIpResources at the given index.
     */
    public com.google.protobuf.ByteString getUserAllocatedNatIpResourcesBytes(int index) {
      return userAllocatedNatIpResources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @param index The index to set the value at.
     * @param value The userAllocatedNatIpResources to set.
     * @return This builder for chaining.
     */
    public Builder setUserAllocatedNatIpResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUserAllocatedNatIpResourcesIsMutable();
      userAllocatedNatIpResources_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @param value The userAllocatedNatIpResources to add.
     * @return This builder for chaining.
     */
    public Builder addUserAllocatedNatIpResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUserAllocatedNatIpResourcesIsMutable();
      userAllocatedNatIpResources_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @param values The userAllocatedNatIpResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllUserAllocatedNatIpResources(java.lang.Iterable<java.lang.String> values) {
      ensureUserAllocatedNatIpResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userAllocatedNatIpResources_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAllocatedNatIpResources() {
      userAllocatedNatIpResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of fully qualified URLs of reserved IP address resources.
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ip_resources = 212776151;</code>
     *
     * @param value The bytes of the userAllocatedNatIpResources to add.
     * @return This builder for chaining.
     */
    public Builder addUserAllocatedNatIpResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUserAllocatedNatIpResourcesIsMutable();
      userAllocatedNatIpResources_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList userAllocatedNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUserAllocatedNatIpsIsMutable() {
      if (!userAllocatedNatIps_.isModifiable()) {
        userAllocatedNatIps_ = new com.google.protobuf.LazyStringArrayList(userAllocatedNatIps_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @return A list containing the userAllocatedNatIps.
     */
    public com.google.protobuf.ProtocolStringList getUserAllocatedNatIpsList() {
      userAllocatedNatIps_.makeImmutable();
      return userAllocatedNatIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @return The count of userAllocatedNatIps.
     */
    public int getUserAllocatedNatIpsCount() {
      return userAllocatedNatIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @param index The index of the element to return.
     * @return The userAllocatedNatIps at the given index.
     */
    public java.lang.String getUserAllocatedNatIps(int index) {
      return userAllocatedNatIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the userAllocatedNatIps at the given index.
     */
    public com.google.protobuf.ByteString getUserAllocatedNatIpsBytes(int index) {
      return userAllocatedNatIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @param index The index to set the value at.
     * @param value The userAllocatedNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setUserAllocatedNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUserAllocatedNatIpsIsMutable();
      userAllocatedNatIps_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @param value The userAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addUserAllocatedNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUserAllocatedNatIpsIsMutable();
      userAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @param values The userAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllUserAllocatedNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureUserAllocatedNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userAllocatedNatIps_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAllocatedNatIps() {
      userAllocatedNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs user-allocated for NAT. They will be raw IP strings like "179.12.26.133".
     * </pre>
     *
     * <code>repeated string user_allocated_nat_ips = 506878242;</code>
     *
     * @param value The bytes of the userAllocatedNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addUserAllocatedNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUserAllocatedNatIpsIsMutable();
      userAllocatedNatIps_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterStatusNatStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterStatusNatStatus)
  private static final com.google.cloud.compute.v1.RouterStatusNatStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterStatusNatStatus();
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterStatusNatStatus> PARSER =
      new com.google.protobuf.AbstractParser<RouterStatusNatStatus>() {
        @java.lang.Override
        public RouterStatusNatStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterStatusNatStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterStatusNatStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusNatStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
