/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

public interface SchedulingOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.Scheduling)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
   * </pre>
   *
   * <code>optional bool automatic_restart = 350821371;</code>
   *
   * @return Whether the automaticRestart field is set.
   */
  boolean hasAutomaticRestart();
  /**
   *
   *
   * <pre>
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
   * </pre>
   *
   * <code>optional bool automatic_restart = 350821371;</code>
   *
   * @return The automaticRestart.
   */
  boolean getAutomaticRestart();

  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * Check the InstanceTerminationAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_termination_action = 107380667;</code>
   *
   * @return Whether the instanceTerminationAction field is set.
   */
  boolean hasInstanceTerminationAction();
  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * Check the InstanceTerminationAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_termination_action = 107380667;</code>
   *
   * @return The instanceTerminationAction.
   */
  java.lang.String getInstanceTerminationAction();
  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * Check the InstanceTerminationAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_termination_action = 107380667;</code>
   *
   * @return The bytes for instanceTerminationAction.
   */
  com.google.protobuf.ByteString getInstanceTerminationActionBytes();

  /**
   *
   *
   * <pre>
   * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
   *
   * @return Whether the localSsdRecoveryTimeout field is set.
   */
  boolean hasLocalSsdRecoveryTimeout();
  /**
   *
   *
   * <pre>
   * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
   *
   * @return The localSsdRecoveryTimeout.
   */
  com.google.cloud.compute.v1.Duration getLocalSsdRecoveryTimeout();
  /**
   *
   *
   * <pre>
   * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
   */
  com.google.cloud.compute.v1.DurationOrBuilder getLocalSsdRecoveryTimeoutOrBuilder();

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return Whether the locationHint field is set.
   */
  boolean hasLocationHint();
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The locationHint.
   */
  java.lang.String getLocationHint();
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The bytes for locationHint.
   */
  com.google.protobuf.ByteString getLocationHintBytes();

  /**
   *
   *
   * <pre>
   * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
   * </pre>
   *
   * <code>optional int32 min_node_cpus = 317231675;</code>
   *
   * @return Whether the minNodeCpus field is set.
   */
  boolean hasMinNodeCpus();
  /**
   *
   *
   * <pre>
   * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
   * </pre>
   *
   * <code>optional int32 min_node_cpus = 317231675;</code>
   *
   * @return The minNodeCpus.
   */
  int getMinNodeCpus();

  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  java.util.List<com.google.cloud.compute.v1.SchedulingNodeAffinity> getNodeAffinitiesList();
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  com.google.cloud.compute.v1.SchedulingNodeAffinity getNodeAffinities(int index);
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  int getNodeAffinitiesCount();
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder>
      getNodeAffinitiesOrBuilderList();
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder getNodeAffinitiesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * Check the OnHostMaintenance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_host_maintenance = 64616796;</code>
   *
   * @return Whether the onHostMaintenance field is set.
   */
  boolean hasOnHostMaintenance();
  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * Check the OnHostMaintenance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_host_maintenance = 64616796;</code>
   *
   * @return The onHostMaintenance.
   */
  java.lang.String getOnHostMaintenance();
  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * Check the OnHostMaintenance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_host_maintenance = 64616796;</code>
   *
   * @return The bytes for onHostMaintenance.
   */
  com.google.protobuf.ByteString getOnHostMaintenanceBytes();

  /**
   *
   *
   * <pre>
   * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
   * </pre>
   *
   * <code>optional bool preemptible = 324203169;</code>
   *
   * @return Whether the preemptible field is set.
   */
  boolean hasPreemptible();
  /**
   *
   *
   * <pre>
   * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
   * </pre>
   *
   * <code>optional bool preemptible = 324203169;</code>
   *
   * @return The preemptible.
   */
  boolean getPreemptible();

  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * Check the ProvisioningModel enum for the list of possible values.
   * </pre>
   *
   * <code>optional string provisioning_model = 494423;</code>
   *
   * @return Whether the provisioningModel field is set.
   */
  boolean hasProvisioningModel();
  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * Check the ProvisioningModel enum for the list of possible values.
   * </pre>
   *
   * <code>optional string provisioning_model = 494423;</code>
   *
   * @return The provisioningModel.
   */
  java.lang.String getProvisioningModel();
  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * Check the ProvisioningModel enum for the list of possible values.
   * </pre>
   *
   * <code>optional string provisioning_model = 494423;</code>
   *
   * @return The bytes for provisioningModel.
   */
  com.google.protobuf.ByteString getProvisioningModelBytes();
}
