/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a ServiceAttachment resource. A service attachment represents a service that a producer has exposed. It encapsulates the load balancer which fronts the service runs and a list of NAT IP ranges that the producers uses to represent the consumers connecting to the service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ServiceAttachment}
 */
public final class ServiceAttachment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ServiceAttachment)
    ServiceAttachmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceAttachment.newBuilder() to construct.
  private ServiceAttachment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceAttachment() {
    connectedEndpoints_ = java.util.Collections.emptyList();
    connectionPreference_ = "";
    consumerAcceptLists_ = java.util.Collections.emptyList();
    consumerRejectLists_ = com.google.protobuf.LazyStringArrayList.emptyList();
    creationTimestamp_ = "";
    description_ = "";
    domainNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    fingerprint_ = "";
    kind_ = "";
    name_ = "";
    natSubnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
    producerForwardingRule_ = "";
    region_ = "";
    selfLink_ = "";
    targetService_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceAttachment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ServiceAttachment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ServiceAttachment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ServiceAttachment.class,
            com.google.cloud.compute.v1.ServiceAttachment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ServiceAttachment.ConnectionPreference}
   */
  public enum ConnectionPreference implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONNECTION_PREFERENCE = 0;</code>
     */
    UNDEFINED_CONNECTION_PREFERENCE(0),
    /** <code>ACCEPT_AUTOMATIC = 75250580;</code> */
    ACCEPT_AUTOMATIC(75250580),
    /** <code>ACCEPT_MANUAL = 373061341;</code> */
    ACCEPT_MANUAL(373061341),
    /** <code>CONNECTION_PREFERENCE_UNSPECIFIED = 34590772;</code> */
    CONNECTION_PREFERENCE_UNSPECIFIED(34590772),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONNECTION_PREFERENCE = 0;</code>
     */
    public static final int UNDEFINED_CONNECTION_PREFERENCE_VALUE = 0;
    /** <code>ACCEPT_AUTOMATIC = 75250580;</code> */
    public static final int ACCEPT_AUTOMATIC_VALUE = 75250580;
    /** <code>ACCEPT_MANUAL = 373061341;</code> */
    public static final int ACCEPT_MANUAL_VALUE = 373061341;
    /** <code>CONNECTION_PREFERENCE_UNSPECIFIED = 34590772;</code> */
    public static final int CONNECTION_PREFERENCE_UNSPECIFIED_VALUE = 34590772;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionPreference valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectionPreference forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CONNECTION_PREFERENCE;
        case 75250580:
          return ACCEPT_AUTOMATIC;
        case 373061341:
          return ACCEPT_MANUAL;
        case 34590772:
          return CONNECTION_PREFERENCE_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectionPreference>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConnectionPreference>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConnectionPreference>() {
              public ConnectionPreference findValueByNumber(int number) {
                return ConnectionPreference.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ServiceAttachment.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConnectionPreference[] VALUES = values();

    public static ConnectionPreference valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectionPreference(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ServiceAttachment.ConnectionPreference)
  }

  private int bitField0_;
  public static final int CONNECTED_ENDPOINTS_FIELD_NUMBER = 72223688;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint>
      connectedEndpoints_;
  /**
   *
   *
   * <pre>
   * [Output Only] An array of connections for all the consumers connected to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint>
      getConnectedEndpointsList() {
    return connectedEndpoints_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An array of connections for all the consumers connected to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder>
      getConnectedEndpointsOrBuilderList() {
    return connectedEndpoints_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An array of connections for all the consumers connected to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
   * </code>
   */
  @java.lang.Override
  public int getConnectedEndpointsCount() {
    return connectedEndpoints_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An array of connections for all the consumers connected to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint getConnectedEndpoints(
      int index) {
    return connectedEndpoints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An array of connections for all the consumers connected to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder
      getConnectedEndpointsOrBuilder(int index) {
    return connectedEndpoints_.get(index);
  }

  public static final int CONNECTION_PREFERENCE_FIELD_NUMBER = 285818076;

  @SuppressWarnings("serial")
  private volatile java.lang.Object connectionPreference_ = "";
  /**
   *
   *
   * <pre>
   * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
   * Check the ConnectionPreference enum for the list of possible values.
   * </pre>
   *
   * <code>optional string connection_preference = 285818076;</code>
   *
   * @return Whether the connectionPreference field is set.
   */
  @java.lang.Override
  public boolean hasConnectionPreference() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
   * Check the ConnectionPreference enum for the list of possible values.
   * </pre>
   *
   * <code>optional string connection_preference = 285818076;</code>
   *
   * @return The connectionPreference.
   */
  @java.lang.Override
  public java.lang.String getConnectionPreference() {
    java.lang.Object ref = connectionPreference_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      connectionPreference_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
   * Check the ConnectionPreference enum for the list of possible values.
   * </pre>
   *
   * <code>optional string connection_preference = 285818076;</code>
   *
   * @return The bytes for connectionPreference.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConnectionPreferenceBytes() {
    java.lang.Object ref = connectionPreference_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      connectionPreference_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONSUMER_ACCEPT_LISTS_FIELD_NUMBER = 402725703;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit>
      consumerAcceptLists_;
  /**
   *
   *
   * <pre>
   * Projects that are allowed to connect to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit>
      getConsumerAcceptListsList() {
    return consumerAcceptLists_;
  }
  /**
   *
   *
   * <pre>
   * Projects that are allowed to connect to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder>
      getConsumerAcceptListsOrBuilderList() {
    return consumerAcceptLists_;
  }
  /**
   *
   *
   * <pre>
   * Projects that are allowed to connect to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
   * </code>
   */
  @java.lang.Override
  public int getConsumerAcceptListsCount() {
    return consumerAcceptLists_.size();
  }
  /**
   *
   *
   * <pre>
   * Projects that are allowed to connect to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit getConsumerAcceptLists(
      int index) {
    return consumerAcceptLists_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Projects that are allowed to connect to this service attachment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder
      getConsumerAcceptListsOrBuilder(int index) {
    return consumerAcceptLists_.get(index);
  }

  public static final int CONSUMER_REJECT_LISTS_FIELD_NUMBER = 204033182;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList consumerRejectLists_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
   * </pre>
   *
   * <code>repeated string consumer_reject_lists = 204033182;</code>
   *
   * @return A list containing the consumerRejectLists.
   */
  public com.google.protobuf.ProtocolStringList getConsumerRejectListsList() {
    return consumerRejectLists_;
  }
  /**
   *
   *
   * <pre>
   * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
   * </pre>
   *
   * <code>repeated string consumer_reject_lists = 204033182;</code>
   *
   * @return The count of consumerRejectLists.
   */
  public int getConsumerRejectListsCount() {
    return consumerRejectLists_.size();
  }
  /**
   *
   *
   * <pre>
   * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
   * </pre>
   *
   * <code>repeated string consumer_reject_lists = 204033182;</code>
   *
   * @param index The index of the element to return.
   * @return The consumerRejectLists at the given index.
   */
  public java.lang.String getConsumerRejectLists(int index) {
    return consumerRejectLists_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
   * </pre>
   *
   * <code>repeated string consumer_reject_lists = 204033182;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the consumerRejectLists at the given index.
   */
  public com.google.protobuf.ByteString getConsumerRejectListsBytes(int index) {
    return consumerRejectLists_.getByteString(index);
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_NAMES_FIELD_NUMBER = 6450189;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList domainNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
   * </pre>
   *
   * <code>repeated string domain_names = 6450189;</code>
   *
   * @return A list containing the domainNames.
   */
  public com.google.protobuf.ProtocolStringList getDomainNamesList() {
    return domainNames_;
  }
  /**
   *
   *
   * <pre>
   * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
   * </pre>
   *
   * <code>repeated string domain_names = 6450189;</code>
   *
   * @return The count of domainNames.
   */
  public int getDomainNamesCount() {
    return domainNames_.size();
  }
  /**
   *
   *
   * <pre>
   * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
   * </pre>
   *
   * <code>repeated string domain_names = 6450189;</code>
   *
   * @param index The index of the element to return.
   * @return The domainNames at the given index.
   */
  public java.lang.String getDomainNames(int index) {
    return domainNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
   * </pre>
   *
   * <code>repeated string domain_names = 6450189;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the domainNames at the given index.
   */
  public com.google.protobuf.ByteString getDomainNamesBytes(int index) {
    return domainNames_.getByteString(index);
  }

  public static final int ENABLE_PROXY_PROTOCOL_FIELD_NUMBER = 363791237;
  private boolean enableProxyProtocol_ = false;
  /**
   *
   *
   * <pre>
   * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
   * </pre>
   *
   * <code>optional bool enable_proxy_protocol = 363791237;</code>
   *
   * @return Whether the enableProxyProtocol field is set.
   */
  @java.lang.Override
  public boolean hasEnableProxyProtocol() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
   * </pre>
   *
   * <code>optional bool enable_proxy_protocol = 363791237;</code>
   *
   * @return The enableProxyProtocol.
   */
  @java.lang.Override
  public boolean getEnableProxyProtocol() {
    return enableProxyProtocol_;
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAT_SUBNETS_FIELD_NUMBER = 374785944;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList natSubnets_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
   * </pre>
   *
   * <code>repeated string nat_subnets = 374785944;</code>
   *
   * @return A list containing the natSubnets.
   */
  public com.google.protobuf.ProtocolStringList getNatSubnetsList() {
    return natSubnets_;
  }
  /**
   *
   *
   * <pre>
   * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
   * </pre>
   *
   * <code>repeated string nat_subnets = 374785944;</code>
   *
   * @return The count of natSubnets.
   */
  public int getNatSubnetsCount() {
    return natSubnets_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
   * </pre>
   *
   * <code>repeated string nat_subnets = 374785944;</code>
   *
   * @param index The index of the element to return.
   * @return The natSubnets at the given index.
   */
  public java.lang.String getNatSubnets(int index) {
    return natSubnets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
   * </pre>
   *
   * <code>repeated string nat_subnets = 374785944;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the natSubnets at the given index.
   */
  public com.google.protobuf.ByteString getNatSubnetsBytes(int index) {
    return natSubnets_.getByteString(index);
  }

  public static final int PRODUCER_FORWARDING_RULE_FIELD_NUMBER = 247927889;

  @SuppressWarnings("serial")
  private volatile java.lang.Object producerForwardingRule_ = "";
  /**
   *
   *
   * <pre>
   * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
   * </pre>
   *
   * <code>optional string producer_forwarding_rule = 247927889;</code>
   *
   * @return Whether the producerForwardingRule field is set.
   */
  @java.lang.Override
  public boolean hasProducerForwardingRule() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
   * </pre>
   *
   * <code>optional string producer_forwarding_rule = 247927889;</code>
   *
   * @return The producerForwardingRule.
   */
  @java.lang.Override
  public java.lang.String getProducerForwardingRule() {
    java.lang.Object ref = producerForwardingRule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      producerForwardingRule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
   * </pre>
   *
   * <code>optional string producer_forwarding_rule = 247927889;</code>
   *
   * @return The bytes for producerForwardingRule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProducerForwardingRuleBytes() {
    java.lang.Object ref = producerForwardingRule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      producerForwardingRule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PSC_SERVICE_ATTACHMENT_ID_FIELD_NUMBER = 527695214;
  private com.google.cloud.compute.v1.Uint128 pscServiceAttachmentId_;
  /**
   *
   *
   * <pre>
   * [Output Only] An 128-bit global unique ID of the PSC service attachment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
   *
   * @return Whether the pscServiceAttachmentId field is set.
   */
  @java.lang.Override
  public boolean hasPscServiceAttachmentId() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An 128-bit global unique ID of the PSC service attachment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
   *
   * @return The pscServiceAttachmentId.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Uint128 getPscServiceAttachmentId() {
    return pscServiceAttachmentId_ == null
        ? com.google.cloud.compute.v1.Uint128.getDefaultInstance()
        : pscServiceAttachmentId_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An 128-bit global unique ID of the PSC service attachment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Uint128OrBuilder getPscServiceAttachmentIdOrBuilder() {
    return pscServiceAttachmentId_ == null
        ? com.google.cloud.compute.v1.Uint128.getDefaultInstance()
        : pscServiceAttachmentId_;
  }

  public static final int RECONCILE_CONNECTIONS_FIELD_NUMBER = 125493732;
  private boolean reconcileConnections_ = false;
  /**
   *
   *
   * <pre>
   * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints. - If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified . - If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list. For newly created service attachment, this boolean defaults to true.
   * </pre>
   *
   * <code>optional bool reconcile_connections = 125493732;</code>
   *
   * @return Whether the reconcileConnections field is set.
   */
  @java.lang.Override
  public boolean hasReconcileConnections() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints. - If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified . - If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list. For newly created service attachment, this boolean defaults to true.
   * </pre>
   *
   * <code>optional bool reconcile_connections = 125493732;</code>
   *
   * @return The reconcileConnections.
   */
  @java.lang.Override
  public boolean getReconcileConnections() {
    return reconcileConnections_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_SERVICE_FIELD_NUMBER = 1293831;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetService_ = "";
  /**
   *
   *
   * <pre>
   * The URL of a service serving the endpoint identified by this service attachment.
   * </pre>
   *
   * <code>optional string target_service = 1293831;</code>
   *
   * @return Whether the targetService field is set.
   */
  @java.lang.Override
  public boolean hasTargetService() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of a service serving the endpoint identified by this service attachment.
   * </pre>
   *
   * <code>optional string target_service = 1293831;</code>
   *
   * @return The targetService.
   */
  @java.lang.Override
  public java.lang.String getTargetService() {
    java.lang.Object ref = targetService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of a service serving the endpoint identified by this service attachment.
   * </pre>
   *
   * <code>optional string target_service = 1293831;</code>
   *
   * @return The bytes for targetService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetServiceBytes() {
    java.lang.Object ref = targetService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1293831, targetService_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < domainNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6450189, domainNames_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    for (int i = 0; i < connectedEndpoints_.size(); i++) {
      output.writeMessage(72223688, connectedEndpoints_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(125493732, reconcileConnections_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    for (int i = 0; i < consumerRejectLists_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 204033182, consumerRejectLists_.getRaw(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 247927889, producerForwardingRule_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 285818076, connectionPreference_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(363791237, enableProxyProtocol_);
    }
    for (int i = 0; i < natSubnets_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 374785944, natSubnets_.getRaw(i));
    }
    for (int i = 0; i < consumerAcceptLists_.size(); i++) {
      output.writeMessage(402725703, consumerAcceptLists_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(527695214, getPscServiceAttachmentId());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1293831, targetService_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domainNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(domainNames_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getDomainNamesList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    for (int i = 0; i < connectedEndpoints_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              72223688, connectedEndpoints_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(125493732, reconcileConnections_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < consumerRejectLists_.size(); i++) {
        dataSize += computeStringSizeNoTag(consumerRejectLists_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getConsumerRejectListsList().size();
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              247927889, producerForwardingRule_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              285818076, connectionPreference_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(363791237, enableProxyProtocol_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < natSubnets_.size(); i++) {
        dataSize += computeStringSizeNoTag(natSubnets_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getNatSubnetsList().size();
    }
    for (int i = 0; i < consumerAcceptLists_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              402725703, consumerAcceptLists_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              527695214, getPscServiceAttachmentId());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ServiceAttachment)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ServiceAttachment other =
        (com.google.cloud.compute.v1.ServiceAttachment) obj;

    if (!getConnectedEndpointsList().equals(other.getConnectedEndpointsList())) return false;
    if (hasConnectionPreference() != other.hasConnectionPreference()) return false;
    if (hasConnectionPreference()) {
      if (!getConnectionPreference().equals(other.getConnectionPreference())) return false;
    }
    if (!getConsumerAcceptListsList().equals(other.getConsumerAcceptListsList())) return false;
    if (!getConsumerRejectListsList().equals(other.getConsumerRejectListsList())) return false;
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getDomainNamesList().equals(other.getDomainNamesList())) return false;
    if (hasEnableProxyProtocol() != other.hasEnableProxyProtocol()) return false;
    if (hasEnableProxyProtocol()) {
      if (getEnableProxyProtocol() != other.getEnableProxyProtocol()) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getNatSubnetsList().equals(other.getNatSubnetsList())) return false;
    if (hasProducerForwardingRule() != other.hasProducerForwardingRule()) return false;
    if (hasProducerForwardingRule()) {
      if (!getProducerForwardingRule().equals(other.getProducerForwardingRule())) return false;
    }
    if (hasPscServiceAttachmentId() != other.hasPscServiceAttachmentId()) return false;
    if (hasPscServiceAttachmentId()) {
      if (!getPscServiceAttachmentId().equals(other.getPscServiceAttachmentId())) return false;
    }
    if (hasReconcileConnections() != other.hasReconcileConnections()) return false;
    if (hasReconcileConnections()) {
      if (getReconcileConnections() != other.getReconcileConnections()) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasTargetService() != other.hasTargetService()) return false;
    if (hasTargetService()) {
      if (!getTargetService().equals(other.getTargetService())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getConnectedEndpointsCount() > 0) {
      hash = (37 * hash) + CONNECTED_ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConnectedEndpointsList().hashCode();
    }
    if (hasConnectionPreference()) {
      hash = (37 * hash) + CONNECTION_PREFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionPreference().hashCode();
    }
    if (getConsumerAcceptListsCount() > 0) {
      hash = (37 * hash) + CONSUMER_ACCEPT_LISTS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerAcceptListsList().hashCode();
    }
    if (getConsumerRejectListsCount() > 0) {
      hash = (37 * hash) + CONSUMER_REJECT_LISTS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerRejectListsList().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getDomainNamesCount() > 0) {
      hash = (37 * hash) + DOMAIN_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getDomainNamesList().hashCode();
    }
    if (hasEnableProxyProtocol()) {
      hash = (37 * hash) + ENABLE_PROXY_PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableProxyProtocol());
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getNatSubnetsCount() > 0) {
      hash = (37 * hash) + NAT_SUBNETS_FIELD_NUMBER;
      hash = (53 * hash) + getNatSubnetsList().hashCode();
    }
    if (hasProducerForwardingRule()) {
      hash = (37 * hash) + PRODUCER_FORWARDING_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getProducerForwardingRule().hashCode();
    }
    if (hasPscServiceAttachmentId()) {
      hash = (37 * hash) + PSC_SERVICE_ATTACHMENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPscServiceAttachmentId().hashCode();
    }
    if (hasReconcileConnections()) {
      hash = (37 * hash) + RECONCILE_CONNECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconcileConnections());
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasTargetService()) {
      hash = (37 * hash) + TARGET_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetService().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ServiceAttachment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ServiceAttachment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a ServiceAttachment resource. A service attachment represents a service that a producer has exposed. It encapsulates the load balancer which fronts the service runs and a list of NAT IP ranges that the producers uses to represent the consumers connecting to the service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ServiceAttachment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ServiceAttachment)
      com.google.cloud.compute.v1.ServiceAttachmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ServiceAttachment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ServiceAttachment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ServiceAttachment.class,
              com.google.cloud.compute.v1.ServiceAttachment.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ServiceAttachment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConnectedEndpointsFieldBuilder();
        getConsumerAcceptListsFieldBuilder();
        getPscServiceAttachmentIdFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (connectedEndpointsBuilder_ == null) {
        connectedEndpoints_ = java.util.Collections.emptyList();
      } else {
        connectedEndpoints_ = null;
        connectedEndpointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      connectionPreference_ = "";
      if (consumerAcceptListsBuilder_ == null) {
        consumerAcceptLists_ = java.util.Collections.emptyList();
      } else {
        consumerAcceptLists_ = null;
        consumerAcceptListsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      consumerRejectLists_ = com.google.protobuf.LazyStringArrayList.emptyList();
      creationTimestamp_ = "";
      description_ = "";
      domainNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      enableProxyProtocol_ = false;
      fingerprint_ = "";
      id_ = 0L;
      kind_ = "";
      name_ = "";
      natSubnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      producerForwardingRule_ = "";
      pscServiceAttachmentId_ = null;
      if (pscServiceAttachmentIdBuilder_ != null) {
        pscServiceAttachmentIdBuilder_.dispose();
        pscServiceAttachmentIdBuilder_ = null;
      }
      reconcileConnections_ = false;
      region_ = "";
      selfLink_ = "";
      targetService_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ServiceAttachment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ServiceAttachment getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ServiceAttachment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ServiceAttachment build() {
      com.google.cloud.compute.v1.ServiceAttachment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ServiceAttachment buildPartial() {
      com.google.cloud.compute.v1.ServiceAttachment result =
          new com.google.cloud.compute.v1.ServiceAttachment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.ServiceAttachment result) {
      if (connectedEndpointsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          connectedEndpoints_ = java.util.Collections.unmodifiableList(connectedEndpoints_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.connectedEndpoints_ = connectedEndpoints_;
      } else {
        result.connectedEndpoints_ = connectedEndpointsBuilder_.build();
      }
      if (consumerAcceptListsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          consumerAcceptLists_ = java.util.Collections.unmodifiableList(consumerAcceptLists_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.consumerAcceptLists_ = consumerAcceptLists_;
      } else {
        result.consumerAcceptLists_ = consumerAcceptListsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.ServiceAttachment result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.connectionPreference_ = connectionPreference_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        consumerRejectLists_.makeImmutable();
        result.consumerRejectLists_ = consumerRejectLists_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        domainNames_.makeImmutable();
        result.domainNames_ = domainNames_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enableProxyProtocol_ = enableProxyProtocol_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        natSubnets_.makeImmutable();
        result.natSubnets_ = natSubnets_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.producerForwardingRule_ = producerForwardingRule_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.pscServiceAttachmentId_ =
            pscServiceAttachmentIdBuilder_ == null
                ? pscServiceAttachmentId_
                : pscServiceAttachmentIdBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.reconcileConnections_ = reconcileConnections_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.targetService_ = targetService_;
        to_bitField0_ |= 0x00002000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ServiceAttachment) {
        return mergeFrom((com.google.cloud.compute.v1.ServiceAttachment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ServiceAttachment other) {
      if (other == com.google.cloud.compute.v1.ServiceAttachment.getDefaultInstance()) return this;
      if (connectedEndpointsBuilder_ == null) {
        if (!other.connectedEndpoints_.isEmpty()) {
          if (connectedEndpoints_.isEmpty()) {
            connectedEndpoints_ = other.connectedEndpoints_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConnectedEndpointsIsMutable();
            connectedEndpoints_.addAll(other.connectedEndpoints_);
          }
          onChanged();
        }
      } else {
        if (!other.connectedEndpoints_.isEmpty()) {
          if (connectedEndpointsBuilder_.isEmpty()) {
            connectedEndpointsBuilder_.dispose();
            connectedEndpointsBuilder_ = null;
            connectedEndpoints_ = other.connectedEndpoints_;
            bitField0_ = (bitField0_ & ~0x00000001);
            connectedEndpointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConnectedEndpointsFieldBuilder()
                    : null;
          } else {
            connectedEndpointsBuilder_.addAllMessages(other.connectedEndpoints_);
          }
        }
      }
      if (other.hasConnectionPreference()) {
        connectionPreference_ = other.connectionPreference_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (consumerAcceptListsBuilder_ == null) {
        if (!other.consumerAcceptLists_.isEmpty()) {
          if (consumerAcceptLists_.isEmpty()) {
            consumerAcceptLists_ = other.consumerAcceptLists_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConsumerAcceptListsIsMutable();
            consumerAcceptLists_.addAll(other.consumerAcceptLists_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerAcceptLists_.isEmpty()) {
          if (consumerAcceptListsBuilder_.isEmpty()) {
            consumerAcceptListsBuilder_.dispose();
            consumerAcceptListsBuilder_ = null;
            consumerAcceptLists_ = other.consumerAcceptLists_;
            bitField0_ = (bitField0_ & ~0x00000004);
            consumerAcceptListsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConsumerAcceptListsFieldBuilder()
                    : null;
          } else {
            consumerAcceptListsBuilder_.addAllMessages(other.consumerAcceptLists_);
          }
        }
      }
      if (!other.consumerRejectLists_.isEmpty()) {
        if (consumerRejectLists_.isEmpty()) {
          consumerRejectLists_ = other.consumerRejectLists_;
          bitField0_ |= 0x00000008;
        } else {
          ensureConsumerRejectListsIsMutable();
          consumerRejectLists_.addAll(other.consumerRejectLists_);
        }
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.domainNames_.isEmpty()) {
        if (domainNames_.isEmpty()) {
          domainNames_ = other.domainNames_;
          bitField0_ |= 0x00000040;
        } else {
          ensureDomainNamesIsMutable();
          domainNames_.addAll(other.domainNames_);
        }
        onChanged();
      }
      if (other.hasEnableProxyProtocol()) {
        setEnableProxyProtocol(other.getEnableProxyProtocol());
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.natSubnets_.isEmpty()) {
        if (natSubnets_.isEmpty()) {
          natSubnets_ = other.natSubnets_;
          bitField0_ |= 0x00001000;
        } else {
          ensureNatSubnetsIsMutable();
          natSubnets_.addAll(other.natSubnets_);
        }
        onChanged();
      }
      if (other.hasProducerForwardingRule()) {
        producerForwardingRule_ = other.producerForwardingRule_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasPscServiceAttachmentId()) {
        mergePscServiceAttachmentId(other.getPscServiceAttachmentId());
      }
      if (other.hasReconcileConnections()) {
        setReconcileConnections(other.getReconcileConnections());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasTargetService()) {
        targetService_ = other.targetService_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 26840
            case 10350650:
              {
                targetService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 10350650
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26989658
            case 51601514:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDomainNamesIsMutable();
                domainNames_.add(s);
                break;
              } // case 51601514
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 244202930
            case 577789506:
              {
                com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.parser(),
                        extensionRegistry);
                if (connectedEndpointsBuilder_ == null) {
                  ensureConnectedEndpointsIsMutable();
                  connectedEndpoints_.add(m);
                } else {
                  connectedEndpointsBuilder_.addMessage(m);
                }
                break;
              } // case 577789506
            case 1003949856:
              {
                reconcileConnections_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 1003949856
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1111570338
            case 1632265458:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureConsumerRejectListsIsMutable();
                consumerRejectLists_.add(s);
                break;
              } // case 1632265458
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 1877428002
            case 1983423114:
              {
                producerForwardingRule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1983423114
            case -2008422686:
              {
                connectionPreference_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -2008422686
            case -1384637400:
              {
                enableProxyProtocol_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case -1384637400
            case -1296679742:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNatSubnetsIsMutable();
                natSubnets_.add(s);
                break;
              } // case -1296679742
            case -1073161670:
              {
                com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.parser(),
                        extensionRegistry);
                if (consumerAcceptListsBuilder_ == null) {
                  ensureConsumerAcceptListsIsMutable();
                  consumerAcceptLists_.add(m);
                } else {
                  consumerAcceptListsBuilder_.addMessage(m);
                }
                break;
              } // case -1073161670
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -645248918
            case -73405582:
              {
                input.readMessage(
                    getPscServiceAttachmentIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case -73405582
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint>
        connectedEndpoints_ = java.util.Collections.emptyList();

    private void ensureConnectedEndpointsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        connectedEndpoints_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint>(
                connectedEndpoints_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint,
            com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder,
            com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder>
        connectedEndpointsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint>
        getConnectedEndpointsList() {
      if (connectedEndpointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(connectedEndpoints_);
      } else {
        return connectedEndpointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public int getConnectedEndpointsCount() {
      if (connectedEndpointsBuilder_ == null) {
        return connectedEndpoints_.size();
      } else {
        return connectedEndpointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint getConnectedEndpoints(
        int index) {
      if (connectedEndpointsBuilder_ == null) {
        return connectedEndpoints_.get(index);
      } else {
        return connectedEndpointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder setConnectedEndpoints(
        int index, com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint value) {
      if (connectedEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.set(index, value);
        onChanged();
      } else {
        connectedEndpointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder setConnectedEndpoints(
        int index,
        com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder builderForValue) {
      if (connectedEndpointsBuilder_ == null) {
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        connectedEndpointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder addConnectedEndpoints(
        com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint value) {
      if (connectedEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.add(value);
        onChanged();
      } else {
        connectedEndpointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder addConnectedEndpoints(
        int index, com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint value) {
      if (connectedEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.add(index, value);
        onChanged();
      } else {
        connectedEndpointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder addConnectedEndpoints(
        com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder builderForValue) {
      if (connectedEndpointsBuilder_ == null) {
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.add(builderForValue.build());
        onChanged();
      } else {
        connectedEndpointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder addConnectedEndpoints(
        int index,
        com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder builderForValue) {
      if (connectedEndpointsBuilder_ == null) {
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        connectedEndpointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder addAllConnectedEndpoints(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint>
            values) {
      if (connectedEndpointsBuilder_ == null) {
        ensureConnectedEndpointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, connectedEndpoints_);
        onChanged();
      } else {
        connectedEndpointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder clearConnectedEndpoints() {
      if (connectedEndpointsBuilder_ == null) {
        connectedEndpoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        connectedEndpointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public Builder removeConnectedEndpoints(int index) {
      if (connectedEndpointsBuilder_ == null) {
        ensureConnectedEndpointsIsMutable();
        connectedEndpoints_.remove(index);
        onChanged();
      } else {
        connectedEndpointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder
        getConnectedEndpointsBuilder(int index) {
      return getConnectedEndpointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder
        getConnectedEndpointsOrBuilder(int index) {
      if (connectedEndpointsBuilder_ == null) {
        return connectedEndpoints_.get(index);
      } else {
        return connectedEndpointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder>
        getConnectedEndpointsOrBuilderList() {
      if (connectedEndpointsBuilder_ != null) {
        return connectedEndpointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(connectedEndpoints_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder
        addConnectedEndpointsBuilder() {
      return getConnectedEndpointsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder
        addConnectedEndpointsBuilder(int index) {
      return getConnectedEndpointsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An array of connections for all the consumers connected to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint connected_endpoints = 72223688;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder>
        getConnectedEndpointsBuilderList() {
      return getConnectedEndpointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint,
            com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder,
            com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder>
        getConnectedEndpointsFieldBuilder() {
      if (connectedEndpointsBuilder_ == null) {
        connectedEndpointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint,
                com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpoint.Builder,
                com.google.cloud.compute.v1.ServiceAttachmentConnectedEndpointOrBuilder>(
                connectedEndpoints_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        connectedEndpoints_ = null;
      }
      return connectedEndpointsBuilder_;
    }

    private java.lang.Object connectionPreference_ = "";
    /**
     *
     *
     * <pre>
     * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
     * Check the ConnectionPreference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_preference = 285818076;</code>
     *
     * @return Whether the connectionPreference field is set.
     */
    public boolean hasConnectionPreference() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
     * Check the ConnectionPreference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_preference = 285818076;</code>
     *
     * @return The connectionPreference.
     */
    public java.lang.String getConnectionPreference() {
      java.lang.Object ref = connectionPreference_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionPreference_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
     * Check the ConnectionPreference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_preference = 285818076;</code>
     *
     * @return The bytes for connectionPreference.
     */
    public com.google.protobuf.ByteString getConnectionPreferenceBytes() {
      java.lang.Object ref = connectionPreference_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionPreference_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
     * Check the ConnectionPreference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_preference = 285818076;</code>
     *
     * @param value The connectionPreference to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionPreference(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      connectionPreference_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
     * Check the ConnectionPreference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_preference = 285818076;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionPreference() {
      connectionPreference_ = getDefaultInstance().getConnectionPreference();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
     * Check the ConnectionPreference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_preference = 285818076;</code>
     *
     * @param value The bytes for connectionPreference to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionPreferenceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      connectionPreference_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit>
        consumerAcceptLists_ = java.util.Collections.emptyList();

    private void ensureConsumerAcceptListsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        consumerAcceptLists_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit>(
                consumerAcceptLists_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit,
            com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder,
            com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder>
        consumerAcceptListsBuilder_;

    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit>
        getConsumerAcceptListsList() {
      if (consumerAcceptListsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerAcceptLists_);
      } else {
        return consumerAcceptListsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public int getConsumerAcceptListsCount() {
      if (consumerAcceptListsBuilder_ == null) {
        return consumerAcceptLists_.size();
      } else {
        return consumerAcceptListsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit getConsumerAcceptLists(
        int index) {
      if (consumerAcceptListsBuilder_ == null) {
        return consumerAcceptLists_.get(index);
      } else {
        return consumerAcceptListsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder setConsumerAcceptLists(
        int index, com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit value) {
      if (consumerAcceptListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.set(index, value);
        onChanged();
      } else {
        consumerAcceptListsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder setConsumerAcceptLists(
        int index,
        com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder builderForValue) {
      if (consumerAcceptListsBuilder_ == null) {
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerAcceptListsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder addConsumerAcceptLists(
        com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit value) {
      if (consumerAcceptListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.add(value);
        onChanged();
      } else {
        consumerAcceptListsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder addConsumerAcceptLists(
        int index, com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit value) {
      if (consumerAcceptListsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.add(index, value);
        onChanged();
      } else {
        consumerAcceptListsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder addConsumerAcceptLists(
        com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder builderForValue) {
      if (consumerAcceptListsBuilder_ == null) {
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.add(builderForValue.build());
        onChanged();
      } else {
        consumerAcceptListsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder addConsumerAcceptLists(
        int index,
        com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder builderForValue) {
      if (consumerAcceptListsBuilder_ == null) {
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerAcceptListsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder addAllConsumerAcceptLists(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit>
            values) {
      if (consumerAcceptListsBuilder_ == null) {
        ensureConsumerAcceptListsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumerAcceptLists_);
        onChanged();
      } else {
        consumerAcceptListsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder clearConsumerAcceptLists() {
      if (consumerAcceptListsBuilder_ == null) {
        consumerAcceptLists_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        consumerAcceptListsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public Builder removeConsumerAcceptLists(int index) {
      if (consumerAcceptListsBuilder_ == null) {
        ensureConsumerAcceptListsIsMutable();
        consumerAcceptLists_.remove(index);
        onChanged();
      } else {
        consumerAcceptListsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder
        getConsumerAcceptListsBuilder(int index) {
      return getConsumerAcceptListsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder
        getConsumerAcceptListsOrBuilder(int index) {
      if (consumerAcceptListsBuilder_ == null) {
        return consumerAcceptLists_.get(index);
      } else {
        return consumerAcceptListsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder>
        getConsumerAcceptListsOrBuilderList() {
      if (consumerAcceptListsBuilder_ != null) {
        return consumerAcceptListsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerAcceptLists_);
      }
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder
        addConsumerAcceptListsBuilder() {
      return getConsumerAcceptListsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder
        addConsumerAcceptListsBuilder(int index) {
      return getConsumerAcceptListsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Projects that are allowed to connect to this service attachment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit consumer_accept_lists = 402725703;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder>
        getConsumerAcceptListsBuilderList() {
      return getConsumerAcceptListsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit,
            com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder,
            com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder>
        getConsumerAcceptListsFieldBuilder() {
      if (consumerAcceptListsBuilder_ == null) {
        consumerAcceptListsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit,
                com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimit.Builder,
                com.google.cloud.compute.v1.ServiceAttachmentConsumerProjectLimitOrBuilder>(
                consumerAcceptLists_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        consumerAcceptLists_ = null;
      }
      return consumerAcceptListsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList consumerRejectLists_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureConsumerRejectListsIsMutable() {
      if (!consumerRejectLists_.isModifiable()) {
        consumerRejectLists_ = new com.google.protobuf.LazyStringArrayList(consumerRejectLists_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @return A list containing the consumerRejectLists.
     */
    public com.google.protobuf.ProtocolStringList getConsumerRejectListsList() {
      consumerRejectLists_.makeImmutable();
      return consumerRejectLists_;
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @return The count of consumerRejectLists.
     */
    public int getConsumerRejectListsCount() {
      return consumerRejectLists_.size();
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @param index The index of the element to return.
     * @return The consumerRejectLists at the given index.
     */
    public java.lang.String getConsumerRejectLists(int index) {
      return consumerRejectLists_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the consumerRejectLists at the given index.
     */
    public com.google.protobuf.ByteString getConsumerRejectListsBytes(int index) {
      return consumerRejectLists_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @param index The index to set the value at.
     * @param value The consumerRejectLists to set.
     * @return This builder for chaining.
     */
    public Builder setConsumerRejectLists(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureConsumerRejectListsIsMutable();
      consumerRejectLists_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @param value The consumerRejectLists to add.
     * @return This builder for chaining.
     */
    public Builder addConsumerRejectLists(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureConsumerRejectListsIsMutable();
      consumerRejectLists_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @param values The consumerRejectLists to add.
     * @return This builder for chaining.
     */
    public Builder addAllConsumerRejectLists(java.lang.Iterable<java.lang.String> values) {
      ensureConsumerRejectListsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumerRejectLists_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConsumerRejectLists() {
      consumerRejectLists_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Projects that are not allowed to connect to this service attachment. The project can be specified using its id or number.
     * </pre>
     *
     * <code>repeated string consumer_reject_lists = 204033182;</code>
     *
     * @param value The bytes of the consumerRejectLists to add.
     * @return This builder for chaining.
     */
    public Builder addConsumerRejectListsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureConsumerRejectListsIsMutable();
      consumerRejectLists_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList domainNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDomainNamesIsMutable() {
      if (!domainNames_.isModifiable()) {
        domainNames_ = new com.google.protobuf.LazyStringArrayList(domainNames_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @return A list containing the domainNames.
     */
    public com.google.protobuf.ProtocolStringList getDomainNamesList() {
      domainNames_.makeImmutable();
      return domainNames_;
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @return The count of domainNames.
     */
    public int getDomainNamesCount() {
      return domainNames_.size();
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @param index The index of the element to return.
     * @return The domainNames at the given index.
     */
    public java.lang.String getDomainNames(int index) {
      return domainNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the domainNames at the given index.
     */
    public com.google.protobuf.ByteString getDomainNamesBytes(int index) {
      return domainNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @param index The index to set the value at.
     * @param value The domainNames to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainNamesIsMutable();
      domainNames_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @param value The domainNames to add.
     * @return This builder for chaining.
     */
    public Builder addDomainNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainNamesIsMutable();
      domainNames_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @param values The domainNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomainNames(java.lang.Iterable<java.lang.String> values) {
      ensureDomainNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, domainNames_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainNames() {
      domainNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the domain name will be used during the integration between the PSC connected endpoints and the Cloud DNS. For example, this is a valid domain name: "p.mycompany.com.". Current max number of domain names supported is 1.
     * </pre>
     *
     * <code>repeated string domain_names = 6450189;</code>
     *
     * @param value The bytes of the domainNames to add.
     * @return This builder for chaining.
     */
    public Builder addDomainNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDomainNamesIsMutable();
      domainNames_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean enableProxyProtocol_;
    /**
     *
     *
     * <pre>
     * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
     * </pre>
     *
     * <code>optional bool enable_proxy_protocol = 363791237;</code>
     *
     * @return Whether the enableProxyProtocol field is set.
     */
    @java.lang.Override
    public boolean hasEnableProxyProtocol() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
     * </pre>
     *
     * <code>optional bool enable_proxy_protocol = 363791237;</code>
     *
     * @return The enableProxyProtocol.
     */
    @java.lang.Override
    public boolean getEnableProxyProtocol() {
      return enableProxyProtocol_;
    }
    /**
     *
     *
     * <pre>
     * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
     * </pre>
     *
     * <code>optional bool enable_proxy_protocol = 363791237;</code>
     *
     * @param value The enableProxyProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setEnableProxyProtocol(boolean value) {

      enableProxyProtocol_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
     * </pre>
     *
     * <code>optional bool enable_proxy_protocol = 363791237;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableProxyProtocol() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enableProxyProtocol_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ServiceAttachment. An up-to-date fingerprint must be provided in order to patch/update the ServiceAttachment; otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the ServiceAttachment.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000200);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#serviceAttachment for service attachments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList natSubnets_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNatSubnetsIsMutable() {
      if (!natSubnets_.isModifiable()) {
        natSubnets_ = new com.google.protobuf.LazyStringArrayList(natSubnets_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @return A list containing the natSubnets.
     */
    public com.google.protobuf.ProtocolStringList getNatSubnetsList() {
      natSubnets_.makeImmutable();
      return natSubnets_;
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @return The count of natSubnets.
     */
    public int getNatSubnetsCount() {
      return natSubnets_.size();
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @param index The index of the element to return.
     * @return The natSubnets at the given index.
     */
    public java.lang.String getNatSubnets(int index) {
      return natSubnets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the natSubnets at the given index.
     */
    public com.google.protobuf.ByteString getNatSubnetsBytes(int index) {
      return natSubnets_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @param index The index to set the value at.
     * @param value The natSubnets to set.
     * @return This builder for chaining.
     */
    public Builder setNatSubnets(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNatSubnetsIsMutable();
      natSubnets_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @param value The natSubnets to add.
     * @return This builder for chaining.
     */
    public Builder addNatSubnets(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNatSubnetsIsMutable();
      natSubnets_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @param values The natSubnets to add.
     * @return This builder for chaining.
     */
    public Builder addAllNatSubnets(java.lang.Iterable<java.lang.String> values) {
      ensureNatSubnetsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, natSubnets_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatSubnets() {
      natSubnets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of URLs where each entry is the URL of a subnet provided by the service producer to use for NAT in this service attachment.
     * </pre>
     *
     * <code>repeated string nat_subnets = 374785944;</code>
     *
     * @param value The bytes of the natSubnets to add.
     * @return This builder for chaining.
     */
    public Builder addNatSubnetsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNatSubnetsIsMutable();
      natSubnets_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object producerForwardingRule_ = "";
    /**
     *
     *
     * <pre>
     * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string producer_forwarding_rule = 247927889;</code>
     *
     * @return Whether the producerForwardingRule field is set.
     */
    public boolean hasProducerForwardingRule() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string producer_forwarding_rule = 247927889;</code>
     *
     * @return The producerForwardingRule.
     */
    public java.lang.String getProducerForwardingRule() {
      java.lang.Object ref = producerForwardingRule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        producerForwardingRule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string producer_forwarding_rule = 247927889;</code>
     *
     * @return The bytes for producerForwardingRule.
     */
    public com.google.protobuf.ByteString getProducerForwardingRuleBytes() {
      java.lang.Object ref = producerForwardingRule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        producerForwardingRule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string producer_forwarding_rule = 247927889;</code>
     *
     * @param value The producerForwardingRule to set.
     * @return This builder for chaining.
     */
    public Builder setProducerForwardingRule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      producerForwardingRule_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string producer_forwarding_rule = 247927889;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProducerForwardingRule() {
      producerForwardingRule_ = getDefaultInstance().getProducerForwardingRule();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of a forwarding rule with loadBalancingScheme INTERNAL* that is serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string producer_forwarding_rule = 247927889;</code>
     *
     * @param value The bytes for producerForwardingRule to set.
     * @return This builder for chaining.
     */
    public Builder setProducerForwardingRuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      producerForwardingRule_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Uint128 pscServiceAttachmentId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Uint128,
            com.google.cloud.compute.v1.Uint128.Builder,
            com.google.cloud.compute.v1.Uint128OrBuilder>
        pscServiceAttachmentIdBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     *
     * @return Whether the pscServiceAttachmentId field is set.
     */
    public boolean hasPscServiceAttachmentId() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     *
     * @return The pscServiceAttachmentId.
     */
    public com.google.cloud.compute.v1.Uint128 getPscServiceAttachmentId() {
      if (pscServiceAttachmentIdBuilder_ == null) {
        return pscServiceAttachmentId_ == null
            ? com.google.cloud.compute.v1.Uint128.getDefaultInstance()
            : pscServiceAttachmentId_;
      } else {
        return pscServiceAttachmentIdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    public Builder setPscServiceAttachmentId(com.google.cloud.compute.v1.Uint128 value) {
      if (pscServiceAttachmentIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pscServiceAttachmentId_ = value;
      } else {
        pscServiceAttachmentIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    public Builder setPscServiceAttachmentId(
        com.google.cloud.compute.v1.Uint128.Builder builderForValue) {
      if (pscServiceAttachmentIdBuilder_ == null) {
        pscServiceAttachmentId_ = builderForValue.build();
      } else {
        pscServiceAttachmentIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    public Builder mergePscServiceAttachmentId(com.google.cloud.compute.v1.Uint128 value) {
      if (pscServiceAttachmentIdBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && pscServiceAttachmentId_ != null
            && pscServiceAttachmentId_
                != com.google.cloud.compute.v1.Uint128.getDefaultInstance()) {
          getPscServiceAttachmentIdBuilder().mergeFrom(value);
        } else {
          pscServiceAttachmentId_ = value;
        }
      } else {
        pscServiceAttachmentIdBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    public Builder clearPscServiceAttachmentId() {
      bitField0_ = (bitField0_ & ~0x00004000);
      pscServiceAttachmentId_ = null;
      if (pscServiceAttachmentIdBuilder_ != null) {
        pscServiceAttachmentIdBuilder_.dispose();
        pscServiceAttachmentIdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    public com.google.cloud.compute.v1.Uint128.Builder getPscServiceAttachmentIdBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getPscServiceAttachmentIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    public com.google.cloud.compute.v1.Uint128OrBuilder getPscServiceAttachmentIdOrBuilder() {
      if (pscServiceAttachmentIdBuilder_ != null) {
        return pscServiceAttachmentIdBuilder_.getMessageOrBuilder();
      } else {
        return pscServiceAttachmentId_ == null
            ? com.google.cloud.compute.v1.Uint128.getDefaultInstance()
            : pscServiceAttachmentId_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An 128-bit global unique ID of the PSC service attachment.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Uint128 psc_service_attachment_id = 527695214;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Uint128,
            com.google.cloud.compute.v1.Uint128.Builder,
            com.google.cloud.compute.v1.Uint128OrBuilder>
        getPscServiceAttachmentIdFieldBuilder() {
      if (pscServiceAttachmentIdBuilder_ == null) {
        pscServiceAttachmentIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Uint128,
                com.google.cloud.compute.v1.Uint128.Builder,
                com.google.cloud.compute.v1.Uint128OrBuilder>(
                getPscServiceAttachmentId(), getParentForChildren(), isClean());
        pscServiceAttachmentId_ = null;
      }
      return pscServiceAttachmentIdBuilder_;
    }

    private boolean reconcileConnections_;
    /**
     *
     *
     * <pre>
     * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints. - If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified . - If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list. For newly created service attachment, this boolean defaults to true.
     * </pre>
     *
     * <code>optional bool reconcile_connections = 125493732;</code>
     *
     * @return Whether the reconcileConnections field is set.
     */
    @java.lang.Override
    public boolean hasReconcileConnections() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints. - If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified . - If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list. For newly created service attachment, this boolean defaults to true.
     * </pre>
     *
     * <code>optional bool reconcile_connections = 125493732;</code>
     *
     * @return The reconcileConnections.
     */
    @java.lang.Override
    public boolean getReconcileConnections() {
      return reconcileConnections_;
    }
    /**
     *
     *
     * <pre>
     * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints. - If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified . - If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list. For newly created service attachment, this boolean defaults to true.
     * </pre>
     *
     * <code>optional bool reconcile_connections = 125493732;</code>
     *
     * @param value The reconcileConnections to set.
     * @return This builder for chaining.
     */
    public Builder setReconcileConnections(boolean value) {

      reconcileConnections_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints. - If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified . - If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list. For newly created service attachment, this boolean defaults to true.
     * </pre>
     *
     * <code>optional bool reconcile_connections = 125493732;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconcileConnections() {
      bitField0_ = (bitField0_ & ~0x00008000);
      reconcileConnections_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the service attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object targetService_ = "";
    /**
     *
     *
     * <pre>
     * The URL of a service serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string target_service = 1293831;</code>
     *
     * @return Whether the targetService field is set.
     */
    public boolean hasTargetService() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of a service serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string target_service = 1293831;</code>
     *
     * @return The targetService.
     */
    public java.lang.String getTargetService() {
      java.lang.Object ref = targetService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of a service serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string target_service = 1293831;</code>
     *
     * @return The bytes for targetService.
     */
    public com.google.protobuf.ByteString getTargetServiceBytes() {
      java.lang.Object ref = targetService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of a service serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string target_service = 1293831;</code>
     *
     * @param value The targetService to set.
     * @return This builder for chaining.
     */
    public Builder setTargetService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetService_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of a service serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string target_service = 1293831;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetService() {
      targetService_ = getDefaultInstance().getTargetService();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of a service serving the endpoint identified by this service attachment.
     * </pre>
     *
     * <code>optional string target_service = 1293831;</code>
     *
     * @param value The bytes for targetService to set.
     * @return This builder for chaining.
     */
    public Builder setTargetServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetService_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ServiceAttachment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ServiceAttachment)
  private static final com.google.cloud.compute.v1.ServiceAttachment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ServiceAttachment();
  }

  public static com.google.cloud.compute.v1.ServiceAttachment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceAttachment> PARSER =
      new com.google.protobuf.AbstractParser<ServiceAttachment>() {
        @java.lang.Override
        public ServiceAttachment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceAttachment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceAttachment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAttachment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
