/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * DEPRECATED: Please use compute#instanceProperties instead. New properties will not be added to this field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SourceInstanceProperties}
 */
public final class SourceInstanceProperties extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SourceInstanceProperties)
    SourceInstancePropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SourceInstanceProperties.newBuilder() to construct.
  private SourceInstanceProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SourceInstanceProperties() {
    description_ = "";
    disks_ = java.util.Collections.emptyList();
    guestAccelerators_ = java.util.Collections.emptyList();
    keyRevocationActionType_ = "";
    machineType_ = "";
    minCpuPlatform_ = "";
    networkInterfaces_ = java.util.Collections.emptyList();
    serviceAccounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SourceInstanceProperties();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SourceInstanceProperties_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SourceInstanceProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SourceInstanceProperties.class,
            com.google.cloud.compute.v1.SourceInstanceProperties.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SourceInstanceProperties.KeyRevocationActionType}
   */
  public enum KeyRevocationActionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_KEY_REVOCATION_ACTION_TYPE = 0;</code>
     */
    UNDEFINED_KEY_REVOCATION_ACTION_TYPE(0),
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 467110106;</code>
     */
    KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED(467110106),
    /**
     *
     *
     * <pre>
     * Indicates user chose no operation.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    /**
     *
     *
     * <pre>
     * Indicates user chose to opt for VM shutdown on key revocation.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    STOP(2555906),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_KEY_REVOCATION_ACTION_TYPE = 0;</code>
     */
    public static final int UNDEFINED_KEY_REVOCATION_ACTION_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 467110106;</code>
     */
    public static final int KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED_VALUE = 467110106;
    /**
     *
     *
     * <pre>
     * Indicates user chose no operation.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;
    /**
     *
     *
     * <pre>
     * Indicates user chose to opt for VM shutdown on key revocation.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    public static final int STOP_VALUE = 2555906;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyRevocationActionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyRevocationActionType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_KEY_REVOCATION_ACTION_TYPE;
        case 467110106:
          return KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED;
        case 2402104:
          return NONE;
        case 2555906:
          return STOP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>() {
              public KeyRevocationActionType findValueByNumber(int number) {
                return KeyRevocationActionType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SourceInstanceProperties.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final KeyRevocationActionType[] VALUES = values();

    public static KeyRevocationActionType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyRevocationActionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SourceInstanceProperties.KeyRevocationActionType)
  }

  private int bitField0_;
  public static final int CAN_IP_FORWARD_FIELD_NUMBER = 467731324;
  private boolean canIpForward_ = false;
  /**
   *
   *
   * <pre>
   * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return Whether the canIpForward field is set.
   */
  @java.lang.Override
  public boolean hasCanIpForward() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return The canIpForward.
   */
  @java.lang.Override
  public boolean getCanIpForward() {
    return canIpForward_;
  }

  public static final int DELETION_PROTECTION_FIELD_NUMBER = 458014698;
  private boolean deletionProtection_ = false;
  /**
   *
   *
   * <pre>
   * Whether the instance created from this machine image should be protected against deletion.
   * </pre>
   *
   * <code>optional bool deletion_protection = 458014698;</code>
   *
   * @return Whether the deletionProtection field is set.
   */
  @java.lang.Override
  public boolean hasDeletionProtection() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether the instance created from this machine image should be protected against deletion.
   * </pre>
   *
   * <code>optional bool deletion_protection = 458014698;</code>
   *
   * @return The deletionProtection.
   */
  @java.lang.Override
  public boolean getDeletionProtection() {
    return deletionProtection_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional text description for the instances that are created from this machine image.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional text description for the instances that are created from this machine image.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional text description for the instances that are created from this machine image.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISKS_FIELD_NUMBER = 95594102;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SavedAttachedDisk> disks_;
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SavedAttachedDisk> getDisksList() {
    return disks_;
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder>
      getDisksOrBuilderList() {
    return disks_;
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public int getDisksCount() {
    return disks_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SavedAttachedDisk getDisks(int index) {
    return disks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder getDisksOrBuilder(int index) {
    return disks_.get(index);
  }

  public static final int GUEST_ACCELERATORS_FIELD_NUMBER = 463595119;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_;
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getGuestAcceleratorsList() {
    return guestAccelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
      getGuestAcceleratorsOrBuilderList() {
    return guestAccelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public int getGuestAcceleratorsCount() {
    return guestAccelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
    return guestAccelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from this machine image.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
      int index) {
    return guestAccelerators_.get(index);
  }

  public static final int KEY_REVOCATION_ACTION_TYPE_FIELD_NUMBER = 235941474;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyRevocationActionType_ = "";
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return Whether the keyRevocationActionType field is set.
   */
  @java.lang.Override
  public boolean hasKeyRevocationActionType() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The keyRevocationActionType.
   */
  @java.lang.Override
  public java.lang.String getKeyRevocationActionType() {
    java.lang.Object ref = keyRevocationActionType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyRevocationActionType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The bytes for keyRevocationActionType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyRevocationActionTypeBytes() {
    java.lang.Object ref = keyRevocationActionType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyRevocationActionType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_SourceInstanceProperties_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from this machine image.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from this machine image.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from this machine image.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from this machine image.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 227711026;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * The machine type to use for instances that are created from this machine image.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return Whether the machineType field is set.
   */
  @java.lang.Override
  public boolean hasMachineType() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The machine type to use for instances that are created from this machine image.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The machine type to use for instances that are created from this machine image.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 86866735;
  private com.google.cloud.compute.v1.Metadata metadata_;
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Metadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : metadata_;
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 242912759;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minCpuPlatform_ = "";
  /**
   *
   *
   * <pre>
   * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return Whether the minCpuPlatform field is set.
   */
  @java.lang.Override
  public boolean hasMinCpuPlatform() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_INTERFACES_FIELD_NUMBER = 52735243;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.NetworkInterface> networkInterfaces_;
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList() {
    return networkInterfaces_;
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
      getNetworkInterfacesOrBuilderList() {
    return networkInterfaces_;
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public int getNetworkInterfacesCount() {
    return networkInterfaces_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index) {
    return networkInterfaces_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
      int index) {
    return networkInterfaces_.get(index);
  }

  public static final int SCHEDULING_FIELD_NUMBER = 386688404;
  private com.google.cloud.compute.v1.Scheduling scheduling_;
  /**
   *
   *
   * <pre>
   * Specifies the scheduling options for the instances that are created from this machine image.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the scheduling options for the instances that are created from this machine image.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Scheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
        : scheduling_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the scheduling options for the instances that are created from this machine image.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
        : scheduling_;
  }

  public static final int SERVICE_ACCOUNTS_FIELD_NUMBER = 277537328;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ServiceAccount> serviceAccounts_;
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList() {
    return serviceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
      getServiceAccountsOrBuilderList() {
    return serviceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public int getServiceAccountsCount() {
    return serviceAccounts_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index) {
    return serviceAccounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
      int index) {
    return serviceAccounts_.get(index);
  }

  public static final int TAGS_FIELD_NUMBER = 3552281;
  private com.google.cloud.compute.v1.Tags tags_;
  /**
   *
   *
   * <pre>
   * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return Whether the tags field is set.
   */
  @java.lang.Override
  public boolean hasTags() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return The tags.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Tags getTags() {
    return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder() {
    return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(3552281, getTags());
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      output.writeMessage(52735243, networkInterfaces_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(86866735, getMetadata());
    }
    for (int i = 0; i < disks_.size(); i++) {
      output.writeMessage(95594102, disks_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227711026, machineType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 235941474, keyRevocationActionType_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 242912759, minCpuPlatform_);
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      output.writeMessage(277537328, serviceAccounts_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(458014698, deletionProtection_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      output.writeMessage(463595119, guestAccelerators_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(467731324, canIpForward_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3552281, getTags());
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              52735243, networkInterfaces_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(86866735, getMetadata());
    }
    for (int i = 0; i < disks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(95594102, disks_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227711026, machineType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              235941474, keyRevocationActionType_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(242912759, minCpuPlatform_);
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              277537328, serviceAccounts_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(458014698, deletionProtection_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              463595119, guestAccelerators_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(467731324, canIpForward_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SourceInstanceProperties)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SourceInstanceProperties other =
        (com.google.cloud.compute.v1.SourceInstanceProperties) obj;

    if (hasCanIpForward() != other.hasCanIpForward()) return false;
    if (hasCanIpForward()) {
      if (getCanIpForward() != other.getCanIpForward()) return false;
    }
    if (hasDeletionProtection() != other.hasDeletionProtection()) return false;
    if (hasDeletionProtection()) {
      if (getDeletionProtection() != other.getDeletionProtection()) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getDisksList().equals(other.getDisksList())) return false;
    if (!getGuestAcceleratorsList().equals(other.getGuestAcceleratorsList())) return false;
    if (hasKeyRevocationActionType() != other.hasKeyRevocationActionType()) return false;
    if (hasKeyRevocationActionType()) {
      if (!getKeyRevocationActionType().equals(other.getKeyRevocationActionType())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasMachineType() != other.hasMachineType()) return false;
    if (hasMachineType()) {
      if (!getMachineType().equals(other.getMachineType())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasMinCpuPlatform() != other.hasMinCpuPlatform()) return false;
    if (hasMinCpuPlatform()) {
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    }
    if (!getNetworkInterfacesList().equals(other.getNetworkInterfacesList())) return false;
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (!getServiceAccountsList().equals(other.getServiceAccountsList())) return false;
    if (hasTags() != other.hasTags()) return false;
    if (hasTags()) {
      if (!getTags().equals(other.getTags())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCanIpForward()) {
      hash = (37 * hash) + CAN_IP_FORWARD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCanIpForward());
    }
    if (hasDeletionProtection()) {
      hash = (37 * hash) + DELETION_PROTECTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeletionProtection());
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getDisksCount() > 0) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDisksList().hashCode();
    }
    if (getGuestAcceleratorsCount() > 0) {
      hash = (37 * hash) + GUEST_ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getGuestAcceleratorsList().hashCode();
    }
    if (hasKeyRevocationActionType()) {
      hash = (37 * hash) + KEY_REVOCATION_ACTION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getKeyRevocationActionType().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasMachineType()) {
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasMinCpuPlatform()) {
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
    }
    if (getNetworkInterfacesCount() > 0) {
      hash = (37 * hash) + NETWORK_INTERFACES_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkInterfacesList().hashCode();
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    if (getServiceAccountsCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountsList().hashCode();
    }
    if (hasTags()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTags().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.SourceInstanceProperties prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED: Please use compute#instanceProperties instead. New properties will not be added to this field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SourceInstanceProperties}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SourceInstanceProperties)
      com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SourceInstanceProperties_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SourceInstanceProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SourceInstanceProperties.class,
              com.google.cloud.compute.v1.SourceInstanceProperties.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SourceInstanceProperties.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDisksFieldBuilder();
        getGuestAcceleratorsFieldBuilder();
        getMetadataFieldBuilder();
        getNetworkInterfacesFieldBuilder();
        getSchedulingFieldBuilder();
        getServiceAccountsFieldBuilder();
        getTagsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      canIpForward_ = false;
      deletionProtection_ = false;
      description_ = "";
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
      } else {
        disks_ = null;
        disksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
      } else {
        guestAccelerators_ = null;
        guestAcceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      keyRevocationActionType_ = "";
      internalGetMutableLabels().clear();
      machineType_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      minCpuPlatform_ = "";
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
      } else {
        networkInterfaces_ = null;
        networkInterfacesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
      } else {
        serviceAccounts_ = null;
        serviceAccountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SourceInstanceProperties_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SourceInstanceProperties getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SourceInstanceProperties build() {
      com.google.cloud.compute.v1.SourceInstanceProperties result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SourceInstanceProperties buildPartial() {
      com.google.cloud.compute.v1.SourceInstanceProperties result =
          new com.google.cloud.compute.v1.SourceInstanceProperties(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.SourceInstanceProperties result) {
      if (disksBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          disks_ = java.util.Collections.unmodifiableList(disks_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.disks_ = disks_;
      } else {
        result.disks_ = disksBuilder_.build();
      }
      if (guestAcceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          guestAccelerators_ = java.util.Collections.unmodifiableList(guestAccelerators_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.guestAccelerators_ = guestAccelerators_;
      } else {
        result.guestAccelerators_ = guestAcceleratorsBuilder_.build();
      }
      if (networkInterfacesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          networkInterfaces_ = java.util.Collections.unmodifiableList(networkInterfaces_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.networkInterfaces_ = networkInterfaces_;
      } else {
        result.networkInterfaces_ = networkInterfacesBuilder_.build();
      }
      if (serviceAccountsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          serviceAccounts_ = java.util.Collections.unmodifiableList(serviceAccounts_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.serviceAccounts_ = serviceAccounts_;
      } else {
        result.serviceAccounts_ = serviceAccountsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.SourceInstanceProperties result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.canIpForward_ = canIpForward_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deletionProtection_ = deletionProtection_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.keyRevocationActionType_ = keyRevocationActionType_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.machineType_ = machineType_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.minCpuPlatform_ = minCpuPlatform_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.scheduling_ = schedulingBuilder_ == null ? scheduling_ : schedulingBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.tags_ = tagsBuilder_ == null ? tags_ : tagsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SourceInstanceProperties) {
        return mergeFrom((com.google.cloud.compute.v1.SourceInstanceProperties) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SourceInstanceProperties other) {
      if (other == com.google.cloud.compute.v1.SourceInstanceProperties.getDefaultInstance())
        return this;
      if (other.hasCanIpForward()) {
        setCanIpForward(other.getCanIpForward());
      }
      if (other.hasDeletionProtection()) {
        setDeletionProtection(other.getDeletionProtection());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (disksBuilder_ == null) {
        if (!other.disks_.isEmpty()) {
          if (disks_.isEmpty()) {
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDisksIsMutable();
            disks_.addAll(other.disks_);
          }
          onChanged();
        }
      } else {
        if (!other.disks_.isEmpty()) {
          if (disksBuilder_.isEmpty()) {
            disksBuilder_.dispose();
            disksBuilder_ = null;
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000008);
            disksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDisksFieldBuilder()
                    : null;
          } else {
            disksBuilder_.addAllMessages(other.disks_);
          }
        }
      }
      if (guestAcceleratorsBuilder_ == null) {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAccelerators_.isEmpty()) {
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureGuestAcceleratorsIsMutable();
            guestAccelerators_.addAll(other.guestAccelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAcceleratorsBuilder_.isEmpty()) {
            guestAcceleratorsBuilder_.dispose();
            guestAcceleratorsBuilder_ = null;
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000010);
            guestAcceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGuestAcceleratorsFieldBuilder()
                    : null;
          } else {
            guestAcceleratorsBuilder_.addAllMessages(other.guestAccelerators_);
          }
        }
      }
      if (other.hasKeyRevocationActionType()) {
        keyRevocationActionType_ = other.keyRevocationActionType_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.hasMachineType()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasMinCpuPlatform()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (networkInterfacesBuilder_ == null) {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfaces_.isEmpty()) {
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureNetworkInterfacesIsMutable();
            networkInterfaces_.addAll(other.networkInterfaces_);
          }
          onChanged();
        }
      } else {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfacesBuilder_.isEmpty()) {
            networkInterfacesBuilder_.dispose();
            networkInterfacesBuilder_ = null;
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x00000400);
            networkInterfacesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNetworkInterfacesFieldBuilder()
                    : null;
          } else {
            networkInterfacesBuilder_.addAllMessages(other.networkInterfaces_);
          }
        }
      }
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (serviceAccountsBuilder_ == null) {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccounts_.isEmpty()) {
            serviceAccounts_ = other.serviceAccounts_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureServiceAccountsIsMutable();
            serviceAccounts_.addAll(other.serviceAccounts_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccountsBuilder_.isEmpty()) {
            serviceAccountsBuilder_.dispose();
            serviceAccountsBuilder_ = null;
            serviceAccounts_ = other.serviceAccounts_;
            bitField0_ = (bitField0_ & ~0x00001000);
            serviceAccountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceAccountsFieldBuilder()
                    : null;
          } else {
            serviceAccountsBuilder_.addAllMessages(other.serviceAccounts_);
          }
        }
      }
      if (other.hasTags()) {
        mergeTags(other.getTags());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28418250:
              {
                input.readMessage(getTagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 28418250
            case 421881946:
              {
                com.google.cloud.compute.v1.NetworkInterface m =
                    input.readMessage(
                        com.google.cloud.compute.v1.NetworkInterface.parser(), extensionRegistry);
                if (networkInterfacesBuilder_ == null) {
                  ensureNetworkInterfacesIsMutable();
                  networkInterfaces_.add(m);
                } else {
                  networkInterfacesBuilder_.addMessage(m);
                }
                break;
              } // case 421881946
            case 694933882:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 694933882
            case 764752818:
              {
                com.google.cloud.compute.v1.SavedAttachedDisk m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SavedAttachedDisk.parser(), extensionRegistry);
                if (disksBuilder_ == null) {
                  ensureDisksIsMutable();
                  disks_.add(m);
                } else {
                  disksBuilder_.addMessage(m);
                }
                break;
              } // case 764752818
            case 1821688210:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1821688210
            case 1887531794:
              {
                keyRevocationActionType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1887531794
            case 1943302074:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 1943302074
            case -2074668670:
              {
                com.google.cloud.compute.v1.ServiceAccount m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ServiceAccount.parser(), extensionRegistry);
                if (serviceAccountsBuilder_ == null) {
                  ensureServiceAccountsIsMutable();
                  serviceAccounts_.add(m);
                } else {
                  serviceAccountsBuilder_.addMessage(m);
                }
                break;
              } // case -2074668670
            case -1201460062:
              {
                input.readMessage(getSchedulingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case -1201460062
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -630849712:
              {
                deletionProtection_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -630849712
            case -586206342:
              {
                com.google.cloud.compute.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (guestAcceleratorsBuilder_ == null) {
                  ensureGuestAcceleratorsIsMutable();
                  guestAccelerators_.add(m);
                } else {
                  guestAcceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case -586206342
            case -553116704:
              {
                canIpForward_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -553116704
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case -293404678
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean canIpForward_;
    /**
     *
     *
     * <pre>
     * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return Whether the canIpForward field is set.
     */
    @java.lang.Override
    public boolean hasCanIpForward() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return The canIpForward.
     */
    @java.lang.Override
    public boolean getCanIpForward() {
      return canIpForward_;
    }
    /**
     *
     *
     * <pre>
     * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @param value The canIpForward to set.
     * @return This builder for chaining.
     */
    public Builder setCanIpForward(boolean value) {

      canIpForward_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanIpForward() {
      bitField0_ = (bitField0_ & ~0x00000001);
      canIpForward_ = false;
      onChanged();
      return this;
    }

    private boolean deletionProtection_;
    /**
     *
     *
     * <pre>
     * Whether the instance created from this machine image should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @return Whether the deletionProtection field is set.
     */
    @java.lang.Override
    public boolean hasDeletionProtection() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether the instance created from this machine image should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @return The deletionProtection.
     */
    @java.lang.Override
    public boolean getDeletionProtection() {
      return deletionProtection_;
    }
    /**
     *
     *
     * <pre>
     * Whether the instance created from this machine image should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @param value The deletionProtection to set.
     * @return This builder for chaining.
     */
    public Builder setDeletionProtection(boolean value) {

      deletionProtection_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the instance created from this machine image should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeletionProtection() {
      bitField0_ = (bitField0_ & ~0x00000002);
      deletionProtection_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SavedAttachedDisk> disks_ =
        java.util.Collections.emptyList();

    private void ensureDisksIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        disks_ = new java.util.ArrayList<com.google.cloud.compute.v1.SavedAttachedDisk>(disks_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SavedAttachedDisk,
            com.google.cloud.compute.v1.SavedAttachedDisk.Builder,
            com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder>
        disksBuilder_;

    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.SavedAttachedDisk> getDisksList() {
      if (disksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(disks_);
      } else {
        return disksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public int getDisksCount() {
      if (disksBuilder_ == null) {
        return disks_.size();
      } else {
        return disksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.SavedAttachedDisk getDisks(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder setDisks(int index, com.google.cloud.compute.v1.SavedAttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.set(index, value);
        onChanged();
      } else {
        disksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder setDisks(
        int index, com.google.cloud.compute.v1.SavedAttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.set(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(com.google.cloud.compute.v1.SavedAttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(value);
        onChanged();
      } else {
        disksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(int index, com.google.cloud.compute.v1.SavedAttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(index, value);
        onChanged();
      } else {
        disksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(com.google.cloud.compute.v1.SavedAttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(
        int index, com.google.cloud.compute.v1.SavedAttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder addAllDisks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SavedAttachedDisk> values) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, disks_);
        onChanged();
      } else {
        disksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder clearDisks() {
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        disksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public Builder removeDisks(int index) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.remove(index);
        onChanged();
      } else {
        disksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.SavedAttachedDisk.Builder getDisksBuilder(int index) {
      return getDisksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder getDisksOrBuilder(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder>
        getDisksOrBuilderList() {
      if (disksBuilder_ != null) {
        return disksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(disks_);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.SavedAttachedDisk.Builder addDisksBuilder() {
      return getDisksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.SavedAttachedDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.SavedAttachedDisk.Builder addDisksBuilder(int index) {
      return getDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.SavedAttachedDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SavedAttachedDisk disks = 95594102;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.SavedAttachedDisk.Builder>
        getDisksBuilderList() {
      return getDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SavedAttachedDisk,
            com.google.cloud.compute.v1.SavedAttachedDisk.Builder,
            com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder>
        getDisksFieldBuilder() {
      if (disksBuilder_ == null) {
        disksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SavedAttachedDisk,
                com.google.cloud.compute.v1.SavedAttachedDisk.Builder,
                com.google.cloud.compute.v1.SavedAttachedDiskOrBuilder>(
                disks_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        disks_ = null;
      }
      return disksBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_ =
        java.util.Collections.emptyList();

    private void ensureGuestAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        guestAccelerators_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AcceleratorConfig>(
                guestAccelerators_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        guestAcceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig>
        getGuestAcceleratorsList() {
      if (guestAcceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      } else {
        return guestAcceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public int getGuestAcceleratorsCount() {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.size();
      } else {
        return guestAcceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addAllGuestAccelerators(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AcceleratorConfig> values) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, guestAccelerators_);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder clearGuestAccelerators() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder removeGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.remove(index);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder getGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
        int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsOrBuilderList() {
      if (guestAcceleratorsBuilder_ != null) {
        return guestAcceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder() {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from this machine image.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig.Builder>
        getGuestAcceleratorsBuilderList() {
      return getGuestAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsFieldBuilder() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAcceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AcceleratorConfig,
                com.google.cloud.compute.v1.AcceleratorConfig.Builder,
                com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>(
                guestAccelerators_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        guestAccelerators_ = null;
      }
      return guestAcceleratorsBuilder_;
    }

    private java.lang.Object keyRevocationActionType_ = "";
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return Whether the keyRevocationActionType field is set.
     */
    public boolean hasKeyRevocationActionType() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return The keyRevocationActionType.
     */
    public java.lang.String getKeyRevocationActionType() {
      java.lang.Object ref = keyRevocationActionType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyRevocationActionType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return The bytes for keyRevocationActionType.
     */
    public com.google.protobuf.ByteString getKeyRevocationActionTypeBytes() {
      java.lang.Object ref = keyRevocationActionType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyRevocationActionType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @param value The keyRevocationActionType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyRevocationActionType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyRevocationActionType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyRevocationActionType() {
      keyRevocationActionType_ = getDefaultInstance().getKeyRevocationActionType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @param value The bytes for keyRevocationActionType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyRevocationActionTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyRevocationActionType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from this machine image.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return Whether the machineType field is set.
     */
    public boolean hasMachineType() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from this machine image.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.compute.v1.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder setMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder setMetadata(com.google.cloud.compute.v1.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder mergeMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.compute.v1.Metadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000100);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public com.google.cloud.compute.v1.Metadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Metadata,
                com.google.cloud.compute.v1.Metadata.Builder,
                com.google.cloud.compute.v1.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return Whether the minCpuPlatform field is set.
     */
    public boolean hasMinCpuPlatform() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The minCpuPlatform.
     */
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCpuPlatform() {
      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.NetworkInterface> networkInterfaces_ =
        java.util.Collections.emptyList();

    private void ensureNetworkInterfacesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        networkInterfaces_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.NetworkInterface>(
                networkInterfaces_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkInterface,
            com.google.cloud.compute.v1.NetworkInterface.Builder,
            com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        networkInterfacesBuilder_;

    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList() {
      if (networkInterfacesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      } else {
        return networkInterfacesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public int getNetworkInterfacesCount() {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.size();
      } else {
        return networkInterfacesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addAllNetworkInterfaces(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.NetworkInterface> values) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkInterfaces_);
        onChanged();
      } else {
        networkInterfacesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder clearNetworkInterfaces() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        networkInterfacesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder removeNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.remove(index);
        onChanged();
      } else {
        networkInterfacesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder getNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
        int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        getNetworkInterfacesOrBuilderList() {
      if (networkInterfacesBuilder_ != null) {
        return networkInterfacesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder addNetworkInterfacesBuilder() {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.NetworkInterface.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder addNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.NetworkInterface.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkInterface.Builder>
        getNetworkInterfacesBuilderList() {
      return getNetworkInterfacesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkInterface,
            com.google.cloud.compute.v1.NetworkInterface.Builder,
            com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        getNetworkInterfacesFieldBuilder() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfacesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkInterface,
                com.google.cloud.compute.v1.NetworkInterface.Builder,
                com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>(
                networkInterfaces_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        networkInterfaces_ = null;
      }
      return networkInterfacesBuilder_;
    }

    private com.google.cloud.compute.v1.Scheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Scheduling,
            com.google.cloud.compute.v1.Scheduling.Builder,
            com.google.cloud.compute.v1.SchedulingOrBuilder>
        schedulingBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.compute.v1.Scheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
      } else {
        schedulingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.Scheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder mergeScheduling(com.google.cloud.compute.v1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && scheduling_ != null
            && scheduling_ != com.google.cloud.compute.v1.Scheduling.getDefaultInstance()) {
          getSchedulingBuilder().mergeFrom(value);
        } else {
          scheduling_ = value;
        }
      } else {
        schedulingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder clearScheduling() {
      bitField0_ = (bitField0_ & ~0x00000800);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public com.google.cloud.compute.v1.Scheduling.Builder getSchedulingBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
            : scheduling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from this machine image.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Scheduling,
            com.google.cloud.compute.v1.Scheduling.Builder,
            com.google.cloud.compute.v1.SchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Scheduling,
                com.google.cloud.compute.v1.Scheduling.Builder,
                com.google.cloud.compute.v1.SchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.ServiceAccount> serviceAccounts_ =
        java.util.Collections.emptyList();

    private void ensureServiceAccountsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        serviceAccounts_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ServiceAccount>(serviceAccounts_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAccount,
            com.google.cloud.compute.v1.ServiceAccount.Builder,
            com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        serviceAccountsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList() {
      if (serviceAccountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      } else {
        return serviceAccountsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public int getServiceAccountsCount() {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.size();
      } else {
        return serviceAccountsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder setServiceAccounts(int index, com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder setServiceAccounts(
        int index, com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(int index, com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(
        com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(
        int index, com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addAllServiceAccounts(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ServiceAccount> values) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccounts_);
        onChanged();
      } else {
        serviceAccountsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder clearServiceAccounts() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        serviceAccountsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder removeServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.remove(index);
        onChanged();
      } else {
        serviceAccountsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder getServiceAccountsBuilder(int index) {
      return getServiceAccountsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
        int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        getServiceAccountsOrBuilderList() {
      if (serviceAccountsBuilder_ != null) {
        return serviceAccountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder addServiceAccountsBuilder() {
      return getServiceAccountsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.ServiceAccount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder addServiceAccountsBuilder(int index) {
      return getServiceAccountsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.ServiceAccount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAccount.Builder>
        getServiceAccountsBuilderList() {
      return getServiceAccountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAccount,
            com.google.cloud.compute.v1.ServiceAccount.Builder,
            com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        getServiceAccountsFieldBuilder() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ServiceAccount,
                com.google.cloud.compute.v1.ServiceAccount.Builder,
                com.google.cloud.compute.v1.ServiceAccountOrBuilder>(
                serviceAccounts_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        serviceAccounts_ = null;
      }
      return serviceAccountsBuilder_;
    }

    private com.google.cloud.compute.v1.Tags tags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Tags,
            com.google.cloud.compute.v1.Tags.Builder,
            com.google.cloud.compute.v1.TagsOrBuilder>
        tagsBuilder_;
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     *
     * @return Whether the tags field is set.
     */
    public boolean hasTags() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     *
     * @return The tags.
     */
    public com.google.cloud.compute.v1.Tags getTags() {
      if (tagsBuilder_ == null) {
        return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
      } else {
        return tagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder setTags(com.google.cloud.compute.v1.Tags value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tags_ = value;
      } else {
        tagsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder setTags(com.google.cloud.compute.v1.Tags.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        tags_ = builderForValue.build();
      } else {
        tagsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder mergeTags(com.google.cloud.compute.v1.Tags value) {
      if (tagsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && tags_ != null
            && tags_ != com.google.cloud.compute.v1.Tags.getDefaultInstance()) {
          getTagsBuilder().mergeFrom(value);
        } else {
          tags_ = value;
        }
      } else {
        tagsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder clearTags() {
      bitField0_ = (bitField0_ & ~0x00002000);
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public com.google.cloud.compute.v1.Tags.Builder getTagsBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder() {
      if (tagsBuilder_ != null) {
        return tagsBuilder_.getMessageOrBuilder();
      } else {
        return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Tags,
            com.google.cloud.compute.v1.Tags.Builder,
            com.google.cloud.compute.v1.TagsOrBuilder>
        getTagsFieldBuilder() {
      if (tagsBuilder_ == null) {
        tagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Tags,
                com.google.cloud.compute.v1.Tags.Builder,
                com.google.cloud.compute.v1.TagsOrBuilder>(
                getTags(), getParentForChildren(), isClean());
        tags_ = null;
      }
      return tagsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SourceInstanceProperties)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SourceInstanceProperties)
  private static final com.google.cloud.compute.v1.SourceInstanceProperties DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SourceInstanceProperties();
  }

  public static com.google.cloud.compute.v1.SourceInstanceProperties getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SourceInstanceProperties> PARSER =
      new com.google.protobuf.AbstractParser<SourceInstanceProperties>() {
        @java.lang.Override
        public SourceInstanceProperties parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SourceInstanceProperties> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SourceInstanceProperties> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SourceInstanceProperties getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
