/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Contain information of Nat mapping for an interface of this endpoint.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings}
 */
public final class VmEndpointNatMappingsInterfaceNatMappings
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings)
    VmEndpointNatMappingsInterfaceNatMappingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VmEndpointNatMappingsInterfaceNatMappings.newBuilder() to construct.
  private VmEndpointNatMappingsInterfaceNatMappings(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VmEndpointNatMappingsInterfaceNatMappings() {
    drainNatIpPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    natIpPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    ruleMappings_ = java.util.Collections.emptyList();
    sourceAliasIpRange_ = "";
    sourceVirtualIp_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VmEndpointNatMappingsInterfaceNatMappings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_VmEndpointNatMappingsInterfaceNatMappings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_VmEndpointNatMappingsInterfaceNatMappings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings.class,
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings.Builder.class);
  }

  private int bitField0_;
  public static final int DRAIN_NAT_IP_PORT_RANGES_FIELD_NUMBER = 395440577;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList drainNatIpPortRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
   *
   * @return A list containing the drainNatIpPortRanges.
   */
  public com.google.protobuf.ProtocolStringList getDrainNatIpPortRangesList() {
    return drainNatIpPortRanges_;
  }
  /**
   *
   *
   * <pre>
   * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
   *
   * @return The count of drainNatIpPortRanges.
   */
  public int getDrainNatIpPortRangesCount() {
    return drainNatIpPortRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
   *
   * @param index The index of the element to return.
   * @return The drainNatIpPortRanges at the given index.
   */
  public java.lang.String getDrainNatIpPortRanges(int index) {
    return drainNatIpPortRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the drainNatIpPortRanges at the given index.
   */
  public com.google.protobuf.ByteString getDrainNatIpPortRangesBytes(int index) {
    return drainNatIpPortRanges_.getByteString(index);
  }

  public static final int NAT_IP_PORT_RANGES_FIELD_NUMBER = 531830810;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList natIpPortRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string nat_ip_port_ranges = 531830810;</code>
   *
   * @return A list containing the natIpPortRanges.
   */
  public com.google.protobuf.ProtocolStringList getNatIpPortRangesList() {
    return natIpPortRanges_;
  }
  /**
   *
   *
   * <pre>
   * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string nat_ip_port_ranges = 531830810;</code>
   *
   * @return The count of natIpPortRanges.
   */
  public int getNatIpPortRangesCount() {
    return natIpPortRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string nat_ip_port_ranges = 531830810;</code>
   *
   * @param index The index of the element to return.
   * @return The natIpPortRanges at the given index.
   */
  public java.lang.String getNatIpPortRanges(int index) {
    return natIpPortRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * </pre>
   *
   * <code>repeated string nat_ip_port_ranges = 531830810;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the natIpPortRanges at the given index.
   */
  public com.google.protobuf.ByteString getNatIpPortRangesBytes(int index) {
    return natIpPortRanges_.getByteString(index);
  }

  public static final int NUM_TOTAL_DRAIN_NAT_PORTS_FIELD_NUMBER = 335532793;
  private int numTotalDrainNatPorts_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
   * </pre>
   *
   * <code>optional int32 num_total_drain_nat_ports = 335532793;</code>
   *
   * @return Whether the numTotalDrainNatPorts field is set.
   */
  @java.lang.Override
  public boolean hasNumTotalDrainNatPorts() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
   * </pre>
   *
   * <code>optional int32 num_total_drain_nat_ports = 335532793;</code>
   *
   * @return The numTotalDrainNatPorts.
   */
  @java.lang.Override
  public int getNumTotalDrainNatPorts() {
    return numTotalDrainNatPorts_;
  }

  public static final int NUM_TOTAL_NAT_PORTS_FIELD_NUMBER = 299904384;
  private int numTotalNatPorts_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
   * </pre>
   *
   * <code>optional int32 num_total_nat_ports = 299904384;</code>
   *
   * @return Whether the numTotalNatPorts field is set.
   */
  @java.lang.Override
  public boolean hasNumTotalNatPorts() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
   * </pre>
   *
   * <code>optional int32 num_total_nat_ports = 299904384;</code>
   *
   * @return The numTotalNatPorts.
   */
  @java.lang.Override
  public int getNumTotalNatPorts() {
    return numTotalNatPorts_;
  }

  public static final int RULE_MAPPINGS_FIELD_NUMBER = 486192968;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings>
      ruleMappings_;
  /**
   *
   *
   * <pre>
   * Information about mappings provided by rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings>
      getRuleMappingsList() {
    return ruleMappings_;
  }
  /**
   *
   *
   * <pre>
   * Information about mappings provided by rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder>
      getRuleMappingsOrBuilderList() {
    return ruleMappings_;
  }
  /**
   *
   *
   * <pre>
   * Information about mappings provided by rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
   * </code>
   */
  @java.lang.Override
  public int getRuleMappingsCount() {
    return ruleMappings_.size();
  }
  /**
   *
   *
   * <pre>
   * Information about mappings provided by rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
      getRuleMappings(int index) {
    return ruleMappings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Information about mappings provided by rules in this NAT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder
      getRuleMappingsOrBuilder(int index) {
    return ruleMappings_.get(index);
  }

  public static final int SOURCE_ALIAS_IP_RANGE_FIELD_NUMBER = 440340952;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceAliasIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
   * </pre>
   *
   * <code>optional string source_alias_ip_range = 440340952;</code>
   *
   * @return Whether the sourceAliasIpRange field is set.
   */
  @java.lang.Override
  public boolean hasSourceAliasIpRange() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
   * </pre>
   *
   * <code>optional string source_alias_ip_range = 440340952;</code>
   *
   * @return The sourceAliasIpRange.
   */
  @java.lang.Override
  public java.lang.String getSourceAliasIpRange() {
    java.lang.Object ref = sourceAliasIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceAliasIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
   * </pre>
   *
   * <code>optional string source_alias_ip_range = 440340952;</code>
   *
   * @return The bytes for sourceAliasIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceAliasIpRangeBytes() {
    java.lang.Object ref = sourceAliasIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceAliasIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_VIRTUAL_IP_FIELD_NUMBER = 149836159;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceVirtualIp_ = "";
  /**
   *
   *
   * <pre>
   * Primary IP of the VM for this NIC.
   * </pre>
   *
   * <code>optional string source_virtual_ip = 149836159;</code>
   *
   * @return Whether the sourceVirtualIp field is set.
   */
  @java.lang.Override
  public boolean hasSourceVirtualIp() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Primary IP of the VM for this NIC.
   * </pre>
   *
   * <code>optional string source_virtual_ip = 149836159;</code>
   *
   * @return The sourceVirtualIp.
   */
  @java.lang.Override
  public java.lang.String getSourceVirtualIp() {
    java.lang.Object ref = sourceVirtualIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceVirtualIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Primary IP of the VM for this NIC.
   * </pre>
   *
   * <code>optional string source_virtual_ip = 149836159;</code>
   *
   * @return The bytes for sourceVirtualIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceVirtualIpBytes() {
    java.lang.Object ref = sourceVirtualIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceVirtualIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 149836159, sourceVirtualIp_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(299904384, numTotalNatPorts_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(335532793, numTotalDrainNatPorts_);
    }
    for (int i = 0; i < drainNatIpPortRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 395440577, drainNatIpPortRanges_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 440340952, sourceAliasIpRange_);
    }
    for (int i = 0; i < ruleMappings_.size(); i++) {
      output.writeMessage(486192968, ruleMappings_.get(i));
    }
    for (int i = 0; i < natIpPortRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 531830810, natIpPortRanges_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(149836159, sourceVirtualIp_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(299904384, numTotalNatPorts_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(335532793, numTotalDrainNatPorts_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < drainNatIpPortRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(drainNatIpPortRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDrainNatIpPortRangesList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(440340952, sourceAliasIpRange_);
    }
    for (int i = 0; i < ruleMappings_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(486192968, ruleMappings_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < natIpPortRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(natIpPortRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getNatIpPortRangesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings other =
        (com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings) obj;

    if (!getDrainNatIpPortRangesList().equals(other.getDrainNatIpPortRangesList())) return false;
    if (!getNatIpPortRangesList().equals(other.getNatIpPortRangesList())) return false;
    if (hasNumTotalDrainNatPorts() != other.hasNumTotalDrainNatPorts()) return false;
    if (hasNumTotalDrainNatPorts()) {
      if (getNumTotalDrainNatPorts() != other.getNumTotalDrainNatPorts()) return false;
    }
    if (hasNumTotalNatPorts() != other.hasNumTotalNatPorts()) return false;
    if (hasNumTotalNatPorts()) {
      if (getNumTotalNatPorts() != other.getNumTotalNatPorts()) return false;
    }
    if (!getRuleMappingsList().equals(other.getRuleMappingsList())) return false;
    if (hasSourceAliasIpRange() != other.hasSourceAliasIpRange()) return false;
    if (hasSourceAliasIpRange()) {
      if (!getSourceAliasIpRange().equals(other.getSourceAliasIpRange())) return false;
    }
    if (hasSourceVirtualIp() != other.hasSourceVirtualIp()) return false;
    if (hasSourceVirtualIp()) {
      if (!getSourceVirtualIp().equals(other.getSourceVirtualIp())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDrainNatIpPortRangesCount() > 0) {
      hash = (37 * hash) + DRAIN_NAT_IP_PORT_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDrainNatIpPortRangesList().hashCode();
    }
    if (getNatIpPortRangesCount() > 0) {
      hash = (37 * hash) + NAT_IP_PORT_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getNatIpPortRangesList().hashCode();
    }
    if (hasNumTotalDrainNatPorts()) {
      hash = (37 * hash) + NUM_TOTAL_DRAIN_NAT_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getNumTotalDrainNatPorts();
    }
    if (hasNumTotalNatPorts()) {
      hash = (37 * hash) + NUM_TOTAL_NAT_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getNumTotalNatPorts();
    }
    if (getRuleMappingsCount() > 0) {
      hash = (37 * hash) + RULE_MAPPINGS_FIELD_NUMBER;
      hash = (53 * hash) + getRuleMappingsList().hashCode();
    }
    if (hasSourceAliasIpRange()) {
      hash = (37 * hash) + SOURCE_ALIAS_IP_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceAliasIpRange().hashCode();
    }
    if (hasSourceVirtualIp()) {
      hash = (37 * hash) + SOURCE_VIRTUAL_IP_FIELD_NUMBER;
      hash = (53 * hash) + getSourceVirtualIp().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contain information of Nat mapping for an interface of this endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings)
      com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VmEndpointNatMappingsInterfaceNatMappings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VmEndpointNatMappingsInterfaceNatMappings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings.class,
              com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      drainNatIpPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      natIpPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      numTotalDrainNatPorts_ = 0;
      numTotalNatPorts_ = 0;
      if (ruleMappingsBuilder_ == null) {
        ruleMappings_ = java.util.Collections.emptyList();
      } else {
        ruleMappings_ = null;
        ruleMappingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      sourceAliasIpRange_ = "";
      sourceVirtualIp_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VmEndpointNatMappingsInterfaceNatMappings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings build() {
      com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings buildPartial() {
      com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings result =
          new com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings result) {
      if (ruleMappingsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          ruleMappings_ = java.util.Collections.unmodifiableList(ruleMappings_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.ruleMappings_ = ruleMappings_;
      } else {
        result.ruleMappings_ = ruleMappingsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        drainNatIpPortRanges_.makeImmutable();
        result.drainNatIpPortRanges_ = drainNatIpPortRanges_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        natIpPortRanges_.makeImmutable();
        result.natIpPortRanges_ = natIpPortRanges_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.numTotalDrainNatPorts_ = numTotalDrainNatPorts_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.numTotalNatPorts_ = numTotalNatPorts_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceAliasIpRange_ = sourceAliasIpRange_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sourceVirtualIp_ = sourceVirtualIp_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings) {
        return mergeFrom(
            (com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings other) {
      if (other
          == com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
              .getDefaultInstance()) return this;
      if (!other.drainNatIpPortRanges_.isEmpty()) {
        if (drainNatIpPortRanges_.isEmpty()) {
          drainNatIpPortRanges_ = other.drainNatIpPortRanges_;
          bitField0_ |= 0x00000001;
        } else {
          ensureDrainNatIpPortRangesIsMutable();
          drainNatIpPortRanges_.addAll(other.drainNatIpPortRanges_);
        }
        onChanged();
      }
      if (!other.natIpPortRanges_.isEmpty()) {
        if (natIpPortRanges_.isEmpty()) {
          natIpPortRanges_ = other.natIpPortRanges_;
          bitField0_ |= 0x00000002;
        } else {
          ensureNatIpPortRangesIsMutable();
          natIpPortRanges_.addAll(other.natIpPortRanges_);
        }
        onChanged();
      }
      if (other.hasNumTotalDrainNatPorts()) {
        setNumTotalDrainNatPorts(other.getNumTotalDrainNatPorts());
      }
      if (other.hasNumTotalNatPorts()) {
        setNumTotalNatPorts(other.getNumTotalNatPorts());
      }
      if (ruleMappingsBuilder_ == null) {
        if (!other.ruleMappings_.isEmpty()) {
          if (ruleMappings_.isEmpty()) {
            ruleMappings_ = other.ruleMappings_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureRuleMappingsIsMutable();
            ruleMappings_.addAll(other.ruleMappings_);
          }
          onChanged();
        }
      } else {
        if (!other.ruleMappings_.isEmpty()) {
          if (ruleMappingsBuilder_.isEmpty()) {
            ruleMappingsBuilder_.dispose();
            ruleMappingsBuilder_ = null;
            ruleMappings_ = other.ruleMappings_;
            bitField0_ = (bitField0_ & ~0x00000010);
            ruleMappingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRuleMappingsFieldBuilder()
                    : null;
          } else {
            ruleMappingsBuilder_.addAllMessages(other.ruleMappings_);
          }
        }
      }
      if (other.hasSourceAliasIpRange()) {
        sourceAliasIpRange_ = other.sourceAliasIpRange_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSourceVirtualIp()) {
        sourceVirtualIp_ = other.sourceVirtualIp_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1198689274:
              {
                sourceVirtualIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1198689274
            case -1895732224:
              {
                numTotalNatPorts_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case -1895732224
            case -1610704952:
              {
                numTotalDrainNatPorts_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case -1610704952
            case -1131442678:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDrainNatIpPortRangesIsMutable();
                drainNatIpPortRanges_.add(s);
                break;
              } // case -1131442678
            case -772239678:
              {
                sourceAliasIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -772239678
            case -405423550:
              {
                com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                    m =
                        input.readMessage(
                            com.google.cloud.compute.v1
                                .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings.parser(),
                            extensionRegistry);
                if (ruleMappingsBuilder_ == null) {
                  ensureRuleMappingsIsMutable();
                  ruleMappings_.add(m);
                } else {
                  ruleMappingsBuilder_.addMessage(m);
                }
                break;
              } // case -405423550
            case -40320814:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNatIpPortRangesIsMutable();
                natIpPortRanges_.add(s);
                break;
              } // case -40320814
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList drainNatIpPortRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDrainNatIpPortRangesIsMutable() {
      if (!drainNatIpPortRanges_.isModifiable()) {
        drainNatIpPortRanges_ = new com.google.protobuf.LazyStringArrayList(drainNatIpPortRanges_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @return A list containing the drainNatIpPortRanges.
     */
    public com.google.protobuf.ProtocolStringList getDrainNatIpPortRangesList() {
      drainNatIpPortRanges_.makeImmutable();
      return drainNatIpPortRanges_;
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @return The count of drainNatIpPortRanges.
     */
    public int getDrainNatIpPortRangesCount() {
      return drainNatIpPortRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @param index The index of the element to return.
     * @return The drainNatIpPortRanges at the given index.
     */
    public java.lang.String getDrainNatIpPortRanges(int index) {
      return drainNatIpPortRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the drainNatIpPortRanges at the given index.
     */
    public com.google.protobuf.ByteString getDrainNatIpPortRangesBytes(int index) {
      return drainNatIpPortRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @param index The index to set the value at.
     * @param value The drainNatIpPortRanges to set.
     * @return This builder for chaining.
     */
    public Builder setDrainNatIpPortRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainNatIpPortRangesIsMutable();
      drainNatIpPortRanges_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @param value The drainNatIpPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDrainNatIpPortRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainNatIpPortRangesIsMutable();
      drainNatIpPortRanges_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @param values The drainNatIpPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllDrainNatIpPortRanges(java.lang.Iterable<java.lang.String> values) {
      ensureDrainNatIpPortRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, drainNatIpPortRanges_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDrainNatIpPortRanges() {
      drainNatIpPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all drain IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string drain_nat_ip_port_ranges = 395440577;</code>
     *
     * @param value The bytes of the drainNatIpPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDrainNatIpPortRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDrainNatIpPortRangesIsMutable();
      drainNatIpPortRanges_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList natIpPortRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNatIpPortRangesIsMutable() {
      if (!natIpPortRanges_.isModifiable()) {
        natIpPortRanges_ = new com.google.protobuf.LazyStringArrayList(natIpPortRanges_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @return A list containing the natIpPortRanges.
     */
    public com.google.protobuf.ProtocolStringList getNatIpPortRangesList() {
      natIpPortRanges_.makeImmutable();
      return natIpPortRanges_;
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @return The count of natIpPortRanges.
     */
    public int getNatIpPortRangesCount() {
      return natIpPortRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @param index The index of the element to return.
     * @return The natIpPortRanges at the given index.
     */
    public java.lang.String getNatIpPortRanges(int index) {
      return natIpPortRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the natIpPortRanges at the given index.
     */
    public com.google.protobuf.ByteString getNatIpPortRangesBytes(int index) {
      return natIpPortRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @param index The index to set the value at.
     * @param value The natIpPortRanges to set.
     * @return This builder for chaining.
     */
    public Builder setNatIpPortRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNatIpPortRangesIsMutable();
      natIpPortRanges_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @param value The natIpPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addNatIpPortRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNatIpPortRangesIsMutable();
      natIpPortRanges_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @param values The natIpPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllNatIpPortRanges(java.lang.Iterable<java.lang.String> values) {
      ensureNatIpPortRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, natIpPortRanges_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatIpPortRanges() {
      natIpPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all IP:port-range mappings assigned to this interface. These ranges are inclusive, that is, both the first and the last ports can be used for NAT. Example: ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
     * </pre>
     *
     * <code>repeated string nat_ip_port_ranges = 531830810;</code>
     *
     * @param value The bytes of the natIpPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addNatIpPortRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNatIpPortRangesIsMutable();
      natIpPortRanges_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int numTotalDrainNatPorts_;
    /**
     *
     *
     * <pre>
     * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_drain_nat_ports = 335532793;</code>
     *
     * @return Whether the numTotalDrainNatPorts field is set.
     */
    @java.lang.Override
    public boolean hasNumTotalDrainNatPorts() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_drain_nat_ports = 335532793;</code>
     *
     * @return The numTotalDrainNatPorts.
     */
    @java.lang.Override
    public int getNumTotalDrainNatPorts() {
      return numTotalDrainNatPorts_;
    }
    /**
     *
     *
     * <pre>
     * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_drain_nat_ports = 335532793;</code>
     *
     * @param value The numTotalDrainNatPorts to set.
     * @return This builder for chaining.
     */
    public Builder setNumTotalDrainNatPorts(int value) {

      numTotalDrainNatPorts_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of drain ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field drain_nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_drain_nat_ports = 335532793;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumTotalDrainNatPorts() {
      bitField0_ = (bitField0_ & ~0x00000004);
      numTotalDrainNatPorts_ = 0;
      onChanged();
      return this;
    }

    private int numTotalNatPorts_;
    /**
     *
     *
     * <pre>
     * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_nat_ports = 299904384;</code>
     *
     * @return Whether the numTotalNatPorts field is set.
     */
    @java.lang.Override
    public boolean hasNumTotalNatPorts() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_nat_ports = 299904384;</code>
     *
     * @return The numTotalNatPorts.
     */
    @java.lang.Override
    public int getNumTotalNatPorts() {
      return numTotalNatPorts_;
    }
    /**
     *
     *
     * <pre>
     * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_nat_ports = 299904384;</code>
     *
     * @param value The numTotalNatPorts to set.
     * @return This builder for chaining.
     */
    public Builder setNumTotalNatPorts(int value) {

      numTotalNatPorts_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of ports across all NAT IPs allocated to this interface. It equals to the aggregated port number in the field nat_ip_port_ranges.
     * </pre>
     *
     * <code>optional int32 num_total_nat_ports = 299904384;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumTotalNatPorts() {
      bitField0_ = (bitField0_ & ~0x00000008);
      numTotalNatPorts_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings>
        ruleMappings_ = java.util.Collections.emptyList();

    private void ensureRuleMappingsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        ruleMappings_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1
                    .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings>(ruleMappings_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings,
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                .Builder,
            com.google.cloud.compute.v1
                .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder>
        ruleMappingsBuilder_;

    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings>
        getRuleMappingsList() {
      if (ruleMappingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ruleMappings_);
      } else {
        return ruleMappingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public int getRuleMappingsCount() {
      if (ruleMappingsBuilder_ == null) {
        return ruleMappings_.size();
      } else {
        return ruleMappingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
        getRuleMappings(int index) {
      if (ruleMappingsBuilder_ == null) {
        return ruleMappings_.get(index);
      } else {
        return ruleMappingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder setRuleMappings(
        int index,
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
            value) {
      if (ruleMappingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleMappingsIsMutable();
        ruleMappings_.set(index, value);
        onChanged();
      } else {
        ruleMappingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder setRuleMappings(
        int index,
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings.Builder
            builderForValue) {
      if (ruleMappingsBuilder_ == null) {
        ensureRuleMappingsIsMutable();
        ruleMappings_.set(index, builderForValue.build());
        onChanged();
      } else {
        ruleMappingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder addRuleMappings(
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
            value) {
      if (ruleMappingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleMappingsIsMutable();
        ruleMappings_.add(value);
        onChanged();
      } else {
        ruleMappingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder addRuleMappings(
        int index,
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
            value) {
      if (ruleMappingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleMappingsIsMutable();
        ruleMappings_.add(index, value);
        onChanged();
      } else {
        ruleMappingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder addRuleMappings(
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings.Builder
            builderForValue) {
      if (ruleMappingsBuilder_ == null) {
        ensureRuleMappingsIsMutable();
        ruleMappings_.add(builderForValue.build());
        onChanged();
      } else {
        ruleMappingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder addRuleMappings(
        int index,
        com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings.Builder
            builderForValue) {
      if (ruleMappingsBuilder_ == null) {
        ensureRuleMappingsIsMutable();
        ruleMappings_.add(index, builderForValue.build());
        onChanged();
      } else {
        ruleMappingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder addAllRuleMappings(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings>
            values) {
      if (ruleMappingsBuilder_ == null) {
        ensureRuleMappingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ruleMappings_);
        onChanged();
      } else {
        ruleMappingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder clearRuleMappings() {
      if (ruleMappingsBuilder_ == null) {
        ruleMappings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        ruleMappingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public Builder removeRuleMappings(int index) {
      if (ruleMappingsBuilder_ == null) {
        ensureRuleMappingsIsMutable();
        ruleMappings_.remove(index);
        onChanged();
      } else {
        ruleMappingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
            .Builder
        getRuleMappingsBuilder(int index) {
      return getRuleMappingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public com.google.cloud.compute.v1
            .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder
        getRuleMappingsOrBuilder(int index) {
      if (ruleMappingsBuilder_ == null) {
        return ruleMappings_.get(index);
      } else {
        return ruleMappingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder>
        getRuleMappingsOrBuilderList() {
      if (ruleMappingsBuilder_ != null) {
        return ruleMappingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ruleMappings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
            .Builder
        addRuleMappingsBuilder() {
      return getRuleMappingsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
            .Builder
        addRuleMappingsBuilder(int index) {
      return getRuleMappingsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information about mappings provided by rules in this NAT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings rule_mappings = 486192968;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                .Builder>
        getRuleMappingsBuilderList() {
      return getRuleMappingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings,
            com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                .Builder,
            com.google.cloud.compute.v1
                .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder>
        getRuleMappingsFieldBuilder() {
      if (ruleMappingsBuilder_ == null) {
        ruleMappingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1
                    .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings,
                com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings
                    .Builder,
                com.google.cloud.compute.v1
                    .VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappingsOrBuilder>(
                ruleMappings_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        ruleMappings_ = null;
      }
      return ruleMappingsBuilder_;
    }

    private java.lang.Object sourceAliasIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
     * </pre>
     *
     * <code>optional string source_alias_ip_range = 440340952;</code>
     *
     * @return Whether the sourceAliasIpRange field is set.
     */
    public boolean hasSourceAliasIpRange() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
     * </pre>
     *
     * <code>optional string source_alias_ip_range = 440340952;</code>
     *
     * @return The sourceAliasIpRange.
     */
    public java.lang.String getSourceAliasIpRange() {
      java.lang.Object ref = sourceAliasIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceAliasIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
     * </pre>
     *
     * <code>optional string source_alias_ip_range = 440340952;</code>
     *
     * @return The bytes for sourceAliasIpRange.
     */
    public com.google.protobuf.ByteString getSourceAliasIpRangeBytes() {
      java.lang.Object ref = sourceAliasIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceAliasIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
     * </pre>
     *
     * <code>optional string source_alias_ip_range = 440340952;</code>
     *
     * @param value The sourceAliasIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setSourceAliasIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceAliasIpRange_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
     * </pre>
     *
     * <code>optional string source_alias_ip_range = 440340952;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceAliasIpRange() {
      sourceAliasIpRange_ = getDefaultInstance().getSourceAliasIpRange();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alias IP range for this interface endpoint. It will be a private (RFC 1918) IP range. Examples: "10.33.4.55/32", or "192.168.5.0/24".
     * </pre>
     *
     * <code>optional string source_alias_ip_range = 440340952;</code>
     *
     * @param value The bytes for sourceAliasIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setSourceAliasIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceAliasIpRange_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object sourceVirtualIp_ = "";
    /**
     *
     *
     * <pre>
     * Primary IP of the VM for this NIC.
     * </pre>
     *
     * <code>optional string source_virtual_ip = 149836159;</code>
     *
     * @return Whether the sourceVirtualIp field is set.
     */
    public boolean hasSourceVirtualIp() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Primary IP of the VM for this NIC.
     * </pre>
     *
     * <code>optional string source_virtual_ip = 149836159;</code>
     *
     * @return The sourceVirtualIp.
     */
    public java.lang.String getSourceVirtualIp() {
      java.lang.Object ref = sourceVirtualIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceVirtualIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Primary IP of the VM for this NIC.
     * </pre>
     *
     * <code>optional string source_virtual_ip = 149836159;</code>
     *
     * @return The bytes for sourceVirtualIp.
     */
    public com.google.protobuf.ByteString getSourceVirtualIpBytes() {
      java.lang.Object ref = sourceVirtualIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceVirtualIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Primary IP of the VM for this NIC.
     * </pre>
     *
     * <code>optional string source_virtual_ip = 149836159;</code>
     *
     * @param value The sourceVirtualIp to set.
     * @return This builder for chaining.
     */
    public Builder setSourceVirtualIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceVirtualIp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Primary IP of the VM for this NIC.
     * </pre>
     *
     * <code>optional string source_virtual_ip = 149836159;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceVirtualIp() {
      sourceVirtualIp_ = getDefaultInstance().getSourceVirtualIp();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Primary IP of the VM for this NIC.
     * </pre>
     *
     * <code>optional string source_virtual_ip = 149836159;</code>
     *
     * @param value The bytes for sourceVirtualIp to set.
     * @return This builder for chaining.
     */
    public Builder setSourceVirtualIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceVirtualIp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings)
  private static final com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings();
  }

  public static com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VmEndpointNatMappingsInterfaceNatMappings>
      PARSER =
          new com.google.protobuf.AbstractParser<VmEndpointNatMappingsInterfaceNatMappings>() {
            @java.lang.Override
            public VmEndpointNatMappingsInterfaceNatMappings parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<VmEndpointNatMappingsInterfaceNatMappings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VmEndpointNatMappingsInterfaceNatMappings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.VmEndpointNatMappingsInterfaceNatMappings
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
