/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 *
 * Messages
 *
 * Contains the configurations necessary to generate a signature for access to private storage buckets that support Signature Version 4 for authentication. The service name for generating the authentication header will always default to 's3'.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AWSV4Signature}
 */
public final class AWSV4Signature extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AWSV4Signature)
    AWSV4SignatureOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AWSV4Signature.newBuilder() to construct.
  private AWSV4Signature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AWSV4Signature() {
    accessKey_ = "";
    accessKeyId_ = "";
    accessKeyVersion_ = "";
    originRegion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AWSV4Signature();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AWSV4Signature_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AWSV4Signature_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AWSV4Signature.class,
            com.google.cloud.compute.v1.AWSV4Signature.Builder.class);
  }

  private int bitField0_;
  public static final int ACCESS_KEY_FIELD_NUMBER = 468922628;

  @SuppressWarnings("serial")
  private volatile java.lang.Object accessKey_ = "";
  /**
   *
   *
   * <pre>
   * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
   * </pre>
   *
   * <code>optional string access_key = 468922628;</code>
   *
   * @return Whether the accessKey field is set.
   */
  @java.lang.Override
  public boolean hasAccessKey() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
   * </pre>
   *
   * <code>optional string access_key = 468922628;</code>
   *
   * @return The accessKey.
   */
  @java.lang.Override
  public java.lang.String getAccessKey() {
    java.lang.Object ref = accessKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      accessKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
   * </pre>
   *
   * <code>optional string access_key = 468922628;</code>
   *
   * @return The bytes for accessKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAccessKeyBytes() {
    java.lang.Object ref = accessKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      accessKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCESS_KEY_ID_FIELD_NUMBER = 292975158;

  @SuppressWarnings("serial")
  private volatile java.lang.Object accessKeyId_ = "";
  /**
   *
   *
   * <pre>
   * The identifier of an access key used for s3 bucket authentication.
   * </pre>
   *
   * <code>optional string access_key_id = 292975158;</code>
   *
   * @return Whether the accessKeyId field is set.
   */
  @java.lang.Override
  public boolean hasAccessKeyId() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The identifier of an access key used for s3 bucket authentication.
   * </pre>
   *
   * <code>optional string access_key_id = 292975158;</code>
   *
   * @return The accessKeyId.
   */
  @java.lang.Override
  public java.lang.String getAccessKeyId() {
    java.lang.Object ref = accessKeyId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      accessKeyId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier of an access key used for s3 bucket authentication.
   * </pre>
   *
   * <code>optional string access_key_id = 292975158;</code>
   *
   * @return The bytes for accessKeyId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAccessKeyIdBytes() {
    java.lang.Object ref = accessKeyId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      accessKeyId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCESS_KEY_VERSION_FIELD_NUMBER = 80261277;

  @SuppressWarnings("serial")
  private volatile java.lang.Object accessKeyVersion_ = "";
  /**
   *
   *
   * <pre>
   * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
   * </pre>
   *
   * <code>optional string access_key_version = 80261277;</code>
   *
   * @return Whether the accessKeyVersion field is set.
   */
  @java.lang.Override
  public boolean hasAccessKeyVersion() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
   * </pre>
   *
   * <code>optional string access_key_version = 80261277;</code>
   *
   * @return The accessKeyVersion.
   */
  @java.lang.Override
  public java.lang.String getAccessKeyVersion() {
    java.lang.Object ref = accessKeyVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      accessKeyVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
   * </pre>
   *
   * <code>optional string access_key_version = 80261277;</code>
   *
   * @return The bytes for accessKeyVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAccessKeyVersionBytes() {
    java.lang.Object ref = accessKeyVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      accessKeyVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORIGIN_REGION_FIELD_NUMBER = 265305645;

  @SuppressWarnings("serial")
  private volatile java.lang.Object originRegion_ = "";
  /**
   *
   *
   * <pre>
   * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
   * </pre>
   *
   * <code>optional string origin_region = 265305645;</code>
   *
   * @return Whether the originRegion field is set.
   */
  @java.lang.Override
  public boolean hasOriginRegion() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
   * </pre>
   *
   * <code>optional string origin_region = 265305645;</code>
   *
   * @return The originRegion.
   */
  @java.lang.Override
  public java.lang.String getOriginRegion() {
    java.lang.Object ref = originRegion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      originRegion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
   * </pre>
   *
   * <code>optional string origin_region = 265305645;</code>
   *
   * @return The bytes for originRegion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOriginRegionBytes() {
    java.lang.Object ref = originRegion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      originRegion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 80261277, accessKeyVersion_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 265305645, originRegion_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 292975158, accessKeyId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 468922628, accessKey_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(80261277, accessKeyVersion_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(265305645, originRegion_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(292975158, accessKeyId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(468922628, accessKey_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AWSV4Signature)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AWSV4Signature other =
        (com.google.cloud.compute.v1.AWSV4Signature) obj;

    if (hasAccessKey() != other.hasAccessKey()) return false;
    if (hasAccessKey()) {
      if (!getAccessKey().equals(other.getAccessKey())) return false;
    }
    if (hasAccessKeyId() != other.hasAccessKeyId()) return false;
    if (hasAccessKeyId()) {
      if (!getAccessKeyId().equals(other.getAccessKeyId())) return false;
    }
    if (hasAccessKeyVersion() != other.hasAccessKeyVersion()) return false;
    if (hasAccessKeyVersion()) {
      if (!getAccessKeyVersion().equals(other.getAccessKeyVersion())) return false;
    }
    if (hasOriginRegion() != other.hasOriginRegion()) return false;
    if (hasOriginRegion()) {
      if (!getOriginRegion().equals(other.getOriginRegion())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAccessKey()) {
      hash = (37 * hash) + ACCESS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getAccessKey().hashCode();
    }
    if (hasAccessKeyId()) {
      hash = (37 * hash) + ACCESS_KEY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAccessKeyId().hashCode();
    }
    if (hasAccessKeyVersion()) {
      hash = (37 * hash) + ACCESS_KEY_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getAccessKeyVersion().hashCode();
    }
    if (hasOriginRegion()) {
      hash = (37 * hash) + ORIGIN_REGION_FIELD_NUMBER;
      hash = (53 * hash) + getOriginRegion().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AWSV4Signature parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.AWSV4Signature prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   *
   * Messages
   *
   * Contains the configurations necessary to generate a signature for access to private storage buckets that support Signature Version 4 for authentication. The service name for generating the authentication header will always default to 's3'.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AWSV4Signature}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AWSV4Signature)
      com.google.cloud.compute.v1.AWSV4SignatureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AWSV4Signature_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AWSV4Signature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AWSV4Signature.class,
              com.google.cloud.compute.v1.AWSV4Signature.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AWSV4Signature.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      accessKey_ = "";
      accessKeyId_ = "";
      accessKeyVersion_ = "";
      originRegion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AWSV4Signature_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AWSV4Signature getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AWSV4Signature.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AWSV4Signature build() {
      com.google.cloud.compute.v1.AWSV4Signature result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AWSV4Signature buildPartial() {
      com.google.cloud.compute.v1.AWSV4Signature result =
          new com.google.cloud.compute.v1.AWSV4Signature(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.AWSV4Signature result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.accessKey_ = accessKey_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.accessKeyId_ = accessKeyId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.accessKeyVersion_ = accessKeyVersion_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.originRegion_ = originRegion_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AWSV4Signature) {
        return mergeFrom((com.google.cloud.compute.v1.AWSV4Signature) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AWSV4Signature other) {
      if (other == com.google.cloud.compute.v1.AWSV4Signature.getDefaultInstance()) return this;
      if (other.hasAccessKey()) {
        accessKey_ = other.accessKey_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAccessKeyId()) {
        accessKeyId_ = other.accessKeyId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAccessKeyVersion()) {
        accessKeyVersion_ = other.accessKeyVersion_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasOriginRegion()) {
        originRegion_ = other.originRegion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 642090218:
              {
                accessKeyVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 642090218
            case 2122445162:
              {
                originRegion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 2122445162
            case -1951166030:
              {
                accessKeyId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1951166030
            case -543586270:
              {
                accessKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -543586270
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object accessKey_ = "";
    /**
     *
     *
     * <pre>
     * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
     * </pre>
     *
     * <code>optional string access_key = 468922628;</code>
     *
     * @return Whether the accessKey field is set.
     */
    public boolean hasAccessKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
     * </pre>
     *
     * <code>optional string access_key = 468922628;</code>
     *
     * @return The accessKey.
     */
    public java.lang.String getAccessKey() {
      java.lang.Object ref = accessKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accessKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
     * </pre>
     *
     * <code>optional string access_key = 468922628;</code>
     *
     * @return The bytes for accessKey.
     */
    public com.google.protobuf.ByteString getAccessKeyBytes() {
      java.lang.Object ref = accessKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accessKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
     * </pre>
     *
     * <code>optional string access_key = 468922628;</code>
     *
     * @param value The accessKey to set.
     * @return This builder for chaining.
     */
    public Builder setAccessKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      accessKey_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
     * </pre>
     *
     * <code>optional string access_key = 468922628;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessKey() {
      accessKey_ = getDefaultInstance().getAccessKey();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. &#64;InputOnly
     * </pre>
     *
     * <code>optional string access_key = 468922628;</code>
     *
     * @param value The bytes for accessKey to set.
     * @return This builder for chaining.
     */
    public Builder setAccessKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      accessKey_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object accessKeyId_ = "";
    /**
     *
     *
     * <pre>
     * The identifier of an access key used for s3 bucket authentication.
     * </pre>
     *
     * <code>optional string access_key_id = 292975158;</code>
     *
     * @return Whether the accessKeyId field is set.
     */
    public boolean hasAccessKeyId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The identifier of an access key used for s3 bucket authentication.
     * </pre>
     *
     * <code>optional string access_key_id = 292975158;</code>
     *
     * @return The accessKeyId.
     */
    public java.lang.String getAccessKeyId() {
      java.lang.Object ref = accessKeyId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accessKeyId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of an access key used for s3 bucket authentication.
     * </pre>
     *
     * <code>optional string access_key_id = 292975158;</code>
     *
     * @return The bytes for accessKeyId.
     */
    public com.google.protobuf.ByteString getAccessKeyIdBytes() {
      java.lang.Object ref = accessKeyId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accessKeyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of an access key used for s3 bucket authentication.
     * </pre>
     *
     * <code>optional string access_key_id = 292975158;</code>
     *
     * @param value The accessKeyId to set.
     * @return This builder for chaining.
     */
    public Builder setAccessKeyId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      accessKeyId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of an access key used for s3 bucket authentication.
     * </pre>
     *
     * <code>optional string access_key_id = 292975158;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessKeyId() {
      accessKeyId_ = getDefaultInstance().getAccessKeyId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of an access key used for s3 bucket authentication.
     * </pre>
     *
     * <code>optional string access_key_id = 292975158;</code>
     *
     * @param value The bytes for accessKeyId to set.
     * @return This builder for chaining.
     */
    public Builder setAccessKeyIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      accessKeyId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object accessKeyVersion_ = "";
    /**
     *
     *
     * <pre>
     * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
     * </pre>
     *
     * <code>optional string access_key_version = 80261277;</code>
     *
     * @return Whether the accessKeyVersion field is set.
     */
    public boolean hasAccessKeyVersion() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
     * </pre>
     *
     * <code>optional string access_key_version = 80261277;</code>
     *
     * @return The accessKeyVersion.
     */
    public java.lang.String getAccessKeyVersion() {
      java.lang.Object ref = accessKeyVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accessKeyVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
     * </pre>
     *
     * <code>optional string access_key_version = 80261277;</code>
     *
     * @return The bytes for accessKeyVersion.
     */
    public com.google.protobuf.ByteString getAccessKeyVersionBytes() {
      java.lang.Object ref = accessKeyVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accessKeyVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
     * </pre>
     *
     * <code>optional string access_key_version = 80261277;</code>
     *
     * @param value The accessKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAccessKeyVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      accessKeyVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
     * </pre>
     *
     * <code>optional string access_key_version = 80261277;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessKeyVersion() {
      accessKeyVersion_ = getDefaultInstance().getAccessKeyVersion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
     * </pre>
     *
     * <code>optional string access_key_version = 80261277;</code>
     *
     * @param value The bytes for accessKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAccessKeyVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      accessKeyVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object originRegion_ = "";
    /**
     *
     *
     * <pre>
     * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
     * </pre>
     *
     * <code>optional string origin_region = 265305645;</code>
     *
     * @return Whether the originRegion field is set.
     */
    public boolean hasOriginRegion() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
     * </pre>
     *
     * <code>optional string origin_region = 265305645;</code>
     *
     * @return The originRegion.
     */
    public java.lang.String getOriginRegion() {
      java.lang.Object ref = originRegion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        originRegion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
     * </pre>
     *
     * <code>optional string origin_region = 265305645;</code>
     *
     * @return The bytes for originRegion.
     */
    public com.google.protobuf.ByteString getOriginRegionBytes() {
      java.lang.Object ref = originRegion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        originRegion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
     * </pre>
     *
     * <code>optional string origin_region = 265305645;</code>
     *
     * @param value The originRegion to set.
     * @return This builder for chaining.
     */
    public Builder setOriginRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      originRegion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
     * </pre>
     *
     * <code>optional string origin_region = 265305645;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOriginRegion() {
      originRegion_ = getDefaultInstance().getOriginRegion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
     * </pre>
     *
     * <code>optional string origin_region = 265305645;</code>
     *
     * @param value The bytes for originRegion to set.
     * @return This builder for chaining.
     */
    public Builder setOriginRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      originRegion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AWSV4Signature)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AWSV4Signature)
  private static final com.google.cloud.compute.v1.AWSV4Signature DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AWSV4Signature();
  }

  public static com.google.cloud.compute.v1.AWSV4Signature getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AWSV4Signature> PARSER =
      new com.google.protobuf.AbstractParser<AWSV4Signature>() {
        @java.lang.Override
        public AWSV4Signature parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AWSV4Signature> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AWSV4Signature> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AWSV4Signature getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
