/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Cloud Storage Bucket resource. This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BackendBucket}
 */
public final class BackendBucket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BackendBucket)
    BackendBucketOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackendBucket.newBuilder() to construct.
  private BackendBucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackendBucket() {
    bucketName_ = "";
    compressionMode_ = "";
    creationTimestamp_ = "";
    customResponseHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
    description_ = "";
    edgeSecurityPolicy_ = "";
    kind_ = "";
    name_ = "";
    selfLink_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackendBucket();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendBucket_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendBucket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BackendBucket.class,
            com.google.cloud.compute.v1.BackendBucket.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BackendBucket.CompressionMode}
   */
  public enum CompressionMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_COMPRESSION_MODE = 0;</code>
     */
    UNDEFINED_COMPRESSION_MODE(0),
    /**
     *
     *
     * <pre>
     * Automatically uses the best compression based on the Accept-Encoding header sent by the client.
     * </pre>
     *
     * <code>AUTOMATIC = 165298699;</code>
     */
    AUTOMATIC(165298699),
    /**
     *
     *
     * <pre>
     * Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
     * </pre>
     *
     * <code>DISABLED = 516696700;</code>
     */
    DISABLED(516696700),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_COMPRESSION_MODE = 0;</code>
     */
    public static final int UNDEFINED_COMPRESSION_MODE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Automatically uses the best compression based on the Accept-Encoding header sent by the client.
     * </pre>
     *
     * <code>AUTOMATIC = 165298699;</code>
     */
    public static final int AUTOMATIC_VALUE = 165298699;
    /**
     *
     *
     * <pre>
     * Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
     * </pre>
     *
     * <code>DISABLED = 516696700;</code>
     */
    public static final int DISABLED_VALUE = 516696700;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CompressionMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CompressionMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_COMPRESSION_MODE;
        case 165298699:
          return AUTOMATIC;
        case 516696700:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CompressionMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CompressionMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CompressionMode>() {
              public CompressionMode findValueByNumber(int number) {
                return CompressionMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendBucket.getDescriptor().getEnumTypes().get(0);
    }

    private static final CompressionMode[] VALUES = values();

    public static CompressionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CompressionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendBucket.CompressionMode)
  }

  private int bitField0_;
  public static final int BUCKET_NAME_FIELD_NUMBER = 283610048;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucketName_ = "";
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket name.
   * </pre>
   *
   * <code>optional string bucket_name = 283610048;</code>
   *
   * @return Whether the bucketName field is set.
   */
  @java.lang.Override
  public boolean hasBucketName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket name.
   * </pre>
   *
   * <code>optional string bucket_name = 283610048;</code>
   *
   * @return The bucketName.
   */
  @java.lang.Override
  public java.lang.String getBucketName() {
    java.lang.Object ref = bucketName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucketName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket name.
   * </pre>
   *
   * <code>optional string bucket_name = 283610048;</code>
   *
   * @return The bytes for bucketName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketNameBytes() {
    java.lang.Object ref = bucketName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucketName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CDN_POLICY_FIELD_NUMBER = 213976452;
  private com.google.cloud.compute.v1.BackendBucketCdnPolicy cdnPolicy_;
  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendBucket.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
   *
   * @return Whether the cdnPolicy field is set.
   */
  @java.lang.Override
  public boolean hasCdnPolicy() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendBucket.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
   *
   * @return The cdnPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendBucketCdnPolicy getCdnPolicy() {
    return cdnPolicy_ == null
        ? com.google.cloud.compute.v1.BackendBucketCdnPolicy.getDefaultInstance()
        : cdnPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendBucket.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendBucketCdnPolicyOrBuilder getCdnPolicyOrBuilder() {
    return cdnPolicy_ == null
        ? com.google.cloud.compute.v1.BackendBucketCdnPolicy.getDefaultInstance()
        : cdnPolicy_;
  }

  public static final int COMPRESSION_MODE_FIELD_NUMBER = 95520988;

  @SuppressWarnings("serial")
  private volatile java.lang.Object compressionMode_ = "";
  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return Whether the compressionMode field is set.
   */
  @java.lang.Override
  public boolean hasCompressionMode() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return The compressionMode.
   */
  @java.lang.Override
  public java.lang.String getCompressionMode() {
    java.lang.Object ref = compressionMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      compressionMode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return The bytes for compressionMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCompressionModeBytes() {
    java.lang.Object ref = compressionMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      compressionMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_RESPONSE_HEADERS_FIELD_NUMBER = 387539094;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList customResponseHeaders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Headers that the Application Load Balancer should add to proxied responses.
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @return A list containing the customResponseHeaders.
   */
  public com.google.protobuf.ProtocolStringList getCustomResponseHeadersList() {
    return customResponseHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Headers that the Application Load Balancer should add to proxied responses.
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @return The count of customResponseHeaders.
   */
  public int getCustomResponseHeadersCount() {
    return customResponseHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Headers that the Application Load Balancer should add to proxied responses.
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @param index The index of the element to return.
   * @return The customResponseHeaders at the given index.
   */
  public java.lang.String getCustomResponseHeaders(int index) {
    return customResponseHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Headers that the Application Load Balancer should add to proxied responses.
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customResponseHeaders at the given index.
   */
  public com.google.protobuf.ByteString getCustomResponseHeadersBytes(int index) {
    return customResponseHeaders_.getByteString(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional textual description of the resource; provided by the client when the resource is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional textual description of the resource; provided by the client when the resource is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional textual description of the resource; provided by the client when the resource is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EDGE_SECURITY_POLICY_FIELD_NUMBER = 41036943;

  @SuppressWarnings("serial")
  private volatile java.lang.Object edgeSecurityPolicy_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return Whether the edgeSecurityPolicy field is set.
   */
  @java.lang.Override
  public boolean hasEdgeSecurityPolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return The edgeSecurityPolicy.
   */
  @java.lang.Override
  public java.lang.String getEdgeSecurityPolicy() {
    java.lang.Object ref = edgeSecurityPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      edgeSecurityPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return The bytes for edgeSecurityPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEdgeSecurityPolicyBytes() {
    java.lang.Object ref = edgeSecurityPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      edgeSecurityPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_CDN_FIELD_NUMBER = 282942321;
  private boolean enableCdn_ = false;
  /**
   *
   *
   * <pre>
   * If true, enable Cloud CDN for this BackendBucket.
   * </pre>
   *
   * <code>optional bool enable_cdn = 282942321;</code>
   *
   * @return Whether the enableCdn field is set.
   */
  @java.lang.Override
  public boolean hasEnableCdn() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, enable Cloud CDN for this BackendBucket.
   * </pre>
   *
   * <code>optional bool enable_cdn = 282942321;</code>
   *
   * @return The enableCdn.
   */
  @java.lang.Override
  public boolean getEnableCdn() {
    return enableCdn_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] Unique identifier for the resource; defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Unique identifier for the resource; defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * Type of the resource.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Type of the resource.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of the resource.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 41036943, edgeSecurityPolicy_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 95520988, compressionMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(213976452, getCdnPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeBool(282942321, enableCdn_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 283610048, bucketName_);
    }
    for (int i = 0; i < customResponseHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 387539094, customResponseHeaders_.getRaw(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(41036943, edgeSecurityPolicy_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(95520988, compressionMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(213976452, getCdnPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(282942321, enableCdn_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(283610048, bucketName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < customResponseHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(customResponseHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getCustomResponseHeadersList().size();
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BackendBucket)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BackendBucket other =
        (com.google.cloud.compute.v1.BackendBucket) obj;

    if (hasBucketName() != other.hasBucketName()) return false;
    if (hasBucketName()) {
      if (!getBucketName().equals(other.getBucketName())) return false;
    }
    if (hasCdnPolicy() != other.hasCdnPolicy()) return false;
    if (hasCdnPolicy()) {
      if (!getCdnPolicy().equals(other.getCdnPolicy())) return false;
    }
    if (hasCompressionMode() != other.hasCompressionMode()) return false;
    if (hasCompressionMode()) {
      if (!getCompressionMode().equals(other.getCompressionMode())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (!getCustomResponseHeadersList().equals(other.getCustomResponseHeadersList())) return false;
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEdgeSecurityPolicy() != other.hasEdgeSecurityPolicy()) return false;
    if (hasEdgeSecurityPolicy()) {
      if (!getEdgeSecurityPolicy().equals(other.getEdgeSecurityPolicy())) return false;
    }
    if (hasEnableCdn() != other.hasEnableCdn()) return false;
    if (hasEnableCdn()) {
      if (getEnableCdn() != other.getEnableCdn()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBucketName()) {
      hash = (37 * hash) + BUCKET_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getBucketName().hashCode();
    }
    if (hasCdnPolicy()) {
      hash = (37 * hash) + CDN_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getCdnPolicy().hashCode();
    }
    if (hasCompressionMode()) {
      hash = (37 * hash) + COMPRESSION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getCompressionMode().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (getCustomResponseHeadersCount() > 0) {
      hash = (37 * hash) + CUSTOM_RESPONSE_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomResponseHeadersList().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEdgeSecurityPolicy()) {
      hash = (37 * hash) + EDGE_SECURITY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getEdgeSecurityPolicy().hashCode();
    }
    if (hasEnableCdn()) {
      hash = (37 * hash) + ENABLE_CDN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableCdn());
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendBucket parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.BackendBucket prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Cloud Storage Bucket resource. This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BackendBucket}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BackendBucket)
      com.google.cloud.compute.v1.BackendBucketOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendBucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendBucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BackendBucket.class,
              com.google.cloud.compute.v1.BackendBucket.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BackendBucket.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCdnPolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bucketName_ = "";
      cdnPolicy_ = null;
      if (cdnPolicyBuilder_ != null) {
        cdnPolicyBuilder_.dispose();
        cdnPolicyBuilder_ = null;
      }
      compressionMode_ = "";
      creationTimestamp_ = "";
      customResponseHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      description_ = "";
      edgeSecurityPolicy_ = "";
      enableCdn_ = false;
      id_ = 0L;
      kind_ = "";
      name_ = "";
      selfLink_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendBucket_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendBucket getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BackendBucket.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendBucket build() {
      com.google.cloud.compute.v1.BackendBucket result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendBucket buildPartial() {
      com.google.cloud.compute.v1.BackendBucket result =
          new com.google.cloud.compute.v1.BackendBucket(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.BackendBucket result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bucketName_ = bucketName_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cdnPolicy_ = cdnPolicyBuilder_ == null ? cdnPolicy_ : cdnPolicyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.compressionMode_ = compressionMode_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        customResponseHeaders_.makeImmutable();
        result.customResponseHeaders_ = customResponseHeaders_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.edgeSecurityPolicy_ = edgeSecurityPolicy_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enableCdn_ = enableCdn_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BackendBucket) {
        return mergeFrom((com.google.cloud.compute.v1.BackendBucket) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BackendBucket other) {
      if (other == com.google.cloud.compute.v1.BackendBucket.getDefaultInstance()) return this;
      if (other.hasBucketName()) {
        bucketName_ = other.bucketName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCdnPolicy()) {
        mergeCdnPolicy(other.getCdnPolicy());
      }
      if (other.hasCompressionMode()) {
        compressionMode_ = other.compressionMode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.customResponseHeaders_.isEmpty()) {
        if (customResponseHeaders_.isEmpty()) {
          customResponseHeaders_ = other.customResponseHeaders_;
          bitField0_ |= 0x00000010;
        } else {
          ensureCustomResponseHeadersIsMutable();
          customResponseHeaders_.addAll(other.customResponseHeaders_);
        }
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasEdgeSecurityPolicy()) {
        edgeSecurityPolicy_ = other.edgeSecurityPolicy_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasEnableCdn()) {
        setEnableCdn(other.getEnableCdn());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 244202930
            case 328295546:
              {
                edgeSecurityPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 328295546
            case 764167906:
              {
                compressionMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 764167906
            case 1711811618:
              {
                input.readMessage(getCdnPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 1711811618
            case -2031428728:
              {
                enableCdn_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case -2031428728
            case -2026086910:
              {
                bucketName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -2026086910
            case -1194654542:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCustomResponseHeadersIsMutable();
                customResponseHeaders_.add(s);
                break;
              } // case -1194654542
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -645248918
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bucketName_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket name.
     * </pre>
     *
     * <code>optional string bucket_name = 283610048;</code>
     *
     * @return Whether the bucketName field is set.
     */
    public boolean hasBucketName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket name.
     * </pre>
     *
     * <code>optional string bucket_name = 283610048;</code>
     *
     * @return The bucketName.
     */
    public java.lang.String getBucketName() {
      java.lang.Object ref = bucketName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket name.
     * </pre>
     *
     * <code>optional string bucket_name = 283610048;</code>
     *
     * @return The bytes for bucketName.
     */
    public com.google.protobuf.ByteString getBucketNameBytes() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket name.
     * </pre>
     *
     * <code>optional string bucket_name = 283610048;</code>
     *
     * @param value The bucketName to set.
     * @return This builder for chaining.
     */
    public Builder setBucketName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucketName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket name.
     * </pre>
     *
     * <code>optional string bucket_name = 283610048;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketName() {
      bucketName_ = getDefaultInstance().getBucketName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket name.
     * </pre>
     *
     * <code>optional string bucket_name = 283610048;</code>
     *
     * @param value The bytes for bucketName to set.
     * @return This builder for chaining.
     */
    public Builder setBucketNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucketName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BackendBucketCdnPolicy cdnPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendBucketCdnPolicy,
            com.google.cloud.compute.v1.BackendBucketCdnPolicy.Builder,
            com.google.cloud.compute.v1.BackendBucketCdnPolicyOrBuilder>
        cdnPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     *
     * @return Whether the cdnPolicy field is set.
     */
    public boolean hasCdnPolicy() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     *
     * @return The cdnPolicy.
     */
    public com.google.cloud.compute.v1.BackendBucketCdnPolicy getCdnPolicy() {
      if (cdnPolicyBuilder_ == null) {
        return cdnPolicy_ == null
            ? com.google.cloud.compute.v1.BackendBucketCdnPolicy.getDefaultInstance()
            : cdnPolicy_;
      } else {
        return cdnPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    public Builder setCdnPolicy(com.google.cloud.compute.v1.BackendBucketCdnPolicy value) {
      if (cdnPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cdnPolicy_ = value;
      } else {
        cdnPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    public Builder setCdnPolicy(
        com.google.cloud.compute.v1.BackendBucketCdnPolicy.Builder builderForValue) {
      if (cdnPolicyBuilder_ == null) {
        cdnPolicy_ = builderForValue.build();
      } else {
        cdnPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    public Builder mergeCdnPolicy(com.google.cloud.compute.v1.BackendBucketCdnPolicy value) {
      if (cdnPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && cdnPolicy_ != null
            && cdnPolicy_
                != com.google.cloud.compute.v1.BackendBucketCdnPolicy.getDefaultInstance()) {
          getCdnPolicyBuilder().mergeFrom(value);
        } else {
          cdnPolicy_ = value;
        }
      } else {
        cdnPolicyBuilder_.mergeFrom(value);
      }
      if (cdnPolicy_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    public Builder clearCdnPolicy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      cdnPolicy_ = null;
      if (cdnPolicyBuilder_ != null) {
        cdnPolicyBuilder_.dispose();
        cdnPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    public com.google.cloud.compute.v1.BackendBucketCdnPolicy.Builder getCdnPolicyBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCdnPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    public com.google.cloud.compute.v1.BackendBucketCdnPolicyOrBuilder getCdnPolicyOrBuilder() {
      if (cdnPolicyBuilder_ != null) {
        return cdnPolicyBuilder_.getMessageOrBuilder();
      } else {
        return cdnPolicy_ == null
            ? com.google.cloud.compute.v1.BackendBucketCdnPolicy.getDefaultInstance()
            : cdnPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendBucket.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendBucketCdnPolicy cdn_policy = 213976452;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendBucketCdnPolicy,
            com.google.cloud.compute.v1.BackendBucketCdnPolicy.Builder,
            com.google.cloud.compute.v1.BackendBucketCdnPolicyOrBuilder>
        getCdnPolicyFieldBuilder() {
      if (cdnPolicyBuilder_ == null) {
        cdnPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendBucketCdnPolicy,
                com.google.cloud.compute.v1.BackendBucketCdnPolicy.Builder,
                com.google.cloud.compute.v1.BackendBucketCdnPolicyOrBuilder>(
                getCdnPolicy(), getParentForChildren(), isClean());
        cdnPolicy_ = null;
      }
      return cdnPolicyBuilder_;
    }

    private java.lang.Object compressionMode_ = "";
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return Whether the compressionMode field is set.
     */
    public boolean hasCompressionMode() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return The compressionMode.
     */
    public java.lang.String getCompressionMode() {
      java.lang.Object ref = compressionMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        compressionMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return The bytes for compressionMode.
     */
    public com.google.protobuf.ByteString getCompressionModeBytes() {
      java.lang.Object ref = compressionMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        compressionMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @param value The compressionMode to set.
     * @return This builder for chaining.
     */
    public Builder setCompressionMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      compressionMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompressionMode() {
      compressionMode_ = getDefaultInstance().getCompressionMode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @param value The bytes for compressionMode to set.
     * @return This builder for chaining.
     */
    public Builder setCompressionModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      compressionMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList customResponseHeaders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCustomResponseHeadersIsMutable() {
      if (!customResponseHeaders_.isModifiable()) {
        customResponseHeaders_ =
            new com.google.protobuf.LazyStringArrayList(customResponseHeaders_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @return A list containing the customResponseHeaders.
     */
    public com.google.protobuf.ProtocolStringList getCustomResponseHeadersList() {
      customResponseHeaders_.makeImmutable();
      return customResponseHeaders_;
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @return The count of customResponseHeaders.
     */
    public int getCustomResponseHeadersCount() {
      return customResponseHeaders_.size();
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param index The index of the element to return.
     * @return The customResponseHeaders at the given index.
     */
    public java.lang.String getCustomResponseHeaders(int index) {
      return customResponseHeaders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customResponseHeaders at the given index.
     */
    public com.google.protobuf.ByteString getCustomResponseHeadersBytes(int index) {
      return customResponseHeaders_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param index The index to set the value at.
     * @param value The customResponseHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setCustomResponseHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomResponseHeadersIsMutable();
      customResponseHeaders_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param value The customResponseHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addCustomResponseHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomResponseHeadersIsMutable();
      customResponseHeaders_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param values The customResponseHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllCustomResponseHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureCustomResponseHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customResponseHeaders_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomResponseHeaders() {
      customResponseHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the Application Load Balancer should add to proxied responses.
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param value The bytes of the customResponseHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addCustomResponseHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCustomResponseHeadersIsMutable();
      customResponseHeaders_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object edgeSecurityPolicy_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return Whether the edgeSecurityPolicy field is set.
     */
    public boolean hasEdgeSecurityPolicy() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return The edgeSecurityPolicy.
     */
    public java.lang.String getEdgeSecurityPolicy() {
      java.lang.Object ref = edgeSecurityPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        edgeSecurityPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return The bytes for edgeSecurityPolicy.
     */
    public com.google.protobuf.ByteString getEdgeSecurityPolicyBytes() {
      java.lang.Object ref = edgeSecurityPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        edgeSecurityPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @param value The edgeSecurityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setEdgeSecurityPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      edgeSecurityPolicy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEdgeSecurityPolicy() {
      edgeSecurityPolicy_ = getDefaultInstance().getEdgeSecurityPolicy();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend bucket.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @param value The bytes for edgeSecurityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setEdgeSecurityPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      edgeSecurityPolicy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean enableCdn_;
    /**
     *
     *
     * <pre>
     * If true, enable Cloud CDN for this BackendBucket.
     * </pre>
     *
     * <code>optional bool enable_cdn = 282942321;</code>
     *
     * @return Whether the enableCdn field is set.
     */
    @java.lang.Override
    public boolean hasEnableCdn() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, enable Cloud CDN for this BackendBucket.
     * </pre>
     *
     * <code>optional bool enable_cdn = 282942321;</code>
     *
     * @return The enableCdn.
     */
    @java.lang.Override
    public boolean getEnableCdn() {
      return enableCdn_;
    }
    /**
     *
     *
     * <pre>
     * If true, enable Cloud CDN for this BackendBucket.
     * </pre>
     *
     * <code>optional bool enable_cdn = 282942321;</code>
     *
     * @param value The enableCdn to set.
     * @return This builder for chaining.
     */
    public Builder setEnableCdn(boolean value) {

      enableCdn_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, enable Cloud CDN for this BackendBucket.
     * </pre>
     *
     * <code>optional bool enable_cdn = 282942321;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableCdn() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enableCdn_ = false;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] Unique identifier for the resource; defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Unique identifier for the resource; defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Unique identifier for the resource; defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Unique identifier for the resource; defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000100);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BackendBucket)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BackendBucket)
  private static final com.google.cloud.compute.v1.BackendBucket DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BackendBucket();
  }

  public static com.google.cloud.compute.v1.BackendBucket getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackendBucket> PARSER =
      new com.google.protobuf.AbstractParser<BackendBucket>() {
        @java.lang.Override
        public BackendBucket parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackendBucket> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackendBucket> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BackendBucket getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
