/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BfdPacket}
 */
public final class BfdPacket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BfdPacket)
    BfdPacketOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BfdPacket.newBuilder() to construct.
  private BfdPacket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BfdPacket() {
    diagnostic_ = "";
    state_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BfdPacket();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BfdPacket_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BfdPacket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BfdPacket.class,
            com.google.cloud.compute.v1.BfdPacket.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BfdPacket.Diagnostic}
   */
  public enum Diagnostic implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIAGNOSTIC = 0;</code>
     */
    UNDEFINED_DIAGNOSTIC(0),
    /** <code>ADMINISTRATIVELY_DOWN = 121685798;</code> */
    ADMINISTRATIVELY_DOWN(121685798),
    /** <code>CONCATENATED_PATH_DOWN = 26186892;</code> */
    CONCATENATED_PATH_DOWN(26186892),
    /** <code>CONTROL_DETECTION_TIME_EXPIRED = 135478383;</code> */
    CONTROL_DETECTION_TIME_EXPIRED(135478383),
    /** <code>DIAGNOSTIC_UNSPECIFIED = 58720895;</code> */
    DIAGNOSTIC_UNSPECIFIED(58720895),
    /** <code>ECHO_FUNCTION_FAILED = 220687466;</code> */
    ECHO_FUNCTION_FAILED(220687466),
    /** <code>FORWARDING_PLANE_RESET = 19715882;</code> */
    FORWARDING_PLANE_RESET(19715882),
    /** <code>NEIGHBOR_SIGNALED_SESSION_DOWN = 374226742;</code> */
    NEIGHBOR_SIGNALED_SESSION_DOWN(374226742),
    /** <code>NO_DIAGNOSTIC = 222503141;</code> */
    NO_DIAGNOSTIC(222503141),
    /** <code>PATH_DOWN = 290605180;</code> */
    PATH_DOWN(290605180),
    /** <code>REVERSE_CONCATENATED_PATH_DOWN = 479337129;</code> */
    REVERSE_CONCATENATED_PATH_DOWN(479337129),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIAGNOSTIC = 0;</code>
     */
    public static final int UNDEFINED_DIAGNOSTIC_VALUE = 0;
    /** <code>ADMINISTRATIVELY_DOWN = 121685798;</code> */
    public static final int ADMINISTRATIVELY_DOWN_VALUE = 121685798;
    /** <code>CONCATENATED_PATH_DOWN = 26186892;</code> */
    public static final int CONCATENATED_PATH_DOWN_VALUE = 26186892;
    /** <code>CONTROL_DETECTION_TIME_EXPIRED = 135478383;</code> */
    public static final int CONTROL_DETECTION_TIME_EXPIRED_VALUE = 135478383;
    /** <code>DIAGNOSTIC_UNSPECIFIED = 58720895;</code> */
    public static final int DIAGNOSTIC_UNSPECIFIED_VALUE = 58720895;
    /** <code>ECHO_FUNCTION_FAILED = 220687466;</code> */
    public static final int ECHO_FUNCTION_FAILED_VALUE = 220687466;
    /** <code>FORWARDING_PLANE_RESET = 19715882;</code> */
    public static final int FORWARDING_PLANE_RESET_VALUE = 19715882;
    /** <code>NEIGHBOR_SIGNALED_SESSION_DOWN = 374226742;</code> */
    public static final int NEIGHBOR_SIGNALED_SESSION_DOWN_VALUE = 374226742;
    /** <code>NO_DIAGNOSTIC = 222503141;</code> */
    public static final int NO_DIAGNOSTIC_VALUE = 222503141;
    /** <code>PATH_DOWN = 290605180;</code> */
    public static final int PATH_DOWN_VALUE = 290605180;
    /** <code>REVERSE_CONCATENATED_PATH_DOWN = 479337129;</code> */
    public static final int REVERSE_CONCATENATED_PATH_DOWN_VALUE = 479337129;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Diagnostic valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Diagnostic forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DIAGNOSTIC;
        case 121685798:
          return ADMINISTRATIVELY_DOWN;
        case 26186892:
          return CONCATENATED_PATH_DOWN;
        case 135478383:
          return CONTROL_DETECTION_TIME_EXPIRED;
        case 58720895:
          return DIAGNOSTIC_UNSPECIFIED;
        case 220687466:
          return ECHO_FUNCTION_FAILED;
        case 19715882:
          return FORWARDING_PLANE_RESET;
        case 374226742:
          return NEIGHBOR_SIGNALED_SESSION_DOWN;
        case 222503141:
          return NO_DIAGNOSTIC;
        case 290605180:
          return PATH_DOWN;
        case 479337129:
          return REVERSE_CONCATENATED_PATH_DOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Diagnostic> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Diagnostic> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Diagnostic>() {
          public Diagnostic findValueByNumber(int number) {
            return Diagnostic.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BfdPacket.getDescriptor().getEnumTypes().get(0);
    }

    private static final Diagnostic[] VALUES = values();

    public static Diagnostic valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Diagnostic(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BfdPacket.Diagnostic)
  }

  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BfdPacket.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    UNDEFINED_STATE(0),
    /** <code>ADMIN_DOWN = 128544690;</code> */
    ADMIN_DOWN(128544690),
    /** <code>DOWN = 2104482;</code> */
    DOWN(2104482),
    /** <code>INIT = 2252048;</code> */
    INIT(2252048),
    /** <code>STATE_UNSPECIFIED = 470755401;</code> */
    STATE_UNSPECIFIED(470755401),
    /** <code>UP = 2715;</code> */
    UP(2715),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    public static final int UNDEFINED_STATE_VALUE = 0;
    /** <code>ADMIN_DOWN = 128544690;</code> */
    public static final int ADMIN_DOWN_VALUE = 128544690;
    /** <code>DOWN = 2104482;</code> */
    public static final int DOWN_VALUE = 2104482;
    /** <code>INIT = 2252048;</code> */
    public static final int INIT_VALUE = 2252048;
    /** <code>STATE_UNSPECIFIED = 470755401;</code> */
    public static final int STATE_UNSPECIFIED_VALUE = 470755401;
    /** <code>UP = 2715;</code> */
    public static final int UP_VALUE = 2715;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATE;
        case 128544690:
          return ADMIN_DOWN;
        case 2104482:
          return DOWN;
        case 2252048:
          return INIT;
        case 470755401:
          return STATE_UNSPECIFIED;
        case 2715:
          return UP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BfdPacket.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BfdPacket.State)
  }

  private int bitField0_;
  public static final int AUTHENTICATION_PRESENT_FIELD_NUMBER = 105974260;
  private boolean authenticationPresent_ = false;
  /**
   *
   *
   * <pre>
   * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool authentication_present = 105974260;</code>
   *
   * @return Whether the authenticationPresent field is set.
   */
  @java.lang.Override
  public boolean hasAuthenticationPresent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool authentication_present = 105974260;</code>
   *
   * @return The authenticationPresent.
   */
  @java.lang.Override
  public boolean getAuthenticationPresent() {
    return authenticationPresent_;
  }

  public static final int CONTROL_PLANE_INDEPENDENT_FIELD_NUMBER = 62363573;
  private boolean controlPlaneIndependent_ = false;
  /**
   *
   *
   * <pre>
   * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool control_plane_independent = 62363573;</code>
   *
   * @return Whether the controlPlaneIndependent field is set.
   */
  @java.lang.Override
  public boolean hasControlPlaneIndependent() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool control_plane_independent = 62363573;</code>
   *
   * @return The controlPlaneIndependent.
   */
  @java.lang.Override
  public boolean getControlPlaneIndependent() {
    return controlPlaneIndependent_;
  }

  public static final int DEMAND_FIELD_NUMBER = 275180107;
  private boolean demand_ = false;
  /**
   *
   *
   * <pre>
   * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool demand = 275180107;</code>
   *
   * @return Whether the demand field is set.
   */
  @java.lang.Override
  public boolean hasDemand() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool demand = 275180107;</code>
   *
   * @return The demand.
   */
  @java.lang.Override
  public boolean getDemand() {
    return demand_;
  }

  public static final int DIAGNOSTIC_FIELD_NUMBER = 62708647;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diagnostic_ = "";
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the Diagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string diagnostic = 62708647;</code>
   *
   * @return Whether the diagnostic field is set.
   */
  @java.lang.Override
  public boolean hasDiagnostic() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the Diagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string diagnostic = 62708647;</code>
   *
   * @return The diagnostic.
   */
  @java.lang.Override
  public java.lang.String getDiagnostic() {
    java.lang.Object ref = diagnostic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diagnostic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the Diagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string diagnostic = 62708647;</code>
   *
   * @return The bytes for diagnostic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiagnosticBytes() {
    java.lang.Object ref = diagnostic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diagnostic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINAL_FIELD_NUMBER = 97436022;
  private boolean final_ = false;
  /**
   *
   *
   * <pre>
   * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool final = 97436022;</code>
   *
   * @return Whether the final field is set.
   */
  @java.lang.Override
  public boolean hasFinal() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool final = 97436022;</code>
   *
   * @return The final.
   */
  @java.lang.Override
  public boolean getFinal() {
    return final_;
  }

  public static final int LENGTH_FIELD_NUMBER = 504249062;
  private int length_ = 0;
  /**
   *
   *
   * <pre>
   * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 length = 504249062;</code>
   *
   * @return Whether the length field is set.
   */
  @java.lang.Override
  public boolean hasLength() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 length = 504249062;</code>
   *
   * @return The length.
   */
  @java.lang.Override
  public int getLength() {
    return length_;
  }

  public static final int MIN_ECHO_RX_INTERVAL_MS_FIELD_NUMBER = 97286868;
  private int minEchoRxIntervalMs_ = 0;
  /**
   *
   *
   * <pre>
   * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 min_echo_rx_interval_ms = 97286868;</code>
   *
   * @return Whether the minEchoRxIntervalMs field is set.
   */
  @java.lang.Override
  public boolean hasMinEchoRxIntervalMs() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 min_echo_rx_interval_ms = 97286868;</code>
   *
   * @return The minEchoRxIntervalMs.
   */
  @java.lang.Override
  public int getMinEchoRxIntervalMs() {
    return minEchoRxIntervalMs_;
  }

  public static final int MIN_RX_INTERVAL_MS_FIELD_NUMBER = 463399028;
  private int minRxIntervalMs_ = 0;
  /**
   *
   *
   * <pre>
   * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 min_rx_interval_ms = 463399028;</code>
   *
   * @return Whether the minRxIntervalMs field is set.
   */
  @java.lang.Override
  public boolean hasMinRxIntervalMs() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 min_rx_interval_ms = 463399028;</code>
   *
   * @return The minRxIntervalMs.
   */
  @java.lang.Override
  public int getMinRxIntervalMs() {
    return minRxIntervalMs_;
  }

  public static final int MIN_TX_INTERVAL_MS_FIELD_NUMBER = 526023602;
  private int minTxIntervalMs_ = 0;
  /**
   *
   *
   * <pre>
   * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 min_tx_interval_ms = 526023602;</code>
   *
   * @return Whether the minTxIntervalMs field is set.
   */
  @java.lang.Override
  public boolean hasMinTxIntervalMs() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 min_tx_interval_ms = 526023602;</code>
   *
   * @return The minTxIntervalMs.
   */
  @java.lang.Override
  public int getMinTxIntervalMs() {
    return minTxIntervalMs_;
  }

  public static final int MULTIPLIER_FIELD_NUMBER = 191331777;
  private int multiplier_ = 0;
  /**
   *
   *
   * <pre>
   * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 multiplier = 191331777;</code>
   *
   * @return Whether the multiplier field is set.
   */
  @java.lang.Override
  public boolean hasMultiplier() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 multiplier = 191331777;</code>
   *
   * @return The multiplier.
   */
  @java.lang.Override
  public int getMultiplier() {
    return multiplier_;
  }

  public static final int MULTIPOINT_FIELD_NUMBER = 191421431;
  private boolean multipoint_ = false;
  /**
   *
   *
   * <pre>
   * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool multipoint = 191421431;</code>
   *
   * @return Whether the multipoint field is set.
   */
  @java.lang.Override
  public boolean hasMultipoint() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool multipoint = 191421431;</code>
   *
   * @return The multipoint.
   */
  @java.lang.Override
  public boolean getMultipoint() {
    return multipoint_;
  }

  public static final int MY_DISCRIMINATOR_FIELD_NUMBER = 76663113;
  private int myDiscriminator_ = 0;
  /**
   *
   *
   * <pre>
   * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 my_discriminator = 76663113;</code>
   *
   * @return Whether the myDiscriminator field is set.
   */
  @java.lang.Override
  public boolean hasMyDiscriminator() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 my_discriminator = 76663113;</code>
   *
   * @return The myDiscriminator.
   */
  @java.lang.Override
  public int getMyDiscriminator() {
    return myDiscriminator_;
  }

  public static final int POLL_FIELD_NUMBER = 3446719;
  private boolean poll_ = false;
  /**
   *
   *
   * <pre>
   * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool poll = 3446719;</code>
   *
   * @return Whether the poll field is set.
   */
  @java.lang.Override
  public boolean hasPoll() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional bool poll = 3446719;</code>
   *
   * @return The poll.
   */
  @java.lang.Override
  public boolean getPoll() {
    return poll_;
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 351608024;
  private int version_ = 0;
  /**
   *
   *
   * <pre>
   * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
   * </pre>
   *
   * <code>optional uint32 version = 351608024;</code>
   *
   * @return Whether the version field is set.
   */
  @java.lang.Override
  public boolean hasVersion() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
   * </pre>
   *
   * <code>optional uint32 version = 351608024;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public int getVersion() {
    return version_;
  }

  public static final int YOUR_DISCRIMINATOR_FIELD_NUMBER = 515634064;
  private int yourDiscriminator_ = 0;
  /**
   *
   *
   * <pre>
   * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 your_discriminator = 515634064;</code>
   *
   * @return Whether the yourDiscriminator field is set.
   */
  @java.lang.Override
  public boolean hasYourDiscriminator() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * </pre>
   *
   * <code>optional uint32 your_discriminator = 515634064;</code>
   *
   * @return The yourDiscriminator.
   */
  @java.lang.Override
  public int getYourDiscriminator() {
    return yourDiscriminator_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeBool(3446719, poll_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(62363573, controlPlaneIndependent_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 62708647, diagnostic_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeUInt32(76663113, myDiscriminator_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt32(97286868, minEchoRxIntervalMs_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(97436022, final_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(105974260, authenticationPresent_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeUInt32(191331777, multiplier_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(191421431, multipoint_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(275180107, demand_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeUInt32(351608024, version_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeUInt32(463399028, minRxIntervalMs_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt32(504249062, length_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeUInt32(515634064, yourDiscriminator_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeUInt32(526023602, minTxIntervalMs_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3446719, poll_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(62363573, controlPlaneIndependent_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(62708647, diagnostic_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(76663113, myDiscriminator_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(97286868, minEchoRxIntervalMs_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(97436022, final_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(105974260, authenticationPresent_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(191331777, multiplier_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(191421431, multipoint_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(275180107, demand_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(351608024, version_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(463399028, minRxIntervalMs_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(504249062, length_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(515634064, yourDiscriminator_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(526023602, minTxIntervalMs_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BfdPacket)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BfdPacket other = (com.google.cloud.compute.v1.BfdPacket) obj;

    if (hasAuthenticationPresent() != other.hasAuthenticationPresent()) return false;
    if (hasAuthenticationPresent()) {
      if (getAuthenticationPresent() != other.getAuthenticationPresent()) return false;
    }
    if (hasControlPlaneIndependent() != other.hasControlPlaneIndependent()) return false;
    if (hasControlPlaneIndependent()) {
      if (getControlPlaneIndependent() != other.getControlPlaneIndependent()) return false;
    }
    if (hasDemand() != other.hasDemand()) return false;
    if (hasDemand()) {
      if (getDemand() != other.getDemand()) return false;
    }
    if (hasDiagnostic() != other.hasDiagnostic()) return false;
    if (hasDiagnostic()) {
      if (!getDiagnostic().equals(other.getDiagnostic())) return false;
    }
    if (hasFinal() != other.hasFinal()) return false;
    if (hasFinal()) {
      if (getFinal() != other.getFinal()) return false;
    }
    if (hasLength() != other.hasLength()) return false;
    if (hasLength()) {
      if (getLength() != other.getLength()) return false;
    }
    if (hasMinEchoRxIntervalMs() != other.hasMinEchoRxIntervalMs()) return false;
    if (hasMinEchoRxIntervalMs()) {
      if (getMinEchoRxIntervalMs() != other.getMinEchoRxIntervalMs()) return false;
    }
    if (hasMinRxIntervalMs() != other.hasMinRxIntervalMs()) return false;
    if (hasMinRxIntervalMs()) {
      if (getMinRxIntervalMs() != other.getMinRxIntervalMs()) return false;
    }
    if (hasMinTxIntervalMs() != other.hasMinTxIntervalMs()) return false;
    if (hasMinTxIntervalMs()) {
      if (getMinTxIntervalMs() != other.getMinTxIntervalMs()) return false;
    }
    if (hasMultiplier() != other.hasMultiplier()) return false;
    if (hasMultiplier()) {
      if (getMultiplier() != other.getMultiplier()) return false;
    }
    if (hasMultipoint() != other.hasMultipoint()) return false;
    if (hasMultipoint()) {
      if (getMultipoint() != other.getMultipoint()) return false;
    }
    if (hasMyDiscriminator() != other.hasMyDiscriminator()) return false;
    if (hasMyDiscriminator()) {
      if (getMyDiscriminator() != other.getMyDiscriminator()) return false;
    }
    if (hasPoll() != other.hasPoll()) return false;
    if (hasPoll()) {
      if (getPoll() != other.getPoll()) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (hasVersion() != other.hasVersion()) return false;
    if (hasVersion()) {
      if (getVersion() != other.getVersion()) return false;
    }
    if (hasYourDiscriminator() != other.hasYourDiscriminator()) return false;
    if (hasYourDiscriminator()) {
      if (getYourDiscriminator() != other.getYourDiscriminator()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAuthenticationPresent()) {
      hash = (37 * hash) + AUTHENTICATION_PRESENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAuthenticationPresent());
    }
    if (hasControlPlaneIndependent()) {
      hash = (37 * hash) + CONTROL_PLANE_INDEPENDENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getControlPlaneIndependent());
    }
    if (hasDemand()) {
      hash = (37 * hash) + DEMAND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDemand());
    }
    if (hasDiagnostic()) {
      hash = (37 * hash) + DIAGNOSTIC_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnostic().hashCode();
    }
    if (hasFinal()) {
      hash = (37 * hash) + FINAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFinal());
    }
    if (hasLength()) {
      hash = (37 * hash) + LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + getLength();
    }
    if (hasMinEchoRxIntervalMs()) {
      hash = (37 * hash) + MIN_ECHO_RX_INTERVAL_MS_FIELD_NUMBER;
      hash = (53 * hash) + getMinEchoRxIntervalMs();
    }
    if (hasMinRxIntervalMs()) {
      hash = (37 * hash) + MIN_RX_INTERVAL_MS_FIELD_NUMBER;
      hash = (53 * hash) + getMinRxIntervalMs();
    }
    if (hasMinTxIntervalMs()) {
      hash = (37 * hash) + MIN_TX_INTERVAL_MS_FIELD_NUMBER;
      hash = (53 * hash) + getMinTxIntervalMs();
    }
    if (hasMultiplier()) {
      hash = (37 * hash) + MULTIPLIER_FIELD_NUMBER;
      hash = (53 * hash) + getMultiplier();
    }
    if (hasMultipoint()) {
      hash = (37 * hash) + MULTIPOINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMultipoint());
    }
    if (hasMyDiscriminator()) {
      hash = (37 * hash) + MY_DISCRIMINATOR_FIELD_NUMBER;
      hash = (53 * hash) + getMyDiscriminator();
    }
    if (hasPoll()) {
      hash = (37 * hash) + POLL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPoll());
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    if (hasVersion()) {
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion();
    }
    if (hasYourDiscriminator()) {
      hash = (37 * hash) + YOUR_DISCRIMINATOR_FIELD_NUMBER;
      hash = (53 * hash) + getYourDiscriminator();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BfdPacket parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.BfdPacket prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BfdPacket}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BfdPacket)
      com.google.cloud.compute.v1.BfdPacketOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BfdPacket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BfdPacket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BfdPacket.class,
              com.google.cloud.compute.v1.BfdPacket.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BfdPacket.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      authenticationPresent_ = false;
      controlPlaneIndependent_ = false;
      demand_ = false;
      diagnostic_ = "";
      final_ = false;
      length_ = 0;
      minEchoRxIntervalMs_ = 0;
      minRxIntervalMs_ = 0;
      minTxIntervalMs_ = 0;
      multiplier_ = 0;
      multipoint_ = false;
      myDiscriminator_ = 0;
      poll_ = false;
      state_ = "";
      version_ = 0;
      yourDiscriminator_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BfdPacket_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BfdPacket getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BfdPacket.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BfdPacket build() {
      com.google.cloud.compute.v1.BfdPacket result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BfdPacket buildPartial() {
      com.google.cloud.compute.v1.BfdPacket result =
          new com.google.cloud.compute.v1.BfdPacket(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.BfdPacket result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.authenticationPresent_ = authenticationPresent_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.controlPlaneIndependent_ = controlPlaneIndependent_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.demand_ = demand_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.diagnostic_ = diagnostic_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.final_ = final_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.length_ = length_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.minEchoRxIntervalMs_ = minEchoRxIntervalMs_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.minRxIntervalMs_ = minRxIntervalMs_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.minTxIntervalMs_ = minTxIntervalMs_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.multiplier_ = multiplier_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.multipoint_ = multipoint_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.myDiscriminator_ = myDiscriminator_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.poll_ = poll_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.version_ = version_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.yourDiscriminator_ = yourDiscriminator_;
        to_bitField0_ |= 0x00008000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BfdPacket) {
        return mergeFrom((com.google.cloud.compute.v1.BfdPacket) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BfdPacket other) {
      if (other == com.google.cloud.compute.v1.BfdPacket.getDefaultInstance()) return this;
      if (other.hasAuthenticationPresent()) {
        setAuthenticationPresent(other.getAuthenticationPresent());
      }
      if (other.hasControlPlaneIndependent()) {
        setControlPlaneIndependent(other.getControlPlaneIndependent());
      }
      if (other.hasDemand()) {
        setDemand(other.getDemand());
      }
      if (other.hasDiagnostic()) {
        diagnostic_ = other.diagnostic_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasFinal()) {
        setFinal(other.getFinal());
      }
      if (other.hasLength()) {
        setLength(other.getLength());
      }
      if (other.hasMinEchoRxIntervalMs()) {
        setMinEchoRxIntervalMs(other.getMinEchoRxIntervalMs());
      }
      if (other.hasMinRxIntervalMs()) {
        setMinRxIntervalMs(other.getMinRxIntervalMs());
      }
      if (other.hasMinTxIntervalMs()) {
        setMinTxIntervalMs(other.getMinTxIntervalMs());
      }
      if (other.hasMultiplier()) {
        setMultiplier(other.getMultiplier());
      }
      if (other.hasMultipoint()) {
        setMultipoint(other.getMultipoint());
      }
      if (other.hasMyDiscriminator()) {
        setMyDiscriminator(other.getMyDiscriminator());
      }
      if (other.hasPoll()) {
        setPoll(other.getPoll());
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasVersion()) {
        setVersion(other.getVersion());
      }
      if (other.hasYourDiscriminator()) {
        setYourDiscriminator(other.getYourDiscriminator());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 27573752:
              {
                poll_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 27573752
            case 498908584:
              {
                controlPlaneIndependent_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 498908584
            case 501669178:
              {
                diagnostic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 501669178
            case 613304904:
              {
                myDiscriminator_ = input.readUInt32();
                bitField0_ |= 0x00000800;
                break;
              } // case 613304904
            case 778294944:
              {
                minEchoRxIntervalMs_ = input.readUInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 778294944
            case 779488176:
              {
                final_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 779488176
            case 847794080:
              {
                authenticationPresent_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 847794080
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 878060682
            case 1530654216:
              {
                multiplier_ = input.readUInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 1530654216
            case 1531371448:
              {
                multipoint_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 1531371448
            case -2093526440:
              {
                demand_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -2093526440
            case -1482103104:
              {
                version_ = input.readUInt32();
                bitField0_ |= 0x00004000;
                break;
              } // case -1482103104
            case -587775072:
              {
                minRxIntervalMs_ = input.readUInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case -587775072
            case -260974800:
              {
                length_ = input.readUInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case -260974800
            case -169894784:
              {
                yourDiscriminator_ = input.readUInt32();
                bitField0_ |= 0x00008000;
                break;
              } // case -169894784
            case -86778480:
              {
                minTxIntervalMs_ = input.readUInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case -86778480
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean authenticationPresent_;
    /**
     *
     *
     * <pre>
     * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool authentication_present = 105974260;</code>
     *
     * @return Whether the authenticationPresent field is set.
     */
    @java.lang.Override
    public boolean hasAuthenticationPresent() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool authentication_present = 105974260;</code>
     *
     * @return The authenticationPresent.
     */
    @java.lang.Override
    public boolean getAuthenticationPresent() {
      return authenticationPresent_;
    }
    /**
     *
     *
     * <pre>
     * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool authentication_present = 105974260;</code>
     *
     * @param value The authenticationPresent to set.
     * @return This builder for chaining.
     */
    public Builder setAuthenticationPresent(boolean value) {

      authenticationPresent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool authentication_present = 105974260;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthenticationPresent() {
      bitField0_ = (bitField0_ & ~0x00000001);
      authenticationPresent_ = false;
      onChanged();
      return this;
    }

    private boolean controlPlaneIndependent_;
    /**
     *
     *
     * <pre>
     * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool control_plane_independent = 62363573;</code>
     *
     * @return Whether the controlPlaneIndependent field is set.
     */
    @java.lang.Override
    public boolean hasControlPlaneIndependent() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool control_plane_independent = 62363573;</code>
     *
     * @return The controlPlaneIndependent.
     */
    @java.lang.Override
    public boolean getControlPlaneIndependent() {
      return controlPlaneIndependent_;
    }
    /**
     *
     *
     * <pre>
     * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool control_plane_independent = 62363573;</code>
     *
     * @param value The controlPlaneIndependent to set.
     * @return This builder for chaining.
     */
    public Builder setControlPlaneIndependent(boolean value) {

      controlPlaneIndependent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool control_plane_independent = 62363573;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearControlPlaneIndependent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      controlPlaneIndependent_ = false;
      onChanged();
      return this;
    }

    private boolean demand_;
    /**
     *
     *
     * <pre>
     * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool demand = 275180107;</code>
     *
     * @return Whether the demand field is set.
     */
    @java.lang.Override
    public boolean hasDemand() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool demand = 275180107;</code>
     *
     * @return The demand.
     */
    @java.lang.Override
    public boolean getDemand() {
      return demand_;
    }
    /**
     *
     *
     * <pre>
     * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool demand = 275180107;</code>
     *
     * @param value The demand to set.
     * @return This builder for chaining.
     */
    public Builder setDemand(boolean value) {

      demand_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool demand = 275180107;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDemand() {
      bitField0_ = (bitField0_ & ~0x00000004);
      demand_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object diagnostic_ = "";
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the Diagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string diagnostic = 62708647;</code>
     *
     * @return Whether the diagnostic field is set.
     */
    public boolean hasDiagnostic() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the Diagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string diagnostic = 62708647;</code>
     *
     * @return The diagnostic.
     */
    public java.lang.String getDiagnostic() {
      java.lang.Object ref = diagnostic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diagnostic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the Diagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string diagnostic = 62708647;</code>
     *
     * @return The bytes for diagnostic.
     */
    public com.google.protobuf.ByteString getDiagnosticBytes() {
      java.lang.Object ref = diagnostic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diagnostic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the Diagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string diagnostic = 62708647;</code>
     *
     * @param value The diagnostic to set.
     * @return This builder for chaining.
     */
    public Builder setDiagnostic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diagnostic_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the Diagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string diagnostic = 62708647;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiagnostic() {
      diagnostic_ = getDefaultInstance().getDiagnostic();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
     * Check the Diagnostic enum for the list of possible values.
     * </pre>
     *
     * <code>optional string diagnostic = 62708647;</code>
     *
     * @param value The bytes for diagnostic to set.
     * @return This builder for chaining.
     */
    public Builder setDiagnosticBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diagnostic_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean final_;
    /**
     *
     *
     * <pre>
     * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool final = 97436022;</code>
     *
     * @return Whether the final field is set.
     */
    @java.lang.Override
    public boolean hasFinal() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool final = 97436022;</code>
     *
     * @return The final.
     */
    @java.lang.Override
    public boolean getFinal() {
      return final_;
    }
    /**
     *
     *
     * <pre>
     * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool final = 97436022;</code>
     *
     * @param value The final to set.
     * @return This builder for chaining.
     */
    public Builder setFinal(boolean value) {

      final_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool final = 97436022;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinal() {
      bitField0_ = (bitField0_ & ~0x00000010);
      final_ = false;
      onChanged();
      return this;
    }

    private int length_;
    /**
     *
     *
     * <pre>
     * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 length = 504249062;</code>
     *
     * @return Whether the length field is set.
     */
    @java.lang.Override
    public boolean hasLength() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 length = 504249062;</code>
     *
     * @return The length.
     */
    @java.lang.Override
    public int getLength() {
      return length_;
    }
    /**
     *
     *
     * <pre>
     * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 length = 504249062;</code>
     *
     * @param value The length to set.
     * @return This builder for chaining.
     */
    public Builder setLength(int value) {

      length_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 length = 504249062;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLength() {
      bitField0_ = (bitField0_ & ~0x00000020);
      length_ = 0;
      onChanged();
      return this;
    }

    private int minEchoRxIntervalMs_;
    /**
     *
     *
     * <pre>
     * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_echo_rx_interval_ms = 97286868;</code>
     *
     * @return Whether the minEchoRxIntervalMs field is set.
     */
    @java.lang.Override
    public boolean hasMinEchoRxIntervalMs() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_echo_rx_interval_ms = 97286868;</code>
     *
     * @return The minEchoRxIntervalMs.
     */
    @java.lang.Override
    public int getMinEchoRxIntervalMs() {
      return minEchoRxIntervalMs_;
    }
    /**
     *
     *
     * <pre>
     * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_echo_rx_interval_ms = 97286868;</code>
     *
     * @param value The minEchoRxIntervalMs to set.
     * @return This builder for chaining.
     */
    public Builder setMinEchoRxIntervalMs(int value) {

      minEchoRxIntervalMs_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_echo_rx_interval_ms = 97286868;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinEchoRxIntervalMs() {
      bitField0_ = (bitField0_ & ~0x00000040);
      minEchoRxIntervalMs_ = 0;
      onChanged();
      return this;
    }

    private int minRxIntervalMs_;
    /**
     *
     *
     * <pre>
     * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_rx_interval_ms = 463399028;</code>
     *
     * @return Whether the minRxIntervalMs field is set.
     */
    @java.lang.Override
    public boolean hasMinRxIntervalMs() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_rx_interval_ms = 463399028;</code>
     *
     * @return The minRxIntervalMs.
     */
    @java.lang.Override
    public int getMinRxIntervalMs() {
      return minRxIntervalMs_;
    }
    /**
     *
     *
     * <pre>
     * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_rx_interval_ms = 463399028;</code>
     *
     * @param value The minRxIntervalMs to set.
     * @return This builder for chaining.
     */
    public Builder setMinRxIntervalMs(int value) {

      minRxIntervalMs_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_rx_interval_ms = 463399028;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinRxIntervalMs() {
      bitField0_ = (bitField0_ & ~0x00000080);
      minRxIntervalMs_ = 0;
      onChanged();
      return this;
    }

    private int minTxIntervalMs_;
    /**
     *
     *
     * <pre>
     * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_tx_interval_ms = 526023602;</code>
     *
     * @return Whether the minTxIntervalMs field is set.
     */
    @java.lang.Override
    public boolean hasMinTxIntervalMs() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_tx_interval_ms = 526023602;</code>
     *
     * @return The minTxIntervalMs.
     */
    @java.lang.Override
    public int getMinTxIntervalMs() {
      return minTxIntervalMs_;
    }
    /**
     *
     *
     * <pre>
     * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_tx_interval_ms = 526023602;</code>
     *
     * @param value The minTxIntervalMs to set.
     * @return This builder for chaining.
     */
    public Builder setMinTxIntervalMs(int value) {

      minTxIntervalMs_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 min_tx_interval_ms = 526023602;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinTxIntervalMs() {
      bitField0_ = (bitField0_ & ~0x00000100);
      minTxIntervalMs_ = 0;
      onChanged();
      return this;
    }

    private int multiplier_;
    /**
     *
     *
     * <pre>
     * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @return Whether the multiplier field is set.
     */
    @java.lang.Override
    public boolean hasMultiplier() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @return The multiplier.
     */
    @java.lang.Override
    public int getMultiplier() {
      return multiplier_;
    }
    /**
     *
     *
     * <pre>
     * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @param value The multiplier to set.
     * @return This builder for chaining.
     */
    public Builder setMultiplier(int value) {

      multiplier_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 multiplier = 191331777;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiplier() {
      bitField0_ = (bitField0_ & ~0x00000200);
      multiplier_ = 0;
      onChanged();
      return this;
    }

    private boolean multipoint_;
    /**
     *
     *
     * <pre>
     * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool multipoint = 191421431;</code>
     *
     * @return Whether the multipoint field is set.
     */
    @java.lang.Override
    public boolean hasMultipoint() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool multipoint = 191421431;</code>
     *
     * @return The multipoint.
     */
    @java.lang.Override
    public boolean getMultipoint() {
      return multipoint_;
    }
    /**
     *
     *
     * <pre>
     * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool multipoint = 191421431;</code>
     *
     * @param value The multipoint to set.
     * @return This builder for chaining.
     */
    public Builder setMultipoint(boolean value) {

      multipoint_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool multipoint = 191421431;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultipoint() {
      bitField0_ = (bitField0_ & ~0x00000400);
      multipoint_ = false;
      onChanged();
      return this;
    }

    private int myDiscriminator_;
    /**
     *
     *
     * <pre>
     * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 my_discriminator = 76663113;</code>
     *
     * @return Whether the myDiscriminator field is set.
     */
    @java.lang.Override
    public boolean hasMyDiscriminator() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 my_discriminator = 76663113;</code>
     *
     * @return The myDiscriminator.
     */
    @java.lang.Override
    public int getMyDiscriminator() {
      return myDiscriminator_;
    }
    /**
     *
     *
     * <pre>
     * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 my_discriminator = 76663113;</code>
     *
     * @param value The myDiscriminator to set.
     * @return This builder for chaining.
     */
    public Builder setMyDiscriminator(int value) {

      myDiscriminator_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 my_discriminator = 76663113;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMyDiscriminator() {
      bitField0_ = (bitField0_ & ~0x00000800);
      myDiscriminator_ = 0;
      onChanged();
      return this;
    }

    private boolean poll_;
    /**
     *
     *
     * <pre>
     * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool poll = 3446719;</code>
     *
     * @return Whether the poll field is set.
     */
    @java.lang.Override
    public boolean hasPoll() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool poll = 3446719;</code>
     *
     * @return The poll.
     */
    @java.lang.Override
    public boolean getPoll() {
      return poll_;
    }
    /**
     *
     *
     * <pre>
     * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool poll = 3446719;</code>
     *
     * @param value The poll to set.
     * @return This builder for chaining.
     */
    public Builder setPoll(boolean value) {

      poll_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional bool poll = 3446719;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPoll() {
      bitField0_ = (bitField0_ & ~0x00001000);
      poll_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private int version_;
    /**
     *
     *
     * <pre>
     * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
     * </pre>
     *
     * <code>optional uint32 version = 351608024;</code>
     *
     * @return Whether the version field is set.
     */
    @java.lang.Override
    public boolean hasVersion() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
     * </pre>
     *
     * <code>optional uint32 version = 351608024;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public int getVersion() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
     * </pre>
     *
     * <code>optional uint32 version = 351608024;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(int value) {

      version_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
     * </pre>
     *
     * <code>optional uint32 version = 351608024;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00004000);
      version_ = 0;
      onChanged();
      return this;
    }

    private int yourDiscriminator_;
    /**
     *
     *
     * <pre>
     * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 your_discriminator = 515634064;</code>
     *
     * @return Whether the yourDiscriminator field is set.
     */
    @java.lang.Override
    public boolean hasYourDiscriminator() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 your_discriminator = 515634064;</code>
     *
     * @return The yourDiscriminator.
     */
    @java.lang.Override
    public int getYourDiscriminator() {
      return yourDiscriminator_;
    }
    /**
     *
     *
     * <pre>
     * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 your_discriminator = 515634064;</code>
     *
     * @param value The yourDiscriminator to set.
     * @return This builder for chaining.
     */
    public Builder setYourDiscriminator(int value) {

      yourDiscriminator_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
     * </pre>
     *
     * <code>optional uint32 your_discriminator = 515634064;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearYourDiscriminator() {
      bitField0_ = (bitField0_ & ~0x00008000);
      yourDiscriminator_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BfdPacket)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BfdPacket)
  private static final com.google.cloud.compute.v1.BfdPacket DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BfdPacket();
  }

  public static com.google.cloud.compute.v1.BfdPacket getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BfdPacket> PARSER =
      new com.google.protobuf.AbstractParser<BfdPacket>() {
        @java.lang.Override
        public BfdPacket parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BfdPacket> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BfdPacket> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BfdPacket getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
