/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A transient resource used in compute.instances.bulkInsert and compute.regionInstances.bulkInsert . This resource is not persisted anywhere, it is used only for processing the requests.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BulkInsertInstanceResource}
 */
public final class BulkInsertInstanceResource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BulkInsertInstanceResource)
    BulkInsertInstanceResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkInsertInstanceResource.newBuilder() to construct.
  private BulkInsertInstanceResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkInsertInstanceResource() {
    namePattern_ = "";
    sourceInstanceTemplate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkInsertInstanceResource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BulkInsertInstanceResource_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 108502267:
        return internalGetPerInstanceProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BulkInsertInstanceResource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BulkInsertInstanceResource.class,
            com.google.cloud.compute.v1.BulkInsertInstanceResource.Builder.class);
  }

  private int bitField0_;
  public static final int COUNT_FIELD_NUMBER = 94851343;
  private long count_ = 0L;
  /**
   *
   *
   * <pre>
   * The maximum number of instances to create.
   * </pre>
   *
   * <code>optional int64 count = 94851343;</code>
   *
   * @return Whether the count field is set.
   */
  @java.lang.Override
  public boolean hasCount() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum number of instances to create.
   * </pre>
   *
   * <code>optional int64 count = 94851343;</code>
   *
   * @return The count.
   */
  @java.lang.Override
  public long getCount() {
    return count_;
  }

  public static final int INSTANCE_PROPERTIES_FIELD_NUMBER = 215355165;
  private com.google.cloud.compute.v1.InstanceProperties instanceProperties_;
  /**
   *
   *
   * <pre>
   * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   *
   * @return Whether the instanceProperties field is set.
   */
  @java.lang.Override
  public boolean hasInstanceProperties() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   *
   * @return The instanceProperties.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceProperties getInstanceProperties() {
    return instanceProperties_ == null
        ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
        : instanceProperties_;
  }
  /**
   *
   *
   * <pre>
   * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstancePropertiesOrBuilder getInstancePropertiesOrBuilder() {
    return instanceProperties_ == null
        ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
        : instanceProperties_;
  }

  public static final int LOCATION_POLICY_FIELD_NUMBER = 465689852;
  private com.google.cloud.compute.v1.LocationPolicy locationPolicy_;
  /**
   *
   *
   * <pre>
   * Policy for chosing target zone. For more information, see Create VMs in bulk .
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
   *
   * @return Whether the locationPolicy field is set.
   */
  @java.lang.Override
  public boolean hasLocationPolicy() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Policy for chosing target zone. For more information, see Create VMs in bulk .
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
   *
   * @return The locationPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LocationPolicy getLocationPolicy() {
    return locationPolicy_ == null
        ? com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance()
        : locationPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Policy for chosing target zone. For more information, see Create VMs in bulk .
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LocationPolicyOrBuilder getLocationPolicyOrBuilder() {
    return locationPolicy_ == null
        ? com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance()
        : locationPolicy_;
  }

  public static final int MIN_COUNT_FIELD_NUMBER = 523228386;
  private long minCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
   * </pre>
   *
   * <code>optional int64 min_count = 523228386;</code>
   *
   * @return Whether the minCount field is set.
   */
  @java.lang.Override
  public boolean hasMinCount() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
   * </pre>
   *
   * <code>optional int64 min_count = 523228386;</code>
   *
   * @return The minCount.
   */
  @java.lang.Override
  public long getMinCount() {
    return minCount_;
  }

  public static final int NAME_PATTERN_FIELD_NUMBER = 413815260;

  @SuppressWarnings("serial")
  private volatile java.lang.Object namePattern_ = "";
  /**
   *
   *
   * <pre>
   * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
   * </pre>
   *
   * <code>optional string name_pattern = 413815260;</code>
   *
   * @return Whether the namePattern field is set.
   */
  @java.lang.Override
  public boolean hasNamePattern() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
   * </pre>
   *
   * <code>optional string name_pattern = 413815260;</code>
   *
   * @return The namePattern.
   */
  @java.lang.Override
  public java.lang.String getNamePattern() {
    java.lang.Object ref = namePattern_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      namePattern_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
   * </pre>
   *
   * <code>optional string name_pattern = 413815260;</code>
   *
   * @return The bytes for namePattern.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNamePatternBytes() {
    java.lang.Object ref = namePattern_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      namePattern_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PER_INSTANCE_PROPERTIES_FIELD_NUMBER = 108502267;

  private static final class PerInstancePropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_BulkInsertInstanceResource_PerInstancePropertiesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
      perInstanceProperties_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
      internalGetPerInstanceProperties() {
    if (perInstanceProperties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PerInstancePropertiesDefaultEntryHolder.defaultEntry);
    }
    return perInstanceProperties_;
  }

  public int getPerInstancePropertiesCount() {
    return internalGetPerInstanceProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
   * </code>
   */
  @java.lang.Override
  public boolean containsPerInstanceProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPerInstanceProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPerInstancePropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
      getPerInstanceProperties() {
    return getPerInstancePropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
      getPerInstancePropertiesMap() {
    return internalGetPerInstanceProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
      getPerInstancePropertiesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
              defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        map = internalGetPerInstanceProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
      getPerInstancePropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        map = internalGetPerInstanceProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SOURCE_INSTANCE_TEMPLATE_FIELD_NUMBER = 332423616;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceInstanceTemplate_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
   * </pre>
   *
   * <code>optional string source_instance_template = 332423616;</code>
   *
   * @return Whether the sourceInstanceTemplate field is set.
   */
  @java.lang.Override
  public boolean hasSourceInstanceTemplate() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
   * </pre>
   *
   * <code>optional string source_instance_template = 332423616;</code>
   *
   * @return The sourceInstanceTemplate.
   */
  @java.lang.Override
  public java.lang.String getSourceInstanceTemplate() {
    java.lang.Object ref = sourceInstanceTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceInstanceTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
   * </pre>
   *
   * <code>optional string source_instance_template = 332423616;</code>
   *
   * @return The bytes for sourceInstanceTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceInstanceTemplateBytes() {
    java.lang.Object ref = sourceInstanceTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceInstanceTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(94851343, count_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetPerInstanceProperties(),
        PerInstancePropertiesDefaultEntryHolder.defaultEntry,
        108502267);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(215355165, getInstanceProperties());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 332423616, sourceInstanceTemplate_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 413815260, namePattern_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(465689852, getLocationPolicy());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(523228386, minCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(94851343, count_);
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        entry : internalGetPerInstanceProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
          perInstanceProperties__ =
              PerInstancePropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              108502267, perInstanceProperties__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              215355165, getInstanceProperties());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              332423616, sourceInstanceTemplate_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(413815260, namePattern_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(465689852, getLocationPolicy());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(523228386, minCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BulkInsertInstanceResource)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BulkInsertInstanceResource other =
        (com.google.cloud.compute.v1.BulkInsertInstanceResource) obj;

    if (hasCount() != other.hasCount()) return false;
    if (hasCount()) {
      if (getCount() != other.getCount()) return false;
    }
    if (hasInstanceProperties() != other.hasInstanceProperties()) return false;
    if (hasInstanceProperties()) {
      if (!getInstanceProperties().equals(other.getInstanceProperties())) return false;
    }
    if (hasLocationPolicy() != other.hasLocationPolicy()) return false;
    if (hasLocationPolicy()) {
      if (!getLocationPolicy().equals(other.getLocationPolicy())) return false;
    }
    if (hasMinCount() != other.hasMinCount()) return false;
    if (hasMinCount()) {
      if (getMinCount() != other.getMinCount()) return false;
    }
    if (hasNamePattern() != other.hasNamePattern()) return false;
    if (hasNamePattern()) {
      if (!getNamePattern().equals(other.getNamePattern())) return false;
    }
    if (!internalGetPerInstanceProperties().equals(other.internalGetPerInstanceProperties()))
      return false;
    if (hasSourceInstanceTemplate() != other.hasSourceInstanceTemplate()) return false;
    if (hasSourceInstanceTemplate()) {
      if (!getSourceInstanceTemplate().equals(other.getSourceInstanceTemplate())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCount()) {
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
    }
    if (hasInstanceProperties()) {
      hash = (37 * hash) + INSTANCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceProperties().hashCode();
    }
    if (hasLocationPolicy()) {
      hash = (37 * hash) + LOCATION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getLocationPolicy().hashCode();
    }
    if (hasMinCount()) {
      hash = (37 * hash) + MIN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinCount());
    }
    if (hasNamePattern()) {
      hash = (37 * hash) + NAME_PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getNamePattern().hashCode();
    }
    if (!internalGetPerInstanceProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PER_INSTANCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPerInstanceProperties().hashCode();
    }
    if (hasSourceInstanceTemplate()) {
      hash = (37 * hash) + SOURCE_INSTANCE_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInstanceTemplate().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.BulkInsertInstanceResource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A transient resource used in compute.instances.bulkInsert and compute.regionInstances.bulkInsert . This resource is not persisted anywhere, it is used only for processing the requests.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BulkInsertInstanceResource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BulkInsertInstanceResource)
      com.google.cloud.compute.v1.BulkInsertInstanceResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BulkInsertInstanceResource_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 108502267:
          return internalGetPerInstanceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 108502267:
          return internalGetMutablePerInstanceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BulkInsertInstanceResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BulkInsertInstanceResource.class,
              com.google.cloud.compute.v1.BulkInsertInstanceResource.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BulkInsertInstanceResource.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstancePropertiesFieldBuilder();
        getLocationPolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      count_ = 0L;
      instanceProperties_ = null;
      if (instancePropertiesBuilder_ != null) {
        instancePropertiesBuilder_.dispose();
        instancePropertiesBuilder_ = null;
      }
      locationPolicy_ = null;
      if (locationPolicyBuilder_ != null) {
        locationPolicyBuilder_.dispose();
        locationPolicyBuilder_ = null;
      }
      minCount_ = 0L;
      namePattern_ = "";
      internalGetMutablePerInstanceProperties().clear();
      sourceInstanceTemplate_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BulkInsertInstanceResource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BulkInsertInstanceResource getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BulkInsertInstanceResource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BulkInsertInstanceResource build() {
      com.google.cloud.compute.v1.BulkInsertInstanceResource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BulkInsertInstanceResource buildPartial() {
      com.google.cloud.compute.v1.BulkInsertInstanceResource result =
          new com.google.cloud.compute.v1.BulkInsertInstanceResource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.BulkInsertInstanceResource result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.count_ = count_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceProperties_ =
            instancePropertiesBuilder_ == null
                ? instanceProperties_
                : instancePropertiesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.locationPolicy_ =
            locationPolicyBuilder_ == null ? locationPolicy_ : locationPolicyBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minCount_ = minCount_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.namePattern_ = namePattern_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.perInstanceProperties_ =
            internalGetPerInstanceProperties()
                .build(PerInstancePropertiesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sourceInstanceTemplate_ = sourceInstanceTemplate_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BulkInsertInstanceResource) {
        return mergeFrom((com.google.cloud.compute.v1.BulkInsertInstanceResource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BulkInsertInstanceResource other) {
      if (other == com.google.cloud.compute.v1.BulkInsertInstanceResource.getDefaultInstance())
        return this;
      if (other.hasCount()) {
        setCount(other.getCount());
      }
      if (other.hasInstanceProperties()) {
        mergeInstanceProperties(other.getInstanceProperties());
      }
      if (other.hasLocationPolicy()) {
        mergeLocationPolicy(other.getLocationPolicy());
      }
      if (other.hasMinCount()) {
        setMinCount(other.getMinCount());
      }
      if (other.hasNamePattern()) {
        namePattern_ = other.namePattern_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      internalGetMutablePerInstanceProperties().mergeFrom(other.internalGetPerInstanceProperties());
      bitField0_ |= 0x00000020;
      if (other.hasSourceInstanceTemplate()) {
        sourceInstanceTemplate_ = other.sourceInstanceTemplate_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 758810744:
              {
                count_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 758810744
            case 868018138:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
                    perInstanceProperties__ =
                        input.readMessage(
                            PerInstancePropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutablePerInstanceProperties()
                    .ensureBuilderMap()
                    .put(perInstanceProperties__.getKey(), perInstanceProperties__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 868018138
            case 1722841322:
              {
                input.readMessage(
                    getInstancePropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 1722841322
            case -1635578366:
              {
                sourceInstanceTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -1635578366
            case -984445214:
              {
                namePattern_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -984445214
            case -569448478:
              {
                input.readMessage(getLocationPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -569448478
            case -109140208:
              {
                minCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case -109140208
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long count_;
    /**
     *
     *
     * <pre>
     * The maximum number of instances to create.
     * </pre>
     *
     * <code>optional int64 count = 94851343;</code>
     *
     * @return Whether the count field is set.
     */
    @java.lang.Override
    public boolean hasCount() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances to create.
     * </pre>
     *
     * <code>optional int64 count = 94851343;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances to create.
     * </pre>
     *
     * <code>optional int64 count = 94851343;</code>
     *
     * @param value The count to set.
     * @return This builder for chaining.
     */
    public Builder setCount(long value) {

      count_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances to create.
     * </pre>
     *
     * <code>optional int64 count = 94851343;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      count_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InstanceProperties instanceProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceProperties,
            com.google.cloud.compute.v1.InstanceProperties.Builder,
            com.google.cloud.compute.v1.InstancePropertiesOrBuilder>
        instancePropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     *
     * @return Whether the instanceProperties field is set.
     */
    public boolean hasInstanceProperties() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     *
     * @return The instanceProperties.
     */
    public com.google.cloud.compute.v1.InstanceProperties getInstanceProperties() {
      if (instancePropertiesBuilder_ == null) {
        return instanceProperties_ == null
            ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
            : instanceProperties_;
      } else {
        return instancePropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder setInstanceProperties(com.google.cloud.compute.v1.InstanceProperties value) {
      if (instancePropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceProperties_ = value;
      } else {
        instancePropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder setInstanceProperties(
        com.google.cloud.compute.v1.InstanceProperties.Builder builderForValue) {
      if (instancePropertiesBuilder_ == null) {
        instanceProperties_ = builderForValue.build();
      } else {
        instancePropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder mergeInstanceProperties(com.google.cloud.compute.v1.InstanceProperties value) {
      if (instancePropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && instanceProperties_ != null
            && instanceProperties_
                != com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()) {
          getInstancePropertiesBuilder().mergeFrom(value);
        } else {
          instanceProperties_ = value;
        }
      } else {
        instancePropertiesBuilder_.mergeFrom(value);
      }
      if (instanceProperties_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public Builder clearInstanceProperties() {
      bitField0_ = (bitField0_ & ~0x00000002);
      instanceProperties_ = null;
      if (instancePropertiesBuilder_ != null) {
        instancePropertiesBuilder_.dispose();
        instancePropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceProperties.Builder getInstancePropertiesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getInstancePropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    public com.google.cloud.compute.v1.InstancePropertiesOrBuilder
        getInstancePropertiesOrBuilder() {
      if (instancePropertiesBuilder_ != null) {
        return instancePropertiesBuilder_.getMessageOrBuilder();
      } else {
        return instanceProperties_ == null
            ? com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()
            : instanceProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceProperties,
            com.google.cloud.compute.v1.InstanceProperties.Builder,
            com.google.cloud.compute.v1.InstancePropertiesOrBuilder>
        getInstancePropertiesFieldBuilder() {
      if (instancePropertiesBuilder_ == null) {
        instancePropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceProperties,
                com.google.cloud.compute.v1.InstanceProperties.Builder,
                com.google.cloud.compute.v1.InstancePropertiesOrBuilder>(
                getInstanceProperties(), getParentForChildren(), isClean());
        instanceProperties_ = null;
      }
      return instancePropertiesBuilder_;
    }

    private com.google.cloud.compute.v1.LocationPolicy locationPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.LocationPolicy,
            com.google.cloud.compute.v1.LocationPolicy.Builder,
            com.google.cloud.compute.v1.LocationPolicyOrBuilder>
        locationPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     *
     * @return Whether the locationPolicy field is set.
     */
    public boolean hasLocationPolicy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     *
     * @return The locationPolicy.
     */
    public com.google.cloud.compute.v1.LocationPolicy getLocationPolicy() {
      if (locationPolicyBuilder_ == null) {
        return locationPolicy_ == null
            ? com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance()
            : locationPolicy_;
      } else {
        return locationPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    public Builder setLocationPolicy(com.google.cloud.compute.v1.LocationPolicy value) {
      if (locationPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        locationPolicy_ = value;
      } else {
        locationPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    public Builder setLocationPolicy(
        com.google.cloud.compute.v1.LocationPolicy.Builder builderForValue) {
      if (locationPolicyBuilder_ == null) {
        locationPolicy_ = builderForValue.build();
      } else {
        locationPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    public Builder mergeLocationPolicy(com.google.cloud.compute.v1.LocationPolicy value) {
      if (locationPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && locationPolicy_ != null
            && locationPolicy_ != com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance()) {
          getLocationPolicyBuilder().mergeFrom(value);
        } else {
          locationPolicy_ = value;
        }
      } else {
        locationPolicyBuilder_.mergeFrom(value);
      }
      if (locationPolicy_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    public Builder clearLocationPolicy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      locationPolicy_ = null;
      if (locationPolicyBuilder_ != null) {
        locationPolicyBuilder_.dispose();
        locationPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    public com.google.cloud.compute.v1.LocationPolicy.Builder getLocationPolicyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getLocationPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    public com.google.cloud.compute.v1.LocationPolicyOrBuilder getLocationPolicyOrBuilder() {
      if (locationPolicyBuilder_ != null) {
        return locationPolicyBuilder_.getMessageOrBuilder();
      } else {
        return locationPolicy_ == null
            ? com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance()
            : locationPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Policy for chosing target zone. For more information, see Create VMs in bulk .
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.LocationPolicy location_policy = 465689852;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.LocationPolicy,
            com.google.cloud.compute.v1.LocationPolicy.Builder,
            com.google.cloud.compute.v1.LocationPolicyOrBuilder>
        getLocationPolicyFieldBuilder() {
      if (locationPolicyBuilder_ == null) {
        locationPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.LocationPolicy,
                com.google.cloud.compute.v1.LocationPolicy.Builder,
                com.google.cloud.compute.v1.LocationPolicyOrBuilder>(
                getLocationPolicy(), getParentForChildren(), isClean());
        locationPolicy_ = null;
      }
      return locationPolicyBuilder_;
    }

    private long minCount_;
    /**
     *
     *
     * <pre>
     * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
     * </pre>
     *
     * <code>optional int64 min_count = 523228386;</code>
     *
     * @return Whether the minCount field is set.
     */
    @java.lang.Override
    public boolean hasMinCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
     * </pre>
     *
     * <code>optional int64 min_count = 523228386;</code>
     *
     * @return The minCount.
     */
    @java.lang.Override
    public long getMinCount() {
      return minCount_;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
     * </pre>
     *
     * <code>optional int64 min_count = 523228386;</code>
     *
     * @param value The minCount to set.
     * @return This builder for chaining.
     */
    public Builder setMinCount(long value) {

      minCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
     * </pre>
     *
     * <code>optional int64 min_count = 523228386;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      minCount_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object namePattern_ = "";
    /**
     *
     *
     * <pre>
     * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
     * </pre>
     *
     * <code>optional string name_pattern = 413815260;</code>
     *
     * @return Whether the namePattern field is set.
     */
    public boolean hasNamePattern() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
     * </pre>
     *
     * <code>optional string name_pattern = 413815260;</code>
     *
     * @return The namePattern.
     */
    public java.lang.String getNamePattern() {
      java.lang.Object ref = namePattern_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namePattern_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
     * </pre>
     *
     * <code>optional string name_pattern = 413815260;</code>
     *
     * @return The bytes for namePattern.
     */
    public com.google.protobuf.ByteString getNamePatternBytes() {
      java.lang.Object ref = namePattern_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namePattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
     * </pre>
     *
     * <code>optional string name_pattern = 413815260;</code>
     *
     * @param value The namePattern to set.
     * @return This builder for chaining.
     */
    public Builder setNamePattern(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      namePattern_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
     * </pre>
     *
     * <code>optional string name_pattern = 413815260;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamePattern() {
      namePattern_ = getDefaultInstance().getNamePattern();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
     * </pre>
     *
     * <code>optional string name_pattern = 413815260;</code>
     *
     * @param value The bytes for namePattern to set.
     * @return This builder for chaining.
     */
    public Builder setNamePatternBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      namePattern_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private static final class PerInstancePropertiesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties> {
      @java.lang.Override
      public com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties build(
          com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder
              val) {
        if (val
            instanceof
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties) {
          return (com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties) val;
        }
        return ((com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
                    .Builder)
                val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
          defaultEntry() {
        return PerInstancePropertiesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final PerInstancePropertiesConverter perInstancePropertiesConverter =
        new PerInstancePropertiesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties.Builder>
        perInstanceProperties_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties.Builder>
        internalGetPerInstanceProperties() {
      if (perInstanceProperties_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(perInstancePropertiesConverter);
      }
      return perInstanceProperties_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties.Builder>
        internalGetMutablePerInstanceProperties() {
      if (perInstanceProperties_ == null) {
        perInstanceProperties_ =
            new com.google.protobuf.MapFieldBuilder<>(perInstancePropertiesConverter);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return perInstanceProperties_;
    }

    public int getPerInstancePropertiesCount() {
      return internalGetPerInstanceProperties().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    @java.lang.Override
    public boolean containsPerInstanceProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPerInstanceProperties().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getPerInstancePropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        getPerInstanceProperties() {
      return getPerInstancePropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        getPerInstancePropertiesMap() {
      return internalGetPerInstanceProperties().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1
            .BulkInsertInstanceResourcePerInstanceProperties
        getPerInstancePropertiesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder>
          map = internalGetMutablePerInstanceProperties().ensureBuilderMap();
      return map.containsKey(key)
          ? perInstancePropertiesConverter.build(map.get(key))
          : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
        getPerInstancePropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder>
          map = internalGetMutablePerInstanceProperties().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return perInstancePropertiesConverter.build(map.get(key));
    }

    public Builder clearPerInstanceProperties() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutablePerInstanceProperties().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    public Builder removePerInstanceProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePerInstanceProperties().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
        getMutablePerInstanceProperties() {
      bitField0_ |= 0x00000020;
      return internalGetMutablePerInstanceProperties().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    public Builder putPerInstanceProperties(
        java.lang.String key,
        com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePerInstanceProperties().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    public Builder putAllPerInstanceProperties(
        java.util.Map<
                java.lang.String,
                com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutablePerInstanceProperties().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties&gt; per_instance_properties = 108502267;
     * </code>
     */
    public com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties.Builder
        putPerInstancePropertiesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder>
          builderMap = internalGetMutablePerInstanceProperties().ensureBuilderMap();
      com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstancePropertiesOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry =
            com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties
                .newBuilder();
        builderMap.put(key, entry);
      }
      if (entry
          instanceof com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties) {
        entry =
            ((com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.BulkInsertInstanceResourcePerInstanceProperties.Builder)
          entry;
    }

    private java.lang.Object sourceInstanceTemplate_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
     * </pre>
     *
     * <code>optional string source_instance_template = 332423616;</code>
     *
     * @return Whether the sourceInstanceTemplate field is set.
     */
    public boolean hasSourceInstanceTemplate() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
     * </pre>
     *
     * <code>optional string source_instance_template = 332423616;</code>
     *
     * @return The sourceInstanceTemplate.
     */
    public java.lang.String getSourceInstanceTemplate() {
      java.lang.Object ref = sourceInstanceTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceInstanceTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
     * </pre>
     *
     * <code>optional string source_instance_template = 332423616;</code>
     *
     * @return The bytes for sourceInstanceTemplate.
     */
    public com.google.protobuf.ByteString getSourceInstanceTemplateBytes() {
      java.lang.Object ref = sourceInstanceTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceInstanceTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
     * </pre>
     *
     * <code>optional string source_instance_template = 332423616;</code>
     *
     * @param value The sourceInstanceTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstanceTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceInstanceTemplate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
     * </pre>
     *
     * <code>optional string source_instance_template = 332423616;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceInstanceTemplate() {
      sourceInstanceTemplate_ = getDefaultInstance().getSourceInstanceTemplate();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
     * </pre>
     *
     * <code>optional string source_instance_template = 332423616;</code>
     *
     * @param value The bytes for sourceInstanceTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstanceTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceInstanceTemplate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BulkInsertInstanceResource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BulkInsertInstanceResource)
  private static final com.google.cloud.compute.v1.BulkInsertInstanceResource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BulkInsertInstanceResource();
  }

  public static com.google.cloud.compute.v1.BulkInsertInstanceResource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkInsertInstanceResource> PARSER =
      new com.google.protobuf.AbstractParser<BulkInsertInstanceResource>() {
        @java.lang.Override
        public BulkInsertInstanceResource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkInsertInstanceResource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkInsertInstanceResource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BulkInsertInstanceResource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
