/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

public interface CustomerEncryptionKeyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.CustomerEncryptionKey)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key The fully-qualifed key name may be returned for resource GET requests. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeyVersions/1
   * </pre>
   *
   * <code>optional string kms_key_name = 484373913;</code>
   *
   * @return Whether the kmsKeyName field is set.
   */
  boolean hasKmsKeyName();
  /**
   *
   *
   * <pre>
   * The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key The fully-qualifed key name may be returned for resource GET requests. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeyVersions/1
   * </pre>
   *
   * <code>optional string kms_key_name = 484373913;</code>
   *
   * @return The kmsKeyName.
   */
  java.lang.String getKmsKeyName();
  /**
   *
   *
   * <pre>
   * The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key The fully-qualifed key name may be returned for resource GET requests. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeyVersions/1
   * </pre>
   *
   * <code>optional string kms_key_name = 484373913;</code>
   *
   * @return The bytes for kmsKeyName.
   */
  com.google.protobuf.ByteString getKmsKeyNameBytes();

  /**
   *
   *
   * <pre>
   * The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name&#64;project_id.iam.gserviceaccount.com/
   * </pre>
   *
   * <code>optional string kms_key_service_account = 209986261;</code>
   *
   * @return Whether the kmsKeyServiceAccount field is set.
   */
  boolean hasKmsKeyServiceAccount();
  /**
   *
   *
   * <pre>
   * The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name&#64;project_id.iam.gserviceaccount.com/
   * </pre>
   *
   * <code>optional string kms_key_service_account = 209986261;</code>
   *
   * @return The kmsKeyServiceAccount.
   */
  java.lang.String getKmsKeyServiceAccount();
  /**
   *
   *
   * <pre>
   * The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name&#64;project_id.iam.gserviceaccount.com/
   * </pre>
   *
   * <code>optional string kms_key_service_account = 209986261;</code>
   *
   * @return The bytes for kmsKeyServiceAccount.
   */
  com.google.protobuf.ByteString getKmsKeyServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
   * </pre>
   *
   * <code>optional string raw_key = 449196488;</code>
   *
   * @return Whether the rawKey field is set.
   */
  boolean hasRawKey();
  /**
   *
   *
   * <pre>
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
   * </pre>
   *
   * <code>optional string raw_key = 449196488;</code>
   *
   * @return The rawKey.
   */
  java.lang.String getRawKey();
  /**
   *
   *
   * <pre>
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
   * </pre>
   *
   * <code>optional string raw_key = 449196488;</code>
   *
   * @return The bytes for rawKey.
   */
  com.google.protobuf.ByteString getRawKeyBytes();

  /**
   *
   *
   * <pre>
   * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
   * </pre>
   *
   * <code>optional string rsa_encrypted_key = 335487397;</code>
   *
   * @return Whether the rsaEncryptedKey field is set.
   */
  boolean hasRsaEncryptedKey();
  /**
   *
   *
   * <pre>
   * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
   * </pre>
   *
   * <code>optional string rsa_encrypted_key = 335487397;</code>
   *
   * @return The rsaEncryptedKey.
   */
  java.lang.String getRsaEncryptedKey();
  /**
   *
   *
   * <pre>
   * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
   * </pre>
   *
   * <code>optional string rsa_encrypted_key = 335487397;</code>
   *
   * @return The bytes for rsaEncryptedKey.
   */
  com.google.protobuf.ByteString getRsaEncryptedKeyBytes();

  /**
   *
   *
   * <pre>
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
   * </pre>
   *
   * <code>optional string sha256 = 170112551;</code>
   *
   * @return Whether the sha256 field is set.
   */
  boolean hasSha256();
  /**
   *
   *
   * <pre>
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
   * </pre>
   *
   * <code>optional string sha256 = 170112551;</code>
   *
   * @return The sha256.
   */
  java.lang.String getSha256();
  /**
   *
   *
   * <pre>
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
   * </pre>
   *
   * <code>optional string sha256 = 170112551;</code>
   *
   * @return The bytes for sha256.
   */
  com.google.protobuf.ByteString getSha256Bytes();
}
