/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

public interface HttpHeaderMatchOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.HttpHeaderMatch)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string exact_match = 457641093;</code>
   *
   * @return Whether the exactMatch field is set.
   */
  boolean hasExactMatch();
  /**
   *
   *
   * <pre>
   * The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string exact_match = 457641093;</code>
   *
   * @return The exactMatch.
   */
  java.lang.String getExactMatch();
  /**
   *
   *
   * <pre>
   * The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string exact_match = 457641093;</code>
   *
   * @return The bytes for exactMatch.
   */
  com.google.protobuf.ByteString getExactMatchBytes();

  /**
   *
   *
   * <pre>
   * The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
   * </pre>
   *
   * <code>optional string header_name = 110223613;</code>
   *
   * @return Whether the headerName field is set.
   */
  boolean hasHeaderName();
  /**
   *
   *
   * <pre>
   * The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
   * </pre>
   *
   * <code>optional string header_name = 110223613;</code>
   *
   * @return The headerName.
   */
  java.lang.String getHeaderName();
  /**
   *
   *
   * <pre>
   * The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
   * </pre>
   *
   * <code>optional string header_name = 110223613;</code>
   *
   * @return The bytes for headerName.
   */
  com.google.protobuf.ByteString getHeaderNameBytes();

  /**
   *
   *
   * <pre>
   * If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false.
   * </pre>
   *
   * <code>optional bool invert_match = 501130268;</code>
   *
   * @return Whether the invertMatch field is set.
   */
  boolean hasInvertMatch();
  /**
   *
   *
   * <pre>
   * If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false.
   * </pre>
   *
   * <code>optional bool invert_match = 501130268;</code>
   *
   * @return The invertMatch.
   */
  boolean getInvertMatch();

  /**
   *
   *
   * <pre>
   * The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string prefix_match = 257898968;</code>
   *
   * @return Whether the prefixMatch field is set.
   */
  boolean hasPrefixMatch();
  /**
   *
   *
   * <pre>
   * The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string prefix_match = 257898968;</code>
   *
   * @return The prefixMatch.
   */
  java.lang.String getPrefixMatch();
  /**
   *
   *
   * <pre>
   * The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string prefix_match = 257898968;</code>
   *
   * @return The bytes for prefixMatch.
   */
  com.google.protobuf.ByteString getPrefixMatchBytes();

  /**
   *
   *
   * <pre>
   * A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional bool present_match = 67435841;</code>
   *
   * @return Whether the presentMatch field is set.
   */
  boolean hasPresentMatch();
  /**
   *
   *
   * <pre>
   * A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional bool present_match = 67435841;</code>
   *
   * @return The presentMatch.
   */
  boolean getPresentMatch();

  /**
   *
   *
   * <pre>
   * The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Int64RangeMatch range_match = 97244227;</code>
   *
   * @return Whether the rangeMatch field is set.
   */
  boolean hasRangeMatch();
  /**
   *
   *
   * <pre>
   * The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Int64RangeMatch range_match = 97244227;</code>
   *
   * @return The rangeMatch.
   */
  com.google.cloud.compute.v1.Int64RangeMatch getRangeMatch();
  /**
   *
   *
   * <pre>
   * The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Int64RangeMatch range_match = 97244227;</code>
   */
  com.google.cloud.compute.v1.Int64RangeMatchOrBuilder getRangeMatchOrBuilder();

  /**
   *
   *
   * <pre>
   * The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional string regex_match = 107387853;</code>
   *
   * @return Whether the regexMatch field is set.
   */
  boolean hasRegexMatch();
  /**
   *
   *
   * <pre>
   * The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional string regex_match = 107387853;</code>
   *
   * @return The regexMatch.
   */
  java.lang.String getRegexMatch();
  /**
   *
   *
   * <pre>
   * The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional string regex_match = 107387853;</code>
   *
   * @return The bytes for regexMatch.
   */
  com.google.protobuf.ByteString getRegexMatchBytes();

  /**
   *
   *
   * <pre>
   * The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string suffix_match = 426488663;</code>
   *
   * @return Whether the suffixMatch field is set.
   */
  boolean hasSuffixMatch();
  /**
   *
   *
   * <pre>
   * The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string suffix_match = 426488663;</code>
   *
   * @return The suffixMatch.
   */
  java.lang.String getSuffixMatch();
  /**
   *
   *
   * <pre>
   * The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
   * </pre>
   *
   * <code>optional string suffix_match = 426488663;</code>
   *
   * @return The bytes for suffixMatch.
   */
  com.google.protobuf.ByteString getSuffixMatchBytes();
}
