/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Initial State for shielded instance, these are public keys which are safe to store in public
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InitialStateConfig}
 */
public final class InitialStateConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InitialStateConfig)
    InitialStateConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InitialStateConfig.newBuilder() to construct.
  private InitialStateConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InitialStateConfig() {
    dbs_ = java.util.Collections.emptyList();
    dbxs_ = java.util.Collections.emptyList();
    keks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InitialStateConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InitialStateConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InitialStateConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InitialStateConfig.class,
            com.google.cloud.compute.v1.InitialStateConfig.Builder.class);
  }

  private int bitField0_;
  public static final int DBS_FIELD_NUMBER = 99253;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.FileContentBuffer> dbs_;
  /**
   *
   *
   * <pre>
   * The Key Database (db).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.FileContentBuffer> getDbsList() {
    return dbs_;
  }
  /**
   *
   *
   * <pre>
   * The Key Database (db).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.FileContentBufferOrBuilder>
      getDbsOrBuilderList() {
    return dbs_;
  }
  /**
   *
   *
   * <pre>
   * The Key Database (db).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
   */
  @java.lang.Override
  public int getDbsCount() {
    return dbs_.size();
  }
  /**
   *
   *
   * <pre>
   * The Key Database (db).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBuffer getDbs(int index) {
    return dbs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Key Database (db).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBufferOrBuilder getDbsOrBuilder(int index) {
    return dbs_.get(index);
  }

  public static final int DBXS_FIELD_NUMBER = 3077113;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.FileContentBuffer> dbxs_;
  /**
   *
   *
   * <pre>
   * The forbidden key database (dbx).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.FileContentBuffer> getDbxsList() {
    return dbxs_;
  }
  /**
   *
   *
   * <pre>
   * The forbidden key database (dbx).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.FileContentBufferOrBuilder>
      getDbxsOrBuilderList() {
    return dbxs_;
  }
  /**
   *
   *
   * <pre>
   * The forbidden key database (dbx).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
   */
  @java.lang.Override
  public int getDbxsCount() {
    return dbxs_.size();
  }
  /**
   *
   *
   * <pre>
   * The forbidden key database (dbx).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBuffer getDbxs(int index) {
    return dbxs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The forbidden key database (dbx).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBufferOrBuilder getDbxsOrBuilder(int index) {
    return dbxs_.get(index);
  }

  public static final int KEKS_FIELD_NUMBER = 3288130;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.FileContentBuffer> keks_;
  /**
   *
   *
   * <pre>
   * The Key Exchange Key (KEK).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.FileContentBuffer> getKeksList() {
    return keks_;
  }
  /**
   *
   *
   * <pre>
   * The Key Exchange Key (KEK).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.FileContentBufferOrBuilder>
      getKeksOrBuilderList() {
    return keks_;
  }
  /**
   *
   *
   * <pre>
   * The Key Exchange Key (KEK).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
   */
  @java.lang.Override
  public int getKeksCount() {
    return keks_.size();
  }
  /**
   *
   *
   * <pre>
   * The Key Exchange Key (KEK).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBuffer getKeks(int index) {
    return keks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Key Exchange Key (KEK).
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBufferOrBuilder getKeksOrBuilder(int index) {
    return keks_.get(index);
  }

  public static final int PK_FIELD_NUMBER = 3579;
  private com.google.cloud.compute.v1.FileContentBuffer pk_;
  /**
   *
   *
   * <pre>
   * The Platform Key (PK).
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
   *
   * @return Whether the pk field is set.
   */
  @java.lang.Override
  public boolean hasPk() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Platform Key (PK).
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
   *
   * @return The pk.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBuffer getPk() {
    return pk_ == null ? com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance() : pk_;
  }
  /**
   *
   *
   * <pre>
   * The Platform Key (PK).
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FileContentBufferOrBuilder getPkOrBuilder() {
    return pk_ == null ? com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance() : pk_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3579, getPk());
    }
    for (int i = 0; i < dbs_.size(); i++) {
      output.writeMessage(99253, dbs_.get(i));
    }
    for (int i = 0; i < dbxs_.size(); i++) {
      output.writeMessage(3077113, dbxs_.get(i));
    }
    for (int i = 0; i < keks_.size(); i++) {
      output.writeMessage(3288130, keks_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3579, getPk());
    }
    for (int i = 0; i < dbs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(99253, dbs_.get(i));
    }
    for (int i = 0; i < dbxs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3077113, dbxs_.get(i));
    }
    for (int i = 0; i < keks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3288130, keks_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InitialStateConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InitialStateConfig other =
        (com.google.cloud.compute.v1.InitialStateConfig) obj;

    if (!getDbsList().equals(other.getDbsList())) return false;
    if (!getDbxsList().equals(other.getDbxsList())) return false;
    if (!getKeksList().equals(other.getKeksList())) return false;
    if (hasPk() != other.hasPk()) return false;
    if (hasPk()) {
      if (!getPk().equals(other.getPk())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDbsCount() > 0) {
      hash = (37 * hash) + DBS_FIELD_NUMBER;
      hash = (53 * hash) + getDbsList().hashCode();
    }
    if (getDbxsCount() > 0) {
      hash = (37 * hash) + DBXS_FIELD_NUMBER;
      hash = (53 * hash) + getDbxsList().hashCode();
    }
    if (getKeksCount() > 0) {
      hash = (37 * hash) + KEKS_FIELD_NUMBER;
      hash = (53 * hash) + getKeksList().hashCode();
    }
    if (hasPk()) {
      hash = (37 * hash) + PK_FIELD_NUMBER;
      hash = (53 * hash) + getPk().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InitialStateConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InitialStateConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Initial State for shielded instance, these are public keys which are safe to store in public
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InitialStateConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InitialStateConfig)
      com.google.cloud.compute.v1.InitialStateConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InitialStateConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InitialStateConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InitialStateConfig.class,
              com.google.cloud.compute.v1.InitialStateConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InitialStateConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDbsFieldBuilder();
        getDbxsFieldBuilder();
        getKeksFieldBuilder();
        getPkFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dbsBuilder_ == null) {
        dbs_ = java.util.Collections.emptyList();
      } else {
        dbs_ = null;
        dbsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (dbxsBuilder_ == null) {
        dbxs_ = java.util.Collections.emptyList();
      } else {
        dbxs_ = null;
        dbxsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (keksBuilder_ == null) {
        keks_ = java.util.Collections.emptyList();
      } else {
        keks_ = null;
        keksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      pk_ = null;
      if (pkBuilder_ != null) {
        pkBuilder_.dispose();
        pkBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InitialStateConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InitialStateConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InitialStateConfig build() {
      com.google.cloud.compute.v1.InitialStateConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InitialStateConfig buildPartial() {
      com.google.cloud.compute.v1.InitialStateConfig result =
          new com.google.cloud.compute.v1.InitialStateConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.InitialStateConfig result) {
      if (dbsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          dbs_ = java.util.Collections.unmodifiableList(dbs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.dbs_ = dbs_;
      } else {
        result.dbs_ = dbsBuilder_.build();
      }
      if (dbxsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dbxs_ = java.util.Collections.unmodifiableList(dbxs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dbxs_ = dbxs_;
      } else {
        result.dbxs_ = dbxsBuilder_.build();
      }
      if (keksBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          keks_ = java.util.Collections.unmodifiableList(keks_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.keks_ = keks_;
      } else {
        result.keks_ = keksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InitialStateConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pk_ = pkBuilder_ == null ? pk_ : pkBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InitialStateConfig) {
        return mergeFrom((com.google.cloud.compute.v1.InitialStateConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InitialStateConfig other) {
      if (other == com.google.cloud.compute.v1.InitialStateConfig.getDefaultInstance()) return this;
      if (dbsBuilder_ == null) {
        if (!other.dbs_.isEmpty()) {
          if (dbs_.isEmpty()) {
            dbs_ = other.dbs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDbsIsMutable();
            dbs_.addAll(other.dbs_);
          }
          onChanged();
        }
      } else {
        if (!other.dbs_.isEmpty()) {
          if (dbsBuilder_.isEmpty()) {
            dbsBuilder_.dispose();
            dbsBuilder_ = null;
            dbs_ = other.dbs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            dbsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDbsFieldBuilder()
                    : null;
          } else {
            dbsBuilder_.addAllMessages(other.dbs_);
          }
        }
      }
      if (dbxsBuilder_ == null) {
        if (!other.dbxs_.isEmpty()) {
          if (dbxs_.isEmpty()) {
            dbxs_ = other.dbxs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDbxsIsMutable();
            dbxs_.addAll(other.dbxs_);
          }
          onChanged();
        }
      } else {
        if (!other.dbxs_.isEmpty()) {
          if (dbxsBuilder_.isEmpty()) {
            dbxsBuilder_.dispose();
            dbxsBuilder_ = null;
            dbxs_ = other.dbxs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dbxsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDbxsFieldBuilder()
                    : null;
          } else {
            dbxsBuilder_.addAllMessages(other.dbxs_);
          }
        }
      }
      if (keksBuilder_ == null) {
        if (!other.keks_.isEmpty()) {
          if (keks_.isEmpty()) {
            keks_ = other.keks_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureKeksIsMutable();
            keks_.addAll(other.keks_);
          }
          onChanged();
        }
      } else {
        if (!other.keks_.isEmpty()) {
          if (keksBuilder_.isEmpty()) {
            keksBuilder_.dispose();
            keksBuilder_ = null;
            keks_ = other.keks_;
            bitField0_ = (bitField0_ & ~0x00000004);
            keksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getKeksFieldBuilder()
                    : null;
          } else {
            keksBuilder_.addAllMessages(other.keks_);
          }
        }
      }
      if (other.hasPk()) {
        mergePk(other.getPk());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28634:
              {
                input.readMessage(getPkFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 28634
            case 794026:
              {
                com.google.cloud.compute.v1.FileContentBuffer m =
                    input.readMessage(
                        com.google.cloud.compute.v1.FileContentBuffer.parser(), extensionRegistry);
                if (dbsBuilder_ == null) {
                  ensureDbsIsMutable();
                  dbs_.add(m);
                } else {
                  dbsBuilder_.addMessage(m);
                }
                break;
              } // case 794026
            case 24616906:
              {
                com.google.cloud.compute.v1.FileContentBuffer m =
                    input.readMessage(
                        com.google.cloud.compute.v1.FileContentBuffer.parser(), extensionRegistry);
                if (dbxsBuilder_ == null) {
                  ensureDbxsIsMutable();
                  dbxs_.add(m);
                } else {
                  dbxsBuilder_.addMessage(m);
                }
                break;
              } // case 24616906
            case 26305042:
              {
                com.google.cloud.compute.v1.FileContentBuffer m =
                    input.readMessage(
                        com.google.cloud.compute.v1.FileContentBuffer.parser(), extensionRegistry);
                if (keksBuilder_ == null) {
                  ensureKeksIsMutable();
                  keks_.add(m);
                } else {
                  keksBuilder_.addMessage(m);
                }
                break;
              } // case 26305042
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.FileContentBuffer> dbs_ =
        java.util.Collections.emptyList();

    private void ensureDbsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        dbs_ = new java.util.ArrayList<com.google.cloud.compute.v1.FileContentBuffer>(dbs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        dbsBuilder_;

    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.FileContentBuffer> getDbsList() {
      if (dbsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dbs_);
      } else {
        return dbsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public int getDbsCount() {
      if (dbsBuilder_ == null) {
        return dbs_.size();
      } else {
        return dbsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer getDbs(int index) {
      if (dbsBuilder_ == null) {
        return dbs_.get(index);
      } else {
        return dbsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder setDbs(int index, com.google.cloud.compute.v1.FileContentBuffer value) {
      if (dbsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbsIsMutable();
        dbs_.set(index, value);
        onChanged();
      } else {
        dbsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder setDbs(
        int index, com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (dbsBuilder_ == null) {
        ensureDbsIsMutable();
        dbs_.set(index, builderForValue.build());
        onChanged();
      } else {
        dbsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder addDbs(com.google.cloud.compute.v1.FileContentBuffer value) {
      if (dbsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbsIsMutable();
        dbs_.add(value);
        onChanged();
      } else {
        dbsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder addDbs(int index, com.google.cloud.compute.v1.FileContentBuffer value) {
      if (dbsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbsIsMutable();
        dbs_.add(index, value);
        onChanged();
      } else {
        dbsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder addDbs(com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (dbsBuilder_ == null) {
        ensureDbsIsMutable();
        dbs_.add(builderForValue.build());
        onChanged();
      } else {
        dbsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder addDbs(
        int index, com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (dbsBuilder_ == null) {
        ensureDbsIsMutable();
        dbs_.add(index, builderForValue.build());
        onChanged();
      } else {
        dbsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder addAllDbs(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.FileContentBuffer> values) {
      if (dbsBuilder_ == null) {
        ensureDbsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dbs_);
        onChanged();
      } else {
        dbsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder clearDbs() {
      if (dbsBuilder_ == null) {
        dbs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        dbsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public Builder removeDbs(int index) {
      if (dbsBuilder_ == null) {
        ensureDbsIsMutable();
        dbs_.remove(index);
        onChanged();
      } else {
        dbsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder getDbsBuilder(int index) {
      return getDbsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public com.google.cloud.compute.v1.FileContentBufferOrBuilder getDbsOrBuilder(int index) {
      if (dbsBuilder_ == null) {
        return dbs_.get(index);
      } else {
        return dbsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getDbsOrBuilderList() {
      if (dbsBuilder_ != null) {
        return dbsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dbs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder addDbsBuilder() {
      return getDbsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder addDbsBuilder(int index) {
      return getDbsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Key Database (db).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbs = 99253;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.FileContentBuffer.Builder>
        getDbsBuilderList() {
      return getDbsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getDbsFieldBuilder() {
      if (dbsBuilder_ == null) {
        dbsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.FileContentBuffer,
                com.google.cloud.compute.v1.FileContentBuffer.Builder,
                com.google.cloud.compute.v1.FileContentBufferOrBuilder>(
                dbs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        dbs_ = null;
      }
      return dbsBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.FileContentBuffer> dbxs_ =
        java.util.Collections.emptyList();

    private void ensureDbxsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dbxs_ = new java.util.ArrayList<com.google.cloud.compute.v1.FileContentBuffer>(dbxs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        dbxsBuilder_;

    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.FileContentBuffer> getDbxsList() {
      if (dbxsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dbxs_);
      } else {
        return dbxsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public int getDbxsCount() {
      if (dbxsBuilder_ == null) {
        return dbxs_.size();
      } else {
        return dbxsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer getDbxs(int index) {
      if (dbxsBuilder_ == null) {
        return dbxs_.get(index);
      } else {
        return dbxsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder setDbxs(int index, com.google.cloud.compute.v1.FileContentBuffer value) {
      if (dbxsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbxsIsMutable();
        dbxs_.set(index, value);
        onChanged();
      } else {
        dbxsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder setDbxs(
        int index, com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (dbxsBuilder_ == null) {
        ensureDbxsIsMutable();
        dbxs_.set(index, builderForValue.build());
        onChanged();
      } else {
        dbxsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder addDbxs(com.google.cloud.compute.v1.FileContentBuffer value) {
      if (dbxsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbxsIsMutable();
        dbxs_.add(value);
        onChanged();
      } else {
        dbxsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder addDbxs(int index, com.google.cloud.compute.v1.FileContentBuffer value) {
      if (dbxsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbxsIsMutable();
        dbxs_.add(index, value);
        onChanged();
      } else {
        dbxsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder addDbxs(com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (dbxsBuilder_ == null) {
        ensureDbxsIsMutable();
        dbxs_.add(builderForValue.build());
        onChanged();
      } else {
        dbxsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder addDbxs(
        int index, com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (dbxsBuilder_ == null) {
        ensureDbxsIsMutable();
        dbxs_.add(index, builderForValue.build());
        onChanged();
      } else {
        dbxsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder addAllDbxs(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.FileContentBuffer> values) {
      if (dbxsBuilder_ == null) {
        ensureDbxsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dbxs_);
        onChanged();
      } else {
        dbxsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder clearDbxs() {
      if (dbxsBuilder_ == null) {
        dbxs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dbxsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public Builder removeDbxs(int index) {
      if (dbxsBuilder_ == null) {
        ensureDbxsIsMutable();
        dbxs_.remove(index);
        onChanged();
      } else {
        dbxsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder getDbxsBuilder(int index) {
      return getDbxsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public com.google.cloud.compute.v1.FileContentBufferOrBuilder getDbxsOrBuilder(int index) {
      if (dbxsBuilder_ == null) {
        return dbxs_.get(index);
      } else {
        return dbxsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getDbxsOrBuilderList() {
      if (dbxsBuilder_ != null) {
        return dbxsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dbxs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder addDbxsBuilder() {
      return getDbxsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder addDbxsBuilder(int index) {
      return getDbxsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The forbidden key database (dbx).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer dbxs = 3077113;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.FileContentBuffer.Builder>
        getDbxsBuilderList() {
      return getDbxsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getDbxsFieldBuilder() {
      if (dbxsBuilder_ == null) {
        dbxsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.FileContentBuffer,
                com.google.cloud.compute.v1.FileContentBuffer.Builder,
                com.google.cloud.compute.v1.FileContentBufferOrBuilder>(
                dbxs_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        dbxs_ = null;
      }
      return dbxsBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.FileContentBuffer> keks_ =
        java.util.Collections.emptyList();

    private void ensureKeksIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        keks_ = new java.util.ArrayList<com.google.cloud.compute.v1.FileContentBuffer>(keks_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        keksBuilder_;

    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.FileContentBuffer> getKeksList() {
      if (keksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(keks_);
      } else {
        return keksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public int getKeksCount() {
      if (keksBuilder_ == null) {
        return keks_.size();
      } else {
        return keksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer getKeks(int index) {
      if (keksBuilder_ == null) {
        return keks_.get(index);
      } else {
        return keksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder setKeks(int index, com.google.cloud.compute.v1.FileContentBuffer value) {
      if (keksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeksIsMutable();
        keks_.set(index, value);
        onChanged();
      } else {
        keksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder setKeks(
        int index, com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (keksBuilder_ == null) {
        ensureKeksIsMutable();
        keks_.set(index, builderForValue.build());
        onChanged();
      } else {
        keksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder addKeks(com.google.cloud.compute.v1.FileContentBuffer value) {
      if (keksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeksIsMutable();
        keks_.add(value);
        onChanged();
      } else {
        keksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder addKeks(int index, com.google.cloud.compute.v1.FileContentBuffer value) {
      if (keksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeksIsMutable();
        keks_.add(index, value);
        onChanged();
      } else {
        keksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder addKeks(com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (keksBuilder_ == null) {
        ensureKeksIsMutable();
        keks_.add(builderForValue.build());
        onChanged();
      } else {
        keksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder addKeks(
        int index, com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (keksBuilder_ == null) {
        ensureKeksIsMutable();
        keks_.add(index, builderForValue.build());
        onChanged();
      } else {
        keksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder addAllKeks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.FileContentBuffer> values) {
      if (keksBuilder_ == null) {
        ensureKeksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, keks_);
        onChanged();
      } else {
        keksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder clearKeks() {
      if (keksBuilder_ == null) {
        keks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        keksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public Builder removeKeks(int index) {
      if (keksBuilder_ == null) {
        ensureKeksIsMutable();
        keks_.remove(index);
        onChanged();
      } else {
        keksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder getKeksBuilder(int index) {
      return getKeksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public com.google.cloud.compute.v1.FileContentBufferOrBuilder getKeksOrBuilder(int index) {
      if (keksBuilder_ == null) {
        return keks_.get(index);
      } else {
        return keksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getKeksOrBuilderList() {
      if (keksBuilder_ != null) {
        return keksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(keks_);
      }
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder addKeksBuilder() {
      return getKeksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder addKeksBuilder(int index) {
      return getKeksFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Key Exchange Key (KEK).
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.FileContentBuffer keks = 3288130;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.FileContentBuffer.Builder>
        getKeksBuilderList() {
      return getKeksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getKeksFieldBuilder() {
      if (keksBuilder_ == null) {
        keksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.FileContentBuffer,
                com.google.cloud.compute.v1.FileContentBuffer.Builder,
                com.google.cloud.compute.v1.FileContentBufferOrBuilder>(
                keks_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        keks_ = null;
      }
      return keksBuilder_;
    }

    private com.google.cloud.compute.v1.FileContentBuffer pk_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        pkBuilder_;
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     *
     * @return Whether the pk field is set.
     */
    public boolean hasPk() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     *
     * @return The pk.
     */
    public com.google.cloud.compute.v1.FileContentBuffer getPk() {
      if (pkBuilder_ == null) {
        return pk_ == null
            ? com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance()
            : pk_;
      } else {
        return pkBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    public Builder setPk(com.google.cloud.compute.v1.FileContentBuffer value) {
      if (pkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pk_ = value;
      } else {
        pkBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    public Builder setPk(com.google.cloud.compute.v1.FileContentBuffer.Builder builderForValue) {
      if (pkBuilder_ == null) {
        pk_ = builderForValue.build();
      } else {
        pkBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    public Builder mergePk(com.google.cloud.compute.v1.FileContentBuffer value) {
      if (pkBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && pk_ != null
            && pk_ != com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance()) {
          getPkBuilder().mergeFrom(value);
        } else {
          pk_ = value;
        }
      } else {
        pkBuilder_.mergeFrom(value);
      }
      if (pk_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    public Builder clearPk() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pk_ = null;
      if (pkBuilder_ != null) {
        pkBuilder_.dispose();
        pkBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    public com.google.cloud.compute.v1.FileContentBuffer.Builder getPkBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    public com.google.cloud.compute.v1.FileContentBufferOrBuilder getPkOrBuilder() {
      if (pkBuilder_ != null) {
        return pkBuilder_.getMessageOrBuilder();
      } else {
        return pk_ == null
            ? com.google.cloud.compute.v1.FileContentBuffer.getDefaultInstance()
            : pk_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Platform Key (PK).
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FileContentBuffer pk = 3579;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FileContentBuffer,
            com.google.cloud.compute.v1.FileContentBuffer.Builder,
            com.google.cloud.compute.v1.FileContentBufferOrBuilder>
        getPkFieldBuilder() {
      if (pkBuilder_ == null) {
        pkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.FileContentBuffer,
                com.google.cloud.compute.v1.FileContentBuffer.Builder,
                com.google.cloud.compute.v1.FileContentBufferOrBuilder>(
                getPk(), getParentForChildren(), isClean());
        pk_ = null;
      }
      return pkBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InitialStateConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InitialStateConfig)
  private static final com.google.cloud.compute.v1.InitialStateConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InitialStateConfig();
  }

  public static com.google.cloud.compute.v1.InitialStateConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InitialStateConfig> PARSER =
      new com.google.protobuf.AbstractParser<InitialStateConfig>() {
        @java.lang.Override
        public InitialStateConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InitialStateConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InitialStateConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InitialStateConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
