/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Description of a planned outage on this Interconnect.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectOutageNotification}
 */
public final class InterconnectOutageNotification extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectOutageNotification)
    InterconnectOutageNotificationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InterconnectOutageNotification.newBuilder() to construct.
  private InterconnectOutageNotification(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectOutageNotification() {
    affectedCircuits_ = com.google.protobuf.LazyStringArrayList.emptyList();
    description_ = "";
    issueType_ = "";
    name_ = "";
    source_ = "";
    state_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectOutageNotification();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectOutageNotification_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectOutageNotification_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectOutageNotification.class,
            com.google.cloud.compute.v1.InterconnectOutageNotification.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectOutageNotification.IssueType}
   */
  public enum IssueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ISSUE_TYPE = 0;</code>
     */
    UNDEFINED_ISSUE_TYPE(0),
    /**
     *
     *
     * <pre>
     * [Deprecated] The Interconnect may be completely out of service for some or all of the specified window.
     * </pre>
     *
     * <code>IT_OUTAGE = 175779973;</code>
     */
    IT_OUTAGE(175779973),
    /**
     *
     *
     * <pre>
     * [Deprecated] Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
     * </pre>
     *
     * <code>IT_PARTIAL_OUTAGE = 92103971;</code>
     */
    IT_PARTIAL_OUTAGE(92103971),
    /**
     *
     *
     * <pre>
     * The Interconnect may be completely out of service for some or all of the specified window.
     * </pre>
     *
     * <code>OUTAGE = 195285745;</code>
     */
    OUTAGE(195285745),
    /**
     *
     *
     * <pre>
     * Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
     * </pre>
     *
     * <code>PARTIAL_OUTAGE = 147053455;</code>
     */
    PARTIAL_OUTAGE(147053455),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ISSUE_TYPE = 0;</code>
     */
    public static final int UNDEFINED_ISSUE_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * [Deprecated] The Interconnect may be completely out of service for some or all of the specified window.
     * </pre>
     *
     * <code>IT_OUTAGE = 175779973;</code>
     */
    public static final int IT_OUTAGE_VALUE = 175779973;
    /**
     *
     *
     * <pre>
     * [Deprecated] Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
     * </pre>
     *
     * <code>IT_PARTIAL_OUTAGE = 92103971;</code>
     */
    public static final int IT_PARTIAL_OUTAGE_VALUE = 92103971;
    /**
     *
     *
     * <pre>
     * The Interconnect may be completely out of service for some or all of the specified window.
     * </pre>
     *
     * <code>OUTAGE = 195285745;</code>
     */
    public static final int OUTAGE_VALUE = 195285745;
    /**
     *
     *
     * <pre>
     * Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
     * </pre>
     *
     * <code>PARTIAL_OUTAGE = 147053455;</code>
     */
    public static final int PARTIAL_OUTAGE_VALUE = 147053455;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IssueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IssueType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ISSUE_TYPE;
        case 175779973:
          return IT_OUTAGE;
        case 92103971:
          return IT_PARTIAL_OUTAGE;
        case 195285745:
          return OUTAGE;
        case 147053455:
          return PARTIAL_OUTAGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IssueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IssueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IssueType>() {
          public IssueType findValueByNumber(int number) {
            return IssueType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectOutageNotification.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IssueType[] VALUES = values();

    public static IssueType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IssueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectOutageNotification.IssueType)
  }

  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectOutageNotification.Source}
   */
  public enum Source implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE = 0;</code>
     */
    UNDEFINED_SOURCE(0),
    /**
     *
     *
     * <pre>
     * This notification was generated by Google.
     * </pre>
     *
     * <code>GOOGLE = 497439289;</code>
     */
    GOOGLE(497439289),
    /**
     *
     *
     * <pre>
     * [Deprecated] This notification was generated by Google.
     * </pre>
     *
     * <code>NSRC_GOOGLE = 510574562;</code>
     */
    NSRC_GOOGLE(510574562),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE = 0;</code>
     */
    public static final int UNDEFINED_SOURCE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This notification was generated by Google.
     * </pre>
     *
     * <code>GOOGLE = 497439289;</code>
     */
    public static final int GOOGLE_VALUE = 497439289;
    /**
     *
     *
     * <pre>
     * [Deprecated] This notification was generated by Google.
     * </pre>
     *
     * <code>NSRC_GOOGLE = 510574562;</code>
     */
    public static final int NSRC_GOOGLE_VALUE = 510574562;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Source valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Source forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SOURCE;
        case 497439289:
          return GOOGLE;
        case 510574562:
          return NSRC_GOOGLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Source> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Source> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Source>() {
          public Source findValueByNumber(int number) {
            return Source.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectOutageNotification.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Source[] VALUES = values();

    public static Source valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Source(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectOutageNotification.Source)
  }

  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectOutageNotification.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    UNDEFINED_STATE(0),
    /**
     *
     *
     * <pre>
     * This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /**
     *
     *
     * <pre>
     * The outage associated with this notification was cancelled before the outage was due to start.
     * </pre>
     *
     * <code>CANCELLED = 41957681;</code>
     */
    CANCELLED(41957681),
    /**
     *
     *
     * <pre>
     * The outage associated with this notification is complete.
     * </pre>
     *
     * <code>COMPLETED = 309921323;</code>
     */
    COMPLETED(309921323),
    /**
     *
     *
     * <pre>
     * [Deprecated] This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
     * </pre>
     *
     * <code>NS_ACTIVE = 252563136;</code>
     */
    NS_ACTIVE(252563136),
    /**
     *
     *
     * <pre>
     * [Deprecated] The outage associated with this notification was canceled before the outage was due to start.
     * </pre>
     *
     * <code>NS_CANCELED = 506579411;</code>
     */
    NS_CANCELED(506579411),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    public static final int UNDEFINED_STATE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;
    /**
     *
     *
     * <pre>
     * The outage associated with this notification was cancelled before the outage was due to start.
     * </pre>
     *
     * <code>CANCELLED = 41957681;</code>
     */
    public static final int CANCELLED_VALUE = 41957681;
    /**
     *
     *
     * <pre>
     * The outage associated with this notification is complete.
     * </pre>
     *
     * <code>COMPLETED = 309921323;</code>
     */
    public static final int COMPLETED_VALUE = 309921323;
    /**
     *
     *
     * <pre>
     * [Deprecated] This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
     * </pre>
     *
     * <code>NS_ACTIVE = 252563136;</code>
     */
    public static final int NS_ACTIVE_VALUE = 252563136;
    /**
     *
     *
     * <pre>
     * [Deprecated] The outage associated with this notification was canceled before the outage was due to start.
     * </pre>
     *
     * <code>NS_CANCELED = 506579411;</code>
     */
    public static final int NS_CANCELED_VALUE = 506579411;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATE;
        case 314733318:
          return ACTIVE;
        case 41957681:
          return CANCELLED;
        case 309921323:
          return COMPLETED;
        case 252563136:
          return NS_ACTIVE;
        case 506579411:
          return NS_CANCELED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectOutageNotification.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectOutageNotification.State)
  }

  private int bitField0_;
  public static final int AFFECTED_CIRCUITS_FIELD_NUMBER = 177717013;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList affectedCircuits_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @return A list containing the affectedCircuits.
   */
  public com.google.protobuf.ProtocolStringList getAffectedCircuitsList() {
    return affectedCircuits_;
  }
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @return The count of affectedCircuits.
   */
  public int getAffectedCircuitsCount() {
    return affectedCircuits_.size();
  }
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @param index The index of the element to return.
   * @return The affectedCircuits at the given index.
   */
  public java.lang.String getAffectedCircuits(int index) {
    return affectedCircuits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the affectedCircuits at the given index.
   */
  public com.google.protobuf.ByteString getAffectedCircuitsBytes(int index) {
    return affectedCircuits_.getByteString(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A description about the purpose of the outage.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A description about the purpose of the outage.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description about the purpose of the outage.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_TIME_FIELD_NUMBER = 114938801;
  private long endTime_ = 0L;
  /**
   *
   *
   * <pre>
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 end_time = 114938801;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 end_time = 114938801;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public long getEndTime() {
    return endTime_;
  }

  public static final int ISSUE_TYPE_FIELD_NUMBER = 369639136;

  @SuppressWarnings("serial")
  private volatile java.lang.Object issueType_ = "";
  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * Check the IssueType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string issue_type = 369639136;</code>
   *
   * @return Whether the issueType field is set.
   */
  @java.lang.Override
  public boolean hasIssueType() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * Check the IssueType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string issue_type = 369639136;</code>
   *
   * @return The issueType.
   */
  @java.lang.Override
  public java.lang.String getIssueType() {
    java.lang.Object ref = issueType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issueType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * Check the IssueType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string issue_type = 369639136;</code>
   *
   * @return The bytes for issueType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIssueTypeBytes() {
    java.lang.Object ref = issueType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      issueType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier for this outage notification.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for this outage notification.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for this outage notification.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 177235995;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";
  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * Check the Source enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * Check the Source enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * Check the Source enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 37467274;
  private long startTime_ = 0L;
  /**
   *
   *
   * <pre>
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 start_time = 37467274;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 start_time = 37467274;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public long getStartTime() {
    return startTime_;
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";
  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(37467274, startTime_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(114938801, endTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 177235995, source_);
    }
    for (int i = 0; i < affectedCircuits_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 177717013, affectedCircuits_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 369639136, issueType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(37467274, startTime_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(114938801, endTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(177235995, source_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < affectedCircuits_.size(); i++) {
        dataSize += computeStringSizeNoTag(affectedCircuits_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAffectedCircuitsList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(369639136, issueType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectOutageNotification)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectOutageNotification other =
        (com.google.cloud.compute.v1.InterconnectOutageNotification) obj;

    if (!getAffectedCircuitsList().equals(other.getAffectedCircuitsList())) return false;
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (getEndTime() != other.getEndTime()) return false;
    }
    if (hasIssueType() != other.hasIssueType()) return false;
    if (hasIssueType()) {
      if (!getIssueType().equals(other.getIssueType())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (getStartTime() != other.getStartTime()) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAffectedCircuitsCount() > 0) {
      hash = (37 * hash) + AFFECTED_CIRCUITS_FIELD_NUMBER;
      hash = (53 * hash) + getAffectedCircuitsList().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEndTime());
    }
    if (hasIssueType()) {
      hash = (37 * hash) + ISSUE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getIssueType().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartTime());
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectOutageNotification prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Description of a planned outage on this Interconnect.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectOutageNotification}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectOutageNotification)
      com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectOutageNotification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectOutageNotification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectOutageNotification.class,
              com.google.cloud.compute.v1.InterconnectOutageNotification.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectOutageNotification.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      affectedCircuits_ = com.google.protobuf.LazyStringArrayList.emptyList();
      description_ = "";
      endTime_ = 0L;
      issueType_ = "";
      name_ = "";
      source_ = "";
      startTime_ = 0L;
      state_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectOutageNotification_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectOutageNotification getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectOutageNotification.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectOutageNotification build() {
      com.google.cloud.compute.v1.InterconnectOutageNotification result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectOutageNotification buildPartial() {
      com.google.cloud.compute.v1.InterconnectOutageNotification result =
          new com.google.cloud.compute.v1.InterconnectOutageNotification(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectOutageNotification result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        affectedCircuits_.makeImmutable();
        result.affectedCircuits_ = affectedCircuits_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endTime_ = endTime_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.issueType_ = issueType_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.source_ = source_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.startTime_ = startTime_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectOutageNotification) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectOutageNotification) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectOutageNotification other) {
      if (other == com.google.cloud.compute.v1.InterconnectOutageNotification.getDefaultInstance())
        return this;
      if (!other.affectedCircuits_.isEmpty()) {
        if (affectedCircuits_.isEmpty()) {
          affectedCircuits_ = other.affectedCircuits_;
          bitField0_ |= 0x00000001;
        } else {
          ensureAffectedCircuitsIsMutable();
          affectedCircuits_.addAll(other.affectedCircuits_);
        }
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasEndTime()) {
        setEndTime(other.getEndTime());
      }
      if (other.hasIssueType()) {
        issueType_ = other.issueType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSource()) {
        source_ = other.source_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasStartTime()) {
        setStartTime(other.getStartTime());
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26989658
            case 299738192:
              {
                startTime_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 299738192
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 878060682
            case 919510408:
              {
                endTime_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 919510408
            case 1417887962:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1417887962
            case 1421736106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAffectedCircuitsIsMutable();
                affectedCircuits_.add(s);
                break;
              } // case 1421736106
            case -1337854206:
              {
                issueType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1337854206
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList affectedCircuits_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAffectedCircuitsIsMutable() {
      if (!affectedCircuits_.isModifiable()) {
        affectedCircuits_ = new com.google.protobuf.LazyStringArrayList(affectedCircuits_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @return A list containing the affectedCircuits.
     */
    public com.google.protobuf.ProtocolStringList getAffectedCircuitsList() {
      affectedCircuits_.makeImmutable();
      return affectedCircuits_;
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @return The count of affectedCircuits.
     */
    public int getAffectedCircuitsCount() {
      return affectedCircuits_.size();
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @param index The index of the element to return.
     * @return The affectedCircuits at the given index.
     */
    public java.lang.String getAffectedCircuits(int index) {
      return affectedCircuits_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the affectedCircuits at the given index.
     */
    public com.google.protobuf.ByteString getAffectedCircuitsBytes(int index) {
      return affectedCircuits_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @param index The index to set the value at.
     * @param value The affectedCircuits to set.
     * @return This builder for chaining.
     */
    public Builder setAffectedCircuits(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAffectedCircuitsIsMutable();
      affectedCircuits_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @param value The affectedCircuits to add.
     * @return This builder for chaining.
     */
    public Builder addAffectedCircuits(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAffectedCircuitsIsMutable();
      affectedCircuits_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @param values The affectedCircuits to add.
     * @return This builder for chaining.
     */
    public Builder addAllAffectedCircuits(java.lang.Iterable<java.lang.String> values) {
      ensureAffectedCircuitsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, affectedCircuits_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAffectedCircuits() {
      affectedCircuits_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
     * </pre>
     *
     * <code>repeated string affected_circuits = 177717013;</code>
     *
     * @param value The bytes of the affectedCircuits to add.
     * @return This builder for chaining.
     */
    public Builder addAffectedCircuitsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAffectedCircuitsIsMutable();
      affectedCircuits_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description about the purpose of the outage.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A description about the purpose of the outage.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description about the purpose of the outage.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description about the purpose of the outage.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description about the purpose of the outage.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description about the purpose of the outage.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long endTime_;
    /**
     *
     *
     * <pre>
     * Scheduled end time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 end_time = 114938801;</code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Scheduled end time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 end_time = 114938801;</code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public long getEndTime() {
      return endTime_;
    }
    /**
     *
     *
     * <pre>
     * Scheduled end time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 end_time = 114938801;</code>
     *
     * @param value The endTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndTime(long value) {

      endTime_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduled end time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 end_time = 114938801;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endTime_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object issueType_ = "";
    /**
     *
     *
     * <pre>
     * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
     * Check the IssueType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string issue_type = 369639136;</code>
     *
     * @return Whether the issueType field is set.
     */
    public boolean hasIssueType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
     * Check the IssueType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string issue_type = 369639136;</code>
     *
     * @return The issueType.
     */
    public java.lang.String getIssueType() {
      java.lang.Object ref = issueType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issueType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
     * Check the IssueType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string issue_type = 369639136;</code>
     *
     * @return The bytes for issueType.
     */
    public com.google.protobuf.ByteString getIssueTypeBytes() {
      java.lang.Object ref = issueType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issueType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
     * Check the IssueType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string issue_type = 369639136;</code>
     *
     * @param value The issueType to set.
     * @return This builder for chaining.
     */
    public Builder setIssueType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      issueType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
     * Check the IssueType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string issue_type = 369639136;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssueType() {
      issueType_ = getDefaultInstance().getIssueType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
     * Check the IssueType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string issue_type = 369639136;</code>
     *
     * @param value The bytes for issueType to set.
     * @return This builder for chaining.
     */
    public Builder setIssueTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      issueType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier for this outage notification.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this outage notification.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this outage notification.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this outage notification.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this outage notification.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this outage notification.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
     * Check the Source enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
     * Check the Source enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
     * Check the Source enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
     * Check the Source enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
     * Check the Source enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
     * Check the Source enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source = 177235995;</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long startTime_;
    /**
     *
     *
     * <pre>
     * Scheduled start time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 start_time = 37467274;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Scheduled start time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 start_time = 37467274;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public long getStartTime() {
      return startTime_;
    }
    /**
     *
     *
     * <pre>
     * Scheduled start time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 start_time = 37467274;</code>
     *
     * @param value The startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTime(long value) {

      startTime_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheduled start time for the outage (milliseconds since Unix epoch).
     * </pre>
     *
     * <code>optional int64 start_time = 37467274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      startTime_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";
    /**
     *
     *
     * <pre>
     * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectOutageNotification)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectOutageNotification)
  private static final com.google.cloud.compute.v1.InterconnectOutageNotification DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectOutageNotification();
  }

  public static com.google.cloud.compute.v1.InterconnectOutageNotification getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectOutageNotification> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectOutageNotification>() {
        @java.lang.Override
        public InterconnectOutageNotification parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectOutageNotification> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectOutageNotification> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectOutageNotification getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
