/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Configuration for location policy among multiple possible locations (e.g. preferences for zone selection among zones in a single region).
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.LocationPolicy}
 */
public final class LocationPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.LocationPolicy)
    LocationPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LocationPolicy.newBuilder() to construct.
  private LocationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LocationPolicy() {
    targetShape_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LocationPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_LocationPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 413423454:
        return internalGetLocations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_LocationPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.LocationPolicy.class,
            com.google.cloud.compute.v1.LocationPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Strategy for distributing VMs across zones in a region.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.LocationPolicy.TargetShape}
   */
  public enum TargetShape implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TARGET_SHAPE = 0;</code>
     */
    UNDEFINED_TARGET_SHAPE(0),
    /**
     *
     *
     * <pre>
     * GCE picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
     * </pre>
     *
     * <code>ANY = 64972;</code>
     */
    ANY(64972),
    /**
     *
     *
     * <pre>
     * GCE always selects a single zone for all the VMs, optimizing for resource quotas, available reservations and general capacity. Recommended for batch workloads that cannot tollerate distribution over multiple zones. This the default shape in Bulk Insert and Capacity Advisor APIs.
     * </pre>
     *
     * <code>ANY_SINGLE_ZONE = 61100880;</code>
     */
    ANY_SINGLE_ZONE(61100880),
    /**
     *
     *
     * <pre>
     * GCE prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across allowed zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
     * </pre>
     *
     * <code>BALANCED = 468409608;</code>
     */
    BALANCED(468409608),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TARGET_SHAPE = 0;</code>
     */
    public static final int UNDEFINED_TARGET_SHAPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * GCE picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
     * </pre>
     *
     * <code>ANY = 64972;</code>
     */
    public static final int ANY_VALUE = 64972;
    /**
     *
     *
     * <pre>
     * GCE always selects a single zone for all the VMs, optimizing for resource quotas, available reservations and general capacity. Recommended for batch workloads that cannot tollerate distribution over multiple zones. This the default shape in Bulk Insert and Capacity Advisor APIs.
     * </pre>
     *
     * <code>ANY_SINGLE_ZONE = 61100880;</code>
     */
    public static final int ANY_SINGLE_ZONE_VALUE = 61100880;
    /**
     *
     *
     * <pre>
     * GCE prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across allowed zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
     * </pre>
     *
     * <code>BALANCED = 468409608;</code>
     */
    public static final int BALANCED_VALUE = 468409608;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetShape valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TargetShape forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TARGET_SHAPE;
        case 64972:
          return ANY;
        case 61100880:
          return ANY_SINGLE_ZONE;
        case 468409608:
          return BALANCED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TargetShape> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TargetShape> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TargetShape>() {
          public TargetShape findValueByNumber(int number) {
            return TargetShape.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.LocationPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final TargetShape[] VALUES = values();

    public static TargetShape valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TargetShape(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.LocationPolicy.TargetShape)
  }

  private int bitField0_;
  public static final int LOCATIONS_FIELD_NUMBER = 413423454;

  private static final class LocationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_LocationPolicy_LocationsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.LocationPolicyLocation.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
      locations_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
      internalGetLocations() {
    if (locations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LocationsDefaultEntryHolder.defaultEntry);
    }
    return locations_;
  }

  public int getLocationsCount() {
    return internalGetLocations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public boolean containsLocations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLocations().getMap().containsKey(key);
  }
  /** Use {@link #getLocationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
      getLocations() {
    return getLocationsMap();
  }
  /**
   *
   *
   * <pre>
   * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
      getLocationsMap() {
    return internalGetLocations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.LocationPolicyLocation getLocationsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.compute.v1.LocationPolicyLocation defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation> map =
        internalGetLocations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LocationPolicyLocation getLocationsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation> map =
        internalGetLocations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TARGET_SHAPE_FIELD_NUMBER = 338621299;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetShape_ = "";
  /**
   *
   *
   * <pre>
   * Strategy for distributing VMs across zones in a region.
   * Check the TargetShape enum for the list of possible values.
   * </pre>
   *
   * <code>optional string target_shape = 338621299;</code>
   *
   * @return Whether the targetShape field is set.
   */
  @java.lang.Override
  public boolean hasTargetShape() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Strategy for distributing VMs across zones in a region.
   * Check the TargetShape enum for the list of possible values.
   * </pre>
   *
   * <code>optional string target_shape = 338621299;</code>
   *
   * @return The targetShape.
   */
  @java.lang.Override
  public java.lang.String getTargetShape() {
    java.lang.Object ref = targetShape_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetShape_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Strategy for distributing VMs across zones in a region.
   * Check the TargetShape enum for the list of possible values.
   * </pre>
   *
   * <code>optional string target_shape = 338621299;</code>
   *
   * @return The bytes for targetShape.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetShapeBytes() {
    java.lang.Object ref = targetShape_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetShape_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 338621299, targetShape_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLocations(), LocationsDefaultEntryHolder.defaultEntry, 413423454);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(338621299, targetShape_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
        entry : internalGetLocations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
          locations__ =
              LocationsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(413423454, locations__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.LocationPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.LocationPolicy other =
        (com.google.cloud.compute.v1.LocationPolicy) obj;

    if (!internalGetLocations().equals(other.internalGetLocations())) return false;
    if (hasTargetShape() != other.hasTargetShape()) return false;
    if (hasTargetShape()) {
      if (!getTargetShape().equals(other.getTargetShape())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetLocations().getMap().isEmpty()) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLocations().hashCode();
    }
    if (hasTargetShape()) {
      hash = (37 * hash) + TARGET_SHAPE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetShape().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.LocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.LocationPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for location policy among multiple possible locations (e.g. preferences for zone selection among zones in a single region).
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.LocationPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.LocationPolicy)
      com.google.cloud.compute.v1.LocationPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_LocationPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 413423454:
          return internalGetLocations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 413423454:
          return internalGetMutableLocations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_LocationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.LocationPolicy.class,
              com.google.cloud.compute.v1.LocationPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.LocationPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableLocations().clear();
      targetShape_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_LocationPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.LocationPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.LocationPolicy build() {
      com.google.cloud.compute.v1.LocationPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.LocationPolicy buildPartial() {
      com.google.cloud.compute.v1.LocationPolicy result =
          new com.google.cloud.compute.v1.LocationPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.LocationPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.locations_ = internalGetLocations().build(LocationsDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.targetShape_ = targetShape_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.LocationPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.LocationPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.LocationPolicy other) {
      if (other == com.google.cloud.compute.v1.LocationPolicy.getDefaultInstance()) return this;
      internalGetMutableLocations().mergeFrom(other.internalGetLocations());
      bitField0_ |= 0x00000001;
      if (other.hasTargetShape()) {
        targetShape_ = other.targetShape_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case -1585996902:
              {
                targetShape_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1585996902
            case -987579662:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
                    locations__ =
                        input.readMessage(
                            LocationsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableLocations()
                    .ensureBuilderMap()
                    .put(locations__.getKey(), locations__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case -987579662
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private static final class LocationsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder,
            com.google.cloud.compute.v1.LocationPolicyLocation> {
      @java.lang.Override
      public com.google.cloud.compute.v1.LocationPolicyLocation build(
          com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.LocationPolicyLocation) {
          return (com.google.cloud.compute.v1.LocationPolicyLocation) val;
        }
        return ((com.google.cloud.compute.v1.LocationPolicyLocation.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
          defaultEntry() {
        return LocationsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final LocationsConverter locationsConverter = new LocationsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder,
            com.google.cloud.compute.v1.LocationPolicyLocation,
            com.google.cloud.compute.v1.LocationPolicyLocation.Builder>
        locations_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder,
            com.google.cloud.compute.v1.LocationPolicyLocation,
            com.google.cloud.compute.v1.LocationPolicyLocation.Builder>
        internalGetLocations() {
      if (locations_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(locationsConverter);
      }
      return locations_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder,
            com.google.cloud.compute.v1.LocationPolicyLocation,
            com.google.cloud.compute.v1.LocationPolicyLocation.Builder>
        internalGetMutableLocations() {
      if (locations_ == null) {
        locations_ = new com.google.protobuf.MapFieldBuilder<>(locationsConverter);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return locations_;
    }

    public int getLocationsCount() {
      return internalGetLocations().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public boolean containsLocations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLocations().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getLocationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
        getLocations() {
      return getLocationsMap();
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
        getLocationsMap() {
      return internalGetLocations().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.LocationPolicyLocation getLocationsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.compute.v1.LocationPolicyLocation defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder>
          map = internalGetMutableLocations().ensureBuilderMap();
      return map.containsKey(key) ? locationsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.LocationPolicyLocation getLocationsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder>
          map = internalGetMutableLocations().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return locationsConverter.build(map.get(key));
    }

    public Builder clearLocations() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableLocations().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    public Builder removeLocations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLocations().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
        getMutableLocations() {
      bitField0_ |= 0x00000001;
      return internalGetMutableLocations().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    public Builder putLocations(
        java.lang.String key, com.google.cloud.compute.v1.LocationPolicyLocation value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLocations().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    public Builder putAllLocations(
        java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
            values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocation>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableLocations().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.LocationPolicyLocation&gt; locations = 413423454;
     * </code>
     */
    public com.google.cloud.compute.v1.LocationPolicyLocation.Builder putLocationsBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder>
          builderMap = internalGetMutableLocations().ensureBuilderMap();
      com.google.cloud.compute.v1.LocationPolicyLocationOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.LocationPolicyLocation.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.LocationPolicyLocation) {
        entry = ((com.google.cloud.compute.v1.LocationPolicyLocation) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.LocationPolicyLocation.Builder) entry;
    }

    private java.lang.Object targetShape_ = "";
    /**
     *
     *
     * <pre>
     * Strategy for distributing VMs across zones in a region.
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return Whether the targetShape field is set.
     */
    public boolean hasTargetShape() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Strategy for distributing VMs across zones in a region.
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return The targetShape.
     */
    public java.lang.String getTargetShape() {
      java.lang.Object ref = targetShape_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetShape_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Strategy for distributing VMs across zones in a region.
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return The bytes for targetShape.
     */
    public com.google.protobuf.ByteString getTargetShapeBytes() {
      java.lang.Object ref = targetShape_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetShape_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Strategy for distributing VMs across zones in a region.
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @param value The targetShape to set.
     * @return This builder for chaining.
     */
    public Builder setTargetShape(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetShape_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strategy for distributing VMs across zones in a region.
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetShape() {
      targetShape_ = getDefaultInstance().getTargetShape();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strategy for distributing VMs across zones in a region.
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @param value The bytes for targetShape to set.
     * @return This builder for chaining.
     */
    public Builder setTargetShapeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetShape_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.LocationPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.LocationPolicy)
  private static final com.google.cloud.compute.v1.LocationPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.LocationPolicy();
  }

  public static com.google.cloud.compute.v1.LocationPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LocationPolicy> PARSER =
      new com.google.protobuf.AbstractParser<LocationPolicy>() {
        @java.lang.Override
        public LocationPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LocationPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LocationPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.LocationPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
