/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A Managed Instance resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ManagedInstance}
 */
public final class ManagedInstance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ManagedInstance)
    ManagedInstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ManagedInstance.newBuilder() to construct.
  private ManagedInstance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ManagedInstance() {
    currentAction_ = "";
    instance_ = "";
    instanceHealth_ = java.util.Collections.emptyList();
    instanceStatus_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ManagedInstance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ManagedInstance_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ManagedInstance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ManagedInstance.class,
            com.google.cloud.compute.v1.ManagedInstance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * STOPPING
   * SUSPENDING
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ManagedInstance.CurrentAction}
   */
  public enum CurrentAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CURRENT_ACTION = 0;</code>
     */
    UNDEFINED_CURRENT_ACTION(0),
    /**
     *
     *
     * <pre>
     * The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
     * </pre>
     *
     * <code>ABANDONING = 388244813;</code>
     */
    ABANDONING(388244813),
    /**
     *
     *
     * <pre>
     * The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
     * </pre>
     *
     * <code>CREATING_WITHOUT_RETRIES = 428843785;</code>
     */
    CREATING_WITHOUT_RETRIES(428843785),
    /**
     *
     *
     * <pre>
     * The managed instance group is permanently deleting this instance.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * The managed instance group has not scheduled any actions for this instance.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    /**
     *
     *
     * <pre>
     * The managed instance group is recreating this instance.
     * </pre>
     *
     * <code>RECREATING = 287278572;</code>
     */
    RECREATING(287278572),
    /**
     *
     *
     * <pre>
     * The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
     * </pre>
     *
     * <code>REFRESHING = 163266343;</code>
     */
    REFRESHING(163266343),
    /**
     *
     *
     * <pre>
     * The managed instance group is restarting this instance.
     * </pre>
     *
     * <code>RESTARTING = 320534387;</code>
     */
    RESTARTING(320534387),
    /**
     *
     *
     * <pre>
     * The managed instance group is resuming this instance.
     * </pre>
     *
     * <code>RESUMING = 446856618;</code>
     */
    RESUMING(446856618),
    /**
     *
     *
     * <pre>
     * The managed instance group is starting this instance.
     * </pre>
     *
     * <code>STARTING = 488820800;</code>
     */
    STARTING(488820800),
    /**
     *
     *
     * <pre>
     * The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
     * </pre>
     *
     * <code>VERIFYING = 16982185;</code>
     */
    VERIFYING(16982185),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CURRENT_ACTION = 0;</code>
     */
    public static final int UNDEFINED_CURRENT_ACTION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
     * </pre>
     *
     * <code>ABANDONING = 388244813;</code>
     */
    public static final int ABANDONING_VALUE = 388244813;
    /**
     *
     *
     * <pre>
     * The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;
    /**
     *
     *
     * <pre>
     * The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
     * </pre>
     *
     * <code>CREATING_WITHOUT_RETRIES = 428843785;</code>
     */
    public static final int CREATING_WITHOUT_RETRIES_VALUE = 428843785;
    /**
     *
     *
     * <pre>
     * The managed instance group is permanently deleting this instance.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;
    /**
     *
     *
     * <pre>
     * The managed instance group has not scheduled any actions for this instance.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;
    /**
     *
     *
     * <pre>
     * The managed instance group is recreating this instance.
     * </pre>
     *
     * <code>RECREATING = 287278572;</code>
     */
    public static final int RECREATING_VALUE = 287278572;
    /**
     *
     *
     * <pre>
     * The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
     * </pre>
     *
     * <code>REFRESHING = 163266343;</code>
     */
    public static final int REFRESHING_VALUE = 163266343;
    /**
     *
     *
     * <pre>
     * The managed instance group is restarting this instance.
     * </pre>
     *
     * <code>RESTARTING = 320534387;</code>
     */
    public static final int RESTARTING_VALUE = 320534387;
    /**
     *
     *
     * <pre>
     * The managed instance group is resuming this instance.
     * </pre>
     *
     * <code>RESUMING = 446856618;</code>
     */
    public static final int RESUMING_VALUE = 446856618;
    /**
     *
     *
     * <pre>
     * The managed instance group is starting this instance.
     * </pre>
     *
     * <code>STARTING = 488820800;</code>
     */
    public static final int STARTING_VALUE = 488820800;
    /**
     *
     *
     * <pre>
     * The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
     * </pre>
     *
     * <code>VERIFYING = 16982185;</code>
     */
    public static final int VERIFYING_VALUE = 16982185;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CurrentAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CurrentAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CURRENT_ACTION;
        case 388244813:
          return ABANDONING;
        case 455564985:
          return CREATING;
        case 428843785:
          return CREATING_WITHOUT_RETRIES;
        case 528602024:
          return DELETING;
        case 2402104:
          return NONE;
        case 287278572:
          return RECREATING;
        case 163266343:
          return REFRESHING;
        case 320534387:
          return RESTARTING;
        case 446856618:
          return RESUMING;
        case 488820800:
          return STARTING;
        case 16982185:
          return VERIFYING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CurrentAction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CurrentAction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CurrentAction>() {
          public CurrentAction findValueByNumber(int number) {
            return CurrentAction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ManagedInstance.getDescriptor().getEnumTypes().get(0);
    }

    private static final CurrentAction[] VALUES = values();

    public static CurrentAction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CurrentAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ManagedInstance.CurrentAction)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. This field is empty when the instance does not exist.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * STOPPING
   * SUSPENDING
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ManagedInstance.InstanceStatus}
   */
  public enum InstanceStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANCE_STATUS = 0;</code>
     */
    UNDEFINED_INSTANCE_STATUS(0),
    /**
     *
     *
     * <pre>
     * The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    DEPROVISIONING(428935662),
    /**
     *
     *
     * <pre>
     * Resources are being allocated for the instance.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    PROVISIONING(290896621),
    /**
     *
     *
     * <pre>
     * The instance is in repair.
     * </pre>
     *
     * <code>REPAIRING = 413483285;</code>
     */
    REPAIRING(413483285),
    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>RUNNING = 121282975;</code>
     */
    RUNNING(121282975),
    /**
     *
     *
     * <pre>
     * All required resources have been allocated and the instance is being started.
     * </pre>
     *
     * <code>STAGING = 431072283;</code>
     */
    STAGING(431072283),
    /**
     *
     *
     * <pre>
     * The instance has stopped successfully.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    STOPPED(444276141),
    /** <code>STOPPING = 350791796;</code> */
    STOPPING(350791796),
    /**
     *
     *
     * <pre>
     * The instance has suspended.
     * </pre>
     *
     * <code>SUSPENDED = 51223995;</code>
     */
    SUSPENDED(51223995),
    /** <code>SUSPENDING = 514206246;</code> */
    SUSPENDING(514206246),
    /**
     *
     *
     * <pre>
     * The instance has stopped (either by explicit action or underlying failure).
     * </pre>
     *
     * <code>TERMINATED = 250018339;</code>
     */
    TERMINATED(250018339),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANCE_STATUS = 0;</code>
     */
    public static final int UNDEFINED_INSTANCE_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    public static final int DEPROVISIONING_VALUE = 428935662;
    /**
     *
     *
     * <pre>
     * Resources are being allocated for the instance.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    public static final int PROVISIONING_VALUE = 290896621;
    /**
     *
     *
     * <pre>
     * The instance is in repair.
     * </pre>
     *
     * <code>REPAIRING = 413483285;</code>
     */
    public static final int REPAIRING_VALUE = 413483285;
    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>RUNNING = 121282975;</code>
     */
    public static final int RUNNING_VALUE = 121282975;
    /**
     *
     *
     * <pre>
     * All required resources have been allocated and the instance is being started.
     * </pre>
     *
     * <code>STAGING = 431072283;</code>
     */
    public static final int STAGING_VALUE = 431072283;
    /**
     *
     *
     * <pre>
     * The instance has stopped successfully.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    public static final int STOPPED_VALUE = 444276141;
    /** <code>STOPPING = 350791796;</code> */
    public static final int STOPPING_VALUE = 350791796;
    /**
     *
     *
     * <pre>
     * The instance has suspended.
     * </pre>
     *
     * <code>SUSPENDED = 51223995;</code>
     */
    public static final int SUSPENDED_VALUE = 51223995;
    /** <code>SUSPENDING = 514206246;</code> */
    public static final int SUSPENDING_VALUE = 514206246;
    /**
     *
     *
     * <pre>
     * The instance has stopped (either by explicit action or underlying failure).
     * </pre>
     *
     * <code>TERMINATED = 250018339;</code>
     */
    public static final int TERMINATED_VALUE = 250018339;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstanceStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InstanceStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INSTANCE_STATUS;
        case 428935662:
          return DEPROVISIONING;
        case 290896621:
          return PROVISIONING;
        case 413483285:
          return REPAIRING;
        case 121282975:
          return RUNNING;
        case 431072283:
          return STAGING;
        case 444276141:
          return STOPPED;
        case 350791796:
          return STOPPING;
        case 51223995:
          return SUSPENDED;
        case 514206246:
          return SUSPENDING;
        case 250018339:
          return TERMINATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InstanceStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InstanceStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<InstanceStatus>() {
          public InstanceStatus findValueByNumber(int number) {
            return InstanceStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ManagedInstance.getDescriptor().getEnumTypes().get(1);
    }

    private static final InstanceStatus[] VALUES = values();

    public static InstanceStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InstanceStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ManagedInstance.InstanceStatus)
  }

  private int bitField0_;
  public static final int CURRENT_ACTION_FIELD_NUMBER = 178475964;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentAction_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
   * Check the CurrentAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string current_action = 178475964;</code>
   *
   * @return Whether the currentAction field is set.
   */
  @java.lang.Override
  public boolean hasCurrentAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
   * Check the CurrentAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string current_action = 178475964;</code>
   *
   * @return The currentAction.
   */
  @java.lang.Override
  public java.lang.String getCurrentAction() {
    java.lang.Object ref = currentAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
   * Check the CurrentAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string current_action = 178475964;</code>
   *
   * @return The bytes for currentAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentActionBytes() {
    java.lang.Object ref = currentAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INSTANCE_FIELD_NUMBER = 18257045;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_HEALTH_FIELD_NUMBER = 382667078;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ManagedInstanceInstanceHealth> instanceHealth_;
  /**
   *
   *
   * <pre>
   * [Output Only] Health state of the instance per health-check.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ManagedInstanceInstanceHealth>
      getInstanceHealthList() {
    return instanceHealth_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Health state of the instance per health-check.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder>
      getInstanceHealthOrBuilderList() {
    return instanceHealth_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Health state of the instance per health-check.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
   * </code>
   */
  @java.lang.Override
  public int getInstanceHealthCount() {
    return instanceHealth_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Health state of the instance per health-check.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceInstanceHealth getInstanceHealth(int index) {
    return instanceHealth_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Health state of the instance per health-check.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder
      getInstanceHealthOrBuilder(int index) {
    return instanceHealth_.get(index);
  }

  public static final int INSTANCE_STATUS_FIELD_NUMBER = 174577372;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceStatus_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. This field is empty when the instance does not exist.
   * Check the InstanceStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_status = 174577372;</code>
   *
   * @return Whether the instanceStatus field is set.
   */
  @java.lang.Override
  public boolean hasInstanceStatus() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. This field is empty when the instance does not exist.
   * Check the InstanceStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_status = 174577372;</code>
   *
   * @return The instanceStatus.
   */
  @java.lang.Override
  public java.lang.String getInstanceStatus() {
    java.lang.Object ref = instanceStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. This field is empty when the instance does not exist.
   * Check the InstanceStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_status = 174577372;</code>
   *
   * @return The bytes for instanceStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceStatusBytes() {
    java.lang.Object ref = instanceStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_ATTEMPT_FIELD_NUMBER = 434771492;
  private com.google.cloud.compute.v1.ManagedInstanceLastAttempt lastAttempt_;
  /**
   *
   *
   * <pre>
   * [Output Only] Information about the last attempt to create or delete the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
   * </code>
   *
   * @return Whether the lastAttempt field is set.
   */
  @java.lang.Override
  public boolean hasLastAttempt() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Information about the last attempt to create or delete the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
   * </code>
   *
   * @return The lastAttempt.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceLastAttempt getLastAttempt() {
    return lastAttempt_ == null
        ? com.google.cloud.compute.v1.ManagedInstanceLastAttempt.getDefaultInstance()
        : lastAttempt_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Information about the last attempt to create or delete the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceLastAttemptOrBuilder getLastAttemptOrBuilder() {
    return lastAttempt_ == null
        ? com.google.cloud.compute.v1.ManagedInstanceLastAttempt.getDefaultInstance()
        : lastAttempt_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRESERVED_STATE_FROM_CONFIG_FIELD_NUMBER = 98661858;
  private com.google.cloud.compute.v1.PreservedState preservedStateFromConfig_;
  /**
   *
   *
   * <pre>
   * [Output Only] Preserved state applied from per-instance config for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
   * </code>
   *
   * @return Whether the preservedStateFromConfig field is set.
   */
  @java.lang.Override
  public boolean hasPreservedStateFromConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Preserved state applied from per-instance config for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
   * </code>
   *
   * @return The preservedStateFromConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PreservedState getPreservedStateFromConfig() {
    return preservedStateFromConfig_ == null
        ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
        : preservedStateFromConfig_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Preserved state applied from per-instance config for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PreservedStateOrBuilder
      getPreservedStateFromConfigOrBuilder() {
    return preservedStateFromConfig_ == null
        ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
        : preservedStateFromConfig_;
  }

  public static final int PRESERVED_STATE_FROM_POLICY_FIELD_NUMBER = 470783954;
  private com.google.cloud.compute.v1.PreservedState preservedStateFromPolicy_;
  /**
   *
   *
   * <pre>
   * [Output Only] Preserved state generated based on stateful policy for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
   * </code>
   *
   * @return Whether the preservedStateFromPolicy field is set.
   */
  @java.lang.Override
  public boolean hasPreservedStateFromPolicy() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Preserved state generated based on stateful policy for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
   * </code>
   *
   * @return The preservedStateFromPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PreservedState getPreservedStateFromPolicy() {
    return preservedStateFromPolicy_ == null
        ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
        : preservedStateFromPolicy_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Preserved state generated based on stateful policy for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PreservedStateOrBuilder
      getPreservedStateFromPolicyOrBuilder() {
    return preservedStateFromPolicy_ == null
        ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
        : preservedStateFromPolicy_;
  }

  public static final int VERSION_FIELD_NUMBER = 351608024;
  private com.google.cloud.compute.v1.ManagedInstanceVersion version_;
  /**
   *
   *
   * <pre>
   * [Output Only] Intended version of this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
   *
   * @return Whether the version field is set.
   */
  @java.lang.Override
  public boolean hasVersion() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Intended version of this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceVersion getVersion() {
    return version_ == null
        ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
        : version_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Intended version of this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder getVersionOrBuilder() {
    return version_ == null
        ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
        : version_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18257045, instance_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(98661858, getPreservedStateFromConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 174577372, instanceStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178475964, currentAction_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(351608024, getVersion());
    }
    for (int i = 0; i < instanceHealth_.size(); i++) {
      output.writeMessage(382667078, instanceHealth_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(434771492, getLastAttempt());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(470783954, getPreservedStateFromPolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18257045, instance_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              98661858, getPreservedStateFromConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(174577372, instanceStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(178475964, currentAction_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351608024, getVersion());
    }
    for (int i = 0; i < instanceHealth_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              382667078, instanceHealth_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(434771492, getLastAttempt());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              470783954, getPreservedStateFromPolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ManagedInstance)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ManagedInstance other =
        (com.google.cloud.compute.v1.ManagedInstance) obj;

    if (hasCurrentAction() != other.hasCurrentAction()) return false;
    if (hasCurrentAction()) {
      if (!getCurrentAction().equals(other.getCurrentAction())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (!getInstanceHealthList().equals(other.getInstanceHealthList())) return false;
    if (hasInstanceStatus() != other.hasInstanceStatus()) return false;
    if (hasInstanceStatus()) {
      if (!getInstanceStatus().equals(other.getInstanceStatus())) return false;
    }
    if (hasLastAttempt() != other.hasLastAttempt()) return false;
    if (hasLastAttempt()) {
      if (!getLastAttempt().equals(other.getLastAttempt())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPreservedStateFromConfig() != other.hasPreservedStateFromConfig()) return false;
    if (hasPreservedStateFromConfig()) {
      if (!getPreservedStateFromConfig().equals(other.getPreservedStateFromConfig())) return false;
    }
    if (hasPreservedStateFromPolicy() != other.hasPreservedStateFromPolicy()) return false;
    if (hasPreservedStateFromPolicy()) {
      if (!getPreservedStateFromPolicy().equals(other.getPreservedStateFromPolicy())) return false;
    }
    if (hasVersion() != other.hasVersion()) return false;
    if (hasVersion()) {
      if (!getVersion().equals(other.getVersion())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCurrentAction()) {
      hash = (37 * hash) + CURRENT_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentAction().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    if (getInstanceHealthCount() > 0) {
      hash = (37 * hash) + INSTANCE_HEALTH_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceHealthList().hashCode();
    }
    if (hasInstanceStatus()) {
      hash = (37 * hash) + INSTANCE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceStatus().hashCode();
    }
    if (hasLastAttempt()) {
      hash = (37 * hash) + LAST_ATTEMPT_FIELD_NUMBER;
      hash = (53 * hash) + getLastAttempt().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPreservedStateFromConfig()) {
      hash = (37 * hash) + PRESERVED_STATE_FROM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPreservedStateFromConfig().hashCode();
    }
    if (hasPreservedStateFromPolicy()) {
      hash = (37 * hash) + PRESERVED_STATE_FROM_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getPreservedStateFromPolicy().hashCode();
    }
    if (hasVersion()) {
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ManagedInstance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ManagedInstance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Managed Instance resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ManagedInstance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ManagedInstance)
      com.google.cloud.compute.v1.ManagedInstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ManagedInstance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ManagedInstance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ManagedInstance.class,
              com.google.cloud.compute.v1.ManagedInstance.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ManagedInstance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstanceHealthFieldBuilder();
        getLastAttemptFieldBuilder();
        getPreservedStateFromConfigFieldBuilder();
        getPreservedStateFromPolicyFieldBuilder();
        getVersionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      currentAction_ = "";
      id_ = 0L;
      instance_ = "";
      if (instanceHealthBuilder_ == null) {
        instanceHealth_ = java.util.Collections.emptyList();
      } else {
        instanceHealth_ = null;
        instanceHealthBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      instanceStatus_ = "";
      lastAttempt_ = null;
      if (lastAttemptBuilder_ != null) {
        lastAttemptBuilder_.dispose();
        lastAttemptBuilder_ = null;
      }
      name_ = "";
      preservedStateFromConfig_ = null;
      if (preservedStateFromConfigBuilder_ != null) {
        preservedStateFromConfigBuilder_.dispose();
        preservedStateFromConfigBuilder_ = null;
      }
      preservedStateFromPolicy_ = null;
      if (preservedStateFromPolicyBuilder_ != null) {
        preservedStateFromPolicyBuilder_.dispose();
        preservedStateFromPolicyBuilder_ = null;
      }
      version_ = null;
      if (versionBuilder_ != null) {
        versionBuilder_.dispose();
        versionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ManagedInstance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ManagedInstance getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ManagedInstance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ManagedInstance build() {
      com.google.cloud.compute.v1.ManagedInstance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ManagedInstance buildPartial() {
      com.google.cloud.compute.v1.ManagedInstance result =
          new com.google.cloud.compute.v1.ManagedInstance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.ManagedInstance result) {
      if (instanceHealthBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          instanceHealth_ = java.util.Collections.unmodifiableList(instanceHealth_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.instanceHealth_ = instanceHealth_;
      } else {
        result.instanceHealth_ = instanceHealthBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.ManagedInstance result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.currentAction_ = currentAction_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.instance_ = instance_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.instanceStatus_ = instanceStatus_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lastAttempt_ =
            lastAttemptBuilder_ == null ? lastAttempt_ : lastAttemptBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.preservedStateFromConfig_ =
            preservedStateFromConfigBuilder_ == null
                ? preservedStateFromConfig_
                : preservedStateFromConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.preservedStateFromPolicy_ =
            preservedStateFromPolicyBuilder_ == null
                ? preservedStateFromPolicy_
                : preservedStateFromPolicyBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.version_ = versionBuilder_ == null ? version_ : versionBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ManagedInstance) {
        return mergeFrom((com.google.cloud.compute.v1.ManagedInstance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ManagedInstance other) {
      if (other == com.google.cloud.compute.v1.ManagedInstance.getDefaultInstance()) return this;
      if (other.hasCurrentAction()) {
        currentAction_ = other.currentAction_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInstance()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (instanceHealthBuilder_ == null) {
        if (!other.instanceHealth_.isEmpty()) {
          if (instanceHealth_.isEmpty()) {
            instanceHealth_ = other.instanceHealth_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureInstanceHealthIsMutable();
            instanceHealth_.addAll(other.instanceHealth_);
          }
          onChanged();
        }
      } else {
        if (!other.instanceHealth_.isEmpty()) {
          if (instanceHealthBuilder_.isEmpty()) {
            instanceHealthBuilder_.dispose();
            instanceHealthBuilder_ = null;
            instanceHealth_ = other.instanceHealth_;
            bitField0_ = (bitField0_ & ~0x00000008);
            instanceHealthBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstanceHealthFieldBuilder()
                    : null;
          } else {
            instanceHealthBuilder_.addAllMessages(other.instanceHealth_);
          }
        }
      }
      if (other.hasInstanceStatus()) {
        instanceStatus_ = other.instanceStatus_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasLastAttempt()) {
        mergeLastAttempt(other.getLastAttempt());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasPreservedStateFromConfig()) {
        mergePreservedStateFromConfig(other.getPreservedStateFromConfig());
      }
      if (other.hasPreservedStateFromPolicy()) {
        mergePreservedStateFromPolicy(other.getPreservedStateFromPolicy());
      }
      if (other.hasVersion()) {
        mergeVersion(other.getVersion());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 26840
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26989658
            case 146056362:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 146056362
            case 789294866:
              {
                input.readMessage(
                    getPreservedStateFromConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 789294866
            case 1396618978:
              {
                instanceStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1396618978
            case 1427807714:
              {
                currentAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1427807714
            case -1482103102:
              {
                input.readMessage(getVersionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case -1482103102
            case -1233630670:
              {
                com.google.cloud.compute.v1.ManagedInstanceInstanceHealth m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.parser(),
                        extensionRegistry);
                if (instanceHealthBuilder_ == null) {
                  ensureInstanceHealthIsMutable();
                  instanceHealth_.add(m);
                } else {
                  instanceHealthBuilder_.addMessage(m);
                }
                break;
              } // case -1233630670
            case -816795358:
              {
                input.readMessage(getLastAttemptFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -816795358
            case -528695662:
              {
                input.readMessage(
                    getPreservedStateFromPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case -528695662
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object currentAction_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
     * Check the CurrentAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string current_action = 178475964;</code>
     *
     * @return Whether the currentAction field is set.
     */
    public boolean hasCurrentAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
     * Check the CurrentAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string current_action = 178475964;</code>
     *
     * @return The currentAction.
     */
    public java.lang.String getCurrentAction() {
      java.lang.Object ref = currentAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
     * Check the CurrentAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string current_action = 178475964;</code>
     *
     * @return The bytes for currentAction.
     */
    public com.google.protobuf.ByteString getCurrentActionBytes() {
      java.lang.Object ref = currentAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
     * Check the CurrentAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string current_action = 178475964;</code>
     *
     * @param value The currentAction to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentAction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
     * Check the CurrentAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string current_action = 178475964;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentAction() {
      currentAction_ = getDefaultInstance().getCurrentAction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
     * Check the CurrentAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string current_action = 178475964;</code>
     *
     * @param value The bytes for currentAction to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentAction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] The unique identifier for this resource. This field is empty when instance does not exist.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return Whether the instance field is set.
     */
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can exist even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.ManagedInstanceInstanceHealth>
        instanceHealth_ = java.util.Collections.emptyList();

    private void ensureInstanceHealthIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        instanceHealth_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ManagedInstanceInstanceHealth>(
                instanceHealth_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceInstanceHealth,
            com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder,
            com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder>
        instanceHealthBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ManagedInstanceInstanceHealth>
        getInstanceHealthList() {
      if (instanceHealthBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instanceHealth_);
      } else {
        return instanceHealthBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public int getInstanceHealthCount() {
      if (instanceHealthBuilder_ == null) {
        return instanceHealth_.size();
      } else {
        return instanceHealthBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceInstanceHealth getInstanceHealth(int index) {
      if (instanceHealthBuilder_ == null) {
        return instanceHealth_.get(index);
      } else {
        return instanceHealthBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder setInstanceHealth(
        int index, com.google.cloud.compute.v1.ManagedInstanceInstanceHealth value) {
      if (instanceHealthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceHealthIsMutable();
        instanceHealth_.set(index, value);
        onChanged();
      } else {
        instanceHealthBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder setInstanceHealth(
        int index,
        com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder builderForValue) {
      if (instanceHealthBuilder_ == null) {
        ensureInstanceHealthIsMutable();
        instanceHealth_.set(index, builderForValue.build());
        onChanged();
      } else {
        instanceHealthBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder addInstanceHealth(
        com.google.cloud.compute.v1.ManagedInstanceInstanceHealth value) {
      if (instanceHealthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceHealthIsMutable();
        instanceHealth_.add(value);
        onChanged();
      } else {
        instanceHealthBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder addInstanceHealth(
        int index, com.google.cloud.compute.v1.ManagedInstanceInstanceHealth value) {
      if (instanceHealthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceHealthIsMutable();
        instanceHealth_.add(index, value);
        onChanged();
      } else {
        instanceHealthBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder addInstanceHealth(
        com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder builderForValue) {
      if (instanceHealthBuilder_ == null) {
        ensureInstanceHealthIsMutable();
        instanceHealth_.add(builderForValue.build());
        onChanged();
      } else {
        instanceHealthBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder addInstanceHealth(
        int index,
        com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder builderForValue) {
      if (instanceHealthBuilder_ == null) {
        ensureInstanceHealthIsMutable();
        instanceHealth_.add(index, builderForValue.build());
        onChanged();
      } else {
        instanceHealthBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder addAllInstanceHealth(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ManagedInstanceInstanceHealth>
            values) {
      if (instanceHealthBuilder_ == null) {
        ensureInstanceHealthIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceHealth_);
        onChanged();
      } else {
        instanceHealthBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder clearInstanceHealth() {
      if (instanceHealthBuilder_ == null) {
        instanceHealth_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        instanceHealthBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public Builder removeInstanceHealth(int index) {
      if (instanceHealthBuilder_ == null) {
        ensureInstanceHealthIsMutable();
        instanceHealth_.remove(index);
        onChanged();
      } else {
        instanceHealthBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder
        getInstanceHealthBuilder(int index) {
      return getInstanceHealthFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder
        getInstanceHealthOrBuilder(int index) {
      if (instanceHealthBuilder_ == null) {
        return instanceHealth_.get(index);
      } else {
        return instanceHealthBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder>
        getInstanceHealthOrBuilderList() {
      if (instanceHealthBuilder_ != null) {
        return instanceHealthBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instanceHealth_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder
        addInstanceHealthBuilder() {
      return getInstanceHealthFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder
        addInstanceHealthBuilder(int index) {
      return getInstanceHealthFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Health state of the instance per health-check.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ManagedInstanceInstanceHealth instance_health = 382667078;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder>
        getInstanceHealthBuilderList() {
      return getInstanceHealthFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceInstanceHealth,
            com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder,
            com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder>
        getInstanceHealthFieldBuilder() {
      if (instanceHealthBuilder_ == null) {
        instanceHealthBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ManagedInstanceInstanceHealth,
                com.google.cloud.compute.v1.ManagedInstanceInstanceHealth.Builder,
                com.google.cloud.compute.v1.ManagedInstanceInstanceHealthOrBuilder>(
                instanceHealth_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        instanceHealth_ = null;
      }
      return instanceHealthBuilder_;
    }

    private java.lang.Object instanceStatus_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. This field is empty when the instance does not exist.
     * Check the InstanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_status = 174577372;</code>
     *
     * @return Whether the instanceStatus field is set.
     */
    public boolean hasInstanceStatus() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. This field is empty when the instance does not exist.
     * Check the InstanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_status = 174577372;</code>
     *
     * @return The instanceStatus.
     */
    public java.lang.String getInstanceStatus() {
      java.lang.Object ref = instanceStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. This field is empty when the instance does not exist.
     * Check the InstanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_status = 174577372;</code>
     *
     * @return The bytes for instanceStatus.
     */
    public com.google.protobuf.ByteString getInstanceStatusBytes() {
      java.lang.Object ref = instanceStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. This field is empty when the instance does not exist.
     * Check the InstanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_status = 174577372;</code>
     *
     * @param value The instanceStatus to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceStatus_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. This field is empty when the instance does not exist.
     * Check the InstanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_status = 174577372;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceStatus() {
      instanceStatus_ = getDefaultInstance().getInstanceStatus();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. This field is empty when the instance does not exist.
     * Check the InstanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_status = 174577372;</code>
     *
     * @param value The bytes for instanceStatus to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceStatus_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ManagedInstanceLastAttempt lastAttempt_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceLastAttempt,
            com.google.cloud.compute.v1.ManagedInstanceLastAttempt.Builder,
            com.google.cloud.compute.v1.ManagedInstanceLastAttemptOrBuilder>
        lastAttemptBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     *
     * @return Whether the lastAttempt field is set.
     */
    public boolean hasLastAttempt() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     *
     * @return The lastAttempt.
     */
    public com.google.cloud.compute.v1.ManagedInstanceLastAttempt getLastAttempt() {
      if (lastAttemptBuilder_ == null) {
        return lastAttempt_ == null
            ? com.google.cloud.compute.v1.ManagedInstanceLastAttempt.getDefaultInstance()
            : lastAttempt_;
      } else {
        return lastAttemptBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    public Builder setLastAttempt(com.google.cloud.compute.v1.ManagedInstanceLastAttempt value) {
      if (lastAttemptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastAttempt_ = value;
      } else {
        lastAttemptBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    public Builder setLastAttempt(
        com.google.cloud.compute.v1.ManagedInstanceLastAttempt.Builder builderForValue) {
      if (lastAttemptBuilder_ == null) {
        lastAttempt_ = builderForValue.build();
      } else {
        lastAttemptBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    public Builder mergeLastAttempt(com.google.cloud.compute.v1.ManagedInstanceLastAttempt value) {
      if (lastAttemptBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && lastAttempt_ != null
            && lastAttempt_
                != com.google.cloud.compute.v1.ManagedInstanceLastAttempt.getDefaultInstance()) {
          getLastAttemptBuilder().mergeFrom(value);
        } else {
          lastAttempt_ = value;
        }
      } else {
        lastAttemptBuilder_.mergeFrom(value);
      }
      if (lastAttempt_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    public Builder clearLastAttempt() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lastAttempt_ = null;
      if (lastAttemptBuilder_ != null) {
        lastAttemptBuilder_.dispose();
        lastAttemptBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceLastAttempt.Builder getLastAttemptBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getLastAttemptFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceLastAttemptOrBuilder
        getLastAttemptOrBuilder() {
      if (lastAttemptBuilder_ != null) {
        return lastAttemptBuilder_.getMessageOrBuilder();
      } else {
        return lastAttempt_ == null
            ? com.google.cloud.compute.v1.ManagedInstanceLastAttempt.getDefaultInstance()
            : lastAttempt_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Information about the last attempt to create or delete the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceLastAttempt last_attempt = 434771492;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceLastAttempt,
            com.google.cloud.compute.v1.ManagedInstanceLastAttempt.Builder,
            com.google.cloud.compute.v1.ManagedInstanceLastAttemptOrBuilder>
        getLastAttemptFieldBuilder() {
      if (lastAttemptBuilder_ == null) {
        lastAttemptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ManagedInstanceLastAttempt,
                com.google.cloud.compute.v1.ManagedInstanceLastAttempt.Builder,
                com.google.cloud.compute.v1.ManagedInstanceLastAttemptOrBuilder>(
                getLastAttempt(), getParentForChildren(), isClean());
        lastAttempt_ = null;
      }
      return lastAttemptBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the instance. The name always exists even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.PreservedState preservedStateFromConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.PreservedState,
            com.google.cloud.compute.v1.PreservedState.Builder,
            com.google.cloud.compute.v1.PreservedStateOrBuilder>
        preservedStateFromConfigBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     *
     * @return Whether the preservedStateFromConfig field is set.
     */
    public boolean hasPreservedStateFromConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     *
     * @return The preservedStateFromConfig.
     */
    public com.google.cloud.compute.v1.PreservedState getPreservedStateFromConfig() {
      if (preservedStateFromConfigBuilder_ == null) {
        return preservedStateFromConfig_ == null
            ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
            : preservedStateFromConfig_;
      } else {
        return preservedStateFromConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    public Builder setPreservedStateFromConfig(com.google.cloud.compute.v1.PreservedState value) {
      if (preservedStateFromConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        preservedStateFromConfig_ = value;
      } else {
        preservedStateFromConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    public Builder setPreservedStateFromConfig(
        com.google.cloud.compute.v1.PreservedState.Builder builderForValue) {
      if (preservedStateFromConfigBuilder_ == null) {
        preservedStateFromConfig_ = builderForValue.build();
      } else {
        preservedStateFromConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    public Builder mergePreservedStateFromConfig(com.google.cloud.compute.v1.PreservedState value) {
      if (preservedStateFromConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && preservedStateFromConfig_ != null
            && preservedStateFromConfig_
                != com.google.cloud.compute.v1.PreservedState.getDefaultInstance()) {
          getPreservedStateFromConfigBuilder().mergeFrom(value);
        } else {
          preservedStateFromConfig_ = value;
        }
      } else {
        preservedStateFromConfigBuilder_.mergeFrom(value);
      }
      if (preservedStateFromConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    public Builder clearPreservedStateFromConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      preservedStateFromConfig_ = null;
      if (preservedStateFromConfigBuilder_ != null) {
        preservedStateFromConfigBuilder_.dispose();
        preservedStateFromConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    public com.google.cloud.compute.v1.PreservedState.Builder getPreservedStateFromConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPreservedStateFromConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    public com.google.cloud.compute.v1.PreservedStateOrBuilder
        getPreservedStateFromConfigOrBuilder() {
      if (preservedStateFromConfigBuilder_ != null) {
        return preservedStateFromConfigBuilder_.getMessageOrBuilder();
      } else {
        return preservedStateFromConfig_ == null
            ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
            : preservedStateFromConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state applied from per-instance config for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_config = 98661858;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.PreservedState,
            com.google.cloud.compute.v1.PreservedState.Builder,
            com.google.cloud.compute.v1.PreservedStateOrBuilder>
        getPreservedStateFromConfigFieldBuilder() {
      if (preservedStateFromConfigBuilder_ == null) {
        preservedStateFromConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.PreservedState,
                com.google.cloud.compute.v1.PreservedState.Builder,
                com.google.cloud.compute.v1.PreservedStateOrBuilder>(
                getPreservedStateFromConfig(), getParentForChildren(), isClean());
        preservedStateFromConfig_ = null;
      }
      return preservedStateFromConfigBuilder_;
    }

    private com.google.cloud.compute.v1.PreservedState preservedStateFromPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.PreservedState,
            com.google.cloud.compute.v1.PreservedState.Builder,
            com.google.cloud.compute.v1.PreservedStateOrBuilder>
        preservedStateFromPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     *
     * @return Whether the preservedStateFromPolicy field is set.
     */
    public boolean hasPreservedStateFromPolicy() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     *
     * @return The preservedStateFromPolicy.
     */
    public com.google.cloud.compute.v1.PreservedState getPreservedStateFromPolicy() {
      if (preservedStateFromPolicyBuilder_ == null) {
        return preservedStateFromPolicy_ == null
            ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
            : preservedStateFromPolicy_;
      } else {
        return preservedStateFromPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    public Builder setPreservedStateFromPolicy(com.google.cloud.compute.v1.PreservedState value) {
      if (preservedStateFromPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        preservedStateFromPolicy_ = value;
      } else {
        preservedStateFromPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    public Builder setPreservedStateFromPolicy(
        com.google.cloud.compute.v1.PreservedState.Builder builderForValue) {
      if (preservedStateFromPolicyBuilder_ == null) {
        preservedStateFromPolicy_ = builderForValue.build();
      } else {
        preservedStateFromPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    public Builder mergePreservedStateFromPolicy(com.google.cloud.compute.v1.PreservedState value) {
      if (preservedStateFromPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && preservedStateFromPolicy_ != null
            && preservedStateFromPolicy_
                != com.google.cloud.compute.v1.PreservedState.getDefaultInstance()) {
          getPreservedStateFromPolicyBuilder().mergeFrom(value);
        } else {
          preservedStateFromPolicy_ = value;
        }
      } else {
        preservedStateFromPolicyBuilder_.mergeFrom(value);
      }
      if (preservedStateFromPolicy_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    public Builder clearPreservedStateFromPolicy() {
      bitField0_ = (bitField0_ & ~0x00000100);
      preservedStateFromPolicy_ = null;
      if (preservedStateFromPolicyBuilder_ != null) {
        preservedStateFromPolicyBuilder_.dispose();
        preservedStateFromPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    public com.google.cloud.compute.v1.PreservedState.Builder getPreservedStateFromPolicyBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getPreservedStateFromPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    public com.google.cloud.compute.v1.PreservedStateOrBuilder
        getPreservedStateFromPolicyOrBuilder() {
      if (preservedStateFromPolicyBuilder_ != null) {
        return preservedStateFromPolicyBuilder_.getMessageOrBuilder();
      } else {
        return preservedStateFromPolicy_ == null
            ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
            : preservedStateFromPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Preserved state generated based on stateful policy for this instance.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.PreservedState preserved_state_from_policy = 470783954;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.PreservedState,
            com.google.cloud.compute.v1.PreservedState.Builder,
            com.google.cloud.compute.v1.PreservedStateOrBuilder>
        getPreservedStateFromPolicyFieldBuilder() {
      if (preservedStateFromPolicyBuilder_ == null) {
        preservedStateFromPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.PreservedState,
                com.google.cloud.compute.v1.PreservedState.Builder,
                com.google.cloud.compute.v1.PreservedStateOrBuilder>(
                getPreservedStateFromPolicy(), getParentForChildren(), isClean());
        preservedStateFromPolicy_ = null;
      }
      return preservedStateFromPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.ManagedInstanceVersion version_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceVersion,
            com.google.cloud.compute.v1.ManagedInstanceVersion.Builder,
            com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder>
        versionBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     *
     * @return Whether the version field is set.
     */
    public boolean hasVersion() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     *
     * @return The version.
     */
    public com.google.cloud.compute.v1.ManagedInstanceVersion getVersion() {
      if (versionBuilder_ == null) {
        return version_ == null
            ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
            : version_;
      } else {
        return versionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder setVersion(com.google.cloud.compute.v1.ManagedInstanceVersion value) {
      if (versionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
      } else {
        versionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder setVersion(
        com.google.cloud.compute.v1.ManagedInstanceVersion.Builder builderForValue) {
      if (versionBuilder_ == null) {
        version_ = builderForValue.build();
      } else {
        versionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder mergeVersion(com.google.cloud.compute.v1.ManagedInstanceVersion value) {
      if (versionBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && version_ != null
            && version_
                != com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()) {
          getVersionBuilder().mergeFrom(value);
        } else {
          version_ = value;
        }
      } else {
        versionBuilder_.mergeFrom(value);
      }
      if (version_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000200);
      version_ = null;
      if (versionBuilder_ != null) {
        versionBuilder_.dispose();
        versionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceVersion.Builder getVersionBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getVersionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder getVersionOrBuilder() {
      if (versionBuilder_ != null) {
        return versionBuilder_.getMessageOrBuilder();
      } else {
        return version_ == null
            ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
            : version_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Intended version of this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceVersion,
            com.google.cloud.compute.v1.ManagedInstanceVersion.Builder,
            com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder>
        getVersionFieldBuilder() {
      if (versionBuilder_ == null) {
        versionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ManagedInstanceVersion,
                com.google.cloud.compute.v1.ManagedInstanceVersion.Builder,
                com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder>(
                getVersion(), getParentForChildren(), isClean());
        version_ = null;
      }
      return versionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ManagedInstance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ManagedInstance)
  private static final com.google.cloud.compute.v1.ManagedInstance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ManagedInstance();
  }

  public static com.google.cloud.compute.v1.ManagedInstance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ManagedInstance> PARSER =
      new com.google.protobuf.AbstractParser<ManagedInstance>() {
        @java.lang.Override
        public ManagedInstance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ManagedInstance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ManagedInstance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
