/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a VPC Network resource. Networks connect resources to each other and to the internet. For more information, read Virtual Private Cloud (VPC) Network.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Network}
 */
public final class Network extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Network)
    NetworkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Network.newBuilder() to construct.
  private Network(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Network() {
    iPv4Range_ = "";
    creationTimestamp_ = "";
    description_ = "";
    firewallPolicy_ = "";
    gatewayIPv4_ = "";
    internalIpv6Range_ = "";
    kind_ = "";
    name_ = "";
    networkFirewallPolicyEnforcementOrder_ = "";
    peerings_ = java.util.Collections.emptyList();
    selfLink_ = "";
    selfLinkWithId_ = "";
    subnetworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Network();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Network_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Network_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Network.class,
            com.google.cloud.compute.v1.Network.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Network.NetworkFirewallPolicyEnforcementOrder}
   */
  public enum NetworkFirewallPolicyEnforcementOrder
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER = 0;</code>
     */
    UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER(0),
    /** <code>AFTER_CLASSIC_FIREWALL = 154582608;</code> */
    AFTER_CLASSIC_FIREWALL(154582608),
    /** <code>BEFORE_CLASSIC_FIREWALL = 338458349;</code> */
    BEFORE_CLASSIC_FIREWALL(338458349),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER = 0;</code>
     */
    public static final int UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER_VALUE = 0;
    /** <code>AFTER_CLASSIC_FIREWALL = 154582608;</code> */
    public static final int AFTER_CLASSIC_FIREWALL_VALUE = 154582608;
    /** <code>BEFORE_CLASSIC_FIREWALL = 338458349;</code> */
    public static final int BEFORE_CLASSIC_FIREWALL_VALUE = 338458349;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkFirewallPolicyEnforcementOrder valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NetworkFirewallPolicyEnforcementOrder forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER;
        case 154582608:
          return AFTER_CLASSIC_FIREWALL;
        case 338458349:
          return BEFORE_CLASSIC_FIREWALL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NetworkFirewallPolicyEnforcementOrder>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<
            NetworkFirewallPolicyEnforcementOrder>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NetworkFirewallPolicyEnforcementOrder>() {
              public NetworkFirewallPolicyEnforcementOrder findValueByNumber(int number) {
                return NetworkFirewallPolicyEnforcementOrder.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Network.getDescriptor().getEnumTypes().get(0);
    }

    private static final NetworkFirewallPolicyEnforcementOrder[] VALUES = values();

    public static NetworkFirewallPolicyEnforcementOrder valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NetworkFirewallPolicyEnforcementOrder(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Network.NetworkFirewallPolicyEnforcementOrder)
  }

  private int bitField0_;
  public static final int I_PV4_RANGE_FIELD_NUMBER = 59234358;

  @SuppressWarnings("serial")
  private volatile java.lang.Object iPv4Range_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
   * </pre>
   *
   * <code>optional string I_pv4_range = 59234358;</code>
   *
   * @return Whether the iPv4Range field is set.
   */
  @java.lang.Override
  public boolean hasIPv4Range() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
   * </pre>
   *
   * <code>optional string I_pv4_range = 59234358;</code>
   *
   * @return The iPv4Range.
   */
  @java.lang.Override
  public java.lang.String getIPv4Range() {
    java.lang.Object ref = iPv4Range_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      iPv4Range_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
   * </pre>
   *
   * <code>optional string I_pv4_range = 59234358;</code>
   *
   * @return The bytes for iPv4Range.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIPv4RangeBytes() {
    java.lang.Object ref = iPv4Range_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      iPv4Range_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTO_CREATE_SUBNETWORKS_FIELD_NUMBER = 256156690;
  private boolean autoCreateSubnetworks_ = false;
  /**
   *
   *
   * <pre>
   * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
   * </pre>
   *
   * <code>optional bool auto_create_subnetworks = 256156690;</code>
   *
   * @return Whether the autoCreateSubnetworks field is set.
   */
  @java.lang.Override
  public boolean hasAutoCreateSubnetworks() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
   * </pre>
   *
   * <code>optional bool auto_create_subnetworks = 256156690;</code>
   *
   * @return The autoCreateSubnetworks.
   */
  @java.lang.Override
  public boolean getAutoCreateSubnetworks() {
    return autoCreateSubnetworks_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_ULA_INTERNAL_IPV6_FIELD_NUMBER = 423757720;
  private boolean enableUlaInternalIpv6_ = false;
  /**
   *
   *
   * <pre>
   * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
   * </pre>
   *
   * <code>optional bool enable_ula_internal_ipv6 = 423757720;</code>
   *
   * @return Whether the enableUlaInternalIpv6 field is set.
   */
  @java.lang.Override
  public boolean hasEnableUlaInternalIpv6() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
   * </pre>
   *
   * <code>optional bool enable_ula_internal_ipv6 = 423757720;</code>
   *
   * @return The enableUlaInternalIpv6.
   */
  @java.lang.Override
  public boolean getEnableUlaInternalIpv6() {
    return enableUlaInternalIpv6_;
  }

  public static final int FIREWALL_POLICY_FIELD_NUMBER = 498173265;

  @SuppressWarnings("serial")
  private volatile java.lang.Object firewallPolicy_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the firewall policy the network is associated with.
   * </pre>
   *
   * <code>optional string firewall_policy = 498173265;</code>
   *
   * @return Whether the firewallPolicy field is set.
   */
  @java.lang.Override
  public boolean hasFirewallPolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the firewall policy the network is associated with.
   * </pre>
   *
   * <code>optional string firewall_policy = 498173265;</code>
   *
   * @return The firewallPolicy.
   */
  @java.lang.Override
  public java.lang.String getFirewallPolicy() {
    java.lang.Object ref = firewallPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      firewallPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the firewall policy the network is associated with.
   * </pre>
   *
   * <code>optional string firewall_policy = 498173265;</code>
   *
   * @return The bytes for firewallPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFirewallPolicyBytes() {
    java.lang.Object ref = firewallPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      firewallPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GATEWAY_I_PV4_FIELD_NUMBER = 178678877;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gatewayIPv4_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
   * </pre>
   *
   * <code>optional string gateway_i_pv4 = 178678877;</code>
   *
   * @return Whether the gatewayIPv4 field is set.
   */
  @java.lang.Override
  public boolean hasGatewayIPv4() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
   * </pre>
   *
   * <code>optional string gateway_i_pv4 = 178678877;</code>
   *
   * @return The gatewayIPv4.
   */
  @java.lang.Override
  public java.lang.String getGatewayIPv4() {
    java.lang.Object ref = gatewayIPv4_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gatewayIPv4_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
   * </pre>
   *
   * <code>optional string gateway_i_pv4 = 178678877;</code>
   *
   * @return The bytes for gatewayIPv4.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGatewayIPv4Bytes() {
    java.lang.Object ref = gatewayIPv4_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gatewayIPv4_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTERNAL_IPV6_RANGE_FIELD_NUMBER = 277456807;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalIpv6Range_ = "";
  /**
   *
   *
   * <pre>
   * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
   * </pre>
   *
   * <code>optional string internal_ipv6_range = 277456807;</code>
   *
   * @return Whether the internalIpv6Range field is set.
   */
  @java.lang.Override
  public boolean hasInternalIpv6Range() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
   * </pre>
   *
   * <code>optional string internal_ipv6_range = 277456807;</code>
   *
   * @return The internalIpv6Range.
   */
  @java.lang.Override
  public java.lang.String getInternalIpv6Range() {
    java.lang.Object ref = internalIpv6Range_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalIpv6Range_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
   * </pre>
   *
   * <code>optional string internal_ipv6_range = 277456807;</code>
   *
   * @return The bytes for internalIpv6Range.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalIpv6RangeBytes() {
    java.lang.Object ref = internalIpv6Range_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalIpv6Range_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#network for networks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#network for networks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#network for networks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MTU_FIELD_NUMBER = 108462;
  private int mtu_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
   * </pre>
   *
   * <code>optional int32 mtu = 108462;</code>
   *
   * @return Whether the mtu field is set.
   */
  @java.lang.Override
  public boolean hasMtu() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
   * </pre>
   *
   * <code>optional int32 mtu = 108462;</code>
   *
   * @return The mtu.
   */
  @java.lang.Override
  public int getMtu() {
    return mtu_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER_FIELD_NUMBER = 6504784;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkFirewallPolicyEnforcementOrder_ = "";
  /**
   *
   *
   * <pre>
   * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
   * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
   *
   * @return Whether the networkFirewallPolicyEnforcementOrder field is set.
   */
  @java.lang.Override
  public boolean hasNetworkFirewallPolicyEnforcementOrder() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
   * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
   *
   * @return The networkFirewallPolicyEnforcementOrder.
   */
  @java.lang.Override
  public java.lang.String getNetworkFirewallPolicyEnforcementOrder() {
    java.lang.Object ref = networkFirewallPolicyEnforcementOrder_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkFirewallPolicyEnforcementOrder_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
   * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
   *
   * @return The bytes for networkFirewallPolicyEnforcementOrder.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkFirewallPolicyEnforcementOrderBytes() {
    java.lang.Object ref = networkFirewallPolicyEnforcementOrder_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkFirewallPolicyEnforcementOrder_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEERINGS_FIELD_NUMBER = 69883187;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.NetworkPeering> peerings_;
  /**
   *
   *
   * <pre>
   * [Output Only] A list of network peerings for the resource.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.NetworkPeering> getPeeringsList() {
    return peerings_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of network peerings for the resource.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.NetworkPeeringOrBuilder>
      getPeeringsOrBuilderList() {
    return peerings_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of network peerings for the resource.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
   */
  @java.lang.Override
  public int getPeeringsCount() {
    return peerings_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of network peerings for the resource.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeering getPeerings(int index) {
    return peerings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of network peerings for the resource.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringOrBuilder getPeeringsOrBuilder(int index) {
    return peerings_.get(index);
  }

  public static final int ROUTING_CONFIG_FIELD_NUMBER = 523556059;
  private com.google.cloud.compute.v1.NetworkRoutingConfig routingConfig_;
  /**
   *
   *
   * <pre>
   * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;</code>
   *
   * @return Whether the routingConfig field is set.
   */
  @java.lang.Override
  public boolean hasRoutingConfig() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;</code>
   *
   * @return The routingConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkRoutingConfig getRoutingConfig() {
    return routingConfig_ == null
        ? com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance()
        : routingConfig_;
  }
  /**
   *
   *
   * <pre>
   * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkRoutingConfigOrBuilder getRoutingConfigOrBuilder() {
    return routingConfig_ == null
        ? com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance()
        : routingConfig_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_WITH_ID_FIELD_NUMBER = 44520962;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLinkWithId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return Whether the selfLinkWithId field is set.
   */
  @java.lang.Override
  public boolean hasSelfLinkWithId() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The selfLinkWithId.
   */
  @java.lang.Override
  public java.lang.String getSelfLinkWithId() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLinkWithId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The bytes for selfLinkWithId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLinkWithId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORKS_FIELD_NUMBER = 415853125;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subnetworks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
   * </pre>
   *
   * <code>repeated string subnetworks = 415853125;</code>
   *
   * @return A list containing the subnetworks.
   */
  public com.google.protobuf.ProtocolStringList getSubnetworksList() {
    return subnetworks_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
   * </pre>
   *
   * <code>repeated string subnetworks = 415853125;</code>
   *
   * @return The count of subnetworks.
   */
  public int getSubnetworksCount() {
    return subnetworks_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
   * </pre>
   *
   * <code>repeated string subnetworks = 415853125;</code>
   *
   * @param index The index of the element to return.
   * @return The subnetworks at the given index.
   */
  public java.lang.String getSubnetworks(int index) {
    return subnetworks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
   * </pre>
   *
   * <code>repeated string subnetworks = 415853125;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subnetworks at the given index.
   */
  public com.google.protobuf.ByteString getSubnetworksBytes(int index) {
    return subnetworks_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt32(108462, mtu_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 6504784, networkFirewallPolicyEnforcementOrder_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 44520962, selfLinkWithId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 59234358, iPv4Range_);
    }
    for (int i = 0; i < peerings_.size(); i++) {
      output.writeMessage(69883187, peerings_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178678877, gatewayIPv4_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(256156690, autoCreateSubnetworks_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 277456807, internalIpv6Range_);
    }
    for (int i = 0; i < subnetworks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 415853125, subnetworks_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(423757720, enableUlaInternalIpv6_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 498173265, firewallPolicy_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(523556059, getRoutingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(108462, mtu_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              6504784, networkFirewallPolicyEnforcementOrder_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(44520962, selfLinkWithId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(59234358, iPv4Range_);
    }
    for (int i = 0; i < peerings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(69883187, peerings_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(178678877, gatewayIPv4_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(256156690, autoCreateSubnetworks_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(277456807, internalIpv6Range_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subnetworks_.size(); i++) {
        dataSize += computeStringSizeNoTag(subnetworks_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSubnetworksList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(423757720, enableUlaInternalIpv6_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(498173265, firewallPolicy_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(523556059, getRoutingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Network)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Network other = (com.google.cloud.compute.v1.Network) obj;

    if (hasIPv4Range() != other.hasIPv4Range()) return false;
    if (hasIPv4Range()) {
      if (!getIPv4Range().equals(other.getIPv4Range())) return false;
    }
    if (hasAutoCreateSubnetworks() != other.hasAutoCreateSubnetworks()) return false;
    if (hasAutoCreateSubnetworks()) {
      if (getAutoCreateSubnetworks() != other.getAutoCreateSubnetworks()) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEnableUlaInternalIpv6() != other.hasEnableUlaInternalIpv6()) return false;
    if (hasEnableUlaInternalIpv6()) {
      if (getEnableUlaInternalIpv6() != other.getEnableUlaInternalIpv6()) return false;
    }
    if (hasFirewallPolicy() != other.hasFirewallPolicy()) return false;
    if (hasFirewallPolicy()) {
      if (!getFirewallPolicy().equals(other.getFirewallPolicy())) return false;
    }
    if (hasGatewayIPv4() != other.hasGatewayIPv4()) return false;
    if (hasGatewayIPv4()) {
      if (!getGatewayIPv4().equals(other.getGatewayIPv4())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInternalIpv6Range() != other.hasInternalIpv6Range()) return false;
    if (hasInternalIpv6Range()) {
      if (!getInternalIpv6Range().equals(other.getInternalIpv6Range())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasMtu() != other.hasMtu()) return false;
    if (hasMtu()) {
      if (getMtu() != other.getMtu()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetworkFirewallPolicyEnforcementOrder()
        != other.hasNetworkFirewallPolicyEnforcementOrder()) return false;
    if (hasNetworkFirewallPolicyEnforcementOrder()) {
      if (!getNetworkFirewallPolicyEnforcementOrder()
          .equals(other.getNetworkFirewallPolicyEnforcementOrder())) return false;
    }
    if (!getPeeringsList().equals(other.getPeeringsList())) return false;
    if (hasRoutingConfig() != other.hasRoutingConfig()) return false;
    if (hasRoutingConfig()) {
      if (!getRoutingConfig().equals(other.getRoutingConfig())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSelfLinkWithId() != other.hasSelfLinkWithId()) return false;
    if (hasSelfLinkWithId()) {
      if (!getSelfLinkWithId().equals(other.getSelfLinkWithId())) return false;
    }
    if (!getSubnetworksList().equals(other.getSubnetworksList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIPv4Range()) {
      hash = (37 * hash) + I_PV4_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIPv4Range().hashCode();
    }
    if (hasAutoCreateSubnetworks()) {
      hash = (37 * hash) + AUTO_CREATE_SUBNETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoCreateSubnetworks());
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEnableUlaInternalIpv6()) {
      hash = (37 * hash) + ENABLE_ULA_INTERNAL_IPV6_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableUlaInternalIpv6());
    }
    if (hasFirewallPolicy()) {
      hash = (37 * hash) + FIREWALL_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getFirewallPolicy().hashCode();
    }
    if (hasGatewayIPv4()) {
      hash = (37 * hash) + GATEWAY_I_PV4_FIELD_NUMBER;
      hash = (53 * hash) + getGatewayIPv4().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInternalIpv6Range()) {
      hash = (37 * hash) + INTERNAL_IPV6_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getInternalIpv6Range().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasMtu()) {
      hash = (37 * hash) + MTU_FIELD_NUMBER;
      hash = (53 * hash) + getMtu();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetworkFirewallPolicyEnforcementOrder()) {
      hash = (37 * hash) + NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkFirewallPolicyEnforcementOrder().hashCode();
    }
    if (getPeeringsCount() > 0) {
      hash = (37 * hash) + PEERINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPeeringsList().hashCode();
    }
    if (hasRoutingConfig()) {
      hash = (37 * hash) + ROUTING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRoutingConfig().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSelfLinkWithId()) {
      hash = (37 * hash) + SELF_LINK_WITH_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLinkWithId().hashCode();
    }
    if (getSubnetworksCount() > 0) {
      hash = (37 * hash) + SUBNETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetworksList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Network parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Network parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Network parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Network parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Network prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a VPC Network resource. Networks connect resources to each other and to the internet. For more information, read Virtual Private Cloud (VPC) Network.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Network}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Network)
      com.google.cloud.compute.v1.NetworkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Network_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Network_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Network.class,
              com.google.cloud.compute.v1.Network.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Network.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPeeringsFieldBuilder();
        getRoutingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      iPv4Range_ = "";
      autoCreateSubnetworks_ = false;
      creationTimestamp_ = "";
      description_ = "";
      enableUlaInternalIpv6_ = false;
      firewallPolicy_ = "";
      gatewayIPv4_ = "";
      id_ = 0L;
      internalIpv6Range_ = "";
      kind_ = "";
      mtu_ = 0;
      name_ = "";
      networkFirewallPolicyEnforcementOrder_ = "";
      if (peeringsBuilder_ == null) {
        peerings_ = java.util.Collections.emptyList();
      } else {
        peerings_ = null;
        peeringsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      routingConfig_ = null;
      if (routingConfigBuilder_ != null) {
        routingConfigBuilder_.dispose();
        routingConfigBuilder_ = null;
      }
      selfLink_ = "";
      selfLinkWithId_ = "";
      subnetworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Network_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Network getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Network.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Network build() {
      com.google.cloud.compute.v1.Network result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Network buildPartial() {
      com.google.cloud.compute.v1.Network result = new com.google.cloud.compute.v1.Network(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Network result) {
      if (peeringsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          peerings_ = java.util.Collections.unmodifiableList(peerings_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.peerings_ = peerings_;
      } else {
        result.peerings_ = peeringsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Network result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.iPv4Range_ = iPv4Range_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.autoCreateSubnetworks_ = autoCreateSubnetworks_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableUlaInternalIpv6_ = enableUlaInternalIpv6_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.firewallPolicy_ = firewallPolicy_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.gatewayIPv4_ = gatewayIPv4_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.internalIpv6Range_ = internalIpv6Range_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.mtu_ = mtu_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.networkFirewallPolicyEnforcementOrder_ = networkFirewallPolicyEnforcementOrder_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.routingConfig_ =
            routingConfigBuilder_ == null ? routingConfig_ : routingConfigBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.selfLinkWithId_ = selfLinkWithId_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        subnetworks_.makeImmutable();
        result.subnetworks_ = subnetworks_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Network) {
        return mergeFrom((com.google.cloud.compute.v1.Network) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Network other) {
      if (other == com.google.cloud.compute.v1.Network.getDefaultInstance()) return this;
      if (other.hasIPv4Range()) {
        iPv4Range_ = other.iPv4Range_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAutoCreateSubnetworks()) {
        setAutoCreateSubnetworks(other.getAutoCreateSubnetworks());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEnableUlaInternalIpv6()) {
        setEnableUlaInternalIpv6(other.getEnableUlaInternalIpv6());
      }
      if (other.hasFirewallPolicy()) {
        firewallPolicy_ = other.firewallPolicy_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasGatewayIPv4()) {
        gatewayIPv4_ = other.gatewayIPv4_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInternalIpv6Range()) {
        internalIpv6Range_ = other.internalIpv6Range_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasMtu()) {
        setMtu(other.getMtu());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasNetworkFirewallPolicyEnforcementOrder()) {
        networkFirewallPolicyEnforcementOrder_ = other.networkFirewallPolicyEnforcementOrder_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (peeringsBuilder_ == null) {
        if (!other.peerings_.isEmpty()) {
          if (peerings_.isEmpty()) {
            peerings_ = other.peerings_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensurePeeringsIsMutable();
            peerings_.addAll(other.peerings_);
          }
          onChanged();
        }
      } else {
        if (!other.peerings_.isEmpty()) {
          if (peeringsBuilder_.isEmpty()) {
            peeringsBuilder_.dispose();
            peeringsBuilder_ = null;
            peerings_ = other.peerings_;
            bitField0_ = (bitField0_ & ~0x00002000);
            peeringsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPeeringsFieldBuilder()
                    : null;
          } else {
            peeringsBuilder_.addAllMessages(other.peerings_);
          }
        }
      }
      if (other.hasRoutingConfig()) {
        mergeRoutingConfig(other.getRoutingConfig());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasSelfLinkWithId()) {
        selfLinkWithId_ = other.selfLinkWithId_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (!other.subnetworks_.isEmpty()) {
        if (subnetworks_.isEmpty()) {
          subnetworks_ = other.subnetworks_;
          bitField0_ |= 0x00020000;
        } else {
          ensureSubnetworksIsMutable();
          subnetworks_.addAll(other.subnetworks_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 26840
            case 867696:
              {
                mtu_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 867696
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26989658
            case 52038274:
              {
                networkFirewallPolicyEnforcementOrder_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 52038274
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 356167698:
              {
                selfLinkWithId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 356167698
            case 473874866:
              {
                iPv4Range_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 473874866
            case 559065498:
              {
                com.google.cloud.compute.v1.NetworkPeering m =
                    input.readMessage(
                        com.google.cloud.compute.v1.NetworkPeering.parser(), extensionRegistry);
                if (peeringsBuilder_ == null) {
                  ensurePeeringsIsMutable();
                  peerings_.add(m);
                } else {
                  peeringsBuilder_.addMessage(m);
                }
                break;
              } // case 559065498
            case 1429431018:
              {
                gatewayIPv4_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1429431018
            case 2049253520:
              {
                autoCreateSubnetworks_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 2049253520
            case -2075312838:
              {
                internalIpv6Range_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -2075312838
            case -968142294:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSubnetworksIsMutable();
                subnetworks_.add(s);
                break;
              } // case -968142294
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -904905536:
              {
                enableUlaInternalIpv6_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case -904905536
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -645248918
            case -309581174:
              {
                firewallPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -309581174
            case -106518822:
              {
                input.readMessage(getRoutingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case -106518822
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object iPv4Range_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
     * </pre>
     *
     * <code>optional string I_pv4_range = 59234358;</code>
     *
     * @return Whether the iPv4Range field is set.
     */
    public boolean hasIPv4Range() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
     * </pre>
     *
     * <code>optional string I_pv4_range = 59234358;</code>
     *
     * @return The iPv4Range.
     */
    public java.lang.String getIPv4Range() {
      java.lang.Object ref = iPv4Range_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        iPv4Range_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
     * </pre>
     *
     * <code>optional string I_pv4_range = 59234358;</code>
     *
     * @return The bytes for iPv4Range.
     */
    public com.google.protobuf.ByteString getIPv4RangeBytes() {
      java.lang.Object ref = iPv4Range_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        iPv4Range_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
     * </pre>
     *
     * <code>optional string I_pv4_range = 59234358;</code>
     *
     * @param value The iPv4Range to set.
     * @return This builder for chaining.
     */
    public Builder setIPv4Range(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iPv4Range_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
     * </pre>
     *
     * <code>optional string I_pv4_range = 59234358;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIPv4Range() {
      iPv4Range_ = getDefaultInstance().getIPv4Range();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of subnet mode networks. The range of internal addresses that are legal on this network. This range is a CIDR specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
     * </pre>
     *
     * <code>optional string I_pv4_range = 59234358;</code>
     *
     * @param value The bytes for iPv4Range to set.
     * @return This builder for chaining.
     */
    public Builder setIPv4RangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iPv4Range_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean autoCreateSubnetworks_;
    /**
     *
     *
     * <pre>
     * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
     * </pre>
     *
     * <code>optional bool auto_create_subnetworks = 256156690;</code>
     *
     * @return Whether the autoCreateSubnetworks field is set.
     */
    @java.lang.Override
    public boolean hasAutoCreateSubnetworks() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
     * </pre>
     *
     * <code>optional bool auto_create_subnetworks = 256156690;</code>
     *
     * @return The autoCreateSubnetworks.
     */
    @java.lang.Override
    public boolean getAutoCreateSubnetworks() {
      return autoCreateSubnetworks_;
    }
    /**
     *
     *
     * <pre>
     * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
     * </pre>
     *
     * <code>optional bool auto_create_subnetworks = 256156690;</code>
     *
     * @param value The autoCreateSubnetworks to set.
     * @return This builder for chaining.
     */
    public Builder setAutoCreateSubnetworks(boolean value) {

      autoCreateSubnetworks_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Must be set to create a VPC network. If not set, a legacy network is created. When set to true, the VPC network is created in auto mode. When set to false, the VPC network is created in custom mode. An auto mode VPC network starts with one subnet per region. Each subnet has a predetermined range as described in Auto mode VPC network IP ranges. For custom mode VPC networks, you can add subnets using the subnetworks insert method.
     * </pre>
     *
     * <code>optional bool auto_create_subnetworks = 256156690;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoCreateSubnetworks() {
      bitField0_ = (bitField0_ & ~0x00000002);
      autoCreateSubnetworks_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean enableUlaInternalIpv6_;
    /**
     *
     *
     * <pre>
     * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
     * </pre>
     *
     * <code>optional bool enable_ula_internal_ipv6 = 423757720;</code>
     *
     * @return Whether the enableUlaInternalIpv6 field is set.
     */
    @java.lang.Override
    public boolean hasEnableUlaInternalIpv6() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
     * </pre>
     *
     * <code>optional bool enable_ula_internal_ipv6 = 423757720;</code>
     *
     * @return The enableUlaInternalIpv6.
     */
    @java.lang.Override
    public boolean getEnableUlaInternalIpv6() {
      return enableUlaInternalIpv6_;
    }
    /**
     *
     *
     * <pre>
     * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
     * </pre>
     *
     * <code>optional bool enable_ula_internal_ipv6 = 423757720;</code>
     *
     * @param value The enableUlaInternalIpv6 to set.
     * @return This builder for chaining.
     */
    public Builder setEnableUlaInternalIpv6(boolean value) {

      enableUlaInternalIpv6_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable ULA internal ipv6 on this network. Enabling this feature will assign a /48 from google defined ULA prefix fd20::/20. .
     * </pre>
     *
     * <code>optional bool enable_ula_internal_ipv6 = 423757720;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableUlaInternalIpv6() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableUlaInternalIpv6_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object firewallPolicy_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the firewall policy the network is associated with.
     * </pre>
     *
     * <code>optional string firewall_policy = 498173265;</code>
     *
     * @return Whether the firewallPolicy field is set.
     */
    public boolean hasFirewallPolicy() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the firewall policy the network is associated with.
     * </pre>
     *
     * <code>optional string firewall_policy = 498173265;</code>
     *
     * @return The firewallPolicy.
     */
    public java.lang.String getFirewallPolicy() {
      java.lang.Object ref = firewallPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        firewallPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the firewall policy the network is associated with.
     * </pre>
     *
     * <code>optional string firewall_policy = 498173265;</code>
     *
     * @return The bytes for firewallPolicy.
     */
    public com.google.protobuf.ByteString getFirewallPolicyBytes() {
      java.lang.Object ref = firewallPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        firewallPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the firewall policy the network is associated with.
     * </pre>
     *
     * <code>optional string firewall_policy = 498173265;</code>
     *
     * @param value The firewallPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setFirewallPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      firewallPolicy_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the firewall policy the network is associated with.
     * </pre>
     *
     * <code>optional string firewall_policy = 498173265;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFirewallPolicy() {
      firewallPolicy_ = getDefaultInstance().getFirewallPolicy();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the firewall policy the network is associated with.
     * </pre>
     *
     * <code>optional string firewall_policy = 498173265;</code>
     *
     * @param value The bytes for firewallPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setFirewallPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      firewallPolicy_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object gatewayIPv4_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
     * </pre>
     *
     * <code>optional string gateway_i_pv4 = 178678877;</code>
     *
     * @return Whether the gatewayIPv4 field is set.
     */
    public boolean hasGatewayIPv4() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
     * </pre>
     *
     * <code>optional string gateway_i_pv4 = 178678877;</code>
     *
     * @return The gatewayIPv4.
     */
    public java.lang.String getGatewayIPv4() {
      java.lang.Object ref = gatewayIPv4_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gatewayIPv4_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
     * </pre>
     *
     * <code>optional string gateway_i_pv4 = 178678877;</code>
     *
     * @return The bytes for gatewayIPv4.
     */
    public com.google.protobuf.ByteString getGatewayIPv4Bytes() {
      java.lang.Object ref = gatewayIPv4_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gatewayIPv4_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
     * </pre>
     *
     * <code>optional string gateway_i_pv4 = 178678877;</code>
     *
     * @param value The gatewayIPv4 to set.
     * @return This builder for chaining.
     */
    public Builder setGatewayIPv4(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gatewayIPv4_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
     * </pre>
     *
     * <code>optional string gateway_i_pv4 = 178678877;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGatewayIPv4() {
      gatewayIPv4_ = getDefaultInstance().getGatewayIPv4();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routing out of the network, selected by Google Cloud.
     * </pre>
     *
     * <code>optional string gateway_i_pv4 = 178678877;</code>
     *
     * @param value The bytes for gatewayIPv4 to set.
     * @return This builder for chaining.
     */
    public Builder setGatewayIPv4Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gatewayIPv4_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000080);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object internalIpv6Range_ = "";
    /**
     *
     *
     * <pre>
     * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
     * </pre>
     *
     * <code>optional string internal_ipv6_range = 277456807;</code>
     *
     * @return Whether the internalIpv6Range field is set.
     */
    public boolean hasInternalIpv6Range() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
     * </pre>
     *
     * <code>optional string internal_ipv6_range = 277456807;</code>
     *
     * @return The internalIpv6Range.
     */
    public java.lang.String getInternalIpv6Range() {
      java.lang.Object ref = internalIpv6Range_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalIpv6Range_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
     * </pre>
     *
     * <code>optional string internal_ipv6_range = 277456807;</code>
     *
     * @return The bytes for internalIpv6Range.
     */
    public com.google.protobuf.ByteString getInternalIpv6RangeBytes() {
      java.lang.Object ref = internalIpv6Range_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalIpv6Range_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
     * </pre>
     *
     * <code>optional string internal_ipv6_range = 277456807;</code>
     *
     * @param value The internalIpv6Range to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIpv6Range(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalIpv6Range_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
     * </pre>
     *
     * <code>optional string internal_ipv6_range = 277456807;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalIpv6Range() {
      internalIpv6Range_ = getDefaultInstance().getInternalIpv6Range();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When enabling ula internal ipv6, caller optionally can specify the /48 range they want from the google defined ULA prefix fd20::/20. The input must be a valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will fail if the speficied /48 is already in used by another resource. If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field. .
     * </pre>
     *
     * <code>optional string internal_ipv6_range = 277456807;</code>
     *
     * @param value The bytes for internalIpv6Range to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIpv6RangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalIpv6Range_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#network for networks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#network for networks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#network for networks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#network for networks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#network for networks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#network for networks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int mtu_;
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @return Whether the mtu field is set.
     */
    @java.lang.Override
    public boolean hasMtu() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @return The mtu.
     */
    @java.lang.Override
    public int getMtu() {
      return mtu_;
    }
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @param value The mtu to set.
     * @return This builder for chaining.
     */
    public Builder setMtu(int value) {

      mtu_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1300 and the maximum value is 8896. The suggested value is 1500, which is the default MTU used on the Internet, or 8896 if you want to use Jumbo frames. If unspecified, the value defaults to 1460.
     * </pre>
     *
     * <code>optional int32 mtu = 108462;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMtu() {
      bitField0_ = (bitField0_ & ~0x00000400);
      mtu_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object networkFirewallPolicyEnforcementOrder_ = "";
    /**
     *
     *
     * <pre>
     * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
     * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
     *
     * @return Whether the networkFirewallPolicyEnforcementOrder field is set.
     */
    public boolean hasNetworkFirewallPolicyEnforcementOrder() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
     * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
     *
     * @return The networkFirewallPolicyEnforcementOrder.
     */
    public java.lang.String getNetworkFirewallPolicyEnforcementOrder() {
      java.lang.Object ref = networkFirewallPolicyEnforcementOrder_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkFirewallPolicyEnforcementOrder_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
     * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
     *
     * @return The bytes for networkFirewallPolicyEnforcementOrder.
     */
    public com.google.protobuf.ByteString getNetworkFirewallPolicyEnforcementOrderBytes() {
      java.lang.Object ref = networkFirewallPolicyEnforcementOrder_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkFirewallPolicyEnforcementOrder_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
     * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
     *
     * @param value The networkFirewallPolicyEnforcementOrder to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkFirewallPolicyEnforcementOrder(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkFirewallPolicyEnforcementOrder_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
     * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkFirewallPolicyEnforcementOrder() {
      networkFirewallPolicyEnforcementOrder_ =
          getDefaultInstance().getNetworkFirewallPolicyEnforcementOrder();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
     * Check the NetworkFirewallPolicyEnforcementOrder enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_firewall_policy_enforcement_order = 6504784;</code>
     *
     * @param value The bytes for networkFirewallPolicyEnforcementOrder to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkFirewallPolicyEnforcementOrderBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkFirewallPolicyEnforcementOrder_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.NetworkPeering> peerings_ =
        java.util.Collections.emptyList();

    private void ensurePeeringsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        peerings_ = new java.util.ArrayList<com.google.cloud.compute.v1.NetworkPeering>(peerings_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPeering,
            com.google.cloud.compute.v1.NetworkPeering.Builder,
            com.google.cloud.compute.v1.NetworkPeeringOrBuilder>
        peeringsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkPeering> getPeeringsList() {
      if (peeringsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(peerings_);
      } else {
        return peeringsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public int getPeeringsCount() {
      if (peeringsBuilder_ == null) {
        return peerings_.size();
      } else {
        return peeringsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public com.google.cloud.compute.v1.NetworkPeering getPeerings(int index) {
      if (peeringsBuilder_ == null) {
        return peerings_.get(index);
      } else {
        return peeringsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder setPeerings(int index, com.google.cloud.compute.v1.NetworkPeering value) {
      if (peeringsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePeeringsIsMutable();
        peerings_.set(index, value);
        onChanged();
      } else {
        peeringsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder setPeerings(
        int index, com.google.cloud.compute.v1.NetworkPeering.Builder builderForValue) {
      if (peeringsBuilder_ == null) {
        ensurePeeringsIsMutable();
        peerings_.set(index, builderForValue.build());
        onChanged();
      } else {
        peeringsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder addPeerings(com.google.cloud.compute.v1.NetworkPeering value) {
      if (peeringsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePeeringsIsMutable();
        peerings_.add(value);
        onChanged();
      } else {
        peeringsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder addPeerings(int index, com.google.cloud.compute.v1.NetworkPeering value) {
      if (peeringsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePeeringsIsMutable();
        peerings_.add(index, value);
        onChanged();
      } else {
        peeringsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder addPeerings(com.google.cloud.compute.v1.NetworkPeering.Builder builderForValue) {
      if (peeringsBuilder_ == null) {
        ensurePeeringsIsMutable();
        peerings_.add(builderForValue.build());
        onChanged();
      } else {
        peeringsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder addPeerings(
        int index, com.google.cloud.compute.v1.NetworkPeering.Builder builderForValue) {
      if (peeringsBuilder_ == null) {
        ensurePeeringsIsMutable();
        peerings_.add(index, builderForValue.build());
        onChanged();
      } else {
        peeringsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder addAllPeerings(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.NetworkPeering> values) {
      if (peeringsBuilder_ == null) {
        ensurePeeringsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, peerings_);
        onChanged();
      } else {
        peeringsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder clearPeerings() {
      if (peeringsBuilder_ == null) {
        peerings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        peeringsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public Builder removePeerings(int index) {
      if (peeringsBuilder_ == null) {
        ensurePeeringsIsMutable();
        peerings_.remove(index);
        onChanged();
      } else {
        peeringsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public com.google.cloud.compute.v1.NetworkPeering.Builder getPeeringsBuilder(int index) {
      return getPeeringsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public com.google.cloud.compute.v1.NetworkPeeringOrBuilder getPeeringsOrBuilder(int index) {
      if (peeringsBuilder_ == null) {
        return peerings_.get(index);
      } else {
        return peeringsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.NetworkPeeringOrBuilder>
        getPeeringsOrBuilderList() {
      if (peeringsBuilder_ != null) {
        return peeringsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(peerings_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public com.google.cloud.compute.v1.NetworkPeering.Builder addPeeringsBuilder() {
      return getPeeringsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.NetworkPeering.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public com.google.cloud.compute.v1.NetworkPeering.Builder addPeeringsBuilder(int index) {
      return getPeeringsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.NetworkPeering.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of network peerings for the resource.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkPeering peerings = 69883187;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkPeering.Builder>
        getPeeringsBuilderList() {
      return getPeeringsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPeering,
            com.google.cloud.compute.v1.NetworkPeering.Builder,
            com.google.cloud.compute.v1.NetworkPeeringOrBuilder>
        getPeeringsFieldBuilder() {
      if (peeringsBuilder_ == null) {
        peeringsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkPeering,
                com.google.cloud.compute.v1.NetworkPeering.Builder,
                com.google.cloud.compute.v1.NetworkPeeringOrBuilder>(
                peerings_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        peerings_ = null;
      }
      return peeringsBuilder_;
    }

    private com.google.cloud.compute.v1.NetworkRoutingConfig routingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkRoutingConfig,
            com.google.cloud.compute.v1.NetworkRoutingConfig.Builder,
            com.google.cloud.compute.v1.NetworkRoutingConfigOrBuilder>
        routingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     *
     * @return Whether the routingConfig field is set.
     */
    public boolean hasRoutingConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     *
     * @return The routingConfig.
     */
    public com.google.cloud.compute.v1.NetworkRoutingConfig getRoutingConfig() {
      if (routingConfigBuilder_ == null) {
        return routingConfig_ == null
            ? com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance()
            : routingConfig_;
      } else {
        return routingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    public Builder setRoutingConfig(com.google.cloud.compute.v1.NetworkRoutingConfig value) {
      if (routingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routingConfig_ = value;
      } else {
        routingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    public Builder setRoutingConfig(
        com.google.cloud.compute.v1.NetworkRoutingConfig.Builder builderForValue) {
      if (routingConfigBuilder_ == null) {
        routingConfig_ = builderForValue.build();
      } else {
        routingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    public Builder mergeRoutingConfig(com.google.cloud.compute.v1.NetworkRoutingConfig value) {
      if (routingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && routingConfig_ != null
            && routingConfig_
                != com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance()) {
          getRoutingConfigBuilder().mergeFrom(value);
        } else {
          routingConfig_ = value;
        }
      } else {
        routingConfigBuilder_.mergeFrom(value);
      }
      if (routingConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    public Builder clearRoutingConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      routingConfig_ = null;
      if (routingConfigBuilder_ != null) {
        routingConfigBuilder_.dispose();
        routingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkRoutingConfig.Builder getRoutingConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getRoutingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkRoutingConfigOrBuilder getRoutingConfigOrBuilder() {
      if (routingConfigBuilder_ != null) {
        return routingConfigBuilder_.getMessageOrBuilder();
      } else {
        return routingConfig_ == null
            ? com.google.cloud.compute.v1.NetworkRoutingConfig.getDefaultInstance()
            : routingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The network-level routing configuration for this network. Used by Cloud Router to determine what type of network-wide routing behavior to enforce.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkRoutingConfig routing_config = 523556059;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkRoutingConfig,
            com.google.cloud.compute.v1.NetworkRoutingConfig.Builder,
            com.google.cloud.compute.v1.NetworkRoutingConfigOrBuilder>
        getRoutingConfigFieldBuilder() {
      if (routingConfigBuilder_ == null) {
        routingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkRoutingConfig,
                com.google.cloud.compute.v1.NetworkRoutingConfig.Builder,
                com.google.cloud.compute.v1.NetworkRoutingConfigOrBuilder>(
                getRoutingConfig(), getParentForChildren(), isClean());
        routingConfig_ = null;
      }
      return routingConfigBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLinkWithId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return Whether the selfLinkWithId field is set.
     */
    public boolean hasSelfLinkWithId() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The selfLinkWithId.
     */
    public java.lang.String getSelfLinkWithId() {
      java.lang.Object ref = selfLinkWithId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLinkWithId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The bytes for selfLinkWithId.
     */
    public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
      java.lang.Object ref = selfLinkWithId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLinkWithId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLinkWithId_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLinkWithId() {
      selfLinkWithId_ = getDefaultInstance().getSelfLinkWithId();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The bytes for selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLinkWithId_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList subnetworks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSubnetworksIsMutable() {
      if (!subnetworks_.isModifiable()) {
        subnetworks_ = new com.google.protobuf.LazyStringArrayList(subnetworks_);
      }
      bitField0_ |= 0x00020000;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @return A list containing the subnetworks.
     */
    public com.google.protobuf.ProtocolStringList getSubnetworksList() {
      subnetworks_.makeImmutable();
      return subnetworks_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @return The count of subnetworks.
     */
    public int getSubnetworksCount() {
      return subnetworks_.size();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @param index The index of the element to return.
     * @return The subnetworks at the given index.
     */
    public java.lang.String getSubnetworks(int index) {
      return subnetworks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the subnetworks at the given index.
     */
    public com.google.protobuf.ByteString getSubnetworksBytes(int index) {
      return subnetworks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @param index The index to set the value at.
     * @param value The subnetworks to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubnetworksIsMutable();
      subnetworks_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @param value The subnetworks to add.
     * @return This builder for chaining.
     */
    public Builder addSubnetworks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubnetworksIsMutable();
      subnetworks_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @param values The subnetworks to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubnetworks(java.lang.Iterable<java.lang.String> values) {
      ensureSubnetworksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subnetworks_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetworks() {
      subnetworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URLs for all subnetworks in this VPC network.
     * </pre>
     *
     * <code>repeated string subnetworks = 415853125;</code>
     *
     * @param value The bytes of the subnetworks to add.
     * @return This builder for chaining.
     */
    public Builder addSubnetworksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSubnetworksIsMutable();
      subnetworks_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Network)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Network)
  private static final com.google.cloud.compute.v1.Network DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Network();
  }

  public static com.google.cloud.compute.v1.Network getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Network> PARSER =
      new com.google.protobuf.AbstractParser<Network>() {
        @java.lang.Override
        public Network parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Network> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Network> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Network getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
