/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterInterface}
 */
public final class RouterInterface extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterInterface)
    RouterInterfaceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouterInterface.newBuilder() to construct.
  private RouterInterface(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterInterface() {
    ipRange_ = "";
    ipVersion_ = "";
    linkedInterconnectAttachment_ = "";
    linkedVpnTunnel_ = "";
    managementType_ = "";
    name_ = "";
    privateIpAddress_ = "";
    redundantInterface_ = "";
    subnetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterInterface();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterInterface_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterInterface_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterInterface.class,
            com.google.cloud.compute.v1.RouterInterface.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * IP version of this interface.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterInterface.IpVersion}
   */
  public enum IpVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IP_VERSION = 0;</code>
     */
    UNDEFINED_IP_VERSION(0),
    /** <code>IPV4 = 2254341;</code> */
    IPV4(2254341),
    /** <code>IPV6 = 2254343;</code> */
    IPV6(2254343),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IP_VERSION = 0;</code>
     */
    public static final int UNDEFINED_IP_VERSION_VALUE = 0;
    /** <code>IPV4 = 2254341;</code> */
    public static final int IPV4_VALUE = 2254341;
    /** <code>IPV6 = 2254343;</code> */
    public static final int IPV6_VALUE = 2254343;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IpVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IpVersion forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_IP_VERSION;
        case 2254341:
          return IPV4;
        case 2254343:
          return IPV6;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IpVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IpVersion> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IpVersion>() {
          public IpVersion findValueByNumber(int number) {
            return IpVersion.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterInterface.getDescriptor().getEnumTypes().get(0);
    }

    private static final IpVersion[] VALUES = values();

    public static IpVersion valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IpVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterInterface.IpVersion)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterInterface.ManagementType}
   */
  public enum ManagementType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MANAGEMENT_TYPE = 0;</code>
     */
    UNDEFINED_MANAGEMENT_TYPE(0),
    /**
     *
     *
     * <pre>
     * The interface is automatically created for PARTNER type InterconnectAttachment, Google will automatically create/update/delete this interface when the PARTNER InterconnectAttachment is created/provisioned/deleted. This type of interface cannot be manually managed by user.
     * </pre>
     *
     * <code>MANAGED_BY_ATTACHMENT = 458926411;</code>
     */
    MANAGED_BY_ATTACHMENT(458926411),
    /**
     *
     *
     * <pre>
     * Default value, the interface is manually created and managed by user.
     * </pre>
     *
     * <code>MANAGED_BY_USER = 317294067;</code>
     */
    MANAGED_BY_USER(317294067),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MANAGEMENT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_MANAGEMENT_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The interface is automatically created for PARTNER type InterconnectAttachment, Google will automatically create/update/delete this interface when the PARTNER InterconnectAttachment is created/provisioned/deleted. This type of interface cannot be manually managed by user.
     * </pre>
     *
     * <code>MANAGED_BY_ATTACHMENT = 458926411;</code>
     */
    public static final int MANAGED_BY_ATTACHMENT_VALUE = 458926411;
    /**
     *
     *
     * <pre>
     * Default value, the interface is manually created and managed by user.
     * </pre>
     *
     * <code>MANAGED_BY_USER = 317294067;</code>
     */
    public static final int MANAGED_BY_USER_VALUE = 317294067;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ManagementType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ManagementType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MANAGEMENT_TYPE;
        case 458926411:
          return MANAGED_BY_ATTACHMENT;
        case 317294067:
          return MANAGED_BY_USER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ManagementType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ManagementType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ManagementType>() {
          public ManagementType findValueByNumber(int number) {
            return ManagementType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterInterface.getDescriptor().getEnumTypes().get(1);
    }

    private static final ManagementType[] VALUES = values();

    public static ManagementType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ManagementType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterInterface.ManagementType)
  }

  private int bitField0_;
  public static final int IP_RANGE_FIELD_NUMBER = 145092645;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipRange_ = "";
  /**
   *
   *
   * <pre>
   * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
   * </pre>
   *
   * <code>optional string ip_range = 145092645;</code>
   *
   * @return Whether the ipRange field is set.
   */
  @java.lang.Override
  public boolean hasIpRange() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
   * </pre>
   *
   * <code>optional string ip_range = 145092645;</code>
   *
   * @return The ipRange.
   */
  @java.lang.Override
  public java.lang.String getIpRange() {
    java.lang.Object ref = ipRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
   * </pre>
   *
   * <code>optional string ip_range = 145092645;</code>
   *
   * @return The bytes for ipRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpRangeBytes() {
    java.lang.Object ref = ipRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_VERSION_FIELD_NUMBER = 294959552;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipVersion_ = "";
  /**
   *
   *
   * <pre>
   * IP version of this interface.
   * Check the IpVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_version = 294959552;</code>
   *
   * @return Whether the ipVersion field is set.
   */
  @java.lang.Override
  public boolean hasIpVersion() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * IP version of this interface.
   * Check the IpVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_version = 294959552;</code>
   *
   * @return The ipVersion.
   */
  @java.lang.Override
  public java.lang.String getIpVersion() {
    java.lang.Object ref = ipVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP version of this interface.
   * Check the IpVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_version = 294959552;</code>
   *
   * @return The bytes for ipVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpVersionBytes() {
    java.lang.Object ref = ipVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_INTERCONNECT_ATTACHMENT_FIELD_NUMBER = 501085518;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkedInterconnectAttachment_ = "";
  /**
   *
   *
   * <pre>
   * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
   * </pre>
   *
   * <code>optional string linked_interconnect_attachment = 501085518;</code>
   *
   * @return Whether the linkedInterconnectAttachment field is set.
   */
  @java.lang.Override
  public boolean hasLinkedInterconnectAttachment() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
   * </pre>
   *
   * <code>optional string linked_interconnect_attachment = 501085518;</code>
   *
   * @return The linkedInterconnectAttachment.
   */
  @java.lang.Override
  public java.lang.String getLinkedInterconnectAttachment() {
    java.lang.Object ref = linkedInterconnectAttachment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedInterconnectAttachment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
   * </pre>
   *
   * <code>optional string linked_interconnect_attachment = 501085518;</code>
   *
   * @return The bytes for linkedInterconnectAttachment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkedInterconnectAttachmentBytes() {
    java.lang.Object ref = linkedInterconnectAttachment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedInterconnectAttachment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_VPN_TUNNEL_FIELD_NUMBER = 352296953;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkedVpnTunnel_ = "";
  /**
   *
   *
   * <pre>
   * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
   * </pre>
   *
   * <code>optional string linked_vpn_tunnel = 352296953;</code>
   *
   * @return Whether the linkedVpnTunnel field is set.
   */
  @java.lang.Override
  public boolean hasLinkedVpnTunnel() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
   * </pre>
   *
   * <code>optional string linked_vpn_tunnel = 352296953;</code>
   *
   * @return The linkedVpnTunnel.
   */
  @java.lang.Override
  public java.lang.String getLinkedVpnTunnel() {
    java.lang.Object ref = linkedVpnTunnel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedVpnTunnel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
   * </pre>
   *
   * <code>optional string linked_vpn_tunnel = 352296953;</code>
   *
   * @return The bytes for linkedVpnTunnel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkedVpnTunnelBytes() {
    java.lang.Object ref = linkedVpnTunnel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedVpnTunnel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MANAGEMENT_TYPE_FIELD_NUMBER = 173703606;

  @SuppressWarnings("serial")
  private volatile java.lang.Object managementType_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * Check the ManagementType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string management_type = 173703606;</code>
   *
   * @return Whether the managementType field is set.
   */
  @java.lang.Override
  public boolean hasManagementType() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * Check the ManagementType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string management_type = 173703606;</code>
   *
   * @return The managementType.
   */
  @java.lang.Override
  public java.lang.String getManagementType() {
    java.lang.Object ref = managementType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      managementType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * Check the ManagementType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string management_type = 173703606;</code>
   *
   * @return The bytes for managementType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getManagementTypeBytes() {
    java.lang.Object ref = managementType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      managementType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_IP_ADDRESS_FIELD_NUMBER = 100854040;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
   * </pre>
   *
   * <code>optional string private_ip_address = 100854040;</code>
   *
   * @return Whether the privateIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasPrivateIpAddress() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
   * </pre>
   *
   * <code>optional string private_ip_address = 100854040;</code>
   *
   * @return The privateIpAddress.
   */
  @java.lang.Override
  public java.lang.String getPrivateIpAddress() {
    java.lang.Object ref = privateIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
   * </pre>
   *
   * <code>optional string private_ip_address = 100854040;</code>
   *
   * @return The bytes for privateIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateIpAddressBytes() {
    java.lang.Object ref = privateIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDUNDANT_INTERFACE_FIELD_NUMBER = 523187303;

  @SuppressWarnings("serial")
  private volatile java.lang.Object redundantInterface_ = "";
  /**
   *
   *
   * <pre>
   * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string redundant_interface = 523187303;</code>
   *
   * @return Whether the redundantInterface field is set.
   */
  @java.lang.Override
  public boolean hasRedundantInterface() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string redundant_interface = 523187303;</code>
   *
   * @return The redundantInterface.
   */
  @java.lang.Override
  public java.lang.String getRedundantInterface() {
    java.lang.Object ref = redundantInterface_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redundantInterface_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string redundant_interface = 523187303;</code>
   *
   * @return The bytes for redundantInterface.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRedundantInterfaceBytes() {
    java.lang.Object ref = redundantInterface_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redundantInterface_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 307827694;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return Whether the subnetwork field is set.
   */
  @java.lang.Override
  public boolean hasSubnetwork() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100854040, privateIpAddress_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 145092645, ipRange_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 173703606, managementType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 294959552, ipVersion_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 307827694, subnetwork_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 352296953, linkedVpnTunnel_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 501085518, linkedInterconnectAttachment_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 523187303, redundantInterface_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(100854040, privateIpAddress_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(145092645, ipRange_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(173703606, managementType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(294959552, ipVersion_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(307827694, subnetwork_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(352296953, linkedVpnTunnel_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              501085518, linkedInterconnectAttachment_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(523187303, redundantInterface_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterInterface)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterInterface other =
        (com.google.cloud.compute.v1.RouterInterface) obj;

    if (hasIpRange() != other.hasIpRange()) return false;
    if (hasIpRange()) {
      if (!getIpRange().equals(other.getIpRange())) return false;
    }
    if (hasIpVersion() != other.hasIpVersion()) return false;
    if (hasIpVersion()) {
      if (!getIpVersion().equals(other.getIpVersion())) return false;
    }
    if (hasLinkedInterconnectAttachment() != other.hasLinkedInterconnectAttachment()) return false;
    if (hasLinkedInterconnectAttachment()) {
      if (!getLinkedInterconnectAttachment().equals(other.getLinkedInterconnectAttachment()))
        return false;
    }
    if (hasLinkedVpnTunnel() != other.hasLinkedVpnTunnel()) return false;
    if (hasLinkedVpnTunnel()) {
      if (!getLinkedVpnTunnel().equals(other.getLinkedVpnTunnel())) return false;
    }
    if (hasManagementType() != other.hasManagementType()) return false;
    if (hasManagementType()) {
      if (!getManagementType().equals(other.getManagementType())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPrivateIpAddress() != other.hasPrivateIpAddress()) return false;
    if (hasPrivateIpAddress()) {
      if (!getPrivateIpAddress().equals(other.getPrivateIpAddress())) return false;
    }
    if (hasRedundantInterface() != other.hasRedundantInterface()) return false;
    if (hasRedundantInterface()) {
      if (!getRedundantInterface().equals(other.getRedundantInterface())) return false;
    }
    if (hasSubnetwork() != other.hasSubnetwork()) return false;
    if (hasSubnetwork()) {
      if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIpRange()) {
      hash = (37 * hash) + IP_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIpRange().hashCode();
    }
    if (hasIpVersion()) {
      hash = (37 * hash) + IP_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getIpVersion().hashCode();
    }
    if (hasLinkedInterconnectAttachment()) {
      hash = (37 * hash) + LINKED_INTERCONNECT_ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedInterconnectAttachment().hashCode();
    }
    if (hasLinkedVpnTunnel()) {
      hash = (37 * hash) + LINKED_VPN_TUNNEL_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedVpnTunnel().hashCode();
    }
    if (hasManagementType()) {
      hash = (37 * hash) + MANAGEMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getManagementType().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPrivateIpAddress()) {
      hash = (37 * hash) + PRIVATE_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateIpAddress().hashCode();
    }
    if (hasRedundantInterface()) {
      hash = (37 * hash) + REDUNDANT_INTERFACE_FIELD_NUMBER;
      hash = (53 * hash) + getRedundantInterface().hashCode();
    }
    if (hasSubnetwork()) {
      hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetwork().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterInterface parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterInterface prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterInterface}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterInterface)
      com.google.cloud.compute.v1.RouterInterfaceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterInterface_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterInterface_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterInterface.class,
              com.google.cloud.compute.v1.RouterInterface.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterInterface.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ipRange_ = "";
      ipVersion_ = "";
      linkedInterconnectAttachment_ = "";
      linkedVpnTunnel_ = "";
      managementType_ = "";
      name_ = "";
      privateIpAddress_ = "";
      redundantInterface_ = "";
      subnetwork_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterInterface_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterInterface getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterInterface.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterInterface build() {
      com.google.cloud.compute.v1.RouterInterface result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterInterface buildPartial() {
      com.google.cloud.compute.v1.RouterInterface result =
          new com.google.cloud.compute.v1.RouterInterface(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterInterface result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ipRange_ = ipRange_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ipVersion_ = ipVersion_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.linkedInterconnectAttachment_ = linkedInterconnectAttachment_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.linkedVpnTunnel_ = linkedVpnTunnel_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.managementType_ = managementType_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.privateIpAddress_ = privateIpAddress_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.redundantInterface_ = redundantInterface_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.subnetwork_ = subnetwork_;
        to_bitField0_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterInterface) {
        return mergeFrom((com.google.cloud.compute.v1.RouterInterface) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterInterface other) {
      if (other == com.google.cloud.compute.v1.RouterInterface.getDefaultInstance()) return this;
      if (other.hasIpRange()) {
        ipRange_ = other.ipRange_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasIpVersion()) {
        ipVersion_ = other.ipVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasLinkedInterconnectAttachment()) {
        linkedInterconnectAttachment_ = other.linkedInterconnectAttachment_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasLinkedVpnTunnel()) {
        linkedVpnTunnel_ = other.linkedVpnTunnel_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasManagementType()) {
        managementType_ = other.managementType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasPrivateIpAddress()) {
        privateIpAddress_ = other.privateIpAddress_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasRedundantInterface()) {
        redundantInterface_ = other.redundantInterface_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasSubnetwork()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26989658
            case 806832322:
              {
                privateIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 806832322
            case 1160741162:
              {
                ipRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1160741162
            case 1389628850:
              {
                managementType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1389628850
            case -1935290878:
              {
                ipVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1935290878
            case -1832345742:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -1832345742
            case -1476591670:
              {
                linkedVpnTunnel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1476591670
            case -286283150:
              {
                linkedInterconnectAttachment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -286283150
            case -109468870:
              {
                redundantInterface_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -109468870
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object ipRange_ = "";
    /**
     *
     *
     * <pre>
     * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
     * </pre>
     *
     * <code>optional string ip_range = 145092645;</code>
     *
     * @return Whether the ipRange field is set.
     */
    public boolean hasIpRange() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
     * </pre>
     *
     * <code>optional string ip_range = 145092645;</code>
     *
     * @return The ipRange.
     */
    public java.lang.String getIpRange() {
      java.lang.Object ref = ipRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
     * </pre>
     *
     * <code>optional string ip_range = 145092645;</code>
     *
     * @return The bytes for ipRange.
     */
    public com.google.protobuf.ByteString getIpRangeBytes() {
      java.lang.Object ref = ipRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
     * </pre>
     *
     * <code>optional string ip_range = 145092645;</code>
     *
     * @param value The ipRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipRange_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
     * </pre>
     *
     * <code>optional string ip_range = 145092645;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpRange() {
      ipRange_ = getDefaultInstance().getIpRange();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP address and range of the interface. - For Internet Protocol version 4 (IPv4), the IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example, 169.254.0.1/30. Note: Do not truncate the IP address, as it represents the IP address of the interface. - For Internet Protocol version 6 (IPv6), the value must be a unique local address (ULA) range from fdff:1::/64 with a mask length of 126 or less. This value should be a CIDR-formatted string, for example, fc00:0:1:1::1/112. Within the router's VPC, this IPv6 prefix will be reserved exclusively for this connection and cannot be used for any other purpose.
     * </pre>
     *
     * <code>optional string ip_range = 145092645;</code>
     *
     * @param value The bytes for ipRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipRange_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object ipVersion_ = "";
    /**
     *
     *
     * <pre>
     * IP version of this interface.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return Whether the ipVersion field is set.
     */
    public boolean hasIpVersion() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * IP version of this interface.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return The ipVersion.
     */
    public java.lang.String getIpVersion() {
      java.lang.Object ref = ipVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP version of this interface.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return The bytes for ipVersion.
     */
    public com.google.protobuf.ByteString getIpVersionBytes() {
      java.lang.Object ref = ipVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP version of this interface.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @param value The ipVersion to set.
     * @return This builder for chaining.
     */
    public Builder setIpVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP version of this interface.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpVersion() {
      ipVersion_ = getDefaultInstance().getIpVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP version of this interface.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @param value The bytes for ipVersion to set.
     * @return This builder for chaining.
     */
    public Builder setIpVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object linkedInterconnectAttachment_ = "";
    /**
     *
     *
     * <pre>
     * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_interconnect_attachment = 501085518;</code>
     *
     * @return Whether the linkedInterconnectAttachment field is set.
     */
    public boolean hasLinkedInterconnectAttachment() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_interconnect_attachment = 501085518;</code>
     *
     * @return The linkedInterconnectAttachment.
     */
    public java.lang.String getLinkedInterconnectAttachment() {
      java.lang.Object ref = linkedInterconnectAttachment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedInterconnectAttachment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_interconnect_attachment = 501085518;</code>
     *
     * @return The bytes for linkedInterconnectAttachment.
     */
    public com.google.protobuf.ByteString getLinkedInterconnectAttachmentBytes() {
      java.lang.Object ref = linkedInterconnectAttachment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedInterconnectAttachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_interconnect_attachment = 501085518;</code>
     *
     * @param value The linkedInterconnectAttachment to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedInterconnectAttachment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkedInterconnectAttachment_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_interconnect_attachment = 501085518;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedInterconnectAttachment() {
      linkedInterconnectAttachment_ = getDefaultInstance().getLinkedInterconnectAttachment();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_interconnect_attachment = 501085518;</code>
     *
     * @param value The bytes for linkedInterconnectAttachment to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedInterconnectAttachmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkedInterconnectAttachment_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object linkedVpnTunnel_ = "";
    /**
     *
     *
     * <pre>
     * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return Whether the linkedVpnTunnel field is set.
     */
    public boolean hasLinkedVpnTunnel() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return The linkedVpnTunnel.
     */
    public java.lang.String getLinkedVpnTunnel() {
      java.lang.Object ref = linkedVpnTunnel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedVpnTunnel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return The bytes for linkedVpnTunnel.
     */
    public com.google.protobuf.ByteString getLinkedVpnTunnelBytes() {
      java.lang.Object ref = linkedVpnTunnel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedVpnTunnel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @param value The linkedVpnTunnel to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedVpnTunnel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkedVpnTunnel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedVpnTunnel() {
      linkedVpnTunnel_ = getDefaultInstance().getLinkedVpnTunnel();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a subnetwork.
     * </pre>
     *
     * <code>optional string linked_vpn_tunnel = 352296953;</code>
     *
     * @param value The bytes for linkedVpnTunnel to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedVpnTunnelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkedVpnTunnel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object managementType_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return Whether the managementType field is set.
     */
    public boolean hasManagementType() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return The managementType.
     */
    public java.lang.String getManagementType() {
      java.lang.Object ref = managementType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        managementType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return The bytes for managementType.
     */
    public com.google.protobuf.ByteString getManagementTypeBytes() {
      java.lang.Object ref = managementType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        managementType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @param value The managementType to set.
     * @return This builder for chaining.
     */
    public Builder setManagementType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      managementType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearManagementType() {
      managementType_ = getDefaultInstance().getManagementType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @param value The bytes for managementType to set.
     * @return This builder for chaining.
     */
    public Builder setManagementTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      managementType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object privateIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
     * </pre>
     *
     * <code>optional string private_ip_address = 100854040;</code>
     *
     * @return Whether the privateIpAddress field is set.
     */
    public boolean hasPrivateIpAddress() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
     * </pre>
     *
     * <code>optional string private_ip_address = 100854040;</code>
     *
     * @return The privateIpAddress.
     */
    public java.lang.String getPrivateIpAddress() {
      java.lang.Object ref = privateIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
     * </pre>
     *
     * <code>optional string private_ip_address = 100854040;</code>
     *
     * @return The bytes for privateIpAddress.
     */
    public com.google.protobuf.ByteString getPrivateIpAddressBytes() {
      java.lang.Object ref = privateIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
     * </pre>
     *
     * <code>optional string private_ip_address = 100854040;</code>
     *
     * @param value The privateIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateIpAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
     * </pre>
     *
     * <code>optional string private_ip_address = 100854040;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpAddress() {
      privateIpAddress_ = getDefaultInstance().getPrivateIpAddress();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
     * </pre>
     *
     * <code>optional string private_ip_address = 100854040;</code>
     *
     * @param value The bytes for privateIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateIpAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object redundantInterface_ = "";
    /**
     *
     *
     * <pre>
     * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string redundant_interface = 523187303;</code>
     *
     * @return Whether the redundantInterface field is set.
     */
    public boolean hasRedundantInterface() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string redundant_interface = 523187303;</code>
     *
     * @return The redundantInterface.
     */
    public java.lang.String getRedundantInterface() {
      java.lang.Object ref = redundantInterface_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redundantInterface_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string redundant_interface = 523187303;</code>
     *
     * @return The bytes for redundantInterface.
     */
    public com.google.protobuf.ByteString getRedundantInterfaceBytes() {
      java.lang.Object ref = redundantInterface_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redundantInterface_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string redundant_interface = 523187303;</code>
     *
     * @param value The redundantInterface to set.
     * @return This builder for chaining.
     */
    public Builder setRedundantInterface(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      redundantInterface_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string redundant_interface = 523187303;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedundantInterface() {
      redundantInterface_ = getDefaultInstance().getRedundantInterface();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string redundant_interface = 523187303;</code>
     *
     * @param value The bytes for redundantInterface to set.
     * @return This builder for chaining.
     */
    public Builder setRedundantInterfaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      redundantInterface_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return Whether the subnetwork field is set.
     */
    public boolean hasSubnetwork() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterInterface)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterInterface)
  private static final com.google.cloud.compute.v1.RouterInterface DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterInterface();
  }

  public static com.google.cloud.compute.v1.RouterInterface getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterInterface> PARSER =
      new com.google.protobuf.AbstractParser<RouterInterface>() {
        @java.lang.Override
        public RouterInterface parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterInterface> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterInterface> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterInterface getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
