/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a match condition that incoming network traffic is evaluated against.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher}
 */
public final class SecurityPolicyRuleNetworkMatcher extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher)
    SecurityPolicyRuleNetworkMatcherOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPolicyRuleNetworkMatcher.newBuilder() to construct.
  private SecurityPolicyRuleNetworkMatcher(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPolicyRuleNetworkMatcher() {
    destIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    destPorts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    ipProtocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
    srcAsns_ = emptyIntList();
    srcIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    srcPorts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    srcRegionCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    userDefinedFields_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPolicyRuleNetworkMatcher();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRuleNetworkMatcher_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRuleNetworkMatcher_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.class,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder.class);
  }

  public static final int DEST_IP_RANGES_FIELD_NUMBER = 337357713;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList destIpRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @return A list containing the destIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getDestIpRangesList() {
    return destIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @return The count of destIpRanges.
   */
  public int getDestIpRangesCount() {
    return destIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @param index The index of the element to return.
   * @return The destIpRanges at the given index.
   */
  public java.lang.String getDestIpRanges(int index) {
    return destIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the destIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getDestIpRangesBytes(int index) {
    return destIpRanges_.getByteString(index);
  }

  public static final int DEST_PORTS_FIELD_NUMBER = 379902005;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList destPorts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string dest_ports = 379902005;</code>
   *
   * @return A list containing the destPorts.
   */
  public com.google.protobuf.ProtocolStringList getDestPortsList() {
    return destPorts_;
  }
  /**
   *
   *
   * <pre>
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string dest_ports = 379902005;</code>
   *
   * @return The count of destPorts.
   */
  public int getDestPortsCount() {
    return destPorts_.size();
  }
  /**
   *
   *
   * <pre>
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string dest_ports = 379902005;</code>
   *
   * @param index The index of the element to return.
   * @return The destPorts at the given index.
   */
  public java.lang.String getDestPorts(int index) {
    return destPorts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string dest_ports = 379902005;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the destPorts at the given index.
   */
  public com.google.protobuf.ByteString getDestPortsBytes(int index) {
    return destPorts_.getByteString(index);
  }

  public static final int IP_PROTOCOLS_FIELD_NUMBER = 259213251;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ipProtocols_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * </pre>
   *
   * <code>repeated string ip_protocols = 259213251;</code>
   *
   * @return A list containing the ipProtocols.
   */
  public com.google.protobuf.ProtocolStringList getIpProtocolsList() {
    return ipProtocols_;
  }
  /**
   *
   *
   * <pre>
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * </pre>
   *
   * <code>repeated string ip_protocols = 259213251;</code>
   *
   * @return The count of ipProtocols.
   */
  public int getIpProtocolsCount() {
    return ipProtocols_.size();
  }
  /**
   *
   *
   * <pre>
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * </pre>
   *
   * <code>repeated string ip_protocols = 259213251;</code>
   *
   * @param index The index of the element to return.
   * @return The ipProtocols at the given index.
   */
  public java.lang.String getIpProtocols(int index) {
    return ipProtocols_.get(index);
  }
  /**
   *
   *
   * <pre>
   * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
   * </pre>
   *
   * <code>repeated string ip_protocols = 259213251;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ipProtocols at the given index.
   */
  public com.google.protobuf.ByteString getIpProtocolsBytes(int index) {
    return ipProtocols_.getByteString(index);
  }

  public static final int SRC_ASNS_FIELD_NUMBER = 117825266;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList srcAsns_ = emptyIntList();
  /**
   *
   *
   * <pre>
   * BGP Autonomous System Number associated with the source IP address.
   * </pre>
   *
   * <code>repeated uint32 src_asns = 117825266;</code>
   *
   * @return A list containing the srcAsns.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSrcAsnsList() {
    return srcAsns_;
  }
  /**
   *
   *
   * <pre>
   * BGP Autonomous System Number associated with the source IP address.
   * </pre>
   *
   * <code>repeated uint32 src_asns = 117825266;</code>
   *
   * @return The count of srcAsns.
   */
  public int getSrcAsnsCount() {
    return srcAsns_.size();
  }
  /**
   *
   *
   * <pre>
   * BGP Autonomous System Number associated with the source IP address.
   * </pre>
   *
   * <code>repeated uint32 src_asns = 117825266;</code>
   *
   * @param index The index of the element to return.
   * @return The srcAsns at the given index.
   */
  public int getSrcAsns(int index) {
    return srcAsns_.getInt(index);
  }

  private int srcAsnsMemoizedSerializedSize = -1;

  public static final int SRC_IP_RANGES_FIELD_NUMBER = 432128083;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList srcIpRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @return A list containing the srcIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getSrcIpRangesList() {
    return srcIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @return The count of srcIpRanges.
   */
  public int getSrcIpRangesCount() {
    return srcIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @param index The index of the element to return.
   * @return The srcIpRanges at the given index.
   */
  public java.lang.String getSrcIpRanges(int index) {
    return srcIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the srcIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getSrcIpRangesBytes(int index) {
    return srcIpRanges_.getByteString(index);
  }

  public static final int SRC_PORTS_FIELD_NUMBER = 445095415;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList srcPorts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string src_ports = 445095415;</code>
   *
   * @return A list containing the srcPorts.
   */
  public com.google.protobuf.ProtocolStringList getSrcPortsList() {
    return srcPorts_;
  }
  /**
   *
   *
   * <pre>
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string src_ports = 445095415;</code>
   *
   * @return The count of srcPorts.
   */
  public int getSrcPortsCount() {
    return srcPorts_.size();
  }
  /**
   *
   *
   * <pre>
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string src_ports = 445095415;</code>
   *
   * @param index The index of the element to return.
   * @return The srcPorts at the given index.
   */
  public java.lang.String getSrcPorts(int index) {
    return srcPorts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
   * </pre>
   *
   * <code>repeated string src_ports = 445095415;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the srcPorts at the given index.
   */
  public com.google.protobuf.ByteString getSrcPortsBytes(int index) {
    return srcPorts_.getByteString(index);
  }

  public static final int SRC_REGION_CODES_FIELD_NUMBER = 99086742;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList srcRegionCodes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * </pre>
   *
   * <code>repeated string src_region_codes = 99086742;</code>
   *
   * @return A list containing the srcRegionCodes.
   */
  public com.google.protobuf.ProtocolStringList getSrcRegionCodesList() {
    return srcRegionCodes_;
  }
  /**
   *
   *
   * <pre>
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * </pre>
   *
   * <code>repeated string src_region_codes = 99086742;</code>
   *
   * @return The count of srcRegionCodes.
   */
  public int getSrcRegionCodesCount() {
    return srcRegionCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * </pre>
   *
   * <code>repeated string src_region_codes = 99086742;</code>
   *
   * @param index The index of the element to return.
   * @return The srcRegionCodes at the given index.
   */
  public java.lang.String getSrcRegionCodes(int index) {
    return srcRegionCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
   * </pre>
   *
   * <code>repeated string src_region_codes = 99086742;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the srcRegionCodes at the given index.
   */
  public com.google.protobuf.ByteString getSrcRegionCodesBytes(int index) {
    return srcRegionCodes_.getByteString(index);
  }

  public static final int USER_DEFINED_FIELDS_FIELD_NUMBER = 28312739;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>
      userDefinedFields_;
  /**
   *
   *
   * <pre>
   * User-defined fields. Each element names a defined field and lists the matching values for that field.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>
      getUserDefinedFieldsList() {
    return userDefinedFields_;
  }
  /**
   *
   *
   * <pre>
   * User-defined fields. Each element names a defined field and lists the matching values for that field.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder>
      getUserDefinedFieldsOrBuilderList() {
    return userDefinedFields_;
  }
  /**
   *
   *
   * <pre>
   * User-defined fields. Each element names a defined field and lists the matching values for that field.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public int getUserDefinedFieldsCount() {
    return userDefinedFields_.size();
  }
  /**
   *
   *
   * <pre>
   * User-defined fields. Each element names a defined field and lists the matching values for that field.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
      getUserDefinedFields(int index) {
    return userDefinedFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * User-defined fields. Each element names a defined field and lists the matching values for that field.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder
      getUserDefinedFieldsOrBuilder(int index) {
    return userDefinedFields_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < userDefinedFields_.size(); i++) {
      output.writeMessage(28312739, userDefinedFields_.get(i));
    }
    for (int i = 0; i < srcRegionCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 99086742, srcRegionCodes_.getRaw(i));
    }
    if (getSrcAsnsList().size() > 0) {
      output.writeUInt32NoTag(942602130);
      output.writeUInt32NoTag(srcAsnsMemoizedSerializedSize);
    }
    for (int i = 0; i < srcAsns_.size(); i++) {
      output.writeUInt32NoTag(srcAsns_.getInt(i));
    }
    for (int i = 0; i < ipProtocols_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 259213251, ipProtocols_.getRaw(i));
    }
    for (int i = 0; i < destIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 337357713, destIpRanges_.getRaw(i));
    }
    for (int i = 0; i < destPorts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 379902005, destPorts_.getRaw(i));
    }
    for (int i = 0; i < srcIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 432128083, srcIpRanges_.getRaw(i));
    }
    for (int i = 0; i < srcPorts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 445095415, srcPorts_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < userDefinedFields_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28312739, userDefinedFields_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < srcRegionCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(srcRegionCodes_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSrcRegionCodesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < srcAsns_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(srcAsns_.getInt(i));
      }
      size += dataSize;
      if (!getSrcAsnsList().isEmpty()) {
        size += 5;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      srcAsnsMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ipProtocols_.size(); i++) {
        dataSize += computeStringSizeNoTag(ipProtocols_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getIpProtocolsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < destIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(destIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDestIpRangesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < destPorts_.size(); i++) {
        dataSize += computeStringSizeNoTag(destPorts_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDestPortsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < srcIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(srcIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSrcIpRangesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < srcPorts_.size(); i++) {
        dataSize += computeStringSizeNoTag(srcPorts_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSrcPortsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher other =
        (com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher) obj;

    if (!getDestIpRangesList().equals(other.getDestIpRangesList())) return false;
    if (!getDestPortsList().equals(other.getDestPortsList())) return false;
    if (!getIpProtocolsList().equals(other.getIpProtocolsList())) return false;
    if (!getSrcAsnsList().equals(other.getSrcAsnsList())) return false;
    if (!getSrcIpRangesList().equals(other.getSrcIpRangesList())) return false;
    if (!getSrcPortsList().equals(other.getSrcPortsList())) return false;
    if (!getSrcRegionCodesList().equals(other.getSrcRegionCodesList())) return false;
    if (!getUserDefinedFieldsList().equals(other.getUserDefinedFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDestIpRangesCount() > 0) {
      hash = (37 * hash) + DEST_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDestIpRangesList().hashCode();
    }
    if (getDestPortsCount() > 0) {
      hash = (37 * hash) + DEST_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getDestPortsList().hashCode();
    }
    if (getIpProtocolsCount() > 0) {
      hash = (37 * hash) + IP_PROTOCOLS_FIELD_NUMBER;
      hash = (53 * hash) + getIpProtocolsList().hashCode();
    }
    if (getSrcAsnsCount() > 0) {
      hash = (37 * hash) + SRC_ASNS_FIELD_NUMBER;
      hash = (53 * hash) + getSrcAsnsList().hashCode();
    }
    if (getSrcIpRangesCount() > 0) {
      hash = (37 * hash) + SRC_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSrcIpRangesList().hashCode();
    }
    if (getSrcPortsCount() > 0) {
      hash = (37 * hash) + SRC_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getSrcPortsList().hashCode();
    }
    if (getSrcRegionCodesCount() > 0) {
      hash = (37 * hash) + SRC_REGION_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getSrcRegionCodesList().hashCode();
    }
    if (getUserDefinedFieldsCount() > 0) {
      hash = (37 * hash) + USER_DEFINED_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getUserDefinedFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a match condition that incoming network traffic is evaluated against.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher)
      com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleNetworkMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleNetworkMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.class,
              com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      destIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      destPorts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      ipProtocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
      srcAsns_ = emptyIntList();
      srcIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      srcPorts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      srcRegionCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (userDefinedFieldsBuilder_ == null) {
        userDefinedFields_ = java.util.Collections.emptyList();
      } else {
        userDefinedFields_ = null;
        userDefinedFieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleNetworkMatcher_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher build() {
      com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher buildPartial() {
      com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher result =
          new com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher result) {
      if (userDefinedFieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          userDefinedFields_ = java.util.Collections.unmodifiableList(userDefinedFields_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.userDefinedFields_ = userDefinedFields_;
      } else {
        result.userDefinedFields_ = userDefinedFieldsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        destIpRanges_.makeImmutable();
        result.destIpRanges_ = destIpRanges_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        destPorts_.makeImmutable();
        result.destPorts_ = destPorts_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        ipProtocols_.makeImmutable();
        result.ipProtocols_ = ipProtocols_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        srcAsns_.makeImmutable();
        result.srcAsns_ = srcAsns_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        srcIpRanges_.makeImmutable();
        result.srcIpRanges_ = srcIpRanges_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        srcPorts_.makeImmutable();
        result.srcPorts_ = srcPorts_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        srcRegionCodes_.makeImmutable();
        result.srcRegionCodes_ = srcRegionCodes_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher) {
        return mergeFrom((com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher other) {
      if (other
          == com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.getDefaultInstance())
        return this;
      if (!other.destIpRanges_.isEmpty()) {
        if (destIpRanges_.isEmpty()) {
          destIpRanges_ = other.destIpRanges_;
          bitField0_ |= 0x00000001;
        } else {
          ensureDestIpRangesIsMutable();
          destIpRanges_.addAll(other.destIpRanges_);
        }
        onChanged();
      }
      if (!other.destPorts_.isEmpty()) {
        if (destPorts_.isEmpty()) {
          destPorts_ = other.destPorts_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDestPortsIsMutable();
          destPorts_.addAll(other.destPorts_);
        }
        onChanged();
      }
      if (!other.ipProtocols_.isEmpty()) {
        if (ipProtocols_.isEmpty()) {
          ipProtocols_ = other.ipProtocols_;
          bitField0_ |= 0x00000004;
        } else {
          ensureIpProtocolsIsMutable();
          ipProtocols_.addAll(other.ipProtocols_);
        }
        onChanged();
      }
      if (!other.srcAsns_.isEmpty()) {
        if (srcAsns_.isEmpty()) {
          srcAsns_ = other.srcAsns_;
          srcAsns_.makeImmutable();
          bitField0_ |= 0x00000008;
        } else {
          ensureSrcAsnsIsMutable();
          srcAsns_.addAll(other.srcAsns_);
        }
        onChanged();
      }
      if (!other.srcIpRanges_.isEmpty()) {
        if (srcIpRanges_.isEmpty()) {
          srcIpRanges_ = other.srcIpRanges_;
          bitField0_ |= 0x00000010;
        } else {
          ensureSrcIpRangesIsMutable();
          srcIpRanges_.addAll(other.srcIpRanges_);
        }
        onChanged();
      }
      if (!other.srcPorts_.isEmpty()) {
        if (srcPorts_.isEmpty()) {
          srcPorts_ = other.srcPorts_;
          bitField0_ |= 0x00000020;
        } else {
          ensureSrcPortsIsMutable();
          srcPorts_.addAll(other.srcPorts_);
        }
        onChanged();
      }
      if (!other.srcRegionCodes_.isEmpty()) {
        if (srcRegionCodes_.isEmpty()) {
          srcRegionCodes_ = other.srcRegionCodes_;
          bitField0_ |= 0x00000040;
        } else {
          ensureSrcRegionCodesIsMutable();
          srcRegionCodes_.addAll(other.srcRegionCodes_);
        }
        onChanged();
      }
      if (userDefinedFieldsBuilder_ == null) {
        if (!other.userDefinedFields_.isEmpty()) {
          if (userDefinedFields_.isEmpty()) {
            userDefinedFields_ = other.userDefinedFields_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureUserDefinedFieldsIsMutable();
            userDefinedFields_.addAll(other.userDefinedFields_);
          }
          onChanged();
        }
      } else {
        if (!other.userDefinedFields_.isEmpty()) {
          if (userDefinedFieldsBuilder_.isEmpty()) {
            userDefinedFieldsBuilder_.dispose();
            userDefinedFieldsBuilder_ = null;
            userDefinedFields_ = other.userDefinedFields_;
            bitField0_ = (bitField0_ & ~0x00000080);
            userDefinedFieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUserDefinedFieldsFieldBuilder()
                    : null;
          } else {
            userDefinedFieldsBuilder_.addAllMessages(other.userDefinedFields_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 226501914:
              {
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                    m =
                        input.readMessage(
                            com.google.cloud.compute.v1
                                .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.parser(),
                            extensionRegistry);
                if (userDefinedFieldsBuilder_ == null) {
                  ensureUserDefinedFieldsIsMutable();
                  userDefinedFields_.add(m);
                } else {
                  userDefinedFieldsBuilder_.addMessage(m);
                }
                break;
              } // case 226501914
            case 792693938:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSrcRegionCodesIsMutable();
                srcRegionCodes_.add(s);
                break;
              } // case 792693938
            case 942602128:
              {
                int v = input.readUInt32();
                ensureSrcAsnsIsMutable();
                srcAsns_.addInt(v);
                break;
              } // case 942602128
            case 942602130:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureSrcAsnsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  srcAsns_.addInt(input.readUInt32());
                }
                input.popLimit(limit);
                break;
              } // case 942602130
            case 2073706010:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIpProtocolsIsMutable();
                ipProtocols_.add(s);
                break;
              } // case 2073706010
            case -1596105590:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestIpRangesIsMutable();
                destIpRanges_.add(s);
                break;
              } // case -1596105590
            case -1255751254:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestPortsIsMutable();
                destPorts_.add(s);
                break;
              } // case -1255751254
            case -837942630:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSrcIpRangesIsMutable();
                srcIpRanges_.add(s);
                break;
              } // case -837942630
            case -734203974:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSrcPortsIsMutable();
                srcPorts_.add(s);
                break;
              } // case -734203974
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList destIpRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDestIpRangesIsMutable() {
      if (!destIpRanges_.isModifiable()) {
        destIpRanges_ = new com.google.protobuf.LazyStringArrayList(destIpRanges_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @return A list containing the destIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getDestIpRangesList() {
      destIpRanges_.makeImmutable();
      return destIpRanges_;
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @return The count of destIpRanges.
     */
    public int getDestIpRangesCount() {
      return destIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param index The index of the element to return.
     * @return The destIpRanges at the given index.
     */
    public java.lang.String getDestIpRanges(int index) {
      return destIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the destIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getDestIpRangesBytes(int index) {
      return destIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param index The index to set the value at.
     * @param value The destIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setDestIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestIpRangesIsMutable();
      destIpRanges_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param value The destIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestIpRangesIsMutable();
      destIpRanges_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param values The destIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllDestIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureDestIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destIpRanges_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestIpRanges() {
      destIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param value The bytes of the destIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDestIpRangesIsMutable();
      destIpRanges_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList destPorts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDestPortsIsMutable() {
      if (!destPorts_.isModifiable()) {
        destPorts_ = new com.google.protobuf.LazyStringArrayList(destPorts_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @return A list containing the destPorts.
     */
    public com.google.protobuf.ProtocolStringList getDestPortsList() {
      destPorts_.makeImmutable();
      return destPorts_;
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @return The count of destPorts.
     */
    public int getDestPortsCount() {
      return destPorts_.size();
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @param index The index of the element to return.
     * @return The destPorts at the given index.
     */
    public java.lang.String getDestPorts(int index) {
      return destPorts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the destPorts at the given index.
     */
    public com.google.protobuf.ByteString getDestPortsBytes(int index) {
      return destPorts_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @param index The index to set the value at.
     * @param value The destPorts to set.
     * @return This builder for chaining.
     */
    public Builder setDestPorts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestPortsIsMutable();
      destPorts_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @param value The destPorts to add.
     * @return This builder for chaining.
     */
    public Builder addDestPorts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestPortsIsMutable();
      destPorts_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @param values The destPorts to add.
     * @return This builder for chaining.
     */
    public Builder addAllDestPorts(java.lang.Iterable<java.lang.String> values) {
      ensureDestPortsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destPorts_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestPorts() {
      destPorts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string dest_ports = 379902005;</code>
     *
     * @param value The bytes of the destPorts to add.
     * @return This builder for chaining.
     */
    public Builder addDestPortsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDestPortsIsMutable();
      destPorts_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ipProtocols_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIpProtocolsIsMutable() {
      if (!ipProtocols_.isModifiable()) {
        ipProtocols_ = new com.google.protobuf.LazyStringArrayList(ipProtocols_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @return A list containing the ipProtocols.
     */
    public com.google.protobuf.ProtocolStringList getIpProtocolsList() {
      ipProtocols_.makeImmutable();
      return ipProtocols_;
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @return The count of ipProtocols.
     */
    public int getIpProtocolsCount() {
      return ipProtocols_.size();
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @param index The index of the element to return.
     * @return The ipProtocols at the given index.
     */
    public java.lang.String getIpProtocols(int index) {
      return ipProtocols_.get(index);
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipProtocols at the given index.
     */
    public com.google.protobuf.ByteString getIpProtocolsBytes(int index) {
      return ipProtocols_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @param index The index to set the value at.
     * @param value The ipProtocols to set.
     * @return This builder for chaining.
     */
    public Builder setIpProtocols(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpProtocolsIsMutable();
      ipProtocols_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @param value The ipProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addIpProtocols(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpProtocolsIsMutable();
      ipProtocols_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @param values The ipProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addAllIpProtocols(java.lang.Iterable<java.lang.String> values) {
      ensureIpProtocolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipProtocols_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpProtocols() {
      ipProtocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
     * </pre>
     *
     * <code>repeated string ip_protocols = 259213251;</code>
     *
     * @param value The bytes of the ipProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addIpProtocolsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIpProtocolsIsMutable();
      ipProtocols_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList srcAsns_ = emptyIntList();

    private void ensureSrcAsnsIsMutable() {
      if (!srcAsns_.isModifiable()) {
        srcAsns_ = makeMutableCopy(srcAsns_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @return A list containing the srcAsns.
     */
    public java.util.List<java.lang.Integer> getSrcAsnsList() {
      srcAsns_.makeImmutable();
      return srcAsns_;
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @return The count of srcAsns.
     */
    public int getSrcAsnsCount() {
      return srcAsns_.size();
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @param index The index of the element to return.
     * @return The srcAsns at the given index.
     */
    public int getSrcAsns(int index) {
      return srcAsns_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @param index The index to set the value at.
     * @param value The srcAsns to set.
     * @return This builder for chaining.
     */
    public Builder setSrcAsns(int index, int value) {

      ensureSrcAsnsIsMutable();
      srcAsns_.setInt(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @param value The srcAsns to add.
     * @return This builder for chaining.
     */
    public Builder addSrcAsns(int value) {

      ensureSrcAsnsIsMutable();
      srcAsns_.addInt(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @param values The srcAsns to add.
     * @return This builder for chaining.
     */
    public Builder addAllSrcAsns(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureSrcAsnsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcAsns_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BGP Autonomous System Number associated with the source IP address.
     * </pre>
     *
     * <code>repeated uint32 src_asns = 117825266;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcAsns() {
      srcAsns_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList srcIpRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSrcIpRangesIsMutable() {
      if (!srcIpRanges_.isModifiable()) {
        srcIpRanges_ = new com.google.protobuf.LazyStringArrayList(srcIpRanges_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @return A list containing the srcIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getSrcIpRangesList() {
      srcIpRanges_.makeImmutable();
      return srcIpRanges_;
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @return The count of srcIpRanges.
     */
    public int getSrcIpRangesCount() {
      return srcIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param index The index of the element to return.
     * @return The srcIpRanges at the given index.
     */
    public java.lang.String getSrcIpRanges(int index) {
      return srcIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the srcIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getSrcIpRangesBytes(int index) {
      return srcIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param index The index to set the value at.
     * @param value The srcIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSrcIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcIpRangesIsMutable();
      srcIpRanges_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param value The srcIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSrcIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcIpRangesIsMutable();
      srcIpRanges_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param values The srcIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSrcIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSrcIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcIpRanges_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcIpRanges() {
      srcIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param value The bytes of the srcIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSrcIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSrcIpRangesIsMutable();
      srcIpRanges_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList srcPorts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSrcPortsIsMutable() {
      if (!srcPorts_.isModifiable()) {
        srcPorts_ = new com.google.protobuf.LazyStringArrayList(srcPorts_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @return A list containing the srcPorts.
     */
    public com.google.protobuf.ProtocolStringList getSrcPortsList() {
      srcPorts_.makeImmutable();
      return srcPorts_;
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @return The count of srcPorts.
     */
    public int getSrcPortsCount() {
      return srcPorts_.size();
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @param index The index of the element to return.
     * @return The srcPorts at the given index.
     */
    public java.lang.String getSrcPorts(int index) {
      return srcPorts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the srcPorts at the given index.
     */
    public com.google.protobuf.ByteString getSrcPortsBytes(int index) {
      return srcPorts_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @param index The index to set the value at.
     * @param value The srcPorts to set.
     * @return This builder for chaining.
     */
    public Builder setSrcPorts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcPortsIsMutable();
      srcPorts_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @param value The srcPorts to add.
     * @return This builder for chaining.
     */
    public Builder addSrcPorts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcPortsIsMutable();
      srcPorts_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @param values The srcPorts to add.
     * @return This builder for chaining.
     */
    public Builder addAllSrcPorts(java.lang.Iterable<java.lang.String> values) {
      ensureSrcPortsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcPorts_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcPorts() {
      srcPorts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
     * </pre>
     *
     * <code>repeated string src_ports = 445095415;</code>
     *
     * @param value The bytes of the srcPorts to add.
     * @return This builder for chaining.
     */
    public Builder addSrcPortsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSrcPortsIsMutable();
      srcPorts_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList srcRegionCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSrcRegionCodesIsMutable() {
      if (!srcRegionCodes_.isModifiable()) {
        srcRegionCodes_ = new com.google.protobuf.LazyStringArrayList(srcRegionCodes_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @return A list containing the srcRegionCodes.
     */
    public com.google.protobuf.ProtocolStringList getSrcRegionCodesList() {
      srcRegionCodes_.makeImmutable();
      return srcRegionCodes_;
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @return The count of srcRegionCodes.
     */
    public int getSrcRegionCodesCount() {
      return srcRegionCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @param index The index of the element to return.
     * @return The srcRegionCodes at the given index.
     */
    public java.lang.String getSrcRegionCodes(int index) {
      return srcRegionCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the srcRegionCodes at the given index.
     */
    public com.google.protobuf.ByteString getSrcRegionCodesBytes(int index) {
      return srcRegionCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @param index The index to set the value at.
     * @param value The srcRegionCodes to set.
     * @return This builder for chaining.
     */
    public Builder setSrcRegionCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcRegionCodesIsMutable();
      srcRegionCodes_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @param value The srcRegionCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSrcRegionCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcRegionCodesIsMutable();
      srcRegionCodes_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @param values The srcRegionCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSrcRegionCodes(java.lang.Iterable<java.lang.String> values) {
      ensureSrcRegionCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcRegionCodes_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcRegionCodes() {
      srcRegionCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
     * </pre>
     *
     * <code>repeated string src_region_codes = 99086742;</code>
     *
     * @param value The bytes of the srcRegionCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSrcRegionCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSrcRegionCodesIsMutable();
      srcRegionCodes_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>
        userDefinedFields_ = java.util.Collections.emptyList();

    private void ensureUserDefinedFieldsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        userDefinedFields_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>(
                userDefinedFields_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                .Builder,
            com.google.cloud.compute.v1
                .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder>
        userDefinedFieldsBuilder_;

    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>
        getUserDefinedFieldsList() {
      if (userDefinedFieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(userDefinedFields_);
      } else {
        return userDefinedFieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public int getUserDefinedFieldsCount() {
      if (userDefinedFieldsBuilder_ == null) {
        return userDefinedFields_.size();
      } else {
        return userDefinedFieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
        getUserDefinedFields(int index) {
      if (userDefinedFieldsBuilder_ == null) {
        return userDefinedFields_.get(index);
      } else {
        return userDefinedFieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder setUserDefinedFields(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch value) {
      if (userDefinedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.set(index, value);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder setUserDefinedFields(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.Builder
            builderForValue) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.set(index, builderForValue.build());
        onChanged();
      } else {
        userDefinedFieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch value) {
      if (userDefinedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(value);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch value) {
      if (userDefinedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(index, value);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.Builder
            builderForValue) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(builderForValue.build());
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.Builder
            builderForValue) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(index, builderForValue.build());
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder addAllUserDefinedFields(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>
            values) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userDefinedFields_);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder clearUserDefinedFields() {
      if (userDefinedFieldsBuilder_ == null) {
        userDefinedFields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public Builder removeUserDefinedFields(int index) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.remove(index);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.Builder
        getUserDefinedFieldsBuilder(int index) {
      return getUserDefinedFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder
        getUserDefinedFieldsOrBuilder(int index) {
      if (userDefinedFieldsBuilder_ == null) {
        return userDefinedFields_.get(index);
      } else {
        return userDefinedFieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder>
        getUserDefinedFieldsOrBuilderList() {
      if (userDefinedFieldsBuilder_ != null) {
        return userDefinedFieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(userDefinedFields_);
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.Builder
        addUserDefinedFieldsBuilder() {
      return getUserDefinedFieldsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch.Builder
        addUserDefinedFieldsBuilder(int index) {
      return getUserDefinedFieldsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * User-defined fields. Each element names a defined field and lists the matching values for that field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch user_defined_fields = 28312739;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                .Builder>
        getUserDefinedFieldsBuilderList() {
      return getUserDefinedFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                .Builder,
            com.google.cloud.compute.v1
                .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder>
        getUserDefinedFieldsFieldBuilder() {
      if (userDefinedFieldsBuilder_ == null) {
        userDefinedFieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch,
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
                    .Builder,
                com.google.cloud.compute.v1
                    .SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatchOrBuilder>(
                userDefinedFields_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        userDefinedFields_ = null;
      }
      return userDefinedFieldsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher)
  private static final com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher();
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPolicyRuleNetworkMatcher> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPolicyRuleNetworkMatcher>() {
        @java.lang.Override
        public SecurityPolicyRuleNetworkMatcher parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPolicyRuleNetworkMatcher> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPolicyRuleNetworkMatcher> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
