/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an SSL certificate resource. Google Compute Engine has two SSL certificate resources: * [Global](/compute/docs/reference/rest/v1/sslCertificates) * [Regional](/compute/docs/reference/rest/v1/regionSslCertificates) The global SSL certificates (sslCertificates) are used by: - Global external Application Load Balancers - Classic Application Load Balancers - Proxy Network Load Balancers (with target SSL proxies) The regional SSL certificates (regionSslCertificates) are used by: - Regional external Application Load Balancers - Regional internal Application Load Balancers Optionally, certificate file contents that you upload can contain a set of up to five PEM-encoded certificates. The API call creates an object (sslCertificate) that holds this data. You can use SSL keys and certificates to secure connections to a load balancer. For more information, read Creating and using SSL certificates, SSL certificates quotas and limits, and Troubleshooting SSL certificates.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SslCertificate}
 */
public final class SslCertificate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SslCertificate)
    SslCertificateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SslCertificate.newBuilder() to construct.
  private SslCertificate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SslCertificate() {
    certificate_ = "";
    creationTimestamp_ = "";
    description_ = "";
    expireTime_ = "";
    kind_ = "";
    name_ = "";
    privateKey_ = "";
    region_ = "";
    selfLink_ = "";
    subjectAlternativeNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SslCertificate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SslCertificate_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SslCertificate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SslCertificate.class,
            com.google.cloud.compute.v1.SslCertificate.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SslCertificate.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * Google-managed SSLCertificate.
     * </pre>
     *
     * <code>MANAGED = 479501183;</code>
     */
    MANAGED(479501183),
    /**
     *
     *
     * <pre>
     * Certificate uploaded by user.
     * </pre>
     *
     * <code>SELF_MANAGED = 434437516;</code>
     */
    SELF_MANAGED(434437516),
    /** <code>TYPE_UNSPECIFIED = 437714322;</code> */
    TYPE_UNSPECIFIED(437714322),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Google-managed SSLCertificate.
     * </pre>
     *
     * <code>MANAGED = 479501183;</code>
     */
    public static final int MANAGED_VALUE = 479501183;
    /**
     *
     *
     * <pre>
     * Certificate uploaded by user.
     * </pre>
     *
     * <code>SELF_MANAGED = 434437516;</code>
     */
    public static final int SELF_MANAGED_VALUE = 434437516;
    /** <code>TYPE_UNSPECIFIED = 437714322;</code> */
    public static final int TYPE_UNSPECIFIED_VALUE = 437714322;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 479501183:
          return MANAGED;
        case 434437516:
          return SELF_MANAGED;
        case 437714322:
          return TYPE_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SslCertificate.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SslCertificate.Type)
  }

  private int bitField0_;
  public static final int CERTIFICATE_FIELD_NUMBER = 341787031;

  @SuppressWarnings("serial")
  private volatile java.lang.Object certificate_ = "";
  /**
   *
   *
   * <pre>
   * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
   * </pre>
   *
   * <code>optional string certificate = 341787031;</code>
   *
   * @return Whether the certificate field is set.
   */
  @java.lang.Override
  public boolean hasCertificate() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
   * </pre>
   *
   * <code>optional string certificate = 341787031;</code>
   *
   * @return The certificate.
   */
  @java.lang.Override
  public java.lang.String getCertificate() {
    java.lang.Object ref = certificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      certificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
   * </pre>
   *
   * <code>optional string certificate = 341787031;</code>
   *
   * @return The bytes for certificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCertificateBytes() {
    java.lang.Object ref = certificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      certificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 440691181;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expireTime_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Expire time of the certificate. RFC3339
   * </pre>
   *
   * <code>optional string expire_time = 440691181;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Expire time of the certificate. RFC3339
   * </pre>
   *
   * <code>optional string expire_time = 440691181;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public java.lang.String getExpireTime() {
    java.lang.Object ref = expireTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expireTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Expire time of the certificate. RFC3339
   * </pre>
   *
   * <code>optional string expire_time = 440691181;</code>
   *
   * @return The bytes for expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpireTimeBytes() {
    java.lang.Object ref = expireTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expireTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MANAGED_FIELD_NUMBER = 298389407;
  private com.google.cloud.compute.v1.SslCertificateManagedSslCertificate managed_;
  /**
   *
   *
   * <pre>
   * Configuration and status of a managed SSL certificate.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
   * </code>
   *
   * @return Whether the managed field is set.
   */
  @java.lang.Override
  public boolean hasManaged() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration and status of a managed SSL certificate.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
   * </code>
   *
   * @return The managed.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate getManaged() {
    return managed_ == null
        ? com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDefaultInstance()
        : managed_;
  }
  /**
   *
   *
   * <pre>
   * Configuration and status of a managed SSL certificate.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SslCertificateManagedSslCertificateOrBuilder
      getManagedOrBuilder() {
    return managed_ == null
        ? com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDefaultInstance()
        : managed_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_KEY_FIELD_NUMBER = 361331107;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateKey_ = "";
  /**
   *
   *
   * <pre>
   * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
   * </pre>
   *
   * <code>optional string private_key = 361331107;</code>
   *
   * @return Whether the privateKey field is set.
   */
  @java.lang.Override
  public boolean hasPrivateKey() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
   * </pre>
   *
   * <code>optional string private_key = 361331107;</code>
   *
   * @return The privateKey.
   */
  @java.lang.Override
  public java.lang.String getPrivateKey() {
    java.lang.Object ref = privateKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
   * </pre>
   *
   * <code>optional string private_key = 361331107;</code>
   *
   * @return The bytes for privateKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateKeyBytes() {
    java.lang.Object ref = privateKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_MANAGED_FIELD_NUMBER = 329284012;
  private com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate selfManaged_;
  /**
   *
   *
   * <pre>
   * Configuration and status of a self-managed SSL certificate.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
   * </code>
   *
   * @return Whether the selfManaged field is set.
   */
  @java.lang.Override
  public boolean hasSelfManaged() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration and status of a self-managed SSL certificate.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
   * </code>
   *
   * @return The selfManaged.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate getSelfManaged() {
    return selfManaged_ == null
        ? com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.getDefaultInstance()
        : selfManaged_;
  }
  /**
   *
   *
   * <pre>
   * Configuration and status of a self-managed SSL certificate.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificateOrBuilder
      getSelfManagedOrBuilder() {
    return selfManaged_ == null
        ? com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.getDefaultInstance()
        : selfManaged_;
  }

  public static final int SUBJECT_ALTERNATIVE_NAMES_FIELD_NUMBER = 528807907;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subjectAlternativeNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * [Output Only] Domains associated with the certificate via Subject Alternative Name.
   * </pre>
   *
   * <code>repeated string subject_alternative_names = 528807907;</code>
   *
   * @return A list containing the subjectAlternativeNames.
   */
  public com.google.protobuf.ProtocolStringList getSubjectAlternativeNamesList() {
    return subjectAlternativeNames_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Domains associated with the certificate via Subject Alternative Name.
   * </pre>
   *
   * <code>repeated string subject_alternative_names = 528807907;</code>
   *
   * @return The count of subjectAlternativeNames.
   */
  public int getSubjectAlternativeNamesCount() {
    return subjectAlternativeNames_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Domains associated with the certificate via Subject Alternative Name.
   * </pre>
   *
   * <code>repeated string subject_alternative_names = 528807907;</code>
   *
   * @param index The index of the element to return.
   * @return The subjectAlternativeNames at the given index.
   */
  public java.lang.String getSubjectAlternativeNames(int index) {
    return subjectAlternativeNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Domains associated with the certificate via Subject Alternative Name.
   * </pre>
   *
   * <code>repeated string subject_alternative_names = 528807907;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subjectAlternativeNames at the given index.
   */
  public com.google.protobuf.ByteString getSubjectAlternativeNamesBytes(int index) {
    return subjectAlternativeNames_.getByteString(index);
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(298389407, getManaged());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(329284012, getSelfManaged());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 341787031, certificate_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 361331107, privateKey_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 440691181, expireTime_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < subjectAlternativeNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 528807907, subjectAlternativeNames_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(298389407, getManaged());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(329284012, getSelfManaged());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(341787031, certificate_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(361331107, privateKey_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(440691181, expireTime_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subjectAlternativeNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(subjectAlternativeNames_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSubjectAlternativeNamesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SslCertificate)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SslCertificate other =
        (com.google.cloud.compute.v1.SslCertificate) obj;

    if (hasCertificate() != other.hasCertificate()) return false;
    if (hasCertificate()) {
      if (!getCertificate().equals(other.getCertificate())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasManaged() != other.hasManaged()) return false;
    if (hasManaged()) {
      if (!getManaged().equals(other.getManaged())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPrivateKey() != other.hasPrivateKey()) return false;
    if (hasPrivateKey()) {
      if (!getPrivateKey().equals(other.getPrivateKey())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSelfManaged() != other.hasSelfManaged()) return false;
    if (hasSelfManaged()) {
      if (!getSelfManaged().equals(other.getSelfManaged())) return false;
    }
    if (!getSubjectAlternativeNamesList().equals(other.getSubjectAlternativeNamesList()))
      return false;
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCertificate()) {
      hash = (37 * hash) + CERTIFICATE_FIELD_NUMBER;
      hash = (53 * hash) + getCertificate().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasManaged()) {
      hash = (37 * hash) + MANAGED_FIELD_NUMBER;
      hash = (53 * hash) + getManaged().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPrivateKey()) {
      hash = (37 * hash) + PRIVATE_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateKey().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSelfManaged()) {
      hash = (37 * hash) + SELF_MANAGED_FIELD_NUMBER;
      hash = (53 * hash) + getSelfManaged().hashCode();
    }
    if (getSubjectAlternativeNamesCount() > 0) {
      hash = (37 * hash) + SUBJECT_ALTERNATIVE_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getSubjectAlternativeNamesList().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SslCertificate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.SslCertificate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an SSL certificate resource. Google Compute Engine has two SSL certificate resources: * [Global](/compute/docs/reference/rest/v1/sslCertificates) * [Regional](/compute/docs/reference/rest/v1/regionSslCertificates) The global SSL certificates (sslCertificates) are used by: - Global external Application Load Balancers - Classic Application Load Balancers - Proxy Network Load Balancers (with target SSL proxies) The regional SSL certificates (regionSslCertificates) are used by: - Regional external Application Load Balancers - Regional internal Application Load Balancers Optionally, certificate file contents that you upload can contain a set of up to five PEM-encoded certificates. The API call creates an object (sslCertificate) that holds this data. You can use SSL keys and certificates to secure connections to a load balancer. For more information, read Creating and using SSL certificates, SSL certificates quotas and limits, and Troubleshooting SSL certificates.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SslCertificate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SslCertificate)
      com.google.cloud.compute.v1.SslCertificateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SslCertificate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SslCertificate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SslCertificate.class,
              com.google.cloud.compute.v1.SslCertificate.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SslCertificate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getManagedFieldBuilder();
        getSelfManagedFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      certificate_ = "";
      creationTimestamp_ = "";
      description_ = "";
      expireTime_ = "";
      id_ = 0L;
      kind_ = "";
      managed_ = null;
      if (managedBuilder_ != null) {
        managedBuilder_.dispose();
        managedBuilder_ = null;
      }
      name_ = "";
      privateKey_ = "";
      region_ = "";
      selfLink_ = "";
      selfManaged_ = null;
      if (selfManagedBuilder_ != null) {
        selfManagedBuilder_.dispose();
        selfManagedBuilder_ = null;
      }
      subjectAlternativeNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SslCertificate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SslCertificate getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SslCertificate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SslCertificate build() {
      com.google.cloud.compute.v1.SslCertificate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SslCertificate buildPartial() {
      com.google.cloud.compute.v1.SslCertificate result =
          new com.google.cloud.compute.v1.SslCertificate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.SslCertificate result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.certificate_ = certificate_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.expireTime_ = expireTime_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.managed_ = managedBuilder_ == null ? managed_ : managedBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.privateKey_ = privateKey_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.selfManaged_ =
            selfManagedBuilder_ == null ? selfManaged_ : selfManagedBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        subjectAlternativeNames_.makeImmutable();
        result.subjectAlternativeNames_ = subjectAlternativeNames_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SslCertificate) {
        return mergeFrom((com.google.cloud.compute.v1.SslCertificate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SslCertificate other) {
      if (other == com.google.cloud.compute.v1.SslCertificate.getDefaultInstance()) return this;
      if (other.hasCertificate()) {
        certificate_ = other.certificate_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasExpireTime()) {
        expireTime_ = other.expireTime_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasManaged()) {
        mergeManaged(other.getManaged());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasPrivateKey()) {
        privateKey_ = other.privateKey_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasSelfManaged()) {
        mergeSelfManaged(other.getSelfManaged());
      }
      if (!other.subjectAlternativeNames_.isEmpty()) {
        if (subjectAlternativeNames_.isEmpty()) {
          subjectAlternativeNames_ = other.subjectAlternativeNames_;
          bitField0_ |= 0x00001000;
        } else {
          ensureSubjectAlternativeNamesIsMutable();
          subjectAlternativeNames_.addAll(other.subjectAlternativeNames_);
        }
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26989658
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 28604882
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 1111570338
            case -1907852038:
              {
                input.readMessage(getManagedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case -1907852038
            case -1660695198:
              {
                input.readMessage(getSelfManagedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case -1660695198
            case -1560671046:
              {
                certificate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1560671046
            case -1404318438:
              {
                privateKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -1404318438
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -769437846:
              {
                expireTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -769437846
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -645248918
            case -64504038:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSubjectAlternativeNamesIsMutable();
                subjectAlternativeNames_.add(s);
                break;
              } // case -64504038
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object certificate_ = "";
    /**
     *
     *
     * <pre>
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     * </pre>
     *
     * <code>optional string certificate = 341787031;</code>
     *
     * @return Whether the certificate field is set.
     */
    public boolean hasCertificate() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     * </pre>
     *
     * <code>optional string certificate = 341787031;</code>
     *
     * @return The certificate.
     */
    public java.lang.String getCertificate() {
      java.lang.Object ref = certificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        certificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     * </pre>
     *
     * <code>optional string certificate = 341787031;</code>
     *
     * @return The bytes for certificate.
     */
    public com.google.protobuf.ByteString getCertificateBytes() {
      java.lang.Object ref = certificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        certificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     * </pre>
     *
     * <code>optional string certificate = 341787031;</code>
     *
     * @param value The certificate to set.
     * @return This builder for chaining.
     */
    public Builder setCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      certificate_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     * </pre>
     *
     * <code>optional string certificate = 341787031;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCertificate() {
      certificate_ = getDefaultInstance().getCertificate();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     * </pre>
     *
     * <code>optional string certificate = 341787031;</code>
     *
     * @param value The bytes for certificate to set.
     * @return This builder for chaining.
     */
    public Builder setCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      certificate_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object expireTime_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Expire time of the certificate. RFC3339
     * </pre>
     *
     * <code>optional string expire_time = 440691181;</code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Expire time of the certificate. RFC3339
     * </pre>
     *
     * <code>optional string expire_time = 440691181;</code>
     *
     * @return The expireTime.
     */
    public java.lang.String getExpireTime() {
      java.lang.Object ref = expireTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expireTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Expire time of the certificate. RFC3339
     * </pre>
     *
     * <code>optional string expire_time = 440691181;</code>
     *
     * @return The bytes for expireTime.
     */
    public com.google.protobuf.ByteString getExpireTimeBytes() {
      java.lang.Object ref = expireTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expireTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Expire time of the certificate. RFC3339
     * </pre>
     *
     * <code>optional string expire_time = 440691181;</code>
     *
     * @param value The expireTime to set.
     * @return This builder for chaining.
     */
    public Builder setExpireTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expireTime_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Expire time of the certificate. RFC3339
     * </pre>
     *
     * <code>optional string expire_time = 440691181;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpireTime() {
      expireTime_ = getDefaultInstance().getExpireTime();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Expire time of the certificate. RFC3339
     * </pre>
     *
     * <code>optional string expire_time = 440691181;</code>
     *
     * @param value The bytes for expireTime to set.
     * @return This builder for chaining.
     */
    public Builder setExpireTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expireTime_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SslCertificateManagedSslCertificate managed_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificate,
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder,
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificateOrBuilder>
        managedBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     *
     * @return Whether the managed field is set.
     */
    public boolean hasManaged() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     *
     * @return The managed.
     */
    public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate getManaged() {
      if (managedBuilder_ == null) {
        return managed_ == null
            ? com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDefaultInstance()
            : managed_;
      } else {
        return managedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    public Builder setManaged(
        com.google.cloud.compute.v1.SslCertificateManagedSslCertificate value) {
      if (managedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        managed_ = value;
      } else {
        managedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    public Builder setManaged(
        com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder builderForValue) {
      if (managedBuilder_ == null) {
        managed_ = builderForValue.build();
      } else {
        managedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    public Builder mergeManaged(
        com.google.cloud.compute.v1.SslCertificateManagedSslCertificate value) {
      if (managedBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && managed_ != null
            && managed_
                != com.google.cloud.compute.v1.SslCertificateManagedSslCertificate
                    .getDefaultInstance()) {
          getManagedBuilder().mergeFrom(value);
        } else {
          managed_ = value;
        }
      } else {
        managedBuilder_.mergeFrom(value);
      }
      if (managed_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    public Builder clearManaged() {
      bitField0_ = (bitField0_ & ~0x00000040);
      managed_ = null;
      if (managedBuilder_ != null) {
        managedBuilder_.dispose();
        managedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder
        getManagedBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getManagedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    public com.google.cloud.compute.v1.SslCertificateManagedSslCertificateOrBuilder
        getManagedOrBuilder() {
      if (managedBuilder_ != null) {
        return managedBuilder_.getMessageOrBuilder();
      } else {
        return managed_ == null
            ? com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDefaultInstance()
            : managed_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificate,
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder,
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificateOrBuilder>
        getManagedFieldBuilder() {
      if (managedBuilder_ == null) {
        managedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SslCertificateManagedSslCertificate,
                com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder,
                com.google.cloud.compute.v1.SslCertificateManagedSslCertificateOrBuilder>(
                getManaged(), getParentForChildren(), isClean());
        managed_ = null;
      }
      return managedBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object privateKey_ = "";
    /**
     *
     *
     * <pre>
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     * </pre>
     *
     * <code>optional string private_key = 361331107;</code>
     *
     * @return Whether the privateKey field is set.
     */
    public boolean hasPrivateKey() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     * </pre>
     *
     * <code>optional string private_key = 361331107;</code>
     *
     * @return The privateKey.
     */
    public java.lang.String getPrivateKey() {
      java.lang.Object ref = privateKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     * </pre>
     *
     * <code>optional string private_key = 361331107;</code>
     *
     * @return The bytes for privateKey.
     */
    public com.google.protobuf.ByteString getPrivateKeyBytes() {
      java.lang.Object ref = privateKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     * </pre>
     *
     * <code>optional string private_key = 361331107;</code>
     *
     * @param value The privateKey to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateKey_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     * </pre>
     *
     * <code>optional string private_key = 361331107;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateKey() {
      privateKey_ = getDefaultInstance().getPrivateKey();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     * </pre>
     *
     * <code>optional string private_key = 361331107;</code>
     *
     * @param value The bytes for privateKey to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateKey_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate selfManaged_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate,
            com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.Builder,
            com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificateOrBuilder>
        selfManagedBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     *
     * @return Whether the selfManaged field is set.
     */
    public boolean hasSelfManaged() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     *
     * @return The selfManaged.
     */
    public com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate getSelfManaged() {
      if (selfManagedBuilder_ == null) {
        return selfManaged_ == null
            ? com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate
                .getDefaultInstance()
            : selfManaged_;
      } else {
        return selfManagedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    public Builder setSelfManaged(
        com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate value) {
      if (selfManagedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        selfManaged_ = value;
      } else {
        selfManagedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    public Builder setSelfManaged(
        com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.Builder
            builderForValue) {
      if (selfManagedBuilder_ == null) {
        selfManaged_ = builderForValue.build();
      } else {
        selfManagedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    public Builder mergeSelfManaged(
        com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate value) {
      if (selfManagedBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && selfManaged_ != null
            && selfManaged_
                != com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate
                    .getDefaultInstance()) {
          getSelfManagedBuilder().mergeFrom(value);
        } else {
          selfManaged_ = value;
        }
      } else {
        selfManagedBuilder_.mergeFrom(value);
      }
      if (selfManaged_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    public Builder clearSelfManaged() {
      bitField0_ = (bitField0_ & ~0x00000800);
      selfManaged_ = null;
      if (selfManagedBuilder_ != null) {
        selfManagedBuilder_.dispose();
        selfManagedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    public com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.Builder
        getSelfManagedBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getSelfManagedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    public com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificateOrBuilder
        getSelfManagedOrBuilder() {
      if (selfManagedBuilder_ != null) {
        return selfManagedBuilder_.getMessageOrBuilder();
      } else {
        return selfManaged_ == null
            ? com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate
                .getDefaultInstance()
            : selfManaged_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration and status of a self-managed SSL certificate.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate,
            com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.Builder,
            com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificateOrBuilder>
        getSelfManagedFieldBuilder() {
      if (selfManagedBuilder_ == null) {
        selfManagedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate,
                com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate.Builder,
                com.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificateOrBuilder>(
                getSelfManaged(), getParentForChildren(), isClean());
        selfManaged_ = null;
      }
      return selfManagedBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList subjectAlternativeNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSubjectAlternativeNamesIsMutable() {
      if (!subjectAlternativeNames_.isModifiable()) {
        subjectAlternativeNames_ =
            new com.google.protobuf.LazyStringArrayList(subjectAlternativeNames_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @return A list containing the subjectAlternativeNames.
     */
    public com.google.protobuf.ProtocolStringList getSubjectAlternativeNamesList() {
      subjectAlternativeNames_.makeImmutable();
      return subjectAlternativeNames_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @return The count of subjectAlternativeNames.
     */
    public int getSubjectAlternativeNamesCount() {
      return subjectAlternativeNames_.size();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @param index The index of the element to return.
     * @return The subjectAlternativeNames at the given index.
     */
    public java.lang.String getSubjectAlternativeNames(int index) {
      return subjectAlternativeNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the subjectAlternativeNames at the given index.
     */
    public com.google.protobuf.ByteString getSubjectAlternativeNamesBytes(int index) {
      return subjectAlternativeNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @param index The index to set the value at.
     * @param value The subjectAlternativeNames to set.
     * @return This builder for chaining.
     */
    public Builder setSubjectAlternativeNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectAlternativeNamesIsMutable();
      subjectAlternativeNames_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @param value The subjectAlternativeNames to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectAlternativeNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectAlternativeNamesIsMutable();
      subjectAlternativeNames_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @param values The subjectAlternativeNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubjectAlternativeNames(java.lang.Iterable<java.lang.String> values) {
      ensureSubjectAlternativeNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subjectAlternativeNames_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubjectAlternativeNames() {
      subjectAlternativeNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     * </pre>
     *
     * <code>repeated string subject_alternative_names = 528807907;</code>
     *
     * @param value The bytes of the subjectAlternativeNames to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectAlternativeNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSubjectAlternativeNamesIsMutable();
      subjectAlternativeNames_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SslCertificate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SslCertificate)
  private static final com.google.cloud.compute.v1.SslCertificate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SslCertificate();
  }

  public static com.google.cloud.compute.v1.SslCertificate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SslCertificate> PARSER =
      new com.google.protobuf.AbstractParser<SslCertificate>() {
        @java.lang.Override
        public SslCertificate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SslCertificate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SslCertificate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SslCertificate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
