/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Subnetwork resource. A subnetwork (also known as a subnet) is a logical partition of a Virtual Private Cloud network with one primary IP range and zero or more secondary IP ranges. For more information, read Virtual Private Cloud (VPC) Network.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Subnetwork}
 */
public final class Subnetwork extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Subnetwork)
    SubnetworkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Subnetwork.newBuilder() to construct.
  private Subnetwork(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Subnetwork() {
    creationTimestamp_ = "";
    description_ = "";
    externalIpv6Prefix_ = "";
    fingerprint_ = "";
    gatewayAddress_ = "";
    internalIpv6Prefix_ = "";
    ipCidrRange_ = "";
    ipv6AccessType_ = "";
    ipv6CidrRange_ = "";
    kind_ = "";
    name_ = "";
    network_ = "";
    privateIpv6GoogleAccess_ = "";
    purpose_ = "";
    region_ = "";
    reservedInternalRange_ = "";
    role_ = "";
    secondaryIpRanges_ = java.util.Collections.emptyList();
    selfLink_ = "";
    stackType_ = "";
    state_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Subnetwork();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Subnetwork_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Subnetwork_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Subnetwork.class,
            com.google.cloud.compute.v1.Subnetwork.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Subnetwork.Ipv6AccessType}
   */
  public enum Ipv6AccessType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IPV6_ACCESS_TYPE = 0;</code>
     */
    UNDEFINED_IPV6_ACCESS_TYPE(0),
    /**
     *
     *
     * <pre>
     * VMs on this subnet will be assigned IPv6 addresses that are accessible via the Internet, as well as the VPC network.
     * </pre>
     *
     * <code>EXTERNAL = 35607499;</code>
     */
    EXTERNAL(35607499),
    /**
     *
     *
     * <pre>
     * VMs on this subnet will be assigned IPv6 addresses that are only accessible over the VPC network.
     * </pre>
     *
     * <code>INTERNAL = 279295677;</code>
     */
    INTERNAL(279295677),
    /** <code>UNSPECIFIED_IPV6_ACCESS_TYPE = 313080613;</code> */
    UNSPECIFIED_IPV6_ACCESS_TYPE(313080613),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IPV6_ACCESS_TYPE = 0;</code>
     */
    public static final int UNDEFINED_IPV6_ACCESS_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * VMs on this subnet will be assigned IPv6 addresses that are accessible via the Internet, as well as the VPC network.
     * </pre>
     *
     * <code>EXTERNAL = 35607499;</code>
     */
    public static final int EXTERNAL_VALUE = 35607499;
    /**
     *
     *
     * <pre>
     * VMs on this subnet will be assigned IPv6 addresses that are only accessible over the VPC network.
     * </pre>
     *
     * <code>INTERNAL = 279295677;</code>
     */
    public static final int INTERNAL_VALUE = 279295677;
    /** <code>UNSPECIFIED_IPV6_ACCESS_TYPE = 313080613;</code> */
    public static final int UNSPECIFIED_IPV6_ACCESS_TYPE_VALUE = 313080613;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Ipv6AccessType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Ipv6AccessType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_IPV6_ACCESS_TYPE;
        case 35607499:
          return EXTERNAL;
        case 279295677:
          return INTERNAL;
        case 313080613:
          return UNSPECIFIED_IPV6_ACCESS_TYPE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Ipv6AccessType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Ipv6AccessType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Ipv6AccessType>() {
          public Ipv6AccessType findValueByNumber(int number) {
            return Ipv6AccessType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Subnetwork.getDescriptor().getEnumTypes().get(0);
    }

    private static final Ipv6AccessType[] VALUES = values();

    public static Ipv6AccessType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Ipv6AccessType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Subnetwork.Ipv6AccessType)
  }

  /**
   *
   *
   * <pre>
   * This field is for internal use. This field can be both set at resource creation time and updated using patch.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Subnetwork.PrivateIpv6GoogleAccess}
   */
  public enum PrivateIpv6GoogleAccess implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0;</code>
     */
    UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS(0),
    /**
     *
     *
     * <pre>
     * Disable private IPv6 access to/from Google services.
     * </pre>
     *
     * <code>DISABLE_GOOGLE_ACCESS = 450958579;</code>
     */
    DISABLE_GOOGLE_ACCESS(450958579),
    /**
     *
     *
     * <pre>
     * Bidirectional private IPv6 access to/from Google services.
     * </pre>
     *
     * <code>ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994;</code>
     */
    ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE(427975994),
    /**
     *
     *
     * <pre>
     * Outbound private IPv6 access from VMs in this subnet to Google services.
     * </pre>
     *
     * <code>ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263;</code>
     */
    ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE(288210263),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0;</code>
     */
    public static final int UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Disable private IPv6 access to/from Google services.
     * </pre>
     *
     * <code>DISABLE_GOOGLE_ACCESS = 450958579;</code>
     */
    public static final int DISABLE_GOOGLE_ACCESS_VALUE = 450958579;
    /**
     *
     *
     * <pre>
     * Bidirectional private IPv6 access to/from Google services.
     * </pre>
     *
     * <code>ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994;</code>
     */
    public static final int ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE_VALUE = 427975994;
    /**
     *
     *
     * <pre>
     * Outbound private IPv6 access from VMs in this subnet to Google services.
     * </pre>
     *
     * <code>ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263;</code>
     */
    public static final int ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE_VALUE = 288210263;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrivateIpv6GoogleAccess valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PrivateIpv6GoogleAccess forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS;
        case 450958579:
          return DISABLE_GOOGLE_ACCESS;
        case 427975994:
          return ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE;
        case 288210263:
          return ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>() {
              public PrivateIpv6GoogleAccess findValueByNumber(int number) {
                return PrivateIpv6GoogleAccess.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Subnetwork.getDescriptor().getEnumTypes().get(1);
    }

    private static final PrivateIpv6GoogleAccess[] VALUES = values();

    public static PrivateIpv6GoogleAccess valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PrivateIpv6GoogleAccess(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Subnetwork.PrivateIpv6GoogleAccess)
  }

  /**
   *
   *
   * <pre>
   * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Subnetwork.Purpose}
   */
  public enum Purpose implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PURPOSE = 0;</code>
     */
    UNDEFINED_PURPOSE(0),
    /**
     *
     *
     * <pre>
     * Subnet reserved for Global Envoy-based Load Balancing.
     * </pre>
     *
     * <code>GLOBAL_MANAGED_PROXY = 236463602;</code>
     */
    GLOBAL_MANAGED_PROXY(236463602),
    /**
     *
     *
     * <pre>
     * Subnet reserved for Internal HTTP(S) Load Balancing. This is a legacy purpose, please use REGIONAL_MANAGED_PROXY instead.
     * </pre>
     *
     * <code>INTERNAL_HTTPS_LOAD_BALANCER = 248748889;</code>
     */
    INTERNAL_HTTPS_LOAD_BALANCER(248748889),
    /**
     *
     *
     * <pre>
     * Regular user created or automatically created subnet.
     * </pre>
     *
     * <code>PRIVATE = 403485027;</code>
     */
    PRIVATE(403485027),
    /**
     *
     *
     * <pre>
     * Subnetwork used as source range for Private NAT Gateways.
     * </pre>
     *
     * <code>PRIVATE_NAT = 367764517;</code>
     */
    PRIVATE_NAT(367764517),
    /**
     *
     *
     * <pre>
     * Regular user created or automatically created subnet.
     * </pre>
     *
     * <code>PRIVATE_RFC_1918 = 254902107;</code>
     */
    PRIVATE_RFC_1918(254902107),
    /**
     *
     *
     * <pre>
     * Subnetworks created for Private Service Connect in the producer network.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 48134724;</code>
     */
    PRIVATE_SERVICE_CONNECT(48134724),
    /**
     *
     *
     * <pre>
     * Subnetwork used for Regional Envoy-based Load Balancing.
     * </pre>
     *
     * <code>REGIONAL_MANAGED_PROXY = 153049966;</code>
     */
    REGIONAL_MANAGED_PROXY(153049966),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PURPOSE = 0;</code>
     */
    public static final int UNDEFINED_PURPOSE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Subnet reserved for Global Envoy-based Load Balancing.
     * </pre>
     *
     * <code>GLOBAL_MANAGED_PROXY = 236463602;</code>
     */
    public static final int GLOBAL_MANAGED_PROXY_VALUE = 236463602;
    /**
     *
     *
     * <pre>
     * Subnet reserved for Internal HTTP(S) Load Balancing. This is a legacy purpose, please use REGIONAL_MANAGED_PROXY instead.
     * </pre>
     *
     * <code>INTERNAL_HTTPS_LOAD_BALANCER = 248748889;</code>
     */
    public static final int INTERNAL_HTTPS_LOAD_BALANCER_VALUE = 248748889;
    /**
     *
     *
     * <pre>
     * Regular user created or automatically created subnet.
     * </pre>
     *
     * <code>PRIVATE = 403485027;</code>
     */
    public static final int PRIVATE_VALUE = 403485027;
    /**
     *
     *
     * <pre>
     * Subnetwork used as source range for Private NAT Gateways.
     * </pre>
     *
     * <code>PRIVATE_NAT = 367764517;</code>
     */
    public static final int PRIVATE_NAT_VALUE = 367764517;
    /**
     *
     *
     * <pre>
     * Regular user created or automatically created subnet.
     * </pre>
     *
     * <code>PRIVATE_RFC_1918 = 254902107;</code>
     */
    public static final int PRIVATE_RFC_1918_VALUE = 254902107;
    /**
     *
     *
     * <pre>
     * Subnetworks created for Private Service Connect in the producer network.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 48134724;</code>
     */
    public static final int PRIVATE_SERVICE_CONNECT_VALUE = 48134724;
    /**
     *
     *
     * <pre>
     * Subnetwork used for Regional Envoy-based Load Balancing.
     * </pre>
     *
     * <code>REGIONAL_MANAGED_PROXY = 153049966;</code>
     */
    public static final int REGIONAL_MANAGED_PROXY_VALUE = 153049966;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Purpose valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Purpose forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PURPOSE;
        case 236463602:
          return GLOBAL_MANAGED_PROXY;
        case 248748889:
          return INTERNAL_HTTPS_LOAD_BALANCER;
        case 403485027:
          return PRIVATE;
        case 367764517:
          return PRIVATE_NAT;
        case 254902107:
          return PRIVATE_RFC_1918;
        case 48134724:
          return PRIVATE_SERVICE_CONNECT;
        case 153049966:
          return REGIONAL_MANAGED_PROXY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Purpose> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Purpose> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Purpose>() {
          public Purpose findValueByNumber(int number) {
            return Purpose.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Subnetwork.getDescriptor().getEnumTypes().get(2);
    }

    private static final Purpose[] VALUES = values();

    public static Purpose valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Purpose(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Subnetwork.Purpose)
  }

  /**
   *
   *
   * <pre>
   * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Subnetwork.Role}
   */
  public enum Role implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROLE = 0;</code>
     */
    UNDEFINED_ROLE(0),
    /**
     *
     *
     * <pre>
     * The ACTIVE subnet that is currently used.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /**
     *
     *
     * <pre>
     * The BACKUP subnet that could be promoted to ACTIVE.
     * </pre>
     *
     * <code>BACKUP = 341010882;</code>
     */
    BACKUP(341010882),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROLE = 0;</code>
     */
    public static final int UNDEFINED_ROLE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The ACTIVE subnet that is currently used.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;
    /**
     *
     *
     * <pre>
     * The BACKUP subnet that could be promoted to ACTIVE.
     * </pre>
     *
     * <code>BACKUP = 341010882;</code>
     */
    public static final int BACKUP_VALUE = 341010882;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Role valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Role forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ROLE;
        case 314733318:
          return ACTIVE;
        case 341010882:
          return BACKUP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Role> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Role> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Role>() {
          public Role findValueByNumber(int number) {
            return Role.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Subnetwork.getDescriptor().getEnumTypes().get(3);
    }

    private static final Role[] VALUES = values();

    public static Role valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Role(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Subnetwork.Role)
  }

  /**
   *
   *
   * <pre>
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Subnetwork.StackType}
   */
  public enum StackType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STACK_TYPE = 0;</code>
     */
    UNDEFINED_STACK_TYPE(0),
    /**
     *
     *
     * <pre>
     * New VMs in this subnet can have both IPv4 and IPv6 addresses.
     * </pre>
     *
     * <code>IPV4_IPV6 = 22197249;</code>
     */
    IPV4_IPV6(22197249),
    /**
     *
     *
     * <pre>
     * New VMs in this subnet will only be assigned IPv4 addresses.
     * </pre>
     *
     * <code>IPV4_ONLY = 22373798;</code>
     */
    IPV4_ONLY(22373798),
    /** <code>UNSPECIFIED_STACK_TYPE = 298084569;</code> */
    UNSPECIFIED_STACK_TYPE(298084569),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STACK_TYPE = 0;</code>
     */
    public static final int UNDEFINED_STACK_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * New VMs in this subnet can have both IPv4 and IPv6 addresses.
     * </pre>
     *
     * <code>IPV4_IPV6 = 22197249;</code>
     */
    public static final int IPV4_IPV6_VALUE = 22197249;
    /**
     *
     *
     * <pre>
     * New VMs in this subnet will only be assigned IPv4 addresses.
     * </pre>
     *
     * <code>IPV4_ONLY = 22373798;</code>
     */
    public static final int IPV4_ONLY_VALUE = 22373798;
    /** <code>UNSPECIFIED_STACK_TYPE = 298084569;</code> */
    public static final int UNSPECIFIED_STACK_TYPE_VALUE = 298084569;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StackType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StackType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STACK_TYPE;
        case 22197249:
          return IPV4_IPV6;
        case 22373798:
          return IPV4_ONLY;
        case 298084569:
          return UNSPECIFIED_STACK_TYPE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StackType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StackType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<StackType>() {
          public StackType findValueByNumber(int number) {
            return StackType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Subnetwork.getDescriptor().getEnumTypes().get(4);
    }

    private static final StackType[] VALUES = values();

    public static StackType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StackType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Subnetwork.StackType)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Subnetwork.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    UNDEFINED_STATE(0),
    /**
     *
     *
     * <pre>
     * Subnetwork is being drained.
     * </pre>
     *
     * <code>DRAINING = 480455402;</code>
     */
    DRAINING(480455402),
    /**
     *
     *
     * <pre>
     * Subnetwork is ready for use.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    READY(77848963),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    public static final int UNDEFINED_STATE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Subnetwork is being drained.
     * </pre>
     *
     * <code>DRAINING = 480455402;</code>
     */
    public static final int DRAINING_VALUE = 480455402;
    /**
     *
     *
     * <pre>
     * Subnetwork is ready for use.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    public static final int READY_VALUE = 77848963;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATE;
        case 480455402:
          return DRAINING;
        case 77848963:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Subnetwork.getDescriptor().getEnumTypes().get(5);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Subnetwork.State)
  }

  private int bitField0_;
  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_FLOW_LOGS_FIELD_NUMBER = 151544420;
  private boolean enableFlowLogs_ = false;
  /**
   *
   *
   * <pre>
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * </pre>
   *
   * <code>optional bool enable_flow_logs = 151544420;</code>
   *
   * @return Whether the enableFlowLogs field is set.
   */
  @java.lang.Override
  public boolean hasEnableFlowLogs() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * </pre>
   *
   * <code>optional bool enable_flow_logs = 151544420;</code>
   *
   * @return The enableFlowLogs.
   */
  @java.lang.Override
  public boolean getEnableFlowLogs() {
    return enableFlowLogs_;
  }

  public static final int EXTERNAL_IPV6_PREFIX_FIELD_NUMBER = 139299190;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalIpv6Prefix_ = "";
  /**
   *
   *
   * <pre>
   * The external IPv6 address range that is owned by this subnetwork.
   * </pre>
   *
   * <code>optional string external_ipv6_prefix = 139299190;</code>
   *
   * @return Whether the externalIpv6Prefix field is set.
   */
  @java.lang.Override
  public boolean hasExternalIpv6Prefix() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The external IPv6 address range that is owned by this subnetwork.
   * </pre>
   *
   * <code>optional string external_ipv6_prefix = 139299190;</code>
   *
   * @return The externalIpv6Prefix.
   */
  @java.lang.Override
  public java.lang.String getExternalIpv6Prefix() {
    java.lang.Object ref = externalIpv6Prefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalIpv6Prefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The external IPv6 address range that is owned by this subnetwork.
   * </pre>
   *
   * <code>optional string external_ipv6_prefix = 139299190;</code>
   *
   * @return The bytes for externalIpv6Prefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalIpv6PrefixBytes() {
    java.lang.Object ref = externalIpv6Prefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalIpv6Prefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GATEWAY_ADDRESS_FIELD_NUMBER = 459867385;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gatewayAddress_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
   * </pre>
   *
   * <code>optional string gateway_address = 459867385;</code>
   *
   * @return Whether the gatewayAddress field is set.
   */
  @java.lang.Override
  public boolean hasGatewayAddress() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
   * </pre>
   *
   * <code>optional string gateway_address = 459867385;</code>
   *
   * @return The gatewayAddress.
   */
  @java.lang.Override
  public java.lang.String getGatewayAddress() {
    java.lang.Object ref = gatewayAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gatewayAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
   * </pre>
   *
   * <code>optional string gateway_address = 459867385;</code>
   *
   * @return The bytes for gatewayAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGatewayAddressBytes() {
    java.lang.Object ref = gatewayAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gatewayAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTERNAL_IPV6_PREFIX_FIELD_NUMBER = 506270056;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalIpv6Prefix_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
   * </pre>
   *
   * <code>optional string internal_ipv6_prefix = 506270056;</code>
   *
   * @return Whether the internalIpv6Prefix field is set.
   */
  @java.lang.Override
  public boolean hasInternalIpv6Prefix() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
   * </pre>
   *
   * <code>optional string internal_ipv6_prefix = 506270056;</code>
   *
   * @return The internalIpv6Prefix.
   */
  @java.lang.Override
  public java.lang.String getInternalIpv6Prefix() {
    java.lang.Object ref = internalIpv6Prefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalIpv6Prefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
   * </pre>
   *
   * <code>optional string internal_ipv6_prefix = 506270056;</code>
   *
   * @return The bytes for internalIpv6Prefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalIpv6PrefixBytes() {
    java.lang.Object ref = internalIpv6Prefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalIpv6Prefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_CIDR_RANGE_FIELD_NUMBER = 98117322;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipCidrRange_ = "";
  /**
   *
   *
   * <pre>
   * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return Whether the ipCidrRange field is set.
   */
  @java.lang.Override
  public boolean hasIpCidrRange() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return The ipCidrRange.
   */
  @java.lang.Override
  public java.lang.String getIpCidrRange() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipCidrRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return The bytes for ipCidrRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpCidrRangeBytes() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipCidrRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPV6_ACCESS_TYPE_FIELD_NUMBER = 504658653;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipv6AccessType_ = "";
  /**
   *
   *
   * <pre>
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * Check the Ipv6AccessType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ipv6_access_type = 504658653;</code>
   *
   * @return Whether the ipv6AccessType field is set.
   */
  @java.lang.Override
  public boolean hasIpv6AccessType() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * Check the Ipv6AccessType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ipv6_access_type = 504658653;</code>
   *
   * @return The ipv6AccessType.
   */
  @java.lang.Override
  public java.lang.String getIpv6AccessType() {
    java.lang.Object ref = ipv6AccessType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipv6AccessType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * Check the Ipv6AccessType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ipv6_access_type = 504658653;</code>
   *
   * @return The bytes for ipv6AccessType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpv6AccessTypeBytes() {
    java.lang.Object ref = ipv6AccessType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipv6AccessType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPV6_CIDR_RANGE_FIELD_NUMBER = 273141258;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipv6CidrRange_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] This field is for internal use.
   * </pre>
   *
   * <code>optional string ipv6_cidr_range = 273141258;</code>
   *
   * @return Whether the ipv6CidrRange field is set.
   */
  @java.lang.Override
  public boolean hasIpv6CidrRange() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] This field is for internal use.
   * </pre>
   *
   * <code>optional string ipv6_cidr_range = 273141258;</code>
   *
   * @return The ipv6CidrRange.
   */
  @java.lang.Override
  public java.lang.String getIpv6CidrRange() {
    java.lang.Object ref = ipv6CidrRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipv6CidrRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] This field is for internal use.
   * </pre>
   *
   * <code>optional string ipv6_cidr_range = 273141258;</code>
   *
   * @return The bytes for ipv6CidrRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpv6CidrRangeBytes() {
    java.lang.Object ref = ipv6CidrRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipv6CidrRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_CONFIG_FIELD_NUMBER = 351299741;
  private com.google.cloud.compute.v1.SubnetworkLogConfig logConfig_;
  /**
   *
   *
   * <pre>
   * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
   *
   * @return Whether the logConfig field is set.
   */
  @java.lang.Override
  public boolean hasLogConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
   *
   * @return The logConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkLogConfig getLogConfig() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance()
        : logConfig_;
  }
  /**
   *
   *
   * <pre>
   * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkLogConfigOrBuilder getLogConfigOrBuilder() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance()
        : logConfig_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_IP_GOOGLE_ACCESS_FIELD_NUMBER = 421491790;
  private boolean privateIpGoogleAccess_ = false;
  /**
   *
   *
   * <pre>
   * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
   * </pre>
   *
   * <code>optional bool private_ip_google_access = 421491790;</code>
   *
   * @return Whether the privateIpGoogleAccess field is set.
   */
  @java.lang.Override
  public boolean hasPrivateIpGoogleAccess() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
   * </pre>
   *
   * <code>optional bool private_ip_google_access = 421491790;</code>
   *
   * @return The privateIpGoogleAccess.
   */
  @java.lang.Override
  public boolean getPrivateIpGoogleAccess() {
    return privateIpGoogleAccess_;
  }

  public static final int PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER = 48277006;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateIpv6GoogleAccess_ = "";
  /**
   *
   *
   * <pre>
   * This field is for internal use. This field can be both set at resource creation time and updated using patch.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return Whether the privateIpv6GoogleAccess field is set.
   */
  @java.lang.Override
  public boolean hasPrivateIpv6GoogleAccess() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is for internal use. This field can be both set at resource creation time and updated using patch.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public java.lang.String getPrivateIpv6GoogleAccess() {
    java.lang.Object ref = privateIpv6GoogleAccess_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateIpv6GoogleAccess_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is for internal use. This field can be both set at resource creation time and updated using patch.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The bytes for privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes() {
    java.lang.Object ref = privateIpv6GoogleAccess_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateIpv6GoogleAccess_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PURPOSE_FIELD_NUMBER = 316407070;

  @SuppressWarnings("serial")
  private volatile java.lang.Object purpose_ = "";
  /**
   *
   *
   * <pre>
   * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
   * Check the Purpose enum for the list of possible values.
   * </pre>
   *
   * <code>optional string purpose = 316407070;</code>
   *
   * @return Whether the purpose field is set.
   */
  @java.lang.Override
  public boolean hasPurpose() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
   * Check the Purpose enum for the list of possible values.
   * </pre>
   *
   * <code>optional string purpose = 316407070;</code>
   *
   * @return The purpose.
   */
  @java.lang.Override
  public java.lang.String getPurpose() {
    java.lang.Object ref = purpose_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      purpose_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
   * Check the Purpose enum for the list of possible values.
   * </pre>
   *
   * <code>optional string purpose = 316407070;</code>
   *
   * @return The bytes for purpose.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPurposeBytes() {
    java.lang.Object ref = purpose_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      purpose_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_INTERNAL_RANGE_FIELD_NUMBER = 286248754;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reservedInternalRange_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the reserved internal range.
   * </pre>
   *
   * <code>optional string reserved_internal_range = 286248754;</code>
   *
   * @return Whether the reservedInternalRange field is set.
   */
  @java.lang.Override
  public boolean hasReservedInternalRange() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of the reserved internal range.
   * </pre>
   *
   * <code>optional string reserved_internal_range = 286248754;</code>
   *
   * @return The reservedInternalRange.
   */
  @java.lang.Override
  public java.lang.String getReservedInternalRange() {
    java.lang.Object ref = reservedInternalRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservedInternalRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the reserved internal range.
   * </pre>
   *
   * <code>optional string reserved_internal_range = 286248754;</code>
   *
   * @return The bytes for reservedInternalRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReservedInternalRangeBytes() {
    java.lang.Object ref = reservedInternalRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservedInternalRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLE_FIELD_NUMBER = 3506294;

  @SuppressWarnings("serial")
  private volatile java.lang.Object role_ = "";
  /**
   *
   *
   * <pre>
   * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
   * Check the Role enum for the list of possible values.
   * </pre>
   *
   * <code>optional string role = 3506294;</code>
   *
   * @return Whether the role field is set.
   */
  @java.lang.Override
  public boolean hasRole() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
   * Check the Role enum for the list of possible values.
   * </pre>
   *
   * <code>optional string role = 3506294;</code>
   *
   * @return The role.
   */
  @java.lang.Override
  public java.lang.String getRole() {
    java.lang.Object ref = role_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      role_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
   * Check the Role enum for the list of possible values.
   * </pre>
   *
   * <code>optional string role = 3506294;</code>
   *
   * @return The bytes for role.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRoleBytes() {
    java.lang.Object ref = role_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      role_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECONDARY_IP_RANGES_FIELD_NUMBER = 136658915;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SubnetworkSecondaryRange> secondaryIpRanges_;
  /**
   *
   *
   * <pre>
   * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SubnetworkSecondaryRange>
      getSecondaryIpRangesList() {
    return secondaryIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder>
      getSecondaryIpRangesOrBuilderList() {
    return secondaryIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
   * </code>
   */
  @java.lang.Override
  public int getSecondaryIpRangesCount() {
    return secondaryIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkSecondaryRange getSecondaryIpRanges(int index) {
    return secondaryIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder
      getSecondaryIpRangesOrBuilder(int index) {
    return secondaryIpRanges_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STACK_TYPE_FIELD_NUMBER = 425908881;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stackType_ = "";
  /**
   *
   *
   * <pre>
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return Whether the stackType field is set.
   */
  @java.lang.Override
  public boolean hasStackType() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The stackType.
   */
  @java.lang.Override
  public java.lang.String getStackType() {
    java.lang.Object ref = stackType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stackType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The bytes for stackType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStackTypeBytes() {
    java.lang.Object ref = stackType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stackType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3506294, role_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 48277006, privateIpv6GoogleAccess_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 98117322, ipCidrRange_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    for (int i = 0; i < secondaryIpRanges_.size(); i++) {
      output.writeMessage(136658915, secondaryIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 139299190, externalIpv6Prefix_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(151544420, enableFlowLogs_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 273141258, ipv6CidrRange_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 286248754, reservedInternalRange_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 316407070, purpose_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeBool(421491790, privateIpGoogleAccess_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 425908881, stackType_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 459867385, gatewayAddress_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 504658653, ipv6AccessType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 506270056, internalIpv6Prefix_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3506294, role_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              48277006, privateIpv6GoogleAccess_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(98117322, ipCidrRange_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    for (int i = 0; i < secondaryIpRanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              136658915, secondaryIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(139299190, externalIpv6Prefix_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(151544420, enableFlowLogs_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(273141258, ipv6CidrRange_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              286248754, reservedInternalRange_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(316407070, purpose_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(421491790, privateIpGoogleAccess_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(425908881, stackType_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(459867385, gatewayAddress_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(504658653, ipv6AccessType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(506270056, internalIpv6Prefix_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Subnetwork)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Subnetwork other = (com.google.cloud.compute.v1.Subnetwork) obj;

    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEnableFlowLogs() != other.hasEnableFlowLogs()) return false;
    if (hasEnableFlowLogs()) {
      if (getEnableFlowLogs() != other.getEnableFlowLogs()) return false;
    }
    if (hasExternalIpv6Prefix() != other.hasExternalIpv6Prefix()) return false;
    if (hasExternalIpv6Prefix()) {
      if (!getExternalIpv6Prefix().equals(other.getExternalIpv6Prefix())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasGatewayAddress() != other.hasGatewayAddress()) return false;
    if (hasGatewayAddress()) {
      if (!getGatewayAddress().equals(other.getGatewayAddress())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInternalIpv6Prefix() != other.hasInternalIpv6Prefix()) return false;
    if (hasInternalIpv6Prefix()) {
      if (!getInternalIpv6Prefix().equals(other.getInternalIpv6Prefix())) return false;
    }
    if (hasIpCidrRange() != other.hasIpCidrRange()) return false;
    if (hasIpCidrRange()) {
      if (!getIpCidrRange().equals(other.getIpCidrRange())) return false;
    }
    if (hasIpv6AccessType() != other.hasIpv6AccessType()) return false;
    if (hasIpv6AccessType()) {
      if (!getIpv6AccessType().equals(other.getIpv6AccessType())) return false;
    }
    if (hasIpv6CidrRange() != other.hasIpv6CidrRange()) return false;
    if (hasIpv6CidrRange()) {
      if (!getIpv6CidrRange().equals(other.getIpv6CidrRange())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLogConfig() != other.hasLogConfig()) return false;
    if (hasLogConfig()) {
      if (!getLogConfig().equals(other.getLogConfig())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasPrivateIpGoogleAccess() != other.hasPrivateIpGoogleAccess()) return false;
    if (hasPrivateIpGoogleAccess()) {
      if (getPrivateIpGoogleAccess() != other.getPrivateIpGoogleAccess()) return false;
    }
    if (hasPrivateIpv6GoogleAccess() != other.hasPrivateIpv6GoogleAccess()) return false;
    if (hasPrivateIpv6GoogleAccess()) {
      if (!getPrivateIpv6GoogleAccess().equals(other.getPrivateIpv6GoogleAccess())) return false;
    }
    if (hasPurpose() != other.hasPurpose()) return false;
    if (hasPurpose()) {
      if (!getPurpose().equals(other.getPurpose())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasReservedInternalRange() != other.hasReservedInternalRange()) return false;
    if (hasReservedInternalRange()) {
      if (!getReservedInternalRange().equals(other.getReservedInternalRange())) return false;
    }
    if (hasRole() != other.hasRole()) return false;
    if (hasRole()) {
      if (!getRole().equals(other.getRole())) return false;
    }
    if (!getSecondaryIpRangesList().equals(other.getSecondaryIpRangesList())) return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStackType() != other.hasStackType()) return false;
    if (hasStackType()) {
      if (!getStackType().equals(other.getStackType())) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEnableFlowLogs()) {
      hash = (37 * hash) + ENABLE_FLOW_LOGS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableFlowLogs());
    }
    if (hasExternalIpv6Prefix()) {
      hash = (37 * hash) + EXTERNAL_IPV6_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getExternalIpv6Prefix().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasGatewayAddress()) {
      hash = (37 * hash) + GATEWAY_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getGatewayAddress().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInternalIpv6Prefix()) {
      hash = (37 * hash) + INTERNAL_IPV6_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getInternalIpv6Prefix().hashCode();
    }
    if (hasIpCidrRange()) {
      hash = (37 * hash) + IP_CIDR_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIpCidrRange().hashCode();
    }
    if (hasIpv6AccessType()) {
      hash = (37 * hash) + IPV6_ACCESS_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getIpv6AccessType().hashCode();
    }
    if (hasIpv6CidrRange()) {
      hash = (37 * hash) + IPV6_CIDR_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIpv6CidrRange().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLogConfig()) {
      hash = (37 * hash) + LOG_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLogConfig().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasPrivateIpGoogleAccess()) {
      hash = (37 * hash) + PRIVATE_IP_GOOGLE_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPrivateIpGoogleAccess());
    }
    if (hasPrivateIpv6GoogleAccess()) {
      hash = (37 * hash) + PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateIpv6GoogleAccess().hashCode();
    }
    if (hasPurpose()) {
      hash = (37 * hash) + PURPOSE_FIELD_NUMBER;
      hash = (53 * hash) + getPurpose().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasReservedInternalRange()) {
      hash = (37 * hash) + RESERVED_INTERNAL_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getReservedInternalRange().hashCode();
    }
    if (hasRole()) {
      hash = (37 * hash) + ROLE_FIELD_NUMBER;
      hash = (53 * hash) + getRole().hashCode();
    }
    if (getSecondaryIpRangesCount() > 0) {
      hash = (37 * hash) + SECONDARY_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryIpRangesList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStackType()) {
      hash = (37 * hash) + STACK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getStackType().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Subnetwork parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Subnetwork prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Subnetwork resource. A subnetwork (also known as a subnet) is a logical partition of a Virtual Private Cloud network with one primary IP range and zero or more secondary IP ranges. For more information, read Virtual Private Cloud (VPC) Network.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Subnetwork}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Subnetwork)
      com.google.cloud.compute.v1.SubnetworkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Subnetwork_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Subnetwork_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Subnetwork.class,
              com.google.cloud.compute.v1.Subnetwork.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Subnetwork.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLogConfigFieldBuilder();
        getSecondaryIpRangesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      creationTimestamp_ = "";
      description_ = "";
      enableFlowLogs_ = false;
      externalIpv6Prefix_ = "";
      fingerprint_ = "";
      gatewayAddress_ = "";
      id_ = 0L;
      internalIpv6Prefix_ = "";
      ipCidrRange_ = "";
      ipv6AccessType_ = "";
      ipv6CidrRange_ = "";
      kind_ = "";
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      name_ = "";
      network_ = "";
      privateIpGoogleAccess_ = false;
      privateIpv6GoogleAccess_ = "";
      purpose_ = "";
      region_ = "";
      reservedInternalRange_ = "";
      role_ = "";
      if (secondaryIpRangesBuilder_ == null) {
        secondaryIpRanges_ = java.util.Collections.emptyList();
      } else {
        secondaryIpRanges_ = null;
        secondaryIpRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      selfLink_ = "";
      stackType_ = "";
      state_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Subnetwork_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Subnetwork getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Subnetwork.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Subnetwork build() {
      com.google.cloud.compute.v1.Subnetwork result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Subnetwork buildPartial() {
      com.google.cloud.compute.v1.Subnetwork result =
          new com.google.cloud.compute.v1.Subnetwork(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Subnetwork result) {
      if (secondaryIpRangesBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          secondaryIpRanges_ = java.util.Collections.unmodifiableList(secondaryIpRanges_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.secondaryIpRanges_ = secondaryIpRanges_;
      } else {
        result.secondaryIpRanges_ = secondaryIpRangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Subnetwork result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableFlowLogs_ = enableFlowLogs_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.externalIpv6Prefix_ = externalIpv6Prefix_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.gatewayAddress_ = gatewayAddress_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.internalIpv6Prefix_ = internalIpv6Prefix_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.ipCidrRange_ = ipCidrRange_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ipv6AccessType_ = ipv6AccessType_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ipv6CidrRange_ = ipv6CidrRange_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.logConfig_ = logConfigBuilder_ == null ? logConfig_ : logConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.privateIpGoogleAccess_ = privateIpGoogleAccess_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.privateIpv6GoogleAccess_ = privateIpv6GoogleAccess_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.purpose_ = purpose_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.reservedInternalRange_ = reservedInternalRange_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.role_ = role_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.stackType_ = stackType_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00800000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Subnetwork) {
        return mergeFrom((com.google.cloud.compute.v1.Subnetwork) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Subnetwork other) {
      if (other == com.google.cloud.compute.v1.Subnetwork.getDefaultInstance()) return this;
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasEnableFlowLogs()) {
        setEnableFlowLogs(other.getEnableFlowLogs());
      }
      if (other.hasExternalIpv6Prefix()) {
        externalIpv6Prefix_ = other.externalIpv6Prefix_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasGatewayAddress()) {
        gatewayAddress_ = other.gatewayAddress_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInternalIpv6Prefix()) {
        internalIpv6Prefix_ = other.internalIpv6Prefix_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasIpCidrRange()) {
        ipCidrRange_ = other.ipCidrRange_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasIpv6AccessType()) {
        ipv6AccessType_ = other.ipv6AccessType_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasIpv6CidrRange()) {
        ipv6CidrRange_ = other.ipv6CidrRange_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasLogConfig()) {
        mergeLogConfig(other.getLogConfig());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasPrivateIpGoogleAccess()) {
        setPrivateIpGoogleAccess(other.getPrivateIpGoogleAccess());
      }
      if (other.hasPrivateIpv6GoogleAccess()) {
        privateIpv6GoogleAccess_ = other.privateIpv6GoogleAccess_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasPurpose()) {
        purpose_ = other.purpose_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasReservedInternalRange()) {
        reservedInternalRange_ = other.reservedInternalRange_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasRole()) {
        role_ = other.role_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (secondaryIpRangesBuilder_ == null) {
        if (!other.secondaryIpRanges_.isEmpty()) {
          if (secondaryIpRanges_.isEmpty()) {
            secondaryIpRanges_ = other.secondaryIpRanges_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureSecondaryIpRangesIsMutable();
            secondaryIpRanges_.addAll(other.secondaryIpRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.secondaryIpRanges_.isEmpty()) {
          if (secondaryIpRangesBuilder_.isEmpty()) {
            secondaryIpRangesBuilder_.dispose();
            secondaryIpRangesBuilder_ = null;
            secondaryIpRanges_ = other.secondaryIpRanges_;
            bitField0_ = (bitField0_ & ~0x00200000);
            secondaryIpRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecondaryIpRangesFieldBuilder()
                    : null;
          } else {
            secondaryIpRangesBuilder_.addAllMessages(other.secondaryIpRanges_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasStackType()) {
        stackType_ = other.stackType_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 26989658
            case 28050354:
              {
                role_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 28050354
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 244202930
            case 386216050:
              {
                privateIpv6GoogleAccess_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 386216050
            case 784938578:
              {
                ipCidrRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 784938578
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 878060682
            case 1093271322:
              {
                com.google.cloud.compute.v1.SubnetworkSecondaryRange m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SubnetworkSecondaryRange.parser(),
                        extensionRegistry);
                if (secondaryIpRangesBuilder_ == null) {
                  ensureSecondaryIpRangesIsMutable();
                  secondaryIpRanges_.add(m);
                } else {
                  secondaryIpRangesBuilder_.addMessage(m);
                }
                break;
              } // case 1093271322
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 1111570338
            case 1114393522:
              {
                externalIpv6Prefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1114393522
            case 1212355360:
              {
                enableFlowLogs_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 1212355360
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1862979954
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1877428002
            case -2109837230:
              {
                ipv6CidrRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -2109837230
            case -2004977262:
              {
                reservedInternalRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case -2004977262
            case -1763710734:
              {
                purpose_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -1763710734
            case -1484569366:
              {
                input.readMessage(getLogConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case -1484569366
            case -923032976:
              {
                privateIpGoogleAccess_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case -923032976
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -887696246:
              {
                stackType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case -887696246
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case -645248918
            case -616028214:
              {
                gatewayAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -616028214
            case -257698070:
              {
                ipv6AccessType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -257698070
            case -244806846:
              {
                internalIpv6Prefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -244806846
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean enableFlowLogs_;
    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable_flow_logs = 151544420;</code>
     *
     * @return Whether the enableFlowLogs field is set.
     */
    @java.lang.Override
    public boolean hasEnableFlowLogs() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable_flow_logs = 151544420;</code>
     *
     * @return The enableFlowLogs.
     */
    @java.lang.Override
    public boolean getEnableFlowLogs() {
      return enableFlowLogs_;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable_flow_logs = 151544420;</code>
     *
     * @param value The enableFlowLogs to set.
     * @return This builder for chaining.
     */
    public Builder setEnableFlowLogs(boolean value) {

      enableFlowLogs_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. This field isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable_flow_logs = 151544420;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableFlowLogs() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableFlowLogs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object externalIpv6Prefix_ = "";
    /**
     *
     *
     * <pre>
     * The external IPv6 address range that is owned by this subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6_prefix = 139299190;</code>
     *
     * @return Whether the externalIpv6Prefix field is set.
     */
    public boolean hasExternalIpv6Prefix() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The external IPv6 address range that is owned by this subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6_prefix = 139299190;</code>
     *
     * @return The externalIpv6Prefix.
     */
    public java.lang.String getExternalIpv6Prefix() {
      java.lang.Object ref = externalIpv6Prefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalIpv6Prefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The external IPv6 address range that is owned by this subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6_prefix = 139299190;</code>
     *
     * @return The bytes for externalIpv6Prefix.
     */
    public com.google.protobuf.ByteString getExternalIpv6PrefixBytes() {
      java.lang.Object ref = externalIpv6Prefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalIpv6Prefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The external IPv6 address range that is owned by this subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6_prefix = 139299190;</code>
     *
     * @param value The externalIpv6Prefix to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIpv6Prefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalIpv6Prefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The external IPv6 address range that is owned by this subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6_prefix = 139299190;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalIpv6Prefix() {
      externalIpv6Prefix_ = getDefaultInstance().getExternalIpv6Prefix();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The external IPv6 address range that is owned by this subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6_prefix = 139299190;</code>
     *
     * @param value The bytes for externalIpv6Prefix to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIpv6PrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalIpv6Prefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a Subnetwork.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object gatewayAddress_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
     * </pre>
     *
     * <code>optional string gateway_address = 459867385;</code>
     *
     * @return Whether the gatewayAddress field is set.
     */
    public boolean hasGatewayAddress() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
     * </pre>
     *
     * <code>optional string gateway_address = 459867385;</code>
     *
     * @return The gatewayAddress.
     */
    public java.lang.String getGatewayAddress() {
      java.lang.Object ref = gatewayAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gatewayAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
     * </pre>
     *
     * <code>optional string gateway_address = 459867385;</code>
     *
     * @return The bytes for gatewayAddress.
     */
    public com.google.protobuf.ByteString getGatewayAddressBytes() {
      java.lang.Object ref = gatewayAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gatewayAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
     * </pre>
     *
     * <code>optional string gateway_address = 459867385;</code>
     *
     * @param value The gatewayAddress to set.
     * @return This builder for chaining.
     */
    public Builder setGatewayAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gatewayAddress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
     * </pre>
     *
     * <code>optional string gateway_address = 459867385;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGatewayAddress() {
      gatewayAddress_ = getDefaultInstance().getGatewayAddress();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The gateway address for default routes to reach destination addresses outside this subnetwork.
     * </pre>
     *
     * <code>optional string gateway_address = 459867385;</code>
     *
     * @param value The bytes for gatewayAddress to set.
     * @return This builder for chaining.
     */
    public Builder setGatewayAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gatewayAddress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000040);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object internalIpv6Prefix_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
     * </pre>
     *
     * <code>optional string internal_ipv6_prefix = 506270056;</code>
     *
     * @return Whether the internalIpv6Prefix field is set.
     */
    public boolean hasInternalIpv6Prefix() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
     * </pre>
     *
     * <code>optional string internal_ipv6_prefix = 506270056;</code>
     *
     * @return The internalIpv6Prefix.
     */
    public java.lang.String getInternalIpv6Prefix() {
      java.lang.Object ref = internalIpv6Prefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalIpv6Prefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
     * </pre>
     *
     * <code>optional string internal_ipv6_prefix = 506270056;</code>
     *
     * @return The bytes for internalIpv6Prefix.
     */
    public com.google.protobuf.ByteString getInternalIpv6PrefixBytes() {
      java.lang.Object ref = internalIpv6Prefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalIpv6Prefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
     * </pre>
     *
     * <code>optional string internal_ipv6_prefix = 506270056;</code>
     *
     * @param value The internalIpv6Prefix to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIpv6Prefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalIpv6Prefix_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
     * </pre>
     *
     * <code>optional string internal_ipv6_prefix = 506270056;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalIpv6Prefix() {
      internalIpv6Prefix_ = getDefaultInstance().getInternalIpv6Prefix();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
     * </pre>
     *
     * <code>optional string internal_ipv6_prefix = 506270056;</code>
     *
     * @param value The bytes for internalIpv6Prefix to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIpv6PrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalIpv6Prefix_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object ipCidrRange_ = "";
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return Whether the ipCidrRange field is set.
     */
    public boolean hasIpCidrRange() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return The ipCidrRange.
     */
    public java.lang.String getIpCidrRange() {
      java.lang.Object ref = ipCidrRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipCidrRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return The bytes for ipCidrRange.
     */
    public com.google.protobuf.ByteString getIpCidrRangeBytes() {
      java.lang.Object ref = ipCidrRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipCidrRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @param value The ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipCidrRange_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpCidrRange() {
      ipCidrRange_ = getDefaultInstance().getIpCidrRange();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork. Provide this property when you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and non-overlapping within a network. Only IPv4 is supported. This field is set at resource creation time. The range can be any range listed in the Valid ranges list. The range can be expanded after creation using expandIpCidrRange.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @param value The bytes for ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipCidrRange_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object ipv6AccessType_ = "";
    /**
     *
     *
     * <pre>
     * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
     * Check the Ipv6AccessType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ipv6_access_type = 504658653;</code>
     *
     * @return Whether the ipv6AccessType field is set.
     */
    public boolean hasIpv6AccessType() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
     * Check the Ipv6AccessType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ipv6_access_type = 504658653;</code>
     *
     * @return The ipv6AccessType.
     */
    public java.lang.String getIpv6AccessType() {
      java.lang.Object ref = ipv6AccessType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipv6AccessType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
     * Check the Ipv6AccessType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ipv6_access_type = 504658653;</code>
     *
     * @return The bytes for ipv6AccessType.
     */
    public com.google.protobuf.ByteString getIpv6AccessTypeBytes() {
      java.lang.Object ref = ipv6AccessType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipv6AccessType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
     * Check the Ipv6AccessType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ipv6_access_type = 504658653;</code>
     *
     * @param value The ipv6AccessType to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6AccessType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipv6AccessType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
     * Check the Ipv6AccessType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ipv6_access_type = 504658653;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv6AccessType() {
      ipv6AccessType_ = getDefaultInstance().getIpv6AccessType();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
     * Check the Ipv6AccessType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ipv6_access_type = 504658653;</code>
     *
     * @param value The bytes for ipv6AccessType to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6AccessTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipv6AccessType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object ipv6CidrRange_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] This field is for internal use.
     * </pre>
     *
     * <code>optional string ipv6_cidr_range = 273141258;</code>
     *
     * @return Whether the ipv6CidrRange field is set.
     */
    public boolean hasIpv6CidrRange() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] This field is for internal use.
     * </pre>
     *
     * <code>optional string ipv6_cidr_range = 273141258;</code>
     *
     * @return The ipv6CidrRange.
     */
    public java.lang.String getIpv6CidrRange() {
      java.lang.Object ref = ipv6CidrRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipv6CidrRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] This field is for internal use.
     * </pre>
     *
     * <code>optional string ipv6_cidr_range = 273141258;</code>
     *
     * @return The bytes for ipv6CidrRange.
     */
    public com.google.protobuf.ByteString getIpv6CidrRangeBytes() {
      java.lang.Object ref = ipv6CidrRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipv6CidrRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] This field is for internal use.
     * </pre>
     *
     * <code>optional string ipv6_cidr_range = 273141258;</code>
     *
     * @param value The ipv6CidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6CidrRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipv6CidrRange_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] This field is for internal use.
     * </pre>
     *
     * <code>optional string ipv6_cidr_range = 273141258;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv6CidrRange() {
      ipv6CidrRange_ = getDefaultInstance().getIpv6CidrRange();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] This field is for internal use.
     * </pre>
     *
     * <code>optional string ipv6_cidr_range = 273141258;</code>
     *
     * @param value The bytes for ipv6CidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6CidrRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipv6CidrRange_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SubnetworkLogConfig logConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkLogConfig,
            com.google.cloud.compute.v1.SubnetworkLogConfig.Builder,
            com.google.cloud.compute.v1.SubnetworkLogConfigOrBuilder>
        logConfigBuilder_;
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     *
     * @return Whether the logConfig field is set.
     */
    public boolean hasLogConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     *
     * @return The logConfig.
     */
    public com.google.cloud.compute.v1.SubnetworkLogConfig getLogConfig() {
      if (logConfigBuilder_ == null) {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance()
            : logConfig_;
      } else {
        return logConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(com.google.cloud.compute.v1.SubnetworkLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logConfig_ = value;
      } else {
        logConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(
        com.google.cloud.compute.v1.SubnetworkLogConfig.Builder builderForValue) {
      if (logConfigBuilder_ == null) {
        logConfig_ = builderForValue.build();
      } else {
        logConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    public Builder mergeLogConfig(com.google.cloud.compute.v1.SubnetworkLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && logConfig_ != null
            && logConfig_ != com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance()) {
          getLogConfigBuilder().mergeFrom(value);
        } else {
          logConfig_ = value;
        }
      } else {
        logConfigBuilder_.mergeFrom(value);
      }
      if (logConfig_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    public Builder clearLogConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.SubnetworkLogConfig.Builder getLogConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getLogConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.SubnetworkLogConfigOrBuilder getLogConfigOrBuilder() {
      if (logConfigBuilder_ != null) {
        return logConfigBuilder_.getMessageOrBuilder();
      } else {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance()
            : logConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled, logs are exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SubnetworkLogConfig log_config = 351299741;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkLogConfig,
            com.google.cloud.compute.v1.SubnetworkLogConfig.Builder,
            com.google.cloud.compute.v1.SubnetworkLogConfigOrBuilder>
        getLogConfigFieldBuilder() {
      if (logConfigBuilder_ == null) {
        logConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SubnetworkLogConfig,
                com.google.cloud.compute.v1.SubnetworkLogConfig.Builder,
                com.google.cloud.compute.v1.SubnetworkLogConfigOrBuilder>(
                getLogConfig(), getParentForChildren(), isClean());
        logConfig_ = null;
      }
      return logConfigBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this subnetwork belongs, provided by the client when initially creating the subnetwork. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private boolean privateIpGoogleAccess_;
    /**
     *
     *
     * <pre>
     * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
     * </pre>
     *
     * <code>optional bool private_ip_google_access = 421491790;</code>
     *
     * @return Whether the privateIpGoogleAccess field is set.
     */
    @java.lang.Override
    public boolean hasPrivateIpGoogleAccess() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
     * </pre>
     *
     * <code>optional bool private_ip_google_access = 421491790;</code>
     *
     * @return The privateIpGoogleAccess.
     */
    @java.lang.Override
    public boolean getPrivateIpGoogleAccess() {
      return privateIpGoogleAccess_;
    }
    /**
     *
     *
     * <pre>
     * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
     * </pre>
     *
     * <code>optional bool private_ip_google_access = 421491790;</code>
     *
     * @param value The privateIpGoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpGoogleAccess(boolean value) {

      privateIpGoogleAccess_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the VMs in this subnet can access Google services without assigned external IP addresses. This field can be both set at resource creation time and updated using setPrivateIpGoogleAccess.
     * </pre>
     *
     * <code>optional bool private_ip_google_access = 421491790;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpGoogleAccess() {
      bitField0_ = (bitField0_ & ~0x00008000);
      privateIpGoogleAccess_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object privateIpv6GoogleAccess_ = "";
    /**
     *
     *
     * <pre>
     * This field is for internal use. This field can be both set at resource creation time and updated using patch.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return Whether the privateIpv6GoogleAccess field is set.
     */
    public boolean hasPrivateIpv6GoogleAccess() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is for internal use. This field can be both set at resource creation time and updated using patch.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return The privateIpv6GoogleAccess.
     */
    public java.lang.String getPrivateIpv6GoogleAccess() {
      java.lang.Object ref = privateIpv6GoogleAccess_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateIpv6GoogleAccess_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is for internal use. This field can be both set at resource creation time and updated using patch.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return The bytes for privateIpv6GoogleAccess.
     */
    public com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes() {
      java.lang.Object ref = privateIpv6GoogleAccess_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateIpv6GoogleAccess_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is for internal use. This field can be both set at resource creation time and updated using patch.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @param value The privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccess(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is for internal use. This field can be both set at resource creation time and updated using patch.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpv6GoogleAccess() {
      privateIpv6GoogleAccess_ = getDefaultInstance().getPrivateIpv6GoogleAccess();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is for internal use. This field can be both set at resource creation time and updated using patch.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @param value The bytes for privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccessBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object purpose_ = "";
    /**
     *
     *
     * <pre>
     * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
     * Check the Purpose enum for the list of possible values.
     * </pre>
     *
     * <code>optional string purpose = 316407070;</code>
     *
     * @return Whether the purpose field is set.
     */
    public boolean hasPurpose() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
     * Check the Purpose enum for the list of possible values.
     * </pre>
     *
     * <code>optional string purpose = 316407070;</code>
     *
     * @return The purpose.
     */
    public java.lang.String getPurpose() {
      java.lang.Object ref = purpose_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        purpose_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
     * Check the Purpose enum for the list of possible values.
     * </pre>
     *
     * <code>optional string purpose = 316407070;</code>
     *
     * @return The bytes for purpose.
     */
    public com.google.protobuf.ByteString getPurposeBytes() {
      java.lang.Object ref = purpose_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        purpose_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
     * Check the Purpose enum for the list of possible values.
     * </pre>
     *
     * <code>optional string purpose = 316407070;</code>
     *
     * @param value The purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurpose(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      purpose_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
     * Check the Purpose enum for the list of possible values.
     * </pre>
     *
     * <code>optional string purpose = 316407070;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurpose() {
      purpose_ = getDefaultInstance().getPurpose();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The purpose of the resource. This field can be either PRIVATE, GLOBAL_MANAGED_PROXY, REGIONAL_MANAGED_PROXY, PRIVATE_SERVICE_CONNECT, or PRIVATE is the default purpose for user-created subnets or subnets that are automatically created in auto mode networks. Subnets with purpose set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY are user-created subnetworks that are reserved for Envoy-based load balancers. A subnet with purpose set to PRIVATE_SERVICE_CONNECT is used to publish services using Private Service Connect. If unspecified, the subnet purpose defaults to PRIVATE. The enableFlowLogs field isn't supported if the subnet purpose field is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY.
     * Check the Purpose enum for the list of possible values.
     * </pre>
     *
     * <code>optional string purpose = 316407070;</code>
     *
     * @param value The bytes for purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurposeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      purpose_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the region where the Subnetwork resides. This field can be set only at resource creation time.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object reservedInternalRange_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the reserved internal range.
     * </pre>
     *
     * <code>optional string reserved_internal_range = 286248754;</code>
     *
     * @return Whether the reservedInternalRange field is set.
     */
    public boolean hasReservedInternalRange() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of the reserved internal range.
     * </pre>
     *
     * <code>optional string reserved_internal_range = 286248754;</code>
     *
     * @return The reservedInternalRange.
     */
    public java.lang.String getReservedInternalRange() {
      java.lang.Object ref = reservedInternalRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservedInternalRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the reserved internal range.
     * </pre>
     *
     * <code>optional string reserved_internal_range = 286248754;</code>
     *
     * @return The bytes for reservedInternalRange.
     */
    public com.google.protobuf.ByteString getReservedInternalRangeBytes() {
      java.lang.Object ref = reservedInternalRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservedInternalRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the reserved internal range.
     * </pre>
     *
     * <code>optional string reserved_internal_range = 286248754;</code>
     *
     * @param value The reservedInternalRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedInternalRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reservedInternalRange_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the reserved internal range.
     * </pre>
     *
     * <code>optional string reserved_internal_range = 286248754;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedInternalRange() {
      reservedInternalRange_ = getDefaultInstance().getReservedInternalRange();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the reserved internal range.
     * </pre>
     *
     * <code>optional string reserved_internal_range = 286248754;</code>
     *
     * @param value The bytes for reservedInternalRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedInternalRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reservedInternalRange_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object role_ = "";
    /**
     *
     *
     * <pre>
     * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
     * Check the Role enum for the list of possible values.
     * </pre>
     *
     * <code>optional string role = 3506294;</code>
     *
     * @return Whether the role field is set.
     */
    public boolean hasRole() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
     * Check the Role enum for the list of possible values.
     * </pre>
     *
     * <code>optional string role = 3506294;</code>
     *
     * @return The role.
     */
    public java.lang.String getRole() {
      java.lang.Object ref = role_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        role_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
     * Check the Role enum for the list of possible values.
     * </pre>
     *
     * <code>optional string role = 3506294;</code>
     *
     * @return The bytes for role.
     */
    public com.google.protobuf.ByteString getRoleBytes() {
      java.lang.Object ref = role_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        role_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
     * Check the Role enum for the list of possible values.
     * </pre>
     *
     * <code>optional string role = 3506294;</code>
     *
     * @param value The role to set.
     * @return This builder for chaining.
     */
    public Builder setRole(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      role_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
     * Check the Role enum for the list of possible values.
     * </pre>
     *
     * <code>optional string role = 3506294;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRole() {
      role_ = getDefaultInstance().getRole();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role of subnetwork. Currently, this field is only used when purpose is set to GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
     * Check the Role enum for the list of possible values.
     * </pre>
     *
     * <code>optional string role = 3506294;</code>
     *
     * @param value The bytes for role to set.
     * @return This builder for chaining.
     */
    public Builder setRoleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      role_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SubnetworkSecondaryRange>
        secondaryIpRanges_ = java.util.Collections.emptyList();

    private void ensureSecondaryIpRangesIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        secondaryIpRanges_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.SubnetworkSecondaryRange>(
                secondaryIpRanges_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkSecondaryRange,
            com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder,
            com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder>
        secondaryIpRangesBuilder_;

    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SubnetworkSecondaryRange>
        getSecondaryIpRangesList() {
      if (secondaryIpRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secondaryIpRanges_);
      } else {
        return secondaryIpRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public int getSecondaryIpRangesCount() {
      if (secondaryIpRangesBuilder_ == null) {
        return secondaryIpRanges_.size();
      } else {
        return secondaryIpRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkSecondaryRange getSecondaryIpRanges(int index) {
      if (secondaryIpRangesBuilder_ == null) {
        return secondaryIpRanges_.get(index);
      } else {
        return secondaryIpRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder setSecondaryIpRanges(
        int index, com.google.cloud.compute.v1.SubnetworkSecondaryRange value) {
      if (secondaryIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.set(index, value);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder setSecondaryIpRanges(
        int index, com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder builderForValue) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        secondaryIpRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        com.google.cloud.compute.v1.SubnetworkSecondaryRange value) {
      if (secondaryIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(value);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        int index, com.google.cloud.compute.v1.SubnetworkSecondaryRange value) {
      if (secondaryIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(index, value);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder builderForValue) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(builderForValue.build());
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        int index, com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder builderForValue) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder addAllSecondaryIpRanges(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SubnetworkSecondaryRange> values) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secondaryIpRanges_);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder clearSecondaryIpRanges() {
      if (secondaryIpRangesBuilder_ == null) {
        secondaryIpRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public Builder removeSecondaryIpRanges(int index) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.remove(index);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder getSecondaryIpRangesBuilder(
        int index) {
      return getSecondaryIpRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder
        getSecondaryIpRangesOrBuilder(int index) {
      if (secondaryIpRangesBuilder_ == null) {
        return secondaryIpRanges_.get(index);
      } else {
        return secondaryIpRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder>
        getSecondaryIpRangesOrBuilderList() {
      if (secondaryIpRangesBuilder_ != null) {
        return secondaryIpRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secondaryIpRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder
        addSecondaryIpRangesBuilder() {
      return getSecondaryIpRangesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.SubnetworkSecondaryRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder addSecondaryIpRangesBuilder(
        int index) {
      return getSecondaryIpRangesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.SubnetworkSecondaryRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork. The alias IPs may belong to either primary or secondary ranges. This field can be updated with a patch request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SubnetworkSecondaryRange secondary_ip_ranges = 136658915;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder>
        getSecondaryIpRangesBuilderList() {
      return getSecondaryIpRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SubnetworkSecondaryRange,
            com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder,
            com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder>
        getSecondaryIpRangesFieldBuilder() {
      if (secondaryIpRangesBuilder_ == null) {
        secondaryIpRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SubnetworkSecondaryRange,
                com.google.cloud.compute.v1.SubnetworkSecondaryRange.Builder,
                com.google.cloud.compute.v1.SubnetworkSecondaryRangeOrBuilder>(
                secondaryIpRanges_,
                ((bitField0_ & 0x00200000) != 0),
                getParentForChildren(),
                isClean());
        secondaryIpRanges_ = null;
      }
      return secondaryIpRangesBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object stackType_ = "";
    /**
     *
     *
     * <pre>
     * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return Whether the stackType field is set.
     */
    public boolean hasStackType() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return The stackType.
     */
    public java.lang.String getStackType() {
      java.lang.Object ref = stackType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stackType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return The bytes for stackType.
     */
    public com.google.protobuf.ByteString getStackTypeBytes() {
      java.lang.Object ref = stackType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stackType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @param value The stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stackType_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStackType() {
      stackType_ = getDefaultInstance().getStackType();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @param value The bytes for stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stackType_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Subnetwork)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Subnetwork)
  private static final com.google.cloud.compute.v1.Subnetwork DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Subnetwork();
  }

  public static com.google.cloud.compute.v1.Subnetwork getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Subnetwork> PARSER =
      new com.google.protobuf.AbstractParser<Subnetwork>() {
        @java.lang.Override
        public Subnetwork parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Subnetwork> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Subnetwork> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Subnetwork getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
