/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Upcoming Maintenance notification information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.UpcomingMaintenance}
 */
public final class UpcomingMaintenance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.UpcomingMaintenance)
    UpcomingMaintenanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpcomingMaintenance.newBuilder() to construct.
  private UpcomingMaintenance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpcomingMaintenance() {
    latestWindowStartTime_ = "";
    maintenanceStatus_ = "";
    type_ = "";
    windowEndTime_ = "";
    windowStartTime_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpcomingMaintenance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UpcomingMaintenance_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UpcomingMaintenance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.UpcomingMaintenance.class,
            com.google.cloud.compute.v1.UpcomingMaintenance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.UpcomingMaintenance.MaintenanceStatus}
   */
  public enum MaintenanceStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAINTENANCE_STATUS = 0;</code>
     */
    UNDEFINED_MAINTENANCE_STATUS(0),
    /**
     *
     *
     * <pre>
     * There is ongoing maintenance on this VM.
     * </pre>
     *
     * <code>ONGOING = 473158491;</code>
     */
    ONGOING(473158491),
    /**
     *
     *
     * <pre>
     * There is pending maintenance.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    PENDING(35394935),
    /**
     *
     *
     * <pre>
     * Unknown maintenance status. Do not use this value.
     * </pre>
     *
     * <code>UNKNOWN = 433141802;</code>
     */
    UNKNOWN(433141802),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAINTENANCE_STATUS = 0;</code>
     */
    public static final int UNDEFINED_MAINTENANCE_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * There is ongoing maintenance on this VM.
     * </pre>
     *
     * <code>ONGOING = 473158491;</code>
     */
    public static final int ONGOING_VALUE = 473158491;
    /**
     *
     *
     * <pre>
     * There is pending maintenance.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    public static final int PENDING_VALUE = 35394935;
    /**
     *
     *
     * <pre>
     * Unknown maintenance status. Do not use this value.
     * </pre>
     *
     * <code>UNKNOWN = 433141802;</code>
     */
    public static final int UNKNOWN_VALUE = 433141802;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaintenanceStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaintenanceStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MAINTENANCE_STATUS;
        case 473158491:
          return ONGOING;
        case 35394935:
          return PENDING;
        case 433141802:
          return UNKNOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaintenanceStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MaintenanceStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MaintenanceStatus>() {
              public MaintenanceStatus findValueByNumber(int number) {
                return MaintenanceStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.UpcomingMaintenance.getDescriptor().getEnumTypes().get(0);
    }

    private static final MaintenanceStatus[] VALUES = values();

    public static MaintenanceStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaintenanceStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.UpcomingMaintenance.MaintenanceStatus)
  }

  /**
   *
   *
   * <pre>
   * Defines the type of maintenance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.UpcomingMaintenance.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * Scheduled maintenance (e.g. maintenance after uptime guarantee is complete).
     * </pre>
     *
     * <code>SCHEDULED = 478400653;</code>
     */
    SCHEDULED(478400653),
    /**
     *
     *
     * <pre>
     * No type specified. Do not use this value.
     * </pre>
     *
     * <code>UNKNOWN_TYPE = 490705455;</code>
     */
    UNKNOWN_TYPE(490705455),
    /**
     *
     *
     * <pre>
     * Unscheduled maintenance (e.g. emergency maintenance during uptime guarantee).
     * </pre>
     *
     * <code>UNSCHEDULED = 450077204;</code>
     */
    UNSCHEDULED(450077204),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Scheduled maintenance (e.g. maintenance after uptime guarantee is complete).
     * </pre>
     *
     * <code>SCHEDULED = 478400653;</code>
     */
    public static final int SCHEDULED_VALUE = 478400653;
    /**
     *
     *
     * <pre>
     * No type specified. Do not use this value.
     * </pre>
     *
     * <code>UNKNOWN_TYPE = 490705455;</code>
     */
    public static final int UNKNOWN_TYPE_VALUE = 490705455;
    /**
     *
     *
     * <pre>
     * Unscheduled maintenance (e.g. emergency maintenance during uptime guarantee).
     * </pre>
     *
     * <code>UNSCHEDULED = 450077204;</code>
     */
    public static final int UNSCHEDULED_VALUE = 450077204;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 478400653:
          return SCHEDULED;
        case 490705455:
          return UNKNOWN_TYPE;
        case 450077204:
          return UNSCHEDULED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.UpcomingMaintenance.getDescriptor().getEnumTypes().get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.UpcomingMaintenance.Type)
  }

  private int bitField0_;
  public static final int CAN_RESCHEDULE_FIELD_NUMBER = 95981977;
  private boolean canReschedule_ = false;
  /**
   *
   *
   * <pre>
   * Indicates if the maintenance can be customer triggered.
   * </pre>
   *
   * <code>optional bool can_reschedule = 95981977;</code>
   *
   * @return Whether the canReschedule field is set.
   */
  @java.lang.Override
  public boolean hasCanReschedule() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates if the maintenance can be customer triggered.
   * </pre>
   *
   * <code>optional bool can_reschedule = 95981977;</code>
   *
   * @return The canReschedule.
   */
  @java.lang.Override
  public boolean getCanReschedule() {
    return canReschedule_;
  }

  public static final int LATEST_WINDOW_START_TIME_FIELD_NUMBER = 128032129;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestWindowStartTime_ = "";
  /**
   *
   *
   * <pre>
   * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string latest_window_start_time = 128032129;</code>
   *
   * @return Whether the latestWindowStartTime field is set.
   */
  @java.lang.Override
  public boolean hasLatestWindowStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string latest_window_start_time = 128032129;</code>
   *
   * @return The latestWindowStartTime.
   */
  @java.lang.Override
  public java.lang.String getLatestWindowStartTime() {
    java.lang.Object ref = latestWindowStartTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestWindowStartTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string latest_window_start_time = 128032129;</code>
   *
   * @return The bytes for latestWindowStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestWindowStartTimeBytes() {
    java.lang.Object ref = latestWindowStartTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestWindowStartTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAINTENANCE_STATUS_FIELD_NUMBER = 81645214;

  @SuppressWarnings("serial")
  private volatile java.lang.Object maintenanceStatus_ = "";
  /**
   *
   *
   * <pre>
   *
   * Check the MaintenanceStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_status = 81645214;</code>
   *
   * @return Whether the maintenanceStatus field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   *
   * Check the MaintenanceStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_status = 81645214;</code>
   *
   * @return The maintenanceStatus.
   */
  @java.lang.Override
  public java.lang.String getMaintenanceStatus() {
    java.lang.Object ref = maintenanceStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      maintenanceStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   *
   * Check the MaintenanceStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_status = 81645214;</code>
   *
   * @return The bytes for maintenanceStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaintenanceStatusBytes() {
    java.lang.Object ref = maintenanceStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      maintenanceStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * Defines the type of maintenance.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Defines the type of maintenance.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Defines the type of maintenance.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WINDOW_END_TIME_FIELD_NUMBER = 271816480;

  @SuppressWarnings("serial")
  private volatile java.lang.Object windowEndTime_ = "";
  /**
   *
   *
   * <pre>
   * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string window_end_time = 271816480;</code>
   *
   * @return Whether the windowEndTime field is set.
   */
  @java.lang.Override
  public boolean hasWindowEndTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string window_end_time = 271816480;</code>
   *
   * @return The windowEndTime.
   */
  @java.lang.Override
  public java.lang.String getWindowEndTime() {
    java.lang.Object ref = windowEndTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      windowEndTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string window_end_time = 271816480;</code>
   *
   * @return The bytes for windowEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWindowEndTimeBytes() {
    java.lang.Object ref = windowEndTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      windowEndTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WINDOW_START_TIME_FIELD_NUMBER = 473061433;

  @SuppressWarnings("serial")
  private volatile java.lang.Object windowStartTime_ = "";
  /**
   *
   *
   * <pre>
   * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string window_start_time = 473061433;</code>
   *
   * @return Whether the windowStartTime field is set.
   */
  @java.lang.Override
  public boolean hasWindowStartTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string window_start_time = 473061433;</code>
   *
   * @return The windowStartTime.
   */
  @java.lang.Override
  public java.lang.String getWindowStartTime() {
    java.lang.Object ref = windowStartTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      windowStartTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string window_start_time = 473061433;</code>
   *
   * @return The bytes for windowStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWindowStartTimeBytes() {
    java.lang.Object ref = windowStartTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      windowStartTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 81645214, maintenanceStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(95981977, canReschedule_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 128032129, latestWindowStartTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 271816480, windowEndTime_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 473061433, windowStartTime_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(81645214, maintenanceStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(95981977, canReschedule_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              128032129, latestWindowStartTime_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(271816480, windowEndTime_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(473061433, windowStartTime_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.UpcomingMaintenance)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.UpcomingMaintenance other =
        (com.google.cloud.compute.v1.UpcomingMaintenance) obj;

    if (hasCanReschedule() != other.hasCanReschedule()) return false;
    if (hasCanReschedule()) {
      if (getCanReschedule() != other.getCanReschedule()) return false;
    }
    if (hasLatestWindowStartTime() != other.hasLatestWindowStartTime()) return false;
    if (hasLatestWindowStartTime()) {
      if (!getLatestWindowStartTime().equals(other.getLatestWindowStartTime())) return false;
    }
    if (hasMaintenanceStatus() != other.hasMaintenanceStatus()) return false;
    if (hasMaintenanceStatus()) {
      if (!getMaintenanceStatus().equals(other.getMaintenanceStatus())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (hasWindowEndTime() != other.hasWindowEndTime()) return false;
    if (hasWindowEndTime()) {
      if (!getWindowEndTime().equals(other.getWindowEndTime())) return false;
    }
    if (hasWindowStartTime() != other.hasWindowStartTime()) return false;
    if (hasWindowStartTime()) {
      if (!getWindowStartTime().equals(other.getWindowStartTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCanReschedule()) {
      hash = (37 * hash) + CAN_RESCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCanReschedule());
    }
    if (hasLatestWindowStartTime()) {
      hash = (37 * hash) + LATEST_WINDOW_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLatestWindowStartTime().hashCode();
    }
    if (hasMaintenanceStatus()) {
      hash = (37 * hash) + MAINTENANCE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceStatus().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    if (hasWindowEndTime()) {
      hash = (37 * hash) + WINDOW_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getWindowEndTime().hashCode();
    }
    if (hasWindowStartTime()) {
      hash = (37 * hash) + WINDOW_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getWindowStartTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.UpcomingMaintenance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Upcoming Maintenance notification information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.UpcomingMaintenance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.UpcomingMaintenance)
      com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UpcomingMaintenance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UpcomingMaintenance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.UpcomingMaintenance.class,
              com.google.cloud.compute.v1.UpcomingMaintenance.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.UpcomingMaintenance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      canReschedule_ = false;
      latestWindowStartTime_ = "";
      maintenanceStatus_ = "";
      type_ = "";
      windowEndTime_ = "";
      windowStartTime_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UpcomingMaintenance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UpcomingMaintenance getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UpcomingMaintenance build() {
      com.google.cloud.compute.v1.UpcomingMaintenance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UpcomingMaintenance buildPartial() {
      com.google.cloud.compute.v1.UpcomingMaintenance result =
          new com.google.cloud.compute.v1.UpcomingMaintenance(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.UpcomingMaintenance result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.canReschedule_ = canReschedule_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.latestWindowStartTime_ = latestWindowStartTime_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maintenanceStatus_ = maintenanceStatus_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.windowEndTime_ = windowEndTime_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.windowStartTime_ = windowStartTime_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.UpcomingMaintenance) {
        return mergeFrom((com.google.cloud.compute.v1.UpcomingMaintenance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.UpcomingMaintenance other) {
      if (other == com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance())
        return this;
      if (other.hasCanReschedule()) {
        setCanReschedule(other.getCanReschedule());
      }
      if (other.hasLatestWindowStartTime()) {
        latestWindowStartTime_ = other.latestWindowStartTime_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMaintenanceStatus()) {
        maintenanceStatus_ = other.maintenanceStatus_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasWindowEndTime()) {
        windowEndTime_ = other.windowEndTime_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasWindowStartTime()) {
        windowStartTime_ = other.windowStartTime_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 28604882
            case 653161714:
              {
                maintenanceStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 653161714
            case 767855816:
              {
                canReschedule_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 767855816
            case 1024257034:
              {
                latestWindowStartTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1024257034
            case -2120435454:
              {
                windowEndTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -2120435454
            case -510475830:
              {
                windowStartTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -510475830
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean canReschedule_;
    /**
     *
     *
     * <pre>
     * Indicates if the maintenance can be customer triggered.
     * </pre>
     *
     * <code>optional bool can_reschedule = 95981977;</code>
     *
     * @return Whether the canReschedule field is set.
     */
    @java.lang.Override
    public boolean hasCanReschedule() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates if the maintenance can be customer triggered.
     * </pre>
     *
     * <code>optional bool can_reschedule = 95981977;</code>
     *
     * @return The canReschedule.
     */
    @java.lang.Override
    public boolean getCanReschedule() {
      return canReschedule_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if the maintenance can be customer triggered.
     * </pre>
     *
     * <code>optional bool can_reschedule = 95981977;</code>
     *
     * @param value The canReschedule to set.
     * @return This builder for chaining.
     */
    public Builder setCanReschedule(boolean value) {

      canReschedule_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if the maintenance can be customer triggered.
     * </pre>
     *
     * <code>optional bool can_reschedule = 95981977;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanReschedule() {
      bitField0_ = (bitField0_ & ~0x00000001);
      canReschedule_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object latestWindowStartTime_ = "";
    /**
     *
     *
     * <pre>
     * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string latest_window_start_time = 128032129;</code>
     *
     * @return Whether the latestWindowStartTime field is set.
     */
    public boolean hasLatestWindowStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string latest_window_start_time = 128032129;</code>
     *
     * @return The latestWindowStartTime.
     */
    public java.lang.String getLatestWindowStartTime() {
      java.lang.Object ref = latestWindowStartTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestWindowStartTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string latest_window_start_time = 128032129;</code>
     *
     * @return The bytes for latestWindowStartTime.
     */
    public com.google.protobuf.ByteString getLatestWindowStartTimeBytes() {
      java.lang.Object ref = latestWindowStartTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestWindowStartTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string latest_window_start_time = 128032129;</code>
     *
     * @param value The latestWindowStartTime to set.
     * @return This builder for chaining.
     */
    public Builder setLatestWindowStartTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestWindowStartTime_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string latest_window_start_time = 128032129;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestWindowStartTime() {
      latestWindowStartTime_ = getDefaultInstance().getLatestWindowStartTime();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string latest_window_start_time = 128032129;</code>
     *
     * @param value The bytes for latestWindowStartTime to set.
     * @return This builder for chaining.
     */
    public Builder setLatestWindowStartTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestWindowStartTime_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object maintenanceStatus_ = "";
    /**
     *
     *
     * <pre>
     *
     * Check the MaintenanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_status = 81645214;</code>
     *
     * @return Whether the maintenanceStatus field is set.
     */
    public boolean hasMaintenanceStatus() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     *
     * Check the MaintenanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_status = 81645214;</code>
     *
     * @return The maintenanceStatus.
     */
    public java.lang.String getMaintenanceStatus() {
      java.lang.Object ref = maintenanceStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        maintenanceStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the MaintenanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_status = 81645214;</code>
     *
     * @return The bytes for maintenanceStatus.
     */
    public com.google.protobuf.ByteString getMaintenanceStatusBytes() {
      java.lang.Object ref = maintenanceStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        maintenanceStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the MaintenanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_status = 81645214;</code>
     *
     * @param value The maintenanceStatus to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      maintenanceStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the MaintenanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_status = 81645214;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaintenanceStatus() {
      maintenanceStatus_ = getDefaultInstance().getMaintenanceStatus();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the MaintenanceStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_status = 81645214;</code>
     *
     * @param value The bytes for maintenanceStatus to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      maintenanceStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Defines the type of maintenance.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Defines the type of maintenance.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the type of maintenance.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the type of maintenance.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the type of maintenance.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the type of maintenance.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object windowEndTime_ = "";
    /**
     *
     *
     * <pre>
     * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_end_time = 271816480;</code>
     *
     * @return Whether the windowEndTime field is set.
     */
    public boolean hasWindowEndTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_end_time = 271816480;</code>
     *
     * @return The windowEndTime.
     */
    public java.lang.String getWindowEndTime() {
      java.lang.Object ref = windowEndTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        windowEndTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_end_time = 271816480;</code>
     *
     * @return The bytes for windowEndTime.
     */
    public com.google.protobuf.ByteString getWindowEndTimeBytes() {
      java.lang.Object ref = windowEndTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        windowEndTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_end_time = 271816480;</code>
     *
     * @param value The windowEndTime to set.
     * @return This builder for chaining.
     */
    public Builder setWindowEndTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      windowEndTime_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_end_time = 271816480;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWindowEndTime() {
      windowEndTime_ = getDefaultInstance().getWindowEndTime();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time by which the maintenance disruption will be completed. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_end_time = 271816480;</code>
     *
     * @param value The bytes for windowEndTime to set.
     * @return This builder for chaining.
     */
    public Builder setWindowEndTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      windowEndTime_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object windowStartTime_ = "";
    /**
     *
     *
     * <pre>
     * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_start_time = 473061433;</code>
     *
     * @return Whether the windowStartTime field is set.
     */
    public boolean hasWindowStartTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_start_time = 473061433;</code>
     *
     * @return The windowStartTime.
     */
    public java.lang.String getWindowStartTime() {
      java.lang.Object ref = windowStartTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        windowStartTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_start_time = 473061433;</code>
     *
     * @return The bytes for windowStartTime.
     */
    public com.google.protobuf.ByteString getWindowStartTimeBytes() {
      java.lang.Object ref = windowStartTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        windowStartTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_start_time = 473061433;</code>
     *
     * @param value The windowStartTime to set.
     * @return This builder for chaining.
     */
    public Builder setWindowStartTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      windowStartTime_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_start_time = 473061433;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWindowStartTime() {
      windowStartTime_ = getDefaultInstance().getWindowStartTime();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current start time of the maintenance window. This timestamp value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string window_start_time = 473061433;</code>
     *
     * @param value The bytes for windowStartTime to set.
     * @return This builder for chaining.
     */
    public Builder setWindowStartTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      windowStartTime_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.UpcomingMaintenance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.UpcomingMaintenance)
  private static final com.google.cloud.compute.v1.UpcomingMaintenance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.UpcomingMaintenance();
  }

  public static com.google.cloud.compute.v1.UpcomingMaintenance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpcomingMaintenance> PARSER =
      new com.google.protobuf.AbstractParser<UpcomingMaintenance>() {
        @java.lang.Override
        public UpcomingMaintenance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpcomingMaintenance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpcomingMaintenance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.UpcomingMaintenance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
