/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A VPN connection contains all VPN tunnels connected from this VpnGateway to the same peer gateway. The peer gateway could either be an external VPN gateway or a Google Cloud VPN gateway.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.VpnGatewayStatusVpnConnection}
 */
public final class VpnGatewayStatusVpnConnection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.VpnGatewayStatusVpnConnection)
    VpnGatewayStatusVpnConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VpnGatewayStatusVpnConnection.newBuilder() to construct.
  private VpnGatewayStatusVpnConnection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VpnGatewayStatusVpnConnection() {
    peerExternalGateway_ = "";
    peerGcpGateway_ = "";
    tunnels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VpnGatewayStatusVpnConnection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_VpnGatewayStatusVpnConnection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_VpnGatewayStatusVpnConnection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.class,
            com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.Builder.class);
  }

  private int bitField0_;
  public static final int PEER_EXTERNAL_GATEWAY_FIELD_NUMBER = 384956173;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerExternalGateway_ = "";
  /**
   *
   *
   * <pre>
   * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
   * </pre>
   *
   * <code>optional string peer_external_gateway = 384956173;</code>
   *
   * @return Whether the peerExternalGateway field is set.
   */
  @java.lang.Override
  public boolean hasPeerExternalGateway() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
   * </pre>
   *
   * <code>optional string peer_external_gateway = 384956173;</code>
   *
   * @return The peerExternalGateway.
   */
  @java.lang.Override
  public java.lang.String getPeerExternalGateway() {
    java.lang.Object ref = peerExternalGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerExternalGateway_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
   * </pre>
   *
   * <code>optional string peer_external_gateway = 384956173;</code>
   *
   * @return The bytes for peerExternalGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerExternalGatewayBytes() {
    java.lang.Object ref = peerExternalGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerExternalGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_GCP_GATEWAY_FIELD_NUMBER = 281867452;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerGcpGateway_ = "";
  /**
   *
   *
   * <pre>
   * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
   * </pre>
   *
   * <code>optional string peer_gcp_gateway = 281867452;</code>
   *
   * @return Whether the peerGcpGateway field is set.
   */
  @java.lang.Override
  public boolean hasPeerGcpGateway() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
   * </pre>
   *
   * <code>optional string peer_gcp_gateway = 281867452;</code>
   *
   * @return The peerGcpGateway.
   */
  @java.lang.Override
  public java.lang.String getPeerGcpGateway() {
    java.lang.Object ref = peerGcpGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerGcpGateway_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
   * </pre>
   *
   * <code>optional string peer_gcp_gateway = 281867452;</code>
   *
   * @return The bytes for peerGcpGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerGcpGatewayBytes() {
    java.lang.Object ref = peerGcpGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerGcpGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 109757585;
  private com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state_;
  /**
   *
   *
   * <pre>
   * HighAvailabilityRequirementState for the VPN connection.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
   * </code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * HighAvailabilityRequirementState for the VPN connection.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState getState() {
    return state_ == null
        ? com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState
            .getDefaultInstance()
        : state_;
  }
  /**
   *
   *
   * <pre>
   * HighAvailabilityRequirementState for the VPN connection.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementStateOrBuilder
      getStateOrBuilder() {
    return state_ == null
        ? com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState
            .getDefaultInstance()
        : state_;
  }

  public static final int TUNNELS_FIELD_NUMBER = 104561931;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.VpnGatewayStatusTunnel> tunnels_;
  /**
   *
   *
   * <pre>
   * List of VPN tunnels that are in this VPN connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.VpnGatewayStatusTunnel> getTunnelsList() {
    return tunnels_;
  }
  /**
   *
   *
   * <pre>
   * List of VPN tunnels that are in this VPN connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder>
      getTunnelsOrBuilderList() {
    return tunnels_;
  }
  /**
   *
   *
   * <pre>
   * List of VPN tunnels that are in this VPN connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
   */
  @java.lang.Override
  public int getTunnelsCount() {
    return tunnels_.size();
  }
  /**
   *
   *
   * <pre>
   * List of VPN tunnels that are in this VPN connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VpnGatewayStatusTunnel getTunnels(int index) {
    return tunnels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of VPN tunnels that are in this VPN connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder getTunnelsOrBuilder(
      int index) {
    return tunnels_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < tunnels_.size(); i++) {
      output.writeMessage(104561931, tunnels_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(109757585, getState());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 281867452, peerGcpGateway_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 384956173, peerExternalGateway_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < tunnels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(104561931, tunnels_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(109757585, getState());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(281867452, peerGcpGateway_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(384956173, peerExternalGateway_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection other =
        (com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection) obj;

    if (hasPeerExternalGateway() != other.hasPeerExternalGateway()) return false;
    if (hasPeerExternalGateway()) {
      if (!getPeerExternalGateway().equals(other.getPeerExternalGateway())) return false;
    }
    if (hasPeerGcpGateway() != other.hasPeerGcpGateway()) return false;
    if (hasPeerGcpGateway()) {
      if (!getPeerGcpGateway().equals(other.getPeerGcpGateway())) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (!getTunnelsList().equals(other.getTunnelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPeerExternalGateway()) {
      hash = (37 * hash) + PEER_EXTERNAL_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getPeerExternalGateway().hashCode();
    }
    if (hasPeerGcpGateway()) {
      hash = (37 * hash) + PEER_GCP_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getPeerGcpGateway().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    if (getTunnelsCount() > 0) {
      hash = (37 * hash) + TUNNELS_FIELD_NUMBER;
      hash = (53 * hash) + getTunnelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A VPN connection contains all VPN tunnels connected from this VpnGateway to the same peer gateway. The peer gateway could either be an external VPN gateway or a Google Cloud VPN gateway.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.VpnGatewayStatusVpnConnection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.VpnGatewayStatusVpnConnection)
      com.google.cloud.compute.v1.VpnGatewayStatusVpnConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VpnGatewayStatusVpnConnection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VpnGatewayStatusVpnConnection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.class,
              com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStateFieldBuilder();
        getTunnelsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      peerExternalGateway_ = "";
      peerGcpGateway_ = "";
      state_ = null;
      if (stateBuilder_ != null) {
        stateBuilder_.dispose();
        stateBuilder_ = null;
      }
      if (tunnelsBuilder_ == null) {
        tunnels_ = java.util.Collections.emptyList();
      } else {
        tunnels_ = null;
        tunnelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VpnGatewayStatusVpnConnection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection build() {
      com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection buildPartial() {
      com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection result =
          new com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection result) {
      if (tunnelsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          tunnels_ = java.util.Collections.unmodifiableList(tunnels_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.tunnels_ = tunnels_;
      } else {
        result.tunnels_ = tunnelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.peerExternalGateway_ = peerExternalGateway_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.peerGcpGateway_ = peerGcpGateway_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = stateBuilder_ == null ? state_ : stateBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection) {
        return mergeFrom((com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection other) {
      if (other == com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection.getDefaultInstance())
        return this;
      if (other.hasPeerExternalGateway()) {
        peerExternalGateway_ = other.peerExternalGateway_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPeerGcpGateway()) {
        peerGcpGateway_ = other.peerGcpGateway_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasState()) {
        mergeState(other.getState());
      }
      if (tunnelsBuilder_ == null) {
        if (!other.tunnels_.isEmpty()) {
          if (tunnels_.isEmpty()) {
            tunnels_ = other.tunnels_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTunnelsIsMutable();
            tunnels_.addAll(other.tunnels_);
          }
          onChanged();
        }
      } else {
        if (!other.tunnels_.isEmpty()) {
          if (tunnelsBuilder_.isEmpty()) {
            tunnelsBuilder_.dispose();
            tunnelsBuilder_ = null;
            tunnels_ = other.tunnels_;
            bitField0_ = (bitField0_ & ~0x00000008);
            tunnelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTunnelsFieldBuilder()
                    : null;
          } else {
            tunnelsBuilder_.addAllMessages(other.tunnels_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 836495450:
              {
                com.google.cloud.compute.v1.VpnGatewayStatusTunnel m =
                    input.readMessage(
                        com.google.cloud.compute.v1.VpnGatewayStatusTunnel.parser(),
                        extensionRegistry);
                if (tunnelsBuilder_ == null) {
                  ensureTunnelsIsMutable();
                  tunnels_.add(m);
                } else {
                  tunnelsBuilder_.addMessage(m);
                }
                break;
              } // case 836495450
            case 878060682:
              {
                input.readMessage(getStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 878060682
            case -2040027678:
              {
                peerGcpGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -2040027678
            case -1215317910:
              {
                peerExternalGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1215317910
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object peerExternalGateway_ = "";
    /**
     *
     *
     * <pre>
     * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return Whether the peerExternalGateway field is set.
     */
    public boolean hasPeerExternalGateway() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return The peerExternalGateway.
     */
    public java.lang.String getPeerExternalGateway() {
      java.lang.Object ref = peerExternalGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerExternalGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return The bytes for peerExternalGateway.
     */
    public com.google.protobuf.ByteString getPeerExternalGatewayBytes() {
      java.lang.Object ref = peerExternalGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerExternalGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @param value The peerExternalGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerExternalGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerExternalGateway_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerExternalGateway() {
      peerExternalGateway_ = getDefaultInstance().getPeerExternalGateway();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @param value The bytes for peerExternalGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerExternalGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerExternalGateway_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object peerGcpGateway_ = "";
    /**
     *
     *
     * <pre>
     * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return Whether the peerGcpGateway field is set.
     */
    public boolean hasPeerGcpGateway() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return The peerGcpGateway.
     */
    public java.lang.String getPeerGcpGateway() {
      java.lang.Object ref = peerGcpGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerGcpGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return The bytes for peerGcpGateway.
     */
    public com.google.protobuf.ByteString getPeerGcpGatewayBytes() {
      java.lang.Object ref = peerGcpGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerGcpGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @param value The peerGcpGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerGcpGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerGcpGateway_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerGcpGateway() {
      peerGcpGateway_ = getDefaultInstance().getPeerGcpGateway();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are connected. This field is mutually exclusive with peer_gcp_gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @param value The bytes for peerGcpGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerGcpGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerGcpGateway_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState,
            com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState.Builder,
            com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementStateOrBuilder>
        stateBuilder_;
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     *
     * @return The state.
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState getState() {
      if (stateBuilder_ == null) {
        return state_ == null
            ? com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState
                .getDefaultInstance()
            : state_;
      } else {
        return stateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    public Builder setState(
        com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState value) {
      if (stateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        state_ = value;
      } else {
        stateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    public Builder setState(
        com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState.Builder
            builderForValue) {
      if (stateBuilder_ == null) {
        state_ = builderForValue.build();
      } else {
        stateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    public Builder mergeState(
        com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState value) {
      if (stateBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && state_ != null
            && state_
                != com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState
                    .getDefaultInstance()) {
          getStateBuilder().mergeFrom(value);
        } else {
          state_ = value;
        }
      } else {
        stateBuilder_.mergeFrom(value);
      }
      if (state_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = null;
      if (stateBuilder_ != null) {
        stateBuilder_.dispose();
        stateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState.Builder
        getStateBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementStateOrBuilder
        getStateOrBuilder() {
      if (stateBuilder_ != null) {
        return stateBuilder_.getMessageOrBuilder();
      } else {
        return state_ == null
            ? com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState
                .getDefaultInstance()
            : state_;
      }
    }
    /**
     *
     *
     * <pre>
     * HighAvailabilityRequirementState for the VPN connection.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState state = 109757585;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState,
            com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState.Builder,
            com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementStateOrBuilder>
        getStateFieldBuilder() {
      if (stateBuilder_ == null) {
        stateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState,
                com.google.cloud.compute.v1.VpnGatewayStatusHighAvailabilityRequirementState
                    .Builder,
                com.google.cloud.compute.v1
                    .VpnGatewayStatusHighAvailabilityRequirementStateOrBuilder>(
                getState(), getParentForChildren(), isClean());
        state_ = null;
      }
      return stateBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.VpnGatewayStatusTunnel> tunnels_ =
        java.util.Collections.emptyList();

    private void ensureTunnelsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        tunnels_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.VpnGatewayStatusTunnel>(tunnels_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.VpnGatewayStatusTunnel,
            com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder,
            com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder>
        tunnelsBuilder_;

    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.VpnGatewayStatusTunnel> getTunnelsList() {
      if (tunnelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tunnels_);
      } else {
        return tunnelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public int getTunnelsCount() {
      if (tunnelsBuilder_ == null) {
        return tunnels_.size();
      } else {
        return tunnelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusTunnel getTunnels(int index) {
      if (tunnelsBuilder_ == null) {
        return tunnels_.get(index);
      } else {
        return tunnelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder setTunnels(int index, com.google.cloud.compute.v1.VpnGatewayStatusTunnel value) {
      if (tunnelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTunnelsIsMutable();
        tunnels_.set(index, value);
        onChanged();
      } else {
        tunnelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder setTunnels(
        int index, com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder builderForValue) {
      if (tunnelsBuilder_ == null) {
        ensureTunnelsIsMutable();
        tunnels_.set(index, builderForValue.build());
        onChanged();
      } else {
        tunnelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder addTunnels(com.google.cloud.compute.v1.VpnGatewayStatusTunnel value) {
      if (tunnelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTunnelsIsMutable();
        tunnels_.add(value);
        onChanged();
      } else {
        tunnelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder addTunnels(int index, com.google.cloud.compute.v1.VpnGatewayStatusTunnel value) {
      if (tunnelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTunnelsIsMutable();
        tunnels_.add(index, value);
        onChanged();
      } else {
        tunnelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder addTunnels(
        com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder builderForValue) {
      if (tunnelsBuilder_ == null) {
        ensureTunnelsIsMutable();
        tunnels_.add(builderForValue.build());
        onChanged();
      } else {
        tunnelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder addTunnels(
        int index, com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder builderForValue) {
      if (tunnelsBuilder_ == null) {
        ensureTunnelsIsMutable();
        tunnels_.add(index, builderForValue.build());
        onChanged();
      } else {
        tunnelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder addAllTunnels(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.VpnGatewayStatusTunnel> values) {
      if (tunnelsBuilder_ == null) {
        ensureTunnelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tunnels_);
        onChanged();
      } else {
        tunnelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder clearTunnels() {
      if (tunnelsBuilder_ == null) {
        tunnels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        tunnelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public Builder removeTunnels(int index) {
      if (tunnelsBuilder_ == null) {
        ensureTunnelsIsMutable();
        tunnels_.remove(index);
        onChanged();
      } else {
        tunnelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder getTunnelsBuilder(int index) {
      return getTunnelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder getTunnelsOrBuilder(
        int index) {
      if (tunnelsBuilder_ == null) {
        return tunnels_.get(index);
      } else {
        return tunnelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder>
        getTunnelsOrBuilderList() {
      if (tunnelsBuilder_ != null) {
        return tunnelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tunnels_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder addTunnelsBuilder() {
      return getTunnelsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.VpnGatewayStatusTunnel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder addTunnelsBuilder(int index) {
      return getTunnelsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.VpnGatewayStatusTunnel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of VPN tunnels that are in this VPN connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.VpnGatewayStatusTunnel tunnels = 104561931;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder>
        getTunnelsBuilderList() {
      return getTunnelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.VpnGatewayStatusTunnel,
            com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder,
            com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder>
        getTunnelsFieldBuilder() {
      if (tunnelsBuilder_ == null) {
        tunnelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.VpnGatewayStatusTunnel,
                com.google.cloud.compute.v1.VpnGatewayStatusTunnel.Builder,
                com.google.cloud.compute.v1.VpnGatewayStatusTunnelOrBuilder>(
                tunnels_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        tunnels_ = null;
      }
      return tunnelsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.VpnGatewayStatusVpnConnection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.VpnGatewayStatusVpnConnection)
  private static final com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection();
  }

  public static com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VpnGatewayStatusVpnConnection> PARSER =
      new com.google.protobuf.AbstractParser<VpnGatewayStatusVpnConnection>() {
        @java.lang.Override
        public VpnGatewayStatusVpnConnection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VpnGatewayStatusVpnConnection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VpnGatewayStatusVpnConnection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.VpnGatewayStatusVpnConnection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
