/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Output Only] Informational warning message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Warning}
 */
public final class Warning extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Warning)
    WarningOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Warning.newBuilder() to construct.
  private Warning(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Warning() {
    code_ = "";
    data_ = java.util.Collections.emptyList();
    message_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Warning();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Warning_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Warning_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Warning.class,
            com.google.cloud.compute.v1.Warning.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Warning.Code}
   */
  public enum Code implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CODE = 0;</code>
     */
    UNDEFINED_CODE(0),
    /**
     *
     *
     * <pre>
     * Warning about failed cleanup of transient changes made by a failed operation.
     * </pre>
     *
     * <code>CLEANUP_FAILED = 150308440;</code>
     */
    CLEANUP_FAILED(150308440),
    /**
     *
     *
     * <pre>
     * A link to a deprecated resource was created.
     * </pre>
     *
     * <code>DEPRECATED_RESOURCE_USED = 391835586;</code>
     */
    DEPRECATED_RESOURCE_USED(391835586),
    /**
     *
     *
     * <pre>
     * When deploying and at least one of the resources has a type marked as deprecated
     * </pre>
     *
     * <code>DEPRECATED_TYPE_USED = 346526230;</code>
     */
    DEPRECATED_TYPE_USED(346526230),
    /**
     *
     *
     * <pre>
     * The user created a boot disk that is larger than image size.
     * </pre>
     *
     * <code>DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 369442967;</code>
     */
    DISK_SIZE_LARGER_THAN_IMAGE_SIZE(369442967),
    /**
     *
     *
     * <pre>
     * When deploying and at least one of the resources has a type marked as experimental
     * </pre>
     *
     * <code>EXPERIMENTAL_TYPE_USED = 451954443;</code>
     */
    EXPERIMENTAL_TYPE_USED(451954443),
    /**
     *
     *
     * <pre>
     * Warning that is present in an external api call
     * </pre>
     *
     * <code>EXTERNAL_API_WARNING = 175546307;</code>
     */
    EXTERNAL_API_WARNING(175546307),
    /**
     *
     *
     * <pre>
     * Warning that value of a field has been overridden. Deprecated unused field.
     * </pre>
     *
     * <code>FIELD_VALUE_OVERRIDEN = 329669423;</code>
     */
    FIELD_VALUE_OVERRIDEN(329669423),
    /**
     *
     *
     * <pre>
     * The operation involved use of an injected kernel, which is deprecated.
     * </pre>
     *
     * <code>INJECTED_KERNELS_DEPRECATED = 417377419;</code>
     */
    INJECTED_KERNELS_DEPRECATED(417377419),
    /**
     *
     *
     * <pre>
     * A WEIGHTED_MAGLEV backend service is associated with a health check that is not of type HTTP/HTTPS/HTTP2.
     * </pre>
     *
     * <code>INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB = 401542606;</code>
     */
    INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB(401542606),
    /**
     *
     *
     * <pre>
     * When deploying a deployment with a exceedingly large number of resources
     * </pre>
     *
     * <code>LARGE_DEPLOYMENT_WARNING = 481440678;</code>
     */
    LARGE_DEPLOYMENT_WARNING(481440678),
    /**
     *
     *
     * <pre>
     * Resource can't be retrieved due to list overhead quota exceed which captures the amount of resources filtered out by user-defined list filter.
     * </pre>
     *
     * <code>LIST_OVERHEAD_QUOTA_EXCEED = 47618117;</code>
     */
    LIST_OVERHEAD_QUOTA_EXCEED(47618117),
    /**
     *
     *
     * <pre>
     * A resource depends on a missing type
     * </pre>
     *
     * <code>MISSING_TYPE_DEPENDENCY = 344505463;</code>
     */
    MISSING_TYPE_DEPENDENCY(344505463),
    /**
     *
     *
     * <pre>
     * The route's nextHopIp address is not assigned to an instance on the network.
     * </pre>
     *
     * <code>NEXT_HOP_ADDRESS_NOT_ASSIGNED = 324964999;</code>
     */
    NEXT_HOP_ADDRESS_NOT_ASSIGNED(324964999),
    /**
     *
     *
     * <pre>
     * The route's next hop instance cannot ip forward.
     * </pre>
     *
     * <code>NEXT_HOP_CANNOT_IP_FORWARD = 383382887;</code>
     */
    NEXT_HOP_CANNOT_IP_FORWARD(383382887),
    /**
     *
     *
     * <pre>
     * The route's nextHopInstance URL refers to an instance that does not have an ipv6 interface on the same network as the route.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE = 146748434;</code>
     */
    NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE(146748434),
    /**
     *
     *
     * <pre>
     * The route's nextHopInstance URL refers to an instance that does not exist.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE_NOT_FOUND = 464250446;</code>
     */
    NEXT_HOP_INSTANCE_NOT_FOUND(464250446),
    /**
     *
     *
     * <pre>
     * The route's nextHopInstance URL refers to an instance that is not on the same network as the route.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 243758146;</code>
     */
    NEXT_HOP_INSTANCE_NOT_ON_NETWORK(243758146),
    /**
     *
     *
     * <pre>
     * The route's next hop instance does not have a status of RUNNING.
     * </pre>
     *
     * <code>NEXT_HOP_NOT_RUNNING = 417081265;</code>
     */
    NEXT_HOP_NOT_RUNNING(417081265),
    /**
     *
     *
     * <pre>
     * Error which is not critical. We decided to continue the process despite the mentioned error.
     * </pre>
     *
     * <code>NOT_CRITICAL_ERROR = 105763924;</code>
     */
    NOT_CRITICAL_ERROR(105763924),
    /**
     *
     *
     * <pre>
     * No results are present on a particular list page.
     * </pre>
     *
     * <code>NO_RESULTS_ON_PAGE = 30036744;</code>
     */
    NO_RESULTS_ON_PAGE(30036744),
    /**
     *
     *
     * <pre>
     * Success is reported, but some results may be missing due to errors
     * </pre>
     *
     * <code>PARTIAL_SUCCESS = 39966469;</code>
     */
    PARTIAL_SUCCESS(39966469),
    /**
     *
     *
     * <pre>
     * The user attempted to use a resource that requires a TOS they have not accepted.
     * </pre>
     *
     * <code>REQUIRED_TOS_AGREEMENT = 3745539;</code>
     */
    REQUIRED_TOS_AGREEMENT(3745539),
    /**
     *
     *
     * <pre>
     * Warning that a resource is in use.
     * </pre>
     *
     * <code>RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 496728641;</code>
     */
    RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING(496728641),
    /**
     *
     *
     * <pre>
     * One or more of the resources set to auto-delete could not be deleted because they were in use.
     * </pre>
     *
     * <code>RESOURCE_NOT_DELETED = 168598460;</code>
     */
    RESOURCE_NOT_DELETED(168598460),
    /**
     *
     *
     * <pre>
     * When a resource schema validation is ignored.
     * </pre>
     *
     * <code>SCHEMA_VALIDATION_IGNORED = 275245642;</code>
     */
    SCHEMA_VALIDATION_IGNORED(275245642),
    /**
     *
     *
     * <pre>
     * Instance template used in instance group manager is valid as such, but its application does not make a lot of sense, because it allows only single instance in instance group.
     * </pre>
     *
     * <code>SINGLE_INSTANCE_PROPERTY_TEMPLATE = 268305617;</code>
     */
    SINGLE_INSTANCE_PROPERTY_TEMPLATE(268305617),
    /**
     *
     *
     * <pre>
     * When undeclared properties in the schema are present
     * </pre>
     *
     * <code>UNDECLARED_PROPERTIES = 390513439;</code>
     */
    UNDECLARED_PROPERTIES(390513439),
    /**
     *
     *
     * <pre>
     * A given scope cannot be reached.
     * </pre>
     *
     * <code>UNREACHABLE = 13328052;</code>
     */
    UNREACHABLE(13328052),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CODE = 0;</code>
     */
    public static final int UNDEFINED_CODE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Warning about failed cleanup of transient changes made by a failed operation.
     * </pre>
     *
     * <code>CLEANUP_FAILED = 150308440;</code>
     */
    public static final int CLEANUP_FAILED_VALUE = 150308440;
    /**
     *
     *
     * <pre>
     * A link to a deprecated resource was created.
     * </pre>
     *
     * <code>DEPRECATED_RESOURCE_USED = 391835586;</code>
     */
    public static final int DEPRECATED_RESOURCE_USED_VALUE = 391835586;
    /**
     *
     *
     * <pre>
     * When deploying and at least one of the resources has a type marked as deprecated
     * </pre>
     *
     * <code>DEPRECATED_TYPE_USED = 346526230;</code>
     */
    public static final int DEPRECATED_TYPE_USED_VALUE = 346526230;
    /**
     *
     *
     * <pre>
     * The user created a boot disk that is larger than image size.
     * </pre>
     *
     * <code>DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 369442967;</code>
     */
    public static final int DISK_SIZE_LARGER_THAN_IMAGE_SIZE_VALUE = 369442967;
    /**
     *
     *
     * <pre>
     * When deploying and at least one of the resources has a type marked as experimental
     * </pre>
     *
     * <code>EXPERIMENTAL_TYPE_USED = 451954443;</code>
     */
    public static final int EXPERIMENTAL_TYPE_USED_VALUE = 451954443;
    /**
     *
     *
     * <pre>
     * Warning that is present in an external api call
     * </pre>
     *
     * <code>EXTERNAL_API_WARNING = 175546307;</code>
     */
    public static final int EXTERNAL_API_WARNING_VALUE = 175546307;
    /**
     *
     *
     * <pre>
     * Warning that value of a field has been overridden. Deprecated unused field.
     * </pre>
     *
     * <code>FIELD_VALUE_OVERRIDEN = 329669423;</code>
     */
    public static final int FIELD_VALUE_OVERRIDEN_VALUE = 329669423;
    /**
     *
     *
     * <pre>
     * The operation involved use of an injected kernel, which is deprecated.
     * </pre>
     *
     * <code>INJECTED_KERNELS_DEPRECATED = 417377419;</code>
     */
    public static final int INJECTED_KERNELS_DEPRECATED_VALUE = 417377419;
    /**
     *
     *
     * <pre>
     * A WEIGHTED_MAGLEV backend service is associated with a health check that is not of type HTTP/HTTPS/HTTP2.
     * </pre>
     *
     * <code>INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB = 401542606;</code>
     */
    public static final int INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB_VALUE = 401542606;
    /**
     *
     *
     * <pre>
     * When deploying a deployment with a exceedingly large number of resources
     * </pre>
     *
     * <code>LARGE_DEPLOYMENT_WARNING = 481440678;</code>
     */
    public static final int LARGE_DEPLOYMENT_WARNING_VALUE = 481440678;
    /**
     *
     *
     * <pre>
     * Resource can't be retrieved due to list overhead quota exceed which captures the amount of resources filtered out by user-defined list filter.
     * </pre>
     *
     * <code>LIST_OVERHEAD_QUOTA_EXCEED = 47618117;</code>
     */
    public static final int LIST_OVERHEAD_QUOTA_EXCEED_VALUE = 47618117;
    /**
     *
     *
     * <pre>
     * A resource depends on a missing type
     * </pre>
     *
     * <code>MISSING_TYPE_DEPENDENCY = 344505463;</code>
     */
    public static final int MISSING_TYPE_DEPENDENCY_VALUE = 344505463;
    /**
     *
     *
     * <pre>
     * The route's nextHopIp address is not assigned to an instance on the network.
     * </pre>
     *
     * <code>NEXT_HOP_ADDRESS_NOT_ASSIGNED = 324964999;</code>
     */
    public static final int NEXT_HOP_ADDRESS_NOT_ASSIGNED_VALUE = 324964999;
    /**
     *
     *
     * <pre>
     * The route's next hop instance cannot ip forward.
     * </pre>
     *
     * <code>NEXT_HOP_CANNOT_IP_FORWARD = 383382887;</code>
     */
    public static final int NEXT_HOP_CANNOT_IP_FORWARD_VALUE = 383382887;
    /**
     *
     *
     * <pre>
     * The route's nextHopInstance URL refers to an instance that does not have an ipv6 interface on the same network as the route.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE = 146748434;</code>
     */
    public static final int NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE_VALUE = 146748434;
    /**
     *
     *
     * <pre>
     * The route's nextHopInstance URL refers to an instance that does not exist.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE_NOT_FOUND = 464250446;</code>
     */
    public static final int NEXT_HOP_INSTANCE_NOT_FOUND_VALUE = 464250446;
    /**
     *
     *
     * <pre>
     * The route's nextHopInstance URL refers to an instance that is not on the same network as the route.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 243758146;</code>
     */
    public static final int NEXT_HOP_INSTANCE_NOT_ON_NETWORK_VALUE = 243758146;
    /**
     *
     *
     * <pre>
     * The route's next hop instance does not have a status of RUNNING.
     * </pre>
     *
     * <code>NEXT_HOP_NOT_RUNNING = 417081265;</code>
     */
    public static final int NEXT_HOP_NOT_RUNNING_VALUE = 417081265;
    /**
     *
     *
     * <pre>
     * Error which is not critical. We decided to continue the process despite the mentioned error.
     * </pre>
     *
     * <code>NOT_CRITICAL_ERROR = 105763924;</code>
     */
    public static final int NOT_CRITICAL_ERROR_VALUE = 105763924;
    /**
     *
     *
     * <pre>
     * No results are present on a particular list page.
     * </pre>
     *
     * <code>NO_RESULTS_ON_PAGE = 30036744;</code>
     */
    public static final int NO_RESULTS_ON_PAGE_VALUE = 30036744;
    /**
     *
     *
     * <pre>
     * Success is reported, but some results may be missing due to errors
     * </pre>
     *
     * <code>PARTIAL_SUCCESS = 39966469;</code>
     */
    public static final int PARTIAL_SUCCESS_VALUE = 39966469;
    /**
     *
     *
     * <pre>
     * The user attempted to use a resource that requires a TOS they have not accepted.
     * </pre>
     *
     * <code>REQUIRED_TOS_AGREEMENT = 3745539;</code>
     */
    public static final int REQUIRED_TOS_AGREEMENT_VALUE = 3745539;
    /**
     *
     *
     * <pre>
     * Warning that a resource is in use.
     * </pre>
     *
     * <code>RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 496728641;</code>
     */
    public static final int RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING_VALUE = 496728641;
    /**
     *
     *
     * <pre>
     * One or more of the resources set to auto-delete could not be deleted because they were in use.
     * </pre>
     *
     * <code>RESOURCE_NOT_DELETED = 168598460;</code>
     */
    public static final int RESOURCE_NOT_DELETED_VALUE = 168598460;
    /**
     *
     *
     * <pre>
     * When a resource schema validation is ignored.
     * </pre>
     *
     * <code>SCHEMA_VALIDATION_IGNORED = 275245642;</code>
     */
    public static final int SCHEMA_VALIDATION_IGNORED_VALUE = 275245642;
    /**
     *
     *
     * <pre>
     * Instance template used in instance group manager is valid as such, but its application does not make a lot of sense, because it allows only single instance in instance group.
     * </pre>
     *
     * <code>SINGLE_INSTANCE_PROPERTY_TEMPLATE = 268305617;</code>
     */
    public static final int SINGLE_INSTANCE_PROPERTY_TEMPLATE_VALUE = 268305617;
    /**
     *
     *
     * <pre>
     * When undeclared properties in the schema are present
     * </pre>
     *
     * <code>UNDECLARED_PROPERTIES = 390513439;</code>
     */
    public static final int UNDECLARED_PROPERTIES_VALUE = 390513439;
    /**
     *
     *
     * <pre>
     * A given scope cannot be reached.
     * </pre>
     *
     * <code>UNREACHABLE = 13328052;</code>
     */
    public static final int UNREACHABLE_VALUE = 13328052;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Code valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Code forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CODE;
        case 150308440:
          return CLEANUP_FAILED;
        case 391835586:
          return DEPRECATED_RESOURCE_USED;
        case 346526230:
          return DEPRECATED_TYPE_USED;
        case 369442967:
          return DISK_SIZE_LARGER_THAN_IMAGE_SIZE;
        case 451954443:
          return EXPERIMENTAL_TYPE_USED;
        case 175546307:
          return EXTERNAL_API_WARNING;
        case 329669423:
          return FIELD_VALUE_OVERRIDEN;
        case 417377419:
          return INJECTED_KERNELS_DEPRECATED;
        case 401542606:
          return INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB;
        case 481440678:
          return LARGE_DEPLOYMENT_WARNING;
        case 47618117:
          return LIST_OVERHEAD_QUOTA_EXCEED;
        case 344505463:
          return MISSING_TYPE_DEPENDENCY;
        case 324964999:
          return NEXT_HOP_ADDRESS_NOT_ASSIGNED;
        case 383382887:
          return NEXT_HOP_CANNOT_IP_FORWARD;
        case 146748434:
          return NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE;
        case 464250446:
          return NEXT_HOP_INSTANCE_NOT_FOUND;
        case 243758146:
          return NEXT_HOP_INSTANCE_NOT_ON_NETWORK;
        case 417081265:
          return NEXT_HOP_NOT_RUNNING;
        case 105763924:
          return NOT_CRITICAL_ERROR;
        case 30036744:
          return NO_RESULTS_ON_PAGE;
        case 39966469:
          return PARTIAL_SUCCESS;
        case 3745539:
          return REQUIRED_TOS_AGREEMENT;
        case 496728641:
          return RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING;
        case 168598460:
          return RESOURCE_NOT_DELETED;
        case 275245642:
          return SCHEMA_VALIDATION_IGNORED;
        case 268305617:
          return SINGLE_INSTANCE_PROPERTY_TEMPLATE;
        case 390513439:
          return UNDECLARED_PROPERTIES;
        case 13328052:
          return UNREACHABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Code> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Code> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Code>() {
          public Code findValueByNumber(int number) {
            return Code.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Warning.getDescriptor().getEnumTypes().get(0);
    }

    private static final Code[] VALUES = values();

    public static Code valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Code(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Warning.Code)
  }

  private int bitField0_;
  public static final int CODE_FIELD_NUMBER = 3059181;

  @SuppressWarnings("serial")
  private volatile java.lang.Object code_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
   * Check the Code enum for the list of possible values.
   * </pre>
   *
   * <code>optional string code = 3059181;</code>
   *
   * @return Whether the code field is set.
   */
  @java.lang.Override
  public boolean hasCode() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
   * Check the Code enum for the list of possible values.
   * </pre>
   *
   * <code>optional string code = 3059181;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      code_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
   * Check the Code enum for the list of possible values.
   * </pre>
   *
   * <code>optional string code = 3059181;</code>
   *
   * @return The bytes for code.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_FIELD_NUMBER = 3076010;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Data> data_;
  /**
   *
   *
   * <pre>
   * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Data> getDataList() {
    return data_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.DataOrBuilder>
      getDataOrBuilderList() {
    return data_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
   */
  @java.lang.Override
  public int getDataCount() {
    return data_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Data getData(int index) {
    return data_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DataOrBuilder getDataOrBuilder(int index) {
    return data_.get(index);
  }

  public static final int MESSAGE_FIELD_NUMBER = 418054151;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable description of the warning code.
   * </pre>
   *
   * <code>optional string message = 418054151;</code>
   *
   * @return Whether the message field is set.
   */
  @java.lang.Override
  public boolean hasMessage() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable description of the warning code.
   * </pre>
   *
   * <code>optional string message = 418054151;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable description of the warning code.
   * </pre>
   *
   * <code>optional string message = 418054151;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3059181, code_);
    }
    for (int i = 0; i < data_.size(); i++) {
      output.writeMessage(3076010, data_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 418054151, message_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3059181, code_);
    }
    for (int i = 0; i < data_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3076010, data_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(418054151, message_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Warning)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Warning other = (com.google.cloud.compute.v1.Warning) obj;

    if (hasCode() != other.hasCode()) return false;
    if (hasCode()) {
      if (!getCode().equals(other.getCode())) return false;
    }
    if (!getDataList().equals(other.getDataList())) return false;
    if (hasMessage() != other.hasMessage()) return false;
    if (hasMessage()) {
      if (!getMessage().equals(other.getMessage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCode()) {
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCode().hashCode();
    }
    if (getDataCount() > 0) {
      hash = (37 * hash) + DATA_FIELD_NUMBER;
      hash = (53 * hash) + getDataList().hashCode();
    }
    if (hasMessage()) {
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Warning parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Warning parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Warning parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Warning prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Informational warning message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Warning}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Warning)
      com.google.cloud.compute.v1.WarningOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Warning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Warning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Warning.class,
              com.google.cloud.compute.v1.Warning.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Warning.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      code_ = "";
      if (dataBuilder_ == null) {
        data_ = java.util.Collections.emptyList();
      } else {
        data_ = null;
        dataBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      message_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Warning_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Warning getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Warning.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Warning build() {
      com.google.cloud.compute.v1.Warning result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Warning buildPartial() {
      com.google.cloud.compute.v1.Warning result = new com.google.cloud.compute.v1.Warning(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Warning result) {
      if (dataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          data_ = java.util.Collections.unmodifiableList(data_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.data_ = data_;
      } else {
        result.data_ = dataBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Warning result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.code_ = code_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.message_ = message_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Warning) {
        return mergeFrom((com.google.cloud.compute.v1.Warning) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Warning other) {
      if (other == com.google.cloud.compute.v1.Warning.getDefaultInstance()) return this;
      if (other.hasCode()) {
        code_ = other.code_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dataBuilder_ == null) {
        if (!other.data_.isEmpty()) {
          if (data_.isEmpty()) {
            data_ = other.data_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDataIsMutable();
            data_.addAll(other.data_);
          }
          onChanged();
        }
      } else {
        if (!other.data_.isEmpty()) {
          if (dataBuilder_.isEmpty()) {
            dataBuilder_.dispose();
            dataBuilder_ = null;
            data_ = other.data_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dataBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataFieldBuilder()
                    : null;
          } else {
            dataBuilder_.addAllMessages(other.data_);
          }
        }
      }
      if (other.hasMessage()) {
        message_ = other.message_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 24473450:
              {
                code_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 24473450
            case 24608082:
              {
                com.google.cloud.compute.v1.Data m =
                    input.readMessage(com.google.cloud.compute.v1.Data.parser(), extensionRegistry);
                if (dataBuilder_ == null) {
                  ensureDataIsMutable();
                  data_.add(m);
                } else {
                  dataBuilder_.addMessage(m);
                }
                break;
              } // case 24608082
            case -950534086:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -950534086
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object code_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
     * Check the Code enum for the list of possible values.
     * </pre>
     *
     * <code>optional string code = 3059181;</code>
     *
     * @return Whether the code field is set.
     */
    public boolean hasCode() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
     * Check the Code enum for the list of possible values.
     * </pre>
     *
     * <code>optional string code = 3059181;</code>
     *
     * @return The code.
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
     * Check the Code enum for the list of possible values.
     * </pre>
     *
     * <code>optional string code = 3059181;</code>
     *
     * @return The bytes for code.
     */
    public com.google.protobuf.ByteString getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
     * Check the Code enum for the list of possible values.
     * </pre>
     *
     * <code>optional string code = 3059181;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      code_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
     * Check the Code enum for the list of possible values.
     * </pre>
     *
     * <code>optional string code = 3059181;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      code_ = getDefaultInstance().getCode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
     * Check the Code enum for the list of possible values.
     * </pre>
     *
     * <code>optional string code = 3059181;</code>
     *
     * @param value The bytes for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      code_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Data> data_ =
        java.util.Collections.emptyList();

    private void ensureDataIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        data_ = new java.util.ArrayList<com.google.cloud.compute.v1.Data>(data_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Data,
            com.google.cloud.compute.v1.Data.Builder,
            com.google.cloud.compute.v1.DataOrBuilder>
        dataBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Data> getDataList() {
      if (dataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(data_);
      } else {
        return dataBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public int getDataCount() {
      if (dataBuilder_ == null) {
        return data_.size();
      } else {
        return dataBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public com.google.cloud.compute.v1.Data getData(int index) {
      if (dataBuilder_ == null) {
        return data_.get(index);
      } else {
        return dataBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder setData(int index, com.google.cloud.compute.v1.Data value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataIsMutable();
        data_.set(index, value);
        onChanged();
      } else {
        dataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder setData(int index, com.google.cloud.compute.v1.Data.Builder builderForValue) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder addData(com.google.cloud.compute.v1.Data value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataIsMutable();
        data_.add(value);
        onChanged();
      } else {
        dataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder addData(int index, com.google.cloud.compute.v1.Data value) {
      if (dataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataIsMutable();
        data_.add(index, value);
        onChanged();
      } else {
        dataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder addData(com.google.cloud.compute.v1.Data.Builder builderForValue) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.add(builderForValue.build());
        onChanged();
      } else {
        dataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder addData(int index, com.google.cloud.compute.v1.Data.Builder builderForValue) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder addAllData(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Data> values) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, data_);
        onChanged();
      } else {
        dataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder clearData() {
      if (dataBuilder_ == null) {
        data_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public Builder removeData(int index) {
      if (dataBuilder_ == null) {
        ensureDataIsMutable();
        data_.remove(index);
        onChanged();
      } else {
        dataBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public com.google.cloud.compute.v1.Data.Builder getDataBuilder(int index) {
      return getDataFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public com.google.cloud.compute.v1.DataOrBuilder getDataOrBuilder(int index) {
      if (dataBuilder_ == null) {
        return data_.get(index);
      } else {
        return dataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.DataOrBuilder>
        getDataOrBuilderList() {
      if (dataBuilder_ != null) {
        return dataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(data_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public com.google.cloud.compute.v1.Data.Builder addDataBuilder() {
      return getDataFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Data.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public com.google.cloud.compute.v1.Data.Builder addDataBuilder(int index) {
      return getDataFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Data.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Data data = 3076010;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Data.Builder> getDataBuilderList() {
      return getDataFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Data,
            com.google.cloud.compute.v1.Data.Builder,
            com.google.cloud.compute.v1.DataOrBuilder>
        getDataFieldBuilder() {
      if (dataBuilder_ == null) {
        dataBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Data,
                com.google.cloud.compute.v1.Data.Builder,
                com.google.cloud.compute.v1.DataOrBuilder>(
                data_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        data_ = null;
      }
      return dataBuilder_;
    }

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable description of the warning code.
     * </pre>
     *
     * <code>optional string message = 418054151;</code>
     *
     * @return Whether the message field is set.
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable description of the warning code.
     * </pre>
     *
     * <code>optional string message = 418054151;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable description of the warning code.
     * </pre>
     *
     * <code>optional string message = 418054151;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable description of the warning code.
     * </pre>
     *
     * <code>optional string message = 418054151;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable description of the warning code.
     * </pre>
     *
     * <code>optional string message = 418054151;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable description of the warning code.
     * </pre>
     *
     * <code>optional string message = 418054151;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Warning)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Warning)
  private static final com.google.cloud.compute.v1.Warning DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Warning();
  }

  public static com.google.cloud.compute.v1.Warning getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Warning> PARSER =
      new com.google.protobuf.AbstractParser<Warning>() {
        @java.lang.Override
        public Warning parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Warning> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Warning> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Warning getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
