/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an Autoscaler resource. Google Compute Engine has two Autoscaler resources: * [Zonal](/compute/docs/reference/rest/v1/autoscalers) * [Regional](/compute/docs/reference/rest/v1/regionAutoscalers) Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances. For zonal managed instance groups resource, use the autoscaler resource. For regional managed instance groups, use the regionAutoscalers resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Autoscaler}
 */
public final class Autoscaler extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Autoscaler)
    AutoscalerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Autoscaler.newBuilder() to construct.
  private Autoscaler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Autoscaler() {
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    name_ = "";
    region_ = "";
    selfLink_ = "";
    status_ = "";
    statusDetails_ = java.util.Collections.emptyList();
    target_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Autoscaler();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Autoscaler_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 465950178:
        return internalGetScalingScheduleStatus();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Autoscaler_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Autoscaler.class,
            com.google.cloud.compute.v1.Autoscaler.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Autoscaler.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Configuration is acknowledged to be effective
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /**
     *
     *
     * <pre>
     * Configuration is being deleted
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * Configuration has errors. Actionable for users.
     * </pre>
     *
     * <code>ERROR = 66247144;</code>
     */
    ERROR(66247144),
    /**
     *
     *
     * <pre>
     * Autoscaler backend hasn't read new/updated configuration
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    PENDING(35394935),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Configuration is acknowledged to be effective
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;
    /**
     *
     *
     * <pre>
     * Configuration is being deleted
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;
    /**
     *
     *
     * <pre>
     * Configuration has errors. Actionable for users.
     * </pre>
     *
     * <code>ERROR = 66247144;</code>
     */
    public static final int ERROR_VALUE = 66247144;
    /**
     *
     *
     * <pre>
     * Autoscaler backend hasn't read new/updated configuration
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    public static final int PENDING_VALUE = 35394935;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 314733318:
          return ACTIVE;
        case 528602024:
          return DELETING;
        case 66247144:
          return ERROR;
        case 35394935:
          return PENDING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Autoscaler.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Autoscaler.Status)
  }

  private int bitField0_;
  public static final int AUTOSCALING_POLICY_FIELD_NUMBER = 221950041;
  private com.google.cloud.compute.v1.AutoscalingPolicy autoscalingPolicy_;
  /**
   *
   *
   * <pre>
   * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
   * </code>
   *
   * @return Whether the autoscalingPolicy field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
   * </code>
   *
   * @return The autoscalingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AutoscalingPolicy getAutoscalingPolicy() {
    return autoscalingPolicy_ == null
        ? com.google.cloud.compute.v1.AutoscalingPolicy.getDefaultInstance()
        : autoscalingPolicy_;
  }
  /**
   *
   *
   * <pre>
   * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AutoscalingPolicyOrBuilder getAutoscalingPolicyOrBuilder() {
    return autoscalingPolicy_ == null
        ? com.google.cloud.compute.v1.AutoscalingPolicy.getDefaultInstance()
        : autoscalingPolicy_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECOMMENDED_SIZE_FIELD_NUMBER = 257915749;
  private int recommendedSize_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
   * </pre>
   *
   * <code>optional int32 recommended_size = 257915749;</code>
   *
   * @return Whether the recommendedSize field is set.
   */
  @java.lang.Override
  public boolean hasRecommendedSize() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
   * </pre>
   *
   * <code>optional int32 recommended_size = 257915749;</code>
   *
   * @return The recommendedSize.
   */
  @java.lang.Override
  public int getRecommendedSize() {
    return recommendedSize_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCALING_SCHEDULE_STATUS_FIELD_NUMBER = 465950178;

  private static final class ScalingScheduleStatusDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_Autoscaler_ScalingScheduleStatusEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.ScalingScheduleStatus.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
      scalingScheduleStatus_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
      internalGetScalingScheduleStatus() {
    if (scalingScheduleStatus_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ScalingScheduleStatusDefaultEntryHolder.defaultEntry);
    }
    return scalingScheduleStatus_;
  }

  public int getScalingScheduleStatusCount() {
    return internalGetScalingScheduleStatus().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Status information of existing scaling schedules.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
   * </code>
   */
  @java.lang.Override
  public boolean containsScalingScheduleStatus(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetScalingScheduleStatus().getMap().containsKey(key);
  }
  /** Use {@link #getScalingScheduleStatusMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
      getScalingScheduleStatus() {
    return getScalingScheduleStatusMap();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Status information of existing scaling schedules.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
      getScalingScheduleStatusMap() {
    return internalGetScalingScheduleStatus().getMap();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Status information of existing scaling schedules.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.ScalingScheduleStatus
      getScalingScheduleStatusOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.ScalingScheduleStatus defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus> map =
        internalGetScalingScheduleStatus().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Status information of existing scaling schedules.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ScalingScheduleStatus getScalingScheduleStatusOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus> map =
        internalGetScalingScheduleStatus().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_DETAILS_FIELD_NUMBER = 363353845;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AutoscalerStatusDetails> statusDetails_;
  /**
   *
   *
   * <pre>
   * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AutoscalerStatusDetails>
      getStatusDetailsList() {
    return statusDetails_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder>
      getStatusDetailsOrBuilderList() {
    return statusDetails_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
   * </code>
   */
  @java.lang.Override
  public int getStatusDetailsCount() {
    return statusDetails_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AutoscalerStatusDetails getStatusDetails(int index) {
    return statusDetails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder getStatusDetailsOrBuilder(
      int index) {
    return statusDetails_.get(index);
  }

  public static final int TARGET_FIELD_NUMBER = 192835985;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
   * </pre>
   *
   * <code>optional string target = 192835985;</code>
   *
   * @return Whether the target field is set.
   */
  @java.lang.Override
  public boolean hasTarget() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
   * </pre>
   *
   * <code>optional string target = 192835985;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
   * </pre>
   *
   * <code>optional string target = 192835985;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 192835985, target_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(221950041, getAutoscalingPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(257915749, recommendedSize_);
    }
    for (int i = 0; i < statusDetails_.size(); i++) {
      output.writeMessage(363353845, statusDetails_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetScalingScheduleStatus(),
        ScalingScheduleStatusDefaultEntryHolder.defaultEntry,
        465950178);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(192835985, target_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              221950041, getAutoscalingPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(257915749, recommendedSize_);
    }
    for (int i = 0; i < statusDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              363353845, statusDetails_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
        entry : internalGetScalingScheduleStatus().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
          scalingScheduleStatus__ =
              ScalingScheduleStatusDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              465950178, scalingScheduleStatus__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Autoscaler)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Autoscaler other = (com.google.cloud.compute.v1.Autoscaler) obj;

    if (hasAutoscalingPolicy() != other.hasAutoscalingPolicy()) return false;
    if (hasAutoscalingPolicy()) {
      if (!getAutoscalingPolicy().equals(other.getAutoscalingPolicy())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasRecommendedSize() != other.hasRecommendedSize()) return false;
    if (hasRecommendedSize()) {
      if (getRecommendedSize() != other.getRecommendedSize()) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (!internalGetScalingScheduleStatus().equals(other.internalGetScalingScheduleStatus()))
      return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStatusDetailsList().equals(other.getStatusDetailsList())) return false;
    if (hasTarget() != other.hasTarget()) return false;
    if (hasTarget()) {
      if (!getTarget().equals(other.getTarget())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutoscalingPolicy()) {
      hash = (37 * hash) + AUTOSCALING_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingPolicy().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasRecommendedSize()) {
      hash = (37 * hash) + RECOMMENDED_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getRecommendedSize();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (!internalGetScalingScheduleStatus().getMap().isEmpty()) {
      hash = (37 * hash) + SCALING_SCHEDULE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetScalingScheduleStatus().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStatusDetailsCount() > 0) {
      hash = (37 * hash) + STATUS_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getStatusDetailsList().hashCode();
    }
    if (hasTarget()) {
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTarget().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Autoscaler parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Autoscaler prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an Autoscaler resource. Google Compute Engine has two Autoscaler resources: * [Zonal](/compute/docs/reference/rest/v1/autoscalers) * [Regional](/compute/docs/reference/rest/v1/regionAutoscalers) Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances. For zonal managed instance groups resource, use the autoscaler resource. For regional managed instance groups, use the regionAutoscalers resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Autoscaler}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Autoscaler)
      com.google.cloud.compute.v1.AutoscalerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Autoscaler_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 465950178:
          return internalGetScalingScheduleStatus();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 465950178:
          return internalGetMutableScalingScheduleStatus();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Autoscaler_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Autoscaler.class,
              com.google.cloud.compute.v1.Autoscaler.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Autoscaler.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAutoscalingPolicyFieldBuilder();
        getStatusDetailsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoscalingPolicy_ = null;
      if (autoscalingPolicyBuilder_ != null) {
        autoscalingPolicyBuilder_.dispose();
        autoscalingPolicyBuilder_ = null;
      }
      creationTimestamp_ = "";
      description_ = "";
      id_ = 0L;
      kind_ = "";
      name_ = "";
      recommendedSize_ = 0;
      region_ = "";
      internalGetMutableScalingScheduleStatus().clear();
      selfLink_ = "";
      status_ = "";
      if (statusDetailsBuilder_ == null) {
        statusDetails_ = java.util.Collections.emptyList();
      } else {
        statusDetails_ = null;
        statusDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      target_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Autoscaler_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Autoscaler getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Autoscaler.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Autoscaler build() {
      com.google.cloud.compute.v1.Autoscaler result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Autoscaler buildPartial() {
      com.google.cloud.compute.v1.Autoscaler result =
          new com.google.cloud.compute.v1.Autoscaler(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Autoscaler result) {
      if (statusDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          statusDetails_ = java.util.Collections.unmodifiableList(statusDetails_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.statusDetails_ = statusDetails_;
      } else {
        result.statusDetails_ = statusDetailsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Autoscaler result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.autoscalingPolicy_ =
            autoscalingPolicyBuilder_ == null
                ? autoscalingPolicy_
                : autoscalingPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.recommendedSize_ = recommendedSize_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.scalingScheduleStatus_ =
            internalGetScalingScheduleStatus()
                .build(ScalingScheduleStatusDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.target_ = target_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00000800;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Autoscaler) {
        return mergeFrom((com.google.cloud.compute.v1.Autoscaler) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Autoscaler other) {
      if (other == com.google.cloud.compute.v1.Autoscaler.getDefaultInstance()) return this;
      if (other.hasAutoscalingPolicy()) {
        mergeAutoscalingPolicy(other.getAutoscalingPolicy());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasRecommendedSize()) {
        setRecommendedSize(other.getRecommendedSize());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      internalGetMutableScalingScheduleStatus().mergeFrom(other.internalGetScalingScheduleStatus());
      bitField0_ |= 0x00000100;
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (statusDetailsBuilder_ == null) {
        if (!other.statusDetails_.isEmpty()) {
          if (statusDetails_.isEmpty()) {
            statusDetails_ = other.statusDetails_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureStatusDetailsIsMutable();
            statusDetails_.addAll(other.statusDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.statusDetails_.isEmpty()) {
          if (statusDetailsBuilder_.isEmpty()) {
            statusDetailsBuilder_.dispose();
            statusDetailsBuilder_ = null;
            statusDetails_ = other.statusDetails_;
            bitField0_ = (bitField0_ & ~0x00000800);
            statusDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusDetailsFieldBuilder()
                    : null;
          } else {
            statusDetailsBuilder_.addAllMessages(other.statusDetails_);
          }
        }
      }
      if (other.hasTarget()) {
        target_ = other.target_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26989658
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1111570338
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 1450082194
            case 1542687882:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 1542687882
            case 1775600330:
              {
                input.readMessage(
                    getAutoscalingPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 1775600330
            case 2063325992:
              {
                recommendedSize_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 2063325992
            case -1388136534:
              {
                com.google.cloud.compute.v1.AutoscalerStatusDetails m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AutoscalerStatusDetails.parser(),
                        extensionRegistry);
                if (statusDetailsBuilder_ == null) {
                  ensureStatusDetailsIsMutable();
                  statusDetails_.add(m);
                } else {
                  statusDetailsBuilder_.addMessage(m);
                }
                break;
              } // case -1388136534
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -645248918
            case -567365870:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
                    scalingScheduleStatus__ =
                        input.readMessage(
                            ScalingScheduleStatusDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableScalingScheduleStatus()
                    .ensureBuilderMap()
                    .put(scalingScheduleStatus__.getKey(), scalingScheduleStatus__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case -567365870
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.AutoscalingPolicy autoscalingPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AutoscalingPolicy,
            com.google.cloud.compute.v1.AutoscalingPolicy.Builder,
            com.google.cloud.compute.v1.AutoscalingPolicyOrBuilder>
        autoscalingPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     *
     * @return Whether the autoscalingPolicy field is set.
     */
    public boolean hasAutoscalingPolicy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     *
     * @return The autoscalingPolicy.
     */
    public com.google.cloud.compute.v1.AutoscalingPolicy getAutoscalingPolicy() {
      if (autoscalingPolicyBuilder_ == null) {
        return autoscalingPolicy_ == null
            ? com.google.cloud.compute.v1.AutoscalingPolicy.getDefaultInstance()
            : autoscalingPolicy_;
      } else {
        return autoscalingPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder setAutoscalingPolicy(com.google.cloud.compute.v1.AutoscalingPolicy value) {
      if (autoscalingPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingPolicy_ = value;
      } else {
        autoscalingPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder setAutoscalingPolicy(
        com.google.cloud.compute.v1.AutoscalingPolicy.Builder builderForValue) {
      if (autoscalingPolicyBuilder_ == null) {
        autoscalingPolicy_ = builderForValue.build();
      } else {
        autoscalingPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder mergeAutoscalingPolicy(com.google.cloud.compute.v1.AutoscalingPolicy value) {
      if (autoscalingPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && autoscalingPolicy_ != null
            && autoscalingPolicy_
                != com.google.cloud.compute.v1.AutoscalingPolicy.getDefaultInstance()) {
          getAutoscalingPolicyBuilder().mergeFrom(value);
        } else {
          autoscalingPolicy_ = value;
        }
      } else {
        autoscalingPolicyBuilder_.mergeFrom(value);
      }
      if (autoscalingPolicy_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder clearAutoscalingPolicy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      autoscalingPolicy_ = null;
      if (autoscalingPolicyBuilder_ != null) {
        autoscalingPolicyBuilder_.dispose();
        autoscalingPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalingPolicy.Builder getAutoscalingPolicyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAutoscalingPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalingPolicyOrBuilder getAutoscalingPolicyOrBuilder() {
      if (autoscalingPolicyBuilder_ != null) {
        return autoscalingPolicyBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingPolicy_ == null
            ? com.google.cloud.compute.v1.AutoscalingPolicy.getDefaultInstance()
            : autoscalingPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.AutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AutoscalingPolicy,
            com.google.cloud.compute.v1.AutoscalingPolicy.Builder,
            com.google.cloud.compute.v1.AutoscalingPolicyOrBuilder>
        getAutoscalingPolicyFieldBuilder() {
      if (autoscalingPolicyBuilder_ == null) {
        autoscalingPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AutoscalingPolicy,
                com.google.cloud.compute.v1.AutoscalingPolicy.Builder,
                com.google.cloud.compute.v1.AutoscalingPolicyOrBuilder>(
                getAutoscalingPolicy(), getParentForChildren(), isClean());
        autoscalingPolicy_ = null;
      }
      return autoscalingPolicyBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000008);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int recommendedSize_;
    /**
     *
     *
     * <pre>
     * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
     * </pre>
     *
     * <code>optional int32 recommended_size = 257915749;</code>
     *
     * @return Whether the recommendedSize field is set.
     */
    @java.lang.Override
    public boolean hasRecommendedSize() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
     * </pre>
     *
     * <code>optional int32 recommended_size = 257915749;</code>
     *
     * @return The recommendedSize.
     */
    @java.lang.Override
    public int getRecommendedSize() {
      return recommendedSize_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
     * </pre>
     *
     * <code>optional int32 recommended_size = 257915749;</code>
     *
     * @param value The recommendedSize to set.
     * @return This builder for chaining.
     */
    public Builder setRecommendedSize(int value) {

      recommendedSize_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
     * </pre>
     *
     * <code>optional int32 recommended_size = 257915749;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecommendedSize() {
      bitField0_ = (bitField0_ & ~0x00000040);
      recommendedSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private static final class ScalingScheduleStatusConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder,
            com.google.cloud.compute.v1.ScalingScheduleStatus> {
      @java.lang.Override
      public com.google.cloud.compute.v1.ScalingScheduleStatus build(
          com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.ScalingScheduleStatus) {
          return (com.google.cloud.compute.v1.ScalingScheduleStatus) val;
        }
        return ((com.google.cloud.compute.v1.ScalingScheduleStatus.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
          defaultEntry() {
        return ScalingScheduleStatusDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ScalingScheduleStatusConverter scalingScheduleStatusConverter =
        new ScalingScheduleStatusConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder,
            com.google.cloud.compute.v1.ScalingScheduleStatus,
            com.google.cloud.compute.v1.ScalingScheduleStatus.Builder>
        scalingScheduleStatus_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder,
            com.google.cloud.compute.v1.ScalingScheduleStatus,
            com.google.cloud.compute.v1.ScalingScheduleStatus.Builder>
        internalGetScalingScheduleStatus() {
      if (scalingScheduleStatus_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(scalingScheduleStatusConverter);
      }
      return scalingScheduleStatus_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder,
            com.google.cloud.compute.v1.ScalingScheduleStatus,
            com.google.cloud.compute.v1.ScalingScheduleStatus.Builder>
        internalGetMutableScalingScheduleStatus() {
      if (scalingScheduleStatus_ == null) {
        scalingScheduleStatus_ =
            new com.google.protobuf.MapFieldBuilder<>(scalingScheduleStatusConverter);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return scalingScheduleStatus_;
    }

    public int getScalingScheduleStatusCount() {
      return internalGetScalingScheduleStatus().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    @java.lang.Override
    public boolean containsScalingScheduleStatus(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetScalingScheduleStatus().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getScalingScheduleStatusMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
        getScalingScheduleStatus() {
      return getScalingScheduleStatusMap();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
        getScalingScheduleStatusMap() {
      return internalGetScalingScheduleStatus().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.ScalingScheduleStatus
        getScalingScheduleStatusOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.ScalingScheduleStatus defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder>
          map = internalGetMutableScalingScheduleStatus().ensureBuilderMap();
      return map.containsKey(key)
          ? scalingScheduleStatusConverter.build(map.get(key))
          : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.ScalingScheduleStatus getScalingScheduleStatusOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder>
          map = internalGetMutableScalingScheduleStatus().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return scalingScheduleStatusConverter.build(map.get(key));
    }

    public Builder clearScalingScheduleStatus() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableScalingScheduleStatus().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    public Builder removeScalingScheduleStatus(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableScalingScheduleStatus().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
        getMutableScalingScheduleStatus() {
      bitField0_ |= 0x00000100;
      return internalGetMutableScalingScheduleStatus().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    public Builder putScalingScheduleStatus(
        java.lang.String key, com.google.cloud.compute.v1.ScalingScheduleStatus value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableScalingScheduleStatus().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    public Builder putAllScalingScheduleStatus(
        java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatus>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableScalingScheduleStatus().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status information of existing scaling schedules.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.ScalingScheduleStatus&gt; scaling_schedule_status = 465950178;
     * </code>
     */
    public com.google.cloud.compute.v1.ScalingScheduleStatus.Builder
        putScalingScheduleStatusBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder>
          builderMap = internalGetMutableScalingScheduleStatus().ensureBuilderMap();
      com.google.cloud.compute.v1.ScalingScheduleStatusOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.ScalingScheduleStatus.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.ScalingScheduleStatus) {
        entry = ((com.google.cloud.compute.v1.ScalingScheduleStatus) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.ScalingScheduleStatus.Builder) entry;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.AutoscalerStatusDetails> statusDetails_ =
        java.util.Collections.emptyList();

    private void ensureStatusDetailsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        statusDetails_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AutoscalerStatusDetails>(
                statusDetails_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AutoscalerStatusDetails,
            com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder,
            com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder>
        statusDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AutoscalerStatusDetails>
        getStatusDetailsList() {
      if (statusDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusDetails_);
      } else {
        return statusDetailsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public int getStatusDetailsCount() {
      if (statusDetailsBuilder_ == null) {
        return statusDetails_.size();
      } else {
        return statusDetailsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalerStatusDetails getStatusDetails(int index) {
      if (statusDetailsBuilder_ == null) {
        return statusDetails_.get(index);
      } else {
        return statusDetailsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder setStatusDetails(
        int index, com.google.cloud.compute.v1.AutoscalerStatusDetails value) {
      if (statusDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusDetailsIsMutable();
        statusDetails_.set(index, value);
        onChanged();
      } else {
        statusDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder setStatusDetails(
        int index, com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder builderForValue) {
      if (statusDetailsBuilder_ == null) {
        ensureStatusDetailsIsMutable();
        statusDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder addStatusDetails(com.google.cloud.compute.v1.AutoscalerStatusDetails value) {
      if (statusDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusDetailsIsMutable();
        statusDetails_.add(value);
        onChanged();
      } else {
        statusDetailsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder addStatusDetails(
        int index, com.google.cloud.compute.v1.AutoscalerStatusDetails value) {
      if (statusDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusDetailsIsMutable();
        statusDetails_.add(index, value);
        onChanged();
      } else {
        statusDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder addStatusDetails(
        com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder builderForValue) {
      if (statusDetailsBuilder_ == null) {
        ensureStatusDetailsIsMutable();
        statusDetails_.add(builderForValue.build());
        onChanged();
      } else {
        statusDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder addStatusDetails(
        int index, com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder builderForValue) {
      if (statusDetailsBuilder_ == null) {
        ensureStatusDetailsIsMutable();
        statusDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder addAllStatusDetails(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AutoscalerStatusDetails> values) {
      if (statusDetailsBuilder_ == null) {
        ensureStatusDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusDetails_);
        onChanged();
      } else {
        statusDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder clearStatusDetails() {
      if (statusDetailsBuilder_ == null) {
        statusDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        statusDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public Builder removeStatusDetails(int index) {
      if (statusDetailsBuilder_ == null) {
        ensureStatusDetailsIsMutable();
        statusDetails_.remove(index);
        onChanged();
      } else {
        statusDetailsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder getStatusDetailsBuilder(
        int index) {
      return getStatusDetailsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder getStatusDetailsOrBuilder(
        int index) {
      if (statusDetailsBuilder_ == null) {
        return statusDetails_.get(index);
      } else {
        return statusDetailsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder>
        getStatusDetailsOrBuilderList() {
      if (statusDetailsBuilder_ != null) {
        return statusDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusDetails_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder addStatusDetailsBuilder() {
      return getStatusDetailsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AutoscalerStatusDetails.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder addStatusDetailsBuilder(
        int index) {
      return getStatusDetailsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.AutoscalerStatusDetails.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AutoscalerStatusDetails status_details = 363353845;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder>
        getStatusDetailsBuilderList() {
      return getStatusDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AutoscalerStatusDetails,
            com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder,
            com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder>
        getStatusDetailsFieldBuilder() {
      if (statusDetailsBuilder_ == null) {
        statusDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AutoscalerStatusDetails,
                com.google.cloud.compute.v1.AutoscalerStatusDetails.Builder,
                com.google.cloud.compute.v1.AutoscalerStatusDetailsOrBuilder>(
                statusDetails_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        statusDetails_ = null;
      }
      return statusDetailsBuilder_;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return Whether the target field is set.
     */
    public boolean hasTarget() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Autoscaler)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Autoscaler)
  private static final com.google.cloud.compute.v1.Autoscaler DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Autoscaler();
  }

  public static com.google.cloud.compute.v1.Autoscaler getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Autoscaler> PARSER =
      new com.google.protobuf.AbstractParser<Autoscaler>() {
        @java.lang.Override
        public Autoscaler parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Autoscaler> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Autoscaler> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Autoscaler getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
