/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Backend Service resource. A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly. Backend services in Google Compute Engine can be either regionally or globally scoped. * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices) For more information, see Backend Services.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BackendService}
 */
public final class BackendService extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BackendService)
    BackendServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackendService.newBuilder() to construct.
  private BackendService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackendService() {
    backends_ = java.util.Collections.emptyList();
    compressionMode_ = "";
    creationTimestamp_ = "";
    customRequestHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
    customResponseHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
    description_ = "";
    edgeSecurityPolicy_ = "";
    fingerprint_ = "";
    healthChecks_ = com.google.protobuf.LazyStringArrayList.emptyList();
    kind_ = "";
    loadBalancingScheme_ = "";
    localityLbPolicies_ = java.util.Collections.emptyList();
    localityLbPolicy_ = "";
    name_ = "";
    network_ = "";
    portName_ = "";
    protocol_ = "";
    region_ = "";
    securityPolicy_ = "";
    selfLink_ = "";
    serviceBindings_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceLbPolicy_ = "";
    sessionAffinity_ = "";
    usedBy_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackendService();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendService_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8514340:
        return internalGetMetadatas();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendService_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BackendService.class,
            com.google.cloud.compute.v1.BackendService.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BackendService.CompressionMode}
   */
  public enum CompressionMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_COMPRESSION_MODE = 0;</code>
     */
    UNDEFINED_COMPRESSION_MODE(0),
    /**
     *
     *
     * <pre>
     * Automatically uses the best compression based on the Accept-Encoding header sent by the client.
     * </pre>
     *
     * <code>AUTOMATIC = 165298699;</code>
     */
    AUTOMATIC(165298699),
    /**
     *
     *
     * <pre>
     * Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
     * </pre>
     *
     * <code>DISABLED = 516696700;</code>
     */
    DISABLED(516696700),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_COMPRESSION_MODE = 0;</code>
     */
    public static final int UNDEFINED_COMPRESSION_MODE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Automatically uses the best compression based on the Accept-Encoding header sent by the client.
     * </pre>
     *
     * <code>AUTOMATIC = 165298699;</code>
     */
    public static final int AUTOMATIC_VALUE = 165298699;
    /**
     *
     *
     * <pre>
     * Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
     * </pre>
     *
     * <code>DISABLED = 516696700;</code>
     */
    public static final int DISABLED_VALUE = 516696700;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CompressionMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CompressionMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_COMPRESSION_MODE;
        case 165298699:
          return AUTOMATIC;
        case 516696700:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CompressionMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CompressionMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CompressionMode>() {
              public CompressionMode findValueByNumber(int number) {
                return CompressionMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendService.getDescriptor().getEnumTypes().get(0);
    }

    private static final CompressionMode[] VALUES = values();

    public static CompressionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CompressionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendService.CompressionMode)
  }

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BackendService.LoadBalancingScheme}
   */
  public enum LoadBalancingScheme implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOAD_BALANCING_SCHEME = 0;</code>
     */
    UNDEFINED_LOAD_BALANCING_SCHEME(0),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for classic Application Load Balancers, global external proxy Network Load Balancers, or external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL = 35607499;</code>
     */
    EXTERNAL(35607499),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for global external Application Load Balancers, regional external Application Load Balancers, or regional external proxy Network Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL_MANAGED = 512006923;</code>
     */
    EXTERNAL_MANAGED(512006923),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>INTERNAL = 279295677;</code>
     */
    INTERNAL(279295677),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for internal Application Load Balancers.
     * </pre>
     *
     * <code>INTERNAL_MANAGED = 37350397;</code>
     */
    INTERNAL_MANAGED(37350397),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used by Traffic Director.
     * </pre>
     *
     * <code>INTERNAL_SELF_MANAGED = 236211150;</code>
     */
    INTERNAL_SELF_MANAGED(236211150),
    /** <code>INVALID_LOAD_BALANCING_SCHEME = 275352060;</code> */
    INVALID_LOAD_BALANCING_SCHEME(275352060),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOAD_BALANCING_SCHEME = 0;</code>
     */
    public static final int UNDEFINED_LOAD_BALANCING_SCHEME_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for classic Application Load Balancers, global external proxy Network Load Balancers, or external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL = 35607499;</code>
     */
    public static final int EXTERNAL_VALUE = 35607499;
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for global external Application Load Balancers, regional external Application Load Balancers, or regional external proxy Network Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL_MANAGED = 512006923;</code>
     */
    public static final int EXTERNAL_MANAGED_VALUE = 512006923;
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>INTERNAL = 279295677;</code>
     */
    public static final int INTERNAL_VALUE = 279295677;
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for internal Application Load Balancers.
     * </pre>
     *
     * <code>INTERNAL_MANAGED = 37350397;</code>
     */
    public static final int INTERNAL_MANAGED_VALUE = 37350397;
    /**
     *
     *
     * <pre>
     * Signifies that this will be used by Traffic Director.
     * </pre>
     *
     * <code>INTERNAL_SELF_MANAGED = 236211150;</code>
     */
    public static final int INTERNAL_SELF_MANAGED_VALUE = 236211150;
    /** <code>INVALID_LOAD_BALANCING_SCHEME = 275352060;</code> */
    public static final int INVALID_LOAD_BALANCING_SCHEME_VALUE = 275352060;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoadBalancingScheme valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoadBalancingScheme forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LOAD_BALANCING_SCHEME;
        case 35607499:
          return EXTERNAL;
        case 512006923:
          return EXTERNAL_MANAGED;
        case 279295677:
          return INTERNAL;
        case 37350397:
          return INTERNAL_MANAGED;
        case 236211150:
          return INTERNAL_SELF_MANAGED;
        case 275352060:
          return INVALID_LOAD_BALANCING_SCHEME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoadBalancingScheme>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoadBalancingScheme>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LoadBalancingScheme>() {
              public LoadBalancingScheme findValueByNumber(int number) {
                return LoadBalancingScheme.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendService.getDescriptor().getEnumTypes().get(1);
    }

    private static final LoadBalancingScheme[] VALUES = values();

    public static LoadBalancingScheme valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoadBalancingScheme(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendService.LoadBalancingScheme)
  }

  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BackendService.LocalityLbPolicy}
   */
  public enum LocalityLbPolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOCALITY_LB_POLICY = 0;</code>
     */
    UNDEFINED_LOCALITY_LB_POLICY(0),
    /** <code>INVALID_LB_POLICY = 323318707;</code> */
    INVALID_LB_POLICY(323318707),
    /**
     *
     *
     * <pre>
     * An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
     * </pre>
     *
     * <code>LEAST_REQUEST = 46604921;</code>
     */
    LEAST_REQUEST(46604921),
    /**
     *
     *
     * <pre>
     * This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
     * </pre>
     *
     * <code>MAGLEV = 119180266;</code>
     */
    MAGLEV(119180266),
    /**
     *
     *
     * <pre>
     * Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
     * </pre>
     *
     * <code>ORIGINAL_DESTINATION = 166297216;</code>
     */
    ORIGINAL_DESTINATION(166297216),
    /**
     *
     *
     * <pre>
     * The load balancer selects a random healthy host.
     * </pre>
     *
     * <code>RANDOM = 262527171;</code>
     */
    RANDOM(262527171),
    /**
     *
     *
     * <pre>
     * The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
     * </pre>
     *
     * <code>RING_HASH = 432795069;</code>
     */
    RING_HASH(432795069),
    /**
     *
     *
     * <pre>
     * This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
     * </pre>
     *
     * <code>ROUND_ROBIN = 153895801;</code>
     */
    ROUND_ROBIN(153895801),
    /**
     *
     *
     * <pre>
     * Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
     * </pre>
     *
     * <code>WEIGHTED_MAGLEV = 254930962;</code>
     */
    WEIGHTED_MAGLEV(254930962),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOCALITY_LB_POLICY = 0;</code>
     */
    public static final int UNDEFINED_LOCALITY_LB_POLICY_VALUE = 0;
    /** <code>INVALID_LB_POLICY = 323318707;</code> */
    public static final int INVALID_LB_POLICY_VALUE = 323318707;
    /**
     *
     *
     * <pre>
     * An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
     * </pre>
     *
     * <code>LEAST_REQUEST = 46604921;</code>
     */
    public static final int LEAST_REQUEST_VALUE = 46604921;
    /**
     *
     *
     * <pre>
     * This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
     * </pre>
     *
     * <code>MAGLEV = 119180266;</code>
     */
    public static final int MAGLEV_VALUE = 119180266;
    /**
     *
     *
     * <pre>
     * Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
     * </pre>
     *
     * <code>ORIGINAL_DESTINATION = 166297216;</code>
     */
    public static final int ORIGINAL_DESTINATION_VALUE = 166297216;
    /**
     *
     *
     * <pre>
     * The load balancer selects a random healthy host.
     * </pre>
     *
     * <code>RANDOM = 262527171;</code>
     */
    public static final int RANDOM_VALUE = 262527171;
    /**
     *
     *
     * <pre>
     * The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
     * </pre>
     *
     * <code>RING_HASH = 432795069;</code>
     */
    public static final int RING_HASH_VALUE = 432795069;
    /**
     *
     *
     * <pre>
     * This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
     * </pre>
     *
     * <code>ROUND_ROBIN = 153895801;</code>
     */
    public static final int ROUND_ROBIN_VALUE = 153895801;
    /**
     *
     *
     * <pre>
     * Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
     * </pre>
     *
     * <code>WEIGHTED_MAGLEV = 254930962;</code>
     */
    public static final int WEIGHTED_MAGLEV_VALUE = 254930962;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LocalityLbPolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LocalityLbPolicy forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LOCALITY_LB_POLICY;
        case 323318707:
          return INVALID_LB_POLICY;
        case 46604921:
          return LEAST_REQUEST;
        case 119180266:
          return MAGLEV;
        case 166297216:
          return ORIGINAL_DESTINATION;
        case 262527171:
          return RANDOM;
        case 432795069:
          return RING_HASH;
        case 153895801:
          return ROUND_ROBIN;
        case 254930962:
          return WEIGHTED_MAGLEV;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LocalityLbPolicy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LocalityLbPolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LocalityLbPolicy>() {
              public LocalityLbPolicy findValueByNumber(int number) {
                return LocalityLbPolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendService.getDescriptor().getEnumTypes().get(2);
    }

    private static final LocalityLbPolicy[] VALUES = values();

    public static LocalityLbPolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LocalityLbPolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendService.LocalityLbPolicy)
  }

  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BackendService.Protocol}
   */
  public enum Protocol implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PROTOCOL = 0;</code>
     */
    UNDEFINED_PROTOCOL(0),
    /**
     *
     *
     * <pre>
     * gRPC (available for Traffic Director).
     * </pre>
     *
     * <code>GRPC = 2196510;</code>
     */
    GRPC(2196510),
    /** <code>HTTP = 2228360;</code> */
    HTTP(2228360),
    /**
     *
     *
     * <pre>
     * HTTP/2 with SSL.
     * </pre>
     *
     * <code>HTTP2 = 69079210;</code>
     */
    HTTP2(69079210),
    /** <code>HTTPS = 69079243;</code> */
    HTTPS(69079243),
    /**
     *
     *
     * <pre>
     * TCP proxying with SSL.
     * </pre>
     *
     * <code>SSL = 82412;</code>
     */
    SSL(82412),
    /**
     *
     *
     * <pre>
     * TCP proxying or TCP pass-through.
     * </pre>
     *
     * <code>TCP = 82881;</code>
     */
    TCP(82881),
    /**
     *
     *
     * <pre>
     * UDP.
     * </pre>
     *
     * <code>UDP = 83873;</code>
     */
    UDP(83873),
    /**
     *
     *
     * <pre>
     * If a Backend Service has UNSPECIFIED as its protocol, it can be used with any L3/L4 Forwarding Rules.
     * </pre>
     *
     * <code>UNSPECIFIED = 526786327;</code>
     */
    UNSPECIFIED(526786327),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PROTOCOL = 0;</code>
     */
    public static final int UNDEFINED_PROTOCOL_VALUE = 0;
    /**
     *
     *
     * <pre>
     * gRPC (available for Traffic Director).
     * </pre>
     *
     * <code>GRPC = 2196510;</code>
     */
    public static final int GRPC_VALUE = 2196510;
    /** <code>HTTP = 2228360;</code> */
    public static final int HTTP_VALUE = 2228360;
    /**
     *
     *
     * <pre>
     * HTTP/2 with SSL.
     * </pre>
     *
     * <code>HTTP2 = 69079210;</code>
     */
    public static final int HTTP2_VALUE = 69079210;
    /** <code>HTTPS = 69079243;</code> */
    public static final int HTTPS_VALUE = 69079243;
    /**
     *
     *
     * <pre>
     * TCP proxying with SSL.
     * </pre>
     *
     * <code>SSL = 82412;</code>
     */
    public static final int SSL_VALUE = 82412;
    /**
     *
     *
     * <pre>
     * TCP proxying or TCP pass-through.
     * </pre>
     *
     * <code>TCP = 82881;</code>
     */
    public static final int TCP_VALUE = 82881;
    /**
     *
     *
     * <pre>
     * UDP.
     * </pre>
     *
     * <code>UDP = 83873;</code>
     */
    public static final int UDP_VALUE = 83873;
    /**
     *
     *
     * <pre>
     * If a Backend Service has UNSPECIFIED as its protocol, it can be used with any L3/L4 Forwarding Rules.
     * </pre>
     *
     * <code>UNSPECIFIED = 526786327;</code>
     */
    public static final int UNSPECIFIED_VALUE = 526786327;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Protocol valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Protocol forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PROTOCOL;
        case 2196510:
          return GRPC;
        case 2228360:
          return HTTP;
        case 69079210:
          return HTTP2;
        case 69079243:
          return HTTPS;
        case 82412:
          return SSL;
        case 82881:
          return TCP;
        case 83873:
          return UDP;
        case 526786327:
          return UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Protocol> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Protocol> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Protocol>() {
          public Protocol findValueByNumber(int number) {
            return Protocol.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendService.getDescriptor().getEnumTypes().get(3);
    }

    private static final Protocol[] VALUES = values();

    public static Protocol valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Protocol(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendService.Protocol)
  }

  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BackendService.SessionAffinity}
   */
  public enum SessionAffinity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SESSION_AFFINITY = 0;</code>
     */
    UNDEFINED_SESSION_AFFINITY(0),
    /**
     *
     *
     * <pre>
     * 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
     * </pre>
     *
     * <code>CLIENT_IP = 345665051;</code>
     */
    CLIENT_IP(345665051),
    /**
     *
     *
     * <pre>
     * 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
     * </pre>
     *
     * <code>CLIENT_IP_NO_DESTINATION = 106122516;</code>
     */
    CLIENT_IP_NO_DESTINATION(106122516),
    /**
     *
     *
     * <pre>
     * 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
     * </pre>
     *
     * <code>CLIENT_IP_PORT_PROTO = 221722926;</code>
     */
    CLIENT_IP_PORT_PROTO(221722926),
    /**
     *
     *
     * <pre>
     * 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
     * </pre>
     *
     * <code>CLIENT_IP_PROTO = 25322148;</code>
     */
    CLIENT_IP_PROTO(25322148),
    /**
     *
     *
     * <pre>
     * Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
     * </pre>
     *
     * <code>GENERATED_COOKIE = 370321204;</code>
     */
    GENERATED_COOKIE(370321204),
    /**
     *
     *
     * <pre>
     * The hash is based on a user specified header field.
     * </pre>
     *
     * <code>HEADER_FIELD = 200737960;</code>
     */
    HEADER_FIELD(200737960),
    /**
     *
     *
     * <pre>
     * The hash is based on a user provided cookie.
     * </pre>
     *
     * <code>HTTP_COOKIE = 494981627;</code>
     */
    HTTP_COOKIE(494981627),
    /**
     *
     *
     * <pre>
     * No session affinity. Connections from the same client IP may go to any instance in the pool.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SESSION_AFFINITY = 0;</code>
     */
    public static final int UNDEFINED_SESSION_AFFINITY_VALUE = 0;
    /**
     *
     *
     * <pre>
     * 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
     * </pre>
     *
     * <code>CLIENT_IP = 345665051;</code>
     */
    public static final int CLIENT_IP_VALUE = 345665051;
    /**
     *
     *
     * <pre>
     * 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
     * </pre>
     *
     * <code>CLIENT_IP_NO_DESTINATION = 106122516;</code>
     */
    public static final int CLIENT_IP_NO_DESTINATION_VALUE = 106122516;
    /**
     *
     *
     * <pre>
     * 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
     * </pre>
     *
     * <code>CLIENT_IP_PORT_PROTO = 221722926;</code>
     */
    public static final int CLIENT_IP_PORT_PROTO_VALUE = 221722926;
    /**
     *
     *
     * <pre>
     * 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
     * </pre>
     *
     * <code>CLIENT_IP_PROTO = 25322148;</code>
     */
    public static final int CLIENT_IP_PROTO_VALUE = 25322148;
    /**
     *
     *
     * <pre>
     * Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
     * </pre>
     *
     * <code>GENERATED_COOKIE = 370321204;</code>
     */
    public static final int GENERATED_COOKIE_VALUE = 370321204;
    /**
     *
     *
     * <pre>
     * The hash is based on a user specified header field.
     * </pre>
     *
     * <code>HEADER_FIELD = 200737960;</code>
     */
    public static final int HEADER_FIELD_VALUE = 200737960;
    /**
     *
     *
     * <pre>
     * The hash is based on a user provided cookie.
     * </pre>
     *
     * <code>HTTP_COOKIE = 494981627;</code>
     */
    public static final int HTTP_COOKIE_VALUE = 494981627;
    /**
     *
     *
     * <pre>
     * No session affinity. Connections from the same client IP may go to any instance in the pool.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SessionAffinity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SessionAffinity forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SESSION_AFFINITY;
        case 345665051:
          return CLIENT_IP;
        case 106122516:
          return CLIENT_IP_NO_DESTINATION;
        case 221722926:
          return CLIENT_IP_PORT_PROTO;
        case 25322148:
          return CLIENT_IP_PROTO;
        case 370321204:
          return GENERATED_COOKIE;
        case 200737960:
          return HEADER_FIELD;
        case 494981627:
          return HTTP_COOKIE;
        case 2402104:
          return NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SessionAffinity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SessionAffinity>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SessionAffinity>() {
              public SessionAffinity findValueByNumber(int number) {
                return SessionAffinity.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendService.getDescriptor().getEnumTypes().get(4);
    }

    private static final SessionAffinity[] VALUES = values();

    public static SessionAffinity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SessionAffinity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendService.SessionAffinity)
  }

  private int bitField0_;
  private int bitField1_;
  public static final int AFFINITY_COOKIE_TTL_SEC_FIELD_NUMBER = 369996954;
  private int affinityCookieTtlSec_ = 0;
  /**
   *
   *
   * <pre>
   * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
   *
   * @return Whether the affinityCookieTtlSec field is set.
   */
  @java.lang.Override
  public boolean hasAffinityCookieTtlSec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
   *
   * @return The affinityCookieTtlSec.
   */
  @java.lang.Override
  public int getAffinityCookieTtlSec() {
    return affinityCookieTtlSec_;
  }

  public static final int BACKENDS_FIELD_NUMBER = 510839903;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Backend> backends_;
  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Backend> getBackendsList() {
    return backends_;
  }
  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.BackendOrBuilder>
      getBackendsOrBuilderList() {
    return backends_;
  }
  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  @java.lang.Override
  public int getBackendsCount() {
    return backends_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Backend getBackends(int index) {
    return backends_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendOrBuilder getBackendsOrBuilder(int index) {
    return backends_.get(index);
  }

  public static final int CDN_POLICY_FIELD_NUMBER = 213976452;
  private com.google.cloud.compute.v1.BackendServiceCdnPolicy cdnPolicy_;
  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
   *
   * @return Whether the cdnPolicy field is set.
   */
  @java.lang.Override
  public boolean hasCdnPolicy() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
   *
   * @return The cdnPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceCdnPolicy getCdnPolicy() {
    return cdnPolicy_ == null
        ? com.google.cloud.compute.v1.BackendServiceCdnPolicy.getDefaultInstance()
        : cdnPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceCdnPolicyOrBuilder getCdnPolicyOrBuilder() {
    return cdnPolicy_ == null
        ? com.google.cloud.compute.v1.BackendServiceCdnPolicy.getDefaultInstance()
        : cdnPolicy_;
  }

  public static final int CIRCUIT_BREAKERS_FIELD_NUMBER = 421340061;
  private com.google.cloud.compute.v1.CircuitBreakers circuitBreakers_;
  /**
   * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
   *
   * @return Whether the circuitBreakers field is set.
   */
  @java.lang.Override
  public boolean hasCircuitBreakers() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
   *
   * @return The circuitBreakers.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CircuitBreakers getCircuitBreakers() {
    return circuitBreakers_ == null
        ? com.google.cloud.compute.v1.CircuitBreakers.getDefaultInstance()
        : circuitBreakers_;
  }
  /**
   * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CircuitBreakersOrBuilder getCircuitBreakersOrBuilder() {
    return circuitBreakers_ == null
        ? com.google.cloud.compute.v1.CircuitBreakers.getDefaultInstance()
        : circuitBreakers_;
  }

  public static final int COMPRESSION_MODE_FIELD_NUMBER = 95520988;

  @SuppressWarnings("serial")
  private volatile java.lang.Object compressionMode_ = "";
  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return Whether the compressionMode field is set.
   */
  @java.lang.Override
  public boolean hasCompressionMode() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return The compressionMode.
   */
  @java.lang.Override
  public java.lang.String getCompressionMode() {
    java.lang.Object ref = compressionMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      compressionMode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return The bytes for compressionMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCompressionModeBytes() {
    java.lang.Object ref = compressionMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      compressionMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECTION_DRAINING_FIELD_NUMBER = 461096747;
  private com.google.cloud.compute.v1.ConnectionDraining connectionDraining_;
  /**
   * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
   * </code>
   *
   * @return Whether the connectionDraining field is set.
   */
  @java.lang.Override
  public boolean hasConnectionDraining() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
   * </code>
   *
   * @return The connectionDraining.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConnectionDraining getConnectionDraining() {
    return connectionDraining_ == null
        ? com.google.cloud.compute.v1.ConnectionDraining.getDefaultInstance()
        : connectionDraining_;
  }
  /**
   * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConnectionDrainingOrBuilder getConnectionDrainingOrBuilder() {
    return connectionDraining_ == null
        ? com.google.cloud.compute.v1.ConnectionDraining.getDefaultInstance()
        : connectionDraining_;
  }

  public static final int CONNECTION_TRACKING_POLICY_FIELD_NUMBER = 143994969;
  private com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      connectionTrackingPolicy_;
  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
   * </code>
   *
   * @return Whether the connectionTrackingPolicy field is set.
   */
  @java.lang.Override
  public boolean hasConnectionTrackingPolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
   * </code>
   *
   * @return The connectionTrackingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      getConnectionTrackingPolicy() {
    return connectionTrackingPolicy_ == null
        ? com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.getDefaultInstance()
        : connectionTrackingPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder
      getConnectionTrackingPolicyOrBuilder() {
    return connectionTrackingPolicy_ == null
        ? com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.getDefaultInstance()
        : connectionTrackingPolicy_;
  }

  public static final int CONSISTENT_HASH_FIELD_NUMBER = 905883;
  private com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistentHash_;
  /**
   *
   *
   * <pre>
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
   * </code>
   *
   * @return Whether the consistentHash field is set.
   */
  @java.lang.Override
  public boolean hasConsistentHash() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
   * </code>
   *
   * @return The consistentHash.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings getConsistentHash() {
    return consistentHash_ == null
        ? com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.getDefaultInstance()
        : consistentHash_;
  }
  /**
   *
   *
   * <pre>
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettingsOrBuilder
      getConsistentHashOrBuilder() {
    return consistentHash_ == null
        ? com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.getDefaultInstance()
        : consistentHash_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_REQUEST_HEADERS_FIELD_NUMBER = 27977992;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList customRequestHeaders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @return A list containing the customRequestHeaders.
   */
  public com.google.protobuf.ProtocolStringList getCustomRequestHeadersList() {
    return customRequestHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @return The count of customRequestHeaders.
   */
  public int getCustomRequestHeadersCount() {
    return customRequestHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @param index The index of the element to return.
   * @return The customRequestHeaders at the given index.
   */
  public java.lang.String getCustomRequestHeaders(int index) {
    return customRequestHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customRequestHeaders at the given index.
   */
  public com.google.protobuf.ByteString getCustomRequestHeadersBytes(int index) {
    return customRequestHeaders_.getByteString(index);
  }

  public static final int CUSTOM_RESPONSE_HEADERS_FIELD_NUMBER = 387539094;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList customResponseHeaders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @return A list containing the customResponseHeaders.
   */
  public com.google.protobuf.ProtocolStringList getCustomResponseHeadersList() {
    return customResponseHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @return The count of customResponseHeaders.
   */
  public int getCustomResponseHeadersCount() {
    return customResponseHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @param index The index of the element to return.
   * @return The customResponseHeaders at the given index.
   */
  public java.lang.String getCustomResponseHeaders(int index) {
    return customResponseHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customResponseHeaders at the given index.
   */
  public com.google.protobuf.ByteString getCustomResponseHeadersBytes(int index) {
    return customResponseHeaders_.getByteString(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EDGE_SECURITY_POLICY_FIELD_NUMBER = 41036943;

  @SuppressWarnings("serial")
  private volatile java.lang.Object edgeSecurityPolicy_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return Whether the edgeSecurityPolicy field is set.
   */
  @java.lang.Override
  public boolean hasEdgeSecurityPolicy() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return The edgeSecurityPolicy.
   */
  @java.lang.Override
  public java.lang.String getEdgeSecurityPolicy() {
    java.lang.Object ref = edgeSecurityPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      edgeSecurityPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return The bytes for edgeSecurityPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEdgeSecurityPolicyBytes() {
    java.lang.Object ref = edgeSecurityPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      edgeSecurityPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_C_D_N_FIELD_NUMBER = 250733499;
  private boolean enableCDN_ = false;
  /**
   *
   *
   * <pre>
   * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
   * </pre>
   *
   * <code>optional bool enable_c_d_n = 250733499;</code>
   *
   * @return Whether the enableCDN field is set.
   */
  @java.lang.Override
  public boolean hasEnableCDN() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
   * </pre>
   *
   * <code>optional bool enable_c_d_n = 250733499;</code>
   *
   * @return The enableCDN.
   */
  @java.lang.Override
  public boolean getEnableCDN() {
    return enableCDN_;
  }

  public static final int FAILOVER_POLICY_FIELD_NUMBER = 105658655;
  private com.google.cloud.compute.v1.BackendServiceFailoverPolicy failoverPolicy_;
  /**
   *
   *
   * <pre>
   * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
   * </code>
   *
   * @return Whether the failoverPolicy field is set.
   */
  @java.lang.Override
  public boolean hasFailoverPolicy() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
   * </code>
   *
   * @return The failoverPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceFailoverPolicy getFailoverPolicy() {
    return failoverPolicy_ == null
        ? com.google.cloud.compute.v1.BackendServiceFailoverPolicy.getDefaultInstance()
        : failoverPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceFailoverPolicyOrBuilder
      getFailoverPolicyOrBuilder() {
    return failoverPolicy_ == null
        ? com.google.cloud.compute.v1.BackendServiceFailoverPolicy.getDefaultInstance()
        : failoverPolicy_;
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_CHECKS_FIELD_NUMBER = 448370606;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList healthChecks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @return A list containing the healthChecks.
   */
  public com.google.protobuf.ProtocolStringList getHealthChecksList() {
    return healthChecks_;
  }
  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @return The count of healthChecks.
   */
  public int getHealthChecksCount() {
    return healthChecks_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @param index The index of the element to return.
   * @return The healthChecks at the given index.
   */
  public java.lang.String getHealthChecks(int index) {
    return healthChecks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the healthChecks at the given index.
   */
  public com.google.protobuf.ByteString getHealthChecksBytes(int index) {
    return healthChecks_.getByteString(index);
  }

  public static final int IAP_FIELD_NUMBER = 104024;
  private com.google.cloud.compute.v1.BackendServiceIAP iap_;
  /**
   *
   *
   * <pre>
   * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
   *
   * @return Whether the iap field is set.
   */
  @java.lang.Override
  public boolean hasIap() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
   *
   * @return The iap.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceIAP getIap() {
    return iap_ == null ? com.google.cloud.compute.v1.BackendServiceIAP.getDefaultInstance() : iap_;
  }
  /**
   *
   *
   * <pre>
   * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceIAPOrBuilder getIapOrBuilder() {
    return iap_ == null ? com.google.cloud.compute.v1.BackendServiceIAP.getDefaultInstance() : iap_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOAD_BALANCING_SCHEME_FIELD_NUMBER = 363890244;

  @SuppressWarnings("serial")
  private volatile java.lang.Object loadBalancingScheme_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return Whether the loadBalancingScheme field is set.
   */
  @java.lang.Override
  public boolean hasLoadBalancingScheme() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return The loadBalancingScheme.
   */
  @java.lang.Override
  public java.lang.String getLoadBalancingScheme() {
    java.lang.Object ref = loadBalancingScheme_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      loadBalancingScheme_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return The bytes for loadBalancingScheme.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLoadBalancingSchemeBytes() {
    java.lang.Object ref = loadBalancingScheme_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      loadBalancingScheme_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCALITY_LB_POLICIES_FIELD_NUMBER = 140982557;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>
      localityLbPolicies_;
  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>
      getLocalityLbPoliciesList() {
    return localityLbPolicies_;
  }
  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder>
      getLocalityLbPoliciesOrBuilderList() {
    return localityLbPolicies_;
  }
  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  @java.lang.Override
  public int getLocalityLbPoliciesCount() {
    return localityLbPolicies_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig
      getLocalityLbPolicies(int index) {
    return localityLbPolicies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder
      getLocalityLbPoliciesOrBuilder(int index) {
    return localityLbPolicies_.get(index);
  }

  public static final int LOCALITY_LB_POLICY_FIELD_NUMBER = 131431487;

  @SuppressWarnings("serial")
  private volatile java.lang.Object localityLbPolicy_ = "";
  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * Check the LocalityLbPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string locality_lb_policy = 131431487;</code>
   *
   * @return Whether the localityLbPolicy field is set.
   */
  @java.lang.Override
  public boolean hasLocalityLbPolicy() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * Check the LocalityLbPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string locality_lb_policy = 131431487;</code>
   *
   * @return The localityLbPolicy.
   */
  @java.lang.Override
  public java.lang.String getLocalityLbPolicy() {
    java.lang.Object ref = localityLbPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      localityLbPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * Check the LocalityLbPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string locality_lb_policy = 131431487;</code>
   *
   * @return The bytes for localityLbPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocalityLbPolicyBytes() {
    java.lang.Object ref = localityLbPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      localityLbPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_CONFIG_FIELD_NUMBER = 351299741;
  private com.google.cloud.compute.v1.BackendServiceLogConfig logConfig_;
  /**
   *
   *
   * <pre>
   * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
   *
   * @return Whether the logConfig field is set.
   */
  @java.lang.Override
  public boolean hasLogConfig() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
   *
   * @return The logConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceLogConfig getLogConfig() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.BackendServiceLogConfig.getDefaultInstance()
        : logConfig_;
  }
  /**
   *
   *
   * <pre>
   * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceLogConfigOrBuilder getLogConfigOrBuilder() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.BackendServiceLogConfig.getDefaultInstance()
        : logConfig_;
  }

  public static final int MAX_STREAM_DURATION_FIELD_NUMBER = 61428376;
  private com.google.cloud.compute.v1.Duration maxStreamDuration_;
  /**
   *
   *
   * <pre>
   * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   *
   * @return Whether the maxStreamDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxStreamDuration() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   *
   * @return The maxStreamDuration.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getMaxStreamDuration() {
    return maxStreamDuration_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : maxStreamDuration_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getMaxStreamDurationOrBuilder() {
    return maxStreamDuration_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : maxStreamDuration_;
  }

  public static final int METADATAS_FIELD_NUMBER = 8514340;

  private static final class MetadatasDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_BackendService_MetadatasEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadatas_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadatas() {
    if (metadatas_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadatasDefaultEntryHolder.defaultEntry);
    }
    return metadatas_;
  }

  public int getMetadatasCount() {
    return internalGetMetadatas().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  @java.lang.Override
  public boolean containsMetadatas(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadatas().getMap().containsKey(key);
  }
  /** Use {@link #getMetadatasMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadatas() {
    return getMetadatasMap();
  }
  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadatasMap() {
    return internalGetMetadatas().getMap();
  }
  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadatasOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadatas().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadatasOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadatas().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTLIER_DETECTION_FIELD_NUMBER = 354625086;
  private com.google.cloud.compute.v1.OutlierDetection outlierDetection_;
  /**
   *
   *
   * <pre>
   * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
   *
   * @return Whether the outlierDetection field is set.
   */
  @java.lang.Override
  public boolean hasOutlierDetection() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
   *
   * @return The outlierDetection.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.OutlierDetection getOutlierDetection() {
    return outlierDetection_ == null
        ? com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance()
        : outlierDetection_;
  }
  /**
   *
   *
   * <pre>
   * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.OutlierDetectionOrBuilder getOutlierDetectionOrBuilder() {
    return outlierDetection_ == null
        ? com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance()
        : outlierDetection_;
  }

  public static final int PORT_FIELD_NUMBER = 3446913;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return Whether the port field is set.
   */
  @java.lang.Override
  public boolean hasPort() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int PORT_NAME_FIELD_NUMBER = 41534345;

  @SuppressWarnings("serial")
  private volatile java.lang.Object portName_ = "";
  /**
   *
   *
   * <pre>
   * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return Whether the portName field is set.
   */
  @java.lang.Override
  public boolean hasPortName() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return The portName.
   */
  @java.lang.Override
  public java.lang.String getPortName() {
    java.lang.Object ref = portName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      portName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return The bytes for portName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPortNameBytes() {
    java.lang.Object ref = portName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      portName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTOCOL_FIELD_NUMBER = 84577944;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protocol_ = "";
  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * Check the Protocol enum for the list of possible values.
   * </pre>
   *
   * <code>optional string protocol = 84577944;</code>
   *
   * @return Whether the protocol field is set.
   */
  @java.lang.Override
  public boolean hasProtocol() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * Check the Protocol enum for the list of possible values.
   * </pre>
   *
   * <code>optional string protocol = 84577944;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * Check the Protocol enum for the list of possible values.
   * </pre>
   *
   * <code>optional string protocol = 84577944;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_POLICY_FIELD_NUMBER = 171082513;

  @SuppressWarnings("serial")
  private volatile java.lang.Object securityPolicy_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return Whether the securityPolicy field is set.
   */
  @java.lang.Override
  public boolean hasSecurityPolicy() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return The securityPolicy.
   */
  @java.lang.Override
  public java.lang.String getSecurityPolicy() {
    java.lang.Object ref = securityPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      securityPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return The bytes for securityPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecurityPolicyBytes() {
    java.lang.Object ref = securityPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      securityPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_SETTINGS_FIELD_NUMBER = 478649922;
  private com.google.cloud.compute.v1.SecuritySettings securitySettings_;
  /**
   *
   *
   * <pre>
   * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
   *
   * @return Whether the securitySettings field is set.
   */
  @java.lang.Override
  public boolean hasSecuritySettings() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
   *
   * @return The securitySettings.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecuritySettings getSecuritySettings() {
    return securitySettings_ == null
        ? com.google.cloud.compute.v1.SecuritySettings.getDefaultInstance()
        : securitySettings_;
  }
  /**
   *
   *
   * <pre>
   * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecuritySettingsOrBuilder getSecuritySettingsOrBuilder() {
    return securitySettings_ == null
        ? com.google.cloud.compute.v1.SecuritySettings.getDefaultInstance()
        : securitySettings_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_BINDINGS_FIELD_NUMBER = 133581016;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serviceBindings_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @return A list containing the serviceBindings.
   */
  public com.google.protobuf.ProtocolStringList getServiceBindingsList() {
    return serviceBindings_;
  }
  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @return The count of serviceBindings.
   */
  public int getServiceBindingsCount() {
    return serviceBindings_.size();
  }
  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @param index The index of the element to return.
   * @return The serviceBindings at the given index.
   */
  public java.lang.String getServiceBindings(int index) {
    return serviceBindings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceBindings at the given index.
   */
  public com.google.protobuf.ByteString getServiceBindingsBytes(int index) {
    return serviceBindings_.getByteString(index);
  }

  public static final int SERVICE_LB_POLICY_FIELD_NUMBER = 94848785;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceLbPolicy_ = "";
  /**
   *
   *
   * <pre>
   * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
   * </pre>
   *
   * <code>optional string service_lb_policy = 94848785;</code>
   *
   * @return Whether the serviceLbPolicy field is set.
   */
  @java.lang.Override
  public boolean hasServiceLbPolicy() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
   * </pre>
   *
   * <code>optional string service_lb_policy = 94848785;</code>
   *
   * @return The serviceLbPolicy.
   */
  @java.lang.Override
  public java.lang.String getServiceLbPolicy() {
    java.lang.Object ref = serviceLbPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceLbPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
   * </pre>
   *
   * <code>optional string service_lb_policy = 94848785;</code>
   *
   * @return The bytes for serviceLbPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceLbPolicyBytes() {
    java.lang.Object ref = serviceLbPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceLbPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SESSION_AFFINITY_FIELD_NUMBER = 463888561;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sessionAffinity_ = "";
  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
   * Check the SessionAffinity enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_affinity = 463888561;</code>
   *
   * @return Whether the sessionAffinity field is set.
   */
  @java.lang.Override
  public boolean hasSessionAffinity() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
   * Check the SessionAffinity enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_affinity = 463888561;</code>
   *
   * @return The sessionAffinity.
   */
  @java.lang.Override
  public java.lang.String getSessionAffinity() {
    java.lang.Object ref = sessionAffinity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionAffinity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
   * Check the SessionAffinity enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_affinity = 463888561;</code>
   *
   * @return The bytes for sessionAffinity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionAffinityBytes() {
    java.lang.Object ref = sessionAffinity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionAffinity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBSETTING_FIELD_NUMBER = 450283536;
  private com.google.cloud.compute.v1.Subsetting subsetting_;
  /**
   * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
   *
   * @return Whether the subsetting field is set.
   */
  @java.lang.Override
  public boolean hasSubsetting() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
   *
   * @return The subsetting.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Subsetting getSubsetting() {
    return subsetting_ == null
        ? com.google.cloud.compute.v1.Subsetting.getDefaultInstance()
        : subsetting_;
  }
  /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.SubsettingOrBuilder getSubsettingOrBuilder() {
    return subsetting_ == null
        ? com.google.cloud.compute.v1.Subsetting.getDefaultInstance()
        : subsetting_;
  }

  public static final int TIMEOUT_SEC_FIELD_NUMBER = 79994995;
  private int timeoutSec_ = 0;
  /**
   *
   *
   * <pre>
   * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
   * </pre>
   *
   * <code>optional int32 timeout_sec = 79994995;</code>
   *
   * @return Whether the timeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasTimeoutSec() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
   * </pre>
   *
   * <code>optional int32 timeout_sec = 79994995;</code>
   *
   * @return The timeoutSec.
   */
  @java.lang.Override
  public int getTimeoutSec() {
    return timeoutSec_;
  }

  public static final int USED_BY_FIELD_NUMBER = 389320729;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.BackendServiceUsedBy> usedBy_;
  /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.BackendServiceUsedBy> getUsedByList() {
    return usedBy_;
  }
  /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder>
      getUsedByOrBuilderList() {
    return usedBy_;
  }
  /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
  @java.lang.Override
  public int getUsedByCount() {
    return usedBy_.size();
  }
  /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceUsedBy getUsedBy(int index) {
    return usedBy_.get(index);
  }
  /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder getUsedByOrBuilder(int index) {
    return usedBy_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(104024, getIap());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(905883, getConsistentHash());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeInt32(3446913, port_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadatas(), MetadatasDefaultEntryHolder.defaultEntry, 8514340);
    for (int i = 0; i < customRequestHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 27977992, customRequestHeaders_.getRaw(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 41036943, edgeSecurityPolicy_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 41534345, portName_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeMessage(61428376, getMaxStreamDuration());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeInt32(79994995, timeoutSec_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 84577944, protocol_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 94848785, serviceLbPolicy_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 95520988, compressionMode_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(105658655, getFailoverPolicy());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 131431487, localityLbPolicy_);
    }
    for (int i = 0; i < serviceBindings_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 133581016, serviceBindings_.getRaw(i));
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    for (int i = 0; i < localityLbPolicies_.size(); i++) {
      output.writeMessage(140982557, localityLbPolicies_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(143994969, getConnectionTrackingPolicy());
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 171082513, securityPolicy_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(213976452, getCdnPolicy());
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(250733499, enableCDN_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeMessage(354625086, getOutlierDetection());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 363890244, loadBalancingScheme_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(369996954, affinityCookieTtlSec_);
    }
    for (int i = 0; i < customResponseHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 387539094, customResponseHeaders_.getRaw(i));
    }
    for (int i = 0; i < usedBy_.size(); i++) {
      output.writeMessage(389320729, usedBy_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(421340061, getCircuitBreakers());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < healthChecks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 448370606, healthChecks_.getRaw(i));
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeMessage(450283536, getSubsetting());
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(461096747, getConnectionDraining());
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 463888561, sessionAffinity_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      output.writeMessage(478649922, getSecuritySettings());
    }
    for (int i = 0; i < backends_.size(); i++) {
      output.writeMessage(510839903, backends_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(104024, getIap());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(905883, getConsistentHash());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3446913, port_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadatas().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadatas__ =
          MetadatasDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8514340, metadatas__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < customRequestHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(customRequestHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getCustomRequestHeadersList().size();
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(41036943, edgeSecurityPolicy_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(41534345, portName_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              61428376, getMaxStreamDuration());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(79994995, timeoutSec_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(84577944, protocol_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(94848785, serviceLbPolicy_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(95520988, compressionMode_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(105658655, getFailoverPolicy());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(131431487, localityLbPolicy_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serviceBindings_.size(); i++) {
        dataSize += computeStringSizeNoTag(serviceBindings_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getServiceBindingsList().size();
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    for (int i = 0; i < localityLbPolicies_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              140982557, localityLbPolicies_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              143994969, getConnectionTrackingPolicy());
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(171082513, securityPolicy_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(213976452, getCdnPolicy());
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(250733499, enableCDN_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              354625086, getOutlierDetection());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(363890244, loadBalancingScheme_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(369996954, affinityCookieTtlSec_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < customResponseHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(customResponseHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getCustomResponseHeadersList().size();
    }
    for (int i = 0; i < usedBy_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(389320729, usedBy_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(421340061, getCircuitBreakers());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < healthChecks_.size(); i++) {
        dataSize += computeStringSizeNoTag(healthChecks_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getHealthChecksList().size();
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(450283536, getSubsetting());
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              461096747, getConnectionDraining());
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(463888561, sessionAffinity_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              478649922, getSecuritySettings());
    }
    for (int i = 0; i < backends_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(510839903, backends_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BackendService)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BackendService other =
        (com.google.cloud.compute.v1.BackendService) obj;

    if (hasAffinityCookieTtlSec() != other.hasAffinityCookieTtlSec()) return false;
    if (hasAffinityCookieTtlSec()) {
      if (getAffinityCookieTtlSec() != other.getAffinityCookieTtlSec()) return false;
    }
    if (!getBackendsList().equals(other.getBackendsList())) return false;
    if (hasCdnPolicy() != other.hasCdnPolicy()) return false;
    if (hasCdnPolicy()) {
      if (!getCdnPolicy().equals(other.getCdnPolicy())) return false;
    }
    if (hasCircuitBreakers() != other.hasCircuitBreakers()) return false;
    if (hasCircuitBreakers()) {
      if (!getCircuitBreakers().equals(other.getCircuitBreakers())) return false;
    }
    if (hasCompressionMode() != other.hasCompressionMode()) return false;
    if (hasCompressionMode()) {
      if (!getCompressionMode().equals(other.getCompressionMode())) return false;
    }
    if (hasConnectionDraining() != other.hasConnectionDraining()) return false;
    if (hasConnectionDraining()) {
      if (!getConnectionDraining().equals(other.getConnectionDraining())) return false;
    }
    if (hasConnectionTrackingPolicy() != other.hasConnectionTrackingPolicy()) return false;
    if (hasConnectionTrackingPolicy()) {
      if (!getConnectionTrackingPolicy().equals(other.getConnectionTrackingPolicy())) return false;
    }
    if (hasConsistentHash() != other.hasConsistentHash()) return false;
    if (hasConsistentHash()) {
      if (!getConsistentHash().equals(other.getConsistentHash())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (!getCustomRequestHeadersList().equals(other.getCustomRequestHeadersList())) return false;
    if (!getCustomResponseHeadersList().equals(other.getCustomResponseHeadersList())) return false;
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEdgeSecurityPolicy() != other.hasEdgeSecurityPolicy()) return false;
    if (hasEdgeSecurityPolicy()) {
      if (!getEdgeSecurityPolicy().equals(other.getEdgeSecurityPolicy())) return false;
    }
    if (hasEnableCDN() != other.hasEnableCDN()) return false;
    if (hasEnableCDN()) {
      if (getEnableCDN() != other.getEnableCDN()) return false;
    }
    if (hasFailoverPolicy() != other.hasFailoverPolicy()) return false;
    if (hasFailoverPolicy()) {
      if (!getFailoverPolicy().equals(other.getFailoverPolicy())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (!getHealthChecksList().equals(other.getHealthChecksList())) return false;
    if (hasIap() != other.hasIap()) return false;
    if (hasIap()) {
      if (!getIap().equals(other.getIap())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLoadBalancingScheme() != other.hasLoadBalancingScheme()) return false;
    if (hasLoadBalancingScheme()) {
      if (!getLoadBalancingScheme().equals(other.getLoadBalancingScheme())) return false;
    }
    if (!getLocalityLbPoliciesList().equals(other.getLocalityLbPoliciesList())) return false;
    if (hasLocalityLbPolicy() != other.hasLocalityLbPolicy()) return false;
    if (hasLocalityLbPolicy()) {
      if (!getLocalityLbPolicy().equals(other.getLocalityLbPolicy())) return false;
    }
    if (hasLogConfig() != other.hasLogConfig()) return false;
    if (hasLogConfig()) {
      if (!getLogConfig().equals(other.getLogConfig())) return false;
    }
    if (hasMaxStreamDuration() != other.hasMaxStreamDuration()) return false;
    if (hasMaxStreamDuration()) {
      if (!getMaxStreamDuration().equals(other.getMaxStreamDuration())) return false;
    }
    if (!internalGetMetadatas().equals(other.internalGetMetadatas())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasOutlierDetection() != other.hasOutlierDetection()) return false;
    if (hasOutlierDetection()) {
      if (!getOutlierDetection().equals(other.getOutlierDetection())) return false;
    }
    if (hasPort() != other.hasPort()) return false;
    if (hasPort()) {
      if (getPort() != other.getPort()) return false;
    }
    if (hasPortName() != other.hasPortName()) return false;
    if (hasPortName()) {
      if (!getPortName().equals(other.getPortName())) return false;
    }
    if (hasProtocol() != other.hasProtocol()) return false;
    if (hasProtocol()) {
      if (!getProtocol().equals(other.getProtocol())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSecurityPolicy() != other.hasSecurityPolicy()) return false;
    if (hasSecurityPolicy()) {
      if (!getSecurityPolicy().equals(other.getSecurityPolicy())) return false;
    }
    if (hasSecuritySettings() != other.hasSecuritySettings()) return false;
    if (hasSecuritySettings()) {
      if (!getSecuritySettings().equals(other.getSecuritySettings())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getServiceBindingsList().equals(other.getServiceBindingsList())) return false;
    if (hasServiceLbPolicy() != other.hasServiceLbPolicy()) return false;
    if (hasServiceLbPolicy()) {
      if (!getServiceLbPolicy().equals(other.getServiceLbPolicy())) return false;
    }
    if (hasSessionAffinity() != other.hasSessionAffinity()) return false;
    if (hasSessionAffinity()) {
      if (!getSessionAffinity().equals(other.getSessionAffinity())) return false;
    }
    if (hasSubsetting() != other.hasSubsetting()) return false;
    if (hasSubsetting()) {
      if (!getSubsetting().equals(other.getSubsetting())) return false;
    }
    if (hasTimeoutSec() != other.hasTimeoutSec()) return false;
    if (hasTimeoutSec()) {
      if (getTimeoutSec() != other.getTimeoutSec()) return false;
    }
    if (!getUsedByList().equals(other.getUsedByList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAffinityCookieTtlSec()) {
      hash = (37 * hash) + AFFINITY_COOKIE_TTL_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getAffinityCookieTtlSec();
    }
    if (getBackendsCount() > 0) {
      hash = (37 * hash) + BACKENDS_FIELD_NUMBER;
      hash = (53 * hash) + getBackendsList().hashCode();
    }
    if (hasCdnPolicy()) {
      hash = (37 * hash) + CDN_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getCdnPolicy().hashCode();
    }
    if (hasCircuitBreakers()) {
      hash = (37 * hash) + CIRCUIT_BREAKERS_FIELD_NUMBER;
      hash = (53 * hash) + getCircuitBreakers().hashCode();
    }
    if (hasCompressionMode()) {
      hash = (37 * hash) + COMPRESSION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getCompressionMode().hashCode();
    }
    if (hasConnectionDraining()) {
      hash = (37 * hash) + CONNECTION_DRAINING_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionDraining().hashCode();
    }
    if (hasConnectionTrackingPolicy()) {
      hash = (37 * hash) + CONNECTION_TRACKING_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionTrackingPolicy().hashCode();
    }
    if (hasConsistentHash()) {
      hash = (37 * hash) + CONSISTENT_HASH_FIELD_NUMBER;
      hash = (53 * hash) + getConsistentHash().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (getCustomRequestHeadersCount() > 0) {
      hash = (37 * hash) + CUSTOM_REQUEST_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomRequestHeadersList().hashCode();
    }
    if (getCustomResponseHeadersCount() > 0) {
      hash = (37 * hash) + CUSTOM_RESPONSE_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomResponseHeadersList().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEdgeSecurityPolicy()) {
      hash = (37 * hash) + EDGE_SECURITY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getEdgeSecurityPolicy().hashCode();
    }
    if (hasEnableCDN()) {
      hash = (37 * hash) + ENABLE_C_D_N_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableCDN());
    }
    if (hasFailoverPolicy()) {
      hash = (37 * hash) + FAILOVER_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getFailoverPolicy().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (getHealthChecksCount() > 0) {
      hash = (37 * hash) + HEALTH_CHECKS_FIELD_NUMBER;
      hash = (53 * hash) + getHealthChecksList().hashCode();
    }
    if (hasIap()) {
      hash = (37 * hash) + IAP_FIELD_NUMBER;
      hash = (53 * hash) + getIap().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLoadBalancingScheme()) {
      hash = (37 * hash) + LOAD_BALANCING_SCHEME_FIELD_NUMBER;
      hash = (53 * hash) + getLoadBalancingScheme().hashCode();
    }
    if (getLocalityLbPoliciesCount() > 0) {
      hash = (37 * hash) + LOCALITY_LB_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getLocalityLbPoliciesList().hashCode();
    }
    if (hasLocalityLbPolicy()) {
      hash = (37 * hash) + LOCALITY_LB_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getLocalityLbPolicy().hashCode();
    }
    if (hasLogConfig()) {
      hash = (37 * hash) + LOG_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLogConfig().hashCode();
    }
    if (hasMaxStreamDuration()) {
      hash = (37 * hash) + MAX_STREAM_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxStreamDuration().hashCode();
    }
    if (!internalGetMetadatas().getMap().isEmpty()) {
      hash = (37 * hash) + METADATAS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadatas().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasOutlierDetection()) {
      hash = (37 * hash) + OUTLIER_DETECTION_FIELD_NUMBER;
      hash = (53 * hash) + getOutlierDetection().hashCode();
    }
    if (hasPort()) {
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
    }
    if (hasPortName()) {
      hash = (37 * hash) + PORT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPortName().hashCode();
    }
    if (hasProtocol()) {
      hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + getProtocol().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSecurityPolicy()) {
      hash = (37 * hash) + SECURITY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityPolicy().hashCode();
    }
    if (hasSecuritySettings()) {
      hash = (37 * hash) + SECURITY_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSecuritySettings().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getServiceBindingsCount() > 0) {
      hash = (37 * hash) + SERVICE_BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceBindingsList().hashCode();
    }
    if (hasServiceLbPolicy()) {
      hash = (37 * hash) + SERVICE_LB_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getServiceLbPolicy().hashCode();
    }
    if (hasSessionAffinity()) {
      hash = (37 * hash) + SESSION_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getSessionAffinity().hashCode();
    }
    if (hasSubsetting()) {
      hash = (37 * hash) + SUBSETTING_FIELD_NUMBER;
      hash = (53 * hash) + getSubsetting().hashCode();
    }
    if (hasTimeoutSec()) {
      hash = (37 * hash) + TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getTimeoutSec();
    }
    if (getUsedByCount() > 0) {
      hash = (37 * hash) + USED_BY_FIELD_NUMBER;
      hash = (53 * hash) + getUsedByList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendService parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendService parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendService parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.BackendService prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Backend Service resource. A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly. Backend services in Google Compute Engine can be either regionally or globally scoped. * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices) For more information, see Backend Services.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BackendService}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BackendService)
      com.google.cloud.compute.v1.BackendServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendService_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8514340:
          return internalGetMetadatas();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8514340:
          return internalGetMutableMetadatas();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BackendService.class,
              com.google.cloud.compute.v1.BackendService.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BackendService.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBackendsFieldBuilder();
        getCdnPolicyFieldBuilder();
        getCircuitBreakersFieldBuilder();
        getConnectionDrainingFieldBuilder();
        getConnectionTrackingPolicyFieldBuilder();
        getConsistentHashFieldBuilder();
        getFailoverPolicyFieldBuilder();
        getIapFieldBuilder();
        getLocalityLbPoliciesFieldBuilder();
        getLogConfigFieldBuilder();
        getMaxStreamDurationFieldBuilder();
        getOutlierDetectionFieldBuilder();
        getSecuritySettingsFieldBuilder();
        getSubsettingFieldBuilder();
        getUsedByFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      affinityCookieTtlSec_ = 0;
      if (backendsBuilder_ == null) {
        backends_ = java.util.Collections.emptyList();
      } else {
        backends_ = null;
        backendsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      cdnPolicy_ = null;
      if (cdnPolicyBuilder_ != null) {
        cdnPolicyBuilder_.dispose();
        cdnPolicyBuilder_ = null;
      }
      circuitBreakers_ = null;
      if (circuitBreakersBuilder_ != null) {
        circuitBreakersBuilder_.dispose();
        circuitBreakersBuilder_ = null;
      }
      compressionMode_ = "";
      connectionDraining_ = null;
      if (connectionDrainingBuilder_ != null) {
        connectionDrainingBuilder_.dispose();
        connectionDrainingBuilder_ = null;
      }
      connectionTrackingPolicy_ = null;
      if (connectionTrackingPolicyBuilder_ != null) {
        connectionTrackingPolicyBuilder_.dispose();
        connectionTrackingPolicyBuilder_ = null;
      }
      consistentHash_ = null;
      if (consistentHashBuilder_ != null) {
        consistentHashBuilder_.dispose();
        consistentHashBuilder_ = null;
      }
      creationTimestamp_ = "";
      customRequestHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      customResponseHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      description_ = "";
      edgeSecurityPolicy_ = "";
      enableCDN_ = false;
      failoverPolicy_ = null;
      if (failoverPolicyBuilder_ != null) {
        failoverPolicyBuilder_.dispose();
        failoverPolicyBuilder_ = null;
      }
      fingerprint_ = "";
      healthChecks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      iap_ = null;
      if (iapBuilder_ != null) {
        iapBuilder_.dispose();
        iapBuilder_ = null;
      }
      id_ = 0L;
      kind_ = "";
      loadBalancingScheme_ = "";
      if (localityLbPoliciesBuilder_ == null) {
        localityLbPolicies_ = java.util.Collections.emptyList();
      } else {
        localityLbPolicies_ = null;
        localityLbPoliciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      localityLbPolicy_ = "";
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      maxStreamDuration_ = null;
      if (maxStreamDurationBuilder_ != null) {
        maxStreamDurationBuilder_.dispose();
        maxStreamDurationBuilder_ = null;
      }
      internalGetMutableMetadatas().clear();
      name_ = "";
      network_ = "";
      outlierDetection_ = null;
      if (outlierDetectionBuilder_ != null) {
        outlierDetectionBuilder_.dispose();
        outlierDetectionBuilder_ = null;
      }
      port_ = 0;
      portName_ = "";
      protocol_ = "";
      region_ = "";
      securityPolicy_ = "";
      securitySettings_ = null;
      if (securitySettingsBuilder_ != null) {
        securitySettingsBuilder_.dispose();
        securitySettingsBuilder_ = null;
      }
      selfLink_ = "";
      serviceBindings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceLbPolicy_ = "";
      sessionAffinity_ = "";
      subsetting_ = null;
      if (subsettingBuilder_ != null) {
        subsettingBuilder_.dispose();
        subsettingBuilder_ = null;
      }
      timeoutSec_ = 0;
      if (usedByBuilder_ == null) {
        usedBy_ = java.util.Collections.emptyList();
      } else {
        usedBy_ = null;
        usedByBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendService_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendService getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BackendService.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendService build() {
      com.google.cloud.compute.v1.BackendService result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendService buildPartial() {
      com.google.cloud.compute.v1.BackendService result =
          new com.google.cloud.compute.v1.BackendService(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.BackendService result) {
      if (backendsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          backends_ = java.util.Collections.unmodifiableList(backends_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.backends_ = backends_;
      } else {
        result.backends_ = backendsBuilder_.build();
      }
      if (localityLbPoliciesBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          localityLbPolicies_ = java.util.Collections.unmodifiableList(localityLbPolicies_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.localityLbPolicies_ = localityLbPolicies_;
      } else {
        result.localityLbPolicies_ = localityLbPoliciesBuilder_.build();
      }
      if (usedByBuilder_ == null) {
        if (((bitField1_ & 0x00000200) != 0)) {
          usedBy_ = java.util.Collections.unmodifiableList(usedBy_);
          bitField1_ = (bitField1_ & ~0x00000200);
        }
        result.usedBy_ = usedBy_;
      } else {
        result.usedBy_ = usedByBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.BackendService result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.affinityCookieTtlSec_ = affinityCookieTtlSec_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cdnPolicy_ = cdnPolicyBuilder_ == null ? cdnPolicy_ : cdnPolicyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.circuitBreakers_ =
            circuitBreakersBuilder_ == null ? circuitBreakers_ : circuitBreakersBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.compressionMode_ = compressionMode_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.connectionDraining_ =
            connectionDrainingBuilder_ == null
                ? connectionDraining_
                : connectionDrainingBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.connectionTrackingPolicy_ =
            connectionTrackingPolicyBuilder_ == null
                ? connectionTrackingPolicy_
                : connectionTrackingPolicyBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.consistentHash_ =
            consistentHashBuilder_ == null ? consistentHash_ : consistentHashBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        customRequestHeaders_.makeImmutable();
        result.customRequestHeaders_ = customRequestHeaders_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        customResponseHeaders_.makeImmutable();
        result.customResponseHeaders_ = customResponseHeaders_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.edgeSecurityPolicy_ = edgeSecurityPolicy_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.enableCDN_ = enableCDN_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.failoverPolicy_ =
            failoverPolicyBuilder_ == null ? failoverPolicy_ : failoverPolicyBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        healthChecks_.makeImmutable();
        result.healthChecks_ = healthChecks_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.iap_ = iapBuilder_ == null ? iap_ : iapBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.loadBalancingScheme_ = loadBalancingScheme_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.localityLbPolicy_ = localityLbPolicy_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.logConfig_ = logConfigBuilder_ == null ? logConfig_ : logConfigBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.maxStreamDuration_ =
            maxStreamDurationBuilder_ == null
                ? maxStreamDuration_
                : maxStreamDurationBuilder_.build();
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.metadatas_ = internalGetMetadatas();
        result.metadatas_.makeImmutable();
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.outlierDetection_ =
            outlierDetectionBuilder_ == null ? outlierDetection_ : outlierDetectionBuilder_.build();
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.port_ = port_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.portName_ = portName_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.protocol_ = protocol_;
        to_bitField0_ |= 0x02000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.compute.v1.BackendService result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.securityPolicy_ = securityPolicy_;
        to_bitField0_ |= 0x08000000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.securitySettings_ =
            securitySettingsBuilder_ == null ? securitySettings_ : securitySettingsBuilder_.build();
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        serviceBindings_.makeImmutable();
        result.serviceBindings_ = serviceBindings_;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.serviceLbPolicy_ = serviceLbPolicy_;
        to_bitField0_ |= 0x40000000;
      }
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.sessionAffinity_ = sessionAffinity_;
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.subsetting_ = subsettingBuilder_ == null ? subsetting_ : subsettingBuilder_.build();
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField1_ & 0x00000100) != 0)) {
        result.timeoutSec_ = timeoutSec_;
        to_bitField1_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BackendService) {
        return mergeFrom((com.google.cloud.compute.v1.BackendService) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BackendService other) {
      if (other == com.google.cloud.compute.v1.BackendService.getDefaultInstance()) return this;
      if (other.hasAffinityCookieTtlSec()) {
        setAffinityCookieTtlSec(other.getAffinityCookieTtlSec());
      }
      if (backendsBuilder_ == null) {
        if (!other.backends_.isEmpty()) {
          if (backends_.isEmpty()) {
            backends_ = other.backends_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBackendsIsMutable();
            backends_.addAll(other.backends_);
          }
          onChanged();
        }
      } else {
        if (!other.backends_.isEmpty()) {
          if (backendsBuilder_.isEmpty()) {
            backendsBuilder_.dispose();
            backendsBuilder_ = null;
            backends_ = other.backends_;
            bitField0_ = (bitField0_ & ~0x00000002);
            backendsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBackendsFieldBuilder()
                    : null;
          } else {
            backendsBuilder_.addAllMessages(other.backends_);
          }
        }
      }
      if (other.hasCdnPolicy()) {
        mergeCdnPolicy(other.getCdnPolicy());
      }
      if (other.hasCircuitBreakers()) {
        mergeCircuitBreakers(other.getCircuitBreakers());
      }
      if (other.hasCompressionMode()) {
        compressionMode_ = other.compressionMode_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasConnectionDraining()) {
        mergeConnectionDraining(other.getConnectionDraining());
      }
      if (other.hasConnectionTrackingPolicy()) {
        mergeConnectionTrackingPolicy(other.getConnectionTrackingPolicy());
      }
      if (other.hasConsistentHash()) {
        mergeConsistentHash(other.getConsistentHash());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.customRequestHeaders_.isEmpty()) {
        if (customRequestHeaders_.isEmpty()) {
          customRequestHeaders_ = other.customRequestHeaders_;
          bitField0_ |= 0x00000200;
        } else {
          ensureCustomRequestHeadersIsMutable();
          customRequestHeaders_.addAll(other.customRequestHeaders_);
        }
        onChanged();
      }
      if (!other.customResponseHeaders_.isEmpty()) {
        if (customResponseHeaders_.isEmpty()) {
          customResponseHeaders_ = other.customResponseHeaders_;
          bitField0_ |= 0x00000400;
        } else {
          ensureCustomResponseHeadersIsMutable();
          customResponseHeaders_.addAll(other.customResponseHeaders_);
        }
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasEdgeSecurityPolicy()) {
        edgeSecurityPolicy_ = other.edgeSecurityPolicy_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasEnableCDN()) {
        setEnableCDN(other.getEnableCDN());
      }
      if (other.hasFailoverPolicy()) {
        mergeFailoverPolicy(other.getFailoverPolicy());
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.healthChecks_.isEmpty()) {
        if (healthChecks_.isEmpty()) {
          healthChecks_ = other.healthChecks_;
          bitField0_ |= 0x00010000;
        } else {
          ensureHealthChecksIsMutable();
          healthChecks_.addAll(other.healthChecks_);
        }
        onChanged();
      }
      if (other.hasIap()) {
        mergeIap(other.getIap());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasLoadBalancingScheme()) {
        loadBalancingScheme_ = other.loadBalancingScheme_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (localityLbPoliciesBuilder_ == null) {
        if (!other.localityLbPolicies_.isEmpty()) {
          if (localityLbPolicies_.isEmpty()) {
            localityLbPolicies_ = other.localityLbPolicies_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureLocalityLbPoliciesIsMutable();
            localityLbPolicies_.addAll(other.localityLbPolicies_);
          }
          onChanged();
        }
      } else {
        if (!other.localityLbPolicies_.isEmpty()) {
          if (localityLbPoliciesBuilder_.isEmpty()) {
            localityLbPoliciesBuilder_.dispose();
            localityLbPoliciesBuilder_ = null;
            localityLbPolicies_ = other.localityLbPolicies_;
            bitField0_ = (bitField0_ & ~0x00200000);
            localityLbPoliciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocalityLbPoliciesFieldBuilder()
                    : null;
          } else {
            localityLbPoliciesBuilder_.addAllMessages(other.localityLbPolicies_);
          }
        }
      }
      if (other.hasLocalityLbPolicy()) {
        localityLbPolicy_ = other.localityLbPolicy_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasLogConfig()) {
        mergeLogConfig(other.getLogConfig());
      }
      if (other.hasMaxStreamDuration()) {
        mergeMaxStreamDuration(other.getMaxStreamDuration());
      }
      internalGetMutableMetadatas().mergeFrom(other.internalGetMetadatas());
      bitField0_ |= 0x02000000;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (other.hasOutlierDetection()) {
        mergeOutlierDetection(other.getOutlierDetection());
      }
      if (other.hasPort()) {
        setPort(other.getPort());
      }
      if (other.hasPortName()) {
        portName_ = other.portName_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (other.hasProtocol()) {
        protocol_ = other.protocol_;
        bitField0_ |= 0x80000000;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField1_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSecurityPolicy()) {
        securityPolicy_ = other.securityPolicy_;
        bitField1_ |= 0x00000002;
        onChanged();
      }
      if (other.hasSecuritySettings()) {
        mergeSecuritySettings(other.getSecuritySettings());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField1_ |= 0x00000008;
        onChanged();
      }
      if (!other.serviceBindings_.isEmpty()) {
        if (serviceBindings_.isEmpty()) {
          serviceBindings_ = other.serviceBindings_;
          bitField1_ |= 0x00000010;
        } else {
          ensureServiceBindingsIsMutable();
          serviceBindings_.addAll(other.serviceBindings_);
        }
        onChanged();
      }
      if (other.hasServiceLbPolicy()) {
        serviceLbPolicy_ = other.serviceLbPolicy_;
        bitField1_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSessionAffinity()) {
        sessionAffinity_ = other.sessionAffinity_;
        bitField1_ |= 0x00000040;
        onChanged();
      }
      if (other.hasSubsetting()) {
        mergeSubsetting(other.getSubsetting());
      }
      if (other.hasTimeoutSec()) {
        setTimeoutSec(other.getTimeoutSec());
      }
      if (usedByBuilder_ == null) {
        if (!other.usedBy_.isEmpty()) {
          if (usedBy_.isEmpty()) {
            usedBy_ = other.usedBy_;
            bitField1_ = (bitField1_ & ~0x00000200);
          } else {
            ensureUsedByIsMutable();
            usedBy_.addAll(other.usedBy_);
          }
          onChanged();
        }
      } else {
        if (!other.usedBy_.isEmpty()) {
          if (usedByBuilder_.isEmpty()) {
            usedByBuilder_.dispose();
            usedByBuilder_ = null;
            usedBy_ = other.usedBy_;
            bitField1_ = (bitField1_ & ~0x00000200);
            usedByBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUsedByFieldBuilder()
                    : null;
          } else {
            usedByBuilder_.addAllMessages(other.usedBy_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00040000;
                break;
              } // case 26840
            case 832194:
              {
                input.readMessage(getIapFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 832194
            case 7247066:
              {
                input.readMessage(getConsistentHashFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 7247066
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 26989658
            case 27575304:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x20000000;
                break;
              } // case 27575304
            case 68114722:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadatas__ =
                    input.readMessage(
                        MetadatasDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadatas()
                    .getMutableMap()
                    .put(metadatas__.getKey(), metadatas__.getValue());
                bitField0_ |= 0x02000000;
                break;
              } // case 68114722
            case 223823938:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCustomRequestHeadersIsMutable();
                customRequestHeaders_.add(s);
                break;
              } // case 223823938
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 244202930
            case 328295546:
              {
                edgeSecurityPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 328295546
            case 332274762:
              {
                portName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 332274762
            case 491427010:
              {
                input.readMessage(
                    getMaxStreamDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 491427010
            case 639959960:
              {
                timeoutSec_ = input.readInt32();
                bitField1_ |= 0x00000100;
                break;
              } // case 639959960
            case 676623554:
              {
                protocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x80000000;
                break;
              } // case 676623554
            case 758790282:
              {
                serviceLbPolicy_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000020;
                break;
              } // case 758790282
            case 764167906:
              {
                compressionMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 764167906
            case 845269242:
              {
                input.readMessage(getFailoverPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 845269242
            case 1051451898:
              {
                localityLbPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 1051451898
            case 1068648130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServiceBindingsIsMutable();
                serviceBindings_.add(s);
                break;
              } // case 1068648130
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000001;
                break;
              } // case 1111570338
            case 1127860458:
              {
                com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig
                            .parser(),
                        extensionRegistry);
                if (localityLbPoliciesBuilder_ == null) {
                  ensureLocalityLbPoliciesIsMutable();
                  localityLbPolicies_.add(m);
                } else {
                  localityLbPoliciesBuilder_.addMessage(m);
                }
                break;
              } // case 1127860458
            case 1151959754:
              {
                input.readMessage(
                    getConnectionTrackingPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 1151959754
            case 1368660106:
              {
                securityPolicy_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000002;
                break;
              } // case 1368660106
            case 1711811618:
              {
                input.readMessage(getCdnPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 1711811618
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case 1862979954
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 1877428002
            case 2005867992:
              {
                enableCDN_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 2005867992
            case -1484569366:
              {
                input.readMessage(getLogConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case -1484569366
            case -1457966606:
              {
                input.readMessage(
                    getOutlierDetectionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case -1457966606
            case -1383845342:
              {
                loadBalancingScheme_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case -1383845342
            case -1334991664:
              {
                affinityCookieTtlSec_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case -1334991664
            case -1194654542:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCustomResponseHeadersIsMutable();
                customResponseHeaders_.add(s);
                break;
              } // case -1194654542
            case -1180401462:
              {
                com.google.cloud.compute.v1.BackendServiceUsedBy m =
                    input.readMessage(
                        com.google.cloud.compute.v1.BackendServiceUsedBy.parser(),
                        extensionRegistry);
                if (usedByBuilder_ == null) {
                  ensureUsedByIsMutable();
                  usedBy_.add(m);
                } else {
                  usedByBuilder_.addMessage(m);
                }
                break;
              } // case -1180401462
            case -924246806:
              {
                input.readMessage(getCircuitBreakersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -924246806
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -911466526
            case -708002446:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureHealthChecksIsMutable();
                healthChecks_.add(s);
                break;
              } // case -708002446
            case -692699006:
              {
                input.readMessage(getSubsettingFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000080;
                break;
              } // case -692699006
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000008;
                break;
              } // case -645248918
            case -606193318:
              {
                input.readMessage(
                    getConnectionDrainingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -606193318
            case -583858806:
              {
                sessionAffinity_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000040;
                break;
              } // case -583858806
            case -465767918:
              {
                input.readMessage(
                    getSecuritySettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000004;
                break;
              } // case -465767918
            case -208248070:
              {
                com.google.cloud.compute.v1.Backend m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Backend.parser(), extensionRegistry);
                if (backendsBuilder_ == null) {
                  ensureBackendsIsMutable();
                  backends_.add(m);
                } else {
                  backendsBuilder_.addMessage(m);
                }
                break;
              } // case -208248070
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private int affinityCookieTtlSec_;
    /**
     *
     *
     * <pre>
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     *
     * @return Whether the affinityCookieTtlSec field is set.
     */
    @java.lang.Override
    public boolean hasAffinityCookieTtlSec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     *
     * @return The affinityCookieTtlSec.
     */
    @java.lang.Override
    public int getAffinityCookieTtlSec() {
      return affinityCookieTtlSec_;
    }
    /**
     *
     *
     * <pre>
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     *
     * @param value The affinityCookieTtlSec to set.
     * @return This builder for chaining.
     */
    public Builder setAffinityCookieTtlSec(int value) {

      affinityCookieTtlSec_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAffinityCookieTtlSec() {
      bitField0_ = (bitField0_ & ~0x00000001);
      affinityCookieTtlSec_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Backend> backends_ =
        java.util.Collections.emptyList();

    private void ensureBackendsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        backends_ = new java.util.ArrayList<com.google.cloud.compute.v1.Backend>(backends_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Backend,
            com.google.cloud.compute.v1.Backend.Builder,
            com.google.cloud.compute.v1.BackendOrBuilder>
        backendsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Backend> getBackendsList() {
      if (backendsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(backends_);
      } else {
        return backendsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public int getBackendsCount() {
      if (backendsBuilder_ == null) {
        return backends_.size();
      } else {
        return backendsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public com.google.cloud.compute.v1.Backend getBackends(int index) {
      if (backendsBuilder_ == null) {
        return backends_.get(index);
      } else {
        return backendsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder setBackends(int index, com.google.cloud.compute.v1.Backend value) {
      if (backendsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackendsIsMutable();
        backends_.set(index, value);
        onChanged();
      } else {
        backendsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder setBackends(
        int index, com.google.cloud.compute.v1.Backend.Builder builderForValue) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.set(index, builderForValue.build());
        onChanged();
      } else {
        backendsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder addBackends(com.google.cloud.compute.v1.Backend value) {
      if (backendsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackendsIsMutable();
        backends_.add(value);
        onChanged();
      } else {
        backendsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder addBackends(int index, com.google.cloud.compute.v1.Backend value) {
      if (backendsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackendsIsMutable();
        backends_.add(index, value);
        onChanged();
      } else {
        backendsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder addBackends(com.google.cloud.compute.v1.Backend.Builder builderForValue) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.add(builderForValue.build());
        onChanged();
      } else {
        backendsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder addBackends(
        int index, com.google.cloud.compute.v1.Backend.Builder builderForValue) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.add(index, builderForValue.build());
        onChanged();
      } else {
        backendsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder addAllBackends(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Backend> values) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, backends_);
        onChanged();
      } else {
        backendsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder clearBackends() {
      if (backendsBuilder_ == null) {
        backends_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        backendsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public Builder removeBackends(int index) {
      if (backendsBuilder_ == null) {
        ensureBackendsIsMutable();
        backends_.remove(index);
        onChanged();
      } else {
        backendsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public com.google.cloud.compute.v1.Backend.Builder getBackendsBuilder(int index) {
      return getBackendsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public com.google.cloud.compute.v1.BackendOrBuilder getBackendsOrBuilder(int index) {
      if (backendsBuilder_ == null) {
        return backends_.get(index);
      } else {
        return backendsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.BackendOrBuilder>
        getBackendsOrBuilderList() {
      if (backendsBuilder_ != null) {
        return backendsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(backends_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public com.google.cloud.compute.v1.Backend.Builder addBackendsBuilder() {
      return getBackendsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Backend.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public com.google.cloud.compute.v1.Backend.Builder addBackendsBuilder(int index) {
      return getBackendsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Backend.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of backends that serve this BackendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Backend.Builder> getBackendsBuilderList() {
      return getBackendsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Backend,
            com.google.cloud.compute.v1.Backend.Builder,
            com.google.cloud.compute.v1.BackendOrBuilder>
        getBackendsFieldBuilder() {
      if (backendsBuilder_ == null) {
        backendsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Backend,
                com.google.cloud.compute.v1.Backend.Builder,
                com.google.cloud.compute.v1.BackendOrBuilder>(
                backends_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        backends_ = null;
      }
      return backendsBuilder_;
    }

    private com.google.cloud.compute.v1.BackendServiceCdnPolicy cdnPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceCdnPolicy,
            com.google.cloud.compute.v1.BackendServiceCdnPolicy.Builder,
            com.google.cloud.compute.v1.BackendServiceCdnPolicyOrBuilder>
        cdnPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     *
     * @return Whether the cdnPolicy field is set.
     */
    public boolean hasCdnPolicy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     *
     * @return The cdnPolicy.
     */
    public com.google.cloud.compute.v1.BackendServiceCdnPolicy getCdnPolicy() {
      if (cdnPolicyBuilder_ == null) {
        return cdnPolicy_ == null
            ? com.google.cloud.compute.v1.BackendServiceCdnPolicy.getDefaultInstance()
            : cdnPolicy_;
      } else {
        return cdnPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    public Builder setCdnPolicy(com.google.cloud.compute.v1.BackendServiceCdnPolicy value) {
      if (cdnPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cdnPolicy_ = value;
      } else {
        cdnPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    public Builder setCdnPolicy(
        com.google.cloud.compute.v1.BackendServiceCdnPolicy.Builder builderForValue) {
      if (cdnPolicyBuilder_ == null) {
        cdnPolicy_ = builderForValue.build();
      } else {
        cdnPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    public Builder mergeCdnPolicy(com.google.cloud.compute.v1.BackendServiceCdnPolicy value) {
      if (cdnPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cdnPolicy_ != null
            && cdnPolicy_
                != com.google.cloud.compute.v1.BackendServiceCdnPolicy.getDefaultInstance()) {
          getCdnPolicyBuilder().mergeFrom(value);
        } else {
          cdnPolicy_ = value;
        }
      } else {
        cdnPolicyBuilder_.mergeFrom(value);
      }
      if (cdnPolicy_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    public Builder clearCdnPolicy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cdnPolicy_ = null;
      if (cdnPolicyBuilder_ != null) {
        cdnPolicyBuilder_.dispose();
        cdnPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceCdnPolicy.Builder getCdnPolicyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCdnPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceCdnPolicyOrBuilder getCdnPolicyOrBuilder() {
      if (cdnPolicyBuilder_ != null) {
        return cdnPolicyBuilder_.getMessageOrBuilder();
      } else {
        return cdnPolicy_ == null
            ? com.google.cloud.compute.v1.BackendServiceCdnPolicy.getDefaultInstance()
            : cdnPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceCdnPolicy,
            com.google.cloud.compute.v1.BackendServiceCdnPolicy.Builder,
            com.google.cloud.compute.v1.BackendServiceCdnPolicyOrBuilder>
        getCdnPolicyFieldBuilder() {
      if (cdnPolicyBuilder_ == null) {
        cdnPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceCdnPolicy,
                com.google.cloud.compute.v1.BackendServiceCdnPolicy.Builder,
                com.google.cloud.compute.v1.BackendServiceCdnPolicyOrBuilder>(
                getCdnPolicy(), getParentForChildren(), isClean());
        cdnPolicy_ = null;
      }
      return cdnPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.CircuitBreakers circuitBreakers_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CircuitBreakers,
            com.google.cloud.compute.v1.CircuitBreakers.Builder,
            com.google.cloud.compute.v1.CircuitBreakersOrBuilder>
        circuitBreakersBuilder_;
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     *
     * @return Whether the circuitBreakers field is set.
     */
    public boolean hasCircuitBreakers() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     *
     * @return The circuitBreakers.
     */
    public com.google.cloud.compute.v1.CircuitBreakers getCircuitBreakers() {
      if (circuitBreakersBuilder_ == null) {
        return circuitBreakers_ == null
            ? com.google.cloud.compute.v1.CircuitBreakers.getDefaultInstance()
            : circuitBreakers_;
      } else {
        return circuitBreakersBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    public Builder setCircuitBreakers(com.google.cloud.compute.v1.CircuitBreakers value) {
      if (circuitBreakersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        circuitBreakers_ = value;
      } else {
        circuitBreakersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    public Builder setCircuitBreakers(
        com.google.cloud.compute.v1.CircuitBreakers.Builder builderForValue) {
      if (circuitBreakersBuilder_ == null) {
        circuitBreakers_ = builderForValue.build();
      } else {
        circuitBreakersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    public Builder mergeCircuitBreakers(com.google.cloud.compute.v1.CircuitBreakers value) {
      if (circuitBreakersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && circuitBreakers_ != null
            && circuitBreakers_
                != com.google.cloud.compute.v1.CircuitBreakers.getDefaultInstance()) {
          getCircuitBreakersBuilder().mergeFrom(value);
        } else {
          circuitBreakers_ = value;
        }
      } else {
        circuitBreakersBuilder_.mergeFrom(value);
      }
      if (circuitBreakers_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    public Builder clearCircuitBreakers() {
      bitField0_ = (bitField0_ & ~0x00000008);
      circuitBreakers_ = null;
      if (circuitBreakersBuilder_ != null) {
        circuitBreakersBuilder_.dispose();
        circuitBreakersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    public com.google.cloud.compute.v1.CircuitBreakers.Builder getCircuitBreakersBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCircuitBreakersFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    public com.google.cloud.compute.v1.CircuitBreakersOrBuilder getCircuitBreakersOrBuilder() {
      if (circuitBreakersBuilder_ != null) {
        return circuitBreakersBuilder_.getMessageOrBuilder();
      } else {
        return circuitBreakers_ == null
            ? com.google.cloud.compute.v1.CircuitBreakers.getDefaultInstance()
            : circuitBreakers_;
      }
    }
    /**
     * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CircuitBreakers,
            com.google.cloud.compute.v1.CircuitBreakers.Builder,
            com.google.cloud.compute.v1.CircuitBreakersOrBuilder>
        getCircuitBreakersFieldBuilder() {
      if (circuitBreakersBuilder_ == null) {
        circuitBreakersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CircuitBreakers,
                com.google.cloud.compute.v1.CircuitBreakers.Builder,
                com.google.cloud.compute.v1.CircuitBreakersOrBuilder>(
                getCircuitBreakers(), getParentForChildren(), isClean());
        circuitBreakers_ = null;
      }
      return circuitBreakersBuilder_;
    }

    private java.lang.Object compressionMode_ = "";
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return Whether the compressionMode field is set.
     */
    public boolean hasCompressionMode() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return The compressionMode.
     */
    public java.lang.String getCompressionMode() {
      java.lang.Object ref = compressionMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        compressionMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return The bytes for compressionMode.
     */
    public com.google.protobuf.ByteString getCompressionModeBytes() {
      java.lang.Object ref = compressionMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        compressionMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @param value The compressionMode to set.
     * @return This builder for chaining.
     */
    public Builder setCompressionMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      compressionMode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompressionMode() {
      compressionMode_ = getDefaultInstance().getCompressionMode();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string compression_mode = 95520988;</code>
     *
     * @param value The bytes for compressionMode to set.
     * @return This builder for chaining.
     */
    public Builder setCompressionModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      compressionMode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ConnectionDraining connectionDraining_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConnectionDraining,
            com.google.cloud.compute.v1.ConnectionDraining.Builder,
            com.google.cloud.compute.v1.ConnectionDrainingOrBuilder>
        connectionDrainingBuilder_;
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     *
     * @return Whether the connectionDraining field is set.
     */
    public boolean hasConnectionDraining() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     *
     * @return The connectionDraining.
     */
    public com.google.cloud.compute.v1.ConnectionDraining getConnectionDraining() {
      if (connectionDrainingBuilder_ == null) {
        return connectionDraining_ == null
            ? com.google.cloud.compute.v1.ConnectionDraining.getDefaultInstance()
            : connectionDraining_;
      } else {
        return connectionDrainingBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    public Builder setConnectionDraining(com.google.cloud.compute.v1.ConnectionDraining value) {
      if (connectionDrainingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionDraining_ = value;
      } else {
        connectionDrainingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    public Builder setConnectionDraining(
        com.google.cloud.compute.v1.ConnectionDraining.Builder builderForValue) {
      if (connectionDrainingBuilder_ == null) {
        connectionDraining_ = builderForValue.build();
      } else {
        connectionDrainingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    public Builder mergeConnectionDraining(com.google.cloud.compute.v1.ConnectionDraining value) {
      if (connectionDrainingBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && connectionDraining_ != null
            && connectionDraining_
                != com.google.cloud.compute.v1.ConnectionDraining.getDefaultInstance()) {
          getConnectionDrainingBuilder().mergeFrom(value);
        } else {
          connectionDraining_ = value;
        }
      } else {
        connectionDrainingBuilder_.mergeFrom(value);
      }
      if (connectionDraining_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    public Builder clearConnectionDraining() {
      bitField0_ = (bitField0_ & ~0x00000020);
      connectionDraining_ = null;
      if (connectionDrainingBuilder_ != null) {
        connectionDrainingBuilder_.dispose();
        connectionDrainingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    public com.google.cloud.compute.v1.ConnectionDraining.Builder getConnectionDrainingBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getConnectionDrainingFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    public com.google.cloud.compute.v1.ConnectionDrainingOrBuilder
        getConnectionDrainingOrBuilder() {
      if (connectionDrainingBuilder_ != null) {
        return connectionDrainingBuilder_.getMessageOrBuilder();
      } else {
        return connectionDraining_ == null
            ? com.google.cloud.compute.v1.ConnectionDraining.getDefaultInstance()
            : connectionDraining_;
      }
    }
    /**
     * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConnectionDraining,
            com.google.cloud.compute.v1.ConnectionDraining.Builder,
            com.google.cloud.compute.v1.ConnectionDrainingOrBuilder>
        getConnectionDrainingFieldBuilder() {
      if (connectionDrainingBuilder_ == null) {
        connectionDrainingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ConnectionDraining,
                com.google.cloud.compute.v1.ConnectionDraining.Builder,
                com.google.cloud.compute.v1.ConnectionDrainingOrBuilder>(
                getConnectionDraining(), getParentForChildren(), isClean());
        connectionDraining_ = null;
      }
      return connectionDrainingBuilder_;
    }

    private com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
        connectionTrackingPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy,
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder,
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder>
        connectionTrackingPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     *
     * @return Whether the connectionTrackingPolicy field is set.
     */
    public boolean hasConnectionTrackingPolicy() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     *
     * @return The connectionTrackingPolicy.
     */
    public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
        getConnectionTrackingPolicy() {
      if (connectionTrackingPolicyBuilder_ == null) {
        return connectionTrackingPolicy_ == null
            ? com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
                .getDefaultInstance()
            : connectionTrackingPolicy_;
      } else {
        return connectionTrackingPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    public Builder setConnectionTrackingPolicy(
        com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy value) {
      if (connectionTrackingPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionTrackingPolicy_ = value;
      } else {
        connectionTrackingPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    public Builder setConnectionTrackingPolicy(
        com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder
            builderForValue) {
      if (connectionTrackingPolicyBuilder_ == null) {
        connectionTrackingPolicy_ = builderForValue.build();
      } else {
        connectionTrackingPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    public Builder mergeConnectionTrackingPolicy(
        com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy value) {
      if (connectionTrackingPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && connectionTrackingPolicy_ != null
            && connectionTrackingPolicy_
                != com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
                    .getDefaultInstance()) {
          getConnectionTrackingPolicyBuilder().mergeFrom(value);
        } else {
          connectionTrackingPolicy_ = value;
        }
      } else {
        connectionTrackingPolicyBuilder_.mergeFrom(value);
      }
      if (connectionTrackingPolicy_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    public Builder clearConnectionTrackingPolicy() {
      bitField0_ = (bitField0_ & ~0x00000040);
      connectionTrackingPolicy_ = null;
      if (connectionTrackingPolicyBuilder_ != null) {
        connectionTrackingPolicyBuilder_.dispose();
        connectionTrackingPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder
        getConnectionTrackingPolicyBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getConnectionTrackingPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder
        getConnectionTrackingPolicyOrBuilder() {
      if (connectionTrackingPolicyBuilder_ != null) {
        return connectionTrackingPolicyBuilder_.getMessageOrBuilder();
      } else {
        return connectionTrackingPolicy_ == null
            ? com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
                .getDefaultInstance()
            : connectionTrackingPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy,
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder,
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder>
        getConnectionTrackingPolicyFieldBuilder() {
      if (connectionTrackingPolicyBuilder_ == null) {
        connectionTrackingPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy,
                com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder,
                com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder>(
                getConnectionTrackingPolicy(), getParentForChildren(), isClean());
        connectionTrackingPolicy_ = null;
      }
      return connectionTrackingPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistentHash_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings,
            com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.Builder,
            com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettingsOrBuilder>
        consistentHashBuilder_;
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     *
     * @return Whether the consistentHash field is set.
     */
    public boolean hasConsistentHash() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     *
     * @return The consistentHash.
     */
    public com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings getConsistentHash() {
      if (consistentHashBuilder_ == null) {
        return consistentHash_ == null
            ? com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.getDefaultInstance()
            : consistentHash_;
      } else {
        return consistentHashBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    public Builder setConsistentHash(
        com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings value) {
      if (consistentHashBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistentHash_ = value;
      } else {
        consistentHashBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    public Builder setConsistentHash(
        com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.Builder builderForValue) {
      if (consistentHashBuilder_ == null) {
        consistentHash_ = builderForValue.build();
      } else {
        consistentHashBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    public Builder mergeConsistentHash(
        com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings value) {
      if (consistentHashBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && consistentHash_ != null
            && consistentHash_
                != com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings
                    .getDefaultInstance()) {
          getConsistentHashBuilder().mergeFrom(value);
        } else {
          consistentHash_ = value;
        }
      } else {
        consistentHashBuilder_.mergeFrom(value);
      }
      if (consistentHash_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    public Builder clearConsistentHash() {
      bitField0_ = (bitField0_ & ~0x00000080);
      consistentHash_ = null;
      if (consistentHashBuilder_ != null) {
        consistentHashBuilder_.dispose();
        consistentHashBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    public com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.Builder
        getConsistentHashBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getConsistentHashFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    public com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettingsOrBuilder
        getConsistentHashOrBuilder() {
      if (consistentHashBuilder_ != null) {
        return consistentHashBuilder_.getMessageOrBuilder();
      } else {
        return consistentHash_ == null
            ? com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.getDefaultInstance()
            : consistentHash_;
      }
    }
    /**
     *
     *
     * <pre>
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings,
            com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.Builder,
            com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettingsOrBuilder>
        getConsistentHashFieldBuilder() {
      if (consistentHashBuilder_ == null) {
        consistentHashBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings,
                com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings.Builder,
                com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettingsOrBuilder>(
                getConsistentHash(), getParentForChildren(), isClean());
        consistentHash_ = null;
      }
      return consistentHashBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList customRequestHeaders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCustomRequestHeadersIsMutable() {
      if (!customRequestHeaders_.isModifiable()) {
        customRequestHeaders_ = new com.google.protobuf.LazyStringArrayList(customRequestHeaders_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @return A list containing the customRequestHeaders.
     */
    public com.google.protobuf.ProtocolStringList getCustomRequestHeadersList() {
      customRequestHeaders_.makeImmutable();
      return customRequestHeaders_;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @return The count of customRequestHeaders.
     */
    public int getCustomRequestHeadersCount() {
      return customRequestHeaders_.size();
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @param index The index of the element to return.
     * @return The customRequestHeaders at the given index.
     */
    public java.lang.String getCustomRequestHeaders(int index) {
      return customRequestHeaders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customRequestHeaders at the given index.
     */
    public com.google.protobuf.ByteString getCustomRequestHeadersBytes(int index) {
      return customRequestHeaders_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @param index The index to set the value at.
     * @param value The customRequestHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setCustomRequestHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomRequestHeadersIsMutable();
      customRequestHeaders_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @param value The customRequestHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addCustomRequestHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomRequestHeadersIsMutable();
      customRequestHeaders_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @param values The customRequestHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllCustomRequestHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureCustomRequestHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customRequestHeaders_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomRequestHeaders() {
      customRequestHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_request_headers = 27977992;</code>
     *
     * @param value The bytes of the customRequestHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addCustomRequestHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCustomRequestHeadersIsMutable();
      customRequestHeaders_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList customResponseHeaders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCustomResponseHeadersIsMutable() {
      if (!customResponseHeaders_.isModifiable()) {
        customResponseHeaders_ =
            new com.google.protobuf.LazyStringArrayList(customResponseHeaders_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @return A list containing the customResponseHeaders.
     */
    public com.google.protobuf.ProtocolStringList getCustomResponseHeadersList() {
      customResponseHeaders_.makeImmutable();
      return customResponseHeaders_;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @return The count of customResponseHeaders.
     */
    public int getCustomResponseHeadersCount() {
      return customResponseHeaders_.size();
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param index The index of the element to return.
     * @return The customResponseHeaders at the given index.
     */
    public java.lang.String getCustomResponseHeaders(int index) {
      return customResponseHeaders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customResponseHeaders at the given index.
     */
    public com.google.protobuf.ByteString getCustomResponseHeadersBytes(int index) {
      return customResponseHeaders_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param index The index to set the value at.
     * @param value The customResponseHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setCustomResponseHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomResponseHeadersIsMutable();
      customResponseHeaders_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param value The customResponseHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addCustomResponseHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomResponseHeadersIsMutable();
      customResponseHeaders_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param values The customResponseHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllCustomResponseHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureCustomResponseHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customResponseHeaders_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomResponseHeaders() {
      customResponseHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     * </pre>
     *
     * <code>repeated string custom_response_headers = 387539094;</code>
     *
     * @param value The bytes of the customResponseHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addCustomResponseHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCustomResponseHeadersIsMutable();
      customResponseHeaders_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object edgeSecurityPolicy_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return Whether the edgeSecurityPolicy field is set.
     */
    public boolean hasEdgeSecurityPolicy() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return The edgeSecurityPolicy.
     */
    public java.lang.String getEdgeSecurityPolicy() {
      java.lang.Object ref = edgeSecurityPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        edgeSecurityPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return The bytes for edgeSecurityPolicy.
     */
    public com.google.protobuf.ByteString getEdgeSecurityPolicyBytes() {
      java.lang.Object ref = edgeSecurityPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        edgeSecurityPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @param value The edgeSecurityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setEdgeSecurityPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      edgeSecurityPolicy_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEdgeSecurityPolicy() {
      edgeSecurityPolicy_ = getDefaultInstance().getEdgeSecurityPolicy();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string edge_security_policy = 41036943;</code>
     *
     * @param value The bytes for edgeSecurityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setEdgeSecurityPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      edgeSecurityPolicy_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private boolean enableCDN_;
    /**
     *
     *
     * <pre>
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     * </pre>
     *
     * <code>optional bool enable_c_d_n = 250733499;</code>
     *
     * @return Whether the enableCDN field is set.
     */
    @java.lang.Override
    public boolean hasEnableCDN() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     * </pre>
     *
     * <code>optional bool enable_c_d_n = 250733499;</code>
     *
     * @return The enableCDN.
     */
    @java.lang.Override
    public boolean getEnableCDN() {
      return enableCDN_;
    }
    /**
     *
     *
     * <pre>
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     * </pre>
     *
     * <code>optional bool enable_c_d_n = 250733499;</code>
     *
     * @param value The enableCDN to set.
     * @return This builder for chaining.
     */
    public Builder setEnableCDN(boolean value) {

      enableCDN_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     * </pre>
     *
     * <code>optional bool enable_c_d_n = 250733499;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableCDN() {
      bitField0_ = (bitField0_ & ~0x00002000);
      enableCDN_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BackendServiceFailoverPolicy failoverPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceFailoverPolicy,
            com.google.cloud.compute.v1.BackendServiceFailoverPolicy.Builder,
            com.google.cloud.compute.v1.BackendServiceFailoverPolicyOrBuilder>
        failoverPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     *
     * @return Whether the failoverPolicy field is set.
     */
    public boolean hasFailoverPolicy() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     *
     * @return The failoverPolicy.
     */
    public com.google.cloud.compute.v1.BackendServiceFailoverPolicy getFailoverPolicy() {
      if (failoverPolicyBuilder_ == null) {
        return failoverPolicy_ == null
            ? com.google.cloud.compute.v1.BackendServiceFailoverPolicy.getDefaultInstance()
            : failoverPolicy_;
      } else {
        return failoverPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    public Builder setFailoverPolicy(
        com.google.cloud.compute.v1.BackendServiceFailoverPolicy value) {
      if (failoverPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        failoverPolicy_ = value;
      } else {
        failoverPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    public Builder setFailoverPolicy(
        com.google.cloud.compute.v1.BackendServiceFailoverPolicy.Builder builderForValue) {
      if (failoverPolicyBuilder_ == null) {
        failoverPolicy_ = builderForValue.build();
      } else {
        failoverPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    public Builder mergeFailoverPolicy(
        com.google.cloud.compute.v1.BackendServiceFailoverPolicy value) {
      if (failoverPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && failoverPolicy_ != null
            && failoverPolicy_
                != com.google.cloud.compute.v1.BackendServiceFailoverPolicy.getDefaultInstance()) {
          getFailoverPolicyBuilder().mergeFrom(value);
        } else {
          failoverPolicy_ = value;
        }
      } else {
        failoverPolicyBuilder_.mergeFrom(value);
      }
      if (failoverPolicy_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    public Builder clearFailoverPolicy() {
      bitField0_ = (bitField0_ & ~0x00004000);
      failoverPolicy_ = null;
      if (failoverPolicyBuilder_ != null) {
        failoverPolicyBuilder_.dispose();
        failoverPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceFailoverPolicy.Builder
        getFailoverPolicyBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getFailoverPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceFailoverPolicyOrBuilder
        getFailoverPolicyOrBuilder() {
      if (failoverPolicyBuilder_ != null) {
        return failoverPolicyBuilder_.getMessageOrBuilder();
      } else {
        return failoverPolicy_ == null
            ? com.google.cloud.compute.v1.BackendServiceFailoverPolicy.getDefaultInstance()
            : failoverPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceFailoverPolicy,
            com.google.cloud.compute.v1.BackendServiceFailoverPolicy.Builder,
            com.google.cloud.compute.v1.BackendServiceFailoverPolicyOrBuilder>
        getFailoverPolicyFieldBuilder() {
      if (failoverPolicyBuilder_ == null) {
        failoverPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceFailoverPolicy,
                com.google.cloud.compute.v1.BackendServiceFailoverPolicy.Builder,
                com.google.cloud.compute.v1.BackendServiceFailoverPolicyOrBuilder>(
                getFailoverPolicy(), getParentForChildren(), isClean());
        failoverPolicy_ = null;
      }
      return failoverPolicyBuilder_;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList healthChecks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureHealthChecksIsMutable() {
      if (!healthChecks_.isModifiable()) {
        healthChecks_ = new com.google.protobuf.LazyStringArrayList(healthChecks_);
      }
      bitField0_ |= 0x00010000;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @return A list containing the healthChecks.
     */
    public com.google.protobuf.ProtocolStringList getHealthChecksList() {
      healthChecks_.makeImmutable();
      return healthChecks_;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @return The count of healthChecks.
     */
    public int getHealthChecksCount() {
      return healthChecks_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @param index The index of the element to return.
     * @return The healthChecks at the given index.
     */
    public java.lang.String getHealthChecks(int index) {
      return healthChecks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the healthChecks at the given index.
     */
    public com.google.protobuf.ByteString getHealthChecksBytes(int index) {
      return healthChecks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @param index The index to set the value at.
     * @param value The healthChecks to set.
     * @return This builder for chaining.
     */
    public Builder setHealthChecks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHealthChecksIsMutable();
      healthChecks_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @param value The healthChecks to add.
     * @return This builder for chaining.
     */
    public Builder addHealthChecks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHealthChecksIsMutable();
      healthChecks_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @param values The healthChecks to add.
     * @return This builder for chaining.
     */
    public Builder addAllHealthChecks(java.lang.Iterable<java.lang.String> values) {
      ensureHealthChecksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, healthChecks_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthChecks() {
      healthChecks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
     * </pre>
     *
     * <code>repeated string health_checks = 448370606;</code>
     *
     * @param value The bytes of the healthChecks to add.
     * @return This builder for chaining.
     */
    public Builder addHealthChecksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureHealthChecksIsMutable();
      healthChecks_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BackendServiceIAP iap_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceIAP,
            com.google.cloud.compute.v1.BackendServiceIAP.Builder,
            com.google.cloud.compute.v1.BackendServiceIAPOrBuilder>
        iapBuilder_;
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     *
     * @return Whether the iap field is set.
     */
    public boolean hasIap() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     *
     * @return The iap.
     */
    public com.google.cloud.compute.v1.BackendServiceIAP getIap() {
      if (iapBuilder_ == null) {
        return iap_ == null
            ? com.google.cloud.compute.v1.BackendServiceIAP.getDefaultInstance()
            : iap_;
      } else {
        return iapBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    public Builder setIap(com.google.cloud.compute.v1.BackendServiceIAP value) {
      if (iapBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        iap_ = value;
      } else {
        iapBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    public Builder setIap(com.google.cloud.compute.v1.BackendServiceIAP.Builder builderForValue) {
      if (iapBuilder_ == null) {
        iap_ = builderForValue.build();
      } else {
        iapBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    public Builder mergeIap(com.google.cloud.compute.v1.BackendServiceIAP value) {
      if (iapBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && iap_ != null
            && iap_ != com.google.cloud.compute.v1.BackendServiceIAP.getDefaultInstance()) {
          getIapBuilder().mergeFrom(value);
        } else {
          iap_ = value;
        }
      } else {
        iapBuilder_.mergeFrom(value);
      }
      if (iap_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    public Builder clearIap() {
      bitField0_ = (bitField0_ & ~0x00020000);
      iap_ = null;
      if (iapBuilder_ != null) {
        iapBuilder_.dispose();
        iapBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    public com.google.cloud.compute.v1.BackendServiceIAP.Builder getIapBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getIapFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    public com.google.cloud.compute.v1.BackendServiceIAPOrBuilder getIapOrBuilder() {
      if (iapBuilder_ != null) {
        return iapBuilder_.getMessageOrBuilder();
      } else {
        return iap_ == null
            ? com.google.cloud.compute.v1.BackendServiceIAP.getDefaultInstance()
            : iap_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceIAP,
            com.google.cloud.compute.v1.BackendServiceIAP.Builder,
            com.google.cloud.compute.v1.BackendServiceIAPOrBuilder>
        getIapFieldBuilder() {
      if (iapBuilder_ == null) {
        iapBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceIAP,
                com.google.cloud.compute.v1.BackendServiceIAP.Builder,
                com.google.cloud.compute.v1.BackendServiceIAPOrBuilder>(
                getIap(), getParentForChildren(), isClean());
        iap_ = null;
      }
      return iapBuilder_;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00040000);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object loadBalancingScheme_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return Whether the loadBalancingScheme field is set.
     */
    public boolean hasLoadBalancingScheme() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return The loadBalancingScheme.
     */
    public java.lang.String getLoadBalancingScheme() {
      java.lang.Object ref = loadBalancingScheme_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        loadBalancingScheme_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return The bytes for loadBalancingScheme.
     */
    public com.google.protobuf.ByteString getLoadBalancingSchemeBytes() {
      java.lang.Object ref = loadBalancingScheme_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        loadBalancingScheme_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @param value The loadBalancingScheme to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancingScheme(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      loadBalancingScheme_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadBalancingScheme() {
      loadBalancingScheme_ = getDefaultInstance().getLoadBalancingScheme();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @param value The bytes for loadBalancingScheme to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancingSchemeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      loadBalancingScheme_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>
        localityLbPolicies_ = java.util.Collections.emptyList();

    private void ensureLocalityLbPoliciesIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        localityLbPolicies_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>(
                localityLbPolicies_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig,
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder,
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder>
        localityLbPoliciesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>
        getLocalityLbPoliciesList() {
      if (localityLbPoliciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(localityLbPolicies_);
      } else {
        return localityLbPoliciesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public int getLocalityLbPoliciesCount() {
      if (localityLbPoliciesBuilder_ == null) {
        return localityLbPolicies_.size();
      } else {
        return localityLbPoliciesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig
        getLocalityLbPolicies(int index) {
      if (localityLbPoliciesBuilder_ == null) {
        return localityLbPolicies_.get(index);
      } else {
        return localityLbPoliciesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder setLocalityLbPolicies(
        int index,
        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig value) {
      if (localityLbPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.set(index, value);
        onChanged();
      } else {
        localityLbPoliciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder setLocalityLbPolicies(
        int index,
        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder
            builderForValue) {
      if (localityLbPoliciesBuilder_ == null) {
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.set(index, builderForValue.build());
        onChanged();
      } else {
        localityLbPoliciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder addLocalityLbPolicies(
        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig value) {
      if (localityLbPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.add(value);
        onChanged();
      } else {
        localityLbPoliciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder addLocalityLbPolicies(
        int index,
        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig value) {
      if (localityLbPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.add(index, value);
        onChanged();
      } else {
        localityLbPoliciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder addLocalityLbPolicies(
        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder
            builderForValue) {
      if (localityLbPoliciesBuilder_ == null) {
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.add(builderForValue.build());
        onChanged();
      } else {
        localityLbPoliciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder addLocalityLbPolicies(
        int index,
        com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder
            builderForValue) {
      if (localityLbPoliciesBuilder_ == null) {
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.add(index, builderForValue.build());
        onChanged();
      } else {
        localityLbPoliciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder addAllLocalityLbPolicies(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>
            values) {
      if (localityLbPoliciesBuilder_ == null) {
        ensureLocalityLbPoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, localityLbPolicies_);
        onChanged();
      } else {
        localityLbPoliciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder clearLocalityLbPolicies() {
      if (localityLbPoliciesBuilder_ == null) {
        localityLbPolicies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        localityLbPoliciesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public Builder removeLocalityLbPolicies(int index) {
      if (localityLbPoliciesBuilder_ == null) {
        ensureLocalityLbPoliciesIsMutable();
        localityLbPolicies_.remove(index);
        onChanged();
      } else {
        localityLbPoliciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder
        getLocalityLbPoliciesBuilder(int index) {
      return getLocalityLbPoliciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder
        getLocalityLbPoliciesOrBuilder(int index) {
      if (localityLbPoliciesBuilder_ == null) {
        return localityLbPolicies_.get(index);
      } else {
        return localityLbPoliciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder>
        getLocalityLbPoliciesOrBuilderList() {
      if (localityLbPoliciesBuilder_ != null) {
        return localityLbPoliciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(localityLbPolicies_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder
        addLocalityLbPoliciesBuilder() {
      return getLocalityLbPoliciesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder
        addLocalityLbPoliciesBuilder(int index) {
      return getLocalityLbPoliciesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder>
        getLocalityLbPoliciesBuilderList() {
      return getLocalityLbPoliciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig,
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder,
            com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder>
        getLocalityLbPoliciesFieldBuilder() {
      if (localityLbPoliciesBuilder_ == null) {
        localityLbPoliciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig,
                com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig.Builder,
                com.google.cloud.compute.v1
                    .BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder>(
                localityLbPolicies_,
                ((bitField0_ & 0x00200000) != 0),
                getParentForChildren(),
                isClean());
        localityLbPolicies_ = null;
      }
      return localityLbPoliciesBuilder_;
    }

    private java.lang.Object localityLbPolicy_ = "";
    /**
     *
     *
     * <pre>
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * Check the LocalityLbPolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string locality_lb_policy = 131431487;</code>
     *
     * @return Whether the localityLbPolicy field is set.
     */
    public boolean hasLocalityLbPolicy() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * Check the LocalityLbPolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string locality_lb_policy = 131431487;</code>
     *
     * @return The localityLbPolicy.
     */
    public java.lang.String getLocalityLbPolicy() {
      java.lang.Object ref = localityLbPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        localityLbPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * Check the LocalityLbPolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string locality_lb_policy = 131431487;</code>
     *
     * @return The bytes for localityLbPolicy.
     */
    public com.google.protobuf.ByteString getLocalityLbPolicyBytes() {
      java.lang.Object ref = localityLbPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        localityLbPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * Check the LocalityLbPolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string locality_lb_policy = 131431487;</code>
     *
     * @param value The localityLbPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setLocalityLbPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      localityLbPolicy_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * Check the LocalityLbPolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string locality_lb_policy = 131431487;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalityLbPolicy() {
      localityLbPolicy_ = getDefaultInstance().getLocalityLbPolicy();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * Check the LocalityLbPolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string locality_lb_policy = 131431487;</code>
     *
     * @param value The bytes for localityLbPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setLocalityLbPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      localityLbPolicy_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BackendServiceLogConfig logConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceLogConfig,
            com.google.cloud.compute.v1.BackendServiceLogConfig.Builder,
            com.google.cloud.compute.v1.BackendServiceLogConfigOrBuilder>
        logConfigBuilder_;
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     *
     * @return Whether the logConfig field is set.
     */
    public boolean hasLogConfig() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     *
     * @return The logConfig.
     */
    public com.google.cloud.compute.v1.BackendServiceLogConfig getLogConfig() {
      if (logConfigBuilder_ == null) {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.BackendServiceLogConfig.getDefaultInstance()
            : logConfig_;
      } else {
        return logConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    public Builder setLogConfig(com.google.cloud.compute.v1.BackendServiceLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logConfig_ = value;
      } else {
        logConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    public Builder setLogConfig(
        com.google.cloud.compute.v1.BackendServiceLogConfig.Builder builderForValue) {
      if (logConfigBuilder_ == null) {
        logConfig_ = builderForValue.build();
      } else {
        logConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    public Builder mergeLogConfig(com.google.cloud.compute.v1.BackendServiceLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && logConfig_ != null
            && logConfig_
                != com.google.cloud.compute.v1.BackendServiceLogConfig.getDefaultInstance()) {
          getLogConfigBuilder().mergeFrom(value);
        } else {
          logConfig_ = value;
        }
      } else {
        logConfigBuilder_.mergeFrom(value);
      }
      if (logConfig_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    public Builder clearLogConfig() {
      bitField0_ = (bitField0_ & ~0x00800000);
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLogConfig.Builder getLogConfigBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getLogConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceLogConfigOrBuilder getLogConfigOrBuilder() {
      if (logConfigBuilder_ != null) {
        return logConfigBuilder_.getMessageOrBuilder();
      } else {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.BackendServiceLogConfig.getDefaultInstance()
            : logConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceLogConfig,
            com.google.cloud.compute.v1.BackendServiceLogConfig.Builder,
            com.google.cloud.compute.v1.BackendServiceLogConfigOrBuilder>
        getLogConfigFieldBuilder() {
      if (logConfigBuilder_ == null) {
        logConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceLogConfig,
                com.google.cloud.compute.v1.BackendServiceLogConfig.Builder,
                com.google.cloud.compute.v1.BackendServiceLogConfigOrBuilder>(
                getLogConfig(), getParentForChildren(), isClean());
        logConfig_ = null;
      }
      return logConfigBuilder_;
    }

    private com.google.cloud.compute.v1.Duration maxStreamDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        maxStreamDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     *
     * @return Whether the maxStreamDuration field is set.
     */
    public boolean hasMaxStreamDuration() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     *
     * @return The maxStreamDuration.
     */
    public com.google.cloud.compute.v1.Duration getMaxStreamDuration() {
      if (maxStreamDurationBuilder_ == null) {
        return maxStreamDuration_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : maxStreamDuration_;
      } else {
        return maxStreamDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder setMaxStreamDuration(com.google.cloud.compute.v1.Duration value) {
      if (maxStreamDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxStreamDuration_ = value;
      } else {
        maxStreamDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder setMaxStreamDuration(
        com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (maxStreamDurationBuilder_ == null) {
        maxStreamDuration_ = builderForValue.build();
      } else {
        maxStreamDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder mergeMaxStreamDuration(com.google.cloud.compute.v1.Duration value) {
      if (maxStreamDurationBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && maxStreamDuration_ != null
            && maxStreamDuration_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getMaxStreamDurationBuilder().mergeFrom(value);
        } else {
          maxStreamDuration_ = value;
        }
      } else {
        maxStreamDurationBuilder_.mergeFrom(value);
      }
      if (maxStreamDuration_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder clearMaxStreamDuration() {
      bitField0_ = (bitField0_ & ~0x01000000);
      maxStreamDuration_ = null;
      if (maxStreamDurationBuilder_ != null) {
        maxStreamDurationBuilder_.dispose();
        maxStreamDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getMaxStreamDurationBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getMaxStreamDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getMaxStreamDurationOrBuilder() {
      if (maxStreamDurationBuilder_ != null) {
        return maxStreamDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxStreamDuration_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : maxStreamDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getMaxStreamDurationFieldBuilder() {
      if (maxStreamDurationBuilder_ == null) {
        maxStreamDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getMaxStreamDuration(), getParentForChildren(), isClean());
        maxStreamDuration_ = null;
      }
      return maxStreamDurationBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadatas_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMetadatas() {
      if (metadatas_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadatasDefaultEntryHolder.defaultEntry);
      }
      return metadatas_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadatas() {
      if (metadatas_ == null) {
        metadatas_ =
            com.google.protobuf.MapField.newMapField(MetadatasDefaultEntryHolder.defaultEntry);
      }
      if (!metadatas_.isMutable()) {
        metadatas_ = metadatas_.copy();
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return metadatas_;
    }

    public int getMetadatasCount() {
      return internalGetMetadatas().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    @java.lang.Override
    public boolean containsMetadatas(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadatas().getMap().containsKey(key);
    }
    /** Use {@link #getMetadatasMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadatas() {
      return getMetadatasMap();
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadatasMap() {
      return internalGetMetadatas().getMap();
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadatasOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadatas().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadatasOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadatas().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadatas() {
      bitField0_ = (bitField0_ & ~0x02000000);
      internalGetMutableMetadatas().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    public Builder removeMetadatas(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadatas().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadatas() {
      bitField0_ |= 0x02000000;
      return internalGetMutableMetadatas().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    public Builder putMetadatas(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadatas().getMutableMap().put(key, value);
      bitField0_ |= 0x02000000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
     */
    public Builder putAllMetadatas(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadatas().getMutableMap().putAll(values);
      bitField0_ |= 0x02000000;
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.OutlierDetection outlierDetection_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.OutlierDetection,
            com.google.cloud.compute.v1.OutlierDetection.Builder,
            com.google.cloud.compute.v1.OutlierDetectionOrBuilder>
        outlierDetectionBuilder_;
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     *
     * @return Whether the outlierDetection field is set.
     */
    public boolean hasOutlierDetection() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     *
     * @return The outlierDetection.
     */
    public com.google.cloud.compute.v1.OutlierDetection getOutlierDetection() {
      if (outlierDetectionBuilder_ == null) {
        return outlierDetection_ == null
            ? com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance()
            : outlierDetection_;
      } else {
        return outlierDetectionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    public Builder setOutlierDetection(com.google.cloud.compute.v1.OutlierDetection value) {
      if (outlierDetectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outlierDetection_ = value;
      } else {
        outlierDetectionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    public Builder setOutlierDetection(
        com.google.cloud.compute.v1.OutlierDetection.Builder builderForValue) {
      if (outlierDetectionBuilder_ == null) {
        outlierDetection_ = builderForValue.build();
      } else {
        outlierDetectionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    public Builder mergeOutlierDetection(com.google.cloud.compute.v1.OutlierDetection value) {
      if (outlierDetectionBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && outlierDetection_ != null
            && outlierDetection_
                != com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance()) {
          getOutlierDetectionBuilder().mergeFrom(value);
        } else {
          outlierDetection_ = value;
        }
      } else {
        outlierDetectionBuilder_.mergeFrom(value);
      }
      if (outlierDetection_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    public Builder clearOutlierDetection() {
      bitField0_ = (bitField0_ & ~0x10000000);
      outlierDetection_ = null;
      if (outlierDetectionBuilder_ != null) {
        outlierDetectionBuilder_.dispose();
        outlierDetectionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    public com.google.cloud.compute.v1.OutlierDetection.Builder getOutlierDetectionBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getOutlierDetectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    public com.google.cloud.compute.v1.OutlierDetectionOrBuilder getOutlierDetectionOrBuilder() {
      if (outlierDetectionBuilder_ != null) {
        return outlierDetectionBuilder_.getMessageOrBuilder();
      } else {
        return outlierDetection_ == null
            ? com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance()
            : outlierDetection_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.OutlierDetection,
            com.google.cloud.compute.v1.OutlierDetection.Builder,
            com.google.cloud.compute.v1.OutlierDetectionOrBuilder>
        getOutlierDetectionFieldBuilder() {
      if (outlierDetectionBuilder_ == null) {
        outlierDetectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.OutlierDetection,
                com.google.cloud.compute.v1.OutlierDetection.Builder,
                com.google.cloud.compute.v1.OutlierDetectionOrBuilder>(
                getOutlierDetection(), getParentForChildren(), isClean());
        outlierDetection_ = null;
      }
      return outlierDetectionBuilder_;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return Whether the port field is set.
     */
    @java.lang.Override
    public boolean hasPort() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x20000000);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object portName_ = "";
    /**
     *
     *
     * <pre>
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return Whether the portName field is set.
     */
    public boolean hasPortName() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return The portName.
     */
    public java.lang.String getPortName() {
      java.lang.Object ref = portName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        portName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return The bytes for portName.
     */
    public com.google.protobuf.ByteString getPortNameBytes() {
      java.lang.Object ref = portName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        portName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @param value The portName to set.
     * @return This builder for chaining.
     */
    public Builder setPortName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      portName_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPortName() {
      portName_ = getDefaultInstance().getPortName();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @param value The bytes for portName to set.
     * @return This builder for chaining.
     */
    public Builder setPortNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      portName_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     * </pre>
     *
     * <code>optional string protocol = 84577944;</code>
     *
     * @return Whether the protocol field is set.
     */
    public boolean hasProtocol() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     * </pre>
     *
     * <code>optional string protocol = 84577944;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     * </pre>
     *
     * <code>optional string protocol = 84577944;</code>
     *
     * @return The bytes for protocol.
     */
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     * </pre>
     *
     * <code>optional string protocol = 84577944;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protocol_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     * </pre>
     *
     * <code>optional string protocol = 84577944;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {
      protocol_ = getDefaultInstance().getProtocol();
      bitField0_ = (bitField0_ & ~0x80000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     * </pre>
     *
     * <code>optional string protocol = 84577944;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protocol_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField1_ = (bitField1_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object securityPolicy_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return Whether the securityPolicy field is set.
     */
    public boolean hasSecurityPolicy() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return The securityPolicy.
     */
    public java.lang.String getSecurityPolicy() {
      java.lang.Object ref = securityPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        securityPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return The bytes for securityPolicy.
     */
    public com.google.protobuf.ByteString getSecurityPolicyBytes() {
      java.lang.Object ref = securityPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        securityPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @param value The securityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      securityPolicy_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecurityPolicy() {
      securityPolicy_ = getDefaultInstance().getSecurityPolicy();
      bitField1_ = (bitField1_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource URL for the security policy associated with this backend service.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @param value The bytes for securityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      securityPolicy_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecuritySettings securitySettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecuritySettings,
            com.google.cloud.compute.v1.SecuritySettings.Builder,
            com.google.cloud.compute.v1.SecuritySettingsOrBuilder>
        securitySettingsBuilder_;
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     *
     * @return Whether the securitySettings field is set.
     */
    public boolean hasSecuritySettings() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     *
     * @return The securitySettings.
     */
    public com.google.cloud.compute.v1.SecuritySettings getSecuritySettings() {
      if (securitySettingsBuilder_ == null) {
        return securitySettings_ == null
            ? com.google.cloud.compute.v1.SecuritySettings.getDefaultInstance()
            : securitySettings_;
      } else {
        return securitySettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    public Builder setSecuritySettings(com.google.cloud.compute.v1.SecuritySettings value) {
      if (securitySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securitySettings_ = value;
      } else {
        securitySettingsBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    public Builder setSecuritySettings(
        com.google.cloud.compute.v1.SecuritySettings.Builder builderForValue) {
      if (securitySettingsBuilder_ == null) {
        securitySettings_ = builderForValue.build();
      } else {
        securitySettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    public Builder mergeSecuritySettings(com.google.cloud.compute.v1.SecuritySettings value) {
      if (securitySettingsBuilder_ == null) {
        if (((bitField1_ & 0x00000004) != 0)
            && securitySettings_ != null
            && securitySettings_
                != com.google.cloud.compute.v1.SecuritySettings.getDefaultInstance()) {
          getSecuritySettingsBuilder().mergeFrom(value);
        } else {
          securitySettings_ = value;
        }
      } else {
        securitySettingsBuilder_.mergeFrom(value);
      }
      if (securitySettings_ != null) {
        bitField1_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    public Builder clearSecuritySettings() {
      bitField1_ = (bitField1_ & ~0x00000004);
      securitySettings_ = null;
      if (securitySettingsBuilder_ != null) {
        securitySettingsBuilder_.dispose();
        securitySettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    public com.google.cloud.compute.v1.SecuritySettings.Builder getSecuritySettingsBuilder() {
      bitField1_ |= 0x00000004;
      onChanged();
      return getSecuritySettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    public com.google.cloud.compute.v1.SecuritySettingsOrBuilder getSecuritySettingsOrBuilder() {
      if (securitySettingsBuilder_ != null) {
        return securitySettingsBuilder_.getMessageOrBuilder();
      } else {
        return securitySettings_ == null
            ? com.google.cloud.compute.v1.SecuritySettings.getDefaultInstance()
            : securitySettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecuritySettings,
            com.google.cloud.compute.v1.SecuritySettings.Builder,
            com.google.cloud.compute.v1.SecuritySettingsOrBuilder>
        getSecuritySettingsFieldBuilder() {
      if (securitySettingsBuilder_ == null) {
        securitySettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecuritySettings,
                com.google.cloud.compute.v1.SecuritySettings.Builder,
                com.google.cloud.compute.v1.SecuritySettingsOrBuilder>(
                getSecuritySettings(), getParentForChildren(), isClean());
        securitySettings_ = null;
      }
      return securitySettingsBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField1_ = (bitField1_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList serviceBindings_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServiceBindingsIsMutable() {
      if (!serviceBindings_.isModifiable()) {
        serviceBindings_ = new com.google.protobuf.LazyStringArrayList(serviceBindings_);
      }
      bitField1_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @return A list containing the serviceBindings.
     */
    public com.google.protobuf.ProtocolStringList getServiceBindingsList() {
      serviceBindings_.makeImmutable();
      return serviceBindings_;
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @return The count of serviceBindings.
     */
    public int getServiceBindingsCount() {
      return serviceBindings_.size();
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @param index The index of the element to return.
     * @return The serviceBindings at the given index.
     */
    public java.lang.String getServiceBindings(int index) {
      return serviceBindings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the serviceBindings at the given index.
     */
    public com.google.protobuf.ByteString getServiceBindingsBytes(int index) {
      return serviceBindings_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @param index The index to set the value at.
     * @param value The serviceBindings to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBindings(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceBindingsIsMutable();
      serviceBindings_.set(index, value);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @param value The serviceBindings to add.
     * @return This builder for chaining.
     */
    public Builder addServiceBindings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceBindingsIsMutable();
      serviceBindings_.add(value);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @param values The serviceBindings to add.
     * @return This builder for chaining.
     */
    public Builder addAllServiceBindings(java.lang.Iterable<java.lang.String> values) {
      ensureServiceBindingsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceBindings_);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceBindings() {
      serviceBindings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField1_ = (bitField1_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     * </pre>
     *
     * <code>repeated string service_bindings = 133581016;</code>
     *
     * @param value The bytes of the serviceBindings to add.
     * @return This builder for chaining.
     */
    public Builder addServiceBindingsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServiceBindingsIsMutable();
      serviceBindings_.add(value);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object serviceLbPolicy_ = "";
    /**
     *
     *
     * <pre>
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     * </pre>
     *
     * <code>optional string service_lb_policy = 94848785;</code>
     *
     * @return Whether the serviceLbPolicy field is set.
     */
    public boolean hasServiceLbPolicy() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     * </pre>
     *
     * <code>optional string service_lb_policy = 94848785;</code>
     *
     * @return The serviceLbPolicy.
     */
    public java.lang.String getServiceLbPolicy() {
      java.lang.Object ref = serviceLbPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceLbPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     * </pre>
     *
     * <code>optional string service_lb_policy = 94848785;</code>
     *
     * @return The bytes for serviceLbPolicy.
     */
    public com.google.protobuf.ByteString getServiceLbPolicyBytes() {
      java.lang.Object ref = serviceLbPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceLbPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     * </pre>
     *
     * <code>optional string service_lb_policy = 94848785;</code>
     *
     * @param value The serviceLbPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setServiceLbPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceLbPolicy_ = value;
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     * </pre>
     *
     * <code>optional string service_lb_policy = 94848785;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceLbPolicy() {
      serviceLbPolicy_ = getDefaultInstance().getServiceLbPolicy();
      bitField1_ = (bitField1_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     * </pre>
     *
     * <code>optional string service_lb_policy = 94848785;</code>
     *
     * @param value The bytes for serviceLbPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setServiceLbPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceLbPolicy_ = value;
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object sessionAffinity_ = "";
    /**
     *
     *
     * <pre>
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
     * Check the SessionAffinity enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_affinity = 463888561;</code>
     *
     * @return Whether the sessionAffinity field is set.
     */
    public boolean hasSessionAffinity() {
      return ((bitField1_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
     * Check the SessionAffinity enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_affinity = 463888561;</code>
     *
     * @return The sessionAffinity.
     */
    public java.lang.String getSessionAffinity() {
      java.lang.Object ref = sessionAffinity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionAffinity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
     * Check the SessionAffinity enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_affinity = 463888561;</code>
     *
     * @return The bytes for sessionAffinity.
     */
    public com.google.protobuf.ByteString getSessionAffinityBytes() {
      java.lang.Object ref = sessionAffinity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionAffinity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
     * Check the SessionAffinity enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_affinity = 463888561;</code>
     *
     * @param value The sessionAffinity to set.
     * @return This builder for chaining.
     */
    public Builder setSessionAffinity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sessionAffinity_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
     * Check the SessionAffinity enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_affinity = 463888561;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionAffinity() {
      sessionAffinity_ = getDefaultInstance().getSessionAffinity();
      bitField1_ = (bitField1_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
     * Check the SessionAffinity enum for the list of possible values.
     * </pre>
     *
     * <code>optional string session_affinity = 463888561;</code>
     *
     * @param value The bytes for sessionAffinity to set.
     * @return This builder for chaining.
     */
    public Builder setSessionAffinityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sessionAffinity_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Subsetting subsetting_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Subsetting,
            com.google.cloud.compute.v1.Subsetting.Builder,
            com.google.cloud.compute.v1.SubsettingOrBuilder>
        subsettingBuilder_;
    /**
     * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
     *
     * @return Whether the subsetting field is set.
     */
    public boolean hasSubsetting() {
      return ((bitField1_ & 0x00000080) != 0);
    }
    /**
     * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
     *
     * @return The subsetting.
     */
    public com.google.cloud.compute.v1.Subsetting getSubsetting() {
      if (subsettingBuilder_ == null) {
        return subsetting_ == null
            ? com.google.cloud.compute.v1.Subsetting.getDefaultInstance()
            : subsetting_;
      } else {
        return subsettingBuilder_.getMessage();
      }
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    public Builder setSubsetting(com.google.cloud.compute.v1.Subsetting value) {
      if (subsettingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subsetting_ = value;
      } else {
        subsettingBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    public Builder setSubsetting(com.google.cloud.compute.v1.Subsetting.Builder builderForValue) {
      if (subsettingBuilder_ == null) {
        subsetting_ = builderForValue.build();
      } else {
        subsettingBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    public Builder mergeSubsetting(com.google.cloud.compute.v1.Subsetting value) {
      if (subsettingBuilder_ == null) {
        if (((bitField1_ & 0x00000080) != 0)
            && subsetting_ != null
            && subsetting_ != com.google.cloud.compute.v1.Subsetting.getDefaultInstance()) {
          getSubsettingBuilder().mergeFrom(value);
        } else {
          subsetting_ = value;
        }
      } else {
        subsettingBuilder_.mergeFrom(value);
      }
      if (subsetting_ != null) {
        bitField1_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    public Builder clearSubsetting() {
      bitField1_ = (bitField1_ & ~0x00000080);
      subsetting_ = null;
      if (subsettingBuilder_ != null) {
        subsettingBuilder_.dispose();
        subsettingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    public com.google.cloud.compute.v1.Subsetting.Builder getSubsettingBuilder() {
      bitField1_ |= 0x00000080;
      onChanged();
      return getSubsettingFieldBuilder().getBuilder();
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    public com.google.cloud.compute.v1.SubsettingOrBuilder getSubsettingOrBuilder() {
      if (subsettingBuilder_ != null) {
        return subsettingBuilder_.getMessageOrBuilder();
      } else {
        return subsetting_ == null
            ? com.google.cloud.compute.v1.Subsetting.getDefaultInstance()
            : subsetting_;
      }
    }
    /** <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Subsetting,
            com.google.cloud.compute.v1.Subsetting.Builder,
            com.google.cloud.compute.v1.SubsettingOrBuilder>
        getSubsettingFieldBuilder() {
      if (subsettingBuilder_ == null) {
        subsettingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Subsetting,
                com.google.cloud.compute.v1.Subsetting.Builder,
                com.google.cloud.compute.v1.SubsettingOrBuilder>(
                getSubsetting(), getParentForChildren(), isClean());
        subsetting_ = null;
      }
      return subsettingBuilder_;
    }

    private int timeoutSec_;
    /**
     *
     *
     * <pre>
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @return Whether the timeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasTimeoutSec() {
      return ((bitField1_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @return The timeoutSec.
     */
    @java.lang.Override
    public int getTimeoutSec() {
      return timeoutSec_;
    }
    /**
     *
     *
     * <pre>
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @param value The timeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setTimeoutSec(int value) {

      timeoutSec_ = value;
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeoutSec() {
      bitField1_ = (bitField1_ & ~0x00000100);
      timeoutSec_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.BackendServiceUsedBy> usedBy_ =
        java.util.Collections.emptyList();

    private void ensureUsedByIsMutable() {
      if (!((bitField1_ & 0x00000200) != 0)) {
        usedBy_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.BackendServiceUsedBy>(usedBy_);
        bitField1_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceUsedBy,
            com.google.cloud.compute.v1.BackendServiceUsedBy.Builder,
            com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder>
        usedByBuilder_;

    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public java.util.List<com.google.cloud.compute.v1.BackendServiceUsedBy> getUsedByList() {
      if (usedByBuilder_ == null) {
        return java.util.Collections.unmodifiableList(usedBy_);
      } else {
        return usedByBuilder_.getMessageList();
      }
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public int getUsedByCount() {
      if (usedByBuilder_ == null) {
        return usedBy_.size();
      } else {
        return usedByBuilder_.getCount();
      }
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public com.google.cloud.compute.v1.BackendServiceUsedBy getUsedBy(int index) {
      if (usedByBuilder_ == null) {
        return usedBy_.get(index);
      } else {
        return usedByBuilder_.getMessage(index);
      }
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder setUsedBy(int index, com.google.cloud.compute.v1.BackendServiceUsedBy value) {
      if (usedByBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUsedByIsMutable();
        usedBy_.set(index, value);
        onChanged();
      } else {
        usedByBuilder_.setMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder setUsedBy(
        int index, com.google.cloud.compute.v1.BackendServiceUsedBy.Builder builderForValue) {
      if (usedByBuilder_ == null) {
        ensureUsedByIsMutable();
        usedBy_.set(index, builderForValue.build());
        onChanged();
      } else {
        usedByBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder addUsedBy(com.google.cloud.compute.v1.BackendServiceUsedBy value) {
      if (usedByBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUsedByIsMutable();
        usedBy_.add(value);
        onChanged();
      } else {
        usedByBuilder_.addMessage(value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder addUsedBy(int index, com.google.cloud.compute.v1.BackendServiceUsedBy value) {
      if (usedByBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUsedByIsMutable();
        usedBy_.add(index, value);
        onChanged();
      } else {
        usedByBuilder_.addMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder addUsedBy(
        com.google.cloud.compute.v1.BackendServiceUsedBy.Builder builderForValue) {
      if (usedByBuilder_ == null) {
        ensureUsedByIsMutable();
        usedBy_.add(builderForValue.build());
        onChanged();
      } else {
        usedByBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder addUsedBy(
        int index, com.google.cloud.compute.v1.BackendServiceUsedBy.Builder builderForValue) {
      if (usedByBuilder_ == null) {
        ensureUsedByIsMutable();
        usedBy_.add(index, builderForValue.build());
        onChanged();
      } else {
        usedByBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder addAllUsedBy(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.BackendServiceUsedBy> values) {
      if (usedByBuilder_ == null) {
        ensureUsedByIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, usedBy_);
        onChanged();
      } else {
        usedByBuilder_.addAllMessages(values);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder clearUsedBy() {
      if (usedByBuilder_ == null) {
        usedBy_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000200);
        onChanged();
      } else {
        usedByBuilder_.clear();
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public Builder removeUsedBy(int index) {
      if (usedByBuilder_ == null) {
        ensureUsedByIsMutable();
        usedBy_.remove(index);
        onChanged();
      } else {
        usedByBuilder_.remove(index);
      }
      return this;
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public com.google.cloud.compute.v1.BackendServiceUsedBy.Builder getUsedByBuilder(int index) {
      return getUsedByFieldBuilder().getBuilder(index);
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder getUsedByOrBuilder(int index) {
      if (usedByBuilder_ == null) {
        return usedBy_.get(index);
      } else {
        return usedByBuilder_.getMessageOrBuilder(index);
      }
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public java.util.List<? extends com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder>
        getUsedByOrBuilderList() {
      if (usedByBuilder_ != null) {
        return usedByBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(usedBy_);
      }
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public com.google.cloud.compute.v1.BackendServiceUsedBy.Builder addUsedByBuilder() {
      return getUsedByFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.BackendServiceUsedBy.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public com.google.cloud.compute.v1.BackendServiceUsedBy.Builder addUsedByBuilder(int index) {
      return getUsedByFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.BackendServiceUsedBy.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code> */
    public java.util.List<com.google.cloud.compute.v1.BackendServiceUsedBy.Builder>
        getUsedByBuilderList() {
      return getUsedByFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceUsedBy,
            com.google.cloud.compute.v1.BackendServiceUsedBy.Builder,
            com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder>
        getUsedByFieldBuilder() {
      if (usedByBuilder_ == null) {
        usedByBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceUsedBy,
                com.google.cloud.compute.v1.BackendServiceUsedBy.Builder,
                com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder>(
                usedBy_, ((bitField1_ & 0x00000200) != 0), getParentForChildren(), isClean());
        usedBy_ = null;
      }
      return usedByBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BackendService)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BackendService)
  private static final com.google.cloud.compute.v1.BackendService DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BackendService();
  }

  public static com.google.cloud.compute.v1.BackendService getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackendService> PARSER =
      new com.google.protobuf.AbstractParser<BackendService>() {
        @java.lang.Override
        public BackendService parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackendService> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackendService> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BackendService getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
