/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

public interface BfdStatusOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.BfdStatus)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * Check the BfdSessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bfd_session_initialization_mode = 218156954;</code>
   *
   * @return Whether the bfdSessionInitializationMode field is set.
   */
  boolean hasBfdSessionInitializationMode();
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * Check the BfdSessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bfd_session_initialization_mode = 218156954;</code>
   *
   * @return The bfdSessionInitializationMode.
   */
  java.lang.String getBfdSessionInitializationMode();
  /**
   *
   *
   * <pre>
   * The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
   * Check the BfdSessionInitializationMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bfd_session_initialization_mode = 218156954;</code>
   *
   * @return The bytes for bfdSessionInitializationMode.
   */
  com.google.protobuf.ByteString getBfdSessionInitializationModeBytes();

  /**
   *
   *
   * <pre>
   * Unix timestamp of the most recent config update.
   * </pre>
   *
   * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
   *
   * @return Whether the configUpdateTimestampMicros field is set.
   */
  boolean hasConfigUpdateTimestampMicros();
  /**
   *
   *
   * <pre>
   * Unix timestamp of the most recent config update.
   * </pre>
   *
   * <code>optional int64 config_update_timestamp_micros = 457195569;</code>
   *
   * @return The configUpdateTimestampMicros.
   */
  long getConfigUpdateTimestampMicros();

  /**
   *
   *
   * <pre>
   * Control packet counts for the current BFD session.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
   * </code>
   *
   * @return Whether the controlPacketCounts field is set.
   */
  boolean hasControlPacketCounts();
  /**
   *
   *
   * <pre>
   * Control packet counts for the current BFD session.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
   * </code>
   *
   * @return The controlPacketCounts.
   */
  com.google.cloud.compute.v1.BfdStatusPacketCounts getControlPacketCounts();
  /**
   *
   *
   * <pre>
   * Control packet counts for the current BFD session.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BfdStatusPacketCounts control_packet_counts = 132573561;
   * </code>
   */
  com.google.cloud.compute.v1.BfdStatusPacketCountsOrBuilder getControlPacketCountsOrBuilder();

  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  java.util.List<com.google.cloud.compute.v1.PacketIntervals> getControlPacketIntervalsList();
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  com.google.cloud.compute.v1.PacketIntervals getControlPacketIntervals(int index);
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  int getControlPacketIntervalsCount();
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.PacketIntervalsOrBuilder>
      getControlPacketIntervalsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Inter-packet time interval statistics for control packets.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PacketIntervals control_packet_intervals = 500806649;
   * </code>
   */
  com.google.cloud.compute.v1.PacketIntervalsOrBuilder getControlPacketIntervalsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the LocalDiagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_diagnostic = 463737083;</code>
   *
   * @return Whether the localDiagnostic field is set.
   */
  boolean hasLocalDiagnostic();
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the LocalDiagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_diagnostic = 463737083;</code>
   *
   * @return The localDiagnostic.
   */
  java.lang.String getLocalDiagnostic();
  /**
   *
   *
   * <pre>
   * The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
   * Check the LocalDiagnostic enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_diagnostic = 463737083;</code>
   *
   * @return The bytes for localDiagnostic.
   */
  com.google.protobuf.ByteString getLocalDiagnosticBytes();

  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the LocalState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_state = 149195453;</code>
   *
   * @return Whether the localState field is set.
   */
  boolean hasLocalState();
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the LocalState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_state = 149195453;</code>
   *
   * @return The localState.
   */
  java.lang.String getLocalState();
  /**
   *
   *
   * <pre>
   * The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
   * Check the LocalState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string local_state = 149195453;</code>
   *
   * @return The bytes for localState.
   */
  com.google.protobuf.ByteString getLocalStateBytes();

  /**
   *
   *
   * <pre>
   * Negotiated transmit interval for control packets.
   * </pre>
   *
   * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
   *
   * @return Whether the negotiatedLocalControlTxIntervalMs field is set.
   */
  boolean hasNegotiatedLocalControlTxIntervalMs();
  /**
   *
   *
   * <pre>
   * Negotiated transmit interval for control packets.
   * </pre>
   *
   * <code>optional uint32 negotiated_local_control_tx_interval_ms = 21768340;</code>
   *
   * @return The negotiatedLocalControlTxIntervalMs.
   */
  int getNegotiatedLocalControlTxIntervalMs();

  /**
   *
   *
   * <pre>
   * The most recent Rx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
   *
   * @return Whether the rxPacket field is set.
   */
  boolean hasRxPacket();
  /**
   *
   *
   * <pre>
   * The most recent Rx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
   *
   * @return The rxPacket.
   */
  com.google.cloud.compute.v1.BfdPacket getRxPacket();
  /**
   *
   *
   * <pre>
   * The most recent Rx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket rx_packet = 505069729;</code>
   */
  com.google.cloud.compute.v1.BfdPacketOrBuilder getRxPacketOrBuilder();

  /**
   *
   *
   * <pre>
   * The most recent Tx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
   *
   * @return Whether the txPacket field is set.
   */
  boolean hasTxPacket();
  /**
   *
   *
   * <pre>
   * The most recent Tx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
   *
   * @return The txPacket.
   */
  com.google.cloud.compute.v1.BfdPacket getTxPacket();
  /**
   *
   *
   * <pre>
   * The most recent Tx control packet for this BFD session.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BfdPacket tx_packet = 111386275;</code>
   */
  com.google.cloud.compute.v1.BfdPacketOrBuilder getTxPacketOrBuilder();

  /**
   *
   *
   * <pre>
   * Session uptime in milliseconds. Value will be 0 if session is not up.
   * </pre>
   *
   * <code>optional int64 uptime_ms = 125398365;</code>
   *
   * @return Whether the uptimeMs field is set.
   */
  boolean hasUptimeMs();
  /**
   *
   *
   * <pre>
   * Session uptime in milliseconds. Value will be 0 if session is not up.
   * </pre>
   *
   * <code>optional int64 uptime_ms = 125398365;</code>
   *
   * @return The uptimeMs.
   */
  long getUptimeMs();
}
