/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

public interface CommitmentOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.Commitment)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
   * </pre>
   *
   * <code>optional bool auto_renew = 495520765;</code>
   *
   * @return Whether the autoRenew field is set.
   */
  boolean hasAutoRenew();
  /**
   *
   *
   * <pre>
   * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
   * </pre>
   *
   * <code>optional bool auto_renew = 495520765;</code>
   *
   * @return The autoRenew.
   */
  boolean getAutoRenew();

  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return Whether the category field is set.
   */
  boolean hasCategory();
  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return The category.
   */
  java.lang.String getCategory();
  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return The bytes for category.
   */
  com.google.protobuf.ByteString getCategoryBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return Whether the endTimestamp field is set.
   */
  boolean hasEndTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return The endTimestamp.
   */
  java.lang.String getEndTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return The bytes for endTimestamp.
   */
  com.google.protobuf.ByteString getEndTimestampBytes();

  /**
   *
   *
   * <pre>
   * Specifies the already existing reservations to attach to the Commitment. This field is optional, and it can be a full or partial URL. For example, the following are valid URLs to an reservation: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /reservations/reservation - projects/project/zones/zone/reservations/reservation
   * </pre>
   *
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @return A list containing the existingReservations.
   */
  java.util.List<java.lang.String> getExistingReservationsList();
  /**
   *
   *
   * <pre>
   * Specifies the already existing reservations to attach to the Commitment. This field is optional, and it can be a full or partial URL. For example, the following are valid URLs to an reservation: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /reservations/reservation - projects/project/zones/zone/reservations/reservation
   * </pre>
   *
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @return The count of existingReservations.
   */
  int getExistingReservationsCount();
  /**
   *
   *
   * <pre>
   * Specifies the already existing reservations to attach to the Commitment. This field is optional, and it can be a full or partial URL. For example, the following are valid URLs to an reservation: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /reservations/reservation - projects/project/zones/zone/reservations/reservation
   * </pre>
   *
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @param index The index of the element to return.
   * @return The existingReservations at the given index.
   */
  java.lang.String getExistingReservations(int index);
  /**
   *
   *
   * <pre>
   * Specifies the already existing reservations to attach to the Commitment. This field is optional, and it can be a full or partial URL. For example, the following are valid URLs to an reservation: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /reservations/reservation - projects/project/zones/zone/reservations/reservation
   * </pre>
   *
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the existingReservations at the given index.
   */
  com.google.protobuf.ByteString getExistingReservationsBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   *
   * @return Whether the licenseResource field is set.
   */
  boolean hasLicenseResource();
  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   *
   * @return The licenseResource.
   */
  com.google.cloud.compute.v1.LicenseResourceCommitment getLicenseResource();
  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   */
  com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder getLicenseResourceOrBuilder();

  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @return A list containing the mergeSourceCommitments.
   */
  java.util.List<java.lang.String> getMergeSourceCommitmentsList();
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @return The count of mergeSourceCommitments.
   */
  int getMergeSourceCommitmentsCount();
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @param index The index of the element to return.
   * @return The mergeSourceCommitments at the given index.
   */
  java.lang.String getMergeSourceCommitments(int index);
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the mergeSourceCommitments at the given index.
   */
  com.google.protobuf.ByteString getMergeSourceCommitmentsBytes(int index);

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return Whether the plan field is set.
   */
  boolean hasPlan();
  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return The plan.
   */
  java.lang.String getPlan();
  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return The bytes for plan.
   */
  com.google.protobuf.ByteString getPlanBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where this commitment may be used.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  boolean hasRegion();
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where this commitment may be used.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  java.lang.String getRegion();
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where this commitment may be used.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  com.google.protobuf.ByteString getRegionBytes();

  /**
   *
   *
   * <pre>
   * List of create-on-create reservations for this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  java.util.List<com.google.cloud.compute.v1.Reservation> getReservationsList();
  /**
   *
   *
   * <pre>
   * List of create-on-create reservations for this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  com.google.cloud.compute.v1.Reservation getReservations(int index);
  /**
   *
   *
   * <pre>
   * List of create-on-create reservations for this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  int getReservationsCount();
  /**
   *
   *
   * <pre>
   * List of create-on-create reservations for this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.ReservationOrBuilder>
      getReservationsOrBuilderList();
  /**
   *
   *
   * <pre>
   * List of create-on-create reservations for this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  com.google.cloud.compute.v1.ReservationOrBuilder getReservationsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  java.util.List<com.google.cloud.compute.v1.ResourceCommitment> getResourcesList();
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  com.google.cloud.compute.v1.ResourceCommitment getResources(int index);
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  int getResourcesCount();
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>
      getResourcesOrBuilderList();
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  com.google.cloud.compute.v1.ResourceCommitmentOrBuilder getResourcesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * Source commitment to be split into a new commitment.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return Whether the splitSourceCommitment field is set.
   */
  boolean hasSplitSourceCommitment();
  /**
   *
   *
   * <pre>
   * Source commitment to be split into a new commitment.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return The splitSourceCommitment.
   */
  java.lang.String getSplitSourceCommitment();
  /**
   *
   *
   * <pre>
   * Source commitment to be split into a new commitment.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return The bytes for splitSourceCommitment.
   */
  com.google.protobuf.ByteString getSplitSourceCommitmentBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return Whether the startTimestamp field is set.
   */
  boolean hasStartTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return The startTimestamp.
   */
  java.lang.String getStartTimestamp();
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return The bytes for startTimestamp.
   */
  com.google.protobuf.ByteString getStartTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();
  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  java.lang.String getStatus();
  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  com.google.protobuf.ByteString getStatusBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  boolean hasStatusMessage();
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  java.lang.String getStatusMessage();
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  com.google.protobuf.ByteString getStatusMessageBytes();

  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  boolean hasType();
  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();
}
