/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HealthStatus}
 */
public final class HealthStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HealthStatus)
    HealthStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HealthStatus.newBuilder() to construct.
  private HealthStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HealthStatus() {
    forwardingRule_ = "";
    forwardingRuleIp_ = "";
    healthState_ = "";
    instance_ = "";
    ipAddress_ = "";
    weight_ = "";
    weightError_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HealthStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HealthStatus_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 112032548:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HealthStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HealthStatus.class,
            com.google.cloud.compute.v1.HealthStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Health state of the IPv4 address of the instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.HealthStatus.HealthState}
   */
  public enum HealthState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_HEALTH_STATE = 0;</code>
     */
    UNDEFINED_HEALTH_STATE(0),
    /** <code>HEALTHY = 439801213;</code> */
    HEALTHY(439801213),
    /** <code>UNHEALTHY = 462118084;</code> */
    UNHEALTHY(462118084),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_HEALTH_STATE = 0;</code>
     */
    public static final int UNDEFINED_HEALTH_STATE_VALUE = 0;
    /** <code>HEALTHY = 439801213;</code> */
    public static final int HEALTHY_VALUE = 439801213;
    /** <code>UNHEALTHY = 462118084;</code> */
    public static final int UNHEALTHY_VALUE = 462118084;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HealthState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HealthState forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_HEALTH_STATE;
        case 439801213:
          return HEALTHY;
        case 462118084:
          return UNHEALTHY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HealthState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HealthState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<HealthState>() {
          public HealthState findValueByNumber(int number) {
            return HealthState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.HealthStatus.getDescriptor().getEnumTypes().get(0);
    }

    private static final HealthState[] VALUES = values();

    public static HealthState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HealthState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.HealthStatus.HealthState)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.HealthStatus.WeightError}
   */
  public enum WeightError implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_WEIGHT_ERROR = 0;</code>
     */
    UNDEFINED_WEIGHT_ERROR(0),
    /**
     *
     *
     * <pre>
     * The response to a Health Check probe had the HTTP response header field X-Load-Balancing-Endpoint-Weight, but its content was invalid (i.e., not a non-negative single-precision floating-point number in decimal string representation).
     * </pre>
     *
     * <code>INVALID_WEIGHT = 383698400;</code>
     */
    INVALID_WEIGHT(383698400),
    /**
     *
     *
     * <pre>
     * The response to a Health Check probe did not have the HTTP response header field X-Load-Balancing-Endpoint-Weight.
     * </pre>
     *
     * <code>MISSING_WEIGHT = 384027537;</code>
     */
    MISSING_WEIGHT(384027537),
    /**
     *
     *
     * <pre>
     * This is the value when the accompanied health status is either TIMEOUT (i.e.,the Health Check probe was not able to get a response in time) or UNKNOWN. For the latter, it should be typically because there has not been sufficient time to parse and report the weight for a new backend (which is with 0.0.0.0 ip address). However, it can be also due to an outage case for which the health status is explicitly reset to UNKNOWN.
     * </pre>
     *
     * <code>UNAVAILABLE_WEIGHT = 439464295;</code>
     */
    UNAVAILABLE_WEIGHT(439464295),
    /**
     *
     *
     * <pre>
     * This is the default value when WeightReportMode is DISABLE, and is also the initial value when WeightReportMode has just updated to ENABLE or DRY_RUN and there has not been sufficient time to parse and report the backend weight.
     * </pre>
     *
     * <code>WEIGHT_NONE = 502428831;</code>
     */
    WEIGHT_NONE(502428831),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_WEIGHT_ERROR = 0;</code>
     */
    public static final int UNDEFINED_WEIGHT_ERROR_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The response to a Health Check probe had the HTTP response header field X-Load-Balancing-Endpoint-Weight, but its content was invalid (i.e., not a non-negative single-precision floating-point number in decimal string representation).
     * </pre>
     *
     * <code>INVALID_WEIGHT = 383698400;</code>
     */
    public static final int INVALID_WEIGHT_VALUE = 383698400;
    /**
     *
     *
     * <pre>
     * The response to a Health Check probe did not have the HTTP response header field X-Load-Balancing-Endpoint-Weight.
     * </pre>
     *
     * <code>MISSING_WEIGHT = 384027537;</code>
     */
    public static final int MISSING_WEIGHT_VALUE = 384027537;
    /**
     *
     *
     * <pre>
     * This is the value when the accompanied health status is either TIMEOUT (i.e.,the Health Check probe was not able to get a response in time) or UNKNOWN. For the latter, it should be typically because there has not been sufficient time to parse and report the weight for a new backend (which is with 0.0.0.0 ip address). However, it can be also due to an outage case for which the health status is explicitly reset to UNKNOWN.
     * </pre>
     *
     * <code>UNAVAILABLE_WEIGHT = 439464295;</code>
     */
    public static final int UNAVAILABLE_WEIGHT_VALUE = 439464295;
    /**
     *
     *
     * <pre>
     * This is the default value when WeightReportMode is DISABLE, and is also the initial value when WeightReportMode has just updated to ENABLE or DRY_RUN and there has not been sufficient time to parse and report the backend weight.
     * </pre>
     *
     * <code>WEIGHT_NONE = 502428831;</code>
     */
    public static final int WEIGHT_NONE_VALUE = 502428831;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WeightError valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static WeightError forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_WEIGHT_ERROR;
        case 383698400:
          return INVALID_WEIGHT;
        case 384027537:
          return MISSING_WEIGHT;
        case 439464295:
          return UNAVAILABLE_WEIGHT;
        case 502428831:
          return WEIGHT_NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<WeightError> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<WeightError> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<WeightError>() {
          public WeightError findValueByNumber(int number) {
            return WeightError.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.HealthStatus.getDescriptor().getEnumTypes().get(1);
    }

    private static final WeightError[] VALUES = values();

    public static WeightError valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private WeightError(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.HealthStatus.WeightError)
  }

  private int bitField0_;
  public static final int ANNOTATIONS_FIELD_NUMBER = 112032548;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_HealthStatus_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Metadata defined as annotations for network endpoint.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Metadata defined as annotations for network endpoint.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Metadata defined as annotations for network endpoint.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Metadata defined as annotations for network endpoint.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FORWARDING_RULE_FIELD_NUMBER = 269964030;

  @SuppressWarnings("serial")
  private volatile java.lang.Object forwardingRule_ = "";
  /**
   *
   *
   * <pre>
   * URL of the forwarding rule associated with the health status of the instance.
   * </pre>
   *
   * <code>optional string forwarding_rule = 269964030;</code>
   *
   * @return Whether the forwardingRule field is set.
   */
  @java.lang.Override
  public boolean hasForwardingRule() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the forwarding rule associated with the health status of the instance.
   * </pre>
   *
   * <code>optional string forwarding_rule = 269964030;</code>
   *
   * @return The forwardingRule.
   */
  @java.lang.Override
  public java.lang.String getForwardingRule() {
    java.lang.Object ref = forwardingRule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      forwardingRule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the forwarding rule associated with the health status of the instance.
   * </pre>
   *
   * <code>optional string forwarding_rule = 269964030;</code>
   *
   * @return The bytes for forwardingRule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getForwardingRuleBytes() {
    java.lang.Object ref = forwardingRule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      forwardingRule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORWARDING_RULE_IP_FIELD_NUMBER = 172250632;

  @SuppressWarnings("serial")
  private volatile java.lang.Object forwardingRuleIp_ = "";
  /**
   *
   *
   * <pre>
   * A forwarding rule IP address assigned to this instance.
   * </pre>
   *
   * <code>optional string forwarding_rule_ip = 172250632;</code>
   *
   * @return Whether the forwardingRuleIp field is set.
   */
  @java.lang.Override
  public boolean hasForwardingRuleIp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A forwarding rule IP address assigned to this instance.
   * </pre>
   *
   * <code>optional string forwarding_rule_ip = 172250632;</code>
   *
   * @return The forwardingRuleIp.
   */
  @java.lang.Override
  public java.lang.String getForwardingRuleIp() {
    java.lang.Object ref = forwardingRuleIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      forwardingRuleIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A forwarding rule IP address assigned to this instance.
   * </pre>
   *
   * <code>optional string forwarding_rule_ip = 172250632;</code>
   *
   * @return The bytes for forwardingRuleIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getForwardingRuleIpBytes() {
    java.lang.Object ref = forwardingRuleIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      forwardingRuleIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_STATE_FIELD_NUMBER = 324007150;

  @SuppressWarnings("serial")
  private volatile java.lang.Object healthState_ = "";
  /**
   *
   *
   * <pre>
   * Health state of the IPv4 address of the instance.
   * Check the HealthState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_state = 324007150;</code>
   *
   * @return Whether the healthState field is set.
   */
  @java.lang.Override
  public boolean hasHealthState() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Health state of the IPv4 address of the instance.
   * Check the HealthState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_state = 324007150;</code>
   *
   * @return The healthState.
   */
  @java.lang.Override
  public java.lang.String getHealthState() {
    java.lang.Object ref = healthState_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthState_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Health state of the IPv4 address of the instance.
   * Check the HealthState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string health_state = 324007150;</code>
   *
   * @return The bytes for healthState.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthStateBytes() {
    java.lang.Object ref = healthState_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthState_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 18257045;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";
  /**
   *
   *
   * <pre>
   * URL of the instance resource.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the instance resource.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the instance resource.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 406272220;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipAddress_ = "";
  /**
   *
   *
   * <pre>
   * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return Whether the ipAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpAddress() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 3446913;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * The named port of the instance group, not necessarily the port that is health-checked.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return Whether the port field is set.
   */
  @java.lang.Override
  public boolean hasPort() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The named port of the instance group, not necessarily the port that is health-checked.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int WEIGHT_FIELD_NUMBER = 282149496;

  @SuppressWarnings("serial")
  private volatile java.lang.Object weight_ = "";
  /**
   * <code>optional string weight = 282149496;</code>
   *
   * @return Whether the weight field is set.
   */
  @java.lang.Override
  public boolean hasWeight() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <code>optional string weight = 282149496;</code>
   *
   * @return The weight.
   */
  @java.lang.Override
  public java.lang.String getWeight() {
    java.lang.Object ref = weight_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      weight_ = s;
      return s;
    }
  }
  /**
   * <code>optional string weight = 282149496;</code>
   *
   * @return The bytes for weight.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWeightBytes() {
    java.lang.Object ref = weight_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      weight_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEIGHT_ERROR_FIELD_NUMBER = 522501505;

  @SuppressWarnings("serial")
  private volatile java.lang.Object weightError_ = "";
  /**
   *
   *
   * <pre>
   *
   * Check the WeightError enum for the list of possible values.
   * </pre>
   *
   * <code>optional string weight_error = 522501505;</code>
   *
   * @return Whether the weightError field is set.
   */
  @java.lang.Override
  public boolean hasWeightError() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   *
   * Check the WeightError enum for the list of possible values.
   * </pre>
   *
   * <code>optional string weight_error = 522501505;</code>
   *
   * @return The weightError.
   */
  @java.lang.Override
  public java.lang.String getWeightError() {
    java.lang.Object ref = weightError_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      weightError_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   *
   * Check the WeightError enum for the list of possible values.
   * </pre>
   *
   * <code>optional string weight_error = 522501505;</code>
   *
   * @return The bytes for weightError.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWeightErrorBytes() {
    java.lang.Object ref = weightError_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      weightError_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt32(3446913, port_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18257045, instance_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 112032548);
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 172250632, forwardingRuleIp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 269964030, forwardingRule_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 282149496, weight_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 324007150, healthState_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 406272220, ipAddress_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 522501505, weightError_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3446913, port_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18257045, instance_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(112032548, annotations__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(172250632, forwardingRuleIp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(269964030, forwardingRule_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(282149496, weight_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(324007150, healthState_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(406272220, ipAddress_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(522501505, weightError_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HealthStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HealthStatus other = (com.google.cloud.compute.v1.HealthStatus) obj;

    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasForwardingRule() != other.hasForwardingRule()) return false;
    if (hasForwardingRule()) {
      if (!getForwardingRule().equals(other.getForwardingRule())) return false;
    }
    if (hasForwardingRuleIp() != other.hasForwardingRuleIp()) return false;
    if (hasForwardingRuleIp()) {
      if (!getForwardingRuleIp().equals(other.getForwardingRuleIp())) return false;
    }
    if (hasHealthState() != other.hasHealthState()) return false;
    if (hasHealthState()) {
      if (!getHealthState().equals(other.getHealthState())) return false;
    }
    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (hasIpAddress() != other.hasIpAddress()) return false;
    if (hasIpAddress()) {
      if (!getIpAddress().equals(other.getIpAddress())) return false;
    }
    if (hasPort() != other.hasPort()) return false;
    if (hasPort()) {
      if (getPort() != other.getPort()) return false;
    }
    if (hasWeight() != other.hasWeight()) return false;
    if (hasWeight()) {
      if (!getWeight().equals(other.getWeight())) return false;
    }
    if (hasWeightError() != other.hasWeightError()) return false;
    if (hasWeightError()) {
      if (!getWeightError().equals(other.getWeightError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasForwardingRule()) {
      hash = (37 * hash) + FORWARDING_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getForwardingRule().hashCode();
    }
    if (hasForwardingRuleIp()) {
      hash = (37 * hash) + FORWARDING_RULE_IP_FIELD_NUMBER;
      hash = (53 * hash) + getForwardingRuleIp().hashCode();
    }
    if (hasHealthState()) {
      hash = (37 * hash) + HEALTH_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getHealthState().hashCode();
    }
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    if (hasIpAddress()) {
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
    }
    if (hasPort()) {
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
    }
    if (hasWeight()) {
      hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getWeight().hashCode();
    }
    if (hasWeightError()) {
      hash = (37 * hash) + WEIGHT_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getWeightError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HealthStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HealthStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HealthStatus)
      com.google.cloud.compute.v1.HealthStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthStatus_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 112032548:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 112032548:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HealthStatus.class,
              com.google.cloud.compute.v1.HealthStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HealthStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableAnnotations().clear();
      forwardingRule_ = "";
      forwardingRuleIp_ = "";
      healthState_ = "";
      instance_ = "";
      ipAddress_ = "";
      port_ = 0;
      weight_ = "";
      weightError_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HealthStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthStatus build() {
      com.google.cloud.compute.v1.HealthStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthStatus buildPartial() {
      com.google.cloud.compute.v1.HealthStatus result =
          new com.google.cloud.compute.v1.HealthStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.HealthStatus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.forwardingRule_ = forwardingRule_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.forwardingRuleIp_ = forwardingRuleIp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.healthState_ = healthState_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.instance_ = instance_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ipAddress_ = ipAddress_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.port_ = port_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.weight_ = weight_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.weightError_ = weightError_;
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HealthStatus) {
        return mergeFrom((com.google.cloud.compute.v1.HealthStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HealthStatus other) {
      if (other == com.google.cloud.compute.v1.HealthStatus.getDefaultInstance()) return this;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000001;
      if (other.hasForwardingRule()) {
        forwardingRule_ = other.forwardingRule_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasForwardingRuleIp()) {
        forwardingRuleIp_ = other.forwardingRuleIp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasHealthState()) {
        healthState_ = other.healthState_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasInstance()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasIpAddress()) {
        ipAddress_ = other.ipAddress_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasPort()) {
        setPort(other.getPort());
      }
      if (other.hasWeight()) {
        weight_ = other.weight_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasWeightError()) {
        weightError_ = other.weightError_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 27575304:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 27575304
            case 146056362:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 146056362
            case 896260386:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 896260386
            case 1378005058:
              {
                forwardingRuleIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1378005058
            case -2135255054:
              {
                forwardingRule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -2135255054
            case -2037771326:
              {
                weight_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -2037771326
            case -1702910094:
              {
                healthState_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1702910094
            case -1044789534:
              {
                ipAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -1044789534
            case -114955254:
              {
                weightError_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -114955254
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000001;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata defined as annotations for network endpoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private java.lang.Object forwardingRule_ = "";
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health status of the instance.
     * </pre>
     *
     * <code>optional string forwarding_rule = 269964030;</code>
     *
     * @return Whether the forwardingRule field is set.
     */
    public boolean hasForwardingRule() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health status of the instance.
     * </pre>
     *
     * <code>optional string forwarding_rule = 269964030;</code>
     *
     * @return The forwardingRule.
     */
    public java.lang.String getForwardingRule() {
      java.lang.Object ref = forwardingRule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        forwardingRule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health status of the instance.
     * </pre>
     *
     * <code>optional string forwarding_rule = 269964030;</code>
     *
     * @return The bytes for forwardingRule.
     */
    public com.google.protobuf.ByteString getForwardingRuleBytes() {
      java.lang.Object ref = forwardingRule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        forwardingRule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health status of the instance.
     * </pre>
     *
     * <code>optional string forwarding_rule = 269964030;</code>
     *
     * @param value The forwardingRule to set.
     * @return This builder for chaining.
     */
    public Builder setForwardingRule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      forwardingRule_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health status of the instance.
     * </pre>
     *
     * <code>optional string forwarding_rule = 269964030;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForwardingRule() {
      forwardingRule_ = getDefaultInstance().getForwardingRule();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the forwarding rule associated with the health status of the instance.
     * </pre>
     *
     * <code>optional string forwarding_rule = 269964030;</code>
     *
     * @param value The bytes for forwardingRule to set.
     * @return This builder for chaining.
     */
    public Builder setForwardingRuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      forwardingRule_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object forwardingRuleIp_ = "";
    /**
     *
     *
     * <pre>
     * A forwarding rule IP address assigned to this instance.
     * </pre>
     *
     * <code>optional string forwarding_rule_ip = 172250632;</code>
     *
     * @return Whether the forwardingRuleIp field is set.
     */
    public boolean hasForwardingRuleIp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * A forwarding rule IP address assigned to this instance.
     * </pre>
     *
     * <code>optional string forwarding_rule_ip = 172250632;</code>
     *
     * @return The forwardingRuleIp.
     */
    public java.lang.String getForwardingRuleIp() {
      java.lang.Object ref = forwardingRuleIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        forwardingRuleIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A forwarding rule IP address assigned to this instance.
     * </pre>
     *
     * <code>optional string forwarding_rule_ip = 172250632;</code>
     *
     * @return The bytes for forwardingRuleIp.
     */
    public com.google.protobuf.ByteString getForwardingRuleIpBytes() {
      java.lang.Object ref = forwardingRuleIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        forwardingRuleIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A forwarding rule IP address assigned to this instance.
     * </pre>
     *
     * <code>optional string forwarding_rule_ip = 172250632;</code>
     *
     * @param value The forwardingRuleIp to set.
     * @return This builder for chaining.
     */
    public Builder setForwardingRuleIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      forwardingRuleIp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A forwarding rule IP address assigned to this instance.
     * </pre>
     *
     * <code>optional string forwarding_rule_ip = 172250632;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForwardingRuleIp() {
      forwardingRuleIp_ = getDefaultInstance().getForwardingRuleIp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A forwarding rule IP address assigned to this instance.
     * </pre>
     *
     * <code>optional string forwarding_rule_ip = 172250632;</code>
     *
     * @param value The bytes for forwardingRuleIp to set.
     * @return This builder for chaining.
     */
    public Builder setForwardingRuleIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      forwardingRuleIp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object healthState_ = "";
    /**
     *
     *
     * <pre>
     * Health state of the IPv4 address of the instance.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return Whether the healthState field is set.
     */
    public boolean hasHealthState() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Health state of the IPv4 address of the instance.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return The healthState.
     */
    public java.lang.String getHealthState() {
      java.lang.Object ref = healthState_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthState_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Health state of the IPv4 address of the instance.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return The bytes for healthState.
     */
    public com.google.protobuf.ByteString getHealthStateBytes() {
      java.lang.Object ref = healthState_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Health state of the IPv4 address of the instance.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @param value The healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      healthState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Health state of the IPv4 address of the instance.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthState() {
      healthState_ = getDefaultInstance().getHealthState();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Health state of the IPv4 address of the instance.
     * Check the HealthState enum for the list of possible values.
     * </pre>
     *
     * <code>optional string health_state = 324007150;</code>
     *
     * @param value The bytes for healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      healthState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * URL of the instance resource.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return Whether the instance field is set.
     */
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the instance resource.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the instance resource.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the instance resource.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the instance resource.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the instance resource.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object ipAddress_ = "";
    /**
     *
     *
     * <pre>
     * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return Whether the ipAddress field is set.
     */
    public boolean hasIpAddress() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipAddress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {
      ipAddress_ = getDefaultInstance().getIpAddress();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipAddress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * The named port of the instance group, not necessarily the port that is health-checked.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return Whether the port field is set.
     */
    @java.lang.Override
    public boolean hasPort() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The named port of the instance group, not necessarily the port that is health-checked.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * The named port of the instance group, not necessarily the port that is health-checked.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The named port of the instance group, not necessarily the port that is health-checked.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000040);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object weight_ = "";
    /**
     * <code>optional string weight = 282149496;</code>
     *
     * @return Whether the weight field is set.
     */
    public boolean hasWeight() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional string weight = 282149496;</code>
     *
     * @return The weight.
     */
    public java.lang.String getWeight() {
      java.lang.Object ref = weight_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        weight_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string weight = 282149496;</code>
     *
     * @return The bytes for weight.
     */
    public com.google.protobuf.ByteString getWeightBytes() {
      java.lang.Object ref = weight_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        weight_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string weight = 282149496;</code>
     *
     * @param value The weight to set.
     * @return This builder for chaining.
     */
    public Builder setWeight(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      weight_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <code>optional string weight = 282149496;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWeight() {
      weight_ = getDefaultInstance().getWeight();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <code>optional string weight = 282149496;</code>
     *
     * @param value The bytes for weight to set.
     * @return This builder for chaining.
     */
    public Builder setWeightBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      weight_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object weightError_ = "";
    /**
     *
     *
     * <pre>
     *
     * Check the WeightError enum for the list of possible values.
     * </pre>
     *
     * <code>optional string weight_error = 522501505;</code>
     *
     * @return Whether the weightError field is set.
     */
    public boolean hasWeightError() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     *
     * Check the WeightError enum for the list of possible values.
     * </pre>
     *
     * <code>optional string weight_error = 522501505;</code>
     *
     * @return The weightError.
     */
    public java.lang.String getWeightError() {
      java.lang.Object ref = weightError_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        weightError_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the WeightError enum for the list of possible values.
     * </pre>
     *
     * <code>optional string weight_error = 522501505;</code>
     *
     * @return The bytes for weightError.
     */
    public com.google.protobuf.ByteString getWeightErrorBytes() {
      java.lang.Object ref = weightError_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        weightError_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the WeightError enum for the list of possible values.
     * </pre>
     *
     * <code>optional string weight_error = 522501505;</code>
     *
     * @param value The weightError to set.
     * @return This builder for chaining.
     */
    public Builder setWeightError(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      weightError_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the WeightError enum for the list of possible values.
     * </pre>
     *
     * <code>optional string weight_error = 522501505;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWeightError() {
      weightError_ = getDefaultInstance().getWeightError();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the WeightError enum for the list of possible values.
     * </pre>
     *
     * <code>optional string weight_error = 522501505;</code>
     *
     * @param value The bytes for weightError to set.
     * @return This builder for chaining.
     */
    public Builder setWeightErrorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      weightError_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HealthStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HealthStatus)
  private static final com.google.cloud.compute.v1.HealthStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HealthStatus();
  }

  public static com.google.cloud.compute.v1.HealthStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HealthStatus> PARSER =
      new com.google.protobuf.AbstractParser<HealthStatus>() {
        @java.lang.Override
        public HealthStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HealthStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HealthStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HealthStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
