/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Specifies settings for an HTTP redirect.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HttpRedirectAction}
 */
public final class HttpRedirectAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HttpRedirectAction)
    HttpRedirectActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpRedirectAction.newBuilder() to construct.
  private HttpRedirectAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRedirectAction() {
    hostRedirect_ = "";
    pathRedirect_ = "";
    prefixRedirect_ = "";
    redirectResponseCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRedirectAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRedirectAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRedirectAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HttpRedirectAction.class,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.HttpRedirectAction.RedirectResponseCode}
   */
  public enum RedirectResponseCode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REDIRECT_RESPONSE_CODE = 0;</code>
     */
    UNDEFINED_REDIRECT_RESPONSE_CODE(0),
    /**
     *
     *
     * <pre>
     * Http Status Code 302 - Found.
     * </pre>
     *
     * <code>FOUND = 67084130;</code>
     */
    FOUND(67084130),
    /**
     *
     *
     * <pre>
     * Http Status Code 301 - Moved Permanently.
     * </pre>
     *
     * <code>MOVED_PERMANENTLY_DEFAULT = 386698449;</code>
     */
    MOVED_PERMANENTLY_DEFAULT(386698449),
    /**
     *
     *
     * <pre>
     * Http Status Code 308 - Permanent Redirect maintaining HTTP method.
     * </pre>
     *
     * <code>PERMANENT_REDIRECT = 382006381;</code>
     */
    PERMANENT_REDIRECT(382006381),
    /**
     *
     *
     * <pre>
     * Http Status Code 303 - See Other.
     * </pre>
     *
     * <code>SEE_OTHER = 445380580;</code>
     */
    SEE_OTHER(445380580),
    /**
     *
     *
     * <pre>
     * Http Status Code 307 - Temporary Redirect maintaining HTTP method.
     * </pre>
     *
     * <code>TEMPORARY_REDIRECT = 489550378;</code>
     */
    TEMPORARY_REDIRECT(489550378),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REDIRECT_RESPONSE_CODE = 0;</code>
     */
    public static final int UNDEFINED_REDIRECT_RESPONSE_CODE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Http Status Code 302 - Found.
     * </pre>
     *
     * <code>FOUND = 67084130;</code>
     */
    public static final int FOUND_VALUE = 67084130;
    /**
     *
     *
     * <pre>
     * Http Status Code 301 - Moved Permanently.
     * </pre>
     *
     * <code>MOVED_PERMANENTLY_DEFAULT = 386698449;</code>
     */
    public static final int MOVED_PERMANENTLY_DEFAULT_VALUE = 386698449;
    /**
     *
     *
     * <pre>
     * Http Status Code 308 - Permanent Redirect maintaining HTTP method.
     * </pre>
     *
     * <code>PERMANENT_REDIRECT = 382006381;</code>
     */
    public static final int PERMANENT_REDIRECT_VALUE = 382006381;
    /**
     *
     *
     * <pre>
     * Http Status Code 303 - See Other.
     * </pre>
     *
     * <code>SEE_OTHER = 445380580;</code>
     */
    public static final int SEE_OTHER_VALUE = 445380580;
    /**
     *
     *
     * <pre>
     * Http Status Code 307 - Temporary Redirect maintaining HTTP method.
     * </pre>
     *
     * <code>TEMPORARY_REDIRECT = 489550378;</code>
     */
    public static final int TEMPORARY_REDIRECT_VALUE = 489550378;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RedirectResponseCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RedirectResponseCode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_REDIRECT_RESPONSE_CODE;
        case 67084130:
          return FOUND;
        case 386698449:
          return MOVED_PERMANENTLY_DEFAULT;
        case 382006381:
          return PERMANENT_REDIRECT;
        case 445380580:
          return SEE_OTHER;
        case 489550378:
          return TEMPORARY_REDIRECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RedirectResponseCode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RedirectResponseCode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RedirectResponseCode>() {
              public RedirectResponseCode findValueByNumber(int number) {
                return RedirectResponseCode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.HttpRedirectAction.getDescriptor().getEnumTypes().get(0);
    }

    private static final RedirectResponseCode[] VALUES = values();

    public static RedirectResponseCode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RedirectResponseCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.HttpRedirectAction.RedirectResponseCode)
  }

  private int bitField0_;
  public static final int HOST_REDIRECT_FIELD_NUMBER = 107417747;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostRedirect_ = "";
  /**
   *
   *
   * <pre>
   * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
   * </pre>
   *
   * <code>optional string host_redirect = 107417747;</code>
   *
   * @return Whether the hostRedirect field is set.
   */
  @java.lang.Override
  public boolean hasHostRedirect() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
   * </pre>
   *
   * <code>optional string host_redirect = 107417747;</code>
   *
   * @return The hostRedirect.
   */
  @java.lang.Override
  public java.lang.String getHostRedirect() {
    java.lang.Object ref = hostRedirect_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostRedirect_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
   * </pre>
   *
   * <code>optional string host_redirect = 107417747;</code>
   *
   * @return The bytes for hostRedirect.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostRedirectBytes() {
    java.lang.Object ref = hostRedirect_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostRedirect_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTPS_REDIRECT_FIELD_NUMBER = 170260656;
  private boolean httpsRedirect_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
   * </pre>
   *
   * <code>optional bool https_redirect = 170260656;</code>
   *
   * @return Whether the httpsRedirect field is set.
   */
  @java.lang.Override
  public boolean hasHttpsRedirect() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
   * </pre>
   *
   * <code>optional bool https_redirect = 170260656;</code>
   *
   * @return The httpsRedirect.
   */
  @java.lang.Override
  public boolean getHttpsRedirect() {
    return httpsRedirect_;
  }

  public static final int PATH_REDIRECT_FIELD_NUMBER = 272342710;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pathRedirect_ = "";
  /**
   *
   *
   * <pre>
   * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
   * </pre>
   *
   * <code>optional string path_redirect = 272342710;</code>
   *
   * @return Whether the pathRedirect field is set.
   */
  @java.lang.Override
  public boolean hasPathRedirect() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
   * </pre>
   *
   * <code>optional string path_redirect = 272342710;</code>
   *
   * @return The pathRedirect.
   */
  @java.lang.Override
  public java.lang.String getPathRedirect() {
    java.lang.Object ref = pathRedirect_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pathRedirect_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
   * </pre>
   *
   * <code>optional string path_redirect = 272342710;</code>
   *
   * @return The bytes for pathRedirect.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathRedirectBytes() {
    java.lang.Object ref = pathRedirect_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pathRedirect_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFIX_REDIRECT_FIELD_NUMBER = 446184169;

  @SuppressWarnings("serial")
  private volatile java.lang.Object prefixRedirect_ = "";
  /**
   *
   *
   * <pre>
   * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
   * </pre>
   *
   * <code>optional string prefix_redirect = 446184169;</code>
   *
   * @return Whether the prefixRedirect field is set.
   */
  @java.lang.Override
  public boolean hasPrefixRedirect() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
   * </pre>
   *
   * <code>optional string prefix_redirect = 446184169;</code>
   *
   * @return The prefixRedirect.
   */
  @java.lang.Override
  public java.lang.String getPrefixRedirect() {
    java.lang.Object ref = prefixRedirect_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      prefixRedirect_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
   * </pre>
   *
   * <code>optional string prefix_redirect = 446184169;</code>
   *
   * @return The bytes for prefixRedirect.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrefixRedirectBytes() {
    java.lang.Object ref = prefixRedirect_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      prefixRedirect_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDIRECT_RESPONSE_CODE_FIELD_NUMBER = 436710408;

  @SuppressWarnings("serial")
  private volatile java.lang.Object redirectResponseCode_ = "";
  /**
   *
   *
   * <pre>
   * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
   * Check the RedirectResponseCode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string redirect_response_code = 436710408;</code>
   *
   * @return Whether the redirectResponseCode field is set.
   */
  @java.lang.Override
  public boolean hasRedirectResponseCode() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
   * Check the RedirectResponseCode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string redirect_response_code = 436710408;</code>
   *
   * @return The redirectResponseCode.
   */
  @java.lang.Override
  public java.lang.String getRedirectResponseCode() {
    java.lang.Object ref = redirectResponseCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redirectResponseCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
   * Check the RedirectResponseCode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string redirect_response_code = 436710408;</code>
   *
   * @return The bytes for redirectResponseCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRedirectResponseCodeBytes() {
    java.lang.Object ref = redirectResponseCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redirectResponseCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRIP_QUERY_FIELD_NUMBER = 52284641;
  private boolean stripQuery_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
   * </pre>
   *
   * <code>optional bool strip_query = 52284641;</code>
   *
   * @return Whether the stripQuery field is set.
   */
  @java.lang.Override
  public boolean hasStripQuery() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
   * </pre>
   *
   * <code>optional bool strip_query = 52284641;</code>
   *
   * @return The stripQuery.
   */
  @java.lang.Override
  public boolean getStripQuery() {
    return stripQuery_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(52284641, stripQuery_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 107417747, hostRedirect_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(170260656, httpsRedirect_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 272342710, pathRedirect_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 436710408, redirectResponseCode_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 446184169, prefixRedirect_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(52284641, stripQuery_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(107417747, hostRedirect_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(170260656, httpsRedirect_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(272342710, pathRedirect_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              436710408, redirectResponseCode_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(446184169, prefixRedirect_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HttpRedirectAction)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HttpRedirectAction other =
        (com.google.cloud.compute.v1.HttpRedirectAction) obj;

    if (hasHostRedirect() != other.hasHostRedirect()) return false;
    if (hasHostRedirect()) {
      if (!getHostRedirect().equals(other.getHostRedirect())) return false;
    }
    if (hasHttpsRedirect() != other.hasHttpsRedirect()) return false;
    if (hasHttpsRedirect()) {
      if (getHttpsRedirect() != other.getHttpsRedirect()) return false;
    }
    if (hasPathRedirect() != other.hasPathRedirect()) return false;
    if (hasPathRedirect()) {
      if (!getPathRedirect().equals(other.getPathRedirect())) return false;
    }
    if (hasPrefixRedirect() != other.hasPrefixRedirect()) return false;
    if (hasPrefixRedirect()) {
      if (!getPrefixRedirect().equals(other.getPrefixRedirect())) return false;
    }
    if (hasRedirectResponseCode() != other.hasRedirectResponseCode()) return false;
    if (hasRedirectResponseCode()) {
      if (!getRedirectResponseCode().equals(other.getRedirectResponseCode())) return false;
    }
    if (hasStripQuery() != other.hasStripQuery()) return false;
    if (hasStripQuery()) {
      if (getStripQuery() != other.getStripQuery()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasHostRedirect()) {
      hash = (37 * hash) + HOST_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getHostRedirect().hashCode();
    }
    if (hasHttpsRedirect()) {
      hash = (37 * hash) + HTTPS_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHttpsRedirect());
    }
    if (hasPathRedirect()) {
      hash = (37 * hash) + PATH_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getPathRedirect().hashCode();
    }
    if (hasPrefixRedirect()) {
      hash = (37 * hash) + PREFIX_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getPrefixRedirect().hashCode();
    }
    if (hasRedirectResponseCode()) {
      hash = (37 * hash) + REDIRECT_RESPONSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getRedirectResponseCode().hashCode();
    }
    if (hasStripQuery()) {
      hash = (37 * hash) + STRIP_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStripQuery());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HttpRedirectAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies settings for an HTTP redirect.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HttpRedirectAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HttpRedirectAction)
      com.google.cloud.compute.v1.HttpRedirectActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRedirectAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRedirectAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HttpRedirectAction.class,
              com.google.cloud.compute.v1.HttpRedirectAction.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HttpRedirectAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      hostRedirect_ = "";
      httpsRedirect_ = false;
      pathRedirect_ = "";
      prefixRedirect_ = "";
      redirectResponseCode_ = "";
      stripQuery_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRedirectAction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRedirectAction getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRedirectAction build() {
      com.google.cloud.compute.v1.HttpRedirectAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRedirectAction buildPartial() {
      com.google.cloud.compute.v1.HttpRedirectAction result =
          new com.google.cloud.compute.v1.HttpRedirectAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.HttpRedirectAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.hostRedirect_ = hostRedirect_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.httpsRedirect_ = httpsRedirect_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pathRedirect_ = pathRedirect_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.prefixRedirect_ = prefixRedirect_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.redirectResponseCode_ = redirectResponseCode_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.stripQuery_ = stripQuery_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HttpRedirectAction) {
        return mergeFrom((com.google.cloud.compute.v1.HttpRedirectAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HttpRedirectAction other) {
      if (other == com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()) return this;
      if (other.hasHostRedirect()) {
        hostRedirect_ = other.hostRedirect_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasHttpsRedirect()) {
        setHttpsRedirect(other.getHttpsRedirect());
      }
      if (other.hasPathRedirect()) {
        pathRedirect_ = other.pathRedirect_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasPrefixRedirect()) {
        prefixRedirect_ = other.prefixRedirect_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasRedirectResponseCode()) {
        redirectResponseCode_ = other.redirectResponseCode_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasStripQuery()) {
        setStripQuery(other.getStripQuery());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 418277128:
              {
                stripQuery_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 418277128
            case 859341978:
              {
                hostRedirect_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 859341978
            case 1362085248:
              {
                httpsRedirect_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 1362085248
            case -2116225614:
              {
                pathRedirect_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -2116225614
            case -801284030:
              {
                redirectResponseCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -801284030
            case -725493942:
              {
                prefixRedirect_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -725493942
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object hostRedirect_ = "";
    /**
     *
     *
     * <pre>
     * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
     * </pre>
     *
     * <code>optional string host_redirect = 107417747;</code>
     *
     * @return Whether the hostRedirect field is set.
     */
    public boolean hasHostRedirect() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
     * </pre>
     *
     * <code>optional string host_redirect = 107417747;</code>
     *
     * @return The hostRedirect.
     */
    public java.lang.String getHostRedirect() {
      java.lang.Object ref = hostRedirect_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostRedirect_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
     * </pre>
     *
     * <code>optional string host_redirect = 107417747;</code>
     *
     * @return The bytes for hostRedirect.
     */
    public com.google.protobuf.ByteString getHostRedirectBytes() {
      java.lang.Object ref = hostRedirect_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostRedirect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
     * </pre>
     *
     * <code>optional string host_redirect = 107417747;</code>
     *
     * @param value The hostRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setHostRedirect(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostRedirect_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
     * </pre>
     *
     * <code>optional string host_redirect = 107417747;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostRedirect() {
      hostRedirect_ = getDefaultInstance().getHostRedirect();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
     * </pre>
     *
     * <code>optional string host_redirect = 107417747;</code>
     *
     * @param value The bytes for hostRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setHostRedirectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostRedirect_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean httpsRedirect_;
    /**
     *
     *
     * <pre>
     * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
     * </pre>
     *
     * <code>optional bool https_redirect = 170260656;</code>
     *
     * @return Whether the httpsRedirect field is set.
     */
    @java.lang.Override
    public boolean hasHttpsRedirect() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
     * </pre>
     *
     * <code>optional bool https_redirect = 170260656;</code>
     *
     * @return The httpsRedirect.
     */
    @java.lang.Override
    public boolean getHttpsRedirect() {
      return httpsRedirect_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
     * </pre>
     *
     * <code>optional bool https_redirect = 170260656;</code>
     *
     * @param value The httpsRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setHttpsRedirect(boolean value) {

      httpsRedirect_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
     * </pre>
     *
     * <code>optional bool https_redirect = 170260656;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpsRedirect() {
      bitField0_ = (bitField0_ & ~0x00000002);
      httpsRedirect_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object pathRedirect_ = "";
    /**
     *
     *
     * <pre>
     * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string path_redirect = 272342710;</code>
     *
     * @return Whether the pathRedirect field is set.
     */
    public boolean hasPathRedirect() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string path_redirect = 272342710;</code>
     *
     * @return The pathRedirect.
     */
    public java.lang.String getPathRedirect() {
      java.lang.Object ref = pathRedirect_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pathRedirect_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string path_redirect = 272342710;</code>
     *
     * @return The bytes for pathRedirect.
     */
    public com.google.protobuf.ByteString getPathRedirectBytes() {
      java.lang.Object ref = pathRedirect_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pathRedirect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string path_redirect = 272342710;</code>
     *
     * @param value The pathRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setPathRedirect(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pathRedirect_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string path_redirect = 272342710;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPathRedirect() {
      pathRedirect_ = getDefaultInstance().getPathRedirect();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string path_redirect = 272342710;</code>
     *
     * @param value The bytes for pathRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setPathRedirectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pathRedirect_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object prefixRedirect_ = "";
    /**
     *
     *
     * <pre>
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string prefix_redirect = 446184169;</code>
     *
     * @return Whether the prefixRedirect field is set.
     */
    public boolean hasPrefixRedirect() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string prefix_redirect = 446184169;</code>
     *
     * @return The prefixRedirect.
     */
    public java.lang.String getPrefixRedirect() {
      java.lang.Object ref = prefixRedirect_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        prefixRedirect_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string prefix_redirect = 446184169;</code>
     *
     * @return The bytes for prefixRedirect.
     */
    public com.google.protobuf.ByteString getPrefixRedirectBytes() {
      java.lang.Object ref = prefixRedirect_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        prefixRedirect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string prefix_redirect = 446184169;</code>
     *
     * @param value The prefixRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixRedirect(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      prefixRedirect_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string prefix_redirect = 446184169;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrefixRedirect() {
      prefixRedirect_ = getDefaultInstance().getPrefixRedirect();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
     * </pre>
     *
     * <code>optional string prefix_redirect = 446184169;</code>
     *
     * @param value The bytes for prefixRedirect to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixRedirectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      prefixRedirect_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object redirectResponseCode_ = "";
    /**
     *
     *
     * <pre>
     * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redirect_response_code = 436710408;</code>
     *
     * @return Whether the redirectResponseCode field is set.
     */
    public boolean hasRedirectResponseCode() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redirect_response_code = 436710408;</code>
     *
     * @return The redirectResponseCode.
     */
    public java.lang.String getRedirectResponseCode() {
      java.lang.Object ref = redirectResponseCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redirectResponseCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redirect_response_code = 436710408;</code>
     *
     * @return The bytes for redirectResponseCode.
     */
    public com.google.protobuf.ByteString getRedirectResponseCodeBytes() {
      java.lang.Object ref = redirectResponseCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redirectResponseCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redirect_response_code = 436710408;</code>
     *
     * @param value The redirectResponseCode to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectResponseCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      redirectResponseCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redirect_response_code = 436710408;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedirectResponseCode() {
      redirectResponseCode_ = getDefaultInstance().getRedirectResponseCode();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
     * Check the RedirectResponseCode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redirect_response_code = 436710408;</code>
     *
     * @param value The bytes for redirectResponseCode to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectResponseCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      redirectResponseCode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean stripQuery_;
    /**
     *
     *
     * <pre>
     * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
     * </pre>
     *
     * <code>optional bool strip_query = 52284641;</code>
     *
     * @return Whether the stripQuery field is set.
     */
    @java.lang.Override
    public boolean hasStripQuery() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
     * </pre>
     *
     * <code>optional bool strip_query = 52284641;</code>
     *
     * @return The stripQuery.
     */
    @java.lang.Override
    public boolean getStripQuery() {
      return stripQuery_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
     * </pre>
     *
     * <code>optional bool strip_query = 52284641;</code>
     *
     * @param value The stripQuery to set.
     * @return This builder for chaining.
     */
    public Builder setStripQuery(boolean value) {

      stripQuery_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false.
     * </pre>
     *
     * <code>optional bool strip_query = 52284641;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStripQuery() {
      bitField0_ = (bitField0_ & ~0x00000020);
      stripQuery_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HttpRedirectAction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HttpRedirectAction)
  private static final com.google.cloud.compute.v1.HttpRedirectAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HttpRedirectAction();
  }

  public static com.google.cloud.compute.v1.HttpRedirectAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRedirectAction> PARSER =
      new com.google.protobuf.AbstractParser<HttpRedirectAction>() {
        @java.lang.Override
        public HttpRedirectAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpRedirectAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRedirectAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
