/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HttpRouteAction}
 */
public final class HttpRouteAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HttpRouteAction)
    HttpRouteActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpRouteAction.newBuilder() to construct.
  private HttpRouteAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRouteAction() {
    weightedBackendServices_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRouteAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRouteAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRouteAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HttpRouteAction.class,
            com.google.cloud.compute.v1.HttpRouteAction.Builder.class);
  }

  private int bitField0_;
  public static final int CORS_POLICY_FIELD_NUMBER = 398943748;
  private com.google.cloud.compute.v1.CorsPolicy corsPolicy_;
  /**
   *
   *
   * <pre>
   * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
   *
   * @return Whether the corsPolicy field is set.
   */
  @java.lang.Override
  public boolean hasCorsPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
   *
   * @return The corsPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CorsPolicy getCorsPolicy() {
    return corsPolicy_ == null
        ? com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance()
        : corsPolicy_;
  }
  /**
   *
   *
   * <pre>
   * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CorsPolicyOrBuilder getCorsPolicyOrBuilder() {
    return corsPolicy_ == null
        ? com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance()
        : corsPolicy_;
  }

  public static final int FAULT_INJECTION_POLICY_FIELD_NUMBER = 412781079;
  private com.google.cloud.compute.v1.HttpFaultInjection faultInjectionPolicy_;
  /**
   *
   *
   * <pre>
   * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
   * </code>
   *
   * @return Whether the faultInjectionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasFaultInjectionPolicy() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
   * </code>
   *
   * @return The faultInjectionPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpFaultInjection getFaultInjectionPolicy() {
    return faultInjectionPolicy_ == null
        ? com.google.cloud.compute.v1.HttpFaultInjection.getDefaultInstance()
        : faultInjectionPolicy_;
  }
  /**
   *
   *
   * <pre>
   * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpFaultInjectionOrBuilder
      getFaultInjectionPolicyOrBuilder() {
    return faultInjectionPolicy_ == null
        ? com.google.cloud.compute.v1.HttpFaultInjection.getDefaultInstance()
        : faultInjectionPolicy_;
  }

  public static final int MAX_STREAM_DURATION_FIELD_NUMBER = 61428376;
  private com.google.cloud.compute.v1.Duration maxStreamDuration_;
  /**
   *
   *
   * <pre>
   * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   *
   * @return Whether the maxStreamDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxStreamDuration() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   *
   * @return The maxStreamDuration.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getMaxStreamDuration() {
    return maxStreamDuration_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : maxStreamDuration_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getMaxStreamDurationOrBuilder() {
    return maxStreamDuration_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : maxStreamDuration_;
  }

  public static final int REQUEST_MIRROR_POLICY_FIELD_NUMBER = 220196866;
  private com.google.cloud.compute.v1.RequestMirrorPolicy requestMirrorPolicy_;
  /**
   *
   *
   * <pre>
   * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
   * </code>
   *
   * @return Whether the requestMirrorPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRequestMirrorPolicy() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
   * </code>
   *
   * @return The requestMirrorPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RequestMirrorPolicy getRequestMirrorPolicy() {
    return requestMirrorPolicy_ == null
        ? com.google.cloud.compute.v1.RequestMirrorPolicy.getDefaultInstance()
        : requestMirrorPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RequestMirrorPolicyOrBuilder
      getRequestMirrorPolicyOrBuilder() {
    return requestMirrorPolicy_ == null
        ? com.google.cloud.compute.v1.RequestMirrorPolicy.getDefaultInstance()
        : requestMirrorPolicy_;
  }

  public static final int RETRY_POLICY_FIELD_NUMBER = 56799913;
  private com.google.cloud.compute.v1.HttpRetryPolicy retryPolicy_;
  /**
   *
   *
   * <pre>
   * Specifies the retry policy associated with this route.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
   *
   * @return Whether the retryPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetryPolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the retry policy associated with this route.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
   *
   * @return The retryPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRetryPolicy getRetryPolicy() {
    return retryPolicy_ == null
        ? com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance()
        : retryPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the retry policy associated with this route.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRetryPolicyOrBuilder getRetryPolicyOrBuilder() {
    return retryPolicy_ == null
        ? com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance()
        : retryPolicy_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 296701281;
  private com.google.cloud.compute.v1.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getTimeout() {
    return timeout_ == null ? com.google.cloud.compute.v1.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.cloud.compute.v1.Duration.getDefaultInstance() : timeout_;
  }

  public static final int URL_REWRITE_FIELD_NUMBER = 273333948;
  private com.google.cloud.compute.v1.UrlRewrite urlRewrite_;
  /**
   *
   *
   * <pre>
   * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
   *
   * @return Whether the urlRewrite field is set.
   */
  @java.lang.Override
  public boolean hasUrlRewrite() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
   *
   * @return The urlRewrite.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlRewrite getUrlRewrite() {
    return urlRewrite_ == null
        ? com.google.cloud.compute.v1.UrlRewrite.getDefaultInstance()
        : urlRewrite_;
  }
  /**
   *
   *
   * <pre>
   * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlRewriteOrBuilder getUrlRewriteOrBuilder() {
    return urlRewrite_ == null
        ? com.google.cloud.compute.v1.UrlRewrite.getDefaultInstance()
        : urlRewrite_;
  }

  public static final int WEIGHTED_BACKEND_SERVICES_FIELD_NUMBER = 337028049;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.WeightedBackendService>
      weightedBackendServices_;
  /**
   *
   *
   * <pre>
   * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.WeightedBackendService>
      getWeightedBackendServicesList() {
    return weightedBackendServices_;
  }
  /**
   *
   *
   * <pre>
   * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder>
      getWeightedBackendServicesOrBuilderList() {
    return weightedBackendServices_;
  }
  /**
   *
   *
   * <pre>
   * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
   * </code>
   */
  @java.lang.Override
  public int getWeightedBackendServicesCount() {
    return weightedBackendServices_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.WeightedBackendService getWeightedBackendServices(int index) {
    return weightedBackendServices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder
      getWeightedBackendServicesOrBuilder(int index) {
    return weightedBackendServices_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(56799913, getRetryPolicy());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(61428376, getMaxStreamDuration());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(220196866, getRequestMirrorPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(273333948, getUrlRewrite());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(296701281, getTimeout());
    }
    for (int i = 0; i < weightedBackendServices_.size(); i++) {
      output.writeMessage(337028049, weightedBackendServices_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(398943748, getCorsPolicy());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(412781079, getFaultInjectionPolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(56799913, getRetryPolicy());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              61428376, getMaxStreamDuration());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              220196866, getRequestMirrorPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(273333948, getUrlRewrite());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(296701281, getTimeout());
    }
    for (int i = 0; i < weightedBackendServices_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              337028049, weightedBackendServices_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(398943748, getCorsPolicy());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              412781079, getFaultInjectionPolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HttpRouteAction)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HttpRouteAction other =
        (com.google.cloud.compute.v1.HttpRouteAction) obj;

    if (hasCorsPolicy() != other.hasCorsPolicy()) return false;
    if (hasCorsPolicy()) {
      if (!getCorsPolicy().equals(other.getCorsPolicy())) return false;
    }
    if (hasFaultInjectionPolicy() != other.hasFaultInjectionPolicy()) return false;
    if (hasFaultInjectionPolicy()) {
      if (!getFaultInjectionPolicy().equals(other.getFaultInjectionPolicy())) return false;
    }
    if (hasMaxStreamDuration() != other.hasMaxStreamDuration()) return false;
    if (hasMaxStreamDuration()) {
      if (!getMaxStreamDuration().equals(other.getMaxStreamDuration())) return false;
    }
    if (hasRequestMirrorPolicy() != other.hasRequestMirrorPolicy()) return false;
    if (hasRequestMirrorPolicy()) {
      if (!getRequestMirrorPolicy().equals(other.getRequestMirrorPolicy())) return false;
    }
    if (hasRetryPolicy() != other.hasRetryPolicy()) return false;
    if (hasRetryPolicy()) {
      if (!getRetryPolicy().equals(other.getRetryPolicy())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (hasUrlRewrite() != other.hasUrlRewrite()) return false;
    if (hasUrlRewrite()) {
      if (!getUrlRewrite().equals(other.getUrlRewrite())) return false;
    }
    if (!getWeightedBackendServicesList().equals(other.getWeightedBackendServicesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCorsPolicy()) {
      hash = (37 * hash) + CORS_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getCorsPolicy().hashCode();
    }
    if (hasFaultInjectionPolicy()) {
      hash = (37 * hash) + FAULT_INJECTION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getFaultInjectionPolicy().hashCode();
    }
    if (hasMaxStreamDuration()) {
      hash = (37 * hash) + MAX_STREAM_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxStreamDuration().hashCode();
    }
    if (hasRequestMirrorPolicy()) {
      hash = (37 * hash) + REQUEST_MIRROR_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRequestMirrorPolicy().hashCode();
    }
    if (hasRetryPolicy()) {
      hash = (37 * hash) + RETRY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetryPolicy().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (hasUrlRewrite()) {
      hash = (37 * hash) + URL_REWRITE_FIELD_NUMBER;
      hash = (53 * hash) + getUrlRewrite().hashCode();
    }
    if (getWeightedBackendServicesCount() > 0) {
      hash = (37 * hash) + WEIGHTED_BACKEND_SERVICES_FIELD_NUMBER;
      hash = (53 * hash) + getWeightedBackendServicesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HttpRouteAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HttpRouteAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HttpRouteAction)
      com.google.cloud.compute.v1.HttpRouteActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HttpRouteAction.class,
              com.google.cloud.compute.v1.HttpRouteAction.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HttpRouteAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCorsPolicyFieldBuilder();
        getFaultInjectionPolicyFieldBuilder();
        getMaxStreamDurationFieldBuilder();
        getRequestMirrorPolicyFieldBuilder();
        getRetryPolicyFieldBuilder();
        getTimeoutFieldBuilder();
        getUrlRewriteFieldBuilder();
        getWeightedBackendServicesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      corsPolicy_ = null;
      if (corsPolicyBuilder_ != null) {
        corsPolicyBuilder_.dispose();
        corsPolicyBuilder_ = null;
      }
      faultInjectionPolicy_ = null;
      if (faultInjectionPolicyBuilder_ != null) {
        faultInjectionPolicyBuilder_.dispose();
        faultInjectionPolicyBuilder_ = null;
      }
      maxStreamDuration_ = null;
      if (maxStreamDurationBuilder_ != null) {
        maxStreamDurationBuilder_.dispose();
        maxStreamDurationBuilder_ = null;
      }
      requestMirrorPolicy_ = null;
      if (requestMirrorPolicyBuilder_ != null) {
        requestMirrorPolicyBuilder_.dispose();
        requestMirrorPolicyBuilder_ = null;
      }
      retryPolicy_ = null;
      if (retryPolicyBuilder_ != null) {
        retryPolicyBuilder_.dispose();
        retryPolicyBuilder_ = null;
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      urlRewrite_ = null;
      if (urlRewriteBuilder_ != null) {
        urlRewriteBuilder_.dispose();
        urlRewriteBuilder_ = null;
      }
      if (weightedBackendServicesBuilder_ == null) {
        weightedBackendServices_ = java.util.Collections.emptyList();
      } else {
        weightedBackendServices_ = null;
        weightedBackendServicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteAction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteAction getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteAction build() {
      com.google.cloud.compute.v1.HttpRouteAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteAction buildPartial() {
      com.google.cloud.compute.v1.HttpRouteAction result =
          new com.google.cloud.compute.v1.HttpRouteAction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.HttpRouteAction result) {
      if (weightedBackendServicesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          weightedBackendServices_ =
              java.util.Collections.unmodifiableList(weightedBackendServices_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.weightedBackendServices_ = weightedBackendServices_;
      } else {
        result.weightedBackendServices_ = weightedBackendServicesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.HttpRouteAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.corsPolicy_ = corsPolicyBuilder_ == null ? corsPolicy_ : corsPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.faultInjectionPolicy_ =
            faultInjectionPolicyBuilder_ == null
                ? faultInjectionPolicy_
                : faultInjectionPolicyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxStreamDuration_ =
            maxStreamDurationBuilder_ == null
                ? maxStreamDuration_
                : maxStreamDurationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestMirrorPolicy_ =
            requestMirrorPolicyBuilder_ == null
                ? requestMirrorPolicy_
                : requestMirrorPolicyBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.retryPolicy_ =
            retryPolicyBuilder_ == null ? retryPolicy_ : retryPolicyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.urlRewrite_ = urlRewriteBuilder_ == null ? urlRewrite_ : urlRewriteBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HttpRouteAction) {
        return mergeFrom((com.google.cloud.compute.v1.HttpRouteAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HttpRouteAction other) {
      if (other == com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()) return this;
      if (other.hasCorsPolicy()) {
        mergeCorsPolicy(other.getCorsPolicy());
      }
      if (other.hasFaultInjectionPolicy()) {
        mergeFaultInjectionPolicy(other.getFaultInjectionPolicy());
      }
      if (other.hasMaxStreamDuration()) {
        mergeMaxStreamDuration(other.getMaxStreamDuration());
      }
      if (other.hasRequestMirrorPolicy()) {
        mergeRequestMirrorPolicy(other.getRequestMirrorPolicy());
      }
      if (other.hasRetryPolicy()) {
        mergeRetryPolicy(other.getRetryPolicy());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.hasUrlRewrite()) {
        mergeUrlRewrite(other.getUrlRewrite());
      }
      if (weightedBackendServicesBuilder_ == null) {
        if (!other.weightedBackendServices_.isEmpty()) {
          if (weightedBackendServices_.isEmpty()) {
            weightedBackendServices_ = other.weightedBackendServices_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureWeightedBackendServicesIsMutable();
            weightedBackendServices_.addAll(other.weightedBackendServices_);
          }
          onChanged();
        }
      } else {
        if (!other.weightedBackendServices_.isEmpty()) {
          if (weightedBackendServicesBuilder_.isEmpty()) {
            weightedBackendServicesBuilder_.dispose();
            weightedBackendServicesBuilder_ = null;
            weightedBackendServices_ = other.weightedBackendServices_;
            bitField0_ = (bitField0_ & ~0x00000080);
            weightedBackendServicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWeightedBackendServicesFieldBuilder()
                    : null;
          } else {
            weightedBackendServicesBuilder_.addAllMessages(other.weightedBackendServices_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 454399306:
              {
                input.readMessage(getRetryPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 454399306
            case 491427010:
              {
                input.readMessage(
                    getMaxStreamDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 491427010
            case 1761574930:
              {
                input.readMessage(
                    getRequestMirrorPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 1761574930
            case -2108295710:
              {
                input.readMessage(getUrlRewriteFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case -2108295710
            case -1921357046:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -1921357046
            case -1598742902:
              {
                com.google.cloud.compute.v1.WeightedBackendService m =
                    input.readMessage(
                        com.google.cloud.compute.v1.WeightedBackendService.parser(),
                        extensionRegistry);
                if (weightedBackendServicesBuilder_ == null) {
                  ensureWeightedBackendServicesIsMutable();
                  weightedBackendServices_.add(m);
                } else {
                  weightedBackendServicesBuilder_.addMessage(m);
                }
                break;
              } // case -1598742902
            case -1103417310:
              {
                input.readMessage(getCorsPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1103417310
            case -992718662:
              {
                input.readMessage(
                    getFaultInjectionPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -992718662
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.CorsPolicy corsPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CorsPolicy,
            com.google.cloud.compute.v1.CorsPolicy.Builder,
            com.google.cloud.compute.v1.CorsPolicyOrBuilder>
        corsPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     *
     * @return Whether the corsPolicy field is set.
     */
    public boolean hasCorsPolicy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     *
     * @return The corsPolicy.
     */
    public com.google.cloud.compute.v1.CorsPolicy getCorsPolicy() {
      if (corsPolicyBuilder_ == null) {
        return corsPolicy_ == null
            ? com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance()
            : corsPolicy_;
      } else {
        return corsPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    public Builder setCorsPolicy(com.google.cloud.compute.v1.CorsPolicy value) {
      if (corsPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        corsPolicy_ = value;
      } else {
        corsPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    public Builder setCorsPolicy(com.google.cloud.compute.v1.CorsPolicy.Builder builderForValue) {
      if (corsPolicyBuilder_ == null) {
        corsPolicy_ = builderForValue.build();
      } else {
        corsPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    public Builder mergeCorsPolicy(com.google.cloud.compute.v1.CorsPolicy value) {
      if (corsPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && corsPolicy_ != null
            && corsPolicy_ != com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance()) {
          getCorsPolicyBuilder().mergeFrom(value);
        } else {
          corsPolicy_ = value;
        }
      } else {
        corsPolicyBuilder_.mergeFrom(value);
      }
      if (corsPolicy_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    public Builder clearCorsPolicy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      corsPolicy_ = null;
      if (corsPolicyBuilder_ != null) {
        corsPolicyBuilder_.dispose();
        corsPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    public com.google.cloud.compute.v1.CorsPolicy.Builder getCorsPolicyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCorsPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    public com.google.cloud.compute.v1.CorsPolicyOrBuilder getCorsPolicyOrBuilder() {
      if (corsPolicyBuilder_ != null) {
        return corsPolicyBuilder_.getMessageOrBuilder();
      } else {
        return corsPolicy_ == null
            ? com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance()
            : corsPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.CorsPolicy cors_policy = 398943748;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CorsPolicy,
            com.google.cloud.compute.v1.CorsPolicy.Builder,
            com.google.cloud.compute.v1.CorsPolicyOrBuilder>
        getCorsPolicyFieldBuilder() {
      if (corsPolicyBuilder_ == null) {
        corsPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CorsPolicy,
                com.google.cloud.compute.v1.CorsPolicy.Builder,
                com.google.cloud.compute.v1.CorsPolicyOrBuilder>(
                getCorsPolicy(), getParentForChildren(), isClean());
        corsPolicy_ = null;
      }
      return corsPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.HttpFaultInjection faultInjectionPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpFaultInjection,
            com.google.cloud.compute.v1.HttpFaultInjection.Builder,
            com.google.cloud.compute.v1.HttpFaultInjectionOrBuilder>
        faultInjectionPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     *
     * @return Whether the faultInjectionPolicy field is set.
     */
    public boolean hasFaultInjectionPolicy() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     *
     * @return The faultInjectionPolicy.
     */
    public com.google.cloud.compute.v1.HttpFaultInjection getFaultInjectionPolicy() {
      if (faultInjectionPolicyBuilder_ == null) {
        return faultInjectionPolicy_ == null
            ? com.google.cloud.compute.v1.HttpFaultInjection.getDefaultInstance()
            : faultInjectionPolicy_;
      } else {
        return faultInjectionPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    public Builder setFaultInjectionPolicy(com.google.cloud.compute.v1.HttpFaultInjection value) {
      if (faultInjectionPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        faultInjectionPolicy_ = value;
      } else {
        faultInjectionPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    public Builder setFaultInjectionPolicy(
        com.google.cloud.compute.v1.HttpFaultInjection.Builder builderForValue) {
      if (faultInjectionPolicyBuilder_ == null) {
        faultInjectionPolicy_ = builderForValue.build();
      } else {
        faultInjectionPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    public Builder mergeFaultInjectionPolicy(com.google.cloud.compute.v1.HttpFaultInjection value) {
      if (faultInjectionPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && faultInjectionPolicy_ != null
            && faultInjectionPolicy_
                != com.google.cloud.compute.v1.HttpFaultInjection.getDefaultInstance()) {
          getFaultInjectionPolicyBuilder().mergeFrom(value);
        } else {
          faultInjectionPolicy_ = value;
        }
      } else {
        faultInjectionPolicyBuilder_.mergeFrom(value);
      }
      if (faultInjectionPolicy_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    public Builder clearFaultInjectionPolicy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      faultInjectionPolicy_ = null;
      if (faultInjectionPolicyBuilder_ != null) {
        faultInjectionPolicyBuilder_.dispose();
        faultInjectionPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpFaultInjection.Builder getFaultInjectionPolicyBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFaultInjectionPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpFaultInjectionOrBuilder
        getFaultInjectionPolicyOrBuilder() {
      if (faultInjectionPolicyBuilder_ != null) {
        return faultInjectionPolicyBuilder_.getMessageOrBuilder();
      } else {
        return faultInjectionPolicy_ == null
            ? com.google.cloud.compute.v1.HttpFaultInjection.getDefaultInstance()
            : faultInjectionPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy if: 1. The traffic is generated by fault injection AND 2. The fault injection is not a delay fault injection. Fault injection is not supported with the classic Application Load Balancer . To see which load balancers support fault injection, see Load balancing: Routing and traffic management features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.HttpFaultInjection fault_injection_policy = 412781079;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpFaultInjection,
            com.google.cloud.compute.v1.HttpFaultInjection.Builder,
            com.google.cloud.compute.v1.HttpFaultInjectionOrBuilder>
        getFaultInjectionPolicyFieldBuilder() {
      if (faultInjectionPolicyBuilder_ == null) {
        faultInjectionPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpFaultInjection,
                com.google.cloud.compute.v1.HttpFaultInjection.Builder,
                com.google.cloud.compute.v1.HttpFaultInjectionOrBuilder>(
                getFaultInjectionPolicy(), getParentForChildren(), isClean());
        faultInjectionPolicy_ = null;
      }
      return faultInjectionPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.Duration maxStreamDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        maxStreamDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     *
     * @return Whether the maxStreamDuration field is set.
     */
    public boolean hasMaxStreamDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     *
     * @return The maxStreamDuration.
     */
    public com.google.cloud.compute.v1.Duration getMaxStreamDuration() {
      if (maxStreamDurationBuilder_ == null) {
        return maxStreamDuration_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : maxStreamDuration_;
      } else {
        return maxStreamDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder setMaxStreamDuration(com.google.cloud.compute.v1.Duration value) {
      if (maxStreamDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxStreamDuration_ = value;
      } else {
        maxStreamDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder setMaxStreamDuration(
        com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (maxStreamDurationBuilder_ == null) {
        maxStreamDuration_ = builderForValue.build();
      } else {
        maxStreamDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder mergeMaxStreamDuration(com.google.cloud.compute.v1.Duration value) {
      if (maxStreamDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && maxStreamDuration_ != null
            && maxStreamDuration_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getMaxStreamDurationBuilder().mergeFrom(value);
        } else {
          maxStreamDuration_ = value;
        }
      } else {
        maxStreamDurationBuilder_.mergeFrom(value);
      }
      if (maxStreamDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public Builder clearMaxStreamDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxStreamDuration_ = null;
      if (maxStreamDurationBuilder_ != null) {
        maxStreamDurationBuilder_.dispose();
        maxStreamDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getMaxStreamDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMaxStreamDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getMaxStreamDurationOrBuilder() {
      if (maxStreamDurationBuilder_ != null) {
        return maxStreamDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxStreamDuration_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : maxStreamDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getMaxStreamDurationFieldBuilder() {
      if (maxStreamDurationBuilder_ == null) {
        maxStreamDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getMaxStreamDuration(), getParentForChildren(), isClean());
        maxStreamDuration_ = null;
      }
      return maxStreamDurationBuilder_;
    }

    private com.google.cloud.compute.v1.RequestMirrorPolicy requestMirrorPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RequestMirrorPolicy,
            com.google.cloud.compute.v1.RequestMirrorPolicy.Builder,
            com.google.cloud.compute.v1.RequestMirrorPolicyOrBuilder>
        requestMirrorPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     *
     * @return Whether the requestMirrorPolicy field is set.
     */
    public boolean hasRequestMirrorPolicy() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     *
     * @return The requestMirrorPolicy.
     */
    public com.google.cloud.compute.v1.RequestMirrorPolicy getRequestMirrorPolicy() {
      if (requestMirrorPolicyBuilder_ == null) {
        return requestMirrorPolicy_ == null
            ? com.google.cloud.compute.v1.RequestMirrorPolicy.getDefaultInstance()
            : requestMirrorPolicy_;
      } else {
        return requestMirrorPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    public Builder setRequestMirrorPolicy(com.google.cloud.compute.v1.RequestMirrorPolicy value) {
      if (requestMirrorPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestMirrorPolicy_ = value;
      } else {
        requestMirrorPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    public Builder setRequestMirrorPolicy(
        com.google.cloud.compute.v1.RequestMirrorPolicy.Builder builderForValue) {
      if (requestMirrorPolicyBuilder_ == null) {
        requestMirrorPolicy_ = builderForValue.build();
      } else {
        requestMirrorPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    public Builder mergeRequestMirrorPolicy(com.google.cloud.compute.v1.RequestMirrorPolicy value) {
      if (requestMirrorPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && requestMirrorPolicy_ != null
            && requestMirrorPolicy_
                != com.google.cloud.compute.v1.RequestMirrorPolicy.getDefaultInstance()) {
          getRequestMirrorPolicyBuilder().mergeFrom(value);
        } else {
          requestMirrorPolicy_ = value;
        }
      } else {
        requestMirrorPolicyBuilder_.mergeFrom(value);
      }
      if (requestMirrorPolicy_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    public Builder clearRequestMirrorPolicy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      requestMirrorPolicy_ = null;
      if (requestMirrorPolicyBuilder_ != null) {
        requestMirrorPolicyBuilder_.dispose();
        requestMirrorPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    public com.google.cloud.compute.v1.RequestMirrorPolicy.Builder getRequestMirrorPolicyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRequestMirrorPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    public com.google.cloud.compute.v1.RequestMirrorPolicyOrBuilder
        getRequestMirrorPolicyOrBuilder() {
      if (requestMirrorPolicyBuilder_ != null) {
        return requestMirrorPolicyBuilder_.getMessageOrBuilder();
      } else {
        return requestMirrorPolicy_ == null
            ? com.google.cloud.compute.v1.RequestMirrorPolicy.getDefaultInstance()
            : requestMirrorPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.RequestMirrorPolicy request_mirror_policy = 220196866;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RequestMirrorPolicy,
            com.google.cloud.compute.v1.RequestMirrorPolicy.Builder,
            com.google.cloud.compute.v1.RequestMirrorPolicyOrBuilder>
        getRequestMirrorPolicyFieldBuilder() {
      if (requestMirrorPolicyBuilder_ == null) {
        requestMirrorPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RequestMirrorPolicy,
                com.google.cloud.compute.v1.RequestMirrorPolicy.Builder,
                com.google.cloud.compute.v1.RequestMirrorPolicyOrBuilder>(
                getRequestMirrorPolicy(), getParentForChildren(), isClean());
        requestMirrorPolicy_ = null;
      }
      return requestMirrorPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.HttpRetryPolicy retryPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRetryPolicy,
            com.google.cloud.compute.v1.HttpRetryPolicy.Builder,
            com.google.cloud.compute.v1.HttpRetryPolicyOrBuilder>
        retryPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     *
     * @return Whether the retryPolicy field is set.
     */
    public boolean hasRetryPolicy() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     *
     * @return The retryPolicy.
     */
    public com.google.cloud.compute.v1.HttpRetryPolicy getRetryPolicy() {
      if (retryPolicyBuilder_ == null) {
        return retryPolicy_ == null
            ? com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance()
            : retryPolicy_;
      } else {
        return retryPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    public Builder setRetryPolicy(com.google.cloud.compute.v1.HttpRetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryPolicy_ = value;
      } else {
        retryPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    public Builder setRetryPolicy(
        com.google.cloud.compute.v1.HttpRetryPolicy.Builder builderForValue) {
      if (retryPolicyBuilder_ == null) {
        retryPolicy_ = builderForValue.build();
      } else {
        retryPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    public Builder mergeRetryPolicy(com.google.cloud.compute.v1.HttpRetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && retryPolicy_ != null
            && retryPolicy_ != com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance()) {
          getRetryPolicyBuilder().mergeFrom(value);
        } else {
          retryPolicy_ = value;
        }
      } else {
        retryPolicyBuilder_.mergeFrom(value);
      }
      if (retryPolicy_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    public Builder clearRetryPolicy() {
      bitField0_ = (bitField0_ & ~0x00000010);
      retryPolicy_ = null;
      if (retryPolicyBuilder_ != null) {
        retryPolicyBuilder_.dispose();
        retryPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    public com.google.cloud.compute.v1.HttpRetryPolicy.Builder getRetryPolicyBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRetryPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    public com.google.cloud.compute.v1.HttpRetryPolicyOrBuilder getRetryPolicyOrBuilder() {
      if (retryPolicyBuilder_ != null) {
        return retryPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retryPolicy_ == null
            ? com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance()
            : retryPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the retry policy associated with this route.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRetryPolicy retry_policy = 56799913;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRetryPolicy,
            com.google.cloud.compute.v1.HttpRetryPolicy.Builder,
            com.google.cloud.compute.v1.HttpRetryPolicyOrBuilder>
        getRetryPolicyFieldBuilder() {
      if (retryPolicyBuilder_ == null) {
        retryPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRetryPolicy,
                com.google.cloud.compute.v1.HttpRetryPolicy.Builder,
                com.google.cloud.compute.v1.HttpRetryPolicyOrBuilder>(
                getRetryPolicy(), getParentForChildren(), isClean());
        retryPolicy_ = null;
      }
      return retryPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     *
     * @return The timeout.
     */
    public com.google.cloud.compute.v1.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    public Builder setTimeout(com.google.cloud.compute.v1.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    public Builder setTimeout(com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    public Builder mergeTimeout(com.google.cloud.compute.v1.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && timeout_ != null
            && timeout_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000020);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration timeout = 296701281;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private com.google.cloud.compute.v1.UrlRewrite urlRewrite_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UrlRewrite,
            com.google.cloud.compute.v1.UrlRewrite.Builder,
            com.google.cloud.compute.v1.UrlRewriteOrBuilder>
        urlRewriteBuilder_;
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     *
     * @return Whether the urlRewrite field is set.
     */
    public boolean hasUrlRewrite() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     *
     * @return The urlRewrite.
     */
    public com.google.cloud.compute.v1.UrlRewrite getUrlRewrite() {
      if (urlRewriteBuilder_ == null) {
        return urlRewrite_ == null
            ? com.google.cloud.compute.v1.UrlRewrite.getDefaultInstance()
            : urlRewrite_;
      } else {
        return urlRewriteBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    public Builder setUrlRewrite(com.google.cloud.compute.v1.UrlRewrite value) {
      if (urlRewriteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        urlRewrite_ = value;
      } else {
        urlRewriteBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    public Builder setUrlRewrite(com.google.cloud.compute.v1.UrlRewrite.Builder builderForValue) {
      if (urlRewriteBuilder_ == null) {
        urlRewrite_ = builderForValue.build();
      } else {
        urlRewriteBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    public Builder mergeUrlRewrite(com.google.cloud.compute.v1.UrlRewrite value) {
      if (urlRewriteBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && urlRewrite_ != null
            && urlRewrite_ != com.google.cloud.compute.v1.UrlRewrite.getDefaultInstance()) {
          getUrlRewriteBuilder().mergeFrom(value);
        } else {
          urlRewrite_ = value;
        }
      } else {
        urlRewriteBuilder_.mergeFrom(value);
      }
      if (urlRewrite_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    public Builder clearUrlRewrite() {
      bitField0_ = (bitField0_ & ~0x00000040);
      urlRewrite_ = null;
      if (urlRewriteBuilder_ != null) {
        urlRewriteBuilder_.dispose();
        urlRewriteBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    public com.google.cloud.compute.v1.UrlRewrite.Builder getUrlRewriteBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUrlRewriteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    public com.google.cloud.compute.v1.UrlRewriteOrBuilder getUrlRewriteOrBuilder() {
      if (urlRewriteBuilder_ != null) {
        return urlRewriteBuilder_.getMessageOrBuilder();
      } else {
        return urlRewrite_ == null
            ? com.google.cloud.compute.v1.UrlRewrite.getDefaultInstance()
            : urlRewrite_;
      }
    }
    /**
     *
     *
     * <pre>
     * The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for classic Application Load Balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlRewrite url_rewrite = 273333948;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UrlRewrite,
            com.google.cloud.compute.v1.UrlRewrite.Builder,
            com.google.cloud.compute.v1.UrlRewriteOrBuilder>
        getUrlRewriteFieldBuilder() {
      if (urlRewriteBuilder_ == null) {
        urlRewriteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.UrlRewrite,
                com.google.cloud.compute.v1.UrlRewrite.Builder,
                com.google.cloud.compute.v1.UrlRewriteOrBuilder>(
                getUrlRewrite(), getParentForChildren(), isClean());
        urlRewrite_ = null;
      }
      return urlRewriteBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.WeightedBackendService>
        weightedBackendServices_ = java.util.Collections.emptyList();

    private void ensureWeightedBackendServicesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        weightedBackendServices_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.WeightedBackendService>(
                weightedBackendServices_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.WeightedBackendService,
            com.google.cloud.compute.v1.WeightedBackendService.Builder,
            com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder>
        weightedBackendServicesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.WeightedBackendService>
        getWeightedBackendServicesList() {
      if (weightedBackendServicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(weightedBackendServices_);
      } else {
        return weightedBackendServicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public int getWeightedBackendServicesCount() {
      if (weightedBackendServicesBuilder_ == null) {
        return weightedBackendServices_.size();
      } else {
        return weightedBackendServicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public com.google.cloud.compute.v1.WeightedBackendService getWeightedBackendServices(
        int index) {
      if (weightedBackendServicesBuilder_ == null) {
        return weightedBackendServices_.get(index);
      } else {
        return weightedBackendServicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder setWeightedBackendServices(
        int index, com.google.cloud.compute.v1.WeightedBackendService value) {
      if (weightedBackendServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.set(index, value);
        onChanged();
      } else {
        weightedBackendServicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder setWeightedBackendServices(
        int index, com.google.cloud.compute.v1.WeightedBackendService.Builder builderForValue) {
      if (weightedBackendServicesBuilder_ == null) {
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.set(index, builderForValue.build());
        onChanged();
      } else {
        weightedBackendServicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder addWeightedBackendServices(
        com.google.cloud.compute.v1.WeightedBackendService value) {
      if (weightedBackendServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.add(value);
        onChanged();
      } else {
        weightedBackendServicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder addWeightedBackendServices(
        int index, com.google.cloud.compute.v1.WeightedBackendService value) {
      if (weightedBackendServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.add(index, value);
        onChanged();
      } else {
        weightedBackendServicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder addWeightedBackendServices(
        com.google.cloud.compute.v1.WeightedBackendService.Builder builderForValue) {
      if (weightedBackendServicesBuilder_ == null) {
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.add(builderForValue.build());
        onChanged();
      } else {
        weightedBackendServicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder addWeightedBackendServices(
        int index, com.google.cloud.compute.v1.WeightedBackendService.Builder builderForValue) {
      if (weightedBackendServicesBuilder_ == null) {
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.add(index, builderForValue.build());
        onChanged();
      } else {
        weightedBackendServicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder addAllWeightedBackendServices(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.WeightedBackendService> values) {
      if (weightedBackendServicesBuilder_ == null) {
        ensureWeightedBackendServicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, weightedBackendServices_);
        onChanged();
      } else {
        weightedBackendServicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder clearWeightedBackendServices() {
      if (weightedBackendServicesBuilder_ == null) {
        weightedBackendServices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        weightedBackendServicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public Builder removeWeightedBackendServices(int index) {
      if (weightedBackendServicesBuilder_ == null) {
        ensureWeightedBackendServicesIsMutable();
        weightedBackendServices_.remove(index);
        onChanged();
      } else {
        weightedBackendServicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public com.google.cloud.compute.v1.WeightedBackendService.Builder
        getWeightedBackendServicesBuilder(int index) {
      return getWeightedBackendServicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder
        getWeightedBackendServicesOrBuilder(int index) {
      if (weightedBackendServicesBuilder_ == null) {
        return weightedBackendServices_.get(index);
      } else {
        return weightedBackendServicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder>
        getWeightedBackendServicesOrBuilderList() {
      if (weightedBackendServicesBuilder_ != null) {
        return weightedBackendServicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(weightedBackendServices_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public com.google.cloud.compute.v1.WeightedBackendService.Builder
        addWeightedBackendServicesBuilder() {
      return getWeightedBackendServicesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.WeightedBackendService.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public com.google.cloud.compute.v1.WeightedBackendService.Builder
        addWeightedBackendServicesBuilder(int index) {
      return getWeightedBackendServicesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.WeightedBackendService.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.WeightedBackendService weighted_backend_services = 337028049;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.WeightedBackendService.Builder>
        getWeightedBackendServicesBuilderList() {
      return getWeightedBackendServicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.WeightedBackendService,
            com.google.cloud.compute.v1.WeightedBackendService.Builder,
            com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder>
        getWeightedBackendServicesFieldBuilder() {
      if (weightedBackendServicesBuilder_ == null) {
        weightedBackendServicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.WeightedBackendService,
                com.google.cloud.compute.v1.WeightedBackendService.Builder,
                com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder>(
                weightedBackendServices_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        weightedBackendServices_ = null;
      }
      return weightedBackendServicesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HttpRouteAction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HttpRouteAction)
  private static final com.google.cloud.compute.v1.HttpRouteAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HttpRouteAction();
  }

  public static com.google.cloud.compute.v1.HttpRouteAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRouteAction> PARSER =
      new com.google.protobuf.AbstractParser<HttpRouteAction>() {
        @java.lang.Override
        public HttpRouteAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpRouteAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRouteAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
