/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HttpRouteRuleMatch}
 */
public final class HttpRouteRuleMatch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HttpRouteRuleMatch)
    HttpRouteRuleMatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpRouteRuleMatch.newBuilder() to construct.
  private HttpRouteRuleMatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRouteRuleMatch() {
    fullPathMatch_ = "";
    headerMatches_ = java.util.Collections.emptyList();
    metadataFilters_ = java.util.Collections.emptyList();
    pathTemplateMatch_ = "";
    prefixMatch_ = "";
    queryParameterMatches_ = java.util.Collections.emptyList();
    regexMatch_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRouteRuleMatch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRouteRuleMatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRouteRuleMatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HttpRouteRuleMatch.class,
            com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder.class);
  }

  private int bitField0_;
  public static final int FULL_PATH_MATCH_FIELD_NUMBER = 214598875;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullPathMatch_ = "";
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * </pre>
   *
   * <code>optional string full_path_match = 214598875;</code>
   *
   * @return Whether the fullPathMatch field is set.
   */
  @java.lang.Override
  public boolean hasFullPathMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * </pre>
   *
   * <code>optional string full_path_match = 214598875;</code>
   *
   * @return The fullPathMatch.
   */
  @java.lang.Override
  public java.lang.String getFullPathMatch() {
    java.lang.Object ref = fullPathMatch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullPathMatch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * </pre>
   *
   * <code>optional string full_path_match = 214598875;</code>
   *
   * @return The bytes for fullPathMatch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullPathMatchBytes() {
    java.lang.Object ref = fullPathMatch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullPathMatch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADER_MATCHES_FIELD_NUMBER = 361903489;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HttpHeaderMatch> headerMatches_;
  /**
   *
   *
   * <pre>
   * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HttpHeaderMatch> getHeaderMatchesList() {
    return headerMatches_;
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder>
      getHeaderMatchesOrBuilderList() {
    return headerMatches_;
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
   */
  @java.lang.Override
  public int getHeaderMatchesCount() {
    return headerMatches_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderMatch getHeaderMatches(int index) {
    return headerMatches_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder getHeaderMatchesOrBuilder(int index) {
    return headerMatches_.get(index);
  }

  public static final int IGNORE_CASE_FIELD_NUMBER = 464324989;
  private boolean ignoreCase_ = false;
  /**
   *
   *
   * <pre>
   * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional bool ignore_case = 464324989;</code>
   *
   * @return Whether the ignoreCase field is set.
   */
  @java.lang.Override
  public boolean hasIgnoreCase() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional bool ignore_case = 464324989;</code>
   *
   * @return The ignoreCase.
   */
  @java.lang.Override
  public boolean getIgnoreCase() {
    return ignoreCase_;
  }

  public static final int METADATA_FILTERS_FIELD_NUMBER = 464725739;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.MetadataFilter> metadataFilters_;
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.MetadataFilter> getMetadataFiltersList() {
    return metadataFilters_;
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.MetadataFilterOrBuilder>
      getMetadataFiltersOrBuilderList() {
    return metadataFilters_;
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public int getMetadataFiltersCount() {
    return metadataFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilter getMetadataFilters(int index) {
    return metadataFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilterOrBuilder getMetadataFiltersOrBuilder(
      int index) {
    return metadataFilters_.get(index);
  }

  public static final int PATH_TEMPLATE_MATCH_FIELD_NUMBER = 292348186;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pathTemplateMatch_ = "";
  /**
   *
   *
   * <pre>
   * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
   * </pre>
   *
   * <code>optional string path_template_match = 292348186;</code>
   *
   * @return Whether the pathTemplateMatch field is set.
   */
  @java.lang.Override
  public boolean hasPathTemplateMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
   * </pre>
   *
   * <code>optional string path_template_match = 292348186;</code>
   *
   * @return The pathTemplateMatch.
   */
  @java.lang.Override
  public java.lang.String getPathTemplateMatch() {
    java.lang.Object ref = pathTemplateMatch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pathTemplateMatch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
   * </pre>
   *
   * <code>optional string path_template_match = 292348186;</code>
   *
   * @return The bytes for pathTemplateMatch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathTemplateMatchBytes() {
    java.lang.Object ref = pathTemplateMatch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pathTemplateMatch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFIX_MATCH_FIELD_NUMBER = 257898968;

  @SuppressWarnings("serial")
  private volatile java.lang.Object prefixMatch_ = "";
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * </pre>
   *
   * <code>optional string prefix_match = 257898968;</code>
   *
   * @return Whether the prefixMatch field is set.
   */
  @java.lang.Override
  public boolean hasPrefixMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * </pre>
   *
   * <code>optional string prefix_match = 257898968;</code>
   *
   * @return The prefixMatch.
   */
  @java.lang.Override
  public java.lang.String getPrefixMatch() {
    java.lang.Object ref = prefixMatch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      prefixMatch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * </pre>
   *
   * <code>optional string prefix_match = 257898968;</code>
   *
   * @return The bytes for prefixMatch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrefixMatchBytes() {
    java.lang.Object ref = prefixMatch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      prefixMatch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_PARAMETER_MATCHES_FIELD_NUMBER = 286231270;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HttpQueryParameterMatch>
      queryParameterMatches_;
  /**
   *
   *
   * <pre>
   * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HttpQueryParameterMatch>
      getQueryParameterMatchesList() {
    return queryParameterMatches_;
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder>
      getQueryParameterMatchesOrBuilderList() {
    return queryParameterMatches_;
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
   * </code>
   */
  @java.lang.Override
  public int getQueryParameterMatchesCount() {
    return queryParameterMatches_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpQueryParameterMatch getQueryParameterMatches(int index) {
    return queryParameterMatches_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder
      getQueryParameterMatchesOrBuilder(int index) {
    return queryParameterMatches_.get(index);
  }

  public static final int REGEX_MATCH_FIELD_NUMBER = 107387853;

  @SuppressWarnings("serial")
  private volatile java.lang.Object regexMatch_ = "";
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional string regex_match = 107387853;</code>
   *
   * @return Whether the regexMatch field is set.
   */
  @java.lang.Override
  public boolean hasRegexMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional string regex_match = 107387853;</code>
   *
   * @return The regexMatch.
   */
  @java.lang.Override
  public java.lang.String getRegexMatch() {
    java.lang.Object ref = regexMatch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regexMatch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional string regex_match = 107387853;</code>
   *
   * @return The bytes for regexMatch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegexMatchBytes() {
    java.lang.Object ref = regexMatch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      regexMatch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 107387853, regexMatch_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 214598875, fullPathMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 257898968, prefixMatch_);
    }
    for (int i = 0; i < queryParameterMatches_.size(); i++) {
      output.writeMessage(286231270, queryParameterMatches_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 292348186, pathTemplateMatch_);
    }
    for (int i = 0; i < headerMatches_.size(); i++) {
      output.writeMessage(361903489, headerMatches_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(464324989, ignoreCase_);
    }
    for (int i = 0; i < metadataFilters_.size(); i++) {
      output.writeMessage(464725739, metadataFilters_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(107387853, regexMatch_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(214598875, fullPathMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(257898968, prefixMatch_);
    }
    for (int i = 0; i < queryParameterMatches_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              286231270, queryParameterMatches_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(292348186, pathTemplateMatch_);
    }
    for (int i = 0; i < headerMatches_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              361903489, headerMatches_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(464324989, ignoreCase_);
    }
    for (int i = 0; i < metadataFilters_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              464725739, metadataFilters_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HttpRouteRuleMatch)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HttpRouteRuleMatch other =
        (com.google.cloud.compute.v1.HttpRouteRuleMatch) obj;

    if (hasFullPathMatch() != other.hasFullPathMatch()) return false;
    if (hasFullPathMatch()) {
      if (!getFullPathMatch().equals(other.getFullPathMatch())) return false;
    }
    if (!getHeaderMatchesList().equals(other.getHeaderMatchesList())) return false;
    if (hasIgnoreCase() != other.hasIgnoreCase()) return false;
    if (hasIgnoreCase()) {
      if (getIgnoreCase() != other.getIgnoreCase()) return false;
    }
    if (!getMetadataFiltersList().equals(other.getMetadataFiltersList())) return false;
    if (hasPathTemplateMatch() != other.hasPathTemplateMatch()) return false;
    if (hasPathTemplateMatch()) {
      if (!getPathTemplateMatch().equals(other.getPathTemplateMatch())) return false;
    }
    if (hasPrefixMatch() != other.hasPrefixMatch()) return false;
    if (hasPrefixMatch()) {
      if (!getPrefixMatch().equals(other.getPrefixMatch())) return false;
    }
    if (!getQueryParameterMatchesList().equals(other.getQueryParameterMatchesList())) return false;
    if (hasRegexMatch() != other.hasRegexMatch()) return false;
    if (hasRegexMatch()) {
      if (!getRegexMatch().equals(other.getRegexMatch())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFullPathMatch()) {
      hash = (37 * hash) + FULL_PATH_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getFullPathMatch().hashCode();
    }
    if (getHeaderMatchesCount() > 0) {
      hash = (37 * hash) + HEADER_MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderMatchesList().hashCode();
    }
    if (hasIgnoreCase()) {
      hash = (37 * hash) + IGNORE_CASE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreCase());
    }
    if (getMetadataFiltersCount() > 0) {
      hash = (37 * hash) + METADATA_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataFiltersList().hashCode();
    }
    if (hasPathTemplateMatch()) {
      hash = (37 * hash) + PATH_TEMPLATE_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getPathTemplateMatch().hashCode();
    }
    if (hasPrefixMatch()) {
      hash = (37 * hash) + PREFIX_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getPrefixMatch().hashCode();
    }
    if (getQueryParameterMatchesCount() > 0) {
      hash = (37 * hash) + QUERY_PARAMETER_MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParameterMatchesList().hashCode();
    }
    if (hasRegexMatch()) {
      hash = (37 * hash) + REGEX_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getRegexMatch().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HttpRouteRuleMatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HttpRouteRuleMatch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HttpRouteRuleMatch)
      com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteRuleMatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteRuleMatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HttpRouteRuleMatch.class,
              com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HttpRouteRuleMatch.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fullPathMatch_ = "";
      if (headerMatchesBuilder_ == null) {
        headerMatches_ = java.util.Collections.emptyList();
      } else {
        headerMatches_ = null;
        headerMatchesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      ignoreCase_ = false;
      if (metadataFiltersBuilder_ == null) {
        metadataFilters_ = java.util.Collections.emptyList();
      } else {
        metadataFilters_ = null;
        metadataFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      pathTemplateMatch_ = "";
      prefixMatch_ = "";
      if (queryParameterMatchesBuilder_ == null) {
        queryParameterMatches_ = java.util.Collections.emptyList();
      } else {
        queryParameterMatches_ = null;
        queryParameterMatchesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      regexMatch_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteRuleMatch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteRuleMatch getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HttpRouteRuleMatch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteRuleMatch build() {
      com.google.cloud.compute.v1.HttpRouteRuleMatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteRuleMatch buildPartial() {
      com.google.cloud.compute.v1.HttpRouteRuleMatch result =
          new com.google.cloud.compute.v1.HttpRouteRuleMatch(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.HttpRouteRuleMatch result) {
      if (headerMatchesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          headerMatches_ = java.util.Collections.unmodifiableList(headerMatches_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.headerMatches_ = headerMatches_;
      } else {
        result.headerMatches_ = headerMatchesBuilder_.build();
      }
      if (metadataFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          metadataFilters_ = java.util.Collections.unmodifiableList(metadataFilters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.metadataFilters_ = metadataFilters_;
      } else {
        result.metadataFilters_ = metadataFiltersBuilder_.build();
      }
      if (queryParameterMatchesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          queryParameterMatches_ = java.util.Collections.unmodifiableList(queryParameterMatches_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.queryParameterMatches_ = queryParameterMatches_;
      } else {
        result.queryParameterMatches_ = queryParameterMatchesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.HttpRouteRuleMatch result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fullPathMatch_ = fullPathMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ignoreCase_ = ignoreCase_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pathTemplateMatch_ = pathTemplateMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.prefixMatch_ = prefixMatch_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.regexMatch_ = regexMatch_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HttpRouteRuleMatch) {
        return mergeFrom((com.google.cloud.compute.v1.HttpRouteRuleMatch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HttpRouteRuleMatch other) {
      if (other == com.google.cloud.compute.v1.HttpRouteRuleMatch.getDefaultInstance()) return this;
      if (other.hasFullPathMatch()) {
        fullPathMatch_ = other.fullPathMatch_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (headerMatchesBuilder_ == null) {
        if (!other.headerMatches_.isEmpty()) {
          if (headerMatches_.isEmpty()) {
            headerMatches_ = other.headerMatches_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureHeaderMatchesIsMutable();
            headerMatches_.addAll(other.headerMatches_);
          }
          onChanged();
        }
      } else {
        if (!other.headerMatches_.isEmpty()) {
          if (headerMatchesBuilder_.isEmpty()) {
            headerMatchesBuilder_.dispose();
            headerMatchesBuilder_ = null;
            headerMatches_ = other.headerMatches_;
            bitField0_ = (bitField0_ & ~0x00000002);
            headerMatchesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHeaderMatchesFieldBuilder()
                    : null;
          } else {
            headerMatchesBuilder_.addAllMessages(other.headerMatches_);
          }
        }
      }
      if (other.hasIgnoreCase()) {
        setIgnoreCase(other.getIgnoreCase());
      }
      if (metadataFiltersBuilder_ == null) {
        if (!other.metadataFilters_.isEmpty()) {
          if (metadataFilters_.isEmpty()) {
            metadataFilters_ = other.metadataFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureMetadataFiltersIsMutable();
            metadataFilters_.addAll(other.metadataFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.metadataFilters_.isEmpty()) {
          if (metadataFiltersBuilder_.isEmpty()) {
            metadataFiltersBuilder_.dispose();
            metadataFiltersBuilder_ = null;
            metadataFilters_ = other.metadataFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            metadataFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetadataFiltersFieldBuilder()
                    : null;
          } else {
            metadataFiltersBuilder_.addAllMessages(other.metadataFilters_);
          }
        }
      }
      if (other.hasPathTemplateMatch()) {
        pathTemplateMatch_ = other.pathTemplateMatch_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasPrefixMatch()) {
        prefixMatch_ = other.prefixMatch_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (queryParameterMatchesBuilder_ == null) {
        if (!other.queryParameterMatches_.isEmpty()) {
          if (queryParameterMatches_.isEmpty()) {
            queryParameterMatches_ = other.queryParameterMatches_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureQueryParameterMatchesIsMutable();
            queryParameterMatches_.addAll(other.queryParameterMatches_);
          }
          onChanged();
        }
      } else {
        if (!other.queryParameterMatches_.isEmpty()) {
          if (queryParameterMatchesBuilder_.isEmpty()) {
            queryParameterMatchesBuilder_.dispose();
            queryParameterMatchesBuilder_ = null;
            queryParameterMatches_ = other.queryParameterMatches_;
            bitField0_ = (bitField0_ & ~0x00000040);
            queryParameterMatchesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQueryParameterMatchesFieldBuilder()
                    : null;
          } else {
            queryParameterMatchesBuilder_.addAllMessages(other.queryParameterMatches_);
          }
        }
      }
      if (other.hasRegexMatch()) {
        regexMatch_ = other.regexMatch_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 859102826:
              {
                regexMatch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 859102826
            case 1716791002:
              {
                fullPathMatch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1716791002
            case 2063191746:
              {
                prefixMatch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 2063191746
            case -2005117134:
              {
                com.google.cloud.compute.v1.HttpQueryParameterMatch m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HttpQueryParameterMatch.parser(),
                        extensionRegistry);
                if (queryParameterMatchesBuilder_ == null) {
                  ensureQueryParameterMatchesIsMutable();
                  queryParameterMatches_.add(m);
                } else {
                  queryParameterMatchesBuilder_.addMessage(m);
                }
                break;
              } // case -2005117134
            case -1956181806:
              {
                pathTemplateMatch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1956181806
            case -1399739382:
              {
                com.google.cloud.compute.v1.HttpHeaderMatch m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HttpHeaderMatch.parser(), extensionRegistry);
                if (headerMatchesBuilder_ == null) {
                  ensureHeaderMatchesIsMutable();
                  headerMatches_.add(m);
                } else {
                  headerMatchesBuilder_.addMessage(m);
                }
                break;
              } // case -1399739382
            case -580367384:
              {
                ignoreCase_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -580367384
            case -577161382:
              {
                com.google.cloud.compute.v1.MetadataFilter m =
                    input.readMessage(
                        com.google.cloud.compute.v1.MetadataFilter.parser(), extensionRegistry);
                if (metadataFiltersBuilder_ == null) {
                  ensureMetadataFiltersIsMutable();
                  metadataFilters_.add(m);
                } else {
                  metadataFiltersBuilder_.addMessage(m);
                }
                break;
              } // case -577161382
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fullPathMatch_ = "";
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string full_path_match = 214598875;</code>
     *
     * @return Whether the fullPathMatch field is set.
     */
    public boolean hasFullPathMatch() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string full_path_match = 214598875;</code>
     *
     * @return The fullPathMatch.
     */
    public java.lang.String getFullPathMatch() {
      java.lang.Object ref = fullPathMatch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullPathMatch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string full_path_match = 214598875;</code>
     *
     * @return The bytes for fullPathMatch.
     */
    public com.google.protobuf.ByteString getFullPathMatchBytes() {
      java.lang.Object ref = fullPathMatch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullPathMatch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string full_path_match = 214598875;</code>
     *
     * @param value The fullPathMatch to set.
     * @return This builder for chaining.
     */
    public Builder setFullPathMatch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullPathMatch_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string full_path_match = 214598875;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullPathMatch() {
      fullPathMatch_ = getDefaultInstance().getFullPathMatch();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string full_path_match = 214598875;</code>
     *
     * @param value The bytes for fullPathMatch to set.
     * @return This builder for chaining.
     */
    public Builder setFullPathMatchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullPathMatch_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.HttpHeaderMatch> headerMatches_ =
        java.util.Collections.emptyList();

    private void ensureHeaderMatchesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        headerMatches_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.HttpHeaderMatch>(headerMatches_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderMatch,
            com.google.cloud.compute.v1.HttpHeaderMatch.Builder,
            com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder>
        headerMatchesBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpHeaderMatch> getHeaderMatchesList() {
      if (headerMatchesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(headerMatches_);
      } else {
        return headerMatchesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public int getHeaderMatchesCount() {
      if (headerMatchesBuilder_ == null) {
        return headerMatches_.size();
      } else {
        return headerMatchesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderMatch getHeaderMatches(int index) {
      if (headerMatchesBuilder_ == null) {
        return headerMatches_.get(index);
      } else {
        return headerMatchesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder setHeaderMatches(int index, com.google.cloud.compute.v1.HttpHeaderMatch value) {
      if (headerMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeaderMatchesIsMutable();
        headerMatches_.set(index, value);
        onChanged();
      } else {
        headerMatchesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder setHeaderMatches(
        int index, com.google.cloud.compute.v1.HttpHeaderMatch.Builder builderForValue) {
      if (headerMatchesBuilder_ == null) {
        ensureHeaderMatchesIsMutable();
        headerMatches_.set(index, builderForValue.build());
        onChanged();
      } else {
        headerMatchesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder addHeaderMatches(com.google.cloud.compute.v1.HttpHeaderMatch value) {
      if (headerMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeaderMatchesIsMutable();
        headerMatches_.add(value);
        onChanged();
      } else {
        headerMatchesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder addHeaderMatches(int index, com.google.cloud.compute.v1.HttpHeaderMatch value) {
      if (headerMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeaderMatchesIsMutable();
        headerMatches_.add(index, value);
        onChanged();
      } else {
        headerMatchesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder addHeaderMatches(
        com.google.cloud.compute.v1.HttpHeaderMatch.Builder builderForValue) {
      if (headerMatchesBuilder_ == null) {
        ensureHeaderMatchesIsMutable();
        headerMatches_.add(builderForValue.build());
        onChanged();
      } else {
        headerMatchesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder addHeaderMatches(
        int index, com.google.cloud.compute.v1.HttpHeaderMatch.Builder builderForValue) {
      if (headerMatchesBuilder_ == null) {
        ensureHeaderMatchesIsMutable();
        headerMatches_.add(index, builderForValue.build());
        onChanged();
      } else {
        headerMatchesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder addAllHeaderMatches(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HttpHeaderMatch> values) {
      if (headerMatchesBuilder_ == null) {
        ensureHeaderMatchesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headerMatches_);
        onChanged();
      } else {
        headerMatchesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder clearHeaderMatches() {
      if (headerMatchesBuilder_ == null) {
        headerMatches_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        headerMatchesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public Builder removeHeaderMatches(int index) {
      if (headerMatchesBuilder_ == null) {
        ensureHeaderMatchesIsMutable();
        headerMatches_.remove(index);
        onChanged();
      } else {
        headerMatchesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderMatch.Builder getHeaderMatchesBuilder(int index) {
      return getHeaderMatchesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder getHeaderMatchesOrBuilder(
        int index) {
      if (headerMatchesBuilder_ == null) {
        return headerMatches_.get(index);
      } else {
        return headerMatchesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder>
        getHeaderMatchesOrBuilderList() {
      if (headerMatchesBuilder_ != null) {
        return headerMatchesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(headerMatches_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderMatch.Builder addHeaderMatchesBuilder() {
      return getHeaderMatchesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HttpHeaderMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderMatch.Builder addHeaderMatchesBuilder(int index) {
      return getHeaderMatchesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.HttpHeaderMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of header match criteria, all of which must match corresponding headers in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderMatch header_matches = 361903489;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpHeaderMatch.Builder>
        getHeaderMatchesBuilderList() {
      return getHeaderMatchesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderMatch,
            com.google.cloud.compute.v1.HttpHeaderMatch.Builder,
            com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder>
        getHeaderMatchesFieldBuilder() {
      if (headerMatchesBuilder_ == null) {
        headerMatchesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderMatch,
                com.google.cloud.compute.v1.HttpHeaderMatch.Builder,
                com.google.cloud.compute.v1.HttpHeaderMatchOrBuilder>(
                headerMatches_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        headerMatches_ = null;
      }
      return headerMatchesBuilder_;
    }

    private boolean ignoreCase_;
    /**
     *
     *
     * <pre>
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional bool ignore_case = 464324989;</code>
     *
     * @return Whether the ignoreCase field is set.
     */
    @java.lang.Override
    public boolean hasIgnoreCase() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional bool ignore_case = 464324989;</code>
     *
     * @return The ignoreCase.
     */
    @java.lang.Override
    public boolean getIgnoreCase() {
      return ignoreCase_;
    }
    /**
     *
     *
     * <pre>
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional bool ignore_case = 464324989;</code>
     *
     * @param value The ignoreCase to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreCase(boolean value) {

      ignoreCase_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional bool ignore_case = 464324989;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreCase() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ignoreCase_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.MetadataFilter> metadataFilters_ =
        java.util.Collections.emptyList();

    private void ensureMetadataFiltersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        metadataFilters_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.MetadataFilter>(metadataFilters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.MetadataFilter,
            com.google.cloud.compute.v1.MetadataFilter.Builder,
            com.google.cloud.compute.v1.MetadataFilterOrBuilder>
        metadataFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.MetadataFilter> getMetadataFiltersList() {
      if (metadataFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metadataFilters_);
      } else {
        return metadataFiltersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public int getMetadataFiltersCount() {
      if (metadataFiltersBuilder_ == null) {
        return metadataFilters_.size();
      } else {
        return metadataFiltersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter getMetadataFilters(int index) {
      if (metadataFiltersBuilder_ == null) {
        return metadataFilters_.get(index);
      } else {
        return metadataFiltersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder setMetadataFilters(int index, com.google.cloud.compute.v1.MetadataFilter value) {
      if (metadataFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataFiltersIsMutable();
        metadataFilters_.set(index, value);
        onChanged();
      } else {
        metadataFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder setMetadataFilters(
        int index, com.google.cloud.compute.v1.MetadataFilter.Builder builderForValue) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        metadataFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(com.google.cloud.compute.v1.MetadataFilter value) {
      if (metadataFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(value);
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(int index, com.google.cloud.compute.v1.MetadataFilter value) {
      if (metadataFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(index, value);
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(
        com.google.cloud.compute.v1.MetadataFilter.Builder builderForValue) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(builderForValue.build());
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(
        int index, com.google.cloud.compute.v1.MetadataFilter.Builder builderForValue) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addAllMetadataFilters(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.MetadataFilter> values) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metadataFilters_);
        onChanged();
      } else {
        metadataFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder clearMetadataFilters() {
      if (metadataFiltersBuilder_ == null) {
        metadataFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        metadataFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder removeMetadataFilters(int index) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.remove(index);
        onChanged();
      } else {
        metadataFiltersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter.Builder getMetadataFiltersBuilder(int index) {
      return getMetadataFiltersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilterOrBuilder getMetadataFiltersOrBuilder(
        int index) {
      if (metadataFiltersBuilder_ == null) {
        return metadataFilters_.get(index);
      } else {
        return metadataFiltersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.MetadataFilterOrBuilder>
        getMetadataFiltersOrBuilderList() {
      if (metadataFiltersBuilder_ != null) {
        return metadataFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metadataFilters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter.Builder addMetadataFiltersBuilder() {
      return getMetadataFiltersFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.MetadataFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter.Builder addMetadataFiltersBuilder(int index) {
      return getMetadataFiltersFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.MetadataFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.MetadataFilter.Builder>
        getMetadataFiltersBuilderList() {
      return getMetadataFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.MetadataFilter,
            com.google.cloud.compute.v1.MetadataFilter.Builder,
            com.google.cloud.compute.v1.MetadataFilterOrBuilder>
        getMetadataFiltersFieldBuilder() {
      if (metadataFiltersBuilder_ == null) {
        metadataFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.MetadataFilter,
                com.google.cloud.compute.v1.MetadataFilter.Builder,
                com.google.cloud.compute.v1.MetadataFilterOrBuilder>(
                metadataFilters_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        metadataFilters_ = null;
      }
      return metadataFiltersBuilder_;
    }

    private java.lang.Object pathTemplateMatch_ = "";
    /**
     *
     *
     * <pre>
     * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
     * </pre>
     *
     * <code>optional string path_template_match = 292348186;</code>
     *
     * @return Whether the pathTemplateMatch field is set.
     */
    public boolean hasPathTemplateMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
     * </pre>
     *
     * <code>optional string path_template_match = 292348186;</code>
     *
     * @return The pathTemplateMatch.
     */
    public java.lang.String getPathTemplateMatch() {
      java.lang.Object ref = pathTemplateMatch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pathTemplateMatch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
     * </pre>
     *
     * <code>optional string path_template_match = 292348186;</code>
     *
     * @return The bytes for pathTemplateMatch.
     */
    public com.google.protobuf.ByteString getPathTemplateMatchBytes() {
      java.lang.Object ref = pathTemplateMatch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pathTemplateMatch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
     * </pre>
     *
     * <code>optional string path_template_match = 292348186;</code>
     *
     * @param value The pathTemplateMatch to set.
     * @return This builder for chaining.
     */
    public Builder setPathTemplateMatch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pathTemplateMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
     * </pre>
     *
     * <code>optional string path_template_match = 292348186;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPathTemplateMatch() {
      pathTemplateMatch_ = getDefaultInstance().getPathTemplateMatch();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the route is a pattern match expression that must match the :path header once the query string is removed. A pattern match allows you to match - The value must be between 1 and 1024 characters - The pattern must start with a leading slash ("/") - There may be no more than 5 operators in pattern Precisely one of prefix_match, full_path_match, regex_match or path_template_match must be set.
     * </pre>
     *
     * <code>optional string path_template_match = 292348186;</code>
     *
     * @param value The bytes for pathTemplateMatch to set.
     * @return This builder for chaining.
     */
    public Builder setPathTemplateMatchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pathTemplateMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object prefixMatch_ = "";
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string prefix_match = 257898968;</code>
     *
     * @return Whether the prefixMatch field is set.
     */
    public boolean hasPrefixMatch() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string prefix_match = 257898968;</code>
     *
     * @return The prefixMatch.
     */
    public java.lang.String getPrefixMatch() {
      java.lang.Object ref = prefixMatch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        prefixMatch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string prefix_match = 257898968;</code>
     *
     * @return The bytes for prefixMatch.
     */
    public com.google.protobuf.ByteString getPrefixMatchBytes() {
      java.lang.Object ref = prefixMatch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        prefixMatch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string prefix_match = 257898968;</code>
     *
     * @param value The prefixMatch to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixMatch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      prefixMatch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string prefix_match = 257898968;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrefixMatch() {
      prefixMatch_ = getDefaultInstance().getPrefixMatch();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
     * </pre>
     *
     * <code>optional string prefix_match = 257898968;</code>
     *
     * @param value The bytes for prefixMatch to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixMatchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      prefixMatch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.HttpQueryParameterMatch>
        queryParameterMatches_ = java.util.Collections.emptyList();

    private void ensureQueryParameterMatchesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        queryParameterMatches_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.HttpQueryParameterMatch>(
                queryParameterMatches_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpQueryParameterMatch,
            com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder,
            com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder>
        queryParameterMatchesBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpQueryParameterMatch>
        getQueryParameterMatchesList() {
      if (queryParameterMatchesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(queryParameterMatches_);
      } else {
        return queryParameterMatchesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public int getQueryParameterMatchesCount() {
      if (queryParameterMatchesBuilder_ == null) {
        return queryParameterMatches_.size();
      } else {
        return queryParameterMatchesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpQueryParameterMatch getQueryParameterMatches(int index) {
      if (queryParameterMatchesBuilder_ == null) {
        return queryParameterMatches_.get(index);
      } else {
        return queryParameterMatchesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder setQueryParameterMatches(
        int index, com.google.cloud.compute.v1.HttpQueryParameterMatch value) {
      if (queryParameterMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.set(index, value);
        onChanged();
      } else {
        queryParameterMatchesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder setQueryParameterMatches(
        int index, com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder builderForValue) {
      if (queryParameterMatchesBuilder_ == null) {
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.set(index, builderForValue.build());
        onChanged();
      } else {
        queryParameterMatchesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder addQueryParameterMatches(
        com.google.cloud.compute.v1.HttpQueryParameterMatch value) {
      if (queryParameterMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.add(value);
        onChanged();
      } else {
        queryParameterMatchesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder addQueryParameterMatches(
        int index, com.google.cloud.compute.v1.HttpQueryParameterMatch value) {
      if (queryParameterMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.add(index, value);
        onChanged();
      } else {
        queryParameterMatchesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder addQueryParameterMatches(
        com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder builderForValue) {
      if (queryParameterMatchesBuilder_ == null) {
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.add(builderForValue.build());
        onChanged();
      } else {
        queryParameterMatchesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder addQueryParameterMatches(
        int index, com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder builderForValue) {
      if (queryParameterMatchesBuilder_ == null) {
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.add(index, builderForValue.build());
        onChanged();
      } else {
        queryParameterMatchesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder addAllQueryParameterMatches(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HttpQueryParameterMatch> values) {
      if (queryParameterMatchesBuilder_ == null) {
        ensureQueryParameterMatchesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queryParameterMatches_);
        onChanged();
      } else {
        queryParameterMatchesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder clearQueryParameterMatches() {
      if (queryParameterMatchesBuilder_ == null) {
        queryParameterMatches_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        queryParameterMatchesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public Builder removeQueryParameterMatches(int index) {
      if (queryParameterMatchesBuilder_ == null) {
        ensureQueryParameterMatchesIsMutable();
        queryParameterMatches_.remove(index);
        onChanged();
      } else {
        queryParameterMatchesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder
        getQueryParameterMatchesBuilder(int index) {
      return getQueryParameterMatchesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder
        getQueryParameterMatchesOrBuilder(int index) {
      if (queryParameterMatchesBuilder_ == null) {
        return queryParameterMatches_.get(index);
      } else {
        return queryParameterMatchesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder>
        getQueryParameterMatchesOrBuilderList() {
      if (queryParameterMatchesBuilder_ != null) {
        return queryParameterMatchesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(queryParameterMatches_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder
        addQueryParameterMatchesBuilder() {
      return getQueryParameterMatchesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HttpQueryParameterMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder
        addQueryParameterMatchesBuilder(int index) {
      return getQueryParameterMatchesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.HttpQueryParameterMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.HttpQueryParameterMatch query_parameter_matches = 286231270;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder>
        getQueryParameterMatchesBuilderList() {
      return getQueryParameterMatchesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpQueryParameterMatch,
            com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder,
            com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder>
        getQueryParameterMatchesFieldBuilder() {
      if (queryParameterMatchesBuilder_ == null) {
        queryParameterMatchesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HttpQueryParameterMatch,
                com.google.cloud.compute.v1.HttpQueryParameterMatch.Builder,
                com.google.cloud.compute.v1.HttpQueryParameterMatchOrBuilder>(
                queryParameterMatches_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        queryParameterMatches_ = null;
      }
      return queryParameterMatchesBuilder_;
    }

    private java.lang.Object regexMatch_ = "";
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional string regex_match = 107387853;</code>
     *
     * @return Whether the regexMatch field is set.
     */
    public boolean hasRegexMatch() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional string regex_match = 107387853;</code>
     *
     * @return The regexMatch.
     */
    public java.lang.String getRegexMatch() {
      java.lang.Object ref = regexMatch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regexMatch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional string regex_match = 107387853;</code>
     *
     * @return The bytes for regexMatch.
     */
    public com.google.protobuf.ByteString getRegexMatchBytes() {
      java.lang.Object ref = regexMatch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regexMatch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional string regex_match = 107387853;</code>
     *
     * @param value The regexMatch to set.
     * @return This builder for chaining.
     */
    public Builder setRegexMatch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      regexMatch_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional string regex_match = 107387853;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegexMatch() {
      regexMatch_ = getDefaultInstance().getRegexMatch();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>optional string regex_match = 107387853;</code>
     *
     * @param value The bytes for regexMatch to set.
     * @return This builder for chaining.
     */
    public Builder setRegexMatchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      regexMatch_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HttpRouteRuleMatch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HttpRouteRuleMatch)
  private static final com.google.cloud.compute.v1.HttpRouteRuleMatch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HttpRouteRuleMatch();
  }

  public static com.google.cloud.compute.v1.HttpRouteRuleMatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRouteRuleMatch> PARSER =
      new com.google.protobuf.AbstractParser<HttpRouteRuleMatch>() {
        @java.lang.Override
        public HttpRouteRuleMatch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpRouteRuleMatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRouteRuleMatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteRuleMatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
