/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy}
 */
public final class InstanceGroupManagerUpdatePolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy)
    InstanceGroupManagerUpdatePolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceGroupManagerUpdatePolicy.newBuilder() to construct.
  private InstanceGroupManagerUpdatePolicy(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceGroupManagerUpdatePolicy() {
    instanceRedistributionType_ = "";
    minimalAction_ = "";
    mostDisruptiveAllowedAction_ = "";
    replacementMethod_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceGroupManagerUpdatePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceGroupManagerUpdatePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceGroupManagerUpdatePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.class,
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * NONE
   * PROACTIVE
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.InstanceRedistributionType}
   */
  public enum InstanceRedistributionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE = 0;</code>
     */
    UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE(0),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE = 0;</code>
     */
    public static final int UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE_VALUE = 0;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstanceRedistributionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InstanceRedistributionType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InstanceRedistributionType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InstanceRedistributionType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InstanceRedistributionType>() {
              public InstanceRedistributionType findValueByNumber(int number) {
                return InstanceRedistributionType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final InstanceRedistributionType[] VALUES = values();

    public static InstanceRedistributionType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InstanceRedistributionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.InstanceRedistributionType)
  }

  /**
   *
   *
   * <pre>
   * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * NONE
   * REFRESH
   * REPLACE
   * RESTART
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.MinimalAction}
   */
  public enum MinimalAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MINIMAL_ACTION = 0;</code>
     */
    UNDEFINED_MINIMAL_ACTION(0),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MINIMAL_ACTION = 0;</code>
     */
    public static final int UNDEFINED_MINIMAL_ACTION_VALUE = 0;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MinimalAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MinimalAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MINIMAL_ACTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MinimalAction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MinimalAction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MinimalAction>() {
          public MinimalAction findValueByNumber(int number) {
            return MinimalAction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final MinimalAction[] VALUES = values();

    public static MinimalAction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MinimalAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.MinimalAction)
  }

  /**
   *
   *
   * <pre>
   * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * NONE
   * REFRESH
   * REPLACE
   * RESTART
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.MostDisruptiveAllowedAction}
   */
  public enum MostDisruptiveAllowedAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION = 0;</code>
     */
    UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION(0),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION = 0;</code>
     */
    public static final int UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION_VALUE = 0;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MostDisruptiveAllowedAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MostDisruptiveAllowedAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MostDisruptiveAllowedAction>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MostDisruptiveAllowedAction>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MostDisruptiveAllowedAction>() {
              public MostDisruptiveAllowedAction findValueByNumber(int number) {
                return MostDisruptiveAllowedAction.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final MostDisruptiveAllowedAction[] VALUES = values();

    public static MostDisruptiveAllowedAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MostDisruptiveAllowedAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.MostDisruptiveAllowedAction)
  }

  /**
   *
   *
   * <pre>
   * What action should be used to replace instances. See minimal_action.REPLACE
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.ReplacementMethod}
   */
  public enum ReplacementMethod implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REPLACEMENT_METHOD = 0;</code>
     */
    UNDEFINED_REPLACEMENT_METHOD(0),
    /**
     *
     *
     * <pre>
     * Instances will be recreated (with the same name)
     * </pre>
     *
     * <code>RECREATE = 522644719;</code>
     */
    RECREATE(522644719),
    /**
     *
     *
     * <pre>
     * Default option: instances will be deleted and created (with a new name)
     * </pre>
     *
     * <code>SUBSTITUTE = 280924314;</code>
     */
    SUBSTITUTE(280924314),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REPLACEMENT_METHOD = 0;</code>
     */
    public static final int UNDEFINED_REPLACEMENT_METHOD_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Instances will be recreated (with the same name)
     * </pre>
     *
     * <code>RECREATE = 522644719;</code>
     */
    public static final int RECREATE_VALUE = 522644719;
    /**
     *
     *
     * <pre>
     * Default option: instances will be deleted and created (with a new name)
     * </pre>
     *
     * <code>SUBSTITUTE = 280924314;</code>
     */
    public static final int SUBSTITUTE_VALUE = 280924314;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReplacementMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReplacementMethod forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_REPLACEMENT_METHOD;
        case 522644719:
          return RECREATE;
        case 280924314:
          return SUBSTITUTE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReplacementMethod>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReplacementMethod>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ReplacementMethod>() {
              public ReplacementMethod findValueByNumber(int number) {
                return ReplacementMethod.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDescriptor()
          .getEnumTypes()
          .get(3);
    }

    private static final ReplacementMethod[] VALUES = values();

    public static ReplacementMethod valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReplacementMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.ReplacementMethod)
  }

  /**
   *
   *
   * <pre>
   * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * PROACTIVE
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * MIG will apply new configurations to existing VMs only when you selectively target specific or all VMs to be updated.
     * </pre>
     *
     * <code>OPPORTUNISTIC = 429530089;</code>
     */
    OPPORTUNISTIC(429530089),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * MIG will apply new configurations to existing VMs only when you selectively target specific or all VMs to be updated.
     * </pre>
     *
     * <code>OPPORTUNISTIC = 429530089;</code>
     */
    public static final int OPPORTUNISTIC_VALUE = 429530089;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 429530089:
          return OPPORTUNISTIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDescriptor()
          .getEnumTypes()
          .get(4);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Type)
  }

  private int bitField0_;
  public static final int INSTANCE_REDISTRIBUTION_TYPE_FIELD_NUMBER = 292630424;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceRedistributionType_ = "";
  /**
   *
   *
   * <pre>
   * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
   * Check the InstanceRedistributionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_redistribution_type = 292630424;</code>
   *
   * @return Whether the instanceRedistributionType field is set.
   */
  @java.lang.Override
  public boolean hasInstanceRedistributionType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
   * Check the InstanceRedistributionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_redistribution_type = 292630424;</code>
   *
   * @return The instanceRedistributionType.
   */
  @java.lang.Override
  public java.lang.String getInstanceRedistributionType() {
    java.lang.Object ref = instanceRedistributionType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceRedistributionType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
   * Check the InstanceRedistributionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_redistribution_type = 292630424;</code>
   *
   * @return The bytes for instanceRedistributionType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceRedistributionTypeBytes() {
    java.lang.Object ref = instanceRedistributionType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceRedistributionType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_SURGE_FIELD_NUMBER = 302572691;
  private com.google.cloud.compute.v1.FixedOrPercent maxSurge_;
  /**
   *
   *
   * <pre>
   * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
   *
   * @return Whether the maxSurge field is set.
   */
  @java.lang.Override
  public boolean hasMaxSurge() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
   *
   * @return The maxSurge.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FixedOrPercent getMaxSurge() {
    return maxSurge_ == null
        ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
        : maxSurge_;
  }
  /**
   *
   *
   * <pre>
   * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FixedOrPercentOrBuilder getMaxSurgeOrBuilder() {
    return maxSurge_ == null
        ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
        : maxSurge_;
  }

  public static final int MAX_UNAVAILABLE_FIELD_NUMBER = 404940277;
  private com.google.cloud.compute.v1.FixedOrPercent maxUnavailable_;
  /**
   *
   *
   * <pre>
   * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
   *
   * @return Whether the maxUnavailable field is set.
   */
  @java.lang.Override
  public boolean hasMaxUnavailable() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
   *
   * @return The maxUnavailable.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FixedOrPercent getMaxUnavailable() {
    return maxUnavailable_ == null
        ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
        : maxUnavailable_;
  }
  /**
   *
   *
   * <pre>
   * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FixedOrPercentOrBuilder getMaxUnavailableOrBuilder() {
    return maxUnavailable_ == null
        ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
        : maxUnavailable_;
  }

  public static final int MINIMAL_ACTION_FIELD_NUMBER = 270567060;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minimalAction_ = "";
  /**
   *
   *
   * <pre>
   * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
   * Check the MinimalAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string minimal_action = 270567060;</code>
   *
   * @return Whether the minimalAction field is set.
   */
  @java.lang.Override
  public boolean hasMinimalAction() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
   * Check the MinimalAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string minimal_action = 270567060;</code>
   *
   * @return The minimalAction.
   */
  @java.lang.Override
  public java.lang.String getMinimalAction() {
    java.lang.Object ref = minimalAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minimalAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
   * Check the MinimalAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string minimal_action = 270567060;</code>
   *
   * @return The bytes for minimalAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinimalActionBytes() {
    java.lang.Object ref = minimalAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minimalAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MOST_DISRUPTIVE_ALLOWED_ACTION_FIELD_NUMBER = 66103053;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mostDisruptiveAllowedAction_ = "";
  /**
   *
   *
   * <pre>
   * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
   * Check the MostDisruptiveAllowedAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string most_disruptive_allowed_action = 66103053;</code>
   *
   * @return Whether the mostDisruptiveAllowedAction field is set.
   */
  @java.lang.Override
  public boolean hasMostDisruptiveAllowedAction() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
   * Check the MostDisruptiveAllowedAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string most_disruptive_allowed_action = 66103053;</code>
   *
   * @return The mostDisruptiveAllowedAction.
   */
  @java.lang.Override
  public java.lang.String getMostDisruptiveAllowedAction() {
    java.lang.Object ref = mostDisruptiveAllowedAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mostDisruptiveAllowedAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
   * Check the MostDisruptiveAllowedAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string most_disruptive_allowed_action = 66103053;</code>
   *
   * @return The bytes for mostDisruptiveAllowedAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMostDisruptiveAllowedActionBytes() {
    java.lang.Object ref = mostDisruptiveAllowedAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mostDisruptiveAllowedAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLACEMENT_METHOD_FIELD_NUMBER = 505931694;

  @SuppressWarnings("serial")
  private volatile java.lang.Object replacementMethod_ = "";
  /**
   *
   *
   * <pre>
   * What action should be used to replace instances. See minimal_action.REPLACE
   * Check the ReplacementMethod enum for the list of possible values.
   * </pre>
   *
   * <code>optional string replacement_method = 505931694;</code>
   *
   * @return Whether the replacementMethod field is set.
   */
  @java.lang.Override
  public boolean hasReplacementMethod() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * What action should be used to replace instances. See minimal_action.REPLACE
   * Check the ReplacementMethod enum for the list of possible values.
   * </pre>
   *
   * <code>optional string replacement_method = 505931694;</code>
   *
   * @return The replacementMethod.
   */
  @java.lang.Override
  public java.lang.String getReplacementMethod() {
    java.lang.Object ref = replacementMethod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      replacementMethod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * What action should be used to replace instances. See minimal_action.REPLACE
   * Check the ReplacementMethod enum for the list of possible values.
   * </pre>
   *
   * <code>optional string replacement_method = 505931694;</code>
   *
   * @return The bytes for replacementMethod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReplacementMethodBytes() {
    java.lang.Object ref = replacementMethod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      replacementMethod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 66103053, mostDisruptiveAllowedAction_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 270567060, minimalAction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 292630424, instanceRedistributionType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(302572691, getMaxSurge());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(404940277, getMaxUnavailable());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 505931694, replacementMethod_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              66103053, mostDisruptiveAllowedAction_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(270567060, minimalAction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              292630424, instanceRedistributionType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(302572691, getMaxSurge());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(404940277, getMaxUnavailable());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(505931694, replacementMethod_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy other =
        (com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy) obj;

    if (hasInstanceRedistributionType() != other.hasInstanceRedistributionType()) return false;
    if (hasInstanceRedistributionType()) {
      if (!getInstanceRedistributionType().equals(other.getInstanceRedistributionType()))
        return false;
    }
    if (hasMaxSurge() != other.hasMaxSurge()) return false;
    if (hasMaxSurge()) {
      if (!getMaxSurge().equals(other.getMaxSurge())) return false;
    }
    if (hasMaxUnavailable() != other.hasMaxUnavailable()) return false;
    if (hasMaxUnavailable()) {
      if (!getMaxUnavailable().equals(other.getMaxUnavailable())) return false;
    }
    if (hasMinimalAction() != other.hasMinimalAction()) return false;
    if (hasMinimalAction()) {
      if (!getMinimalAction().equals(other.getMinimalAction())) return false;
    }
    if (hasMostDisruptiveAllowedAction() != other.hasMostDisruptiveAllowedAction()) return false;
    if (hasMostDisruptiveAllowedAction()) {
      if (!getMostDisruptiveAllowedAction().equals(other.getMostDisruptiveAllowedAction()))
        return false;
    }
    if (hasReplacementMethod() != other.hasReplacementMethod()) return false;
    if (hasReplacementMethod()) {
      if (!getReplacementMethod().equals(other.getReplacementMethod())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInstanceRedistributionType()) {
      hash = (37 * hash) + INSTANCE_REDISTRIBUTION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceRedistributionType().hashCode();
    }
    if (hasMaxSurge()) {
      hash = (37 * hash) + MAX_SURGE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxSurge().hashCode();
    }
    if (hasMaxUnavailable()) {
      hash = (37 * hash) + MAX_UNAVAILABLE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxUnavailable().hashCode();
    }
    if (hasMinimalAction()) {
      hash = (37 * hash) + MINIMAL_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getMinimalAction().hashCode();
    }
    if (hasMostDisruptiveAllowedAction()) {
      hash = (37 * hash) + MOST_DISRUPTIVE_ALLOWED_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getMostDisruptiveAllowedAction().hashCode();
    }
    if (hasReplacementMethod()) {
      hash = (37 * hash) + REPLACEMENT_METHOD_FIELD_NUMBER;
      hash = (53 * hash) + getReplacementMethod().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy)
      com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceGroupManagerUpdatePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceGroupManagerUpdatePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.class,
              com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMaxSurgeFieldBuilder();
        getMaxUnavailableFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceRedistributionType_ = "";
      maxSurge_ = null;
      if (maxSurgeBuilder_ != null) {
        maxSurgeBuilder_.dispose();
        maxSurgeBuilder_ = null;
      }
      maxUnavailable_ = null;
      if (maxUnavailableBuilder_ != null) {
        maxUnavailableBuilder_.dispose();
        maxUnavailableBuilder_ = null;
      }
      minimalAction_ = "";
      mostDisruptiveAllowedAction_ = "";
      replacementMethod_ = "";
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceGroupManagerUpdatePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy build() {
      com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy buildPartial() {
      com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy result =
          new com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceRedistributionType_ = instanceRedistributionType_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maxSurge_ = maxSurgeBuilder_ == null ? maxSurge_ : maxSurgeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxUnavailable_ =
            maxUnavailableBuilder_ == null ? maxUnavailable_ : maxUnavailableBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minimalAction_ = minimalAction_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.mostDisruptiveAllowedAction_ = mostDisruptiveAllowedAction_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.replacementMethod_ = replacementMethod_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy) {
        return mergeFrom((com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy other) {
      if (other
          == com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDefaultInstance())
        return this;
      if (other.hasInstanceRedistributionType()) {
        instanceRedistributionType_ = other.instanceRedistributionType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMaxSurge()) {
        mergeMaxSurge(other.getMaxSurge());
      }
      if (other.hasMaxUnavailable()) {
        mergeMaxUnavailable(other.getMaxUnavailable());
      }
      if (other.hasMinimalAction()) {
        minimalAction_ = other.minimalAction_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMostDisruptiveAllowedAction()) {
        mostDisruptiveAllowedAction_ = other.mostDisruptiveAllowedAction_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasReplacementMethod()) {
        replacementMethod_ = other.replacementMethod_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 28604882
            case 528824426:
              {
                mostDisruptiveAllowedAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 528824426
            case -2130430814:
              {
                minimalAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -2130430814
            case -1953923902:
              {
                instanceRedistributionType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1953923902
            case -1874385766:
              {
                input.readMessage(getMaxSurgeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1874385766
            case -1055445078:
              {
                input.readMessage(getMaxUnavailableFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1055445078
            case -247513742:
              {
                replacementMethod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -247513742
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceRedistributionType_ = "";
    /**
     *
     *
     * <pre>
     * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
     * Check the InstanceRedistributionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_redistribution_type = 292630424;</code>
     *
     * @return Whether the instanceRedistributionType field is set.
     */
    public boolean hasInstanceRedistributionType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
     * Check the InstanceRedistributionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_redistribution_type = 292630424;</code>
     *
     * @return The instanceRedistributionType.
     */
    public java.lang.String getInstanceRedistributionType() {
      java.lang.Object ref = instanceRedistributionType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceRedistributionType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
     * Check the InstanceRedistributionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_redistribution_type = 292630424;</code>
     *
     * @return The bytes for instanceRedistributionType.
     */
    public com.google.protobuf.ByteString getInstanceRedistributionTypeBytes() {
      java.lang.Object ref = instanceRedistributionType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceRedistributionType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
     * Check the InstanceRedistributionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_redistribution_type = 292630424;</code>
     *
     * @param value The instanceRedistributionType to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceRedistributionType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceRedistributionType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
     * Check the InstanceRedistributionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_redistribution_type = 292630424;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceRedistributionType() {
      instanceRedistributionType_ = getDefaultInstance().getInstanceRedistributionType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
     * Check the InstanceRedistributionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_redistribution_type = 292630424;</code>
     *
     * @param value The bytes for instanceRedistributionType to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceRedistributionTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceRedistributionType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.FixedOrPercent maxSurge_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FixedOrPercent,
            com.google.cloud.compute.v1.FixedOrPercent.Builder,
            com.google.cloud.compute.v1.FixedOrPercentOrBuilder>
        maxSurgeBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     *
     * @return Whether the maxSurge field is set.
     */
    public boolean hasMaxSurge() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     *
     * @return The maxSurge.
     */
    public com.google.cloud.compute.v1.FixedOrPercent getMaxSurge() {
      if (maxSurgeBuilder_ == null) {
        return maxSurge_ == null
            ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
            : maxSurge_;
      } else {
        return maxSurgeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    public Builder setMaxSurge(com.google.cloud.compute.v1.FixedOrPercent value) {
      if (maxSurgeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxSurge_ = value;
      } else {
        maxSurgeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    public Builder setMaxSurge(com.google.cloud.compute.v1.FixedOrPercent.Builder builderForValue) {
      if (maxSurgeBuilder_ == null) {
        maxSurge_ = builderForValue.build();
      } else {
        maxSurgeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    public Builder mergeMaxSurge(com.google.cloud.compute.v1.FixedOrPercent value) {
      if (maxSurgeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && maxSurge_ != null
            && maxSurge_ != com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()) {
          getMaxSurgeBuilder().mergeFrom(value);
        } else {
          maxSurge_ = value;
        }
      } else {
        maxSurgeBuilder_.mergeFrom(value);
      }
      if (maxSurge_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    public Builder clearMaxSurge() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maxSurge_ = null;
      if (maxSurgeBuilder_ != null) {
        maxSurgeBuilder_.dispose();
        maxSurgeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    public com.google.cloud.compute.v1.FixedOrPercent.Builder getMaxSurgeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMaxSurgeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    public com.google.cloud.compute.v1.FixedOrPercentOrBuilder getMaxSurgeOrBuilder() {
      if (maxSurgeBuilder_ != null) {
        return maxSurgeBuilder_.getMessageOrBuilder();
      } else {
        return maxSurge_ == null
            ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
            : maxSurge_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_surge = 302572691;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FixedOrPercent,
            com.google.cloud.compute.v1.FixedOrPercent.Builder,
            com.google.cloud.compute.v1.FixedOrPercentOrBuilder>
        getMaxSurgeFieldBuilder() {
      if (maxSurgeBuilder_ == null) {
        maxSurgeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.FixedOrPercent,
                com.google.cloud.compute.v1.FixedOrPercent.Builder,
                com.google.cloud.compute.v1.FixedOrPercentOrBuilder>(
                getMaxSurge(), getParentForChildren(), isClean());
        maxSurge_ = null;
      }
      return maxSurgeBuilder_;
    }

    private com.google.cloud.compute.v1.FixedOrPercent maxUnavailable_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FixedOrPercent,
            com.google.cloud.compute.v1.FixedOrPercent.Builder,
            com.google.cloud.compute.v1.FixedOrPercentOrBuilder>
        maxUnavailableBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     *
     * @return Whether the maxUnavailable field is set.
     */
    public boolean hasMaxUnavailable() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     *
     * @return The maxUnavailable.
     */
    public com.google.cloud.compute.v1.FixedOrPercent getMaxUnavailable() {
      if (maxUnavailableBuilder_ == null) {
        return maxUnavailable_ == null
            ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
            : maxUnavailable_;
      } else {
        return maxUnavailableBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    public Builder setMaxUnavailable(com.google.cloud.compute.v1.FixedOrPercent value) {
      if (maxUnavailableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxUnavailable_ = value;
      } else {
        maxUnavailableBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    public Builder setMaxUnavailable(
        com.google.cloud.compute.v1.FixedOrPercent.Builder builderForValue) {
      if (maxUnavailableBuilder_ == null) {
        maxUnavailable_ = builderForValue.build();
      } else {
        maxUnavailableBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    public Builder mergeMaxUnavailable(com.google.cloud.compute.v1.FixedOrPercent value) {
      if (maxUnavailableBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && maxUnavailable_ != null
            && maxUnavailable_ != com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()) {
          getMaxUnavailableBuilder().mergeFrom(value);
        } else {
          maxUnavailable_ = value;
        }
      } else {
        maxUnavailableBuilder_.mergeFrom(value);
      }
      if (maxUnavailable_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    public Builder clearMaxUnavailable() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxUnavailable_ = null;
      if (maxUnavailableBuilder_ != null) {
        maxUnavailableBuilder_.dispose();
        maxUnavailableBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    public com.google.cloud.compute.v1.FixedOrPercent.Builder getMaxUnavailableBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMaxUnavailableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    public com.google.cloud.compute.v1.FixedOrPercentOrBuilder getMaxUnavailableOrBuilder() {
      if (maxUnavailableBuilder_ != null) {
        return maxUnavailableBuilder_.getMessageOrBuilder();
      } else {
        return maxUnavailable_ == null
            ? com.google.cloud.compute.v1.FixedOrPercent.getDefaultInstance()
            : maxUnavailable_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FixedOrPercent max_unavailable = 404940277;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FixedOrPercent,
            com.google.cloud.compute.v1.FixedOrPercent.Builder,
            com.google.cloud.compute.v1.FixedOrPercentOrBuilder>
        getMaxUnavailableFieldBuilder() {
      if (maxUnavailableBuilder_ == null) {
        maxUnavailableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.FixedOrPercent,
                com.google.cloud.compute.v1.FixedOrPercent.Builder,
                com.google.cloud.compute.v1.FixedOrPercentOrBuilder>(
                getMaxUnavailable(), getParentForChildren(), isClean());
        maxUnavailable_ = null;
      }
      return maxUnavailableBuilder_;
    }

    private java.lang.Object minimalAction_ = "";
    /**
     *
     *
     * <pre>
     * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return Whether the minimalAction field is set.
     */
    public boolean hasMinimalAction() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return The minimalAction.
     */
    public java.lang.String getMinimalAction() {
      java.lang.Object ref = minimalAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minimalAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return The bytes for minimalAction.
     */
    public com.google.protobuf.ByteString getMinimalActionBytes() {
      java.lang.Object ref = minimalAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minimalAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @param value The minimalAction to set.
     * @return This builder for chaining.
     */
    public Builder setMinimalAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minimalAction_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinimalAction() {
      minimalAction_ = getDefaultInstance().getMinimalAction();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @param value The bytes for minimalAction to set.
     * @return This builder for chaining.
     */
    public Builder setMinimalActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minimalAction_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object mostDisruptiveAllowedAction_ = "";
    /**
     *
     *
     * <pre>
     * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return Whether the mostDisruptiveAllowedAction field is set.
     */
    public boolean hasMostDisruptiveAllowedAction() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return The mostDisruptiveAllowedAction.
     */
    public java.lang.String getMostDisruptiveAllowedAction() {
      java.lang.Object ref = mostDisruptiveAllowedAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mostDisruptiveAllowedAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return The bytes for mostDisruptiveAllowedAction.
     */
    public com.google.protobuf.ByteString getMostDisruptiveAllowedActionBytes() {
      java.lang.Object ref = mostDisruptiveAllowedAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mostDisruptiveAllowedAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @param value The mostDisruptiveAllowedAction to set.
     * @return This builder for chaining.
     */
    public Builder setMostDisruptiveAllowedAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mostDisruptiveAllowedAction_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMostDisruptiveAllowedAction() {
      mostDisruptiveAllowedAction_ = getDefaultInstance().getMostDisruptiveAllowedAction();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @param value The bytes for mostDisruptiveAllowedAction to set.
     * @return This builder for chaining.
     */
    public Builder setMostDisruptiveAllowedActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mostDisruptiveAllowedAction_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object replacementMethod_ = "";
    /**
     *
     *
     * <pre>
     * What action should be used to replace instances. See minimal_action.REPLACE
     * Check the ReplacementMethod enum for the list of possible values.
     * </pre>
     *
     * <code>optional string replacement_method = 505931694;</code>
     *
     * @return Whether the replacementMethod field is set.
     */
    public boolean hasReplacementMethod() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * What action should be used to replace instances. See minimal_action.REPLACE
     * Check the ReplacementMethod enum for the list of possible values.
     * </pre>
     *
     * <code>optional string replacement_method = 505931694;</code>
     *
     * @return The replacementMethod.
     */
    public java.lang.String getReplacementMethod() {
      java.lang.Object ref = replacementMethod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        replacementMethod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * What action should be used to replace instances. See minimal_action.REPLACE
     * Check the ReplacementMethod enum for the list of possible values.
     * </pre>
     *
     * <code>optional string replacement_method = 505931694;</code>
     *
     * @return The bytes for replacementMethod.
     */
    public com.google.protobuf.ByteString getReplacementMethodBytes() {
      java.lang.Object ref = replacementMethod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        replacementMethod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * What action should be used to replace instances. See minimal_action.REPLACE
     * Check the ReplacementMethod enum for the list of possible values.
     * </pre>
     *
     * <code>optional string replacement_method = 505931694;</code>
     *
     * @param value The replacementMethod to set.
     * @return This builder for chaining.
     */
    public Builder setReplacementMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      replacementMethod_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What action should be used to replace instances. See minimal_action.REPLACE
     * Check the ReplacementMethod enum for the list of possible values.
     * </pre>
     *
     * <code>optional string replacement_method = 505931694;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplacementMethod() {
      replacementMethod_ = getDefaultInstance().getReplacementMethod();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What action should be used to replace instances. See minimal_action.REPLACE
     * Check the ReplacementMethod enum for the list of possible values.
     * </pre>
     *
     * <code>optional string replacement_method = 505931694;</code>
     *
     * @param value The bytes for replacementMethod to set.
     * @return This builder for chaining.
     */
    public Builder setReplacementMethodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      replacementMethod_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy)
  private static final com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy();
  }

  public static com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceGroupManagerUpdatePolicy> PARSER =
      new com.google.protobuf.AbstractParser<InstanceGroupManagerUpdatePolicy>() {
        @java.lang.Override
        public InstanceGroupManagerUpdatePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceGroupManagerUpdatePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceGroupManagerUpdatePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
