/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Diagnostics information about the Interconnect connection, which contains detailed and current technical information about Google's side of the connection.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectDiagnostics}
 */
public final class InterconnectDiagnostics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectDiagnostics)
    InterconnectDiagnosticsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InterconnectDiagnostics.newBuilder() to construct.
  private InterconnectDiagnostics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectDiagnostics() {
    arpCaches_ = java.util.Collections.emptyList();
    bundleAggregationType_ = "";
    bundleOperationalStatus_ = "";
    links_ = java.util.Collections.emptyList();
    macAddress_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectDiagnostics();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectDiagnostics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectDiagnostics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectDiagnostics.class,
            com.google.cloud.compute.v1.InterconnectDiagnostics.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The aggregation type of the bundle interface.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectDiagnostics.BundleAggregationType}
   */
  public enum BundleAggregationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BUNDLE_AGGREGATION_TYPE = 0;</code>
     */
    UNDEFINED_BUNDLE_AGGREGATION_TYPE(0),
    /**
     *
     *
     * <pre>
     * LACP is enabled.
     * </pre>
     *
     * <code>BUNDLE_AGGREGATION_TYPE_LACP = 27758925;</code>
     */
    BUNDLE_AGGREGATION_TYPE_LACP(27758925),
    /**
     *
     *
     * <pre>
     * LACP is disabled.
     * </pre>
     *
     * <code>BUNDLE_AGGREGATION_TYPE_STATIC = 50678873;</code>
     */
    BUNDLE_AGGREGATION_TYPE_STATIC(50678873),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BUNDLE_AGGREGATION_TYPE = 0;</code>
     */
    public static final int UNDEFINED_BUNDLE_AGGREGATION_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * LACP is enabled.
     * </pre>
     *
     * <code>BUNDLE_AGGREGATION_TYPE_LACP = 27758925;</code>
     */
    public static final int BUNDLE_AGGREGATION_TYPE_LACP_VALUE = 27758925;
    /**
     *
     *
     * <pre>
     * LACP is disabled.
     * </pre>
     *
     * <code>BUNDLE_AGGREGATION_TYPE_STATIC = 50678873;</code>
     */
    public static final int BUNDLE_AGGREGATION_TYPE_STATIC_VALUE = 50678873;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BundleAggregationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BundleAggregationType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BUNDLE_AGGREGATION_TYPE;
        case 27758925:
          return BUNDLE_AGGREGATION_TYPE_LACP;
        case 50678873:
          return BUNDLE_AGGREGATION_TYPE_STATIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BundleAggregationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BundleAggregationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<BundleAggregationType>() {
              public BundleAggregationType findValueByNumber(int number) {
                return BundleAggregationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectDiagnostics.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final BundleAggregationType[] VALUES = values();

    public static BundleAggregationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BundleAggregationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectDiagnostics.BundleAggregationType)
  }

  /**
   *
   *
   * <pre>
   * The operational status of the bundle interface.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectDiagnostics.BundleOperationalStatus}
   */
  public enum BundleOperationalStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BUNDLE_OPERATIONAL_STATUS = 0;</code>
     */
    UNDEFINED_BUNDLE_OPERATIONAL_STATUS(0),
    /**
     *
     *
     * <pre>
     * If bundleAggregationType is LACP: LACP is not established and/or all links in the bundle have DOWN operational status. If bundleAggregationType is STATIC: one or more links in the bundle has DOWN operational status.
     * </pre>
     *
     * <code>BUNDLE_OPERATIONAL_STATUS_DOWN = 453842693;</code>
     */
    BUNDLE_OPERATIONAL_STATUS_DOWN(453842693),
    /**
     *
     *
     * <pre>
     * If bundleAggregationType is LACP: LACP is established and at least one link in the bundle has UP operational status. If bundleAggregationType is STATIC: all links in the bundle (typically just one) have UP operational status.
     * </pre>
     *
     * <code>BUNDLE_OPERATIONAL_STATUS_UP = 161366462;</code>
     */
    BUNDLE_OPERATIONAL_STATUS_UP(161366462),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BUNDLE_OPERATIONAL_STATUS = 0;</code>
     */
    public static final int UNDEFINED_BUNDLE_OPERATIONAL_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If bundleAggregationType is LACP: LACP is not established and/or all links in the bundle have DOWN operational status. If bundleAggregationType is STATIC: one or more links in the bundle has DOWN operational status.
     * </pre>
     *
     * <code>BUNDLE_OPERATIONAL_STATUS_DOWN = 453842693;</code>
     */
    public static final int BUNDLE_OPERATIONAL_STATUS_DOWN_VALUE = 453842693;
    /**
     *
     *
     * <pre>
     * If bundleAggregationType is LACP: LACP is established and at least one link in the bundle has UP operational status. If bundleAggregationType is STATIC: all links in the bundle (typically just one) have UP operational status.
     * </pre>
     *
     * <code>BUNDLE_OPERATIONAL_STATUS_UP = 161366462;</code>
     */
    public static final int BUNDLE_OPERATIONAL_STATUS_UP_VALUE = 161366462;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BundleOperationalStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BundleOperationalStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BUNDLE_OPERATIONAL_STATUS;
        case 453842693:
          return BUNDLE_OPERATIONAL_STATUS_DOWN;
        case 161366462:
          return BUNDLE_OPERATIONAL_STATUS_UP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BundleOperationalStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BundleOperationalStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<BundleOperationalStatus>() {
              public BundleOperationalStatus findValueByNumber(int number) {
                return BundleOperationalStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectDiagnostics.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final BundleOperationalStatus[] VALUES = values();

    public static BundleOperationalStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BundleOperationalStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectDiagnostics.BundleOperationalStatus)
  }

  private int bitField0_;
  public static final int ARP_CACHES_FIELD_NUMBER = 414591761;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry> arpCaches_;
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>
      getArpCachesList() {
    return arpCaches_;
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
      getArpCachesOrBuilderList() {
    return arpCaches_;
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public int getArpCachesCount() {
    return arpCaches_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry getArpCaches(int index) {
    return arpCaches_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder getArpCachesOrBuilder(
      int index) {
    return arpCaches_.get(index);
  }

  public static final int BUNDLE_AGGREGATION_TYPE_FIELD_NUMBER = 434939028;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bundleAggregationType_ = "";
  /**
   *
   *
   * <pre>
   * The aggregation type of the bundle interface.
   * Check the BundleAggregationType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bundle_aggregation_type = 434939028;</code>
   *
   * @return Whether the bundleAggregationType field is set.
   */
  @java.lang.Override
  public boolean hasBundleAggregationType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The aggregation type of the bundle interface.
   * Check the BundleAggregationType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bundle_aggregation_type = 434939028;</code>
   *
   * @return The bundleAggregationType.
   */
  @java.lang.Override
  public java.lang.String getBundleAggregationType() {
    java.lang.Object ref = bundleAggregationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bundleAggregationType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The aggregation type of the bundle interface.
   * Check the BundleAggregationType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bundle_aggregation_type = 434939028;</code>
   *
   * @return The bytes for bundleAggregationType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBundleAggregationTypeBytes() {
    java.lang.Object ref = bundleAggregationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bundleAggregationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUNDLE_OPERATIONAL_STATUS_FIELD_NUMBER = 106433500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bundleOperationalStatus_ = "";
  /**
   *
   *
   * <pre>
   * The operational status of the bundle interface.
   * Check the BundleOperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bundle_operational_status = 106433500;</code>
   *
   * @return Whether the bundleOperationalStatus field is set.
   */
  @java.lang.Override
  public boolean hasBundleOperationalStatus() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The operational status of the bundle interface.
   * Check the BundleOperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bundle_operational_status = 106433500;</code>
   *
   * @return The bundleOperationalStatus.
   */
  @java.lang.Override
  public java.lang.String getBundleOperationalStatus() {
    java.lang.Object ref = bundleOperationalStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bundleOperationalStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The operational status of the bundle interface.
   * Check the BundleOperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bundle_operational_status = 106433500;</code>
   *
   * @return The bytes for bundleOperationalStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBundleOperationalStatusBytes() {
    java.lang.Object ref = bundleOperationalStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bundleOperationalStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKS_FIELD_NUMBER = 102977465;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus> links_;
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus>
      getLinksList() {
    return links_;
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder>
      getLinksOrBuilderList() {
    return links_;
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
   * </code>
   */
  @java.lang.Override
  public int getLinksCount() {
    return links_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus getLinks(int index) {
    return links_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder getLinksOrBuilder(
      int index) {
    return links_.get(index);
  }

  public static final int MAC_ADDRESS_FIELD_NUMBER = 332540164;

  @SuppressWarnings("serial")
  private volatile java.lang.Object macAddress_ = "";
  /**
   *
   *
   * <pre>
   * The MAC address of the Interconnect's bundle interface.
   * </pre>
   *
   * <code>optional string mac_address = 332540164;</code>
   *
   * @return Whether the macAddress field is set.
   */
  @java.lang.Override
  public boolean hasMacAddress() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The MAC address of the Interconnect's bundle interface.
   * </pre>
   *
   * <code>optional string mac_address = 332540164;</code>
   *
   * @return The macAddress.
   */
  @java.lang.Override
  public java.lang.String getMacAddress() {
    java.lang.Object ref = macAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      macAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The MAC address of the Interconnect's bundle interface.
   * </pre>
   *
   * <code>optional string mac_address = 332540164;</code>
   *
   * @return The bytes for macAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMacAddressBytes() {
    java.lang.Object ref = macAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      macAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < links_.size(); i++) {
      output.writeMessage(102977465, links_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 106433500, bundleOperationalStatus_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 332540164, macAddress_);
    }
    for (int i = 0; i < arpCaches_.size(); i++) {
      output.writeMessage(414591761, arpCaches_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 434939028, bundleAggregationType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < links_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(102977465, links_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              106433500, bundleOperationalStatus_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(332540164, macAddress_);
    }
    for (int i = 0; i < arpCaches_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(414591761, arpCaches_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              434939028, bundleAggregationType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectDiagnostics)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectDiagnostics other =
        (com.google.cloud.compute.v1.InterconnectDiagnostics) obj;

    if (!getArpCachesList().equals(other.getArpCachesList())) return false;
    if (hasBundleAggregationType() != other.hasBundleAggregationType()) return false;
    if (hasBundleAggregationType()) {
      if (!getBundleAggregationType().equals(other.getBundleAggregationType())) return false;
    }
    if (hasBundleOperationalStatus() != other.hasBundleOperationalStatus()) return false;
    if (hasBundleOperationalStatus()) {
      if (!getBundleOperationalStatus().equals(other.getBundleOperationalStatus())) return false;
    }
    if (!getLinksList().equals(other.getLinksList())) return false;
    if (hasMacAddress() != other.hasMacAddress()) return false;
    if (hasMacAddress()) {
      if (!getMacAddress().equals(other.getMacAddress())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getArpCachesCount() > 0) {
      hash = (37 * hash) + ARP_CACHES_FIELD_NUMBER;
      hash = (53 * hash) + getArpCachesList().hashCode();
    }
    if (hasBundleAggregationType()) {
      hash = (37 * hash) + BUNDLE_AGGREGATION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getBundleAggregationType().hashCode();
    }
    if (hasBundleOperationalStatus()) {
      hash = (37 * hash) + BUNDLE_OPERATIONAL_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getBundleOperationalStatus().hashCode();
    }
    if (getLinksCount() > 0) {
      hash = (37 * hash) + LINKS_FIELD_NUMBER;
      hash = (53 * hash) + getLinksList().hashCode();
    }
    if (hasMacAddress()) {
      hash = (37 * hash) + MAC_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getMacAddress().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InterconnectDiagnostics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Diagnostics information about the Interconnect connection, which contains detailed and current technical information about Google's side of the connection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectDiagnostics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectDiagnostics)
      com.google.cloud.compute.v1.InterconnectDiagnosticsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectDiagnostics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectDiagnostics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectDiagnostics.class,
              com.google.cloud.compute.v1.InterconnectDiagnostics.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectDiagnostics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (arpCachesBuilder_ == null) {
        arpCaches_ = java.util.Collections.emptyList();
      } else {
        arpCaches_ = null;
        arpCachesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      bundleAggregationType_ = "";
      bundleOperationalStatus_ = "";
      if (linksBuilder_ == null) {
        links_ = java.util.Collections.emptyList();
      } else {
        links_ = null;
        linksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      macAddress_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectDiagnostics_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectDiagnostics getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectDiagnostics build() {
      com.google.cloud.compute.v1.InterconnectDiagnostics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectDiagnostics buildPartial() {
      com.google.cloud.compute.v1.InterconnectDiagnostics result =
          new com.google.cloud.compute.v1.InterconnectDiagnostics(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InterconnectDiagnostics result) {
      if (arpCachesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          arpCaches_ = java.util.Collections.unmodifiableList(arpCaches_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.arpCaches_ = arpCaches_;
      } else {
        result.arpCaches_ = arpCachesBuilder_.build();
      }
      if (linksBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          links_ = java.util.Collections.unmodifiableList(links_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.links_ = links_;
      } else {
        result.links_ = linksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectDiagnostics result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bundleAggregationType_ = bundleAggregationType_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bundleOperationalStatus_ = bundleOperationalStatus_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.macAddress_ = macAddress_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectDiagnostics) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectDiagnostics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectDiagnostics other) {
      if (other == com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance())
        return this;
      if (arpCachesBuilder_ == null) {
        if (!other.arpCaches_.isEmpty()) {
          if (arpCaches_.isEmpty()) {
            arpCaches_ = other.arpCaches_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureArpCachesIsMutable();
            arpCaches_.addAll(other.arpCaches_);
          }
          onChanged();
        }
      } else {
        if (!other.arpCaches_.isEmpty()) {
          if (arpCachesBuilder_.isEmpty()) {
            arpCachesBuilder_.dispose();
            arpCachesBuilder_ = null;
            arpCaches_ = other.arpCaches_;
            bitField0_ = (bitField0_ & ~0x00000001);
            arpCachesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getArpCachesFieldBuilder()
                    : null;
          } else {
            arpCachesBuilder_.addAllMessages(other.arpCaches_);
          }
        }
      }
      if (other.hasBundleAggregationType()) {
        bundleAggregationType_ = other.bundleAggregationType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasBundleOperationalStatus()) {
        bundleOperationalStatus_ = other.bundleOperationalStatus_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (linksBuilder_ == null) {
        if (!other.links_.isEmpty()) {
          if (links_.isEmpty()) {
            links_ = other.links_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureLinksIsMutable();
            links_.addAll(other.links_);
          }
          onChanged();
        }
      } else {
        if (!other.links_.isEmpty()) {
          if (linksBuilder_.isEmpty()) {
            linksBuilder_.dispose();
            linksBuilder_ = null;
            links_ = other.links_;
            bitField0_ = (bitField0_ & ~0x00000008);
            linksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLinksFieldBuilder()
                    : null;
          } else {
            linksBuilder_.addAllMessages(other.links_);
          }
        }
      }
      if (other.hasMacAddress()) {
        macAddress_ = other.macAddress_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 823819722:
              {
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.parser(),
                        extensionRegistry);
                if (linksBuilder_ == null) {
                  ensureLinksIsMutable();
                  links_.add(m);
                } else {
                  linksBuilder_.addMessage(m);
                }
                break;
              } // case 823819722
            case 851468002:
              {
                bundleOperationalStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 851468002
            case -1634645982:
              {
                macAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1634645982
            case -978233206:
              {
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.parser(),
                        extensionRegistry);
                if (arpCachesBuilder_ == null) {
                  ensureArpCachesIsMutable();
                  arpCaches_.add(m);
                } else {
                  arpCachesBuilder_.addMessage(m);
                }
                break;
              } // case -978233206
            case -815455070:
              {
                bundleAggregationType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -815455070
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry> arpCaches_ =
        java.util.Collections.emptyList();

    private void ensureArpCachesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        arpCaches_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>(
                arpCaches_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
        arpCachesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>
        getArpCachesList() {
      if (arpCachesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(arpCaches_);
      } else {
        return arpCachesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public int getArpCachesCount() {
      if (arpCachesBuilder_ == null) {
        return arpCaches_.size();
      } else {
        return arpCachesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry getArpCaches(int index) {
      if (arpCachesBuilder_ == null) {
        return arpCaches_.get(index);
      } else {
        return arpCachesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder setArpCaches(
        int index, com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry value) {
      if (arpCachesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArpCachesIsMutable();
        arpCaches_.set(index, value);
        onChanged();
      } else {
        arpCachesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder setArpCaches(
        int index,
        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder builderForValue) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.set(index, builderForValue.build());
        onChanged();
      } else {
        arpCachesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry value) {
      if (arpCachesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArpCachesIsMutable();
        arpCaches_.add(value);
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(
        int index, com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry value) {
      if (arpCachesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArpCachesIsMutable();
        arpCaches_.add(index, value);
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(
        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder builderForValue) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.add(builderForValue.build());
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(
        int index,
        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder builderForValue) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.add(index, builderForValue.build());
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addAllArpCaches(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>
            values) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, arpCaches_);
        onChanged();
      } else {
        arpCachesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder clearArpCaches() {
      if (arpCachesBuilder_ == null) {
        arpCaches_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        arpCachesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder removeArpCaches(int index) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.remove(index);
        onChanged();
      } else {
        arpCachesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder getArpCachesBuilder(
        int index) {
      return getArpCachesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder
        getArpCachesOrBuilder(int index) {
      if (arpCachesBuilder_ == null) {
        return arpCaches_.get(index);
      } else {
        return arpCachesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
        getArpCachesOrBuilderList() {
      if (arpCachesBuilder_ != null) {
        return arpCachesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(arpCaches_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder
        addArpCachesBuilder() {
      return getArpCachesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder addArpCachesBuilder(
        int index) {
      return getArpCachesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing individual neighbors currently seen by the Google router in the ARP cache for the Interconnect. This will be empty when the Interconnect is not bundled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder>
        getArpCachesBuilderList() {
      return getArpCachesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
        getArpCachesFieldBuilder() {
      if (arpCachesBuilder_ == null) {
        arpCachesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry,
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>(
                arpCaches_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        arpCaches_ = null;
      }
      return arpCachesBuilder_;
    }

    private java.lang.Object bundleAggregationType_ = "";
    /**
     *
     *
     * <pre>
     * The aggregation type of the bundle interface.
     * Check the BundleAggregationType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_aggregation_type = 434939028;</code>
     *
     * @return Whether the bundleAggregationType field is set.
     */
    public boolean hasBundleAggregationType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The aggregation type of the bundle interface.
     * Check the BundleAggregationType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_aggregation_type = 434939028;</code>
     *
     * @return The bundleAggregationType.
     */
    public java.lang.String getBundleAggregationType() {
      java.lang.Object ref = bundleAggregationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bundleAggregationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation type of the bundle interface.
     * Check the BundleAggregationType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_aggregation_type = 434939028;</code>
     *
     * @return The bytes for bundleAggregationType.
     */
    public com.google.protobuf.ByteString getBundleAggregationTypeBytes() {
      java.lang.Object ref = bundleAggregationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bundleAggregationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation type of the bundle interface.
     * Check the BundleAggregationType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_aggregation_type = 434939028;</code>
     *
     * @param value The bundleAggregationType to set.
     * @return This builder for chaining.
     */
    public Builder setBundleAggregationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bundleAggregationType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation type of the bundle interface.
     * Check the BundleAggregationType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_aggregation_type = 434939028;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBundleAggregationType() {
      bundleAggregationType_ = getDefaultInstance().getBundleAggregationType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation type of the bundle interface.
     * Check the BundleAggregationType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_aggregation_type = 434939028;</code>
     *
     * @param value The bytes for bundleAggregationType to set.
     * @return This builder for chaining.
     */
    public Builder setBundleAggregationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bundleAggregationType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object bundleOperationalStatus_ = "";
    /**
     *
     *
     * <pre>
     * The operational status of the bundle interface.
     * Check the BundleOperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_operational_status = 106433500;</code>
     *
     * @return Whether the bundleOperationalStatus field is set.
     */
    public boolean hasBundleOperationalStatus() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The operational status of the bundle interface.
     * Check the BundleOperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_operational_status = 106433500;</code>
     *
     * @return The bundleOperationalStatus.
     */
    public java.lang.String getBundleOperationalStatus() {
      java.lang.Object ref = bundleOperationalStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bundleOperationalStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The operational status of the bundle interface.
     * Check the BundleOperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_operational_status = 106433500;</code>
     *
     * @return The bytes for bundleOperationalStatus.
     */
    public com.google.protobuf.ByteString getBundleOperationalStatusBytes() {
      java.lang.Object ref = bundleOperationalStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bundleOperationalStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The operational status of the bundle interface.
     * Check the BundleOperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_operational_status = 106433500;</code>
     *
     * @param value The bundleOperationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setBundleOperationalStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bundleOperationalStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operational status of the bundle interface.
     * Check the BundleOperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_operational_status = 106433500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBundleOperationalStatus() {
      bundleOperationalStatus_ = getDefaultInstance().getBundleOperationalStatus();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operational status of the bundle interface.
     * Check the BundleOperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string bundle_operational_status = 106433500;</code>
     *
     * @param value The bytes for bundleOperationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setBundleOperationalStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bundleOperationalStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus> links_ =
        java.util.Collections.emptyList();

    private void ensureLinksIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        links_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus>(
                links_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder>
        linksBuilder_;

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus>
        getLinksList() {
      if (linksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(links_);
      } else {
        return linksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public int getLinksCount() {
      if (linksBuilder_ == null) {
        return links_.size();
      } else {
        return linksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus getLinks(int index) {
      if (linksBuilder_ == null) {
        return links_.get(index);
      } else {
        return linksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder setLinks(
        int index, com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus value) {
      if (linksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinksIsMutable();
        links_.set(index, value);
        onChanged();
      } else {
        linksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder setLinks(
        int index,
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder builderForValue) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.set(index, builderForValue.build());
        onChanged();
      } else {
        linksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder addLinks(com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus value) {
      if (linksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinksIsMutable();
        links_.add(value);
        onChanged();
      } else {
        linksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder addLinks(
        int index, com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus value) {
      if (linksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinksIsMutable();
        links_.add(index, value);
        onChanged();
      } else {
        linksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder addLinks(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder builderForValue) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.add(builderForValue.build());
        onChanged();
      } else {
        linksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder addLinks(
        int index,
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder builderForValue) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.add(index, builderForValue.build());
        onChanged();
      } else {
        linksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder addAllLinks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus>
            values) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, links_);
        onChanged();
      } else {
        linksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder clearLinks() {
      if (linksBuilder_ == null) {
        links_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        linksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public Builder removeLinks(int index) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.remove(index);
        onChanged();
      } else {
        linksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder getLinksBuilder(
        int index) {
      return getLinksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder getLinksOrBuilder(
        int index) {
      if (linksBuilder_ == null) {
        return links_.get(index);
      } else {
        return linksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder>
        getLinksOrBuilderList() {
      if (linksBuilder_ != null) {
        return linksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(links_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder addLinksBuilder() {
      return getLinksFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder addLinksBuilder(
        int index) {
      return getLinksFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.LinkStatus objects, describing the status for each link on the Interconnect.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus links = 102977465;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder>
        getLinksBuilderList() {
      return getLinksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder>
        getLinksFieldBuilder() {
      if (linksBuilder_ == null) {
        linksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder>(
                links_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        links_ = null;
      }
      return linksBuilder_;
    }

    private java.lang.Object macAddress_ = "";
    /**
     *
     *
     * <pre>
     * The MAC address of the Interconnect's bundle interface.
     * </pre>
     *
     * <code>optional string mac_address = 332540164;</code>
     *
     * @return Whether the macAddress field is set.
     */
    public boolean hasMacAddress() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The MAC address of the Interconnect's bundle interface.
     * </pre>
     *
     * <code>optional string mac_address = 332540164;</code>
     *
     * @return The macAddress.
     */
    public java.lang.String getMacAddress() {
      java.lang.Object ref = macAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        macAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The MAC address of the Interconnect's bundle interface.
     * </pre>
     *
     * <code>optional string mac_address = 332540164;</code>
     *
     * @return The bytes for macAddress.
     */
    public com.google.protobuf.ByteString getMacAddressBytes() {
      java.lang.Object ref = macAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        macAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The MAC address of the Interconnect's bundle interface.
     * </pre>
     *
     * <code>optional string mac_address = 332540164;</code>
     *
     * @param value The macAddress to set.
     * @return This builder for chaining.
     */
    public Builder setMacAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      macAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MAC address of the Interconnect's bundle interface.
     * </pre>
     *
     * <code>optional string mac_address = 332540164;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMacAddress() {
      macAddress_ = getDefaultInstance().getMacAddress();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MAC address of the Interconnect's bundle interface.
     * </pre>
     *
     * <code>optional string mac_address = 332540164;</code>
     *
     * @param value The bytes for macAddress to set.
     * @return This builder for chaining.
     */
    public Builder setMacAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      macAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectDiagnostics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectDiagnostics)
  private static final com.google.cloud.compute.v1.InterconnectDiagnostics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectDiagnostics();
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnostics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectDiagnostics> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectDiagnostics>() {
        @java.lang.Override
        public InterconnectDiagnostics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectDiagnostics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectDiagnostics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnostics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
