/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an Interconnect Attachment (VLAN) Location resource. You can use this resource to find location details about an Interconnect attachment (VLAN). For more information about interconnect attachments, read Creating VLAN Attachments.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectLocation}
 */
public final class InterconnectLocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectLocation)
    InterconnectLocationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InterconnectLocation.newBuilder() to construct.
  private InterconnectLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectLocation() {
    address_ = "";
    availabilityZone_ = "";
    availableFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
    availableLinkTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    city_ = "";
    continent_ = "";
    creationTimestamp_ = "";
    description_ = "";
    facilityProvider_ = "";
    facilityProviderFacilityId_ = "";
    kind_ = "";
    name_ = "";
    peeringdbFacilityId_ = "";
    regionInfos_ = java.util.Collections.emptyList();
    selfLink_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectLocation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectLocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectLocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectLocation.class,
            com.google.cloud.compute.v1.InterconnectLocation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectLocation.AvailableFeatures}
   */
  public enum AvailableFeatures implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AVAILABLE_FEATURES = 0;</code>
     */
    UNDEFINED_AVAILABLE_FEATURES(0),
    /**
     *
     *
     * <pre>
     * Media Access Control security (MACsec)
     * </pre>
     *
     * <code>IF_MACSEC = 396279300;</code>
     */
    IF_MACSEC(396279300),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AVAILABLE_FEATURES = 0;</code>
     */
    public static final int UNDEFINED_AVAILABLE_FEATURES_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Media Access Control security (MACsec)
     * </pre>
     *
     * <code>IF_MACSEC = 396279300;</code>
     */
    public static final int IF_MACSEC_VALUE = 396279300;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AvailableFeatures valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AvailableFeatures forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_AVAILABLE_FEATURES;
        case 396279300:
          return IF_MACSEC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AvailableFeatures>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AvailableFeatures>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AvailableFeatures>() {
              public AvailableFeatures findValueByNumber(int number) {
                return AvailableFeatures.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectLocation.getDescriptor().getEnumTypes().get(0);
    }

    private static final AvailableFeatures[] VALUES = values();

    public static AvailableFeatures valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AvailableFeatures(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectLocation.AvailableFeatures)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectLocation.AvailableLinkTypes}
   */
  public enum AvailableLinkTypes implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AVAILABLE_LINK_TYPES = 0;</code>
     */
    UNDEFINED_AVAILABLE_LINK_TYPES(0),
    /**
     *
     *
     * <pre>
     * 100G Ethernet, LR Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_100G_LR = 337672551;</code>
     */
    LINK_TYPE_ETHERNET_100G_LR(337672551),
    /**
     *
     *
     * <pre>
     * 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_10G_LR = 236739749;</code>
     */
    LINK_TYPE_ETHERNET_10G_LR(236739749),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AVAILABLE_LINK_TYPES = 0;</code>
     */
    public static final int UNDEFINED_AVAILABLE_LINK_TYPES_VALUE = 0;
    /**
     *
     *
     * <pre>
     * 100G Ethernet, LR Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_100G_LR = 337672551;</code>
     */
    public static final int LINK_TYPE_ETHERNET_100G_LR_VALUE = 337672551;
    /**
     *
     *
     * <pre>
     * 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_10G_LR = 236739749;</code>
     */
    public static final int LINK_TYPE_ETHERNET_10G_LR_VALUE = 236739749;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AvailableLinkTypes valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AvailableLinkTypes forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_AVAILABLE_LINK_TYPES;
        case 337672551:
          return LINK_TYPE_ETHERNET_100G_LR;
        case 236739749:
          return LINK_TYPE_ETHERNET_10G_LR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AvailableLinkTypes>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AvailableLinkTypes>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AvailableLinkTypes>() {
              public AvailableLinkTypes findValueByNumber(int number) {
                return AvailableLinkTypes.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectLocation.getDescriptor().getEnumTypes().get(1);
    }

    private static final AvailableLinkTypes[] VALUES = values();

    public static AvailableLinkTypes valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AvailableLinkTypes(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectLocation.AvailableLinkTypes)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectLocation.Continent}
   */
  public enum Continent implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONTINENT = 0;</code>
     */
    UNDEFINED_CONTINENT(0),
    /** <code>AFRICA = 317443706;</code> */
    AFRICA(317443706),
    /** <code>ASIA_PAC = 119782269;</code> */
    ASIA_PAC(119782269),
    /** <code>C_AFRICA = 71993846;</code> */
    C_AFRICA(71993846),
    /** <code>C_ASIA_PAC = 465668089;</code> */
    C_ASIA_PAC(465668089),
    /** <code>C_EUROPE = 200369438;</code> */
    C_EUROPE(200369438),
    /** <code>C_NORTH_AMERICA = 275697048;</code> */
    C_NORTH_AMERICA(275697048),
    /** <code>C_SOUTH_AMERICA = 397149792;</code> */
    C_SOUTH_AMERICA(397149792),
    /** <code>EUROPE = 445819298;</code> */
    EUROPE(445819298),
    /** <code>NORTH_AMERICA = 448015508;</code> */
    NORTH_AMERICA(448015508),
    /** <code>SOUTH_AMERICA = 32597340;</code> */
    SOUTH_AMERICA(32597340),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONTINENT = 0;</code>
     */
    public static final int UNDEFINED_CONTINENT_VALUE = 0;
    /** <code>AFRICA = 317443706;</code> */
    public static final int AFRICA_VALUE = 317443706;
    /** <code>ASIA_PAC = 119782269;</code> */
    public static final int ASIA_PAC_VALUE = 119782269;
    /** <code>C_AFRICA = 71993846;</code> */
    public static final int C_AFRICA_VALUE = 71993846;
    /** <code>C_ASIA_PAC = 465668089;</code> */
    public static final int C_ASIA_PAC_VALUE = 465668089;
    /** <code>C_EUROPE = 200369438;</code> */
    public static final int C_EUROPE_VALUE = 200369438;
    /** <code>C_NORTH_AMERICA = 275697048;</code> */
    public static final int C_NORTH_AMERICA_VALUE = 275697048;
    /** <code>C_SOUTH_AMERICA = 397149792;</code> */
    public static final int C_SOUTH_AMERICA_VALUE = 397149792;
    /** <code>EUROPE = 445819298;</code> */
    public static final int EUROPE_VALUE = 445819298;
    /** <code>NORTH_AMERICA = 448015508;</code> */
    public static final int NORTH_AMERICA_VALUE = 448015508;
    /** <code>SOUTH_AMERICA = 32597340;</code> */
    public static final int SOUTH_AMERICA_VALUE = 32597340;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Continent valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Continent forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CONTINENT;
        case 317443706:
          return AFRICA;
        case 119782269:
          return ASIA_PAC;
        case 71993846:
          return C_AFRICA;
        case 465668089:
          return C_ASIA_PAC;
        case 200369438:
          return C_EUROPE;
        case 275697048:
          return C_NORTH_AMERICA;
        case 397149792:
          return C_SOUTH_AMERICA;
        case 445819298:
          return EUROPE;
        case 448015508:
          return NORTH_AMERICA;
        case 32597340:
          return SOUTH_AMERICA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Continent> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Continent> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Continent>() {
          public Continent findValueByNumber(int number) {
            return Continent.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectLocation.getDescriptor().getEnumTypes().get(2);
    }

    private static final Continent[] VALUES = values();

    public static Continent valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Continent(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectLocation.Continent)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectLocation.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The InterconnectLocation is available for provisioning new Interconnects.
     * </pre>
     *
     * <code>AVAILABLE = 442079913;</code>
     */
    AVAILABLE(442079913),
    /**
     *
     *
     * <pre>
     * The InterconnectLocation is closed for provisioning new Interconnects.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    CLOSED(380163436),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The InterconnectLocation is available for provisioning new Interconnects.
     * </pre>
     *
     * <code>AVAILABLE = 442079913;</code>
     */
    public static final int AVAILABLE_VALUE = 442079913;
    /**
     *
     *
     * <pre>
     * The InterconnectLocation is closed for provisioning new Interconnects.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    public static final int CLOSED_VALUE = 380163436;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 442079913:
          return AVAILABLE;
        case 380163436:
          return CLOSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectLocation.getDescriptor().getEnumTypes().get(3);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectLocation.Status)
  }

  private int bitField0_;
  public static final int ADDRESS_FIELD_NUMBER = 462920692;

  @SuppressWarnings("serial")
  private volatile java.lang.Object address_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
   * </pre>
   *
   * <code>optional string address = 462920692;</code>
   *
   * @return Whether the address field is set.
   */
  @java.lang.Override
  public boolean hasAddress() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
   * </pre>
   *
   * <code>optional string address = 462920692;</code>
   *
   * @return The address.
   */
  @java.lang.Override
  public java.lang.String getAddress() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      address_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
   * </pre>
   *
   * <code>optional string address = 462920692;</code>
   *
   * @return The bytes for address.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAddressBytes() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      address_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABILITY_ZONE_FIELD_NUMBER = 158459920;

  @SuppressWarnings("serial")
  private volatile java.lang.Object availabilityZone_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
   * </pre>
   *
   * <code>optional string availability_zone = 158459920;</code>
   *
   * @return Whether the availabilityZone field is set.
   */
  @java.lang.Override
  public boolean hasAvailabilityZone() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
   * </pre>
   *
   * <code>optional string availability_zone = 158459920;</code>
   *
   * @return The availabilityZone.
   */
  @java.lang.Override
  public java.lang.String getAvailabilityZone() {
    java.lang.Object ref = availabilityZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      availabilityZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
   * </pre>
   *
   * <code>optional string availability_zone = 158459920;</code>
   *
   * @return The bytes for availabilityZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAvailabilityZoneBytes() {
    java.lang.Object ref = availabilityZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      availabilityZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABLE_FEATURES_FIELD_NUMBER = 496344307;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList availableFeatures_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
   * Check the AvailableFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_features = 496344307;</code>
   *
   * @return A list containing the availableFeatures.
   */
  public com.google.protobuf.ProtocolStringList getAvailableFeaturesList() {
    return availableFeatures_;
  }
  /**
   *
   *
   * <pre>
   * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
   * Check the AvailableFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_features = 496344307;</code>
   *
   * @return The count of availableFeatures.
   */
  public int getAvailableFeaturesCount() {
    return availableFeatures_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
   * Check the AvailableFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_features = 496344307;</code>
   *
   * @param index The index of the element to return.
   * @return The availableFeatures at the given index.
   */
  public java.lang.String getAvailableFeatures(int index) {
    return availableFeatures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
   * Check the AvailableFeatures enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_features = 496344307;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the availableFeatures at the given index.
   */
  public com.google.protobuf.ByteString getAvailableFeaturesBytes(int index) {
    return availableFeatures_.getByteString(index);
  }

  public static final int AVAILABLE_LINK_TYPES_FIELD_NUMBER = 509504298;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList availableLinkTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
   * Check the AvailableLinkTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_link_types = 509504298;</code>
   *
   * @return A list containing the availableLinkTypes.
   */
  public com.google.protobuf.ProtocolStringList getAvailableLinkTypesList() {
    return availableLinkTypes_;
  }
  /**
   *
   *
   * <pre>
   * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
   * Check the AvailableLinkTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_link_types = 509504298;</code>
   *
   * @return The count of availableLinkTypes.
   */
  public int getAvailableLinkTypesCount() {
    return availableLinkTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
   * Check the AvailableLinkTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_link_types = 509504298;</code>
   *
   * @param index The index of the element to return.
   * @return The availableLinkTypes at the given index.
   */
  public java.lang.String getAvailableLinkTypes(int index) {
    return availableLinkTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
   * Check the AvailableLinkTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string available_link_types = 509504298;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the availableLinkTypes at the given index.
   */
  public com.google.protobuf.ByteString getAvailableLinkTypesBytes(int index) {
    return availableLinkTypes_.getByteString(index);
  }

  public static final int CITY_FIELD_NUMBER = 3053931;

  @SuppressWarnings("serial")
  private volatile java.lang.Object city_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
   * </pre>
   *
   * <code>optional string city = 3053931;</code>
   *
   * @return Whether the city field is set.
   */
  @java.lang.Override
  public boolean hasCity() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
   * </pre>
   *
   * <code>optional string city = 3053931;</code>
   *
   * @return The city.
   */
  @java.lang.Override
  public java.lang.String getCity() {
    java.lang.Object ref = city_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      city_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
   * </pre>
   *
   * <code>optional string city = 3053931;</code>
   *
   * @return The bytes for city.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCityBytes() {
    java.lang.Object ref = city_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      city_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTINENT_FIELD_NUMBER = 133442996;

  @SuppressWarnings("serial")
  private volatile java.lang.Object continent_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * Check the Continent enum for the list of possible values.
   * </pre>
   *
   * <code>optional string continent = 133442996;</code>
   *
   * @return Whether the continent field is set.
   */
  @java.lang.Override
  public boolean hasContinent() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * Check the Continent enum for the list of possible values.
   * </pre>
   *
   * <code>optional string continent = 133442996;</code>
   *
   * @return The continent.
   */
  @java.lang.Override
  public java.lang.String getContinent() {
    java.lang.Object ref = continent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      continent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * Check the Continent enum for the list of possible values.
   * </pre>
   *
   * <code>optional string continent = 133442996;</code>
   *
   * @return The bytes for continent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContinentBytes() {
    java.lang.Object ref = continent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      continent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACILITY_PROVIDER_FIELD_NUMBER = 533303309;

  @SuppressWarnings("serial")
  private volatile java.lang.Object facilityProvider_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
   * </pre>
   *
   * <code>optional string facility_provider = 533303309;</code>
   *
   * @return Whether the facilityProvider field is set.
   */
  @java.lang.Override
  public boolean hasFacilityProvider() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
   * </pre>
   *
   * <code>optional string facility_provider = 533303309;</code>
   *
   * @return The facilityProvider.
   */
  @java.lang.Override
  public java.lang.String getFacilityProvider() {
    java.lang.Object ref = facilityProvider_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      facilityProvider_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
   * </pre>
   *
   * <code>optional string facility_provider = 533303309;</code>
   *
   * @return The bytes for facilityProvider.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFacilityProviderBytes() {
    java.lang.Object ref = facilityProvider_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      facilityProvider_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACILITY_PROVIDER_FACILITY_ID_FIELD_NUMBER = 87269125;

  @SuppressWarnings("serial")
  private volatile java.lang.Object facilityProviderFacilityId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
   * </pre>
   *
   * <code>optional string facility_provider_facility_id = 87269125;</code>
   *
   * @return Whether the facilityProviderFacilityId field is set.
   */
  @java.lang.Override
  public boolean hasFacilityProviderFacilityId() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
   * </pre>
   *
   * <code>optional string facility_provider_facility_id = 87269125;</code>
   *
   * @return The facilityProviderFacilityId.
   */
  @java.lang.Override
  public java.lang.String getFacilityProviderFacilityId() {
    java.lang.Object ref = facilityProviderFacilityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      facilityProviderFacilityId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
   * </pre>
   *
   * <code>optional string facility_provider_facility_id = 87269125;</code>
   *
   * @return The bytes for facilityProviderFacilityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFacilityProviderFacilityIdBytes() {
    java.lang.Object ref = facilityProviderFacilityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      facilityProviderFacilityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEERINGDB_FACILITY_ID_FIELD_NUMBER = 536567094;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peeringdbFacilityId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
   * </pre>
   *
   * <code>optional string peeringdb_facility_id = 536567094;</code>
   *
   * @return Whether the peeringdbFacilityId field is set.
   */
  @java.lang.Override
  public boolean hasPeeringdbFacilityId() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
   * </pre>
   *
   * <code>optional string peeringdb_facility_id = 536567094;</code>
   *
   * @return The peeringdbFacilityId.
   */
  @java.lang.Override
  public java.lang.String getPeeringdbFacilityId() {
    java.lang.Object ref = peeringdbFacilityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peeringdbFacilityId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
   * </pre>
   *
   * <code>optional string peeringdb_facility_id = 536567094;</code>
   *
   * @return The bytes for peeringdbFacilityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeeringdbFacilityIdBytes() {
    java.lang.Object ref = peeringdbFacilityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peeringdbFacilityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_INFOS_FIELD_NUMBER = 312194170;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectLocationRegionInfo> regionInfos_;
  /**
   *
   *
   * <pre>
   * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectLocationRegionInfo>
      getRegionInfosList() {
    return regionInfos_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder>
      getRegionInfosOrBuilderList() {
    return regionInfos_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
   * </code>
   */
  @java.lang.Override
  public int getRegionInfosCount() {
    return regionInfos_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectLocationRegionInfo getRegionInfos(int index) {
    return regionInfos_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder
      getRegionInfosOrBuilder(int index) {
    return regionInfos_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTS_PZS_FIELD_NUMBER = 83983214;
  private boolean supportsPzs_ = false;
  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool supports_pzs = 83983214;</code>
   *
   * @return Whether the supportsPzs field is set.
   */
  @java.lang.Override
  public boolean hasSupportsPzs() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool supports_pzs = 83983214;</code>
   *
   * @return The supportsPzs.
   */
  @java.lang.Override
  public boolean getSupportsPzs() {
    return supportsPzs_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3053931, city_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeBool(83983214, supportsPzs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 87269125, facilityProviderFacilityId_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 133442996, continent_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 158459920, availabilityZone_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    for (int i = 0; i < regionInfos_.size(); i++) {
      output.writeMessage(312194170, regionInfos_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 462920692, address_);
    }
    for (int i = 0; i < availableFeatures_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 496344307, availableFeatures_.getRaw(i));
    }
    for (int i = 0; i < availableLinkTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 509504298, availableLinkTypes_.getRaw(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 533303309, facilityProvider_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 536567094, peeringdbFacilityId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3053931, city_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(83983214, supportsPzs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              87269125, facilityProviderFacilityId_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(133442996, continent_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(158459920, availabilityZone_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    for (int i = 0; i < regionInfos_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(312194170, regionInfos_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(462920692, address_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < availableFeatures_.size(); i++) {
        dataSize += computeStringSizeNoTag(availableFeatures_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAvailableFeaturesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < availableLinkTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(availableLinkTypes_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAvailableLinkTypesList().size();
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(533303309, facilityProvider_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(536567094, peeringdbFacilityId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectLocation)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectLocation other =
        (com.google.cloud.compute.v1.InterconnectLocation) obj;

    if (hasAddress() != other.hasAddress()) return false;
    if (hasAddress()) {
      if (!getAddress().equals(other.getAddress())) return false;
    }
    if (hasAvailabilityZone() != other.hasAvailabilityZone()) return false;
    if (hasAvailabilityZone()) {
      if (!getAvailabilityZone().equals(other.getAvailabilityZone())) return false;
    }
    if (!getAvailableFeaturesList().equals(other.getAvailableFeaturesList())) return false;
    if (!getAvailableLinkTypesList().equals(other.getAvailableLinkTypesList())) return false;
    if (hasCity() != other.hasCity()) return false;
    if (hasCity()) {
      if (!getCity().equals(other.getCity())) return false;
    }
    if (hasContinent() != other.hasContinent()) return false;
    if (hasContinent()) {
      if (!getContinent().equals(other.getContinent())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFacilityProvider() != other.hasFacilityProvider()) return false;
    if (hasFacilityProvider()) {
      if (!getFacilityProvider().equals(other.getFacilityProvider())) return false;
    }
    if (hasFacilityProviderFacilityId() != other.hasFacilityProviderFacilityId()) return false;
    if (hasFacilityProviderFacilityId()) {
      if (!getFacilityProviderFacilityId().equals(other.getFacilityProviderFacilityId()))
        return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPeeringdbFacilityId() != other.hasPeeringdbFacilityId()) return false;
    if (hasPeeringdbFacilityId()) {
      if (!getPeeringdbFacilityId().equals(other.getPeeringdbFacilityId())) return false;
    }
    if (!getRegionInfosList().equals(other.getRegionInfosList())) return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasSupportsPzs() != other.hasSupportsPzs()) return false;
    if (hasSupportsPzs()) {
      if (getSupportsPzs() != other.getSupportsPzs()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAddress()) {
      hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getAddress().hashCode();
    }
    if (hasAvailabilityZone()) {
      hash = (37 * hash) + AVAILABILITY_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getAvailabilityZone().hashCode();
    }
    if (getAvailableFeaturesCount() > 0) {
      hash = (37 * hash) + AVAILABLE_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableFeaturesList().hashCode();
    }
    if (getAvailableLinkTypesCount() > 0) {
      hash = (37 * hash) + AVAILABLE_LINK_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableLinkTypesList().hashCode();
    }
    if (hasCity()) {
      hash = (37 * hash) + CITY_FIELD_NUMBER;
      hash = (53 * hash) + getCity().hashCode();
    }
    if (hasContinent()) {
      hash = (37 * hash) + CONTINENT_FIELD_NUMBER;
      hash = (53 * hash) + getContinent().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFacilityProvider()) {
      hash = (37 * hash) + FACILITY_PROVIDER_FIELD_NUMBER;
      hash = (53 * hash) + getFacilityProvider().hashCode();
    }
    if (hasFacilityProviderFacilityId()) {
      hash = (37 * hash) + FACILITY_PROVIDER_FACILITY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getFacilityProviderFacilityId().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPeeringdbFacilityId()) {
      hash = (37 * hash) + PEERINGDB_FACILITY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPeeringdbFacilityId().hashCode();
    }
    if (getRegionInfosCount() > 0) {
      hash = (37 * hash) + REGION_INFOS_FIELD_NUMBER;
      hash = (53 * hash) + getRegionInfosList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasSupportsPzs()) {
      hash = (37 * hash) + SUPPORTS_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSupportsPzs());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectLocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InterconnectLocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an Interconnect Attachment (VLAN) Location resource. You can use this resource to find location details about an Interconnect attachment (VLAN). For more information about interconnect attachments, read Creating VLAN Attachments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectLocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectLocation)
      com.google.cloud.compute.v1.InterconnectLocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectLocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectLocation.class,
              com.google.cloud.compute.v1.InterconnectLocation.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectLocation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      address_ = "";
      availabilityZone_ = "";
      availableFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
      availableLinkTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      city_ = "";
      continent_ = "";
      creationTimestamp_ = "";
      description_ = "";
      facilityProvider_ = "";
      facilityProviderFacilityId_ = "";
      id_ = 0L;
      kind_ = "";
      name_ = "";
      peeringdbFacilityId_ = "";
      if (regionInfosBuilder_ == null) {
        regionInfos_ = java.util.Collections.emptyList();
      } else {
        regionInfos_ = null;
        regionInfosBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      selfLink_ = "";
      status_ = "";
      supportsPzs_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectLocation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectLocation getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectLocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectLocation build() {
      com.google.cloud.compute.v1.InterconnectLocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectLocation buildPartial() {
      com.google.cloud.compute.v1.InterconnectLocation result =
          new com.google.cloud.compute.v1.InterconnectLocation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InterconnectLocation result) {
      if (regionInfosBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          regionInfos_ = java.util.Collections.unmodifiableList(regionInfos_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.regionInfos_ = regionInfos_;
      } else {
        result.regionInfos_ = regionInfosBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectLocation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.address_ = address_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.availabilityZone_ = availabilityZone_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        availableFeatures_.makeImmutable();
        result.availableFeatures_ = availableFeatures_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        availableLinkTypes_.makeImmutable();
        result.availableLinkTypes_ = availableLinkTypes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.city_ = city_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.continent_ = continent_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.facilityProvider_ = facilityProvider_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.facilityProviderFacilityId_ = facilityProviderFacilityId_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.peeringdbFacilityId_ = peeringdbFacilityId_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.supportsPzs_ = supportsPzs_;
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectLocation) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectLocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectLocation other) {
      if (other == com.google.cloud.compute.v1.InterconnectLocation.getDefaultInstance())
        return this;
      if (other.hasAddress()) {
        address_ = other.address_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAvailabilityZone()) {
        availabilityZone_ = other.availabilityZone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.availableFeatures_.isEmpty()) {
        if (availableFeatures_.isEmpty()) {
          availableFeatures_ = other.availableFeatures_;
          bitField0_ |= 0x00000004;
        } else {
          ensureAvailableFeaturesIsMutable();
          availableFeatures_.addAll(other.availableFeatures_);
        }
        onChanged();
      }
      if (!other.availableLinkTypes_.isEmpty()) {
        if (availableLinkTypes_.isEmpty()) {
          availableLinkTypes_ = other.availableLinkTypes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureAvailableLinkTypesIsMutable();
          availableLinkTypes_.addAll(other.availableLinkTypes_);
        }
        onChanged();
      }
      if (other.hasCity()) {
        city_ = other.city_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasContinent()) {
        continent_ = other.continent_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasFacilityProvider()) {
        facilityProvider_ = other.facilityProvider_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasFacilityProviderFacilityId()) {
        facilityProviderFacilityId_ = other.facilityProviderFacilityId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasPeeringdbFacilityId()) {
        peeringdbFacilityId_ = other.peeringdbFacilityId_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (regionInfosBuilder_ == null) {
        if (!other.regionInfos_.isEmpty()) {
          if (regionInfos_.isEmpty()) {
            regionInfos_ = other.regionInfos_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureRegionInfosIsMutable();
            regionInfos_.addAll(other.regionInfos_);
          }
          onChanged();
        }
      } else {
        if (!other.regionInfos_.isEmpty()) {
          if (regionInfosBuilder_.isEmpty()) {
            regionInfosBuilder_.dispose();
            regionInfosBuilder_ = null;
            regionInfos_ = other.regionInfos_;
            bitField0_ = (bitField0_ & ~0x00004000);
            regionInfosBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRegionInfosFieldBuilder()
                    : null;
          } else {
            regionInfosBuilder_.addAllMessages(other.regionInfos_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasSupportsPzs()) {
        setSupportsPzs(other.getSupportsPzs());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case 26840
            case 24431450:
              {
                city_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 24431450
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 244202930
            case 671865712:
              {
                supportsPzs_ = input.readBool();
                bitField0_ |= 0x00020000;
                break;
              } // case 671865712
            case 698153002:
              {
                facilityProviderFacilityId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 698153002
            case 1067543970:
              {
                continent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1067543970
            case 1267679362:
              {
                availabilityZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1267679362
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1450082194
            case -1797413934:
              {
                com.google.cloud.compute.v1.InterconnectLocationRegionInfo m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectLocationRegionInfo.parser(),
                        extensionRegistry);
                if (regionInfosBuilder_ == null) {
                  ensureRegionInfosIsMutable();
                  regionInfos_.add(m);
                } else {
                  regionInfosBuilder_.addMessage(m);
                }
                break;
              } // case -1797413934
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -645248918
            case -591601758:
              {
                address_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -591601758
            case -324212838:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAvailableFeaturesIsMutable();
                availableFeatures_.add(s);
                break;
              } // case -324212838
            case -218932910:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAvailableLinkTypesIsMutable();
                availableLinkTypes_.add(s);
                break;
              } // case -218932910
            case -28540822:
              {
                facilityProvider_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -28540822
            case -2430542:
              {
                peeringdbFacilityId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -2430542
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object address_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return Whether the address field is set.
     */
    public boolean hasAddress() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return The address.
     */
    public java.lang.String getAddress() {
      java.lang.Object ref = address_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        address_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return The bytes for address.
     */
    public com.google.protobuf.ByteString getAddressBytes() {
      java.lang.Object ref = address_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        address_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @param value The address to set.
     * @return This builder for chaining.
     */
    public Builder setAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      address_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddress() {
      address_ = getDefaultInstance().getAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @param value The bytes for address to set.
     * @return This builder for chaining.
     */
    public Builder setAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      address_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object availabilityZone_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
     * </pre>
     *
     * <code>optional string availability_zone = 158459920;</code>
     *
     * @return Whether the availabilityZone field is set.
     */
    public boolean hasAvailabilityZone() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
     * </pre>
     *
     * <code>optional string availability_zone = 158459920;</code>
     *
     * @return The availabilityZone.
     */
    public java.lang.String getAvailabilityZone() {
      java.lang.Object ref = availabilityZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        availabilityZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
     * </pre>
     *
     * <code>optional string availability_zone = 158459920;</code>
     *
     * @return The bytes for availabilityZone.
     */
    public com.google.protobuf.ByteString getAvailabilityZoneBytes() {
      java.lang.Object ref = availabilityZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        availabilityZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
     * </pre>
     *
     * <code>optional string availability_zone = 158459920;</code>
     *
     * @param value The availabilityZone to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      availabilityZone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
     * </pre>
     *
     * <code>optional string availability_zone = 158459920;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailabilityZone() {
      availabilityZone_ = getDefaultInstance().getAvailabilityZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Availability zone for this InterconnectLocation. Within a metropolitan area (metro), maintenance will not be simultaneously scheduled in more than one availability zone. Example: "zone1" or "zone2".
     * </pre>
     *
     * <code>optional string availability_zone = 158459920;</code>
     *
     * @param value The bytes for availabilityZone to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      availabilityZone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList availableFeatures_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAvailableFeaturesIsMutable() {
      if (!availableFeatures_.isModifiable()) {
        availableFeatures_ = new com.google.protobuf.LazyStringArrayList(availableFeatures_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @return A list containing the availableFeatures.
     */
    public com.google.protobuf.ProtocolStringList getAvailableFeaturesList() {
      availableFeatures_.makeImmutable();
      return availableFeatures_;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @return The count of availableFeatures.
     */
    public int getAvailableFeaturesCount() {
      return availableFeatures_.size();
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @param index The index of the element to return.
     * @return The availableFeatures at the given index.
     */
    public java.lang.String getAvailableFeatures(int index) {
      return availableFeatures_.get(index);
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the availableFeatures at the given index.
     */
    public com.google.protobuf.ByteString getAvailableFeaturesBytes(int index) {
      return availableFeatures_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @param index The index to set the value at.
     * @param value The availableFeatures to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableFeatures(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableFeaturesIsMutable();
      availableFeatures_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @param value The availableFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addAvailableFeatures(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableFeaturesIsMutable();
      availableFeatures_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @param values The availableFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addAllAvailableFeatures(java.lang.Iterable<java.lang.String> values) {
      ensureAvailableFeaturesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableFeatures_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableFeatures() {
      availableFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of features available at this InterconnectLocation, which can take one of the following values: - MACSEC
     * Check the AvailableFeatures enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_features = 496344307;</code>
     *
     * @param value The bytes of the availableFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addAvailableFeaturesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAvailableFeaturesIsMutable();
      availableFeatures_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList availableLinkTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAvailableLinkTypesIsMutable() {
      if (!availableLinkTypes_.isModifiable()) {
        availableLinkTypes_ = new com.google.protobuf.LazyStringArrayList(availableLinkTypes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @return A list containing the availableLinkTypes.
     */
    public com.google.protobuf.ProtocolStringList getAvailableLinkTypesList() {
      availableLinkTypes_.makeImmutable();
      return availableLinkTypes_;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @return The count of availableLinkTypes.
     */
    public int getAvailableLinkTypesCount() {
      return availableLinkTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @param index The index of the element to return.
     * @return The availableLinkTypes at the given index.
     */
    public java.lang.String getAvailableLinkTypes(int index) {
      return availableLinkTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the availableLinkTypes at the given index.
     */
    public com.google.protobuf.ByteString getAvailableLinkTypesBytes(int index) {
      return availableLinkTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @param index The index to set the value at.
     * @param value The availableLinkTypes to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableLinkTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableLinkTypesIsMutable();
      availableLinkTypes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @param value The availableLinkTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAvailableLinkTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAvailableLinkTypesIsMutable();
      availableLinkTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @param values The availableLinkTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAvailableLinkTypes(java.lang.Iterable<java.lang.String> values) {
      ensureAvailableLinkTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableLinkTypes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableLinkTypes() {
      availableLinkTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] List of link types available at this InterconnectLocation, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR - LINK_TYPE_ETHERNET_100G_LR
     * Check the AvailableLinkTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string available_link_types = 509504298;</code>
     *
     * @param value The bytes of the availableLinkTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAvailableLinkTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAvailableLinkTypesIsMutable();
      availableLinkTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object city_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return Whether the city field is set.
     */
    public boolean hasCity() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return The city.
     */
    public java.lang.String getCity() {
      java.lang.Object ref = city_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        city_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return The bytes for city.
     */
    public com.google.protobuf.ByteString getCityBytes() {
      java.lang.Object ref = city_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        city_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @param value The city to set.
     * @return This builder for chaining.
     */
    public Builder setCity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      city_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCity() {
      city_ = getDefaultInstance().getCity();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @param value The bytes for city to set.
     * @return This builder for chaining.
     */
    public Builder setCityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      city_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object continent_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return Whether the continent field is set.
     */
    public boolean hasContinent() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return The continent.
     */
    public java.lang.String getContinent() {
      java.lang.Object ref = continent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        continent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return The bytes for continent.
     */
    public com.google.protobuf.ByteString getContinentBytes() {
      java.lang.Object ref = continent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        continent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @param value The continent to set.
     * @return This builder for chaining.
     */
    public Builder setContinent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      continent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContinent() {
      continent_ = getDefaultInstance().getContinent();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @param value The bytes for continent to set.
     * @return This builder for chaining.
     */
    public Builder setContinentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      continent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object facilityProvider_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return Whether the facilityProvider field is set.
     */
    public boolean hasFacilityProvider() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return The facilityProvider.
     */
    public java.lang.String getFacilityProvider() {
      java.lang.Object ref = facilityProvider_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        facilityProvider_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return The bytes for facilityProvider.
     */
    public com.google.protobuf.ByteString getFacilityProviderBytes() {
      java.lang.Object ref = facilityProvider_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        facilityProvider_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @param value The facilityProvider to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProvider(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      facilityProvider_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacilityProvider() {
      facilityProvider_ = getDefaultInstance().getFacilityProvider();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @param value The bytes for facilityProvider to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProviderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      facilityProvider_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object facilityProviderFacilityId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return Whether the facilityProviderFacilityId field is set.
     */
    public boolean hasFacilityProviderFacilityId() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return The facilityProviderFacilityId.
     */
    public java.lang.String getFacilityProviderFacilityId() {
      java.lang.Object ref = facilityProviderFacilityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        facilityProviderFacilityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return The bytes for facilityProviderFacilityId.
     */
    public com.google.protobuf.ByteString getFacilityProviderFacilityIdBytes() {
      java.lang.Object ref = facilityProviderFacilityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        facilityProviderFacilityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @param value The facilityProviderFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProviderFacilityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      facilityProviderFacilityId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacilityProviderFacilityId() {
      facilityProviderFacilityId_ = getDefaultInstance().getFacilityProviderFacilityId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @param value The bytes for facilityProviderFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProviderFacilityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      facilityProviderFacilityId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000400);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectLocation for interconnect locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object peeringdbFacilityId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return Whether the peeringdbFacilityId field is set.
     */
    public boolean hasPeeringdbFacilityId() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return The peeringdbFacilityId.
     */
    public java.lang.String getPeeringdbFacilityId() {
      java.lang.Object ref = peeringdbFacilityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peeringdbFacilityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return The bytes for peeringdbFacilityId.
     */
    public com.google.protobuf.ByteString getPeeringdbFacilityIdBytes() {
      java.lang.Object ref = peeringdbFacilityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peeringdbFacilityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @param value The peeringdbFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setPeeringdbFacilityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peeringdbFacilityId_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeeringdbFacilityId() {
      peeringdbFacilityId_ = getDefaultInstance().getPeeringdbFacilityId();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @param value The bytes for peeringdbFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setPeeringdbFacilityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peeringdbFacilityId_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.InterconnectLocationRegionInfo>
        regionInfos_ = java.util.Collections.emptyList();

    private void ensureRegionInfosIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        regionInfos_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InterconnectLocationRegionInfo>(
                regionInfos_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectLocationRegionInfo,
            com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder,
            com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder>
        regionInfosBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectLocationRegionInfo>
        getRegionInfosList() {
      if (regionInfosBuilder_ == null) {
        return java.util.Collections.unmodifiableList(regionInfos_);
      } else {
        return regionInfosBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public int getRegionInfosCount() {
      if (regionInfosBuilder_ == null) {
        return regionInfos_.size();
      } else {
        return regionInfosBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectLocationRegionInfo getRegionInfos(int index) {
      if (regionInfosBuilder_ == null) {
        return regionInfos_.get(index);
      } else {
        return regionInfosBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder setRegionInfos(
        int index, com.google.cloud.compute.v1.InterconnectLocationRegionInfo value) {
      if (regionInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRegionInfosIsMutable();
        regionInfos_.set(index, value);
        onChanged();
      } else {
        regionInfosBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder setRegionInfos(
        int index,
        com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder builderForValue) {
      if (regionInfosBuilder_ == null) {
        ensureRegionInfosIsMutable();
        regionInfos_.set(index, builderForValue.build());
        onChanged();
      } else {
        regionInfosBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder addRegionInfos(
        com.google.cloud.compute.v1.InterconnectLocationRegionInfo value) {
      if (regionInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRegionInfosIsMutable();
        regionInfos_.add(value);
        onChanged();
      } else {
        regionInfosBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder addRegionInfos(
        int index, com.google.cloud.compute.v1.InterconnectLocationRegionInfo value) {
      if (regionInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRegionInfosIsMutable();
        regionInfos_.add(index, value);
        onChanged();
      } else {
        regionInfosBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder addRegionInfos(
        com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder builderForValue) {
      if (regionInfosBuilder_ == null) {
        ensureRegionInfosIsMutable();
        regionInfos_.add(builderForValue.build());
        onChanged();
      } else {
        regionInfosBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder addRegionInfos(
        int index,
        com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder builderForValue) {
      if (regionInfosBuilder_ == null) {
        ensureRegionInfosIsMutable();
        regionInfos_.add(index, builderForValue.build());
        onChanged();
      } else {
        regionInfosBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder addAllRegionInfos(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InterconnectLocationRegionInfo>
            values) {
      if (regionInfosBuilder_ == null) {
        ensureRegionInfosIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, regionInfos_);
        onChanged();
      } else {
        regionInfosBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder clearRegionInfos() {
      if (regionInfosBuilder_ == null) {
        regionInfos_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        regionInfosBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public Builder removeRegionInfos(int index) {
      if (regionInfosBuilder_ == null) {
        ensureRegionInfosIsMutable();
        regionInfos_.remove(index);
        onChanged();
      } else {
        regionInfosBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder getRegionInfosBuilder(
        int index) {
      return getRegionInfosFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder
        getRegionInfosOrBuilder(int index) {
      if (regionInfosBuilder_ == null) {
        return regionInfos_.get(index);
      } else {
        return regionInfosBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder>
        getRegionInfosOrBuilderList() {
      if (regionInfosBuilder_ != null) {
        return regionInfosBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(regionInfos_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder
        addRegionInfosBuilder() {
      return getRegionInfosFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InterconnectLocationRegionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder addRegionInfosBuilder(
        int index) {
      return getRegionInfosFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InterconnectLocationRegionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe parameters pertaining to the relation between this InterconnectLocation and various Google Cloud regions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectLocationRegionInfo region_infos = 312194170;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder>
        getRegionInfosBuilderList() {
      return getRegionInfosFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectLocationRegionInfo,
            com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder,
            com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder>
        getRegionInfosFieldBuilder() {
      if (regionInfosBuilder_ == null) {
        regionInfosBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectLocationRegionInfo,
                com.google.cloud.compute.v1.InterconnectLocationRegionInfo.Builder,
                com.google.cloud.compute.v1.InterconnectLocationRegionInfoOrBuilder>(
                regionInfos_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        regionInfos_ = null;
      }
      return regionInfosBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private boolean supportsPzs_;
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool supports_pzs = 83983214;</code>
     *
     * @return Whether the supportsPzs field is set.
     */
    @java.lang.Override
    public boolean hasSupportsPzs() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool supports_pzs = 83983214;</code>
     *
     * @return The supportsPzs.
     */
    @java.lang.Override
    public boolean getSupportsPzs() {
      return supportsPzs_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool supports_pzs = 83983214;</code>
     *
     * @param value The supportsPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSupportsPzs(boolean value) {

      supportsPzs_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool supports_pzs = 83983214;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportsPzs() {
      bitField0_ = (bitField0_ & ~0x00020000);
      supportsPzs_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectLocation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectLocation)
  private static final com.google.cloud.compute.v1.InterconnectLocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectLocation();
  }

  public static com.google.cloud.compute.v1.InterconnectLocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectLocation> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectLocation>() {
        @java.lang.Override
        public InterconnectLocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectLocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectLocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectLocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
