/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Opaque filter criteria used by load balancers to restrict routing configuration to a limited set of load balancing proxies. Proxies and sidecars involved in load balancing would typically present metadata to the load balancers that need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. An example for using metadataFilters would be: if load balancing involves Envoys, they receive routing configuration when values in metadataFilters match values supplied in of their XDS requests to loadbalancers.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.MetadataFilter}
 */
public final class MetadataFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.MetadataFilter)
    MetadataFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MetadataFilter.newBuilder() to construct.
  private MetadataFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MetadataFilter() {
    filterLabels_ = java.util.Collections.emptyList();
    filterMatchCriteria_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MetadataFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_MetadataFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_MetadataFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.MetadataFilter.class,
            com.google.cloud.compute.v1.MetadataFilter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.MetadataFilter.FilterMatchCriteria}
   */
  public enum FilterMatchCriteria implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_FILTER_MATCH_CRITERIA = 0;</code>
     */
    UNDEFINED_FILTER_MATCH_CRITERIA(0),
    /**
     *
     *
     * <pre>
     * Specifies that all filterLabels must match for the metadataFilter to be considered a match.
     * </pre>
     *
     * <code>MATCH_ALL = 180663271;</code>
     */
    MATCH_ALL(180663271),
    /**
     *
     *
     * <pre>
     * Specifies that any filterLabel must match for the metadataFilter to be considered a match.
     * </pre>
     *
     * <code>MATCH_ANY = 180663346;</code>
     */
    MATCH_ANY(180663346),
    /**
     *
     *
     * <pre>
     * Indicates that the match criteria was not set. A metadataFilter must never be created with this value.
     * </pre>
     *
     * <code>NOT_SET = 163646646;</code>
     */
    NOT_SET(163646646),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_FILTER_MATCH_CRITERIA = 0;</code>
     */
    public static final int UNDEFINED_FILTER_MATCH_CRITERIA_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Specifies that all filterLabels must match for the metadataFilter to be considered a match.
     * </pre>
     *
     * <code>MATCH_ALL = 180663271;</code>
     */
    public static final int MATCH_ALL_VALUE = 180663271;
    /**
     *
     *
     * <pre>
     * Specifies that any filterLabel must match for the metadataFilter to be considered a match.
     * </pre>
     *
     * <code>MATCH_ANY = 180663346;</code>
     */
    public static final int MATCH_ANY_VALUE = 180663346;
    /**
     *
     *
     * <pre>
     * Indicates that the match criteria was not set. A metadataFilter must never be created with this value.
     * </pre>
     *
     * <code>NOT_SET = 163646646;</code>
     */
    public static final int NOT_SET_VALUE = 163646646;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterMatchCriteria valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FilterMatchCriteria forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_FILTER_MATCH_CRITERIA;
        case 180663271:
          return MATCH_ALL;
        case 180663346:
          return MATCH_ANY;
        case 163646646:
          return NOT_SET;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FilterMatchCriteria>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FilterMatchCriteria>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FilterMatchCriteria>() {
              public FilterMatchCriteria findValueByNumber(int number) {
                return FilterMatchCriteria.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.MetadataFilter.getDescriptor().getEnumTypes().get(0);
    }

    private static final FilterMatchCriteria[] VALUES = values();

    public static FilterMatchCriteria valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FilterMatchCriteria(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.MetadataFilter.FilterMatchCriteria)
  }

  private int bitField0_;
  public static final int FILTER_LABELS_FIELD_NUMBER = 307903142;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.MetadataFilterLabelMatch> filterLabels_;
  /**
   *
   *
   * <pre>
   * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.MetadataFilterLabelMatch>
      getFilterLabelsList() {
    return filterLabels_;
  }
  /**
   *
   *
   * <pre>
   * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder>
      getFilterLabelsOrBuilderList() {
    return filterLabels_;
  }
  /**
   *
   *
   * <pre>
   * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
   * </code>
   */
  @java.lang.Override
  public int getFilterLabelsCount() {
    return filterLabels_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilterLabelMatch getFilterLabels(int index) {
    return filterLabels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder getFilterLabelsOrBuilder(
      int index) {
    return filterLabels_.get(index);
  }

  public static final int FILTER_MATCH_CRITERIA_FIELD_NUMBER = 239970368;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filterMatchCriteria_ = "";
  /**
   *
   *
   * <pre>
   * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
   * Check the FilterMatchCriteria enum for the list of possible values.
   * </pre>
   *
   * <code>optional string filter_match_criteria = 239970368;</code>
   *
   * @return Whether the filterMatchCriteria field is set.
   */
  @java.lang.Override
  public boolean hasFilterMatchCriteria() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
   * Check the FilterMatchCriteria enum for the list of possible values.
   * </pre>
   *
   * <code>optional string filter_match_criteria = 239970368;</code>
   *
   * @return The filterMatchCriteria.
   */
  @java.lang.Override
  public java.lang.String getFilterMatchCriteria() {
    java.lang.Object ref = filterMatchCriteria_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filterMatchCriteria_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
   * Check the FilterMatchCriteria enum for the list of possible values.
   * </pre>
   *
   * <code>optional string filter_match_criteria = 239970368;</code>
   *
   * @return The bytes for filterMatchCriteria.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterMatchCriteriaBytes() {
    java.lang.Object ref = filterMatchCriteria_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filterMatchCriteria_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 239970368, filterMatchCriteria_);
    }
    for (int i = 0; i < filterLabels_.size(); i++) {
      output.writeMessage(307903142, filterLabels_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(239970368, filterMatchCriteria_);
    }
    for (int i = 0; i < filterLabels_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(307903142, filterLabels_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.MetadataFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.MetadataFilter other =
        (com.google.cloud.compute.v1.MetadataFilter) obj;

    if (!getFilterLabelsList().equals(other.getFilterLabelsList())) return false;
    if (hasFilterMatchCriteria() != other.hasFilterMatchCriteria()) return false;
    if (hasFilterMatchCriteria()) {
      if (!getFilterMatchCriteria().equals(other.getFilterMatchCriteria())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFilterLabelsCount() > 0) {
      hash = (37 * hash) + FILTER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getFilterLabelsList().hashCode();
    }
    if (hasFilterMatchCriteria()) {
      hash = (37 * hash) + FILTER_MATCH_CRITERIA_FIELD_NUMBER;
      hash = (53 * hash) + getFilterMatchCriteria().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MetadataFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.MetadataFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by load balancers to restrict routing configuration to a limited set of load balancing proxies. Proxies and sidecars involved in load balancing would typically present metadata to the load balancers that need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. An example for using metadataFilters would be: if load balancing involves Envoys, they receive routing configuration when values in metadataFilters match values supplied in of their XDS requests to loadbalancers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.MetadataFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.MetadataFilter)
      com.google.cloud.compute.v1.MetadataFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MetadataFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MetadataFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.MetadataFilter.class,
              com.google.cloud.compute.v1.MetadataFilter.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.MetadataFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (filterLabelsBuilder_ == null) {
        filterLabels_ = java.util.Collections.emptyList();
      } else {
        filterLabels_ = null;
        filterLabelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      filterMatchCriteria_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MetadataFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MetadataFilter getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.MetadataFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MetadataFilter build() {
      com.google.cloud.compute.v1.MetadataFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MetadataFilter buildPartial() {
      com.google.cloud.compute.v1.MetadataFilter result =
          new com.google.cloud.compute.v1.MetadataFilter(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.MetadataFilter result) {
      if (filterLabelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          filterLabels_ = java.util.Collections.unmodifiableList(filterLabels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.filterLabels_ = filterLabels_;
      } else {
        result.filterLabels_ = filterLabelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.MetadataFilter result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filterMatchCriteria_ = filterMatchCriteria_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.MetadataFilter) {
        return mergeFrom((com.google.cloud.compute.v1.MetadataFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.MetadataFilter other) {
      if (other == com.google.cloud.compute.v1.MetadataFilter.getDefaultInstance()) return this;
      if (filterLabelsBuilder_ == null) {
        if (!other.filterLabels_.isEmpty()) {
          if (filterLabels_.isEmpty()) {
            filterLabels_ = other.filterLabels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFilterLabelsIsMutable();
            filterLabels_.addAll(other.filterLabels_);
          }
          onChanged();
        }
      } else {
        if (!other.filterLabels_.isEmpty()) {
          if (filterLabelsBuilder_.isEmpty()) {
            filterLabelsBuilder_.dispose();
            filterLabelsBuilder_ = null;
            filterLabels_ = other.filterLabels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            filterLabelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFilterLabelsFieldBuilder()
                    : null;
          } else {
            filterLabelsBuilder_.addAllMessages(other.filterLabels_);
          }
        }
      }
      if (other.hasFilterMatchCriteria()) {
        filterMatchCriteria_ = other.filterMatchCriteria_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1919762946:
              {
                filterMatchCriteria_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1919762946
            case -1831742158:
              {
                com.google.cloud.compute.v1.MetadataFilterLabelMatch m =
                    input.readMessage(
                        com.google.cloud.compute.v1.MetadataFilterLabelMatch.parser(),
                        extensionRegistry);
                if (filterLabelsBuilder_ == null) {
                  ensureFilterLabelsIsMutable();
                  filterLabels_.add(m);
                } else {
                  filterLabelsBuilder_.addMessage(m);
                }
                break;
              } // case -1831742158
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.MetadataFilterLabelMatch> filterLabels_ =
        java.util.Collections.emptyList();

    private void ensureFilterLabelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        filterLabels_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.MetadataFilterLabelMatch>(
                filterLabels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.MetadataFilterLabelMatch,
            com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder,
            com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder>
        filterLabelsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.MetadataFilterLabelMatch>
        getFilterLabelsList() {
      if (filterLabelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(filterLabels_);
      } else {
        return filterLabelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public int getFilterLabelsCount() {
      if (filterLabelsBuilder_ == null) {
        return filterLabels_.size();
      } else {
        return filterLabelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public com.google.cloud.compute.v1.MetadataFilterLabelMatch getFilterLabels(int index) {
      if (filterLabelsBuilder_ == null) {
        return filterLabels_.get(index);
      } else {
        return filterLabelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder setFilterLabels(
        int index, com.google.cloud.compute.v1.MetadataFilterLabelMatch value) {
      if (filterLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilterLabelsIsMutable();
        filterLabels_.set(index, value);
        onChanged();
      } else {
        filterLabelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder setFilterLabels(
        int index, com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder builderForValue) {
      if (filterLabelsBuilder_ == null) {
        ensureFilterLabelsIsMutable();
        filterLabels_.set(index, builderForValue.build());
        onChanged();
      } else {
        filterLabelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder addFilterLabels(com.google.cloud.compute.v1.MetadataFilterLabelMatch value) {
      if (filterLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilterLabelsIsMutable();
        filterLabels_.add(value);
        onChanged();
      } else {
        filterLabelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder addFilterLabels(
        int index, com.google.cloud.compute.v1.MetadataFilterLabelMatch value) {
      if (filterLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilterLabelsIsMutable();
        filterLabels_.add(index, value);
        onChanged();
      } else {
        filterLabelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder addFilterLabels(
        com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder builderForValue) {
      if (filterLabelsBuilder_ == null) {
        ensureFilterLabelsIsMutable();
        filterLabels_.add(builderForValue.build());
        onChanged();
      } else {
        filterLabelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder addFilterLabels(
        int index, com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder builderForValue) {
      if (filterLabelsBuilder_ == null) {
        ensureFilterLabelsIsMutable();
        filterLabels_.add(index, builderForValue.build());
        onChanged();
      } else {
        filterLabelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder addAllFilterLabels(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.MetadataFilterLabelMatch> values) {
      if (filterLabelsBuilder_ == null) {
        ensureFilterLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filterLabels_);
        onChanged();
      } else {
        filterLabelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder clearFilterLabels() {
      if (filterLabelsBuilder_ == null) {
        filterLabels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        filterLabelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public Builder removeFilterLabels(int index) {
      if (filterLabelsBuilder_ == null) {
        ensureFilterLabelsIsMutable();
        filterLabels_.remove(index);
        onChanged();
      } else {
        filterLabelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder getFilterLabelsBuilder(
        int index) {
      return getFilterLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder getFilterLabelsOrBuilder(
        int index) {
      if (filterLabelsBuilder_ == null) {
        return filterLabels_.get(index);
      } else {
        return filterLabelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder>
        getFilterLabelsOrBuilderList() {
      if (filterLabelsBuilder_ != null) {
        return filterLabelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(filterLabels_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder addFilterLabelsBuilder() {
      return getFilterLabelsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.MetadataFilterLabelMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder addFilterLabelsBuilder(
        int index) {
      return getFilterLabelsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.MetadataFilterLabelMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilterLabelMatch filter_labels = 307903142;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder>
        getFilterLabelsBuilderList() {
      return getFilterLabelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.MetadataFilterLabelMatch,
            com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder,
            com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder>
        getFilterLabelsFieldBuilder() {
      if (filterLabelsBuilder_ == null) {
        filterLabelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.MetadataFilterLabelMatch,
                com.google.cloud.compute.v1.MetadataFilterLabelMatch.Builder,
                com.google.cloud.compute.v1.MetadataFilterLabelMatchOrBuilder>(
                filterLabels_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        filterLabels_ = null;
      }
      return filterLabelsBuilder_;
    }

    private java.lang.Object filterMatchCriteria_ = "";
    /**
     *
     *
     * <pre>
     * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
     * Check the FilterMatchCriteria enum for the list of possible values.
     * </pre>
     *
     * <code>optional string filter_match_criteria = 239970368;</code>
     *
     * @return Whether the filterMatchCriteria field is set.
     */
    public boolean hasFilterMatchCriteria() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
     * Check the FilterMatchCriteria enum for the list of possible values.
     * </pre>
     *
     * <code>optional string filter_match_criteria = 239970368;</code>
     *
     * @return The filterMatchCriteria.
     */
    public java.lang.String getFilterMatchCriteria() {
      java.lang.Object ref = filterMatchCriteria_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filterMatchCriteria_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
     * Check the FilterMatchCriteria enum for the list of possible values.
     * </pre>
     *
     * <code>optional string filter_match_criteria = 239970368;</code>
     *
     * @return The bytes for filterMatchCriteria.
     */
    public com.google.protobuf.ByteString getFilterMatchCriteriaBytes() {
      java.lang.Object ref = filterMatchCriteria_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filterMatchCriteria_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
     * Check the FilterMatchCriteria enum for the list of possible values.
     * </pre>
     *
     * <code>optional string filter_match_criteria = 239970368;</code>
     *
     * @param value The filterMatchCriteria to set.
     * @return This builder for chaining.
     */
    public Builder setFilterMatchCriteria(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterMatchCriteria_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
     * Check the FilterMatchCriteria enum for the list of possible values.
     * </pre>
     *
     * <code>optional string filter_match_criteria = 239970368;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilterMatchCriteria() {
      filterMatchCriteria_ = getDefaultInstance().getFilterMatchCriteria();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
     * Check the FilterMatchCriteria enum for the list of possible values.
     * </pre>
     *
     * <code>optional string filter_match_criteria = 239970368;</code>
     *
     * @param value The bytes for filterMatchCriteria to set.
     * @return This builder for chaining.
     */
    public Builder setFilterMatchCriteriaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterMatchCriteria_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.MetadataFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.MetadataFilter)
  private static final com.google.cloud.compute.v1.MetadataFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.MetadataFilter();
  }

  public static com.google.cloud.compute.v1.MetadataFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MetadataFilter> PARSER =
      new com.google.protobuf.AbstractParser<MetadataFilter>() {
        @java.lang.Override
        public MetadataFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MetadataFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MetadataFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
