/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

public interface MetadataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.Metadata)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  boolean hasFingerprint();
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  java.lang.String getFingerprint();
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  com.google.protobuf.ByteString getFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Items items = 100526016;</code>
   */
  java.util.List<com.google.cloud.compute.v1.Items> getItemsList();
  /**
   *
   *
   * <pre>
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Items items = 100526016;</code>
   */
  com.google.cloud.compute.v1.Items getItems(int index);
  /**
   *
   *
   * <pre>
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Items items = 100526016;</code>
   */
  int getItemsCount();
  /**
   *
   *
   * <pre>
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Items items = 100526016;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.ItemsOrBuilder> getItemsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Items items = 100526016;</code>
   */
  com.google.cloud.compute.v1.ItemsOrBuilder getItemsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();
}
